/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tomcat.util.http.fileupload.InvalidFileNameException;

public final class Streams {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static String checkFileName(String string) {
        if (string != null && string.indexOf(0) != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            block3: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\u0000': {
                        stringBuilder.append("\\0");
                        continue block3;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            throw new InvalidFileNameException(string, "Invalid file name: " + String.valueOf(stringBuilder));
        }
        return string;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return Streams.copy(inputStream, outputStream, bl, new byte[8192]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, boolean bl, byte[] byArray) throws IOException {
        try (OutputStream outputStream2 = outputStream;){
            long l;
            block16: {
                InputStream inputStream2 = inputStream;
                try {
                    int n;
                    long l2 = 0L;
                    while ((n = inputStream2.read(byArray)) != -1) {
                        if (n <= 0) continue;
                        l2 += (long)n;
                        if (outputStream2 == null) continue;
                        outputStream2.write(byArray, 0, n);
                    }
                    if (outputStream2 != null) {
                        if (bl) {
                            outputStream2.close();
                        } else {
                            outputStream2.flush();
                        }
                    }
                    inputStream2.close();
                    l = l2;
                    if (inputStream2 == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream2.close();
            }
            return l;
        }
    }

    private Streams() {
    }
}

