// content/browser/process_internals/process_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/process_internals/process_internals.mojom-features.h"  // IWYU pragma: export
#include "content/browser/process_internals/process_internals.mojom-shared.h"  // IWYU pragma: export
#include "content/browser/process_internals/process_internals.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace mojom {

class ProcessInternalsHandlerProxy;

template <typename ImplRefTraits>
class ProcessInternalsHandlerStub;

class ProcessInternalsHandlerRequestValidator;
class ProcessInternalsHandlerResponseValidator;


class ProcessInternalsHandler
    : public ProcessInternalsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProcessInternalsHandlerInterfaceBase;
  using Proxy_ = ProcessInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProcessInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ProcessInternalsHandlerRequestValidator;
  using ResponseValidator_ = ProcessInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetProcessCountInfoMinVersion = 0,
    kGetIsolationModeMinVersion = 0,
    kGetProcessPerSiteModeMinVersion = 0,
    kGetUserTriggeredIsolatedOriginsMinVersion = 0,
    kGetWebTriggeredIsolatedOriginsMinVersion = 0,
    kGetGloballyIsolatedOriginsMinVersion = 0,
    kGetAllWebContentsInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetProcessCountInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsolationMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProcessPerSiteMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserTriggeredIsolatedOrigins_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWebTriggeredIsolatedOrigins_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetGloballyIsolatedOrigins_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllWebContentsInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProcessInternalsHandler() = default;


  using GetProcessCountInfoCallback = base::OnceCallback<void(ProcessCountInfoPtr)>;
  
  virtual void GetProcessCountInfo(GetProcessCountInfoCallback callback) = 0;


  using GetIsolationModeCallback = base::OnceCallback<void(const std::string&)>;
  
  virtual void GetIsolationMode(GetIsolationModeCallback callback) = 0;


  using GetProcessPerSiteModeCallback = base::OnceCallback<void(const std::string&)>;
  
  virtual void GetProcessPerSiteMode(GetProcessPerSiteModeCallback callback) = 0;


  using GetUserTriggeredIsolatedOriginsCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void GetUserTriggeredIsolatedOrigins(GetUserTriggeredIsolatedOriginsCallback callback) = 0;


  using GetWebTriggeredIsolatedOriginsCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  
  virtual void GetWebTriggeredIsolatedOrigins(GetWebTriggeredIsolatedOriginsCallback callback) = 0;


  using GetGloballyIsolatedOriginsCallback = base::OnceCallback<void(std::vector<IsolatedOriginInfoPtr>)>;
  
  virtual void GetGloballyIsolatedOrigins(GetGloballyIsolatedOriginsCallback callback) = 0;


  using GetAllWebContentsInfoCallback = base::OnceCallback<void(std::vector<WebContentsInfoPtr>)>;
  
  virtual void GetAllWebContentsInfo(GetAllWebContentsInfoCallback callback) = 0;
};



class  ProcessInternalsHandlerProxy
    : public ProcessInternalsHandler {
 public:
  using InterfaceType = ProcessInternalsHandler;

  explicit ProcessInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetProcessCountInfo(GetProcessCountInfoCallback callback) final;
  
  void GetIsolationMode(GetIsolationModeCallback callback) final;
  
  void GetProcessPerSiteMode(GetProcessPerSiteModeCallback callback) final;
  
  void GetUserTriggeredIsolatedOrigins(GetUserTriggeredIsolatedOriginsCallback callback) final;
  
  void GetWebTriggeredIsolatedOrigins(GetWebTriggeredIsolatedOriginsCallback callback) final;
  
  void GetGloballyIsolatedOrigins(GetGloballyIsolatedOriginsCallback callback) final;
  
  void GetAllWebContentsInfo(GetAllWebContentsInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProcessInternalsHandlerStubDispatch {
 public:
  static bool Accept(ProcessInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProcessInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProcessInternalsHandler>>
class ProcessInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProcessInternalsHandlerStub() = default;
  ~ProcessInternalsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProcessInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProcessInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ProcessCountInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProcessCountInfo, T>::value>;
  using DataView = ProcessCountInfoDataView;
  using Data_ = internal::ProcessCountInfo_Data;

  template <typename... Args>
  static ProcessCountInfoPtr New(Args&&... args) {
    return ProcessCountInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProcessCountInfoPtr From(const U& u) {
    return mojo::TypeConverter<ProcessCountInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProcessCountInfo>::Convert(*this);
  }


  ProcessCountInfo();

  ProcessCountInfo(
      uint64_t renderer_process_limit,
      uint64_t renderer_process_count_total,
      uint64_t renderer_process_count_for_limit);


  ~ProcessCountInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProcessCountInfoPtr>
  ProcessCountInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProcessCountInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProcessCountInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProcessCountInfo_UnserializedMessageContext<
            UserType, ProcessCountInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProcessCountInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProcessCountInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProcessCountInfo_UnserializedMessageContext<
            UserType, ProcessCountInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProcessCountInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t renderer_process_limit;
  
  uint64_t renderer_process_count_total;
  
  uint64_t renderer_process_count_for_limit;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProcessCountInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  IsolatedOriginInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IsolatedOriginInfo, T>::value>;
  using DataView = IsolatedOriginInfoDataView;
  using Data_ = internal::IsolatedOriginInfo_Data;

  template <typename... Args>
  static IsolatedOriginInfoPtr New(Args&&... args) {
    return IsolatedOriginInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IsolatedOriginInfoPtr From(const U& u) {
    return mojo::TypeConverter<IsolatedOriginInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IsolatedOriginInfo>::Convert(*this);
  }


  IsolatedOriginInfo();

  IsolatedOriginInfo(
      const std::string& origin,
      const std::string& source);


  ~IsolatedOriginInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IsolatedOriginInfoPtr>
  IsolatedOriginInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IsolatedOriginInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IsolatedOriginInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IsolatedOriginInfo_UnserializedMessageContext<
            UserType, IsolatedOriginInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IsolatedOriginInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IsolatedOriginInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IsolatedOriginInfo_UnserializedMessageContext<
            UserType, IsolatedOriginInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IsolatedOriginInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string origin;
  
  std::string source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  SiteInstanceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteInstanceInfo, T>::value>;
  using DataView = SiteInstanceInfoDataView;
  using Data_ = internal::SiteInstanceInfo_Data;

  template <typename... Args>
  static SiteInstanceInfoPtr New(Args&&... args) {
    return SiteInstanceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteInstanceInfoPtr From(const U& u) {
    return mojo::TypeConverter<SiteInstanceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteInstanceInfo>::Convert(*this);
  }


  SiteInstanceInfo();

  SiteInstanceInfo(
      int32_t id,
      int32_t site_instance_group_id,
      int32_t browsing_instance_id,
      bool locked,
      const std::optional<::GURL>& site_url,
      const std::optional<::GURL>& process_lock_url,
      bool requires_origin_keyed_process,
      bool is_sandbox_for_iframes,
      bool is_guest,
      bool is_pdf,
      const std::optional<std::string>& storage_partition);


  ~SiteInstanceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteInstanceInfoPtr>
  SiteInstanceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteInstanceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteInstanceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteInstanceInfo_UnserializedMessageContext<
            UserType, SiteInstanceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteInstanceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteInstanceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteInstanceInfo_UnserializedMessageContext<
            UserType, SiteInstanceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteInstanceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  int32_t site_instance_group_id;
  
  int32_t browsing_instance_id;
  
  bool locked;
  
  std::optional<::GURL> site_url;
  
  std::optional<::GURL> process_lock_url;
  
  bool requires_origin_keyed_process;
  
  bool is_sandbox_for_iframes;
  
  bool is_guest;
  
  bool is_pdf;
  
  std::optional<std::string> storage_partition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameInfo, T>::value>;
  using DataView = FrameInfoDataView;
  using Data_ = internal::FrameInfo_Data;
  using Type = FrameInfo_Type;

  template <typename... Args>
  static FrameInfoPtr New(Args&&... args) {
    return FrameInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameInfoPtr From(const U& u) {
    return mojo::TypeConverter<FrameInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameInfo>::Convert(*this);
  }


  FrameInfo();

  FrameInfo(
      int32_t routing_id,
      int32_t agent_scheduling_group_id,
      int32_t process_id,
      SiteInstanceInfoPtr site_instance,
      const std::optional<::GURL>& last_committed_url,
      std::vector<FrameInfoPtr> subframes,
      FrameInfo::Type type);

FrameInfo(const FrameInfo&) = delete;
FrameInfo& operator=(const FrameInfo&) = delete;

  ~FrameInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameInfoPtr>
  FrameInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameInfo_UnserializedMessageContext<
            UserType, FrameInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameInfo_UnserializedMessageContext<
            UserType, FrameInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t routing_id;
  
  int32_t agent_scheduling_group_id;
  
  int32_t process_id;
  
  SiteInstanceInfoPtr site_instance;
  
  std::optional<::GURL> last_committed_url;
  
  std::vector<FrameInfoPtr> subframes;
  
  FrameInfo::Type type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebContentsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebContentsInfo, T>::value>;
  using DataView = WebContentsInfoDataView;
  using Data_ = internal::WebContentsInfo_Data;

  template <typename... Args>
  static WebContentsInfoPtr New(Args&&... args) {
    return WebContentsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebContentsInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebContentsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebContentsInfo>::Convert(*this);
  }


  WebContentsInfo();

  WebContentsInfo(
      const std::string& title,
      FrameInfoPtr root_frame,
      std::vector<FrameInfoPtr> bfcached_root_frames,
      std::vector<FrameInfoPtr> prerender_root_frames);

WebContentsInfo(const WebContentsInfo&) = delete;
WebContentsInfo& operator=(const WebContentsInfo&) = delete;

  ~WebContentsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebContentsInfoPtr>
  WebContentsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebContentsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebContentsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebContentsInfo_UnserializedMessageContext<
            UserType, WebContentsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebContentsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebContentsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebContentsInfo_UnserializedMessageContext<
            UserType, WebContentsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebContentsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  FrameInfoPtr root_frame;
  
  std::vector<FrameInfoPtr> bfcached_root_frames;
  
  std::vector<FrameInfoPtr> prerender_root_frames;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebContentsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ProcessCountInfoPtr ProcessCountInfo::Clone() const {
  return New(
      mojo::Clone(renderer_process_limit),
      mojo::Clone(renderer_process_count_total),
      mojo::Clone(renderer_process_count_for_limit)
  );
}

template <typename T, ProcessCountInfo::EnableIfSame<T>*>
bool ProcessCountInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->renderer_process_limit, other_struct.renderer_process_limit))
    return false;
  if (!mojo::Equals(this->renderer_process_count_total, other_struct.renderer_process_count_total))
    return false;
  if (!mojo::Equals(this->renderer_process_count_for_limit, other_struct.renderer_process_count_for_limit))
    return false;
  return true;
}

template <typename T, ProcessCountInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.renderer_process_limit < rhs.renderer_process_limit)
    return true;
  if (rhs.renderer_process_limit < lhs.renderer_process_limit)
    return false;
  if (lhs.renderer_process_count_total < rhs.renderer_process_count_total)
    return true;
  if (rhs.renderer_process_count_total < lhs.renderer_process_count_total)
    return false;
  if (lhs.renderer_process_count_for_limit < rhs.renderer_process_count_for_limit)
    return true;
  if (rhs.renderer_process_count_for_limit < lhs.renderer_process_count_for_limit)
    return false;
  return false;
}
template <typename StructPtrType>
SiteInstanceInfoPtr SiteInstanceInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(site_instance_group_id),
      mojo::Clone(browsing_instance_id),
      mojo::Clone(locked),
      mojo::Clone(site_url),
      mojo::Clone(process_lock_url),
      mojo::Clone(requires_origin_keyed_process),
      mojo::Clone(is_sandbox_for_iframes),
      mojo::Clone(is_guest),
      mojo::Clone(is_pdf),
      mojo::Clone(storage_partition)
  );
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>*>
bool SiteInstanceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->site_instance_group_id, other_struct.site_instance_group_id))
    return false;
  if (!mojo::Equals(this->browsing_instance_id, other_struct.browsing_instance_id))
    return false;
  if (!mojo::Equals(this->locked, other_struct.locked))
    return false;
  if (!mojo::Equals(this->site_url, other_struct.site_url))
    return false;
  if (!mojo::Equals(this->process_lock_url, other_struct.process_lock_url))
    return false;
  if (!mojo::Equals(this->requires_origin_keyed_process, other_struct.requires_origin_keyed_process))
    return false;
  if (!mojo::Equals(this->is_sandbox_for_iframes, other_struct.is_sandbox_for_iframes))
    return false;
  if (!mojo::Equals(this->is_guest, other_struct.is_guest))
    return false;
  if (!mojo::Equals(this->is_pdf, other_struct.is_pdf))
    return false;
  if (!mojo::Equals(this->storage_partition, other_struct.storage_partition))
    return false;
  return true;
}

template <typename T, SiteInstanceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.site_instance_group_id < rhs.site_instance_group_id)
    return true;
  if (rhs.site_instance_group_id < lhs.site_instance_group_id)
    return false;
  if (lhs.browsing_instance_id < rhs.browsing_instance_id)
    return true;
  if (rhs.browsing_instance_id < lhs.browsing_instance_id)
    return false;
  if (lhs.locked < rhs.locked)
    return true;
  if (rhs.locked < lhs.locked)
    return false;
  if (lhs.site_url < rhs.site_url)
    return true;
  if (rhs.site_url < lhs.site_url)
    return false;
  if (lhs.process_lock_url < rhs.process_lock_url)
    return true;
  if (rhs.process_lock_url < lhs.process_lock_url)
    return false;
  if (lhs.requires_origin_keyed_process < rhs.requires_origin_keyed_process)
    return true;
  if (rhs.requires_origin_keyed_process < lhs.requires_origin_keyed_process)
    return false;
  if (lhs.is_sandbox_for_iframes < rhs.is_sandbox_for_iframes)
    return true;
  if (rhs.is_sandbox_for_iframes < lhs.is_sandbox_for_iframes)
    return false;
  if (lhs.is_guest < rhs.is_guest)
    return true;
  if (rhs.is_guest < lhs.is_guest)
    return false;
  if (lhs.is_pdf < rhs.is_pdf)
    return true;
  if (rhs.is_pdf < lhs.is_pdf)
    return false;
  if (lhs.storage_partition < rhs.storage_partition)
    return true;
  if (rhs.storage_partition < lhs.storage_partition)
    return false;
  return false;
}
template <typename StructPtrType>
FrameInfoPtr FrameInfo::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(agent_scheduling_group_id),
      mojo::Clone(process_id),
      mojo::Clone(site_instance),
      mojo::Clone(last_committed_url),
      mojo::Clone(subframes),
      mojo::Clone(type)
  );
}

template <typename T, FrameInfo::EnableIfSame<T>*>
bool FrameInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->agent_scheduling_group_id, other_struct.agent_scheduling_group_id))
    return false;
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->site_instance, other_struct.site_instance))
    return false;
  if (!mojo::Equals(this->last_committed_url, other_struct.last_committed_url))
    return false;
  if (!mojo::Equals(this->subframes, other_struct.subframes))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, FrameInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.routing_id < rhs.routing_id)
    return true;
  if (rhs.routing_id < lhs.routing_id)
    return false;
  if (lhs.agent_scheduling_group_id < rhs.agent_scheduling_group_id)
    return true;
  if (rhs.agent_scheduling_group_id < lhs.agent_scheduling_group_id)
    return false;
  if (lhs.process_id < rhs.process_id)
    return true;
  if (rhs.process_id < lhs.process_id)
    return false;
  if (lhs.site_instance < rhs.site_instance)
    return true;
  if (rhs.site_instance < lhs.site_instance)
    return false;
  if (lhs.last_committed_url < rhs.last_committed_url)
    return true;
  if (rhs.last_committed_url < lhs.last_committed_url)
    return false;
  if (lhs.subframes < rhs.subframes)
    return true;
  if (rhs.subframes < lhs.subframes)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
WebContentsInfoPtr WebContentsInfo::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(root_frame),
      mojo::Clone(bfcached_root_frames),
      mojo::Clone(prerender_root_frames)
  );
}

template <typename T, WebContentsInfo::EnableIfSame<T>*>
bool WebContentsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->root_frame, other_struct.root_frame))
    return false;
  if (!mojo::Equals(this->bfcached_root_frames, other_struct.bfcached_root_frames))
    return false;
  if (!mojo::Equals(this->prerender_root_frames, other_struct.prerender_root_frames))
    return false;
  return true;
}

template <typename T, WebContentsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.root_frame < rhs.root_frame)
    return true;
  if (rhs.root_frame < lhs.root_frame)
    return false;
  if (lhs.bfcached_root_frames < rhs.bfcached_root_frames)
    return true;
  if (rhs.bfcached_root_frames < lhs.bfcached_root_frames)
    return false;
  if (lhs.prerender_root_frames < rhs.prerender_root_frames)
    return true;
  if (rhs.prerender_root_frames < lhs.prerender_root_frames)
    return false;
  return false;
}
template <typename StructPtrType>
IsolatedOriginInfoPtr IsolatedOriginInfo::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(source)
  );
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>*>
bool IsolatedOriginInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, IsolatedOriginInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  return false;
}


}  // mojom

namespace mojo {


template <>
struct  StructTraits<::mojom::ProcessCountInfo::DataView,
                                         ::mojom::ProcessCountInfoPtr> {
  static bool IsNull(const ::mojom::ProcessCountInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::ProcessCountInfoPtr* output) { output->reset(); }

  static decltype(::mojom::ProcessCountInfo::renderer_process_limit) renderer_process_limit(
      const ::mojom::ProcessCountInfoPtr& input) {
    return input->renderer_process_limit;
  }

  static decltype(::mojom::ProcessCountInfo::renderer_process_count_total) renderer_process_count_total(
      const ::mojom::ProcessCountInfoPtr& input) {
    return input->renderer_process_count_total;
  }

  static decltype(::mojom::ProcessCountInfo::renderer_process_count_for_limit) renderer_process_count_for_limit(
      const ::mojom::ProcessCountInfoPtr& input) {
    return input->renderer_process_count_for_limit;
  }

  static bool Read(::mojom::ProcessCountInfo::DataView input, ::mojom::ProcessCountInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::SiteInstanceInfo::DataView,
                                         ::mojom::SiteInstanceInfoPtr> {
  static bool IsNull(const ::mojom::SiteInstanceInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::SiteInstanceInfoPtr* output) { output->reset(); }

  static decltype(::mojom::SiteInstanceInfo::id) id(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->id;
  }

  static decltype(::mojom::SiteInstanceInfo::site_instance_group_id) site_instance_group_id(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->site_instance_group_id;
  }

  static decltype(::mojom::SiteInstanceInfo::browsing_instance_id) browsing_instance_id(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->browsing_instance_id;
  }

  static decltype(::mojom::SiteInstanceInfo::locked) locked(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->locked;
  }

  static const decltype(::mojom::SiteInstanceInfo::site_url)& site_url(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->site_url;
  }

  static const decltype(::mojom::SiteInstanceInfo::process_lock_url)& process_lock_url(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->process_lock_url;
  }

  static decltype(::mojom::SiteInstanceInfo::requires_origin_keyed_process) requires_origin_keyed_process(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->requires_origin_keyed_process;
  }

  static decltype(::mojom::SiteInstanceInfo::is_sandbox_for_iframes) is_sandbox_for_iframes(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->is_sandbox_for_iframes;
  }

  static decltype(::mojom::SiteInstanceInfo::is_guest) is_guest(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->is_guest;
  }

  static decltype(::mojom::SiteInstanceInfo::is_pdf) is_pdf(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->is_pdf;
  }

  static const decltype(::mojom::SiteInstanceInfo::storage_partition)& storage_partition(
      const ::mojom::SiteInstanceInfoPtr& input) {
    return input->storage_partition;
  }

  static bool Read(::mojom::SiteInstanceInfo::DataView input, ::mojom::SiteInstanceInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::FrameInfo::DataView,
                                         ::mojom::FrameInfoPtr> {
  static bool IsNull(const ::mojom::FrameInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::FrameInfoPtr* output) { output->reset(); }

  static decltype(::mojom::FrameInfo::routing_id) routing_id(
      const ::mojom::FrameInfoPtr& input) {
    return input->routing_id;
  }

  static decltype(::mojom::FrameInfo::agent_scheduling_group_id) agent_scheduling_group_id(
      const ::mojom::FrameInfoPtr& input) {
    return input->agent_scheduling_group_id;
  }

  static decltype(::mojom::FrameInfo::process_id) process_id(
      const ::mojom::FrameInfoPtr& input) {
    return input->process_id;
  }

  static const decltype(::mojom::FrameInfo::site_instance)& site_instance(
      const ::mojom::FrameInfoPtr& input) {
    return input->site_instance;
  }

  static const decltype(::mojom::FrameInfo::last_committed_url)& last_committed_url(
      const ::mojom::FrameInfoPtr& input) {
    return input->last_committed_url;
  }

  static const decltype(::mojom::FrameInfo::subframes)& subframes(
      const ::mojom::FrameInfoPtr& input) {
    return input->subframes;
  }

  static decltype(::mojom::FrameInfo::type) type(
      const ::mojom::FrameInfoPtr& input) {
    return input->type;
  }

  static bool Read(::mojom::FrameInfo::DataView input, ::mojom::FrameInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::WebContentsInfo::DataView,
                                         ::mojom::WebContentsInfoPtr> {
  static bool IsNull(const ::mojom::WebContentsInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::WebContentsInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::WebContentsInfo::title)& title(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->title;
  }

  static const decltype(::mojom::WebContentsInfo::root_frame)& root_frame(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->root_frame;
  }

  static const decltype(::mojom::WebContentsInfo::bfcached_root_frames)& bfcached_root_frames(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->bfcached_root_frames;
  }

  static const decltype(::mojom::WebContentsInfo::prerender_root_frames)& prerender_root_frames(
      const ::mojom::WebContentsInfoPtr& input) {
    return input->prerender_root_frames;
  }

  static bool Read(::mojom::WebContentsInfo::DataView input, ::mojom::WebContentsInfoPtr* output);
};


template <>
struct  StructTraits<::mojom::IsolatedOriginInfo::DataView,
                                         ::mojom::IsolatedOriginInfoPtr> {
  static bool IsNull(const ::mojom::IsolatedOriginInfoPtr& input) { return !input; }
  static void SetToNull(::mojom::IsolatedOriginInfoPtr* output) { output->reset(); }

  static const decltype(::mojom::IsolatedOriginInfo::origin)& origin(
      const ::mojom::IsolatedOriginInfoPtr& input) {
    return input->origin;
  }

  static const decltype(::mojom::IsolatedOriginInfo::source)& source(
      const ::mojom::IsolatedOriginInfoPtr& input) {
    return input->source;
  }

  static bool Read(::mojom::IsolatedOriginInfo::DataView input, ::mojom::IsolatedOriginInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_PROCESS_INTERNALS_PROCESS_INTERNALS_MOJOM_H_