// content/services/auction_worklet/public/mojom/real_time_reporting.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_REAL_TIME_REPORTING_MOJOM_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_REAL_TIME_REPORTING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-features.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-shared.h"  // IWYU pragma: export
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "content/common/content_export.h"




namespace auction_worklet::mojom {





class CONTENT_EXPORT RealTimeReportingContribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RealTimeReportingContribution, T>::value>;
  using DataView = RealTimeReportingContributionDataView;
  using Data_ = internal::RealTimeReportingContribution_Data;

  template <typename... Args>
  static RealTimeReportingContributionPtr New(Args&&... args) {
    return RealTimeReportingContributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RealTimeReportingContributionPtr From(const U& u) {
    return mojo::TypeConverter<RealTimeReportingContributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RealTimeReportingContribution>::Convert(*this);
  }


  RealTimeReportingContribution();

  RealTimeReportingContribution(
      int32_t bucket,
      double priority_weight,
      std::optional<int32_t> latency_threshold);


  ~RealTimeReportingContribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RealTimeReportingContributionPtr>
  RealTimeReportingContributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RealTimeReportingContribution::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RealTimeReportingContribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RealTimeReportingContribution_UnserializedMessageContext<
            UserType, RealTimeReportingContribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RealTimeReportingContribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RealTimeReportingContribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RealTimeReportingContribution_UnserializedMessageContext<
            UserType, RealTimeReportingContribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RealTimeReportingContribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t bucket;
  
  double priority_weight;
  
  std::optional<int32_t> latency_threshold;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RealTimeReportingContribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
RealTimeReportingContributionPtr RealTimeReportingContribution::Clone() const {
  return New(
      mojo::Clone(bucket),
      mojo::Clone(priority_weight),
      mojo::Clone(latency_threshold)
  );
}

template <typename T, RealTimeReportingContribution::EnableIfSame<T>*>
bool RealTimeReportingContribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bucket, other_struct.bucket))
    return false;
  if (!mojo::Equals(this->priority_weight, other_struct.priority_weight))
    return false;
  if (!mojo::Equals(this->latency_threshold, other_struct.latency_threshold))
    return false;
  return true;
}

template <typename T, RealTimeReportingContribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bucket < rhs.bucket)
    return true;
  if (rhs.bucket < lhs.bucket)
    return false;
  if (lhs.priority_weight < rhs.priority_weight)
    return true;
  if (rhs.priority_weight < lhs.priority_weight)
    return false;
  if (lhs.latency_threshold < rhs.latency_threshold)
    return true;
  if (rhs.latency_threshold < lhs.latency_threshold)
    return false;
  return false;
}


}  // auction_worklet::mojom

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::auction_worklet::mojom::RealTimeReportingContribution::DataView,
                                         ::auction_worklet::mojom::RealTimeReportingContributionPtr> {
  static bool IsNull(const ::auction_worklet::mojom::RealTimeReportingContributionPtr& input) { return !input; }
  static void SetToNull(::auction_worklet::mojom::RealTimeReportingContributionPtr* output) { output->reset(); }

  static decltype(::auction_worklet::mojom::RealTimeReportingContribution::bucket) bucket(
      const ::auction_worklet::mojom::RealTimeReportingContributionPtr& input) {
    return input->bucket;
  }

  static decltype(::auction_worklet::mojom::RealTimeReportingContribution::priority_weight) priority_weight(
      const ::auction_worklet::mojom::RealTimeReportingContributionPtr& input) {
    return input->priority_weight;
  }

  static decltype(::auction_worklet::mojom::RealTimeReportingContribution::latency_threshold) latency_threshold(
      const ::auction_worklet::mojom::RealTimeReportingContributionPtr& input) {
    return input->latency_threshold;
  }

  static bool Read(::auction_worklet::mojom::RealTimeReportingContribution::DataView input, ::auction_worklet::mojom::RealTimeReportingContributionPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_REAL_TIME_REPORTING_MOJOM_H_