// media/mojo/mojom/cdm_document_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_document_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_document_service.mojom-params-data.h"
#include "media/mojo/mojom/cdm_document_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_document_service.mojom-import-headers.h"
#include "media/mojo/mojom/cdm_document_service.mojom-test-utils.h"


namespace media::mojom {
const char CdmDocumentService::Name_[] = "media.mojom.CdmDocumentService";

CdmDocumentService::IPCStableHashFunction CdmDocumentService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmDocumentService>(message.name())) {
    case messages::CdmDocumentService::kChallengePlatform: {
      return &CdmDocumentService::ChallengePlatform_Sym::IPCStableHash;
    }
    case messages::CdmDocumentService::kGetStorageId: {
      return &CdmDocumentService::GetStorageId_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmDocumentService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmDocumentService>(message.name())) {
      case messages::CdmDocumentService::kChallengePlatform:
            return "Receive media::mojom::CdmDocumentService::ChallengePlatform";
      case messages::CdmDocumentService::kGetStorageId:
            return "Receive media::mojom::CdmDocumentService::GetStorageId";
    }
  } else {
    switch (static_cast<messages::CdmDocumentService>(message.name())) {
      case messages::CdmDocumentService::kChallengePlatform:
            return "Receive reply media::mojom::CdmDocumentService::ChallengePlatform";
      case messages::CdmDocumentService::kGetStorageId:
            return "Receive reply media::mojom::CdmDocumentService::GetStorageId";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmDocumentService::ChallengePlatform_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::CdmDocumentService::ChallengePlatform");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmDocumentService::GetStorageId_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::CdmDocumentService::GetStorageId");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CdmDocumentService_ChallengePlatform_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmDocumentService_ChallengePlatform_ForwardToCallback(
      CdmDocumentService::ChallengePlatformCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmDocumentService_ChallengePlatform_ForwardToCallback(const CdmDocumentService_ChallengePlatform_ForwardToCallback&) = delete;
  CdmDocumentService_ChallengePlatform_ForwardToCallback& operator=(const CdmDocumentService_ChallengePlatform_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmDocumentService::ChallengePlatformCallback callback_;
};

class CdmDocumentService_GetStorageId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmDocumentService_GetStorageId_ForwardToCallback(
      CdmDocumentService::GetStorageIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmDocumentService_GetStorageId_ForwardToCallback(const CdmDocumentService_GetStorageId_ForwardToCallback&) = delete;
  CdmDocumentService_GetStorageId_ForwardToCallback& operator=(const CdmDocumentService_GetStorageId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmDocumentService::GetStorageIdCallback callback_;
};

CdmDocumentServiceProxy::CdmDocumentServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmDocumentServiceProxy::ChallengePlatform(
    const std::string& in_service_id, const std::string& in_challenge, ChallengePlatformCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmDocumentService::ChallengePlatform", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_id"), in_service_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("challenge"), in_challenge,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmDocumentService::kChallengePlatform), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmDocumentService_ChallengePlatform_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_id)::BaseType> service_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_service_id, service_id_fragment);
  params->service_id.Set(
      service_id_fragment.is_null() ? nullptr : service_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->service_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null service_id in CdmDocumentService.ChallengePlatform request");
  mojo::internal::MessageFragment<
      typename decltype(params->challenge)::BaseType> challenge_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_challenge, challenge_fragment);
  params->challenge.Set(
      challenge_fragment.is_null() ? nullptr : challenge_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->challenge.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null challenge in CdmDocumentService.ChallengePlatform request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmDocumentService::Name_);
  message.set_method_name("ChallengePlatform");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmDocumentService_ChallengePlatform_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmDocumentServiceProxy::GetStorageId(
    uint32_t in_version, GetStorageIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmDocumentService::GetStorageId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmDocumentService::kGetStorageId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmDocumentService_GetStorageId_Params_Data> params(
          message);
  params.Allocate();
  params->version = in_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmDocumentService::Name_);
  message.set_method_name("GetStorageId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmDocumentService_GetStorageId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CdmDocumentService_ChallengePlatform_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmDocumentService::ChallengePlatformCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmDocumentService_ChallengePlatform_ProxyToResponder> proxy(
        new CdmDocumentService_ChallengePlatform_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmDocumentService_ChallengePlatform_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmDocumentService_ChallengePlatform_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmDocumentService_ChallengePlatform_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmDocumentService::ChallengePlatformCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::string& in_signed_data, const std::string& in_signed_data_signature, const std::string& in_platform_key_certificate);
};

bool CdmDocumentService_ChallengePlatform_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmDocumentService_ChallengePlatform_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmDocumentService_ChallengePlatform_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CdmDocumentService.0
  bool success = true;
  bool p_success{};
  std::string p_signed_data{};
  std::string p_signed_data_signature{};
  std::string p_platform_key_certificate{};
  CdmDocumentService_ChallengePlatform_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadSignedData(&p_signed_data))
    success = false;
  if (success && !input_data_view.ReadSignedDataSignature(&p_signed_data_signature))
    success = false;
  if (success && !input_data_view.ReadPlatformKeyCertificate(&p_platform_key_certificate))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmDocumentService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_signed_data), 
std::move(p_signed_data_signature), 
std::move(p_platform_key_certificate));
  return true;
}

void CdmDocumentService_ChallengePlatform_ProxyToResponder::Run(
    bool in_success, const std::string& in_signed_data, const std::string& in_signed_data_signature, const std::string& in_platform_key_certificate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmDocumentService::ChallengePlatform", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signed_data"), in_signed_data,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signed_data_signature"), in_signed_data_signature,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_key_certificate"), in_platform_key_certificate,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmDocumentService::kChallengePlatform), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmDocumentService_ChallengePlatform_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->signed_data)::BaseType> signed_data_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_signed_data, signed_data_fragment);
  params->signed_data.Set(
      signed_data_fragment.is_null() ? nullptr : signed_data_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signed_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signed_data in ");
  mojo::internal::MessageFragment<
      typename decltype(params->signed_data_signature)::BaseType> signed_data_signature_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_signed_data_signature, signed_data_signature_fragment);
  params->signed_data_signature.Set(
      signed_data_signature_fragment.is_null() ? nullptr : signed_data_signature_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signed_data_signature.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signed_data_signature in ");
  mojo::internal::MessageFragment<
      typename decltype(params->platform_key_certificate)::BaseType> platform_key_certificate_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_platform_key_certificate, platform_key_certificate_fragment);
  params->platform_key_certificate.Set(
      platform_key_certificate_fragment.is_null() ? nullptr : platform_key_certificate_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->platform_key_certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null platform_key_certificate in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmDocumentService::Name_);
  message.set_method_name("ChallengePlatform");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmDocumentService_GetStorageId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmDocumentService::GetStorageIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmDocumentService_GetStorageId_ProxyToResponder> proxy(
        new CdmDocumentService_GetStorageId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmDocumentService_GetStorageId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmDocumentService_GetStorageId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmDocumentService_GetStorageId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmDocumentService::GetStorageIdCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_version, const std::vector<uint8_t>& in_storage_id);
};

bool CdmDocumentService_GetStorageId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmDocumentService_GetStorageId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmDocumentService_GetStorageId_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for CdmDocumentService.1
  bool success = true;
  uint32_t p_version{};
  std::vector<uint8_t> p_storage_id{};
  CdmDocumentService_GetStorageId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_version = input_data_view.version();
  if (success && !input_data_view.ReadStorageId(&p_storage_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmDocumentService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_version), 
std::move(p_storage_id));
  return true;
}

void CdmDocumentService_GetStorageId_ProxyToResponder::Run(
    uint32_t in_version, const std::vector<uint8_t>& in_storage_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmDocumentService::GetStorageId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_id"), in_storage_id,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmDocumentService::kGetStorageId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmDocumentService_GetStorageId_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->version = in_version;
  mojo::internal::MessageFragment<
      typename decltype(params->storage_id)::BaseType>
      storage_id_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& storage_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_storage_id, storage_id_fragment, &storage_id_validate_params);
  params->storage_id.Set(
      storage_id_fragment.is_null() ? nullptr : storage_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmDocumentService::Name_);
  message.set_method_name("GetStorageId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmDocumentServiceStubDispatch::Accept(
    CdmDocumentService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmDocumentService>(message->header()->name)) {
    case messages::CdmDocumentService::kChallengePlatform: {
      break;
    }
    case messages::CdmDocumentService::kGetStorageId: {
      break;
    }
  }
  return false;
}

// static
bool CdmDocumentServiceStubDispatch::AcceptWithResponder(
    CdmDocumentService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmDocumentService>(message->header()->name)) {
    case messages::CdmDocumentService::kChallengePlatform: {
      internal::CdmDocumentService_ChallengePlatform_Params_Data* params =
          reinterpret_cast<
              internal::CdmDocumentService_ChallengePlatform_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CdmDocumentService.0
      bool success = true;
      std::string p_service_id{};
      std::string p_challenge{};
      CdmDocumentService_ChallengePlatform_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceId(&p_service_id))
        success = false;
      if (success && !input_data_view.ReadChallenge(&p_challenge))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmDocumentService::Name_, 0, false);
        return false;
      }
      CdmDocumentService::ChallengePlatformCallback callback =
          CdmDocumentService_ChallengePlatform_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChallengePlatform(        
        std::move(p_service_id), 
        std::move(p_challenge), std::move(callback));
      return true;
    }
    case messages::CdmDocumentService::kGetStorageId: {
      internal::CdmDocumentService_GetStorageId_Params_Data* params =
          reinterpret_cast<
              internal::CdmDocumentService_GetStorageId_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for CdmDocumentService.1
      bool success = true;
      uint32_t p_version{};
      CdmDocumentService_GetStorageId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_version = input_data_view.version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmDocumentService::Name_, 1, false);
        return false;
      }
      CdmDocumentService::GetStorageIdCallback callback =
          CdmDocumentService_GetStorageId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStorageId(        
        std::move(p_version), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmDocumentServiceValidationInfo[] = {
    {base::to_underlying(messages::CdmDocumentService::kChallengePlatform),
     { &internal::CdmDocumentService_ChallengePlatform_Params_Data::Validate,
      &internal::CdmDocumentService_ChallengePlatform_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CdmDocumentService::kGetStorageId),
     { &internal::CdmDocumentService_GetStorageId_Params_Data::Validate,
      &internal::CdmDocumentService_GetStorageId_ResponseParams_Data::Validate}},
};

bool CdmDocumentServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::CdmDocumentService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmDocumentServiceValidationInfo);
}

bool CdmDocumentServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::CdmDocumentService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCdmDocumentServiceValidationInfo);

}


}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void CdmDocumentServiceInterceptorForTesting::ChallengePlatform(const std::string& service_id, const std::string& challenge, ChallengePlatformCallback callback) {
  GetForwardingInterface()->ChallengePlatform(
    std::move(service_id)
    , 
    std::move(challenge)
    , std::move(callback));
}
void CdmDocumentServiceInterceptorForTesting::GetStorageId(uint32_t version, GetStorageIdCallback callback) {
  GetForwardingInterface()->GetStorageId(
    std::move(version)
    , std::move(callback));
}
CdmDocumentServiceAsyncWaiter::CdmDocumentServiceAsyncWaiter(
    CdmDocumentService* proxy) : proxy_(proxy) {}

CdmDocumentServiceAsyncWaiter::~CdmDocumentServiceAsyncWaiter() = default;

void CdmDocumentServiceAsyncWaiter::ChallengePlatform(
    const std::string& service_id, const std::string& challenge, bool* out_success, std::string* out_signed_data, std::string* out_signed_data_signature, std::string* out_platform_key_certificate) {
  base::RunLoop loop;
  proxy_->ChallengePlatform(
      std::move(service_id),
      std::move(challenge),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::string* out_signed_data
,
             std::string* out_signed_data_signature
,
             std::string* out_platform_key_certificate
,
             bool success,
             const std::string& signed_data,
             const std::string& signed_data_signature,
             const std::string& platform_key_certificate) {*out_success = std::move(success);*out_signed_data = std::move(signed_data);*out_signed_data_signature = std::move(signed_data_signature);*out_platform_key_certificate = std::move(platform_key_certificate);
            loop->Quit();
          },
          &loop,
          out_success,
          out_signed_data,
          out_signed_data_signature,
          out_platform_key_certificate));
  loop.Run();
}



void CdmDocumentServiceAsyncWaiter::GetStorageId(
    uint32_t version, uint32_t* out_version, std::vector<uint8_t>* out_storage_id) {
  base::RunLoop loop;
  proxy_->GetStorageId(
      std::move(version),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_version
,
             std::vector<uint8_t>* out_storage_id
,
             uint32_t version,
             const std::vector<uint8_t>& storage_id) {*out_version = std::move(version);*out_storage_id = std::move(storage_id);
            loop->Quit();
          },
          &loop,
          out_version,
          out_storage_id));
  loop.Run();
}








}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif