// services/device/public/mojom/battery_status.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/battery_status.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/battery_status.mojom-params-data.h"
#include "services/device/public/mojom/battery_status.mojom-shared-message-ids.h"

#include "services/device/public/mojom/battery_status.mojom-import-headers.h"
#include "services/device/public/mojom/battery_status.mojom-test-utils.h"


namespace device::mojom {
BatteryStatus::BatteryStatus()
    : charging(true),
      charging_time(0.0),
      discharging_time(std::numeric_limits<double>::infinity()),
      level(1.0) {}

BatteryStatus::BatteryStatus(
    bool charging_in,
    double charging_time_in,
    double discharging_time_in,
    double level_in)
    : charging(std::move(charging_in)),
      charging_time(std::move(charging_time_in)),
      discharging_time(std::move(discharging_time_in)),
      level(std::move(level_in)) {}

BatteryStatus::~BatteryStatus() = default;
size_t BatteryStatus::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->charging);
  seed = mojo::internal::Hash(seed, this->charging_time);
  seed = mojo::internal::Hash(seed, this->discharging_time);
  seed = mojo::internal::Hash(seed, this->level);
  return seed;
}

void BatteryStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "charging"), this->charging,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "charging_time"), this->charging_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "discharging_time"), this->discharging_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level"), this->level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BatteryStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::BatteryStatus::DataView, ::device::mojom::BatteryStatusPtr>::Read(
    ::device::mojom::BatteryStatus::DataView input,
    ::device::mojom::BatteryStatusPtr* output) {
  bool success = true;
  ::device::mojom::BatteryStatusPtr result(::device::mojom::BatteryStatus::New());
  
      if (success)
        result->charging = input.charging();
      if (success)
        result->charging_time = input.charging_time();
      if (success)
        result->discharging_time = input.discharging_time();
      if (success)
        result->level = input.level();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {




}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif