// ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"







namespace ax::mojom {
class AXLocationChangeDataView;

class AXScrollChangeDataView;

class AXLocationAndScrollUpdatesDataView;



}  // ax::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXLocationChangeDataView> {
  using Data = ::ax::mojom::internal::AXLocationChange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ax::mojom::AXScrollChangeDataView> {
  using Data = ::ax::mojom::internal::AXScrollChange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ax::mojom::AXLocationAndScrollUpdatesDataView> {
  using Data = ::ax::mojom::internal::AXLocationAndScrollUpdates_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXLocationChangeDataView {
 public:
  AXLocationChangeDataView() = default;

  AXLocationChangeDataView(
      internal::AXLocationChange_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  inline void GetNewLocationDataView(
      ::ax::mojom::AXRelativeBoundsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewLocation(UserType* output) {
    
    auto* pointer = data_->new_location.Get();
    return mojo::internal::Deserialize<::ax::mojom::AXRelativeBoundsDataView>(
        pointer, output, message_);
  }
 private:
  internal::AXLocationChange_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AXScrollChangeDataView {
 public:
  AXScrollChangeDataView() = default;

  AXScrollChangeDataView(
      internal::AXScrollChange_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
  int32_t scroll_x() const {
    return data_->scroll_x;
  }
  int32_t scroll_y() const {
    return data_->scroll_y;
  }
 private:
  internal::AXScrollChange_Data* data_ = nullptr;
};


class AXLocationAndScrollUpdatesDataView {
 public:
  AXLocationAndScrollUpdatesDataView() = default;

  AXLocationAndScrollUpdatesDataView(
      internal::AXLocationAndScrollUpdates_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationChangesDataView(
      mojo::ArrayDataView<AXLocationChangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocationChanges(UserType* output) {
    
    auto* pointer = data_->location_changes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXLocationChangeDataView>>(
        pointer, output, message_);
  }
  inline void GetScrollChangesDataView(
      mojo::ArrayDataView<AXScrollChangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollChanges(UserType* output) {
    
    auto* pointer = data_->scroll_changes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXScrollChangeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AXLocationAndScrollUpdates_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXLocationChangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXLocationChangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXLocationChange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    decltype(Traits::new_location(input)) in_new_location = Traits::new_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->new_location)::BaseType> new_location_fragment(
            fragment.message());
    mojo::internal::Serialize<::ax::mojom::AXRelativeBoundsDataView>(
        in_new_location, new_location_fragment);
    fragment->new_location.Set(
        new_location_fragment.is_null() ? nullptr : new_location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->new_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_location in AXLocationChange struct");
  }

  static bool Deserialize(::ax::mojom::internal::AXLocationChange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXLocationChangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXScrollChangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXScrollChangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXScrollChange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->scroll_x = Traits::scroll_x(input);
    fragment->scroll_y = Traits::scroll_y(input);
  }

  static bool Deserialize(::ax::mojom::internal::AXScrollChange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXScrollChangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXLocationAndScrollUpdatesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXLocationAndScrollUpdatesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXLocationAndScrollUpdates_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::location_changes(input)) in_location_changes = Traits::location_changes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location_changes)::BaseType>
        location_changes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& location_changes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXLocationChangeDataView>>(
        in_location_changes, location_changes_fragment, &location_changes_validate_params);
    fragment->location_changes.Set(
        location_changes_fragment.is_null() ? nullptr : location_changes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->location_changes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location_changes in AXLocationAndScrollUpdates struct");
    decltype(Traits::scroll_changes(input)) in_scroll_changes = Traits::scroll_changes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_changes)::BaseType>
        scroll_changes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scroll_changes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::AXScrollChangeDataView>>(
        in_scroll_changes, scroll_changes_fragment, &scroll_changes_validate_params);
    fragment->scroll_changes.Set(
        scroll_changes_fragment.is_null() ? nullptr : scroll_changes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_changes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_changes in AXLocationAndScrollUpdates struct");
  }

  static bool Deserialize(::ax::mojom::internal::AXLocationAndScrollUpdates_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXLocationAndScrollUpdatesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {

inline void AXLocationChangeDataView::GetNewLocationDataView(
    ::ax::mojom::AXRelativeBoundsDataView* output) {
  auto pointer = data_->new_location.Get();
  *output = ::ax::mojom::AXRelativeBoundsDataView(pointer, message_);
}




inline void AXLocationAndScrollUpdatesDataView::GetLocationChangesDataView(
    mojo::ArrayDataView<AXLocationChangeDataView>* output) {
  auto pointer = data_->location_changes.Get();
  *output = mojo::ArrayDataView<AXLocationChangeDataView>(pointer, message_);
}
inline void AXLocationAndScrollUpdatesDataView::GetScrollChangesDataView(
    mojo::ArrayDataView<AXScrollChangeDataView>* output) {
  auto pointer = data_->scroll_changes.Get();
  *output = mojo::ArrayDataView<AXScrollChangeDataView>(pointer, message_);
}



}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_LOCATION_AND_SCROLL_UPDATES_MOJOM_SHARED_H_