// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "StyleProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::StylePropertyPrivate
{
public:
    std::unique_ptr<LayoutProperty> layout;
    std::unique_ptr<TextProperty> text;
    std::unique_ptr<IconProperty> icon;
    std::unique_ptr<BackgroundProperty> background;
    std::unique_ptr<BorderProperty> border;
    std::unique_ptr<OutlineProperty> outline;
    std::unique_ptr<CornersProperty> corners;
    std::unique_ptr<ShadowProperty> shadow;
};

StyleProperty::StyleProperty()
    : d(std::make_unique<StylePropertyPrivate>())
{
}

StyleProperty::StyleProperty(const StyleProperty &other)
    : d(std::make_unique<StylePropertyPrivate>())
{
    d->layout = std::make_unique<LayoutProperty>();
    *(d->layout) = *(other.d->layout);
    d->text = std::make_unique<TextProperty>();
    *(d->text) = *(other.d->text);
    d->icon = std::make_unique<IconProperty>();
    *(d->icon) = *(other.d->icon);
    d->background = std::make_unique<BackgroundProperty>();
    *(d->background) = *(other.d->background);
    d->border = std::make_unique<BorderProperty>();
    *(d->border) = *(other.d->border);
    d->outline = std::make_unique<OutlineProperty>();
    *(d->outline) = *(other.d->outline);
    d->corners = std::make_unique<CornersProperty>();
    *(d->corners) = *(other.d->corners);
    d->shadow = std::make_unique<ShadowProperty>();
    *(d->shadow) = *(other.d->shadow);
}

StyleProperty::StyleProperty(StyleProperty &&other)
    : d(std::move(other.d))
{
}

StyleProperty::~StyleProperty() = default;

StyleProperty &StyleProperty::operator=(const StyleProperty &other)
{
    if (this != &other) {
        *(d->layout) = *(other.d->layout);
        *(d->text) = *(other.d->text);
        *(d->icon) = *(other.d->icon);
        *(d->background) = *(other.d->background);
        *(d->border) = *(other.d->border);
        *(d->outline) = *(other.d->outline);
        *(d->corners) = *(other.d->corners);
        *(d->shadow) = *(other.d->shadow);
    }
    return *this;
}

StyleProperty &StyleProperty::operator=(StyleProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

LayoutProperty *StyleProperty::layout() const
{
    return d->layout.get();
}

void StyleProperty::setLayout(std::unique_ptr<LayoutProperty> &&newValue)
{
    d->layout = std::move(newValue);
}

TextProperty *StyleProperty::text() const
{
    return d->text.get();
}

void StyleProperty::setText(std::unique_ptr<TextProperty> &&newValue)
{
    d->text = std::move(newValue);
}

IconProperty *StyleProperty::icon() const
{
    return d->icon.get();
}

void StyleProperty::setIcon(std::unique_ptr<IconProperty> &&newValue)
{
    d->icon = std::move(newValue);
}

BackgroundProperty *StyleProperty::background() const
{
    return d->background.get();
}

void StyleProperty::setBackground(std::unique_ptr<BackgroundProperty> &&newValue)
{
    d->background = std::move(newValue);
}

BorderProperty *StyleProperty::border() const
{
    return d->border.get();
}

void StyleProperty::setBorder(std::unique_ptr<BorderProperty> &&newValue)
{
    d->border = std::move(newValue);
}

OutlineProperty *StyleProperty::outline() const
{
    return d->outline.get();
}

void StyleProperty::setOutline(std::unique_ptr<OutlineProperty> &&newValue)
{
    d->outline = std::move(newValue);
}

CornersProperty *StyleProperty::corners() const
{
    return d->corners.get();
}

void StyleProperty::setCorners(std::unique_ptr<CornersProperty> &&newValue)
{
    d->corners = std::move(newValue);
}

ShadowProperty *StyleProperty::shadow() const
{
    return d->shadow.get();
}

void StyleProperty::setShadow(std::unique_ptr<ShadowProperty> &&newValue)
{
    d->shadow = std::move(newValue);
}

bool StyleProperty::hasAnyValue() const
{
    if (d->layout && d->layout->hasAnyValue()) {
        return true;
    }
    if (d->text && d->text->hasAnyValue()) {
        return true;
    }
    if (d->icon && d->icon->hasAnyValue()) {
        return true;
    }
    if (d->background && d->background->hasAnyValue()) {
        return true;
    }
    if (d->border && d->border->hasAnyValue()) {
        return true;
    }
    if (d->outline && d->outline->hasAnyValue()) {
        return true;
    }
    if (d->corners && d->corners->hasAnyValue()) {
        return true;
    }
    if (d->shadow && d->shadow->hasAnyValue()) {
        return true;
    }
    return false;
}

bool StyleProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->layout && !d->layout->isEmpty()) {
        return false;
    }
    if (d->text && !d->text->isEmpty()) {
        return false;
    }
    if (d->icon && !d->icon->isEmpty()) {
        return false;
    }
    if (d->background && !d->background->isEmpty()) {
        return false;
    }
    if (d->border && !d->border->isEmpty()) {
        return false;
    }
    if (d->outline && !d->outline->isEmpty()) {
        return false;
    }
    if (d->corners && !d->corners->isEmpty()) {
        return false;
    }
    if (d->shadow && !d->shadow->isEmpty()) {
        return false;
    }

    return true;
}

QString StyleProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "StyleProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "layout: ";
    if (d->layout) {
        out << d->layout->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "text: ";
    if (d->text) {
        out << d->text->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "icon: ";
    if (d->icon) {
        out << d->icon->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "background: ";
    if (d->background) {
        out << d->background->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "border: ";
    if (d->border) {
        out << d->border->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "outline: ";
    if (d->outline) {
        out << d->outline->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "corners: ";
    if (d->corners) {
        out << d->corners->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "shadow: ";
    if (d->shadow) {
        out << d->shadow->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void StyleProperty::resolveProperties(const StyleProperty *source, StyleProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (source->d->layout) {
        if (!destination->d->layout) {
            destination->d->layout = std::make_unique<LayoutProperty>();
        }
        LayoutProperty::resolveProperties(source->d->layout.get(), destination->d->layout.get());
    }
    if (source->d->text) {
        if (!destination->d->text) {
            destination->d->text = std::make_unique<TextProperty>();
        }
        TextProperty::resolveProperties(source->d->text.get(), destination->d->text.get());
    }
    if (source->d->icon) {
        if (!destination->d->icon) {
            destination->d->icon = std::make_unique<IconProperty>();
        }
        IconProperty::resolveProperties(source->d->icon.get(), destination->d->icon.get());
    }
    if (source->d->background) {
        if (!destination->d->background) {
            destination->d->background = std::make_unique<BackgroundProperty>();
        }
        BackgroundProperty::resolveProperties(source->d->background.get(), destination->d->background.get());
    }
    if (source->d->border) {
        if (!destination->d->border) {
            destination->d->border = std::make_unique<BorderProperty>();
        }
        BorderProperty::resolveProperties(source->d->border.get(), destination->d->border.get());
    }
    if (source->d->outline) {
        if (!destination->d->outline) {
            destination->d->outline = std::make_unique<OutlineProperty>();
        }
        OutlineProperty::resolveProperties(source->d->outline.get(), destination->d->outline.get());
    }
    if (source->d->corners) {
        if (!destination->d->corners) {
            destination->d->corners = std::make_unique<CornersProperty>();
        }
        CornersProperty::resolveProperties(source->d->corners.get(), destination->d->corners.get());
    }
    if (source->d->shadow) {
        if (!destination->d->shadow) {
            destination->d->shadow = std::make_unique<ShadowProperty>();
        }
        ShadowProperty::resolveProperties(source->d->shadow.get(), destination->d->shadow.get());
    }
}

std::unique_ptr<StyleProperty> StyleProperty::empty()
{
    auto result = std::make_unique<StyleProperty>();
    result->d->layout = LayoutProperty::empty();
    result->d->text = TextProperty::empty();
    result->d->icon = IconProperty::empty();
    result->d->background = BackgroundProperty::empty();
    result->d->border = BorderProperty::empty();
    result->d->outline = OutlineProperty::empty();
    result->d->corners = CornersProperty::empty();
    result->d->shadow = ShadowProperty::empty();
    return result;
}

bool Union::Properties::operator==(const StyleProperty &left, const StyleProperty &right)
{
    if (left.layout() && right.layout()) {
        if (*(left.layout()) != *(right.layout())) {
            return false;
        }
    } else if (left.layout() != right.layout()) {
        return false;
    }
    if (left.text() && right.text()) {
        if (*(left.text()) != *(right.text())) {
            return false;
        }
    } else if (left.text() != right.text()) {
        return false;
    }
    if (left.icon() && right.icon()) {
        if (*(left.icon()) != *(right.icon())) {
            return false;
        }
    } else if (left.icon() != right.icon()) {
        return false;
    }
    if (left.background() && right.background()) {
        if (*(left.background()) != *(right.background())) {
            return false;
        }
    } else if (left.background() != right.background()) {
        return false;
    }
    if (left.border() && right.border()) {
        if (*(left.border()) != *(right.border())) {
            return false;
        }
    } else if (left.border() != right.border()) {
        return false;
    }
    if (left.outline() && right.outline()) {
        if (*(left.outline()) != *(right.outline())) {
            return false;
        }
    } else if (left.outline() != right.outline()) {
        return false;
    }
    if (left.corners() && right.corners()) {
        if (*(left.corners()) != *(right.corners())) {
            return false;
        }
    } else if (left.corners() != right.corners()) {
        return false;
    }
    if (left.shadow() && right.shadow()) {
        if (*(left.shadow()) != *(right.shadow())) {
            return false;
        }
    } else if (left.shadow() != right.shadow()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::StyleProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}