﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/arc-region-switch/model/ListRoute53HealthChecksInRegionResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ARCRegionswitch::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRoute53HealthChecksInRegionResult::ListRoute53HealthChecksInRegionResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListRoute53HealthChecksInRegionResult& ListRoute53HealthChecksInRegionResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("healthChecks")) {
    Aws::Utils::Array<JsonView> healthChecksJsonList = jsonValue.GetArray("healthChecks");
    for (unsigned healthChecksIndex = 0; healthChecksIndex < healthChecksJsonList.GetLength(); ++healthChecksIndex) {
      m_healthChecks.push_back(healthChecksJsonList[healthChecksIndex].AsObject());
    }
    m_healthChecksHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
