﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/billing/model/Dimension.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace Billing {
namespace Model {
namespace DimensionMapper {

static const int LINKED_ACCOUNT_HASH = HashingUtils::HashString("LINKED_ACCOUNT");

Dimension GetDimensionForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == LINKED_ACCOUNT_HASH) {
    return Dimension::LINKED_ACCOUNT;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<Dimension>(hashCode);
  }

  return Dimension::NOT_SET;
}

Aws::String GetNameForDimension(Dimension enumValue) {
  switch (enumValue) {
    case Dimension::NOT_SET:
      return {};
    case Dimension::LINKED_ACCOUNT:
      return "LINKED_ACCOUNT";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace DimensionMapper
}  // namespace Model
}  // namespace Billing
}  // namespace Aws
