/* AbstractWifiInterface.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AbstractWifiInterface.vala, do not modify */

/*
* Copyright (c) 2015-2018 elementary LLC (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "networkapplet.h"
#include <glib.h>
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_ABSTRACT_WIFI_INTERFACE_0_PROPERTY,
	NETWORK_ABSTRACT_WIFI_INTERFACE_ACTIVE_WIFI_ITEM_PROPERTY,
	NETWORK_ABSTRACT_WIFI_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_abstract_wifi_interface_properties[NETWORK_ABSTRACT_WIFI_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rf_kill_device_unref0(var) ((var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL)))

struct _NetworkAbstractWifiInterfacePrivate {
	NetworkWifiMenuItem* _active_wifi_item;
	guint timeout_scan;
};

static gint NetworkAbstractWifiInterface_private_offset;
static gpointer network_abstract_wifi_interface_parent_class = NULL;
static GType network_abstract_wifi_interface_type_id = 0;

static void _network_widget_nm_interface_update_rf_kill_manager_device_added (RFKillManager* _sender,
                                                                       RFKillDevice* device,
                                                                       gpointer self);
static void _network_widget_nm_interface_update_rf_kill_manager_device_changed (RFKillManager* _sender,
                                                                         RFKillDevice* device,
                                                                         gpointer self);
static void _network_widget_nm_interface_update_rf_kill_manager_device_deleted (RFKillManager* _sender,
                                                                         RFKillDevice* device,
                                                                         gpointer self);
static void _network_widget_nm_interface_update_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void network_abstract_wifi_interface_access_point_added_cb (NetworkAbstractWifiInterface* self,
                                                            GObject* ap_);
static void _network_abstract_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added (NMDeviceWifi* _sender,
                                                                                               GObject* ap,
                                                                                               gpointer self);
static void network_abstract_wifi_interface_access_point_removed_cb (NetworkAbstractWifiInterface* self,
                                                              GObject* ap_);
static void _network_abstract_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed (NMDeviceWifi* _sender,
                                                                                                   GObject* ap,
                                                                                                   gpointer self);
static void _network_widget_nm_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                                  guint new_state,
                                                                  guint old_state,
                                                                  guint reason,
                                                                  gpointer self);
static void _network_abstract_wifi_interface_access_point_added_cb_gfunc (gconstpointer data,
                                                                   gpointer self);
static void network_abstract_wifi_interface_real_update_name (NetworkWidgetNMInterface* base,
                                                       gint count);
static void _network_abstract_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action (NetworkWifiMenuItem* _sender,
                                                                                           gpointer self);
static void network_abstract_wifi_interface_update_active_ap (NetworkAbstractWifiInterface* self);
static NetworkState network_abstract_wifi_interface_strength_to_state (NetworkAbstractWifiInterface* self,
                                                                guint8 strength);
static void network_abstract_wifi_interface_real_update (NetworkWidgetNMInterface* base);
static void network_abstract_wifi_interface_cancel_scan (NetworkAbstractWifiInterface* self);
static void network_abstract_wifi_interface_set_scan_placeholder (NetworkAbstractWifiInterface* self);
static void _rf_kill_device_unref0_ (gpointer var);
static inline void _g_list_free__rf_kill_device_unref0_ (GList* self);
static gboolean ___lambda10_ (NetworkAbstractWifiInterface* self);
static gboolean ____lambda10__gsource_func (gpointer self);
static void network_abstract_wifi_interface_real_wifi_activate_cb (NetworkAbstractWifiInterface* self,
                                                            NetworkWifiMenuItem* i);
static gint network_abstract_wifi_interface_sort_func (NetworkAbstractWifiInterface* self,
                                                GtkListBoxRow* r1,
                                                GtkListBoxRow* r2);
static GObject * network_abstract_wifi_interface_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static gint _network_abstract_wifi_interface_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                        GtkListBoxRow* row2,
                                                                        gpointer self);
static void _network_abstract_wifi_interface___lambda11_ (NetworkAbstractWifiInterface* self);
static void __network_abstract_wifi_interface___lambda11__gtk_widget_map (GtkWidget* _sender,
                                                                   gpointer self);
static void network_abstract_wifi_interface_finalize (GObject * obj);
static void _vala_network_abstract_wifi_interface_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_network_abstract_wifi_interface_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
network_abstract_wifi_interface_get_instance_private (NetworkAbstractWifiInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkAbstractWifiInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_network_widget_nm_interface_update_rf_kill_manager_device_added (RFKillManager* _sender,
                                                                  RFKillDevice* device,
                                                                  gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
_network_widget_nm_interface_update_rf_kill_manager_device_changed (RFKillManager* _sender,
                                                                    RFKillDevice* device,
                                                                    gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
_network_widget_nm_interface_update_rf_kill_manager_device_deleted (RFKillManager* _sender,
                                                                    RFKillDevice* device,
                                                                    gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
_network_widget_nm_interface_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
_network_abstract_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added (NMDeviceWifi* _sender,
                                                                                          GObject* ap,
                                                                                          gpointer self)
{
	network_abstract_wifi_interface_access_point_added_cb ((NetworkAbstractWifiInterface*) self, ap);
}

static void
_network_abstract_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed (NMDeviceWifi* _sender,
                                                                                              GObject* ap,
                                                                                              gpointer self)
{
	network_abstract_wifi_interface_access_point_removed_cb ((NetworkAbstractWifiInterface*) self, ap);
}

static void
_network_widget_nm_interface_update_nm_device_state_changed (NMDevice* _sender,
                                                             guint new_state,
                                                             guint old_state,
                                                             guint reason,
                                                             gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_network_abstract_wifi_interface_access_point_added_cb_gfunc (gconstpointer data,
                                                              gpointer self)
{
	network_abstract_wifi_interface_access_point_added_cb ((NetworkAbstractWifiInterface*) self, (GObject*) data);
}

void
network_abstract_wifi_interface_init_wifi_interface (NetworkAbstractWifiInterface* self,
                                                     NMClient* nm_client,
                                                     NMDevice* _device)
{
	NMClient* _tmp0_;
	NMDevice* _tmp1_;
	NMDevice* _tmp2_;
	NMDeviceWifi* _tmp3_;
	NetworkWifiMenuItem* _tmp4_;
	GtkBox* no_aps_box = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* no_aps = NULL;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* wireless_off_box = NULL;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp14_;
	GtkSpinner* _tmp15_;
	GtkSpinner* _tmp16_;
	GtkSpinner* _tmp17_;
	GtkSpinner* _tmp18_;
	GtkBox* scanning_box = NULL;
	GtkBox* _tmp19_;
	GtkLabel* scanning = NULL;
	GtkLabel* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBox* _tmp23_;
	GtkSpinner* _tmp24_;
	GtkBox* _tmp25_;
	GtkBox* _tmp26_;
	GtkStack* _tmp27_;
	GtkBox* _tmp28_;
	GtkStack* _tmp29_;
	GtkBox* _tmp30_;
	GtkStack* _tmp31_;
	GtkBox* _tmp32_;
	GtkStack* _tmp33_;
	RFKillManager* _tmp34_;
	RFKillManager* _tmp35_;
	RFKillManager* _tmp36_;
	RFKillManager* _tmp37_;
	RFKillManager* _tmp38_;
	NMDeviceWifi* _tmp39_;
	NMDeviceWifi* _tmp40_;
	NMDeviceWifi* _tmp41_;
	NMDeviceWifi* _tmp42_;
	GPtrArray* aps = NULL;
	NMDeviceWifi* _tmp43_;
	GPtrArray* _tmp44_;
	GPtrArray* _tmp45_;
	gboolean _tmp46_ = FALSE;
	GPtrArray* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nm_client != NULL);
	_tmp0_ = _g_object_ref0 (nm_client);
	_g_object_unref0 (self->nm_client);
	self->nm_client = _tmp0_;
	_tmp1_ = _g_object_ref0 (_device);
	_g_object_unref0 (((NetworkWidgetNMInterface*) self)->device);
	((NetworkWidgetNMInterface*) self)->device = _tmp1_;
	_tmp2_ = ((NetworkWidgetNMInterface*) self)->device;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, nm_device_wifi_get_type (), NMDeviceWifi));
	_g_object_unref0 (self->wifi_device);
	self->wifi_device = _tmp3_;
	_tmp4_ = network_wifi_menu_item_new_blank ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->blank_item);
	self->blank_item = _tmp4_;
	network_abstract_wifi_interface_set_active_wifi_item (self, NULL);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp5_);
	no_aps_box = _tmp5_;
	_tmp6_ = no_aps_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp7_ = no_aps_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	_tmp8_ = network_abstract_wifi_interface_construct_placeholder_label (self, _ ("No Access Points Available"), TRUE);
	no_aps = _tmp8_;
	_tmp9_ = no_aps_box;
	_tmp10_ = no_aps;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp11_);
	wireless_off_box = _tmp11_;
	_tmp12_ = wireless_off_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = wireless_off_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	_tmp14_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp14_);
	spinner = _tmp14_;
	_tmp15_ = spinner;
	gtk_widget_set_visible ((GtkWidget*) _tmp15_, TRUE);
	_tmp16_ = spinner;
	_tmp17_ = spinner;
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	_tmp18_ = spinner;
	gtk_spinner_start (_tmp18_);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp19_);
	scanning_box = _tmp19_;
	_tmp20_ = network_abstract_wifi_interface_construct_placeholder_label (self, _ ("Scanning for Access Points…"), TRUE);
	scanning = _tmp20_;
	_tmp21_ = scanning_box;
	_tmp22_ = scanning;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = scanning_box;
	_tmp24_ = spinner;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = scanning_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp25_, TRUE);
	_tmp26_ = scanning_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	_tmp27_ = self->placeholder;
	_tmp28_ = no_aps_box;
	gtk_stack_add_named (_tmp27_, (GtkWidget*) _tmp28_, "no-aps");
	_tmp29_ = self->placeholder;
	_tmp30_ = wireless_off_box;
	gtk_stack_add_named (_tmp29_, (GtkWidget*) _tmp30_, "wireless-off");
	_tmp31_ = self->placeholder;
	_tmp32_ = scanning_box;
	gtk_stack_add_named (_tmp31_, (GtkWidget*) _tmp32_, "scanning");
	_tmp33_ = self->placeholder;
	gtk_stack_set_visible_child_name (_tmp33_, "no-aps");
	_tmp34_ = rf_kill_manager_new ();
	_g_object_unref0 (self->rfkill);
	self->rfkill = _tmp34_;
	_tmp35_ = self->rfkill;
	rf_kill_manager_open (_tmp35_);
	_tmp36_ = self->rfkill;
	g_signal_connect_object (_tmp36_, "device-added", (GCallback) _network_widget_nm_interface_update_rf_kill_manager_device_added, (NetworkWidgetNMInterface*) self, 0);
	_tmp37_ = self->rfkill;
	g_signal_connect_object (_tmp37_, "device-changed", (GCallback) _network_widget_nm_interface_update_rf_kill_manager_device_changed, (NetworkWidgetNMInterface*) self, 0);
	_tmp38_ = self->rfkill;
	g_signal_connect_object (_tmp38_, "device-deleted", (GCallback) _network_widget_nm_interface_update_rf_kill_manager_device_deleted, (NetworkWidgetNMInterface*) self, 0);
	_tmp39_ = self->wifi_device;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::active-access-point", (GCallback) _network_widget_nm_interface_update_g_object_notify, (NetworkWidgetNMInterface*) self, 0);
	_tmp40_ = self->wifi_device;
	g_signal_connect_object (_tmp40_, "access-point-added", (GCallback) _network_abstract_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added, self, 0);
	_tmp41_ = self->wifi_device;
	g_signal_connect_object (_tmp41_, "access-point-removed", (GCallback) _network_abstract_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed, self, 0);
	_tmp42_ = self->wifi_device;
	g_signal_connect_object ((NMDevice*) _tmp42_, "state-changed", (GCallback) _network_widget_nm_interface_update_nm_device_state_changed, (NetworkWidgetNMInterface*) self, 0);
	_tmp43_ = self->wifi_device;
	_tmp44_ = nm_device_wifi_get_access_points (_tmp43_);
	_tmp45_ = _g_ptr_array_ref0 (_tmp44_);
	aps = _tmp45_;
	_tmp47_ = aps;
	if (_tmp47_ != NULL) {
		GPtrArray* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		_tmp48_ = aps;
		_tmp49_ = vala_g_ptr_array_get_length (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = _tmp50_ > 0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		GPtrArray* _tmp51_;
		_tmp51_ = aps;
		g_ptr_array_foreach (_tmp51_, _network_abstract_wifi_interface_access_point_added_cb_gfunc, self);
	}
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
	_g_ptr_array_unref0 (aps);
	_g_object_unref0 (scanning);
	_g_object_unref0 (scanning_box);
	_g_object_unref0 (spinner);
	_g_object_unref0 (wireless_off_box);
	_g_object_unref0 (no_aps);
	_g_object_unref0 (no_aps_box);
}

static void
network_abstract_wifi_interface_real_update_name (NetworkWidgetNMInterface* base,
                                                  gint count)
{
	NetworkAbstractWifiInterface * self;
	self = (NetworkAbstractWifiInterface*) base;
	if (count <= 1) {
		network_widget_nm_interface_set_display_title ((NetworkWidgetNMInterface*) self, _ ("Wireless"));
	} else {
		NMDevice* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = ((NetworkWidgetNMInterface*) self)->device;
		_tmp1_ = nm_device_get_description (_tmp0_);
		network_widget_nm_interface_set_display_title ((NetworkWidgetNMInterface*) self, _tmp1_);
	}
}

GtkLabel*
network_abstract_wifi_interface_construct_placeholder_label (NetworkAbstractWifiInterface* self,
                                                             const gchar* text,
                                                             gboolean title)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_set_visible ((GtkWidget*) label, TRUE);
	gtk_label_set_use_markup (label, TRUE);
	g_object_set (label, "wrap", TRUE, NULL);
	g_object_set (label, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (label, 30);
	gtk_label_set_justify (label, GTK_JUSTIFY_CENTER);
	result = label;
	return result;
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static void
_network_abstract_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action (NetworkWifiMenuItem* _sender,
                                                                                      gpointer self)
{
	network_abstract_wifi_interface_wifi_activate_cb ((NetworkAbstractWifiInterface*) self, _sender);
}

static void
network_abstract_wifi_interface_access_point_added_cb (NetworkAbstractWifiInterface* self,
                                                       GObject* ap_)
{
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp0_;
	NetworkWifiMenuItem* previous_wifi_item = NULL;
	NetworkWifiMenuItem* _tmp1_;
	NetworkWifiMenuItem* _tmp2_;
	NMAccessPoint* _tmp3_;
	GBytes* _tmp4_;
	GBytes* _tmp5_;
	gboolean found = FALSE;
	GtkListBox* _tmp6_;
	GList* _tmp7_;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap_ != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ap_, nm_access_point_get_type (), NMAccessPoint));
	ap = _tmp0_;
	_tmp1_ = self->blank_item;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	previous_wifi_item = _tmp2_;
	_tmp3_ = ap;
	_tmp4_ = nm_access_point_get_ssid (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		g_debug ("AbstractWifiInterface.vala:132: NULL AP SSID");
		_g_object_unref0 (previous_wifi_item);
		_g_object_unref0 (ap);
		return;
	}
	found = FALSE;
	_tmp6_ = self->wifi_list;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp7_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp8_;
				NetworkWifiMenuItem* _tmp9_;
				GBytes* menu_ssid = NULL;
				NetworkWifiMenuItem* _tmp10_;
				GBytes* _tmp11_;
				GBytes* _tmp12_;
				GBytes* _tmp13_;
				gboolean _tmp14_ = FALSE;
				GBytes* _tmp15_;
				NetworkWifiMenuItem* _tmp22_;
				NetworkWifiMenuItem* _tmp23_;
				_tmp8_ = w;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp9_;
				_tmp10_ = menu_item;
				_tmp11_ = network_wifi_menu_item_get_ssid (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _g_bytes_ref0 (_tmp12_);
				menu_ssid = _tmp13_;
				_tmp15_ = menu_ssid;
				if (_tmp15_ != NULL) {
					NMAccessPoint* _tmp16_;
					GBytes* _tmp17_;
					GBytes* _tmp18_;
					GBytes* _tmp19_;
					_tmp16_ = ap;
					_tmp17_ = nm_access_point_get_ssid (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = menu_ssid;
					_tmp14_ = g_bytes_compare (_tmp18_, _tmp19_) == 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					NetworkWifiMenuItem* _tmp20_;
					NMAccessPoint* _tmp21_;
					found = TRUE;
					_tmp20_ = menu_item;
					_tmp21_ = ap;
					network_wifi_menu_item_add_ap (_tmp20_, _tmp21_);
					_g_bytes_unref0 (menu_ssid);
					_g_object_unref0 (menu_item);
					break;
				}
				_tmp22_ = menu_item;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (previous_wifi_item);
				previous_wifi_item = _tmp23_;
				_g_bytes_unref0 (menu_ssid);
				_g_object_unref0 (menu_item);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	if (!found) {
		NMAccessPoint* _tmp25_;
		GBytes* _tmp26_;
		GBytes* _tmp27_;
		_tmp25_ = ap;
		_tmp26_ = nm_access_point_get_ssid (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp24_ = _tmp27_ != NULL;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		NetworkWifiMenuItem* item = NULL;
		NMAccessPoint* _tmp28_;
		NetworkWifiMenuItem* _tmp29_;
		NetworkWifiMenuItem* _tmp30_;
		NetworkWifiMenuItem* _tmp31_;
		NetworkWifiMenuItem* _tmp32_;
		NetworkWifiMenuItem* _tmp33_;
		GtkListBox* _tmp34_;
		NetworkWifiMenuItem* _tmp35_;
		_tmp28_ = ap;
		_tmp29_ = previous_wifi_item;
		_tmp30_ = network_wifi_menu_item_new (_tmp28_, _tmp29_);
		g_object_ref_sink (_tmp30_);
		item = _tmp30_;
		_tmp31_ = item;
		g_signal_connect_object (_tmp31_, "user-action", (GCallback) _network_abstract_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action, self, 0);
		_tmp32_ = item;
		_tmp33_ = _g_object_ref0 (_tmp32_);
		_g_object_unref0 (previous_wifi_item);
		previous_wifi_item = _tmp33_;
		_tmp34_ = self->wifi_list;
		_tmp35_ = item;
		gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
		network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
		_g_object_unref0 (item);
	}
	_g_object_unref0 (previous_wifi_item);
	_g_object_unref0 (ap);
}

static void
network_abstract_wifi_interface_update_active_ap (NetworkAbstractWifiInterface* self)
{
	NMDeviceWifi* _tmp0_;
	NMAccessPoint* _tmp1_;
	NMAccessPoint* _tmp2_;
	NMAccessPoint* _tmp3_;
	NetworkWifiMenuItem* _tmp4_;
	NMAccessPoint* _tmp9_;
	GBytes* ssid = NULL;
	NMAccessPoint* _tmp11_;
	GBytes* _tmp12_;
	GBytes* _tmp13_;
	GBytes* _tmp14_;
	GBytes* _tmp15_;
	GBytes* _tmp17_;
	gsize _tmp18_ = 0;
	guint8* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean found = FALSE;
	GtkListBox* _tmp22_;
	GList* _tmp23_;
	g_return_if_fail (self != NULL);
	g_debug ("AbstractWifiInterface.vala:164: Update active AP");
	_tmp0_ = self->wifi_device;
	_tmp1_ = nm_device_wifi_get_active_access_point (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->active_ap);
	self->active_ap = _tmp3_;
	_tmp4_ = self->priv->_active_wifi_item;
	if (_tmp4_ != NULL) {
		NetworkWifiMenuItem* _tmp5_;
		NetworkState _tmp6_;
		NetworkState _tmp7_;
		_tmp5_ = self->priv->_active_wifi_item;
		_tmp6_ = network_wifi_menu_item_get_state (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == NETWORK_STATE_CONNECTING_WIFI) {
			NetworkWifiMenuItem* _tmp8_;
			_tmp8_ = self->priv->_active_wifi_item;
			network_wifi_menu_item_set_state (_tmp8_, NETWORK_STATE_DISCONNECTED);
		}
		network_abstract_wifi_interface_set_active_wifi_item (self, NULL);
	}
	_tmp9_ = self->active_ap;
	if (_tmp9_ == NULL) {
		NetworkWifiMenuItem* _tmp10_;
		g_debug ("AbstractWifiInterface.vala:176: No active AP");
		_tmp10_ = self->blank_item;
		network_wifi_menu_item_set_active (_tmp10_, TRUE);
		return;
	}
	_tmp11_ = self->active_ap;
	_tmp12_ = nm_access_point_get_ssid (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_bytes_ref0 (_tmp13_);
	ssid = _tmp14_;
	_tmp15_ = ssid;
	if (_tmp15_ == NULL) {
		NetworkWifiMenuItem* _tmp16_;
		g_debug ("AbstractWifiInterface.vala:183: NULL active AP SSID");
		_tmp16_ = self->blank_item;
		network_wifi_menu_item_set_active (_tmp16_, TRUE);
		_g_bytes_unref0 (ssid);
		return;
	}
	_tmp17_ = ssid;
	_tmp19_ = g_bytes_get_data (_tmp17_, &_tmp18_);
	_tmp20_ = nm_utils_ssid_to_utf8 (_tmp19_, (gsize) _tmp18_);
	_tmp21_ = _tmp20_;
	g_debug ("AbstractWifiInterface.vala:188: Active ap: %s", _tmp21_);
	_g_free0 (_tmp21_);
	found = FALSE;
	_tmp22_ = self->wifi_list;
	_tmp23_ = gtk_container_get_children ((GtkContainer*) _tmp22_);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp23_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp24_;
				NetworkWifiMenuItem* _tmp25_;
				NetworkWifiMenuItem* _tmp26_;
				GBytes* _tmp27_;
				GBytes* _tmp28_;
				GBytes* _tmp29_;
				NetworkWifiMenuItem* _tmp30_;
				GBytes* _tmp31_;
				GBytes* _tmp32_;
				_tmp24_ = w;
				_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp25_;
				_tmp26_ = menu_item;
				_tmp27_ = network_wifi_menu_item_get_ssid (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ == NULL) {
					_g_object_unref0 (menu_item);
					continue;
				}
				_tmp29_ = ssid;
				_tmp30_ = menu_item;
				_tmp31_ = network_wifi_menu_item_get_ssid (_tmp30_);
				_tmp32_ = _tmp31_;
				if (g_bytes_compare (_tmp29_, _tmp32_) == 0) {
					NetworkWifiMenuItem* _tmp33_;
					NetworkWifiMenuItem* _tmp34_;
					NetworkWifiMenuItem* _tmp35_;
					NetworkState _tmp36_;
					NetworkState _tmp37_;
					found = TRUE;
					_tmp33_ = menu_item;
					network_wifi_menu_item_set_active (_tmp33_, TRUE);
					_tmp34_ = menu_item;
					network_abstract_wifi_interface_set_active_wifi_item (self, _tmp34_);
					_tmp35_ = self->priv->_active_wifi_item;
					_tmp36_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
					_tmp37_ = _tmp36_;
					network_wifi_menu_item_set_state (_tmp35_, _tmp37_);
				}
				_g_object_unref0 (menu_item);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	if (!found) {
		g_debug ("AbstractWifiInterface.vala:206: Active AP not added");
	}
	_g_bytes_unref0 (ssid);
}

static void
network_abstract_wifi_interface_access_point_removed_cb (NetworkAbstractWifiInterface* self,
                                                         GObject* ap_)
{
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp0_;
	NetworkWifiMenuItem* found_item = NULL;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	NetworkWifiMenuItem* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap_ != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ap_, nm_access_point_get_type (), NMAccessPoint));
	ap = _tmp0_;
	found_item = NULL;
	_tmp1_ = self->wifi_list;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp2_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp3_;
				NetworkWifiMenuItem* _tmp4_;
				NetworkWifiMenuItem* _tmp5_;
				GBytes* _tmp6_;
				GBytes* _tmp7_;
				NMAccessPoint* _tmp8_;
				GBytes* _tmp9_;
				GBytes* _tmp10_;
				NetworkWifiMenuItem* _tmp11_;
				GBytes* _tmp12_;
				GBytes* _tmp13_;
				_tmp3_ = w;
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp4_;
				_tmp5_ = menu_item;
				_tmp6_ = network_wifi_menu_item_get_ssid (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (menu_item);
					continue;
				}
				_tmp8_ = ap;
				_tmp9_ = nm_access_point_get_ssid (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = menu_item;
				_tmp12_ = network_wifi_menu_item_get_ssid (_tmp11_);
				_tmp13_ = _tmp12_;
				if (g_bytes_compare (_tmp10_, _tmp13_) == 0) {
					NetworkWifiMenuItem* _tmp14_;
					NetworkWifiMenuItem* _tmp15_;
					_tmp14_ = menu_item;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					_g_object_unref0 (found_item);
					found_item = _tmp15_;
					_g_object_unref0 (menu_item);
					break;
				}
				_g_object_unref0 (menu_item);
			}
		}
		(w_collection == NULL) ? NULL : (w_collection = (g_list_free (w_collection), NULL));
	}
	_tmp16_ = found_item;
	if (_tmp16_ == NULL) {
		g_critical ("AbstractWifiInterface.vala:227: Couldn't remove an access point which " \
"has not been added.");
		_g_object_unref0 (found_item);
		_g_object_unref0 (ap);
		return;
	} else {
		NetworkWifiMenuItem* _tmp17_;
		NMAccessPoint* _tmp18_;
		_tmp17_ = found_item;
		_tmp18_ = ap;
		if (!network_wifi_menu_item_remove_ap (_tmp17_, _tmp18_)) {
			NetworkWifiMenuItem* _tmp19_;
			_tmp19_ = found_item;
			gtk_widget_destroy ((GtkWidget*) _tmp19_);
		}
	}
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
	_g_object_unref0 (found_item);
	_g_object_unref0 (ap);
}

static NetworkState
network_abstract_wifi_interface_strength_to_state (NetworkAbstractWifiInterface* self,
                                                   guint8 strength)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	if (((gint) strength) < 30) {
		result = NETWORK_STATE_CONNECTED_WIFI_WEAK;
		return result;
	} else {
		if (((gint) strength) < 55) {
			result = NETWORK_STATE_CONNECTED_WIFI_OK;
			return result;
		} else {
			if (((gint) strength) < 80) {
				result = NETWORK_STATE_CONNECTED_WIFI_GOOD;
				return result;
			} else {
				result = NETWORK_STATE_CONNECTED_WIFI_EXCELLENT;
				return result;
			}
		}
	}
}

static gpointer
_rf_kill_device_ref0 (gpointer self)
{
	return self ? rf_kill_device_ref (self) : NULL;
}

static void
_rf_kill_device_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL));
}

static inline void
_g_list_free__rf_kill_device_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rf_kill_device_unref0_);
}

static void
network_abstract_wifi_interface_real_update (NetworkWidgetNMInterface* base)
{
	NetworkAbstractWifiInterface * self;
	NMDeviceWifi* _tmp0_;
	NMDeviceState _tmp1_;
	NMDeviceState _tmp2_;
	NetworkState _tmp10_;
	NetworkState _tmp11_;
	GEnumValue* _tmp12_;
	RFKillManager* _tmp13_;
	GList* _tmp14_;
	gboolean _tmp25_ = FALSE;
	self = (NetworkAbstractWifiInterface*) base;
	_tmp0_ = self->wifi_device;
	_tmp1_ = nm_device_get_state ((NMDevice*) _tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_FAILED:
		{
			NetworkWifiMenuItem* _tmp3_;
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_FAILED_WIFI);
			_tmp3_ = self->priv->_active_wifi_item;
			if (_tmp3_ != NULL) {
				NetworkWifiMenuItem* _tmp4_;
				NetworkState _tmp5_;
				NetworkState _tmp6_;
				_tmp4_ = self->priv->_active_wifi_item;
				_tmp5_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
				_tmp6_ = _tmp5_;
				network_wifi_menu_item_set_state (_tmp4_, _tmp6_);
			}
			network_abstract_wifi_interface_cancel_scan (self);
			break;
		}
		case NM_DEVICE_STATE_DEACTIVATING:
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			GtkStack* _tmp7_;
			network_abstract_wifi_interface_cancel_scan (self);
			_tmp7_ = self->placeholder;
			gtk_stack_set_visible_child_name (_tmp7_, "wireless-off");
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_DISCONNECTED);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			network_abstract_wifi_interface_set_scan_placeholder (self);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_DISCONNECTED);
			break;
		}
		case NM_DEVICE_STATE_PREPARE:
		case NM_DEVICE_STATE_CONFIG:
		case NM_DEVICE_STATE_NEED_AUTH:
		case NM_DEVICE_STATE_IP_CONFIG:
		case NM_DEVICE_STATE_IP_CHECK:
		case NM_DEVICE_STATE_SECONDARIES:
		{
			network_abstract_wifi_interface_set_scan_placeholder (self);
			network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTING_WIFI);
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			NMAccessPoint* _tmp8_;
			network_abstract_wifi_interface_set_scan_placeholder (self);
			_tmp8_ = self->active_ap;
			if (_tmp8_ != NULL) {
				NMAccessPoint* _tmp9_;
				_tmp9_ = self->active_ap;
				network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, network_abstract_wifi_interface_strength_to_state (self, nm_access_point_get_strength (_tmp9_)));
			} else {
				network_widget_nm_interface_set_state ((NetworkWidgetNMInterface*) self, NETWORK_STATE_CONNECTED_WIFI_WEAK);
			}
			break;
		}
		default:
		break;
	}
	_tmp10_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_enum_get_value (g_type_class_ref (NETWORK_TYPE_STATE), _tmp11_);
	g_debug ("AbstractWifiInterface.vala:294: New network state: %s", (_tmp12_ != NULL) ? _tmp12_->value_name : NULL);
	self->software_locked = FALSE;
	self->hardware_locked = FALSE;
	_tmp13_ = self->rfkill;
	_tmp14_ = rf_kill_manager_get_devices (_tmp13_);
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp14_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			RFKillDevice* _tmp15_;
			RFKillDevice* device = NULL;
			_tmp15_ = _rf_kill_device_ref0 ((RFKillDevice*) device_it->data);
			device = _tmp15_;
			{
				RFKillDevice* _tmp16_;
				RFKillDeviceType _tmp17_;
				RFKillDeviceType _tmp18_;
				RFKillDevice* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				RFKillDevice* _tmp22_;
				gboolean _tmp23_;
				gboolean _tmp24_;
				_tmp16_ = device;
				_tmp17_ = rf_kill_device_get_device_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ != RF_KILL_DEVICE_TYPE_WLAN) {
					_rf_kill_device_unref0 (device);
					continue;
				}
				_tmp19_ = device;
				_tmp20_ = rf_kill_device_get_software_lock (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					self->software_locked = TRUE;
				}
				_tmp22_ = device;
				_tmp23_ = rf_kill_device_get_hardware_lock (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_) {
					self->hardware_locked = TRUE;
				}
				_rf_kill_device_unref0 (device);
			}
		}
		(device_collection == NULL) ? NULL : (device_collection = (_g_list_free__rf_kill_device_unref0_ (device_collection), NULL));
	}
	if (self->hardware_locked) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = self->software_locked;
	}
	self->locked = _tmp25_;
	network_abstract_wifi_interface_update_active_ap (self);
	NETWORK_WIDGET_NM_INTERFACE_CLASS (network_abstract_wifi_interface_parent_class)->update (G_TYPE_CHECK_INSTANCE_CAST (self, NETWORK_TYPE_WIDGET_NM_INTERFACE, NetworkWidgetNMInterface));
}

static void
network_abstract_wifi_interface_cancel_scan (NetworkAbstractWifiInterface* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_scan > ((guint) 0)) {
		g_source_remove (self->priv->timeout_scan);
		self->priv->timeout_scan = (guint) 0;
	}
}

static gboolean
___lambda10_ (NetworkAbstractWifiInterface* self)
{
	GtkStack* _tmp0_;
	gboolean result;
	self->priv->timeout_scan = (guint) 0;
	_tmp0_ = self->placeholder;
	gtk_stack_set_visible_child_name (_tmp0_, "no-aps");
	result = FALSE;
	return result;
}

static gboolean
____lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda10_ ((NetworkAbstractWifiInterface*) self);
	return result;
}

static void
network_abstract_wifi_interface_set_scan_placeholder (NetworkAbstractWifiInterface* self)
{
	NetworkState _tmp0_;
	NetworkState _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widget_nm_interface_get_state ((NetworkWidgetNMInterface*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NETWORK_STATE_DISCONNECTED) {
		GtkStack* _tmp2_;
		NMDeviceWifi* _tmp3_;
		_tmp2_ = self->placeholder;
		gtk_stack_set_visible_child_name (_tmp2_, "scanning");
		network_abstract_wifi_interface_cancel_scan (self);
		_tmp3_ = self->wifi_device;
		nm_device_wifi_request_scan_async (_tmp3_, NULL, NULL, NULL);
		self->priv->timeout_scan = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ____lambda10__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
network_abstract_wifi_interface_real_wifi_activate_cb (NetworkAbstractWifiInterface* self,
                                                       NetworkWifiMenuItem* i)
{
	g_critical ("Type `%s' does not implement abstract method `network_abstract_wifi_interface_wifi_activate_cb'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
network_abstract_wifi_interface_wifi_activate_cb (NetworkAbstractWifiInterface* self,
                                                  NetworkWifiMenuItem* i)
{
	NetworkAbstractWifiInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_ABSTRACT_WIFI_INTERFACE_GET_CLASS (self);
	if (_klass_->wifi_activate_cb) {
		_klass_->wifi_activate_cb (self, i);
	}
}

static gint
network_abstract_wifi_interface_sort_func (NetworkAbstractWifiInterface* self,
                                           GtkListBoxRow* r1,
                                           GtkListBoxRow* r2)
{
	gboolean _tmp0_ = FALSE;
	NetworkWifiMenuItem* w1 = NULL;
	NetworkWifiMenuItem* _tmp1_;
	NetworkWifiMenuItem* w2 = NULL;
	NetworkWifiMenuItem* _tmp2_;
	NetworkWifiMenuItem* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	NetworkWifiMenuItem* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (r1 != NULL, 0);
	g_return_val_if_fail (r2 != NULL, 0);
	if (r1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = r2 == NULL;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (r1, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	w1 = _tmp1_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (r2, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	w2 = _tmp2_;
	_tmp3_ = w2;
	_tmp4_ = network_wifi_menu_item_get_strength (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = w1;
	_tmp7_ = network_wifi_menu_item_get_strength (_tmp6_);
	_tmp8_ = _tmp7_;
	result = (gint) (_tmp5_ - _tmp8_);
	_g_object_unref0 (w2);
	_g_object_unref0 (w1);
	return result;
}

NetworkAbstractWifiInterface*
network_abstract_wifi_interface_construct (GType object_type)
{
	NetworkAbstractWifiInterface * self = NULL;
	self = (NetworkAbstractWifiInterface*) network_widget_nm_interface_construct (object_type);
	return self;
}

NetworkWifiMenuItem*
network_abstract_wifi_interface_get_active_wifi_item (NetworkAbstractWifiInterface* self)
{
	NetworkWifiMenuItem* result;
	NetworkWifiMenuItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_wifi_item;
	result = _tmp0_;
	return result;
}

void
network_abstract_wifi_interface_set_active_wifi_item (NetworkAbstractWifiInterface* self,
                                                      NetworkWifiMenuItem* value)
{
	NetworkWifiMenuItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_abstract_wifi_interface_get_active_wifi_item (self);
	if (old_value != value) {
		NetworkWifiMenuItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_active_wifi_item);
		self->priv->_active_wifi_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_abstract_wifi_interface_properties[NETWORK_ABSTRACT_WIFI_INTERFACE_ACTIVE_WIFI_ITEM_PROPERTY]);
	}
}

static gint
_network_abstract_wifi_interface_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                   GtkListBoxRow* row2,
                                                                   gpointer self)
{
	gint result;
	result = network_abstract_wifi_interface_sort_func ((NetworkAbstractWifiInterface*) self, row1, row2);
	return result;
}

static void
_network_abstract_wifi_interface___lambda11_ (NetworkAbstractWifiInterface* self)
{
	GtkListBox* _tmp0_;
	_tmp0_ = self->wifi_list;
	gtk_list_box_invalidate_sort (_tmp0_);
}

static void
__network_abstract_wifi_interface___lambda11__gtk_widget_map (GtkWidget* _sender,
                                                              gpointer self)
{
	_network_abstract_wifi_interface___lambda11_ ((NetworkAbstractWifiInterface*) self);
}

static GObject *
network_abstract_wifi_interface_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkAbstractWifiInterface * self;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GtkStack* _tmp5_;
	parent_class = G_OBJECT_CLASS (network_abstract_wifi_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_ABSTRACT_WIFI_INTERFACE, NetworkAbstractWifiInterface);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->placeholder);
	self->placeholder = _tmp0_;
	_tmp1_ = self->placeholder;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->wifi_list);
	self->wifi_list = _tmp2_;
	_tmp3_ = self->wifi_list;
	gtk_list_box_set_sort_func (_tmp3_, _network_abstract_wifi_interface_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp4_ = self->wifi_list;
	_tmp5_ = self->placeholder;
	gtk_list_box_set_placeholder (_tmp4_, (GtkWidget*) _tmp5_);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __network_abstract_wifi_interface___lambda11__gtk_widget_map, self, 0);
	return obj;
}

static void
network_abstract_wifi_interface_class_init (NetworkAbstractWifiInterfaceClass * klass,
                                            gpointer klass_data)
{
	network_abstract_wifi_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkAbstractWifiInterface_private_offset);
	((NetworkWidgetNMInterfaceClass *) klass)->update_name = (void (*) (NetworkWidgetNMInterface*, gint)) network_abstract_wifi_interface_real_update_name;
	((NetworkWidgetNMInterfaceClass *) klass)->update = (void (*) (NetworkWidgetNMInterface*)) network_abstract_wifi_interface_real_update;
	((NetworkAbstractWifiInterfaceClass *) klass)->wifi_activate_cb = (void (*) (NetworkAbstractWifiInterface*, NetworkWifiMenuItem*)) network_abstract_wifi_interface_real_wifi_activate_cb;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_abstract_wifi_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_abstract_wifi_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_abstract_wifi_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_abstract_wifi_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_ABSTRACT_WIFI_INTERFACE_ACTIVE_WIFI_ITEM_PROPERTY, network_abstract_wifi_interface_properties[NETWORK_ABSTRACT_WIFI_INTERFACE_ACTIVE_WIFI_ITEM_PROPERTY] = g_param_spec_object ("active-wifi-item", "active-wifi-item", "active-wifi-item", NETWORK_TYPE_WIFI_MENU_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
network_abstract_wifi_interface_instance_init (NetworkAbstractWifiInterface * self,
                                               gpointer klass)
{
	self->priv = network_abstract_wifi_interface_get_instance_private (self);
	self->blank_item = NULL;
	self->priv->timeout_scan = (guint) 0;
}

static void
network_abstract_wifi_interface_finalize (GObject * obj)
{
	NetworkAbstractWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_ABSTRACT_WIFI_INTERFACE, NetworkAbstractWifiInterface);
	_g_object_unref0 (self->rfkill);
	_g_object_unref0 (self->wifi_device);
	_g_object_unref0 (self->active_ap);
	_g_object_unref0 (self->wifi_list);
	_g_object_unref0 (self->nm_client);
	_g_object_unref0 (self->priv->_active_wifi_item);
	_g_object_unref0 (self->blank_item);
	_g_object_unref0 (self->placeholder);
	G_OBJECT_CLASS (network_abstract_wifi_interface_parent_class)->finalize (obj);
}

GType
network_abstract_wifi_interface_get_type (void)
{
	return network_abstract_wifi_interface_type_id;
}

GType
network_abstract_wifi_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkAbstractWifiInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_abstract_wifi_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkAbstractWifiInterface), 0, (GInstanceInitFunc) network_abstract_wifi_interface_instance_init, NULL };
	network_abstract_wifi_interface_type_id = g_type_module_register_type (module, NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkAbstractWifiInterface", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	NetworkAbstractWifiInterface_private_offset = sizeof (NetworkAbstractWifiInterfacePrivate);
	return network_abstract_wifi_interface_type_id;
}

static void
_vala_network_abstract_wifi_interface_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	NetworkAbstractWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_ABSTRACT_WIFI_INTERFACE, NetworkAbstractWifiInterface);
	switch (property_id) {
		case NETWORK_ABSTRACT_WIFI_INTERFACE_ACTIVE_WIFI_ITEM_PROPERTY:
		g_value_set_object (value, network_abstract_wifi_interface_get_active_wifi_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_abstract_wifi_interface_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	NetworkAbstractWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_ABSTRACT_WIFI_INTERFACE, NetworkAbstractWifiInterface);
	switch (property_id) {
		case NETWORK_ABSTRACT_WIFI_INTERFACE_ACTIVE_WIFI_ITEM_PROPERTY:
		network_abstract_wifi_interface_set_active_wifi_item (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

