// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum keyword.yaml. DO NOT EDIT.

package keyword

import (
	"fmt"
	"iter"
)

// Keywords are special "grammar particles" recognized by Protobuf. These
// include both the reserved words listed at
// https://protobuf.com/docs/language-spec#identifiers-and-keywords, as well
// as all valid punctuation.
type Keyword byte

const (
	Unknown Keyword = iota
	Syntax
	Edition
	Import
	Weak
	Public
	Package
	Message
	Enum
	Service
	Extend
	Option
	Group
	Oneof
	Extensions
	Reserved
	RPC
	Returns
	To
	Repeated
	Optional
	Required
	Stream
	Export
	Local
	Int32
	Int64
	UInt32
	UInt64
	SInt32
	SInt64
	Fixed32
	Fixed64
	SFixed32
	SFixed64
	Float
	Double
	Bool
	String
	Bytes
	Inf
	NAN
	True
	False
	Null
	Map
	Max
	Return
	Break
	Continue
	If
	Else
	For
	In
	Switch
	Case
	Func
	And
	Or
	Not
	Default
	JsonName
	Semi
	Comma
	Dot
	Colon
	Eq
	Plus
	Minus
	Star
	Slash
	Percent
	Bang
	Ask
	ColonEq
	PlusEq
	MinusEq
	StarEq
	SlashEq
	PercentEq
	Range
	RangeEq
	LParen
	RParen
	LBracket
	RBracket
	LBrace
	RBrace
	Less
	Greater
	LessEq
	GreaterEq
	EqEq
	BangEq
	Comment
	LComment
	RComment
	AndAnd
	OrOr
	Parens
	Brackets
	Braces
	Angles
	BlockComment
)

// String implements [fmt.Stringer].
func (v Keyword) String() string {
	if int(v) < 0 || int(v) > len(_table_Keyword_String) {
		return fmt.Sprintf("Keyword(%v)", int(v))
	}
	return _table_Keyword_String[v]
}

// GoString implements [fmt.GoStringer].
func (v Keyword) GoString() string {
	if int(v) < 0 || int(v) > len(_table_Keyword_GoString) {
		return fmt.Sprintf("keyword.Keyword(%v)", int(v))
	}
	return _table_Keyword_GoString[v]
}

// Lookup looks up a keyword by name.
//
// If name does not name a keyword, returns [Unknown].
func Lookup(s string) Keyword {
	return _table_Keyword_Lookup[s]
}

// All returns an iterator over all distinct [Keyword] values.
func All() iter.Seq[Keyword] {
	return func(yield func(Keyword) bool) {
		for i := 0; i < 104; i++ {
			if !yield(Keyword(i)) {
				return
			}
		}
	}
}

var _table_Keyword_String = [...]string{
	Unknown:      "unknown",
	Syntax:       "syntax",
	Edition:      "edition",
	Import:       "import",
	Weak:         "weak",
	Public:       "public",
	Package:      "package",
	Message:      "message",
	Enum:         "enum",
	Service:      "service",
	Extend:       "extend",
	Option:       "option",
	Group:        "group",
	Oneof:        "oneof",
	Extensions:   "extensions",
	Reserved:     "reserved",
	RPC:          "rpc",
	Returns:      "returns",
	To:           "to",
	Repeated:     "repeated",
	Optional:     "optional",
	Required:     "required",
	Stream:       "stream",
	Export:       "export",
	Local:        "local",
	Int32:        "int32",
	Int64:        "int64",
	UInt32:       "uint32",
	UInt64:       "uint64",
	SInt32:       "sint32",
	SInt64:       "sint64",
	Fixed32:      "fixed32",
	Fixed64:      "fixed64",
	SFixed32:     "sfixed32",
	SFixed64:     "sfixed64",
	Float:        "float",
	Double:       "double",
	Bool:         "bool",
	String:       "string",
	Bytes:        "bytes",
	Inf:          "inf",
	NAN:          "nan",
	True:         "true",
	False:        "false",
	Null:         "null",
	Map:          "map",
	Max:          "max",
	Return:       "return",
	Break:        "break",
	Continue:     "continue",
	If:           "if",
	Else:         "else",
	For:          "for",
	In:           "in",
	Switch:       "switch",
	Case:         "case",
	Func:         "func",
	And:          "and",
	Or:           "or",
	Not:          "not",
	Default:      "default",
	JsonName:     "json_name",
	Semi:         ";",
	Comma:        ",",
	Dot:          ".",
	Colon:        ":",
	Eq:           "=",
	Plus:         "+",
	Minus:        "-",
	Star:         "*",
	Slash:        "/",
	Percent:      "%",
	Bang:         "!",
	Ask:          "?",
	ColonEq:      ":=",
	PlusEq:       "+=",
	MinusEq:      "-=",
	StarEq:       "*=",
	SlashEq:      "/=",
	PercentEq:    "%=",
	Range:        "..",
	RangeEq:      "..=",
	LParen:       "(",
	RParen:       ")",
	LBracket:     "[",
	RBracket:     "]",
	LBrace:       "{",
	RBrace:       "}",
	Less:         "<",
	Greater:      ">",
	LessEq:       "<=",
	GreaterEq:    ">=",
	EqEq:         "==",
	BangEq:       "!=",
	Comment:      "//",
	LComment:     "/*",
	RComment:     "*/",
	AndAnd:       "&&",
	OrOr:         "||",
	Parens:       "(...)",
	Brackets:     "[...]",
	Braces:       "{...}",
	Angles:       "<...>",
	BlockComment: "/*...*/",
}

var _table_Keyword_GoString = [...]string{
	Unknown:      "Unknown",
	Syntax:       "Syntax",
	Edition:      "Edition",
	Import:       "Import",
	Weak:         "Weak",
	Public:       "Public",
	Package:      "Package",
	Message:      "Message",
	Enum:         "Enum",
	Service:      "Service",
	Extend:       "Extend",
	Option:       "Option",
	Group:        "Group",
	Oneof:        "Oneof",
	Extensions:   "Extensions",
	Reserved:     "Reserved",
	RPC:          "RPC",
	Returns:      "Returns",
	To:           "To",
	Repeated:     "Repeated",
	Optional:     "Optional",
	Required:     "Required",
	Stream:       "Stream",
	Export:       "Export",
	Local:        "Local",
	Int32:        "Int32",
	Int64:        "Int64",
	UInt32:       "UInt32",
	UInt64:       "UInt64",
	SInt32:       "SInt32",
	SInt64:       "SInt64",
	Fixed32:      "Fixed32",
	Fixed64:      "Fixed64",
	SFixed32:     "SFixed32",
	SFixed64:     "SFixed64",
	Float:        "Float",
	Double:       "Double",
	Bool:         "Bool",
	String:       "String",
	Bytes:        "Bytes",
	Inf:          "Inf",
	NAN:          "NAN",
	True:         "True",
	False:        "False",
	Null:         "Null",
	Map:          "Map",
	Max:          "Max",
	Return:       "Return",
	Break:        "Break",
	Continue:     "Continue",
	If:           "If",
	Else:         "Else",
	For:          "For",
	In:           "In",
	Switch:       "Switch",
	Case:         "Case",
	Func:         "Func",
	And:          "And",
	Or:           "Or",
	Not:          "Not",
	Default:      "Default",
	JsonName:     "JsonName",
	Semi:         "Semi",
	Comma:        "Comma",
	Dot:          "Dot",
	Colon:        "Colon",
	Eq:           "Eq",
	Plus:         "Plus",
	Minus:        "Minus",
	Star:         "Star",
	Slash:        "Slash",
	Percent:      "Percent",
	Bang:         "Bang",
	Ask:          "Ask",
	ColonEq:      "ColonEq",
	PlusEq:       "PlusEq",
	MinusEq:      "MinusEq",
	StarEq:       "StarEq",
	SlashEq:      "SlashEq",
	PercentEq:    "PercentEq",
	Range:        "Range",
	RangeEq:      "RangeEq",
	LParen:       "LParen",
	RParen:       "RParen",
	LBracket:     "LBracket",
	RBracket:     "RBracket",
	LBrace:       "LBrace",
	RBrace:       "RBrace",
	Less:         "Less",
	Greater:      "Greater",
	LessEq:       "LessEq",
	GreaterEq:    "GreaterEq",
	EqEq:         "EqEq",
	BangEq:       "BangEq",
	Comment:      "Comment",
	LComment:     "LComment",
	RComment:     "RComment",
	AndAnd:       "AndAnd",
	OrOr:         "OrOr",
	Parens:       "Parens",
	Brackets:     "Brackets",
	Braces:       "Braces",
	Angles:       "Angles",
	BlockComment: "BlockComment",
}

var _table_Keyword_Lookup = map[string]Keyword{
	"unknown":    Unknown,
	"syntax":     Syntax,
	"edition":    Edition,
	"import":     Import,
	"weak":       Weak,
	"public":     Public,
	"package":    Package,
	"message":    Message,
	"enum":       Enum,
	"service":    Service,
	"extend":     Extend,
	"option":     Option,
	"group":      Group,
	"oneof":      Oneof,
	"extensions": Extensions,
	"reserved":   Reserved,
	"rpc":        RPC,
	"returns":    Returns,
	"to":         To,
	"repeated":   Repeated,
	"optional":   Optional,
	"required":   Required,
	"stream":     Stream,
	"export":     Export,
	"local":      Local,
	"int32":      Int32,
	"int64":      Int64,
	"uint32":     UInt32,
	"uint64":     UInt64,
	"sint32":     SInt32,
	"sint64":     SInt64,
	"fixed32":    Fixed32,
	"fixed64":    Fixed64,
	"sfixed32":   SFixed32,
	"sfixed64":   SFixed64,
	"float":      Float,
	"double":     Double,
	"bool":       Bool,
	"string":     String,
	"bytes":      Bytes,
	"inf":        Inf,
	"nan":        NAN,
	"true":       True,
	"false":      False,
	"null":       Null,
	"map":        Map,
	"max":        Max,
	"return":     Return,
	"break":      Break,
	"continue":   Continue,
	"if":         If,
	"else":       Else,
	"for":        For,
	"in":         In,
	"switch":     Switch,
	"case":       Case,
	"func":       Func,
	"and":        And,
	"or":         Or,
	"not":        Not,
	"default":    Default,
	"json_name":  JsonName,
	";":          Semi,
	",":          Comma,
	".":          Dot,
	":":          Colon,
	"=":          Eq,
	"+":          Plus,
	"-":          Minus,
	"*":          Star,
	"/":          Slash,
	"%":          Percent,
	"!":          Bang,
	"?":          Ask,
	":=":         ColonEq,
	"+=":         PlusEq,
	"-=":         MinusEq,
	"*=":         StarEq,
	"/=":         SlashEq,
	"%=":         PercentEq,
	"..":         Range,
	"..=":        RangeEq,
	"(":          LParen,
	")":          RParen,
	"[":          LBracket,
	"]":          RBracket,
	"{":          LBrace,
	"}":          RBrace,
	"<":          Less,
	">":          Greater,
	"<=":         LessEq,
	">=":         GreaterEq,
	"==":         EqEq,
	"!=":         BangEq,
	"//":         Comment,
	"/*":         LComment,
	"*/":         RComment,
	"&&":         AndAnd,
	"||":         OrOr,
}
var _ iter.Seq[int] // Mark iter as used.
