/* dict.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dict.vala, do not modify */

/* enchant: Dict
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gmodule.h>
#include <enchant.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef gint (*DictCheck) (EnchantDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantDict* me);
typedef gint (*DictIsWordCharacter) (EnchantDict* me, guint32 uc_in, size_t n);
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
#define _enchant_session_unref0(var) ((var == NULL) ? NULL : (var = (enchant_session_unref (var), NULL)))
#define _enchant_provider_unref0(var) ((var == NULL) ? NULL : (var = (enchant_provider_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _ParamSpecEnchantDict ParamSpecEnchantDict;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	void* user_data;
	EnchantSession* session;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantDictPrivate {
	EnchantProvider* provider;
	gchar* error;
	gchar* language_tag;
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _ParamSpecEnchantDict {
	GParamSpec parent_instance;
};

static gint EnchantDict_private_offset;
static gpointer enchant_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN EnchantDict* enchant_dict_new (EnchantProvider* provider,
                               const gchar* tag);
VALA_EXTERN EnchantDict* enchant_dict_construct (GType object_type,
                                     EnchantProvider* provider,
                                     const gchar* tag);
VALA_EXTERN const gchar* enchant_dict_get_extra_word_characters (EnchantDict* self);
VALA_EXTERN gint enchant_dict_is_word_character (EnchantDict* _self_,
                                     guint32 uc_in,
                                     size_t n);
VALA_EXTERN void enchant_dict_set_error (EnchantDict* self,
                             const gchar* err);
VALA_EXTERN const gchar* enchant_dict_get_error (EnchantDict* self);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN void enchant_dict_clear_error (EnchantDict* self);
VALA_EXTERN gboolean enchant_session_exclude (EnchantSession* self,
                                  const gchar* word);
VALA_EXTERN gboolean enchant_session_contains (EnchantSession* self,
                                   const gchar* word);
static gchar** enchant_dict_filter_suggestions (EnchantDict* self,
                                         gchar** suggs,
                                         gint suggs_length1,
                                         gint* result_length1);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
VALA_EXTERN void enchant_dict_add (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN void enchant_session_add (EnchantSession* self,
                          const gchar* word);
VALA_EXTERN gint enchant_dict_is_added (EnchantDict* self,
                            const gchar* word_buf,
                            ssize_t len);
VALA_EXTERN void enchant_dict_remove (EnchantDict* self,
                          const gchar* word_buf,
                          ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
VALA_EXTERN void enchant_session_remove (EnchantSession* self,
                             const gchar* word);
VALA_EXTERN gint enchant_dict_is_removed (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len);
VALA_EXTERN void enchant_dict_store_replacement (EnchantDict* self,
                                     const gchar* mis,
                                     ssize_t mis_len,
                                     const gchar* cor,
                                     ssize_t cor_len);
VALA_EXTERN void enchant_dict_free_string_list (EnchantDict* self,
                                    gchar** string_list);
VALA_EXTERN void enchant_dict_describe (EnchantDict* self,
                            EnchantDictDescribeFn fn,
                            void* user_data);
static void enchant_dict_finalize (EnchantDict * obj);
static GType enchant_dict_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
enchant_dict_get_instance_private (EnchantDict* self)
{
	return G_STRUCT_MEMBER_P (self, EnchantDict_private_offset);
}

static gpointer
_enchant_provider_ref0 (gpointer self)
{
#line 61 "dict.vala"
	return self ? enchant_provider_ref (self) : NULL;
#line 344 "dict.c"
}

EnchantDict*
enchant_dict_construct (GType object_type,
                        EnchantProvider* provider,
                        const gchar* tag)
{
	EnchantDict* self = NULL;
	EnchantProvider* _tmp0_;
	gchar* _tmp1_;
#line 60 "dict.vala"
	g_return_val_if_fail (tag != NULL, NULL);
#line 60 "dict.vala"
	self = (EnchantDict*) g_type_create_instance (object_type);
#line 61 "dict.vala"
	_tmp0_ = _enchant_provider_ref0 (provider);
#line 61 "dict.vala"
	_enchant_provider_unref0 (self->priv->provider);
#line 61 "dict.vala"
	self->priv->provider = _tmp0_;
#line 62 "dict.vala"
	_tmp1_ = g_strdup (tag);
#line 62 "dict.vala"
	_g_free0 (self->priv->language_tag);
#line 62 "dict.vala"
	self->priv->language_tag = _tmp1_;
#line 60 "dict.vala"
	return self;
#line 373 "dict.c"
}

EnchantDict*
enchant_dict_new (EnchantProvider* provider,
                  const gchar* tag)
{
#line 60 "dict.vala"
	return enchant_dict_construct (TYPE_ENCHANT_DICT, provider, tag);
#line 382 "dict.c"
}

const gchar*
enchant_dict_get_extra_word_characters (EnchantDict* self)
{
	const gchar* _tmp0_ = NULL;
	DictGetExtraWordCharacters _tmp1_;
	const gchar* result;
#line 70 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "dict.vala"
	_tmp1_ = self->get_extra_word_characters_method;
#line 71 "dict.vala"
	if (_tmp1_ != NULL) {
#line 397 "dict.c"
		DictGetExtraWordCharacters _tmp2_;
		const gchar* _tmp3_;
#line 72 "dict.vala"
		_tmp2_ = self->get_extra_word_characters_method;
#line 72 "dict.vala"
		_tmp3_ = _tmp2_ (self);
#line 72 "dict.vala"
		_tmp0_ = _tmp3_;
#line 406 "dict.c"
	} else {
#line 72 "dict.vala"
		_tmp0_ = "";
#line 410 "dict.c"
	}
#line 71 "dict.vala"
	result = _tmp0_;
#line 71 "dict.vala"
	return result;
#line 416 "dict.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 430 "dict.c"
}

gint
enchant_dict_is_word_character (EnchantDict* _self_,
                                guint32 uc_in,
                                size_t n)
{
	gboolean _tmp0_ = FALSE;
	gunichar uc = 0U;
	gboolean _tmp3_ = FALSE;
	GUnicodeType type = 0;
	gint result;
#line 75 "dict.vala"
	_vala_return_val_if_fail (n <= ((size_t) 2), "n <= 2", 0);
#line 78 "dict.vala"
	if (_self_ != NULL) {
#line 447 "dict.c"
		DictIsWordCharacter _tmp1_;
#line 78 "dict.vala"
		_tmp1_ = _self_->is_word_character_method;
#line 78 "dict.vala"
		_tmp0_ = _tmp1_ != NULL;
#line 453 "dict.c"
	} else {
#line 78 "dict.vala"
		_tmp0_ = FALSE;
#line 457 "dict.c"
	}
#line 78 "dict.vala"
	if (_tmp0_) {
#line 461 "dict.c"
		DictIsWordCharacter _tmp2_;
#line 79 "dict.vala"
		_tmp2_ = _self_->is_word_character_method;
#line 79 "dict.vala"
		result = _tmp2_ (_self_, uc_in, n);
#line 79 "dict.vala"
		return result;
#line 469 "dict.c"
	}
#line 81 "dict.vala"
	uc = (gunichar) uc_in;
#line 84 "dict.vala"
	if (uc == string_get_char ("'", (glong) 0)) {
#line 84 "dict.vala"
		_tmp3_ = TRUE;
#line 477 "dict.c"
	} else {
#line 84 "dict.vala"
		_tmp3_ = uc == string_get_char ("’", (glong) 0);
#line 481 "dict.c"
	}
#line 84 "dict.vala"
	if (_tmp3_) {
#line 485 "dict.c"
		gint _tmp4_ = 0;
#line 85 "dict.vala"
		if (n < ((size_t) 2)) {
#line 85 "dict.vala"
			_tmp4_ = 1;
#line 491 "dict.c"
		} else {
#line 85 "dict.vala"
			_tmp4_ = 0;
#line 495 "dict.c"
		}
#line 85 "dict.vala"
		result = _tmp4_;
#line 85 "dict.vala"
		return result;
#line 501 "dict.c"
	}
#line 87 "dict.vala"
	type = g_unichar_type (uc);
#line 89 "dict.vala"
	switch (type) {
#line 89 "dict.vala"
		case G_UNICODE_MODIFIER_LETTER:
#line 89 "dict.vala"
		case G_UNICODE_LOWERCASE_LETTER:
#line 89 "dict.vala"
		case G_UNICODE_TITLECASE_LETTER:
#line 89 "dict.vala"
		case G_UNICODE_UPPERCASE_LETTER:
#line 89 "dict.vala"
		case G_UNICODE_OTHER_LETTER:
#line 89 "dict.vala"
		case G_UNICODE_SPACING_MARK:
#line 89 "dict.vala"
		case G_UNICODE_ENCLOSING_MARK:
#line 89 "dict.vala"
		case G_UNICODE_NON_SPACING_MARK:
#line 89 "dict.vala"
		case G_UNICODE_DECIMAL_NUMBER:
#line 89 "dict.vala"
		case G_UNICODE_LETTER_NUMBER:
#line 89 "dict.vala"
		case G_UNICODE_OTHER_NUMBER:
#line 89 "dict.vala"
		case G_UNICODE_CONNECT_PUNCTUATION:
#line 531 "dict.c"
		{
#line 102 "dict.vala"
			result = 1;
#line 102 "dict.vala"
			return result;
#line 537 "dict.c"
		}
#line 89 "dict.vala"
		case G_UNICODE_DASH_PUNCTUATION:
#line 541 "dict.c"
		{
			gboolean _tmp5_ = FALSE;
#line 105 "dict.vala"
			if (n == ((size_t) 1)) {
#line 105 "dict.vala"
				_tmp5_ = type == G_UNICODE_DASH_PUNCTUATION;
#line 548 "dict.c"
			} else {
#line 105 "dict.vala"
				_tmp5_ = FALSE;
#line 552 "dict.c"
			}
#line 105 "dict.vala"
			if (_tmp5_) {
#line 106 "dict.vala"
				result = 1;
#line 106 "dict.vala"
				return result;
#line 560 "dict.c"
			}
#line 107 "dict.vala"
			result = 0;
#line 107 "dict.vala"
			return result;
#line 566 "dict.c"
		}
		default:
		{
#line 110 "dict.vala"
			result = 0;
#line 110 "dict.vala"
			return result;
#line 574 "dict.c"
		}
	}
}

void
enchant_dict_set_error (EnchantDict* self,
                        const gchar* err)
{
	gchar* _tmp0_;
#line 114 "dict.vala"
	g_return_if_fail (self != NULL);
#line 114 "dict.vala"
	g_return_if_fail (err != NULL);
#line 115 "dict.vala"
	g_debug ("dict.vala:115: enchant_dict_set_error: %s", err);
#line 116 "dict.vala"
	_tmp0_ = g_strdup (err);
#line 116 "dict.vala"
	_g_free0 (self->priv->error);
#line 116 "dict.vala"
	self->priv->error = _tmp0_;
#line 596 "dict.c"
}

const gchar*
enchant_dict_get_error (EnchantDict* self)
{
	const gchar* _tmp0_;
	const gchar* result;
#line 119 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 120 "dict.vala"
	_tmp0_ = self->priv->error;
#line 120 "dict.vala"
	result = _tmp0_;
#line 120 "dict.vala"
	return result;
#line 612 "dict.c"
}

gint
enchant_dict_check (EnchantDict* _self_,
                    const gchar* word_buf,
                    ssize_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	EnchantSession* _tmp5_;
	const gchar* _tmp6_;
	DictCheck _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint result;
#line 127 "dict.vala"
	if (_self_ == NULL) {
#line 127 "dict.vala"
		_tmp0_ = TRUE;
#line 638 "dict.c"
	} else {
#line 127 "dict.vala"
		_tmp0_ = word_buf == NULL;
#line 642 "dict.c"
	}
#line 127 "dict.vala"
	if (_tmp0_) {
#line 128 "dict.vala"
		result = -1;
#line 128 "dict.vala"
		return result;
#line 650 "dict.c"
	}
#line 129 "dict.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 129 "dict.vala"
	word = _tmp1_;
#line 130 "dict.vala"
	_tmp2_ = word;
#line 130 "dict.vala"
	if (_tmp2_ == NULL) {
#line 131 "dict.vala"
		result = -1;
#line 131 "dict.vala"
		_g_free0 (word);
#line 131 "dict.vala"
		return result;
#line 666 "dict.c"
	}
#line 133 "dict.vala"
	enchant_dict_clear_error (_self_);
#line 136 "dict.vala"
	_tmp3_ = _self_->session;
#line 136 "dict.vala"
	_tmp4_ = word;
#line 136 "dict.vala"
	if (enchant_session_exclude (_tmp3_, _tmp4_)) {
#line 137 "dict.vala"
		result = 1;
#line 137 "dict.vala"
		_g_free0 (word);
#line 137 "dict.vala"
		return result;
#line 682 "dict.c"
	}
#line 140 "dict.vala"
	_tmp5_ = _self_->session;
#line 140 "dict.vala"
	_tmp6_ = word;
#line 140 "dict.vala"
	if (enchant_session_contains (_tmp5_, _tmp6_)) {
#line 141 "dict.vala"
		result = 0;
#line 141 "dict.vala"
		_g_free0 (word);
#line 141 "dict.vala"
		return result;
#line 696 "dict.c"
	}
#line 143 "dict.vala"
	_tmp7_ = _self_->check_method;
#line 143 "dict.vala"
	_tmp8_ = word;
#line 143 "dict.vala"
	_tmp9_ = word;
#line 143 "dict.vala"
	_tmp10_ = strlen (_tmp9_);
#line 143 "dict.vala"
	_tmp11_ = _tmp10_;
#line 143 "dict.vala"
	result = _tmp7_ (_self_, _tmp8_, (size_t) _tmp11_);
#line 143 "dict.vala"
	_g_free0 (word);
#line 143 "dict.vala"
	return result;
#line 714 "dict.c"
}

static gchar**
enchant_dict_filter_suggestions (EnchantDict* self,
                                 gchar** suggs,
                                 gint suggs_length1,
                                 gint* result_length1)
{
	GStrvBuilder* sb = NULL;
	GStrvBuilder* _tmp0_;
	GStrvBuilder* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** result;
#line 148 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "dict.vala"
	_tmp0_ = g_strv_builder_new ();
#line 149 "dict.vala"
	sb = _tmp0_;
#line 737 "dict.c"
	{
		gchar** sugg_collection = NULL;
		gint sugg_collection_length1 = 0;
		gint _sugg_collection_size_ = 0;
		gint sugg_it = 0;
#line 150 "dict.vala"
		sugg_collection = suggs;
#line 150 "dict.vala"
		sugg_collection_length1 = suggs_length1;
#line 150 "dict.vala"
		for (sugg_it = 0; sugg_it < sugg_collection_length1; sugg_it = sugg_it + 1) {
#line 749 "dict.c"
			gchar* _tmp1_;
			gchar* sugg = NULL;
#line 150 "dict.vala"
			_tmp1_ = g_strdup (sugg_collection[sugg_it]);
#line 150 "dict.vala"
			sugg = _tmp1_;
#line 756 "dict.c"
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
#line 151 "dict.vala"
				_tmp4_ = sugg;
#line 151 "dict.vala"
				if (_tmp4_ != NULL) {
#line 765 "dict.c"
					const gchar* _tmp5_;
#line 151 "dict.vala"
					_tmp5_ = sugg;
#line 151 "dict.vala"
					_tmp3_ = g_utf8_validate (_tmp5_, (gssize) -1, NULL);
#line 771 "dict.c"
				} else {
#line 151 "dict.vala"
					_tmp3_ = FALSE;
#line 775 "dict.c"
				}
#line 151 "dict.vala"
				if (_tmp3_) {
#line 779 "dict.c"
					EnchantSession* _tmp6_;
					const gchar* _tmp7_;
#line 151 "dict.vala"
					_tmp6_ = self->session;
#line 151 "dict.vala"
					_tmp7_ = sugg;
#line 151 "dict.vala"
					_tmp2_ = !enchant_session_exclude (_tmp6_, _tmp7_);
#line 788 "dict.c"
				} else {
#line 151 "dict.vala"
					_tmp2_ = FALSE;
#line 792 "dict.c"
				}
#line 151 "dict.vala"
				if (_tmp2_) {
#line 796 "dict.c"
					GStrvBuilder* _tmp8_;
					const gchar* _tmp9_;
#line 152 "dict.vala"
					_tmp8_ = sb;
#line 152 "dict.vala"
					_tmp9_ = sugg;
#line 152 "dict.vala"
					g_strv_builder_add (_tmp8_, _tmp9_);
#line 805 "dict.c"
				}
#line 150 "dict.vala"
				_g_free0 (sugg);
#line 809 "dict.c"
			}
		}
	}
#line 153 "dict.vala"
	_tmp10_ = sb;
#line 153 "dict.vala"
	_tmp12_ = _tmp11_ = g_strv_builder_end (_tmp10_);
#line 153 "dict.vala"
	_tmp13_ = _tmp12_;
#line 153 "dict.vala"
	_tmp13__length1 = _vala_array_length (_tmp11_);
#line 153 "dict.vala"
	if (result_length1) {
#line 153 "dict.vala"
		*result_length1 = _tmp13__length1;
#line 825 "dict.c"
	}
#line 153 "dict.vala"
	result = _tmp13_;
#line 153 "dict.vala"
	_g_strv_builder_unref0 (sb);
#line 153 "dict.vala"
	return result;
#line 833 "dict.c"
}

gchar**
enchant_dict_suggest (EnchantDict* self,
                      const gchar* word_buf,
                      ssize_t len,
                      size_t* result_length1)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** dict_suggs = NULL;
	DictSuggest _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	size_t _tmp8_ = 0;
	gchar** _tmp9_;
	gint dict_suggs_length1;
	gint _dict_suggs_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** result;
#line 157 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 157 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, NULL);
#line 158 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 158 "dict.vala"
	word = _tmp0_;
#line 159 "dict.vala"
	_tmp1_ = word;
#line 159 "dict.vala"
	if (_tmp1_ == NULL) {
#line 872 "dict.c"
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 160 "dict.vala"
		_tmp2_ = NULL;
#line 160 "dict.vala"
		_tmp2__length1 = 0;
#line 160 "dict.vala"
		if (result_length1) {
#line 160 "dict.vala"
			*result_length1 = _tmp2__length1;
#line 883 "dict.c"
		}
#line 160 "dict.vala"
		result = _tmp2_;
#line 160 "dict.vala"
		_g_free0 (word);
#line 160 "dict.vala"
		return result;
#line 891 "dict.c"
	}
#line 162 "dict.vala"
	enchant_dict_clear_error (self);
#line 165 "dict.vala"
	_tmp3_ = self->suggest_method;
#line 165 "dict.vala"
	_tmp4_ = word;
#line 165 "dict.vala"
	_tmp5_ = word;
#line 165 "dict.vala"
	_tmp6_ = strlen (_tmp5_);
#line 165 "dict.vala"
	_tmp7_ = _tmp6_;
#line 165 "dict.vala"
	_tmp9_ = _tmp3_ (self, _tmp4_, (size_t) _tmp7_, &_tmp8_);
#line 165 "dict.vala"
	dict_suggs = _tmp9_;
#line 165 "dict.vala"
	dict_suggs_length1 = _tmp8_;
#line 165 "dict.vala"
	_dict_suggs_size_ = dict_suggs_length1;
#line 166 "dict.vala"
	_tmp10_ = dict_suggs;
#line 166 "dict.vala"
	_tmp10__length1 = dict_suggs_length1;
#line 166 "dict.vala"
	if (_tmp10_ != NULL) {
#line 919 "dict.c"
		gchar** _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_ = 0;
		gchar** _tmp13_;
#line 167 "dict.vala"
		_tmp11_ = dict_suggs;
#line 167 "dict.vala"
		_tmp11__length1 = dict_suggs_length1;
#line 167 "dict.vala"
		_tmp13_ = enchant_dict_filter_suggestions (self, _tmp11_, (gint) _tmp11__length1, &_tmp12_);
#line 167 "dict.vala"
		dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 167 "dict.vala"
		dict_suggs = _tmp13_;
#line 167 "dict.vala"
		dict_suggs_length1 = _tmp12_;
#line 167 "dict.vala"
		_dict_suggs_size_ = dict_suggs_length1;
#line 938 "dict.c"
	}
#line 169 "dict.vala"
	_tmp14_ = dict_suggs;
#line 169 "dict.vala"
	_tmp14__length1 = dict_suggs_length1;
#line 169 "dict.vala"
	if (result_length1) {
#line 169 "dict.vala"
		*result_length1 = _tmp14__length1;
#line 948 "dict.c"
	}
#line 169 "dict.vala"
	result = _tmp14_;
#line 169 "dict.vala"
	_g_free0 (word);
#line 169 "dict.vala"
	return result;
#line 956 "dict.c"
}

void
enchant_dict_add (EnchantDict* self,
                  const gchar* word_buf,
                  ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 172 "dict.vala"
	g_return_if_fail (self != NULL);
#line 172 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 173 "dict.vala"
	enchant_dict_add_to_session (self, word_buf, len);
#line 174 "dict.vala"
	_tmp0_ = self->session;
#line 174 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 174 "dict.vala"
	enchant_pwl_add (_tmp1_, word_buf, len);
#line 175 "dict.vala"
	_tmp2_ = self->session;
#line 175 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 175 "dict.vala"
	enchant_pwl_remove (_tmp3_, word_buf, len);
#line 986 "dict.c"
}

void
enchant_dict_add_to_session (EnchantDict* self,
                             const gchar* word_buf,
                             ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	const gchar* _tmp3_;
	DictAddToSession _tmp4_;
#line 178 "dict.vala"
	g_return_if_fail (self != NULL);
#line 178 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 179 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 179 "dict.vala"
	word = _tmp0_;
#line 180 "dict.vala"
	_tmp1_ = word;
#line 180 "dict.vala"
	if (_tmp1_ == NULL) {
#line 181 "dict.vala"
		_g_free0 (word);
#line 181 "dict.vala"
		return;
#line 1016 "dict.c"
	}
#line 182 "dict.vala"
	enchant_dict_clear_error (self);
#line 183 "dict.vala"
	_tmp2_ = self->session;
#line 183 "dict.vala"
	_tmp3_ = word;
#line 183 "dict.vala"
	enchant_session_add (_tmp2_, _tmp3_);
#line 184 "dict.vala"
	_tmp4_ = self->add_to_session_method;
#line 184 "dict.vala"
	if (_tmp4_ != NULL) {
#line 1030 "dict.c"
		DictAddToSession _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 185 "dict.vala"
		_tmp5_ = self->add_to_session_method;
#line 185 "dict.vala"
		_tmp6_ = word;
#line 185 "dict.vala"
		_tmp7_ = word;
#line 185 "dict.vala"
		_tmp8_ = strlen (_tmp7_);
#line 185 "dict.vala"
		_tmp9_ = _tmp8_;
#line 185 "dict.vala"
		_tmp5_ (self, _tmp6_, (size_t) _tmp9_);
#line 1048 "dict.c"
	}
#line 178 "dict.vala"
	_g_free0 (word);
#line 1052 "dict.c"
}

gint
enchant_dict_is_added (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	gint result;
#line 188 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 188 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 189 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 189 "dict.vala"
	word = _tmp0_;
#line 190 "dict.vala"
	_tmp1_ = word;
#line 190 "dict.vala"
	if (_tmp1_ == NULL) {
#line 191 "dict.vala"
		result = 0;
#line 191 "dict.vala"
		_g_free0 (word);
#line 191 "dict.vala"
		return result;
#line 1085 "dict.c"
	}
#line 192 "dict.vala"
	enchant_dict_clear_error (self);
#line 193 "dict.vala"
	_tmp3_ = self->session;
#line 193 "dict.vala"
	_tmp4_ = word;
#line 193 "dict.vala"
	if (enchant_session_contains (_tmp3_, _tmp4_)) {
#line 193 "dict.vala"
		_tmp2_ = 1;
#line 1097 "dict.c"
	} else {
#line 193 "dict.vala"
		_tmp2_ = 0;
#line 1101 "dict.c"
	}
#line 193 "dict.vala"
	result = _tmp2_;
#line 193 "dict.vala"
	_g_free0 (word);
#line 193 "dict.vala"
	return result;
#line 1109 "dict.c"
}

void
enchant_dict_remove (EnchantDict* self,
                     const gchar* word_buf,
                     ssize_t len)
{
	EnchantSession* _tmp0_;
	EnchantPWL* _tmp1_;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
#line 196 "dict.vala"
	g_return_if_fail (self != NULL);
#line 196 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 197 "dict.vala"
	enchant_dict_remove_from_session (self, word_buf, len);
#line 198 "dict.vala"
	_tmp0_ = self->session;
#line 198 "dict.vala"
	_tmp1_ = _tmp0_->pwl;
#line 198 "dict.vala"
	enchant_pwl_remove (_tmp1_, word_buf, len);
#line 199 "dict.vala"
	_tmp2_ = self->session;
#line 199 "dict.vala"
	_tmp3_ = _tmp2_->exclude_pwl;
#line 199 "dict.vala"
	enchant_pwl_add (_tmp3_, word_buf, len);
#line 1139 "dict.c"
}

void
enchant_dict_remove_from_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	EnchantSession* _tmp2_;
	const gchar* _tmp3_;
	DictRemoveFromSession _tmp4_;
#line 202 "dict.vala"
	g_return_if_fail (self != NULL);
#line 202 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 203 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 203 "dict.vala"
	word = _tmp0_;
#line 204 "dict.vala"
	_tmp1_ = word;
#line 204 "dict.vala"
	if (_tmp1_ == NULL) {
#line 205 "dict.vala"
		_g_free0 (word);
#line 205 "dict.vala"
		return;
#line 1169 "dict.c"
	}
#line 206 "dict.vala"
	enchant_dict_clear_error (self);
#line 207 "dict.vala"
	_tmp2_ = self->session;
#line 207 "dict.vala"
	_tmp3_ = word;
#line 207 "dict.vala"
	enchant_session_remove (_tmp2_, _tmp3_);
#line 208 "dict.vala"
	_tmp4_ = self->remove_from_session_method;
#line 208 "dict.vala"
	if (_tmp4_ != NULL) {
#line 1183 "dict.c"
		DictRemoveFromSession _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 209 "dict.vala"
		_tmp5_ = self->remove_from_session_method;
#line 209 "dict.vala"
		_tmp6_ = word;
#line 209 "dict.vala"
		_tmp7_ = word;
#line 209 "dict.vala"
		_tmp8_ = strlen (_tmp7_);
#line 209 "dict.vala"
		_tmp9_ = _tmp8_;
#line 209 "dict.vala"
		_tmp5_ (self, _tmp6_, (size_t) _tmp9_);
#line 1201 "dict.c"
	}
#line 202 "dict.vala"
	_g_free0 (word);
#line 1205 "dict.c"
}

gint
enchant_dict_is_removed (EnchantDict* self,
                         const gchar* word_buf,
                         ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	EnchantSession* _tmp3_;
	const gchar* _tmp4_;
	gint result;
#line 212 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 212 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 213 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 213 "dict.vala"
	word = _tmp0_;
#line 214 "dict.vala"
	_tmp1_ = word;
#line 214 "dict.vala"
	if (_tmp1_ == NULL) {
#line 215 "dict.vala"
		result = 0;
#line 215 "dict.vala"
		_g_free0 (word);
#line 215 "dict.vala"
		return result;
#line 1238 "dict.c"
	}
#line 216 "dict.vala"
	enchant_dict_clear_error (self);
#line 217 "dict.vala"
	_tmp3_ = self->session;
#line 217 "dict.vala"
	_tmp4_ = word;
#line 217 "dict.vala"
	if (enchant_session_exclude (_tmp3_, _tmp4_)) {
#line 217 "dict.vala"
		_tmp2_ = 1;
#line 1250 "dict.c"
	} else {
#line 217 "dict.vala"
		_tmp2_ = 0;
#line 1254 "dict.c"
	}
#line 217 "dict.vala"
	result = _tmp2_;
#line 217 "dict.vala"
	_g_free0 (word);
#line 217 "dict.vala"
	return result;
#line 1262 "dict.c"
}

void
enchant_dict_store_replacement (EnchantDict* self,
                                const gchar* mis,
                                ssize_t mis_len,
                                const gchar* cor,
                                ssize_t cor_len)
{
#line 221 "dict.vala"
	g_return_if_fail (self != NULL);
#line 221 "dict.vala"
	g_return_if_fail (mis != NULL);
#line 221 "dict.vala"
	g_return_if_fail (cor != NULL);
#line 1278 "dict.c"
}

void
enchant_dict_free_string_list (EnchantDict* self,
                               gchar** string_list)
{
	gchar** _tmp0_;
#line 224 "dict.vala"
	g_return_if_fail (self != NULL);
#line 225 "dict.vala"
	enchant_dict_clear_error (self);
#line 226 "dict.vala"
	_tmp0_ = string_list;
#line 226 "dict.vala"
	string_list = NULL;
#line 226 "dict.vala"
	g_strfreev ((gchar**) _tmp0_);
#line 1296 "dict.c"
}

void
enchant_dict_describe (EnchantDict* self,
                       EnchantDictDescribeFn fn,
                       void* user_data)
{
	gchar* name = NULL;
	gchar* desc = NULL;
	gchar* file = NULL;
	EnchantProvider* _tmp0_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
#line 229 "dict.vala"
	g_return_if_fail (self != NULL);
#line 229 "dict.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 232 "dict.vala"
	enchant_dict_clear_error (self);
#line 237 "dict.vala"
	_tmp0_ = self->priv->provider;
#line 237 "dict.vala"
	if (_tmp0_ != NULL) {
#line 1322 "dict.c"
		EnchantProvider* _tmp1_;
		GModule* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		EnchantProvider* _tmp5_;
		ProviderIdentify _tmp6_;
		EnchantProvider* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		EnchantProvider* _tmp10_;
		ProviderDescribe _tmp11_;
		EnchantProvider* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
#line 238 "dict.vala"
		_tmp1_ = self->priv->provider;
#line 238 "dict.vala"
		_tmp2_ = _tmp1_->module;
#line 238 "dict.vala"
		_tmp3_ = g_module_name (_tmp2_);
#line 238 "dict.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 238 "dict.vala"
		_g_free0 (file);
#line 238 "dict.vala"
		file = _tmp4_;
#line 239 "dict.vala"
		_tmp5_ = self->priv->provider;
#line 239 "dict.vala"
		_tmp6_ = _tmp5_->identify;
#line 239 "dict.vala"
		_tmp7_ = self->priv->provider;
#line 239 "dict.vala"
		_tmp8_ = _tmp6_ (_tmp7_);
#line 239 "dict.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 239 "dict.vala"
		_g_free0 (name);
#line 239 "dict.vala"
		name = _tmp9_;
#line 240 "dict.vala"
		_tmp10_ = self->priv->provider;
#line 240 "dict.vala"
		_tmp11_ = _tmp10_->describe;
#line 240 "dict.vala"
		_tmp12_ = self->priv->provider;
#line 240 "dict.vala"
		_tmp13_ = _tmp11_ (_tmp12_);
#line 240 "dict.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 240 "dict.vala"
		_g_free0 (desc);
#line 240 "dict.vala"
		desc = _tmp14_;
#line 1377 "dict.c"
	} else {
		EnchantSession* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
#line 242 "dict.vala"
		_tmp15_ = self->session;
#line 242 "dict.vala"
		_tmp16_ = _tmp15_->personal_filename;
#line 242 "dict.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 242 "dict.vala"
		_g_free0 (file);
#line 242 "dict.vala"
		file = _tmp17_;
#line 243 "dict.vala"
		_tmp18_ = g_strdup ("Personal Wordlist");
#line 243 "dict.vala"
		_g_free0 (name);
#line 243 "dict.vala"
		name = _tmp18_;
#line 244 "dict.vala"
		_tmp19_ = g_strdup ("Personal Wordlist");
#line 244 "dict.vala"
		_g_free0 (desc);
#line 244 "dict.vala"
		desc = _tmp19_;
#line 1406 "dict.c"
	}
#line 247 "dict.vala"
	_tmp20_ = self->priv->language_tag;
#line 247 "dict.vala"
	_tmp21_ = name;
#line 247 "dict.vala"
	_tmp22_ = desc;
#line 247 "dict.vala"
	_tmp23_ = file;
#line 247 "dict.vala"
	fn (_tmp20_, _tmp21_, _tmp22_, _tmp23_, user_data);
#line 229 "dict.vala"
	_g_free0 (file);
#line 229 "dict.vala"
	_g_free0 (desc);
#line 229 "dict.vala"
	_g_free0 (name);
#line 1424 "dict.c"
}

void
enchant_dict_clear_error (EnchantDict* self)
{
#line 250 "dict.vala"
	g_return_if_fail (self != NULL);
#line 251 "dict.vala"
	_g_free0 (self->priv->error);
#line 251 "dict.vala"
	self->priv->error = NULL;
#line 1436 "dict.c"
}

static void
value_enchant_dict_init (GValue* value)
{
#line 45 "dict.vala"
	value->data[0].v_pointer = NULL;
#line 1444 "dict.c"
}

static void
value_enchant_dict_free_value (GValue* value)
{
#line 45 "dict.vala"
	if (value->data[0].v_pointer) {
#line 45 "dict.vala"
		enchant_dict_unref (value->data[0].v_pointer);
#line 1454 "dict.c"
	}
}

static void
value_enchant_dict_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 45 "dict.vala"
	if (src_value->data[0].v_pointer) {
#line 45 "dict.vala"
		dest_value->data[0].v_pointer = enchant_dict_ref (src_value->data[0].v_pointer);
#line 1466 "dict.c"
	} else {
#line 45 "dict.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1470 "dict.c"
	}
}

static gpointer
value_enchant_dict_peek_pointer (const GValue* value)
{
#line 45 "dict.vala"
	return value->data[0].v_pointer;
#line 1479 "dict.c"
}

static gchar*
value_enchant_dict_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 45 "dict.vala"
	if (collect_values[0].v_pointer) {
#line 1490 "dict.c"
		EnchantDict * object;
		object = collect_values[0].v_pointer;
#line 45 "dict.vala"
		if (object->parent_instance.g_class == NULL) {
#line 45 "dict.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1497 "dict.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 45 "dict.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1501 "dict.c"
		}
#line 45 "dict.vala"
		value->data[0].v_pointer = enchant_dict_ref (object);
#line 1505 "dict.c"
	} else {
#line 45 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1509 "dict.c"
	}
#line 45 "dict.vala"
	return NULL;
#line 1513 "dict.c"
}

static gchar*
value_enchant_dict_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	EnchantDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 45 "dict.vala"
	if (!object_p) {
#line 45 "dict.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1528 "dict.c"
	}
#line 45 "dict.vala"
	if (!value->data[0].v_pointer) {
#line 45 "dict.vala"
		*object_p = NULL;
#line 1534 "dict.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 45 "dict.vala"
		*object_p = value->data[0].v_pointer;
#line 1538 "dict.c"
	} else {
#line 45 "dict.vala"
		*object_p = enchant_dict_ref (value->data[0].v_pointer);
#line 1542 "dict.c"
	}
#line 45 "dict.vala"
	return NULL;
#line 1546 "dict.c"
}

GParamSpec*
param_spec_enchant_dict (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecEnchantDict* spec;
#line 45 "dict.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_DICT), NULL);
#line 45 "dict.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 45 "dict.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 45 "dict.vala"
	return G_PARAM_SPEC (spec);
#line 1565 "dict.c"
}

gpointer
value_get_enchant_dict (const GValue* value)
{
#line 45 "dict.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT), NULL);
#line 45 "dict.vala"
	return value->data[0].v_pointer;
#line 1575 "dict.c"
}

void
value_set_enchant_dict (GValue* value,
                        gpointer v_object)
{
	EnchantDict * old;
#line 45 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 45 "dict.vala"
	old = value->data[0].v_pointer;
#line 45 "dict.vala"
	if (v_object) {
#line 45 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 45 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 45 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 45 "dict.vala"
		enchant_dict_ref (value->data[0].v_pointer);
#line 1597 "dict.c"
	} else {
#line 45 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1601 "dict.c"
	}
#line 45 "dict.vala"
	if (old) {
#line 45 "dict.vala"
		enchant_dict_unref (old);
#line 1607 "dict.c"
	}
}

void
value_take_enchant_dict (GValue* value,
                         gpointer v_object)
{
	EnchantDict * old;
#line 45 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 45 "dict.vala"
	old = value->data[0].v_pointer;
#line 45 "dict.vala"
	if (v_object) {
#line 45 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 45 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 45 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 1628 "dict.c"
	} else {
#line 45 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1632 "dict.c"
	}
#line 45 "dict.vala"
	if (old) {
#line 45 "dict.vala"
		enchant_dict_unref (old);
#line 1638 "dict.c"
	}
}

static void
enchant_dict_class_init (EnchantDictClass * klass,
                         gpointer klass_data)
{
#line 45 "dict.vala"
	enchant_dict_parent_class = g_type_class_peek_parent (klass);
#line 45 "dict.vala"
	((EnchantDictClass *) klass)->finalize = enchant_dict_finalize;
#line 45 "dict.vala"
	g_type_class_adjust_private_offset (klass, &EnchantDict_private_offset);
#line 1652 "dict.c"
}

static void
enchant_dict_instance_init (EnchantDict * self,
                            gpointer klass)
{
#line 45 "dict.vala"
	self->priv = enchant_dict_get_instance_private (self);
#line 45 "dict.vala"
	self->ref_count = 1;
#line 1663 "dict.c"
}

static void
enchant_dict_finalize (EnchantDict * obj)
{
	EnchantDict * self;
	EnchantProvider* _tmp0_;
#line 45 "dict.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_DICT, EnchantDict);
#line 45 "dict.vala"
	g_signal_handlers_destroy (self);
#line 66 "dict.vala"
	_tmp0_ = self->priv->provider;
#line 66 "dict.vala"
	if (_tmp0_ != NULL) {
#line 1679 "dict.c"
		EnchantProvider* _tmp1_;
		ProviderDisposeDict _tmp2_;
		EnchantProvider* _tmp3_;
#line 67 "dict.vala"
		_tmp1_ = self->priv->provider;
#line 67 "dict.vala"
		_tmp2_ = _tmp1_->dispose_dict;
#line 67 "dict.vala"
		_tmp3_ = self->priv->provider;
#line 67 "dict.vala"
		_tmp2_ (_tmp3_, self);
#line 1691 "dict.c"
	}
#line 47 "dict.vala"
	_enchant_session_unref0 (self->session);
#line 48 "dict.vala"
	_enchant_provider_unref0 (self->priv->provider);
#line 49 "dict.vala"
	_g_free0 (self->priv->error);
#line 50 "dict.vala"
	_g_free0 (self->priv->language_tag);
#line 1701 "dict.c"
}

static GType
enchant_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_dict_init, value_enchant_dict_free_value, value_enchant_dict_copy_value, value_enchant_dict_peek_pointer, "p", value_enchant_dict_collect_value, "p", value_enchant_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantDict), 0, (GInstanceInitFunc) enchant_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_dict_type_id;
	enchant_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	EnchantDict_private_offset = g_type_add_instance_private (enchant_dict_type_id, sizeof (EnchantDictPrivate));
	return enchant_dict_type_id;
}

GType
enchant_dict_get_type (void)
{
	static volatile gsize enchant_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_dict_type_id__once)) {
		GType enchant_dict_type_id;
		enchant_dict_type_id = enchant_dict_get_type_once ();
		g_once_init_leave (&enchant_dict_type_id__once, enchant_dict_type_id);
	}
	return enchant_dict_type_id__once;
}

gpointer
enchant_dict_ref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 45 "dict.vala"
	g_atomic_int_inc (&self->ref_count);
#line 45 "dict.vala"
	return instance;
#line 1737 "dict.c"
}

void
enchant_dict_unref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 45 "dict.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 45 "dict.vala"
		ENCHANT_DICT_GET_CLASS (self)->finalize (self);
#line 45 "dict.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1751 "dict.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

