/* THIS FILE IS AUTOGENERATED FROM AudioNode.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "AudioNodeBinding.h"
#include "EventTargetBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/dom/AudioContext.h"
#include "mozilla/dom/AudioNode.h"
#include "mozilla/dom/AudioParam.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<ChannelCountMode>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ChannelCountMode aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<ChannelCountMode>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<ChannelCountMode>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<ChannelCountMode>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<ChannelInterpretation>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ChannelInterpretation aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<ChannelInterpretation>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<ChannelInterpretation>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<ChannelInterpretation>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



AudioNodeOptions::AudioNodeOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
AudioNodeOptions::InitIds(JSContext* cx, AudioNodeOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->channelInterpretation_id.init(cx, "channelInterpretation") ||
      !atomsCache->channelCountMode_id.init(cx, "channelCountMode") ||
      !atomsCache->channelCount_id.init(cx, "channelCount")) {
    return false;
  }
  return true;
}

bool
AudioNodeOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  AudioNodeOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<AudioNodeOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->channelCount_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mChannelCount.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'channelCount' member of AudioNodeOptions", &(mChannelCount.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->channelCountMode_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mChannelCountMode.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ChannelCountMode>::Values,
                                                                         "ChannelCountMode", "'channelCountMode' member of AudioNodeOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mChannelCountMode.Value()) = static_cast<ChannelCountMode>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->channelInterpretation_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mChannelInterpretation.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ChannelInterpretation>::Values,
                                                                         "ChannelInterpretation", "'channelInterpretation' member of AudioNodeOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mChannelInterpretation.Value()) = static_cast<ChannelInterpretation>(index);
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
AudioNodeOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
AudioNodeOptions::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  AudioNodeOptionsAtoms* atomsCache = GetAtomCache<AudioNodeOptionsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mChannelCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mChannelCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->channelCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mChannelCountMode.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      ChannelCountMode const & currentValue = mChannelCountMode.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->channelCountMode_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mChannelInterpretation.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      ChannelInterpretation const & currentValue = mChannelInterpretation.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->channelInterpretation_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
AudioNodeOptions::TraceDictionary(JSTracer* trc)
{
}

AudioNodeOptions&
AudioNodeOptions::operator=(const AudioNodeOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mChannelCount.Reset();
  if (aOther.mChannelCount.WasPassed()) {
    mChannelCount.Construct(aOther.mChannelCount.Value());
  }
  mChannelCountMode.Reset();
  if (aOther.mChannelCountMode.WasPassed()) {
    mChannelCountMode.Construct(aOther.mChannelCountMode.Value());
  }
  mChannelInterpretation.Reset();
  if (aOther.mChannelInterpretation.WasPassed()) {
    mChannelInterpretation.Construct(aOther.mChannelInterpretation.Value());
  }
  return *this;
}


namespace AudioNode_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<EventTarget_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
connect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "AudioNode.connect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "connect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 1: {
      [[fallthrough]];
    }
    case 2: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::AudioNode> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::AudioNode, mozilla::dom::AudioNode>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          uint32_t arg1;
          if (args.hasDefined(1)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
              return false;
            }
          } else {
            arg1 = 0U;
          }
          uint32_t arg2;
          if (args.hasDefined(2)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
              return false;
            }
          } else {
            arg2 = 0U;
          }
          FastErrorResult rv;
          auto result(StrongOrRawPtr<mozilla::dom::AudioNode>(MOZ_KnownLive(self)->Connect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv)));
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.connect"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            return false;
          }
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::AudioParam> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::AudioParam, mozilla::dom::AudioParam>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          uint32_t arg1;
          if (args.hasDefined(1)) {
            if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
              return false;
            }
          } else {
            arg1 = 0U;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Connect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->Connect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.connect"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      return cx.ThrowErrorMessage<MSG_OVERLOAD_RESOLUTION_FAILED>("1", "2");
      break;
    }
    case 3: {
      NonNull<mozilla::dom::AudioNode> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::AudioNode, mozilla::dom::AudioNode>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "AudioNode");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      uint32_t arg1;
      if (args.hasDefined(1)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
          return false;
        }
      } else {
        arg1 = 0U;
      }
      uint32_t arg2;
      if (args.hasDefined(2)) {
        if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
          return false;
        }
      } else {
        arg2 = 0U;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::AudioNode>(MOZ_KnownLive(self)->Connect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.connect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo connect_methodinfo = {
  { (JSJitGetterOp)connect },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
disconnect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "AudioNode.disconnect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "disconnect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 0: {
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Disconnect(rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::AudioNode> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::AudioNode, mozilla::dom::AudioNode>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::AudioParam> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::AudioParam, mozilla::dom::AudioParam>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      uint32_t arg0;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(arg0, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Disconnect(arg0, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::AudioNode> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::AudioNode, mozilla::dom::AudioNode>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          uint32_t arg1;
          if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
            return false;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
        do {
          NonNull<mozilla::dom::AudioParam> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::AudioParam, mozilla::dom::AudioParam>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          uint32_t arg1;
          if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
            return false;
          }
          FastErrorResult rv;
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv))>, "Should be returning void here");
          MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, rv);
          if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
            return false;
          }
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      return cx.ThrowErrorMessage<MSG_OVERLOAD_RESOLUTION_FAILED>("1", "2");
      break;
    }
    case 3: {
      NonNull<mozilla::dom::AudioNode> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::AudioNode, mozilla::dom::AudioNode>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "AudioNode");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      uint32_t arg1;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      uint32_t arg2;
      if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->Disconnect(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.disconnect"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo disconnect_methodinfo = {
  { (JSJitGetterOp)disconnect },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_context(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "context", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::AudioContext>(MOZ_KnownLive(self)->Context()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo context_getterinfo = {
  { get_context },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_numberOfInputs(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "numberOfInputs", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->NumberOfInputs());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo numberOfInputs_getterinfo = {
  { get_numberOfInputs },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_numberOfOutputs(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "numberOfOutputs", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->NumberOfOutputs());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo numberOfOutputs_getterinfo = {
  { get_numberOfOutputs },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_channelCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "channelCount", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->ChannelCount());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_channelCount(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "channelCount", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetChannelCount(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetChannelCount(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.channelCount setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo channelCount_getterinfo = {
  { get_channelCount },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo channelCount_setterinfo = {
  { (JSJitGetterOp)set_channelCount },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_channelCountMode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "channelCountMode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  ChannelCountMode result(MOZ_KnownLive(self)->ChannelCountModeValue());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_channelCountMode(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "AudioNode.channelCountMode setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "channelCountMode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  ChannelCountMode arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<ChannelCountMode>::Values,
                                                                       "ChannelCountMode", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<ChannelCountMode>(index);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetChannelCountModeValue(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetChannelCountModeValue(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.channelCountMode setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo channelCountMode_getterinfo = {
  { get_channelCountMode },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo channelCountMode_setterinfo = {
  { (JSJitGetterOp)set_channelCountMode },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_channelInterpretation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "channelInterpretation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  ChannelInterpretation result(MOZ_KnownLive(self)->ChannelInterpretationValue());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_channelInterpretation(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "AudioNode.channelInterpretation setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "channelInterpretation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  ChannelInterpretation arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<ChannelInterpretation>::Values,
                                                                       "ChannelInterpretation", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<ChannelInterpretation>(index);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetChannelInterpretationValue(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetChannelInterpretationValue(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "AudioNode.channelInterpretation setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo channelInterpretation_getterinfo = {
  { get_channelInterpretation },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo channelInterpretation_setterinfo = {
  { (JSJitGetterOp)set_channelInterpretation },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_id(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "AudioNode", "id", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::AudioNode*>(void_self);
  uint32_t result(MOZ_KnownLive(self)->Id());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo id_getterinfo = {
  { get_id },
  { prototypes::id::AudioNode },
  { PrototypeTraits<prototypes::id::AudioNode>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("connect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&connect_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("disconnect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&disconnect_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("context", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &context_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("numberOfInputs", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &numberOfInputs_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("numberOfOutputs", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &numberOfOutputs_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("channelCount", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &channelCount_getterinfo, GenericSetter<NormalThisPolicy>, &channelCount_setterinfo),
  JSPropertySpec::nativeAccessors("channelCountMode", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &channelCountMode_getterinfo, GenericSetter<NormalThisPolicy>, &channelCountMode_setterinfo),
  JSPropertySpec::nativeAccessors("channelInterpretation", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &channelInterpretation_getterinfo, GenericSetter<NormalThisPolicy>, &channelInterpretation_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(6 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("id", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &id_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { nullptr, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[8];
static PropertyInfo sNativeProperties_propertyInfos[8];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  8,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[2] }
  }
};
static_assert(8 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::AudioNode,
  constructors::id::AudioNode,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  EventTarget_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::AudioNode>::Depth,
  prototypes::id::AudioNode,
  true,
  0,
  "AudioNode",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "AudioNodePrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::AudioNode,
  PrototypeTraits<prototypes::id::AudioNode>::Depth,
  &sNativePropertyHooks,
  EventTarget_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::dom_webaudio_enabled();
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::AudioNode);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::AudioNode);

  JS::Handle<JSObject*> parentProto(EventTarget_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(EventTarget_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "AudioNode",
                              ShouldExpose<AudioNode_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::AudioNode,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JSObject*
GetProtoObject(JSContext* aCx)
{
  return GetProtoObjectHandle(aCx);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::AudioNode,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace AudioNode_Binding



} // namespace dom


} // namespace mozilla
