/* THIS FILE IS AUTOGENERATED FROM RTCSessionDescription.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "RTCSessionDescriptionBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_media.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsIGlobalObject.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCSdpType>::Values[4];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCSdpType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCSdpType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCSdpType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCSdpType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



RTCLocalSessionDescriptionInit::RTCLocalSessionDescriptionInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCLocalSessionDescriptionInit::InitIds(JSContext* cx, RTCLocalSessionDescriptionInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->sdp_id.init(cx, "sdp")) {
    return false;
  }
  return true;
}

bool
RTCLocalSessionDescriptionInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCLocalSessionDescriptionInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCLocalSessionDescriptionInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->sdp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mSdp)) {
      return false;
    }
  } else {
    mSdp.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mType.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RTCSdpType>::Values,
                                                                         "RTCSdpType", "'type' member of RTCLocalSessionDescriptionInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mType.Value()) = static_cast<RTCSdpType>(index);
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCLocalSessionDescriptionInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCLocalSessionDescriptionInit::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCLocalSessionDescriptionInitAtoms* atomsCache = GetAtomCache<RTCLocalSessionDescriptionInitAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mSdp;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sdp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mType.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCSdpType const & currentValue = mType.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCLocalSessionDescriptionInit::TraceDictionary(JSTracer* trc)
{
}

RTCLocalSessionDescriptionInit&
RTCLocalSessionDescriptionInit::operator=(const RTCLocalSessionDescriptionInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mSdp = aOther.mSdp;
  mType.Reset();
  if (aOther.mType.WasPassed()) {
    mType.Construct(aOther.mType.Value());
  }
  return *this;
}



RTCSessionDescriptionInit::RTCSessionDescriptionInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCSessionDescriptionInit::InitIds(JSContext* cx, RTCSessionDescriptionInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->sdp_id.init(cx, "sdp")) {
    return false;
  }
  return true;
}

bool
RTCSessionDescriptionInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCSessionDescriptionInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCSessionDescriptionInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->sdp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mSdp)) {
      return false;
    }
  } else {
    mSdp.AssignLiteral(u"");
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RTCSdpType>::Values,
                                                                         "RTCSdpType", "'type' member of RTCSessionDescriptionInit",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mType = static_cast<RTCSdpType>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'type' member of RTCSessionDescriptionInit");
  }
  return true;
}

bool
RTCSessionDescriptionInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCSessionDescriptionInit::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCSessionDescriptionInitAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionInitAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mSdp;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sdp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    RTCSdpType const & currentValue = mType;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCSessionDescriptionInit::TraceDictionary(JSTracer* trc)
{
}

RTCSessionDescriptionInit&
RTCSessionDescriptionInit::operator=(const RTCSessionDescriptionInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mSdp = aOther.mSdp;
  mType = aOther.mType;
  return *this;
}


namespace RTCSessionDescription_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get_type(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCSessionDescription", "type", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCSessionDescription*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RTCSdpType result(MOZ_KnownLive(self)->GetType(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCSessionDescription.type getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_type(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "RTCSessionDescription.type setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCSessionDescription", "type", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCSessionDescription*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RTCSdpType arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<RTCSdpType>::Values,
                                                                       "RTCSdpType", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<RTCSdpType>(index);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetType(arg0, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetType(arg0, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCSessionDescription.type setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo type_getterinfo = {
  { get_type },
  { prototypes::id::RTCSessionDescription },
  { PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo type_setterinfo = {
  { (JSJitGetterOp)set_type },
  { prototypes::id::RTCSessionDescription },
  { PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_sdp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCSessionDescription", "sdp", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCSessionDescription*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSdp(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSdp(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCSessionDescription.sdp getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_sdp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCSessionDescription", "sdp", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCSessionDescription*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetSdp(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetSdp(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCSessionDescription.sdp setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo sdp_getterinfo = {
  { get_sdp },
  { prototypes::id::RTCSessionDescription },
  { PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo sdp_setterinfo = {
  { (JSJitGetterOp)set_sdp },
  { prototypes::id::RTCSessionDescription },
  { PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
toJSON(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCSessionDescription", "toJSON", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCSessionDescription*>(void_self);
  JS::Rooted<JSObject*> result(cx, JS_NewPlainObject(cx));
  if (!result) {
    return false;
  }
  if (!RTCSessionDescription_Binding::CollectJSONAttributes(cx, obj, MOZ_KnownLive(self), result)) {
    return false;
  }
  args.rval().setObject(*result);
  return true;
}

static const JSJitInfo toJSON_methodinfo = {
  { (JSJitGetterOp)toJSON },
  { prototypes::id::RTCSessionDescription },
  { PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::RTCSessionDescription* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::RTCSessionDescription>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::RTCSessionDescription>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sChromeStaticMethods_specs[] = {
  JS_FNSPEC("_create", RTCSessionDescription::_Create, nullptr, 2, 0, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeStaticMethods[] = {
  { nullptr, &sChromeStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("toJSON", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&toJSON_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("type", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &type_getterinfo, GenericSetter<NormalThisPolicy>, &type_setterinfo),
  JSPropertySpec::nativeAccessors("sdp", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &sdp_getterinfo, GenericSetter<NormalThisPolicy>, &sdp_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(2 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  true,  0 /* sChromeStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeStaticMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

MOZ_CAN_RUN_SCRIPT bool
CollectJSONAttributes(JSContext* cx, JS::Handle<JSObject*> obj, mozilla::dom::RTCSessionDescription* self, JS::Rooted<JSObject*>& result)
{
  { // scope for "temp"
    JS::Rooted<JS::Value> temp(cx);
    if (!get_type(cx, obj, self, JSJitGetterCallArgs(&temp))) {
      return false;
    }
    if (!JS_DefineProperty(cx, result, "type", temp, JSPROP_ENUMERATE)) {
      return false;
    }
  }
  { // scope for "temp"
    JS::Rooted<JS::Value> temp(cx);
    if (!get_sdp(cx, obj, self, JSJitGetterCallArgs(&temp))) {
      return false;
    }
    if (!JS_DefineProperty(cx, result, "sdp", temp, JSPROP_ENUMERATE)) {
      return false;
    }
  }
  return true;
}

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::RTCSessionDescription,
  constructors::id::RTCSessionDescription,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "RTCSessionDescription constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCSessionDescription", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "RTCSessionDescription");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::RTCSessionDescription,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "RTCSessionDescription constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FastRTCSessionDescriptionInit arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(mozilla::dom::RTCSessionDescription::Constructor(global, cx, Constify(arg0), rv, desiredProto)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCSessionDescription constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth,
  prototypes::id::RTCSessionDescription,
  true,
  1,
  "RTCSessionDescription",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "RTCSessionDescriptionPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::RTCSessionDescription,
  PrototypeTraits<prototypes::id::RTCSessionDescription>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::media_peerconnection_enabled();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "RTCSessionDescription",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::RTCSessionDescription>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::RTCSessionDescription, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::RTCSessionDescription>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::RTCSessionDescription>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::RTCSessionDescription>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::RTCSessionDescription>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::RTCSessionDescription* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::RTCSessionDescription>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::RTCSessionDescription*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::RTCSessionDescription> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::RTCSessionDescription);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::RTCSessionDescription);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "RTCSessionDescription",
                              ShouldExpose<RTCSessionDescription_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::RTCSessionDescription,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::RTCSessionDescription,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace RTCSessionDescription_Binding



void
RTCSessionDescriptionJSImpl::ToJSON(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCSessionDescription.toJSON", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCSessionDescriptionAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->toJSON_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  JS::Rooted<JSObject*> rvalDecl(cx);
  if (rval.isObject()) {
#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunreachable-code-return"
#endif // __clang__
    if ((false) && !CallerSubsumes(rval)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("return value of RTCSessionDescription.toJSON");
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
    rvalDecl = &rval.toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCSessionDescription.toJSON");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal.set(rvalDecl);
}

void
RTCSessionDescriptionJSImpl::__Init(const RTCSessionDescriptionInit& descriptionInitDict, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "__init", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!descriptionInitDict.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCSessionDescriptionAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->__init_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

bool
RTCSessionDescriptionJSImpl::InitIds(JSContext* cx, RTCSessionDescriptionAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->__init_id.init(cx, "__init") ||
      !atomsCache->toJSON_id.init(cx, "toJSON") ||
      !atomsCache->sdp_id.init(cx, "sdp") ||
      !atomsCache->type_id.init(cx, "type")) {
    return false;
  }
  return true;
}


RTCSdpType
RTCSessionDescriptionJSImpl::GetType(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCSessionDescription.type", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return RTCSdpType(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCSessionDescriptionAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->type_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return RTCSdpType(0);
  }
  RTCSdpType rvalDecl;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, rval,
                                                                       binding_detail::EnumStrings<RTCSdpType>::Values,
                                                                       "RTCSdpType", "return value of RTCSessionDescription.type",
                                                                       &index)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return RTCSdpType(0);
    }
    MOZ_ASSERT(index >= 0);
    rvalDecl = static_cast<RTCSdpType>(index);
  }
  return rvalDecl;
}

void
RTCSessionDescriptionJSImpl::GetSdp(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCSessionDescription.sdp", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCSessionDescriptionAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->sdp_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  binding_detail::FakeString<char16_t> rvalDecl;
  if (!ConvertJSValueToString(cx, rval, eStringify, eStringify, rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = rvalDecl;
}

void
RTCSessionDescriptionJSImpl::SetType(RTCSdpType arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCSessionDescription.type", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (!ToJSValue(cx, arg, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCSessionDescriptionAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->type_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCSessionDescriptionJSImpl::SetSdp(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCSessionDescription.sdp", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, arg, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCSessionDescriptionAtoms* atomsCache = GetAtomCache<RTCSessionDescriptionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->sdp_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}


NS_IMPL_CYCLE_COLLECTION_WRAPPERCACHE_CLASS(RTCSessionDescription)
NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN(RTCSessionDescription)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mImpl)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mParent)
  NS_IMPL_CYCLE_COLLECTION_UNLINK_PRESERVED_WRAPPER
  tmp->ClearWeakReferences();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN(RTCSessionDescription)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mImpl)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mParent)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END
NS_IMPL_CYCLE_COLLECTING_ADDREF(RTCSessionDescription)
NS_IMPL_CYCLE_COLLECTING_RELEASE(RTCSessionDescription)
NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(RTCSessionDescription)
  NS_WRAPPERCACHE_INTERFACE_MAP_ENTRY
  NS_INTERFACE_MAP_ENTRY(nsISupports)
  NS_INTERFACE_MAP_ENTRY(nsISupportsWeakReference)
NS_INTERFACE_MAP_END

RTCSessionDescription::RTCSessionDescription(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent)
  : mImpl(new RTCSessionDescriptionJSImpl(nullptr, aJSImplObject, aJSImplGlobal, /* aIncumbentGlobal = */ nullptr)),
    mParent(aParent)
{
}


RTCSessionDescription::~RTCSessionDescription()
{
}

nsISupports*
RTCSessionDescription::GetParentObject() const
{
  return mParent;
}

JSObject*
RTCSessionDescription::WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  JS::Rooted<JSObject*> obj(aCx, RTCSessionDescription_Binding::Wrap(aCx, this, aGivenProto));
  if (!obj) {
    return nullptr;
  }

  // Now define it on our chrome object
  JSAutoRealm ar(aCx, mImpl->CallbackGlobalOrNull());
  if (!JS_WrapObject(aCx, &obj)) {
    return nullptr;
  }
  JS::Rooted<JSObject*> callback(aCx, mImpl->CallbackOrNull());
  if (!JS_DefineProperty(aCx, callback, "__DOM_IMPL__", obj, 0)) {
    return nullptr;
  }
  return obj;
}

already_AddRefed<RTCSessionDescription>
RTCSessionDescription::Constructor(const GlobalObject& global, JSContext* cx, const RTCSessionDescriptionInit& descriptionInitDict, ErrorResult& aRv, JS::Handle<JSObject*> aGivenProto)
{
  RefPtr<RTCSessionDescription> impl =
    ConstructJSImplementation<RTCSessionDescription>("@mozilla.org/dom/rtcsessiondescription;1", global, aRv);
  if (aRv.Failed()) {
    return nullptr;
  }
  // Wrap the object before calling __Init so that __DOM_IMPL__ is available.
  JS::Rooted<JSObject*> scopeObj(cx, global.Get());
  MOZ_ASSERT(js::IsObjectInContextCompartment(scopeObj, cx));
  JS::Rooted<JS::Value> wrappedVal(cx);
  if (!GetOrCreateDOMReflector(cx, impl, &wrappedVal, aGivenProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  // Initialize the object with the constructor arguments.
  impl->mImpl->__Init(descriptionInitDict, aRv, js::GetNonCCWObjectRealm(scopeObj));
  if (aRv.Failed()) {
    return nullptr;
  }
  return impl.forget();
}

RTCSdpType
RTCSessionDescription::GetType(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetType(aRv, aRealm);
}

void
RTCSessionDescription::SetType(RTCSdpType arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetType(arg, aRv, aRealm);
}

void
RTCSessionDescription::GetSdp(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetSdp(aRetVal, aRv, aRealm);
}

void
RTCSessionDescription::SetSdp(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetSdp(arg, aRv, aRealm);
}

void
RTCSessionDescription::ToJSON(JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->ToJSON(aRetVal, aRv, aRealm);
}

bool
RTCSessionDescription::_Create(JSContext* cx, unsigned argc, JS::Value* vp)
{
  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  if (!args.requireAtLeast(cx, "RTCSessionDescription._create", 2)) {
    return false;
  }
  BindingCallContext callCx(cx, "RTCSessionDescription._create");
  if (!args[0].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
  }
  if (!args[1].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
  }

  // GlobalObject will go through wrappers as needed for us, and
  // is simpler than the right UnwrapArg incantation.
  GlobalObject global(cx, &args[0].toObject());
  if (global.Failed()) {
    return false;
  }
  nsCOMPtr<nsIGlobalObject> globalHolder = do_QueryInterface(global.GetAsSupports());
  MOZ_ASSERT(globalHolder);
  JS::Rooted<JSObject*> arg(cx, &args[1].toObject());
  JS::Rooted<JSObject*> argGlobal(cx, JS::CurrentGlobalOrNull(cx));
  RefPtr<RTCSessionDescription> impl = new RTCSessionDescription(arg, argGlobal, globalHolder);
  MOZ_ASSERT(js::IsObjectInContextCompartment(arg, cx));
  return GetOrCreateDOMReflector(cx, impl, args.rval());
}


} // namespace dom


} // namespace mozilla
