/* abstract-field-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from abstract-field-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_ABSTRACT_FIELD_DETAILS_0_PROPERTY,
	FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE,
	FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC,
	FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC,
	FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_PROPERTY,
	FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE_PROPERTY,
	FOLKS_ABSTRACT_FIELD_DETAILS_ID_PROPERTY,
	FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS_PROPERTY,
	FOLKS_ABSTRACT_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksAbstractFieldDetailsPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gpointer _value;
	gchar* _id;
	GeeMultiMap* _parameters;
};

static gint FolksAbstractFieldDetails_private_offset;
static gpointer folks_abstract_field_details_parent_class = NULL;

static gboolean folks_abstract_field_details_real_equal (FolksAbstractFieldDetails* self,
                                                  FolksAbstractFieldDetails* that);
static gboolean folks_abstract_field_details_real_parameters_equal (FolksAbstractFieldDetails* self,
                                                             FolksAbstractFieldDetails* that);
static gboolean folks_abstract_field_details_real_values_equal (FolksAbstractFieldDetails* self,
                                                         FolksAbstractFieldDetails* that);
static guint folks_abstract_field_details_real_hash (FolksAbstractFieldDetails* self);
static void folks_abstract_field_details_finalize (GObject * obj);
static GType folks_abstract_field_details_get_type_once (void);
static void _vala_folks_abstract_field_details_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_folks_abstract_field_details_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
folks_abstract_field_details_get_instance_private (FolksAbstractFieldDetails* self)
{
	return G_STRUCT_MEMBER_P (self, FolksAbstractFieldDetails_private_offset);
}

/**
   * Get the values for a parameter
   *
   * @param parameter_name the parameter name
   * @return a collection of values for ``parameter_name`` or ``null`` (i.e. no
   * collection) if there are no such parameters.
   *
   * @since 0.6.0
   */
GeeCollection*
folks_abstract_field_details_get_parameter_values (FolksAbstractFieldDetails* self,
                                                   const gchar* parameter_name)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parameter_name != NULL, NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	if (gee_multi_map_contains (_tmp1_, parameter_name) == FALSE) {
		result = NULL;
		return result;
	}
	_tmp2_ = folks_abstract_field_details_get_parameters (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_multi_map_get (_tmp3_, parameter_name);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_read_only_view (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	result = _tmp8_;
	return result;
}

/**
   * Add a new value for a parameter.
   *
   * If there is already a parameter called ``parameter_name`` then
   * ``parameter_value`` is added to the existing ones.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.6.0
   */
void
folks_abstract_field_details_add_parameter (FolksAbstractFieldDetails* self,
                                            const gchar* parameter_name,
                                            const gchar* parameter_value)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	gee_multi_map_set (_tmp1_, parameter_name, parameter_value);
}

/**
   * Set the value of a parameter.
   *
   * Sets the parameter called ``parameter_name`` to be ``parameter_value``.
   * If there were already parameters with the same name they are replaced.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.6.0
   */
void
folks_abstract_field_details_set_parameter (FolksAbstractFieldDetails* self,
                                            const gchar* parameter_name,
                                            const gchar* parameter_value)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	gee_multi_map_remove_all (_tmp1_, parameter_name);
	_tmp2_ = folks_abstract_field_details_get_parameters (self);
	_tmp3_ = _tmp2_;
	gee_multi_map_set (_tmp3_, parameter_name, parameter_value);
}

/**
   * Extend the existing parameters.
   *
   * Merge the parameters from ``additional`` into the existing ones.
   *
   * @param additional the parameters to add
   *
   * @since 0.6.0
   */
void
folks_abstract_field_details_extend_parameters (FolksAbstractFieldDetails* self,
                                                GeeMultiMap* additional)
{
	GeeMapIterator* iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (additional != NULL);
	_tmp0_ = gee_multi_map_map_iterator (additional);
	iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		gchar* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
		_tmp4_ = (gchar*) _tmp3_;
		_tmp5_ = iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		_tmp7_ = (gchar*) _tmp6_;
		folks_abstract_field_details_add_parameter (self, _tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
	}
	_g_object_unref0 (iter);
}

/**
   * Remove all instances of a parameter.
   *
   * @param parameter_name the name of the parameter
   *
   * @since 0.6.0
   */
void
folks_abstract_field_details_remove_parameter_all (FolksAbstractFieldDetails* self,
                                                   const gchar* parameter_name)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	gee_multi_map_remove_all (_tmp1_, parameter_name);
}

/**
   * A fairly-strict equality function for {@link AbstractFieldDetails}.
   *
   * This function compares:
   *
   *  * {@link AbstractFieldDetails.value}s
   *  * {@link AbstractFieldDetails.parameters}
   *
   * And does not compare:
   *
   *  * {@link AbstractFieldDetails.id}s
   *
   * See the description of {@link AbstractFieldDetails.values_equal} for
   * details on the value comparison.
   *
   * To check equality not including the parameters, see
   * {@link AbstractFieldDetails.values_equal}.
   *
   * @param that another {@link AbstractFieldDetails}
   *
   * @return whether the elements are equal
   *
   * @see AbstractFieldDetails.parameters_equal
   * @see AbstractFieldDetails.values_equal
   * @since 0.6.0
   */
static gboolean
folks_abstract_field_details_real_equal (FolksAbstractFieldDetails* self,
                                         FolksAbstractFieldDetails* that)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (that != NULL, FALSE);
	if (G_TYPE_FROM_INSTANCE ((GObject*) self) == G_TYPE_FROM_INSTANCE ((GObject*) that)) {
		_tmp1_ = folks_abstract_field_details_values_equal (self, that);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = folks_abstract_field_details_parameters_equal (self, that);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
folks_abstract_field_details_equal (FolksAbstractFieldDetails* self,
                                    FolksAbstractFieldDetails* that)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->equal) {
		return _klass_->equal (self, that);
	}
	return FALSE;
}

/**
   * Same as {@link AbstractFieldDetails.equal}, but static, so we can use
   * libgee 0.8 without an API break.
   *
   * See [[https://bugzilla.gnome.org/show_bug.cgi?id=673918|673918]]
   * This can and should be removed next time we break the API.
   * Note: This uses Gee.EqualDataFunc signature, to avoid having to cast.
   *
   * @param left one {@link AbstractFieldDetails} to compare
   * @param right another {@link AbstractFieldDetails} to compare
   *
   * @return whether the elemants are equal
   *
   * @since 0.9.0
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
folks_abstract_field_details_equal_static (FolksAbstractFieldDetails* left,
                                           FolksAbstractFieldDetails* right)
{
	FolksAbstractFieldDetails* left_details = NULL;
	FolksAbstractFieldDetails* _tmp0_;
	FolksAbstractFieldDetails* right_details = NULL;
	FolksAbstractFieldDetails* _tmp1_;
	gboolean result;
	g_return_val_if_fail (left != NULL, FALSE);
	g_return_val_if_fail (right != NULL, FALSE);
	g_return_val_if_fail (left != NULL, FALSE);
	g_return_val_if_fail (right != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (left, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	left_details = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (right, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	right_details = _tmp1_;
	result = folks_abstract_field_details_equal (left_details, right_details);
	_g_object_unref0 (right_details);
	_g_object_unref0 (left_details);
	return result;
}

/**
   * An equality function which only considers parameters.
   *
   * This function compares:
   *
   *  * {@link AbstractFieldDetails.parameters}
   *
   * And does not compare:
   *
   *  * {@link AbstractFieldDetails.value}s
   *  * {@link AbstractFieldDetails.id}s
   *
   * @param that another {@link AbstractFieldDetails}
   *
   * @return whether the elements' {@link AbstractFieldDetails.value}s are
   * equal.
   *
   * @see AbstractFieldDetails.equal
   * @see AbstractFieldDetails.values_equal
   * @since 0.6.5
   */
static gboolean
folks_abstract_field_details_real_parameters_equal (FolksAbstractFieldDetails* self,
                                                    FolksAbstractFieldDetails* that)
{
	GeeMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = folks_abstract_field_details_get_parameters (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_multi_map_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_abstract_field_details_get_parameters (that);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_multi_map_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ != _tmp7_) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _param_it = NULL;
		GeeMultiMap* _tmp8_;
		GeeMultiMap* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp8_ = folks_abstract_field_details_get_parameters (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_multi_map_get_keys (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_param_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			gchar* param = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			GeeMultiMap* _tmp17_;
			GeeMultiMap* _tmp18_;
			const gchar* _tmp19_;
			GeeCollection* this_param_values = NULL;
			GeeMultiMap* _tmp20_;
			GeeMultiMap* _tmp21_;
			GeeCollection* _tmp22_;
			GeeCollection* that_param_values = NULL;
			GeeMultiMap* _tmp23_;
			GeeMultiMap* _tmp24_;
			GeeCollection* _tmp25_;
			GeeCollection* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			GeeCollection* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			_tmp14_ = _param_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _param_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			param = (gchar*) _tmp16_;
			_tmp17_ = folks_abstract_field_details_get_parameters (that);
			_tmp18_ = _tmp17_;
			_tmp19_ = param;
			if (!gee_multi_map_contains (_tmp18_, _tmp19_)) {
				result = FALSE;
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				return result;
			}
			_tmp20_ = folks_abstract_field_details_get_parameters (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = gee_multi_map_get_values (_tmp21_);
			this_param_values = _tmp22_;
			_tmp23_ = folks_abstract_field_details_get_parameters (that);
			_tmp24_ = _tmp23_;
			_tmp25_ = gee_multi_map_get_values (_tmp24_);
			that_param_values = _tmp25_;
			_tmp26_ = this_param_values;
			_tmp27_ = gee_collection_get_size (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = that_param_values;
			_tmp30_ = gee_collection_get_size (_tmp29_);
			_tmp31_ = _tmp30_;
			if (_tmp28_ != _tmp31_) {
				result = FALSE;
				_g_object_unref0 (that_param_values);
				_g_object_unref0 (this_param_values);
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				return result;
			}
			{
				GeeIterator* _param_val_it = NULL;
				GeeMultiMap* _tmp32_;
				GeeMultiMap* _tmp33_;
				GeeCollection* _tmp34_;
				GeeCollection* _tmp35_;
				GeeIterator* _tmp36_;
				GeeIterator* _tmp37_;
				_tmp32_ = folks_abstract_field_details_get_parameters (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = gee_multi_map_get_values (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
				_tmp37_ = _tmp36_;
				_g_object_unref0 (_tmp35_);
				_param_val_it = _tmp37_;
				while (TRUE) {
					GeeIterator* _tmp38_;
					gchar* param_val = NULL;
					GeeIterator* _tmp39_;
					gpointer _tmp40_;
					GeeCollection* _tmp41_;
					const gchar* _tmp42_;
					_tmp38_ = _param_val_it;
					if (!gee_iterator_next (_tmp38_)) {
						break;
					}
					_tmp39_ = _param_val_it;
					_tmp40_ = gee_iterator_get (_tmp39_);
					param_val = (gchar*) _tmp40_;
					_tmp41_ = that_param_values;
					_tmp42_ = param_val;
					if (!gee_collection_contains (_tmp41_, _tmp42_)) {
						result = FALSE;
						_g_free0 (param_val);
						_g_object_unref0 (_param_val_it);
						_g_object_unref0 (that_param_values);
						_g_object_unref0 (this_param_values);
						_g_free0 (param);
						_g_object_unref0 (_param_it);
						return result;
					}
					_g_free0 (param_val);
				}
				_g_object_unref0 (_param_val_it);
			}
			_g_object_unref0 (that_param_values);
			_g_object_unref0 (this_param_values);
			_g_free0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = TRUE;
	return result;
}

gboolean
folks_abstract_field_details_parameters_equal (FolksAbstractFieldDetails* self,
                                               FolksAbstractFieldDetails* that)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->parameters_equal) {
		return _klass_->parameters_equal (self, that);
	}
	return FALSE;
}

/**
   * An equality function which does not consider parameters.
   *
   * Specific classes may override this function to provide "smart" value
   * comparisons (eg, considering the phone number values "+1 555 123 4567" and
   * "123-4567" equal). If you wish to do strict comparisons, simply compare the
   * {@link AbstractFieldDetails.value}s directly.
   *
   * This function compares:
   *
   *  * {@link AbstractFieldDetails.value}s
   *
   * And does not compare:
   *
   *  * {@link AbstractFieldDetails.parameters}
   *  * {@link AbstractFieldDetails.id}s
   *
   * This defaults to string comparison of the
   * {@link AbstractFieldDetails.value}s if the generic type is string;
   * otherwise, direct pointer comparison of the
   * {@link AbstractFieldDetails.value}s.
   *
   * @param that another {@link AbstractFieldDetails}
   *
   * @return whether the elements' {@link AbstractFieldDetails.value}s are
   * equal.
   *
   * @see AbstractFieldDetails.equal
   * @see AbstractFieldDetails.parameters_equal
   * @since 0.6.5
   */
static gboolean
folks_abstract_field_details_real_values_equal (FolksAbstractFieldDetails* self,
                                                FolksAbstractFieldDetails* that)
{
	GEqualFunc equal_func = NULL;
	GEqualFunc _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = g_direct_equal;
	equal_func = _tmp0_;
	if (self->priv->t_type == G_TYPE_STRING) {
		GEqualFunc _tmp1_;
		_tmp1_ = g_str_equal;
		equal_func = _tmp1_;
	}
	if (G_TYPE_FROM_INSTANCE ((GObject*) self) != G_TYPE_FROM_INSTANCE ((GObject*) that)) {
		_tmp2_ = TRUE;
	} else {
		GEqualFunc _tmp3_;
		gconstpointer _tmp4_;
		gconstpointer _tmp5_;
		gconstpointer _tmp6_;
		gconstpointer _tmp7_;
		_tmp3_ = equal_func;
		_tmp4_ = folks_abstract_field_details_get_value (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = folks_abstract_field_details_get_value (that);
		_tmp7_ = _tmp6_;
		_tmp2_ = !_tmp3_ (_tmp5_, _tmp7_);
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
folks_abstract_field_details_values_equal (FolksAbstractFieldDetails* self,
                                           FolksAbstractFieldDetails* that)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->values_equal) {
		return _klass_->values_equal (self, that);
	}
	return FALSE;
}

/**
   * A hash function for the {@link AbstractFieldDetails}.
   *
   * This defaults to a string hash of the
   * {@link AbstractFieldDetails.value} if the generic type is string;
   * otherwise, direct hash of the {@link AbstractFieldDetails.value}.
   *
   * @return the hash value
   *
   * @since 0.6.0
   */
static guint
folks_abstract_field_details_real_hash (FolksAbstractFieldDetails* self)
{
	GHashFunc hash_func = NULL;
	GHashFunc _tmp0_;
	GHashFunc _tmp2_;
	gconstpointer _tmp3_;
	gconstpointer _tmp4_;
	guint result;
	_tmp0_ = g_direct_hash;
	hash_func = _tmp0_;
	if (self->priv->t_type == G_TYPE_STRING) {
		GHashFunc _tmp1_;
		_tmp1_ = g_str_hash;
		hash_func = _tmp1_;
	}
	_tmp2_ = hash_func;
	_tmp3_ = folks_abstract_field_details_get_value (self);
	_tmp4_ = _tmp3_;
	result = _tmp2_ (_tmp4_);
	return result;
}

guint
folks_abstract_field_details_hash (FolksAbstractFieldDetails* self)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->hash) {
		return _klass_->hash (self);
	}
	return 0U;
}

/**
   * Same as {@link AbstractFieldDetails.hash}, but static, so we can use libgee
   * 0.8 without an API break.
   *
   * See [[https://bugzilla.gnome.org/show_bug.cgi?id=673918|673918]]
   * This can and should be removed next time we break the API.
   * Note: This uses Gee.HashDataFunc signature, to avoid having to cast.
   *
   * @param value the value to hash
   *
   * @return the hash value
   *
   * @since 0.9.0
   */
guint
folks_abstract_field_details_hash_static (FolksAbstractFieldDetails* value)
{
	FolksAbstractFieldDetails* details = NULL;
	FolksAbstractFieldDetails* _tmp0_;
	guint result;
	g_return_val_if_fail (value != NULL, 0U);
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (value, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	details = _tmp0_;
	result = folks_abstract_field_details_hash (details);
	_g_object_unref0 (details);
	return result;
}

FolksAbstractFieldDetails*
folks_abstract_field_details_construct (GType object_type,
                                        GType t_type,
                                        GBoxedCopyFunc t_dup_func,
                                        GDestroyNotify t_destroy_func)
{
	FolksAbstractFieldDetails * self = NULL;
	self = (FolksAbstractFieldDetails*) g_object_new (object_type, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	return self;
}

gconstpointer
folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->get_value) {
		return _klass_->get_value (self);
	}
	return NULL;
}

static gconstpointer
folks_abstract_field_details_real_get_value (FolksAbstractFieldDetails* base)
{
	gconstpointer result;
	FolksAbstractFieldDetails* self;
	gconstpointer _tmp0_;
	self = base;
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

void
folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self,
                                        gconstpointer value)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->set_value) {
		_klass_->set_value (self, value);
	}
}

static void
folks_abstract_field_details_real_set_value (FolksAbstractFieldDetails* base,
                                             gconstpointer value)
{
	FolksAbstractFieldDetails* self;
	gpointer _tmp0_;
	self = base;
	_tmp0_ = ((value != NULL) && (self->priv->t_dup_func != NULL)) ? self->priv->t_dup_func ((gpointer) value) : ((gpointer) value);
	((self->priv->_value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->t_destroy_func (self->priv->_value), NULL));
	self->priv->_value = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_PROPERTY]);
}

GType
folks_abstract_field_details_get_value_type (FolksAbstractFieldDetails* self)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->t_type;
	return result;
}

const gchar*
folks_abstract_field_details_get_id (FolksAbstractFieldDetails* self)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->get_id) {
		return _klass_->get_id (self);
	}
	return NULL;
}

static const gchar*
folks_abstract_field_details_real_get_id (FolksAbstractFieldDetails* base)
{
	const gchar* result;
	FolksAbstractFieldDetails* self;
	const gchar* _tmp0_;
	self = base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

void
folks_abstract_field_details_set_id (FolksAbstractFieldDetails* self,
                                     const gchar* value)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->set_id) {
		_klass_->set_id (self, value);
	}
}

static void
folks_abstract_field_details_real_set_id (FolksAbstractFieldDetails* base,
                                          const gchar* value)
{
	FolksAbstractFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = base;
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_ID_PROPERTY]);
}

GeeMultiMap*
folks_abstract_field_details_get_parameters (FolksAbstractFieldDetails* self)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->get_parameters) {
		return _klass_->get_parameters (self);
	}
	return NULL;
}

static GeeMultiMap*
folks_abstract_field_details_real_get_parameters (FolksAbstractFieldDetails* base)
{
	GeeMultiMap* result;
	FolksAbstractFieldDetails* self;
	GeeMultiMap* _tmp0_;
	self = base;
	_tmp0_ = self->priv->_parameters;
	result = _tmp0_;
	return result;
}

void
folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self,
                                             GeeMultiMap* value)
{
	FolksAbstractFieldDetailsClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS (self);
	if (_klass_->set_parameters) {
		_klass_->set_parameters (self, value);
	}
}

static void
folks_abstract_field_details_real_set_parameters (FolksAbstractFieldDetails* base,
                                                  GeeMultiMap* value)
{
	FolksAbstractFieldDetails* self;
	self = base;
	if (value == NULL) {
		GeeMultiMap* _tmp0_;
		_tmp0_ = self->priv->_parameters;
		gee_multi_map_clear (_tmp0_);
	} else {
		GeeMultiMap* _tmp1_;
		_tmp1_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parameters);
		self->priv->_parameters = _tmp1_;
	}
	g_object_notify_by_pspec ((GObject *) self, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS_PROPERTY]);
}

static void
folks_abstract_field_details_class_init (FolksAbstractFieldDetailsClass * klass,
                                         gpointer klass_data)
{
	folks_abstract_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksAbstractFieldDetails_private_offset);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_abstract_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->parameters_equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_abstract_field_details_real_parameters_equal;
	((FolksAbstractFieldDetailsClass *) klass)->values_equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_abstract_field_details_real_values_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_abstract_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_value = (gconstpointer (*) (FolksAbstractFieldDetails*)) folks_abstract_field_details_real_get_value;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_value = (void (*) (FolksAbstractFieldDetails*, gconstpointer)) folks_abstract_field_details_real_set_value;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = (const gchar* (*) (FolksAbstractFieldDetails*)) folks_abstract_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = (void (*) (FolksAbstractFieldDetails*, const gchar*)) folks_abstract_field_details_real_set_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_parameters = (GeeMultiMap* (*) (FolksAbstractFieldDetails*)) folks_abstract_field_details_real_get_parameters;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_parameters = (void (*) (FolksAbstractFieldDetails*, GeeMultiMap*)) folks_abstract_field_details_real_set_parameters;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_abstract_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_abstract_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_abstract_field_details_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The value of the field.
	   *
	   * The value of the field, the exact type and content of which depends on what
	   * the structure is used for.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_PROPERTY, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_PROPERTY] = g_param_spec_pointer ("value", "value", "value", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The {@link GLib.Type} of the {@link AbstractFieldDetails.value}.
	   *
	   * This is particularly useful for treating collections of different types of
	   * {@link AbstractFieldDetails} in a uniform way without needing to name them
	   * explicitly.
	   *
	   * @since 0.6.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE_PROPERTY, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE_PROPERTY] = g_param_spec_gtype ("value-type", "value-type", "value-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * A unique ID (if any) for this specific detail.
	   *
	   * This is primarily intended for {@link PersonaStore}s which need to track
	   * specific instances of details (because their backing store is wacky).
	   *
	   * In most cases, this will be an empty string.
	   *
	   * The content of this is opaque to all but the package which set it.
	   *
	   * @since 0.6.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_ID_PROPERTY, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The parameters associated with the value.
	   *
	   * A multi-map of the parameters associated with
	   * {@link Folks.AbstractFieldDetails.value}. The keys are the names of
	   * the parameters, while the values are a list of strings.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS_PROPERTY, folks_abstract_field_details_properties[FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS_PROPERTY] = g_param_spec_object ("parameters", "parameters", "parameters", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
folks_abstract_field_details_instance_init (FolksAbstractFieldDetails * self,
                                            gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	self->priv = folks_abstract_field_details_get_instance_private (self);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_parameters = (GeeMultiMap*) _tmp0_;
}

static void
folks_abstract_field_details_finalize (GObject * obj)
{
	FolksAbstractFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails);
	((self->priv->_value == NULL) || (self->priv->t_destroy_func == NULL)) ? NULL : (self->priv->_value = (self->priv->t_destroy_func (self->priv->_value), NULL));
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->_parameters);
	G_OBJECT_CLASS (folks_abstract_field_details_parent_class)->finalize (obj);
}

/**
 * Object representing any type of value that can have some vCard-like
 * parameters associated with it.
 *
 * Some contact details, like phone numbers or URLs, can have some
 * extra details associated with them.
 * For instance, a phone number expressed in vcard notation as
 * ``tel;type=work,voice:(111) 555-1234`` would be represented as
 * a AbstractFieldDetails with value "(111) 555-1234" and with parameters
 * ``['type': ('work', 'voice')]``.
 *
 * The parameter name "type" with values "work", "home", or "other" are common
 * amongst most vCard attributes (and thus most AbstractFieldDetails-derived
 * classes). A "type" of "pref" may be used to indicate a preferred
 * {@link AbstractFieldDetails.value} amongst many. See specific classes for
 * information on additional parameters and values specific to that class.
 *
 * See [[http://www.ietf.org/rfc/rfc2426.txt|RFC2426]] for more details on
 * pre-defined parameter names and values.
 *
 * @since 0.6.0
 */
static GType
folks_abstract_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksAbstractFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_abstract_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksAbstractFieldDetails), 0, (GInstanceInitFunc) folks_abstract_field_details_instance_init, NULL };
	GType folks_abstract_field_details_type_id;
	folks_abstract_field_details_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksAbstractFieldDetails", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FolksAbstractFieldDetails_private_offset = g_type_add_instance_private (folks_abstract_field_details_type_id, sizeof (FolksAbstractFieldDetailsPrivate));
	return folks_abstract_field_details_type_id;
}

GType
folks_abstract_field_details_get_type (void)
{
	static volatile gsize folks_abstract_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_abstract_field_details_type_id__once)) {
		GType folks_abstract_field_details_type_id;
		folks_abstract_field_details_type_id = folks_abstract_field_details_get_type_once ();
		g_once_init_leave (&folks_abstract_field_details_type_id__once, folks_abstract_field_details_type_id);
	}
	return folks_abstract_field_details_type_id__once;
}

static void
_vala_folks_abstract_field_details_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FolksAbstractFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails);
	switch (property_id) {
		case FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_PROPERTY:
		g_value_set_pointer (value, folks_abstract_field_details_get_value (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_TYPE_PROPERTY:
		g_value_set_gtype (value, folks_abstract_field_details_get_value_type (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_ID_PROPERTY:
		g_value_set_string (value, folks_abstract_field_details_get_id (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS_PROPERTY:
		g_value_set_object (value, folks_abstract_field_details_get_parameters (self));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_abstract_field_details_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FolksAbstractFieldDetails * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails);
	switch (property_id) {
		case FOLKS_ABSTRACT_FIELD_DETAILS_VALUE_PROPERTY:
		folks_abstract_field_details_set_value (self, g_value_get_pointer (value));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_ID_PROPERTY:
		folks_abstract_field_details_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_PARAMETERS_PROPERTY:
		folks_abstract_field_details_set_parameters (self, g_value_get_object (value));
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case FOLKS_ABSTRACT_FIELD_DETAILS_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

