/* do not edit automatically generated by mc from M2Scope.  */
/* M2Scope.mod derive the subset of quadruples for each scope.

Copyright (C) 2003-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Scope_C

#include "GM2Scope.h"
#   include "GStorage.h"
#   include "GM2Debug.h"
#   include "GNameKey.h"
#   include "GSymbolTable.h"
#   include "GM2Printf.h"
#   include "GM2Quads.h"
#   include "GM2StackWord.h"
#   include "GM2Error.h"

typedef struct M2Scope_ScopeProcedure2_p M2Scope_ScopeProcedure2;

typedef struct M2Scope_ScopeProcedure3_p M2Scope_ScopeProcedure3;

#   define Debugging false
#   define TraceQuadruples false
typedef struct M2Scope__T1_r M2Scope__T1;

typedef enum {M2Scope_unsetscope, M2Scope_ignorescope, M2Scope_procedurescope, M2Scope_modulescope, M2Scope_definitionscope, M2Scope_implementationscope, M2Scope_programscope} M2Scope_scopeKind;

typedef M2Scope__T1 *M2Scope_ScopeBlock__opaque;

struct M2Scope__T1_r {
                       unsigned int scopeSym;
                       M2Scope_scopeKind kindScope;
                       unsigned int low;
                       unsigned int high;
                       M2Scope_ScopeBlock__opaque next;
                     };

static M2Scope_ScopeBlock__opaque FreeList;

/*
   InitScopeBlock -
*/

extern "C" M2Scope_ScopeBlock M2Scope_InitScopeBlock (unsigned int scope);

/*
   KillScopeBlock - destroys the ScopeBlock sb and assign sb to NIL.
*/

extern "C" void M2Scope_KillScopeBlock (M2Scope_ScopeBlock *sb);

/*
   ForeachScopeBlockDo2 - calls a procedure p for each block of contigeous quadruples
                          defining an outer scope sb.
*/

extern "C" void M2Scope_ForeachScopeBlockDo2 (M2Scope_ScopeBlock sb, M2Scope_ScopeProcedure2 p);

/*
   ForeachScopeBlockDo3 - calls a procedure p for each block of contigeous quadruples
                          defining an outer scope sb.
*/

extern "C" void M2Scope_ForeachScopeBlockDo3 (M2Scope_ScopeBlock sb, M2Scope_ScopeProcedure3 p);

/*
   New -
*/

static void New (M2Scope_ScopeBlock__opaque *sb);

/*
   Dispose -
*/

static void Dispose (M2Scope_ScopeBlock__opaque *sb);

/*
   SetScope - assigns the scopeSym and kindScope.
*/

static void SetScope (M2Scope_ScopeBlock__opaque sb, unsigned int sym, M2Scope_scopeKind kindScope);

/*
   AddToRange - returns a ScopeBlock pointer to the last block. The,
                quad, will be added to the end of sb or a later block
                if First is TRUE.
*/

static M2Scope_ScopeBlock__opaque AddToRange (M2Scope_ScopeBlock__opaque sb, bool First, unsigned int quad);

/*
   GetGlobalQuads -
*/

static M2Scope_ScopeBlock__opaque GetGlobalQuads (M2Scope_ScopeBlock__opaque sb, unsigned int scope);

/*
   GetProcQuads -
*/

static M2Scope_ScopeBlock__opaque GetProcQuads (M2Scope_ScopeBlock__opaque sb, unsigned int proc);

/*
   DisplayScope -
*/

static void DisplayScope (M2Scope_ScopeBlock__opaque sb);

/*
   enter -
*/

static void enter (M2Scope_ScopeBlock__opaque sb);

/*
   leave -
*/

static void leave (M2Scope_ScopeBlock__opaque sb);

/*
   Init - initializes the global variables for this module.
*/

static void Init (void);


/*
   New -
*/

static void New (M2Scope_ScopeBlock__opaque *sb)
{
  if (FreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &(*sb), sizeof (M2Scope__T1));
    }
  else
    {
      (*sb) = FreeList;
      FreeList = FreeList->next;
    }
}


/*
   Dispose -
*/

static void Dispose (M2Scope_ScopeBlock__opaque *sb)
{
  (*sb)->next = FreeList;
  FreeList = (*sb);
  (*sb) = static_cast<M2Scope_ScopeBlock__opaque> (NULL);
}


/*
   SetScope - assigns the scopeSym and kindScope.
*/

static void SetScope (M2Scope_ScopeBlock__opaque sb, unsigned int sym, M2Scope_scopeKind kindScope)
{
  sb->scopeSym = sym;
  sb->kindScope = kindScope;
}


/*
   AddToRange - returns a ScopeBlock pointer to the last block. The,
                quad, will be added to the end of sb or a later block
                if First is TRUE.
*/

static M2Scope_ScopeBlock__opaque AddToRange (M2Scope_ScopeBlock__opaque sb, bool First, unsigned int quad)
{
  if (First)
    {
      if (sb->high == 0)
        {
          sb->high = sb->low;
        }
      sb->next = static_cast<M2Scope_ScopeBlock__opaque> (M2Scope_InitScopeBlock (SymbolTable_NulSym));
      sb = sb->next;
    }
  if (sb->low == 0)
    {
      sb->low = quad;
    }
  sb->high = quad;
  return sb;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetGlobalQuads -
*/

static M2Scope_ScopeBlock__opaque GetGlobalQuads (M2Scope_ScopeBlock__opaque sb, unsigned int scope)
{
  M2Scope_ScopeBlock__opaque prev;
  M2Scope_ScopeBlock__opaque nb;
  unsigned int NestedLevel;
  unsigned int i;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  bool First;
  unsigned int start;
  unsigned int end;

  NestedLevel = 0;
  prev = static_cast<M2Scope_ScopeBlock__opaque> (NULL);
  First = false;
  if (((SymbolTable_GetScope (scope)) != SymbolTable_NulSym) && ((SymbolTable_IsProcedure (SymbolTable_GetScope (scope))) || ((SymbolTable_IsModule (scope)) && (SymbolTable_IsModuleWithinProcedure (scope)))))
    {
      SymbolTable_GetProcedureQuads (SymbolTable_GetProcedureScope (scope), &i, &start, &end);
      M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
      while ((op != M2Quads_ModuleScopeOp) || (op3 != scope))
        {
          i = M2Quads_GetNextQuad (i);
          M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
        }
      end = i;
      M2Quads_GetQuad (end, &op, &op1, &op2, &op3);
      while ((op != M2Quads_FinallyEndOp) || (op3 != scope))
        {
          end = M2Quads_GetNextQuad (end);
          M2Quads_GetQuad (end, &op, &op1, &op2, &op3);
        }
    }
  else
    {
      i = M2Quads_GetFirstQuad ();
      end = 0;
    }
  nb = sb;
  sb->low = 0;
  sb->high = 0;
  for (;;)
  {
    if (i == 0)
      {
        if (Debugging)
          {
            DisplayScope (sb);
          }
        return sb;
      }
    M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
    if (op == M2Quads_ProcedureScopeOp)
      {
        NestedLevel += 1;
      }
    else if (op == M2Quads_ReturnOp)
      {
        /* avoid dangling else.  */
        if (NestedLevel > 0)
          {
            NestedLevel -= 1;
          }
        if (NestedLevel == 0)
          {
            First = true;
          }
      }
    else if (NestedLevel == 0)
      {
        /* avoid dangling else.  */
        if (op == M2Quads_StartDefFileOp)
          {
            nb = AddToRange (nb, true, i);
            SetScope (nb, op3, M2Scope_definitionscope);
            prev = nb;
          }
        else if ((op == M2Quads_StartModFileOp) || (op == M2Quads_InitStartOp))
          {
            /* avoid dangling else.  */
            nb = AddToRange (nb, true, i);
            if (SymbolTable_IsDefImp (op3))
              {
                SetScope (nb, op3, M2Scope_implementationscope);
              }
            else
              {
                SetScope (nb, op3, M2Scope_programscope);
              }
            prev = nb;
          }
        else
          {
            /* avoid dangling else.  */
            nb = AddToRange (nb, First, i);
            if (op == M2Quads_InitEndOp)
              {
                if (SymbolTable_IsDefImp (op3))
                  {
                    SetScope (nb, op3, M2Scope_implementationscope);
                  }
                else
                  {
                    SetScope (nb, op3, M2Scope_programscope);
                  }
                prev = nb;
              }
            else if (First)
              {
                /* avoid dangling else.  */
                M2Debug_Assert (prev != NULL);
                SetScope (nb, prev->scopeSym, prev->kindScope);
              }
          }
        First = false;
      }
    if (i == end)
      {
        if (Debugging)
          {
            DisplayScope (sb);
          }
        return sb;
      }
    i = M2Quads_GetNextQuad (i);
  }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Scope.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetProcQuads -
*/

static M2Scope_ScopeBlock__opaque GetProcQuads (M2Scope_ScopeBlock__opaque sb, unsigned int proc)
{
  M2Scope_ScopeBlock__opaque nb;
  unsigned int scope;
  unsigned int start;
  unsigned int end;
  unsigned int i;
  unsigned int last;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  bool First;
  M2StackWord_StackOfWord s;
  NameKey_Name n;

  s = M2StackWord_InitStackWord ();
  if (Debugging)
    {
      n = SymbolTable_GetSymName (proc);
      M2Printf_printf1 ((const char *) "GetProcQuads for %a\\n", 21, (const unsigned char *) &n, (sizeof (n)-1));
    }
  M2Debug_Assert (SymbolTable_IsProcedure (proc));
  SymbolTable_GetProcedureQuads (proc, &scope, &start, &end);
  if (Debugging)
    {
      M2Printf_printf1 ((const char *) " proc %d\\n", 10, (const unsigned char *) &proc, (sizeof (proc)-1));
      M2Printf_printf1 ((const char *) " scope %d\\n", 11, (const unsigned char *) &scope, (sizeof (scope)-1));
      M2Printf_printf1 ((const char *) " start %d\\n", 11, (const unsigned char *) &start, (sizeof (start)-1));
      M2Printf_printf1 ((const char *) " end %d\\n", 9, (const unsigned char *) &end, (sizeof (end)-1));
    }
  M2StackWord_PushWord (s, static_cast<unsigned int> (0));
  First = false;
  i = scope;
  last = scope;
  nb = sb;
  sb->low = scope;
  sb->high = 0;
  SetScope (sb, proc, M2Scope_procedurescope);
  while ((i <= end) && (start != 0))
    {
      M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
      if ((op == M2Quads_ProcedureScopeOp) || (op == M2Quads_ModuleScopeOp))
        {
          if (((M2StackWord_PeepWord (s, 1)) == proc) && (op3 == proc))
            {
              nb = AddToRange (nb, First, last);
              First = false;
            }
          M2StackWord_PushWord (s, op3);
          if (op == M2Quads_ProcedureScopeOp)
            {
              SetScope (nb, proc, M2Scope_procedurescope);
            }
          else
            {
              SetScope (nb, proc, M2Scope_modulescope);
            }
        }
      else if ((op == M2Quads_ReturnOp) || (op == M2Quads_FinallyEndOp))
        {
          /* avoid dangling else.  */
          op3 = static_cast<unsigned int> (M2StackWord_PopWord (s));
          if ((M2StackWord_PeepWord (s, 1)) == proc)
            {
              First = true;
            }
        }
      else
        {
          /* avoid dangling else.  */
          if ((M2StackWord_PeepWord (s, 1)) == proc)
            {
              nb = AddToRange (nb, First, i);
              First = false;
            }
        }
      last = i;
      i = M2Quads_GetNextQuad (i);
    }
  if (start <= nb->high)
    {
      nb->high = end;
    }
  else
    {
      nb->next = static_cast<M2Scope_ScopeBlock__opaque> (M2Scope_InitScopeBlock (SymbolTable_NulSym));
      nb = nb->next;
      SetScope (nb, proc, M2Scope_unsetscope);
      nb->low = start;
      nb->high = end;
    }
  s = M2StackWord_KillStackWord (s);
  return sb;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisplayScope -
*/

static void DisplayScope (M2Scope_ScopeBlock__opaque sb)
{
  NameKey_Name name;

  M2Printf_printf0 ((const char *) "scope: ", 7);
  switch (sb->kindScope)
    {
      case M2Scope_unsetscope:
        M2Printf_printf0 ((const char *) "unset", 5);
        break;

      case M2Scope_ignorescope:
        M2Printf_printf0 ((const char *) "ignore", 6);
        break;

      case M2Scope_procedurescope:
        name = SymbolTable_GetSymName (sb->scopeSym);
        M2Printf_printf1 ((const char *) "procedure %a", 12, (const unsigned char *) &name, (sizeof (name)-1));
        break;

      case M2Scope_modulescope:
        name = SymbolTable_GetSymName (sb->scopeSym);
        M2Printf_printf1 ((const char *) "inner module %a", 15, (const unsigned char *) &name, (sizeof (name)-1));
        break;

      case M2Scope_definitionscope:
        name = SymbolTable_GetSymName (sb->scopeSym);
        M2Printf_printf1 ((const char *) "definition module %a", 20, (const unsigned char *) &name, (sizeof (name)-1));
        break;

      case M2Scope_implementationscope:
        name = SymbolTable_GetSymName (sb->scopeSym);
        M2Printf_printf1 ((const char *) "implementation module %a", 24, (const unsigned char *) &name, (sizeof (name)-1));
        break;

      case M2Scope_programscope:
        name = SymbolTable_GetSymName (sb->scopeSym);
        M2Printf_printf1 ((const char *) "program module %a", 17, (const unsigned char *) &name, (sizeof (name)-1));
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Scope.def", 20, 1);
        __builtin_unreachable ();
    }
  M2Printf_printf0 ((const char *) "\\n", 2);
  M2Quads_DisplayQuadRange (sb->scopeSym, sb->low, sb->high);
  if (sb->next != NULL)
    {
      DisplayScope (sb->next);
    }
}


/*
   enter -
*/

static void enter (M2Scope_ScopeBlock__opaque sb)
{
  switch (sb->kindScope)
    {
      case M2Scope_unsetscope:
      case M2Scope_ignorescope:
        break;

      case M2Scope_procedurescope:
      case M2Scope_modulescope:
      case M2Scope_definitionscope:
      case M2Scope_implementationscope:
      case M2Scope_programscope:
        M2Error_EnterErrorScope (SymbolTable_GetErrorScope (sb->scopeSym));
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Scope.def", 20, 1);
        __builtin_unreachable ();
    }
}


/*
   leave -
*/

static void leave (M2Scope_ScopeBlock__opaque sb)
{
  switch (sb->kindScope)
    {
      case M2Scope_unsetscope:
      case M2Scope_ignorescope:
        break;


      default:
        M2Error_LeaveErrorScope ();
        break;
    }
}


/*
   Init - initializes the global variables for this module.
*/

static void Init (void)
{
  FreeList = static_cast<M2Scope_ScopeBlock__opaque> (NULL);
}


/*
   InitScopeBlock -
*/

extern "C" M2Scope_ScopeBlock M2Scope_InitScopeBlock (unsigned int scope)
{
  M2Scope_ScopeBlock__opaque sb;

  New (&sb);
  sb->next = static_cast<M2Scope_ScopeBlock__opaque> (NULL);
  sb->kindScope = M2Scope_unsetscope;
  if (scope == SymbolTable_NulSym)
    {
      sb->low = 0;
      sb->high = 0;
    }
  else
    {
      if (SymbolTable_IsProcedure (scope))
        {
          sb = GetProcQuads (sb, scope);
        }
      else
        {
          sb = GetGlobalQuads (sb, scope);
        }
      if (TraceQuadruples)
        {
          DisplayScope (sb);
        }
    }
  return static_cast<M2Scope_ScopeBlock> (sb);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillScopeBlock - destroys the ScopeBlock sb and assign sb to NIL.
*/

extern "C" void M2Scope_KillScopeBlock (M2Scope_ScopeBlock *sb)
{
  M2Scope_ScopeBlock__opaque t;

  t = static_cast<M2Scope_ScopeBlock__opaque> ((*sb));
  while (t != NULL)
    {
      (*sb) = static_cast<M2Scope_ScopeBlock> (t);
      t = t->next;
      Dispose (reinterpret_cast<M2Scope_ScopeBlock__opaque *> (&(*sb)));
    }
  (*sb) = static_cast<M2Scope_ScopeBlock> (NULL);
}


/*
   ForeachScopeBlockDo2 - calls a procedure p for each block of contigeous quadruples
                          defining an outer scope sb.
*/

extern "C" void M2Scope_ForeachScopeBlockDo2 (M2Scope_ScopeBlock sb, M2Scope_ScopeProcedure2 p)
{
  if (TraceQuadruples)
    {
      M2Printf_printf0 ((const char *) "ForeachScopeBlockDo\\n", 21);
    }
  while (sb != NULL)
    {
      if (TraceQuadruples)
        {
          DisplayScope (static_cast<M2Scope_ScopeBlock__opaque> (sb));
        }
      enter (static_cast<M2Scope_ScopeBlock__opaque> (sb));
      if ((static_cast<M2Scope_ScopeBlock__opaque> (sb)->low != 0) && (static_cast<M2Scope_ScopeBlock__opaque> (sb)->high != 0))
        {
          (*p.proc) (static_cast<M2Scope_ScopeBlock__opaque> (sb)->low, static_cast<M2Scope_ScopeBlock__opaque> (sb)->high);
        }
      leave (static_cast<M2Scope_ScopeBlock__opaque> (sb));
      sb = static_cast<M2Scope_ScopeBlock> (static_cast<M2Scope_ScopeBlock__opaque> (sb)->next);
    }
  if (TraceQuadruples)
    {
      M2Printf_printf0 ((const char *) "end ForeachScopeBlockDo\\n\\n", 27);
    }
}


/*
   ForeachScopeBlockDo3 - calls a procedure p for each block of contigeous quadruples
                          defining an outer scope sb.
*/

extern "C" void M2Scope_ForeachScopeBlockDo3 (M2Scope_ScopeBlock sb, M2Scope_ScopeProcedure3 p)
{
  if (TraceQuadruples)
    {
      M2Printf_printf0 ((const char *) "ForeachScopeBlockDo\\n", 21);
    }
  while (sb != NULL)
    {
      if (TraceQuadruples)
        {
          DisplayScope (static_cast<M2Scope_ScopeBlock__opaque> (sb));
        }
      enter (static_cast<M2Scope_ScopeBlock__opaque> (sb));
      if ((static_cast<M2Scope_ScopeBlock__opaque> (sb)->low != 0) && (static_cast<M2Scope_ScopeBlock__opaque> (sb)->high != 0))
        {
          (*p.proc) (static_cast<M2Scope_ScopeBlock__opaque> (sb)->scopeSym, static_cast<M2Scope_ScopeBlock__opaque> (sb)->low, static_cast<M2Scope_ScopeBlock__opaque> (sb)->high);
        }
      leave (static_cast<M2Scope_ScopeBlock__opaque> (sb));
      sb = static_cast<M2Scope_ScopeBlock> (static_cast<M2Scope_ScopeBlock__opaque> (sb)->next);
    }
  if (TraceQuadruples)
    {
      M2Printf_printf0 ((const char *) "end ForeachScopeBlockDo\\n\\n", 27);
    }
}

extern "C" void _M2_M2Scope_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2Scope_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
