/* equation-lexer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from equation-lexer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Enum for tokens generated by pre-lexer and lexer. */

#include "calculator.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRE_LEXER_0_PROPERTY,
	PRE_LEXER_NUM_PROPERTIES
};
static GParamSpec* pre_lexer_properties[PRE_LEXER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	LEXER_TOKEN_0_PROPERTY,
	LEXER_TOKEN_NUM_PROPERTIES
};
static GParamSpec* lexer_token_properties[LEXER_TOKEN_NUM_PROPERTIES];
enum  {
	LEXER_0_PROPERTY,
	LEXER_NUM_PROPERTIES
};
static GParamSpec* lexer_properties[LEXER_NUM_PROPERTIES];
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PreLexerPrivate {
	gboolean eos;
};

struct _LexerPrivate {
	Parser* parser;
	PreLexer* prelexer;
	guint next_token;
	gint number_base;
};

static gint PreLexer_private_offset;
static gpointer pre_lexer_parent_class = NULL;
static gpointer lexer_token_parent_class = NULL;
static gint Lexer_private_offset;
static gpointer lexer_parent_class = NULL;

static void pre_lexer_finalize (GObject * obj);
static GType pre_lexer_get_type_once (void);
static void lexer_token_finalize (GObject * obj);
static GType lexer_token_get_type_once (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static LexerToken* lexer_insert_next_token (Lexer* self);
static gboolean lexer_check_if_function (Lexer* self);
static gboolean lexer_check_if_unit (Lexer* self);
static gboolean lexer_check_if_currency (Lexer* self);
static gboolean lexer_check_if_literal_base (Lexer* self);
static gboolean lexer_check_if_number (Lexer* self);
static LexerToken* lexer_insert_token (Lexer* self,
                                LexerTokenType type);
static LexerToken* lexer_insert_digit (Lexer* self);
static LexerToken* lexer_insert_decimal (Lexer* self);
static LexerToken* lexer_insert_hex (Lexer* self);
static LexerToken* lexer_insert_letter (Lexer* self);
static LexerToken* lexer_insert_angle_num_dm (Lexer* self);
static LexerToken* lexer_insert_angle_num_dms (Lexer* self);
static LexerToken* lexer_insert_hex_dec (Lexer* self);
static LexerToken* lexer_insert_decimal_hex (Lexer* self);
static void lexer_finalize (GObject * obj);
static GType lexer_get_type_once (void);

 G_GNUC_NO_INLINE static GType
lexer_token_type_get_type_once (void)
{
	static const GEnumValue values[] = {{LEXER_TOKEN_TYPE_UNKNOWN, "LEXER_TOKEN_TYPE_UNKNOWN", "unknown"}, {LEXER_TOKEN_TYPE_PL_DECIMAL, "LEXER_TOKEN_TYPE_PL_DECIMAL", "pl-decimal"}, {LEXER_TOKEN_TYPE_PL_DIGIT, "LEXER_TOKEN_TYPE_PL_DIGIT", "pl-digit"}, {LEXER_TOKEN_TYPE_PL_HEX, "LEXER_TOKEN_TYPE_PL_HEX", "pl-hex"}, {LEXER_TOKEN_TYPE_PL_SUPER_DIGIT, "LEXER_TOKEN_TYPE_PL_SUPER_DIGIT", "pl-super-digit"}, {LEXER_TOKEN_TYPE_PL_SUPER_MINUS, "LEXER_TOKEN_TYPE_PL_SUPER_MINUS", "pl-super-minus"}, {LEXER_TOKEN_TYPE_PL_SUB_DIGIT, "LEXER_TOKEN_TYPE_PL_SUB_DIGIT", "pl-sub-digit"}, {LEXER_TOKEN_TYPE_PL_FRACTION, "LEXER_TOKEN_TYPE_PL_FRACTION", "pl-fraction"}, {LEXER_TOKEN_TYPE_PL_DEGREE, "LEXER_TOKEN_TYPE_PL_DEGREE", "pl-degree"}, {LEXER_TOKEN_TYPE_PL_MINUTE, "LEXER_TOKEN_TYPE_PL_MINUTE", "pl-minute"}, {LEXER_TOKEN_TYPE_PL_SECOND, "LEXER_TOKEN_TYPE_PL_SECOND", "pl-second"}, {LEXER_TOKEN_TYPE_PL_LETTER, "LEXER_TOKEN_TYPE_PL_LETTER", "pl-letter"}, {LEXER_TOKEN_TYPE_PL_EOS, "LEXER_TOKEN_TYPE_PL_EOS", "pl-eos"}, {LEXER_TOKEN_TYPE_PL_SKIP, "LEXER_TOKEN_TYPE_PL_SKIP", "pl-skip"}, {LEXER_TOKEN_TYPE_ADD, "LEXER_TOKEN_TYPE_ADD", "add"}, {LEXER_TOKEN_TYPE_SUBTRACT, "LEXER_TOKEN_TYPE_SUBTRACT", "subtract"}, {LEXER_TOKEN_TYPE_MULTIPLY, "LEXER_TOKEN_TYPE_MULTIPLY", "multiply"}, {LEXER_TOKEN_TYPE_DIVIDE, "LEXER_TOKEN_TYPE_DIVIDE", "divide"}, {LEXER_TOKEN_TYPE_MOD, "LEXER_TOKEN_TYPE_MOD", "mod"}, {LEXER_TOKEN_TYPE_L_FLOOR, "LEXER_TOKEN_TYPE_L_FLOOR", "l-floor"}, {LEXER_TOKEN_TYPE_R_FLOOR, "LEXER_TOKEN_TYPE_R_FLOOR", "r-floor"}, {LEXER_TOKEN_TYPE_L_CEILING, "LEXER_TOKEN_TYPE_L_CEILING", "l-ceiling"}, {LEXER_TOKEN_TYPE_R_CEILING, "LEXER_TOKEN_TYPE_R_CEILING", "r-ceiling"}, {LEXER_TOKEN_TYPE_ROOT, "LEXER_TOKEN_TYPE_ROOT", "root"}, {LEXER_TOKEN_TYPE_ROOT_3, "LEXER_TOKEN_TYPE_ROOT_3", "root-3"}, {LEXER_TOKEN_TYPE_ROOT_4, "LEXER_TOKEN_TYPE_ROOT_4", "root-4"}, {LEXER_TOKEN_TYPE_NOT, "LEXER_TOKEN_TYPE_NOT", "not"}, {LEXER_TOKEN_TYPE_AND, "LEXER_TOKEN_TYPE_AND", "and"}, {LEXER_TOKEN_TYPE_NAND, "LEXER_TOKEN_TYPE_NAND", "nand"}, {LEXER_TOKEN_TYPE_OR, "LEXER_TOKEN_TYPE_OR", "or"}, {LEXER_TOKEN_TYPE_NOR, "LEXER_TOKEN_TYPE_NOR", "nor"}, {LEXER_TOKEN_TYPE_XOR, "LEXER_TOKEN_TYPE_XOR", "xor"}, {LEXER_TOKEN_TYPE_XNOR, "LEXER_TOKEN_TYPE_XNOR", "xnor"}, {LEXER_TOKEN_TYPE_IN, "LEXER_TOKEN_TYPE_IN", "in"}, {LEXER_TOKEN_TYPE_NUMBER, "LEXER_TOKEN_TYPE_NUMBER", "number"}, {LEXER_TOKEN_TYPE_SUP_NUMBER, "LEXER_TOKEN_TYPE_SUP_NUMBER", "sup-number"}, {LEXER_TOKEN_TYPE_NSUP_NUMBER, "LEXER_TOKEN_TYPE_NSUP_NUMBER", "nsup-number"}, {LEXER_TOKEN_TYPE_SUB_NUMBER, "LEXER_TOKEN_TYPE_SUB_NUMBER", "sub-number"}, {LEXER_TOKEN_TYPE_FUNCTION, "LEXER_TOKEN_TYPE_FUNCTION", "function"}, {LEXER_TOKEN_TYPE_UNIT, "LEXER_TOKEN_TYPE_UNIT", "unit"}, {LEXER_TOKEN_TYPE_CURRENCY, "LEXER_TOKEN_TYPE_CURRENCY", "currency"}, {LEXER_TOKEN_TYPE_VARIABLE, "LEXER_TOKEN_TYPE_VARIABLE", "variable"}, {LEXER_TOKEN_TYPE_SHIFT_LEFT, "LEXER_TOKEN_TYPE_SHIFT_LEFT", "shift-left"}, {LEXER_TOKEN_TYPE_SHIFT_RIGHT, "LEXER_TOKEN_TYPE_SHIFT_RIGHT", "shift-right"}, {LEXER_TOKEN_TYPE_SHIFT_URIGHT, "LEXER_TOKEN_TYPE_SHIFT_URIGHT", "shift-uright"}, {LEXER_TOKEN_TYPE_ASSIGN, "LEXER_TOKEN_TYPE_ASSIGN", "assign"}, {LEXER_TOKEN_TYPE_L_R_BRACKET, "LEXER_TOKEN_TYPE_L_R_BRACKET", "l-r-bracket"}, {LEXER_TOKEN_TYPE_R_R_BRACKET, "LEXER_TOKEN_TYPE_R_R_BRACKET", "r-r-bracket"}, {LEXER_TOKEN_TYPE_L_S_BRACKET, "LEXER_TOKEN_TYPE_L_S_BRACKET", "l-s-bracket"}, {LEXER_TOKEN_TYPE_R_S_BRACKET, "LEXER_TOKEN_TYPE_R_S_BRACKET", "r-s-bracket"}, {LEXER_TOKEN_TYPE_L_C_BRACKET, "LEXER_TOKEN_TYPE_L_C_BRACKET", "l-c-bracket"}, {LEXER_TOKEN_TYPE_R_C_BRACKET, "LEXER_TOKEN_TYPE_R_C_BRACKET", "r-c-bracket"}, {LEXER_TOKEN_TYPE_ABS, "LEXER_TOKEN_TYPE_ABS", "abs"}, {LEXER_TOKEN_TYPE_POWER, "LEXER_TOKEN_TYPE_POWER", "power"}, {LEXER_TOKEN_TYPE_FACTORIAL, "LEXER_TOKEN_TYPE_FACTORIAL", "factorial"}, {LEXER_TOKEN_TYPE_PERCENTAGE, "LEXER_TOKEN_TYPE_PERCENTAGE", "percentage"}, {LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR, "LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR", "argument-separator"}, {LEXER_TOKEN_TYPE_FUNC_DESC_SEPARATOR, "LEXER_TOKEN_TYPE_FUNC_DESC_SEPARATOR", "func-desc-separator"}, {0, NULL, NULL}};
	GType lexer_token_type_type_id;
	lexer_token_type_type_id = g_enum_register_static ("LexerTokenType", values);
	return lexer_token_type_type_id;
}

GType
lexer_token_type_get_type (void)
{
	static gsize lexer_token_type_type_id__once = 0;
	if (g_once_init_enter (&lexer_token_type_type_id__once)) {
		GType lexer_token_type_type_id;
		lexer_token_type_type_id = lexer_token_type_get_type_once ();
		g_once_init_leave (&lexer_token_type_type_id__once, lexer_token_type_type_id);
	}
	return lexer_token_type_type_id__once;
}

static inline gpointer
pre_lexer_get_instance_private (PreLexer* self)
{
	return G_STRUCT_MEMBER_P (self, PreLexer_private_offset);
}

PreLexer*
pre_lexer_construct (GType object_type,
                     const gchar* input)
{
	PreLexer * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (input != NULL, NULL);
	self = (PreLexer*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (input);
	_g_free0 (self->stream);
	self->stream = _tmp0_;
	self->index = 0;
	self->mark_index = 0;
	return self;
}

PreLexer*
pre_lexer_new (const gchar* input)
{
	return pre_lexer_construct (TYPE_PRE_LEXER, input);
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

void
pre_lexer_roll_back (PreLexer* self)
{
	gunichar c = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	if (self->priv->eos) {
		self->priv->eos = FALSE;
		return;
	}
	_tmp0_ = self->stream;
	string_get_prev_char (_tmp0_, &self->index, &_tmp1_);
	c = _tmp1_;
}

void
pre_lexer_set_marker (PreLexer* self)
{
	g_return_if_fail (self != NULL);
	self->mark_index = self->index;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
pre_lexer_get_marked_substring (PreLexer* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->stream;
	_tmp1_ = string_substring (_tmp0_, (glong) self->mark_index, (glong) (self->index - self->mark_index));
	result = _tmp1_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

LexerTokenType
pre_lexer_get_next_token (PreLexer* self)
{
	gunichar c = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	LexerTokenType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->stream;
	_tmp2_ = string_get_next_char (_tmp0_, &self->index, &_tmp1_);
	c = _tmp1_;
	if (!_tmp2_) {
		self->priv->eos = TRUE;
		result = LEXER_TOKEN_TYPE_PL_EOS;
		return result;
	}
	self->priv->eos = FALSE;
	if (c == ((gunichar) ',')) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = c == ((gunichar) '.');
	}
	if (_tmp3_) {
		result = LEXER_TOKEN_TYPE_PL_DECIMAL;
		return result;
	}
	if (g_unichar_isdigit (c)) {
		result = LEXER_TOKEN_TYPE_PL_DIGIT;
		return result;
	}
	if (c >= ((gunichar) 'a')) {
		_tmp5_ = c <= ((gunichar) 'f');
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (c >= ((gunichar) 'A')) {
			_tmp6_ = c <= ((gunichar) 'F');
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	}
	if (_tmp4_) {
		result = LEXER_TOKEN_TYPE_PL_HEX;
		return result;
	}
	if (c == 8304U) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = c == 185U;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = c == 178U;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = c == 179U;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = c == 8308U;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = c == 8309U;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = c == 8310U;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = c == 8311U;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = c == 8312U;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = c == 8313U;
	}
	if (_tmp7_) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_DIGIT;
		return result;
	}
	if (c == 8315U) {
		result = LEXER_TOKEN_TYPE_PL_SUPER_MINUS;
		return result;
	}
	if (c == 8320U) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = c == 8321U;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = c == 8322U;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = c == 8323U;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = c == 8324U;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = c == 8325U;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = c == 8326U;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = c == 8327U;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = c == 8328U;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = c == 8329U;
	}
	if (_tmp16_) {
		result = LEXER_TOKEN_TYPE_PL_SUB_DIGIT;
		return result;
	}
	if (c == 189U) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = c == 8531U;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = c == 8532U;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		_tmp36_ = c == 188U;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = c == 190U;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		_tmp34_ = c == 8533U;
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = c == 8534U;
	}
	if (_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = c == 8535U;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		_tmp31_ = c == 8536U;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = c == 8537U;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = c == 8538U;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = c == 8539U;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = c == 8540U;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = c == 8541U;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = c == 8542U;
	}
	if (_tmp25_) {
		result = LEXER_TOKEN_TYPE_PL_FRACTION;
		return result;
	}
	if (c == 730U) {
		_tmp39_ = TRUE;
	} else {
		_tmp39_ = c == 176U;
	}
	if (_tmp39_) {
		result = LEXER_TOKEN_TYPE_PL_DEGREE;
		return result;
	}
	if (c == ((gunichar) '\'')) {
		_tmp41_ = TRUE;
	} else {
		_tmp41_ = c == 8242U;
	}
	if (_tmp41_) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = c == 8217U;
	}
	if (_tmp40_) {
		result = LEXER_TOKEN_TYPE_PL_MINUTE;
		return result;
	}
	if (c == ((gunichar) '"')) {
		_tmp43_ = TRUE;
	} else {
		_tmp43_ = c == 8243U;
	}
	if (_tmp43_) {
		_tmp42_ = TRUE;
	} else {
		_tmp42_ = c == 8221U;
	}
	if (_tmp42_) {
		result = LEXER_TOKEN_TYPE_PL_SECOND;
		return result;
	}
	if (g_unichar_isalpha (c)) {
		_tmp45_ = TRUE;
	} else {
		_tmp45_ = c == ((gunichar) '_');
	}
	if (_tmp45_) {
		_tmp44_ = TRUE;
	} else {
		_tmp44_ = c == ((gunichar) '\\');
	}
	if (_tmp44_) {
		result = LEXER_TOKEN_TYPE_PL_LETTER;
		return result;
	}
	if (c == 8743U) {
		result = LEXER_TOKEN_TYPE_AND;
		return result;
	}
	if (c == 8892U) {
		result = LEXER_TOKEN_TYPE_NAND;
		return result;
	}
	if (c == 8744U) {
		result = LEXER_TOKEN_TYPE_OR;
		return result;
	}
	if (c == 8893U) {
		result = LEXER_TOKEN_TYPE_NOR;
		return result;
	}
	if (c == 8891U) {
		_tmp46_ = TRUE;
	} else {
		_tmp46_ = c == 8853U;
	}
	if (_tmp46_) {
		result = LEXER_TOKEN_TYPE_XOR;
		return result;
	}
	if (c == 8857U) {
		result = LEXER_TOKEN_TYPE_XNOR;
		return result;
	}
	if (c == 172U) {
		_tmp47_ = TRUE;
	} else {
		_tmp47_ = c == ((gunichar) '~');
	}
	if (_tmp47_) {
		result = LEXER_TOKEN_TYPE_NOT;
		return result;
	}
	if (c == ((gunichar) '+')) {
		result = LEXER_TOKEN_TYPE_ADD;
		return result;
	}
	if (c == ((gunichar) '-')) {
		_tmp49_ = TRUE;
	} else {
		_tmp49_ = c == 8722U;
	}
	if (_tmp49_) {
		_tmp48_ = TRUE;
	} else {
		_tmp48_ = c == 8211U;
	}
	if (_tmp48_) {
		result = LEXER_TOKEN_TYPE_SUBTRACT;
		return result;
	}
	if (c == ((gunichar) '*')) {
		_tmp50_ = TRUE;
	} else {
		_tmp50_ = c == 215U;
	}
	if (_tmp50_) {
		result = LEXER_TOKEN_TYPE_MULTIPLY;
		return result;
	}
	if (c == ((gunichar) '/')) {
		_tmp52_ = TRUE;
	} else {
		_tmp52_ = c == 8725U;
	}
	if (_tmp52_) {
		_tmp51_ = TRUE;
	} else {
		_tmp51_ = c == 247U;
	}
	if (_tmp51_) {
		result = LEXER_TOKEN_TYPE_DIVIDE;
		return result;
	}
	if (c == 8970U) {
		result = LEXER_TOKEN_TYPE_L_FLOOR;
		return result;
	}
	if (c == 8971U) {
		result = LEXER_TOKEN_TYPE_R_FLOOR;
		return result;
	}
	if (c == 8968U) {
		result = LEXER_TOKEN_TYPE_L_CEILING;
		return result;
	}
	if (c == 8969U) {
		result = LEXER_TOKEN_TYPE_R_CEILING;
		return result;
	}
	if (c == 8730U) {
		result = LEXER_TOKEN_TYPE_ROOT;
		return result;
	}
	if (c == 8731U) {
		result = LEXER_TOKEN_TYPE_ROOT_3;
		return result;
	}
	if (c == 8732U) {
		result = LEXER_TOKEN_TYPE_ROOT_4;
		return result;
	}
	if (c == ((gunichar) '=')) {
		result = LEXER_TOKEN_TYPE_ASSIGN;
		return result;
	}
	if (c == ((gunichar) '(')) {
		result = LEXER_TOKEN_TYPE_L_R_BRACKET;
		return result;
	}
	if (c == ((gunichar) ')')) {
		result = LEXER_TOKEN_TYPE_R_R_BRACKET;
		return result;
	}
	if (c == ((gunichar) '[')) {
		result = LEXER_TOKEN_TYPE_L_S_BRACKET;
		return result;
	}
	if (c == ((gunichar) ']')) {
		result = LEXER_TOKEN_TYPE_R_S_BRACKET;
		return result;
	}
	if (c == ((gunichar) '{')) {
		result = LEXER_TOKEN_TYPE_L_C_BRACKET;
		return result;
	}
	if (c == ((gunichar) '}')) {
		result = LEXER_TOKEN_TYPE_R_C_BRACKET;
		return result;
	}
	if (c == ((gunichar) '|')) {
		result = LEXER_TOKEN_TYPE_ABS;
		return result;
	}
	if (c == ((gunichar) '^')) {
		result = LEXER_TOKEN_TYPE_POWER;
		return result;
	}
	if (c == ((gunichar) '!')) {
		result = LEXER_TOKEN_TYPE_FACTORIAL;
		return result;
	}
	if (c == ((gunichar) '%')) {
		result = LEXER_TOKEN_TYPE_PERCENTAGE;
		return result;
	}
	if (c == ((gunichar) ';')) {
		result = LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR;
		return result;
	}
	if (c == 8921U) {
		result = LEXER_TOKEN_TYPE_SHIFT_URIGHT;
		return result;
	}
	if (c == 187U) {
		_tmp53_ = TRUE;
	} else {
		_tmp53_ = c == 8811U;
	}
	if (_tmp53_) {
		result = LEXER_TOKEN_TYPE_SHIFT_RIGHT;
		return result;
	}
	if (c == 171U) {
		_tmp54_ = TRUE;
	} else {
		_tmp54_ = c == 8810U;
	}
	if (_tmp54_) {
		result = LEXER_TOKEN_TYPE_SHIFT_LEFT;
		return result;
	}
	if (c == ((gunichar) ' ')) {
		_tmp57_ = TRUE;
	} else {
		_tmp57_ = c == ((gunichar) '\r');
	}
	if (_tmp57_) {
		_tmp56_ = TRUE;
	} else {
		_tmp56_ = c == ((gunichar) '\t');
	}
	if (_tmp56_) {
		_tmp55_ = TRUE;
	} else {
		_tmp55_ = c == ((gunichar) '\n');
	}
	if (_tmp55_) {
		result = LEXER_TOKEN_TYPE_PL_SKIP;
		return result;
	}
	if (c == ((gunichar) '@')) {
		result = LEXER_TOKEN_TYPE_FUNC_DESC_SEPARATOR;
		return result;
	}
	result = LEXER_TOKEN_TYPE_UNKNOWN;
	return result;
}

static void
pre_lexer_class_init (PreLexerClass * klass,
                      gpointer klass_data)
{
	pre_lexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PreLexer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = pre_lexer_finalize;
}

static void
pre_lexer_instance_init (PreLexer * self,
                         gpointer klass)
{
	self->priv = pre_lexer_get_instance_private (self);
	self->priv->eos = FALSE;
}

static void
pre_lexer_finalize (GObject * obj)
{
	PreLexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRE_LEXER, PreLexer);
	_g_free0 (self->stream);
	G_OBJECT_CLASS (pre_lexer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
pre_lexer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreLexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pre_lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreLexer), 0, (GInstanceInitFunc) pre_lexer_instance_init, NULL };
	GType pre_lexer_type_id;
	pre_lexer_type_id = g_type_register_static (G_TYPE_OBJECT, "PreLexer", &g_define_type_info, 0);
	PreLexer_private_offset = g_type_add_instance_private (pre_lexer_type_id, sizeof (PreLexerPrivate));
	return pre_lexer_type_id;
}

GType
pre_lexer_get_type (void)
{
	static gsize pre_lexer_type_id__once = 0;
	if (g_once_init_enter (&pre_lexer_type_id__once)) {
		GType pre_lexer_type_id;
		pre_lexer_type_id = pre_lexer_get_type_once ();
		g_once_init_leave (&pre_lexer_type_id__once, pre_lexer_type_id);
	}
	return pre_lexer_type_id__once;
}

LexerToken*
lexer_token_construct (GType object_type)
{
	LexerToken * self = NULL;
	self = (LexerToken*) g_object_new (object_type, NULL);
	return self;
}

LexerToken*
lexer_token_new (void)
{
	return lexer_token_construct (TYPE_LEXER_TOKEN);
}

static void
lexer_token_class_init (LexerTokenClass * klass,
                        gpointer klass_data)
{
	lexer_token_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = lexer_token_finalize;
}

static void
lexer_token_instance_init (LexerToken * self,
                           gpointer klass)
{
}

static void
lexer_token_finalize (GObject * obj)
{
	LexerToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER_TOKEN, LexerToken);
	_g_free0 (self->text);
	G_OBJECT_CLASS (lexer_token_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
lexer_token_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LexerTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LexerToken), 0, (GInstanceInitFunc) lexer_token_instance_init, NULL };
	GType lexer_token_type_id;
	lexer_token_type_id = g_type_register_static (G_TYPE_OBJECT, "LexerToken", &g_define_type_info, 0);
	return lexer_token_type_id;
}

GType
lexer_token_get_type (void)
{
	static gsize lexer_token_type_id__once = 0;
	if (g_once_init_enter (&lexer_token_type_id__once)) {
		GType lexer_token_type_id;
		lexer_token_type_id = lexer_token_get_type_once ();
		g_once_init_leave (&lexer_token_type_id__once, lexer_token_type_id);
	}
	return lexer_token_type_id__once;
}

static inline gpointer
lexer_get_instance_private (Lexer* self)
{
	return G_STRUCT_MEMBER_P (self, Lexer_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}

Lexer*
lexer_construct (GType object_type,
                 const gchar* input,
                 Parser* parser,
                 gint number_base)
{
	Lexer * self = NULL;
	PreLexer* _tmp0_;
	Parser* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	self = (Lexer*) g_object_new (object_type, NULL);
	_tmp0_ = pre_lexer_new (input);
	_g_object_unref0 (self->priv->prelexer);
	self->priv->prelexer = _tmp0_;
	(self->tokens == NULL) ? NULL : (self->tokens = (_g_list_free__g_object_unref0_ (self->tokens), NULL));
	self->tokens = NULL;
	self->priv->next_token = (guint) 0;
	_tmp1_ = _parser_ref0 (parser);
	_parser_unref0 (self->priv->parser);
	self->priv->parser = _tmp1_;
	self->priv->number_base = number_base;
	return self;
}

Lexer*
lexer_new (const gchar* input,
           Parser* parser,
           gint number_base)
{
	return lexer_construct (TYPE_LEXER, input, parser, number_base);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
lexer_scan (Lexer* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		LexerToken* token = NULL;
		LexerToken* _tmp0_;
		LexerToken* _tmp1_;
		LexerToken* _tmp2_;
		LexerToken* _tmp3_;
		_tmp0_ = lexer_insert_next_token (self);
		token = _tmp0_;
		_tmp1_ = token;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		self->tokens = g_list_append (self->tokens, _tmp2_);
		_tmp3_ = token;
		if (_tmp3_->type == LEXER_TOKEN_TYPE_PL_EOS) {
			_g_object_unref0 (token);
			break;
		}
		_g_object_unref0 (token);
	}
	{
		GList* element = NULL;
		GList* _tmp4_;
		GList* _tmp5_;
		_tmp4_ = self->tokens;
		_tmp5_ = g_list_first (_tmp4_);
		element = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GList* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				GList* _tmp15_;
				gconstpointer _tmp16_;
				if (!_tmp6_) {
					GList* _tmp7_;
					GList* _tmp8_;
					_tmp7_ = element;
					_tmp8_ = _tmp7_->next;
					element = _tmp8_;
				}
				_tmp6_ = FALSE;
				_tmp9_ = element;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp15_ = element;
				_tmp16_ = _tmp15_->data;
				if (((LexerToken*) _tmp16_)->type == LEXER_TOKEN_TYPE_UNIT) {
					_tmp14_ = TRUE;
				} else {
					GList* _tmp17_;
					gconstpointer _tmp18_;
					_tmp17_ = element;
					_tmp18_ = _tmp17_->data;
					_tmp14_ = ((LexerToken*) _tmp18_)->type == LEXER_TOKEN_TYPE_CURRENCY;
				}
				if (_tmp14_) {
					gboolean _tmp19_ = FALSE;
					GList* _tmp20_;
					GList* _tmp21_;
					_tmp20_ = element;
					_tmp21_ = _tmp20_->prev;
					if (_tmp21_ == NULL) {
						_tmp19_ = TRUE;
					} else {
						GList* _tmp22_;
						GList* _tmp23_;
						gconstpointer _tmp24_;
						_tmp22_ = element;
						_tmp23_ = _tmp22_->prev;
						_tmp24_ = _tmp23_->data;
						_tmp19_ = ((LexerToken*) _tmp24_)->type != LEXER_TOKEN_TYPE_IN;
					}
					_tmp13_ = _tmp19_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gboolean _tmp25_ = FALSE;
					GList* _tmp26_;
					GList* _tmp27_;
					_tmp26_ = element;
					_tmp27_ = _tmp26_->next;
					if (_tmp27_ == NULL) {
						_tmp25_ = TRUE;
					} else {
						GList* _tmp28_;
						GList* _tmp29_;
						gconstpointer _tmp30_;
						_tmp28_ = element;
						_tmp29_ = _tmp28_->next;
						_tmp30_ = _tmp29_->data;
						_tmp25_ = ((LexerToken*) _tmp30_)->type != LEXER_TOKEN_TYPE_IN;
					}
					_tmp12_ = _tmp25_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					GList* _tmp31_;
					gconstpointer _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = element;
					_tmp32_ = _tmp31_->data;
					_tmp33_ = ((LexerToken*) _tmp32_)->text;
					_tmp11_ = !g_str_has_prefix (_tmp33_, "°");
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GList* _tmp34_;
					gconstpointer _tmp35_;
					const gchar* _tmp36_;
					_tmp34_ = element;
					_tmp35_ = _tmp34_->data;
					_tmp36_ = ((LexerToken*) _tmp35_)->text;
					_tmp10_ = !g_str_has_prefix (_tmp36_, "˚");
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					GList* _tmp37_;
					gconstpointer _tmp38_;
					_tmp37_ = element;
					_tmp38_ = _tmp37_->data;
					((LexerToken*) _tmp38_)->type = LEXER_TOKEN_TYPE_VARIABLE;
				}
			}
		}
	}
}

LexerToken*
lexer_get_next_token (Lexer* self)
{
	GList* _tmp0_;
	GList* _tmp5_;
	guint _tmp6_;
	gconstpointer _tmp7_;
	LexerToken* _tmp8_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tokens;
	if (self->priv->next_token >= g_list_length (_tmp0_)) {
		GList* _tmp1_;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		LexerToken* _tmp4_;
		_tmp1_ = self->tokens;
		_tmp2_ = self->tokens;
		_tmp3_ = g_list_nth_data (_tmp1_, g_list_length (_tmp2_) - 1);
		_tmp4_ = _g_object_ref0 ((LexerToken*) _tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->tokens;
	_tmp6_ = self->priv->next_token;
	self->priv->next_token = _tmp6_ + 1;
	_tmp7_ = g_list_nth_data (_tmp5_, _tmp6_);
	_tmp8_ = _g_object_ref0 ((LexerToken*) _tmp7_);
	result = _tmp8_;
	return result;
}

void
lexer_roll_back (Lexer* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->next_token > ((guint) 0)) {
		guint _tmp0_;
		_tmp0_ = self->priv->next_token;
		self->priv->next_token = _tmp0_ - 1;
	}
}

static gboolean
lexer_check_if_function (Lexer* self)
{
	gchar* name = NULL;
	PreLexer* _tmp0_;
	gchar* _tmp1_;
	Parser* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->parser;
	result = parser_function_is_defined (_tmp2_, name);
	_g_free0 (name);
	return result;
}

static gboolean
lexer_check_if_unit (Lexer* self)
{
	gint super_count = 0;
	PreLexer* _tmp2_;
	gchar* name = NULL;
	PreLexer* _tmp3_;
	gchar* _tmp4_;
	Parser* _tmp5_;
	const gchar* _tmp6_;
	PreLexer* _tmp9_;
	gchar* _tmp10_;
	Parser* _tmp11_;
	const gchar* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	super_count = 0;
	while (TRUE) {
		PreLexer* _tmp0_;
		gint _tmp1_;
		_tmp0_ = self->priv->prelexer;
		if (!(pre_lexer_get_next_token (_tmp0_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
			break;
		}
		_tmp1_ = super_count;
		super_count = _tmp1_ + 1;
	}
	_tmp2_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp2_);
	_tmp3_ = self->priv->prelexer;
	_tmp4_ = pre_lexer_get_marked_substring (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->parser;
	_tmp6_ = name;
	if (parser_unit_is_defined (_tmp5_, _tmp6_)) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	while (TRUE) {
		gint _tmp7_;
		PreLexer* _tmp8_;
		_tmp7_ = super_count;
		super_count = _tmp7_ - 1;
		if (!(_tmp7_ > 0)) {
			break;
		}
		_tmp8_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp8_);
	}
	_tmp9_ = self->priv->prelexer;
	_tmp10_ = pre_lexer_get_marked_substring (_tmp9_);
	_g_free0 (name);
	name = _tmp10_;
	_tmp11_ = self->priv->parser;
	_tmp12_ = name;
	result = parser_unit_is_defined (_tmp11_, _tmp12_);
	_g_free0 (name);
	return result;
}

static gboolean
lexer_check_if_currency (Lexer* self)
{
	gint super_count = 0;
	PreLexer* _tmp2_;
	gchar* name = NULL;
	PreLexer* _tmp3_;
	gchar* _tmp4_;
	Parser* _tmp5_;
	const gchar* _tmp6_;
	PreLexer* _tmp9_;
	gchar* _tmp10_;
	Parser* _tmp11_;
	const gchar* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	super_count = 0;
	while (TRUE) {
		PreLexer* _tmp0_;
		gint _tmp1_;
		_tmp0_ = self->priv->prelexer;
		if (!(pre_lexer_get_next_token (_tmp0_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
			break;
		}
		_tmp1_ = super_count;
		super_count = _tmp1_ + 1;
	}
	_tmp2_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp2_);
	_tmp3_ = self->priv->prelexer;
	_tmp4_ = pre_lexer_get_marked_substring (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->parser;
	_tmp6_ = name;
	if (parser_currency_is_defined (_tmp5_, _tmp6_)) {
		result = TRUE;
		_g_free0 (name);
		return result;
	}
	while (TRUE) {
		gint _tmp7_;
		PreLexer* _tmp8_;
		_tmp7_ = super_count;
		super_count = _tmp7_ - 1;
		if (!(_tmp7_ > 0)) {
			break;
		}
		_tmp8_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp8_);
	}
	_tmp9_ = self->priv->prelexer;
	_tmp10_ = pre_lexer_get_marked_substring (_tmp9_);
	_g_free0 (name);
	name = _tmp10_;
	_tmp11_ = self->priv->parser;
	_tmp12_ = name;
	result = parser_currency_is_defined (_tmp11_, _tmp12_);
	_g_free0 (name);
	return result;
}

static gboolean
lexer_check_if_literal_base (Lexer* self)
{
	gchar* name = NULL;
	PreLexer* _tmp0_;
	gchar* _tmp1_;
	Parser* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->parser;
	_tmp3_ = g_utf8_strdown (name, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = parser_literal_base_is_defined (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	result = _tmp5_;
	_g_free0 (name);
	return result;
}

static gboolean
lexer_check_if_number (Lexer* self)
{
	gint count = 0;
	gchar* text = NULL;
	PreLexer* _tmp0_;
	gchar* _tmp1_;
	Number* tmp = NULL;
	const gchar* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	count = 0;
	_tmp0_ = self->priv->prelexer;
	_tmp1_ = pre_lexer_get_marked_substring (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = mp_set_from_string (_tmp2_, self->priv->number_base, TRUE);
	tmp = _tmp3_;
	_tmp4_ = tmp;
	if (_tmp4_ != NULL) {
		result = TRUE;
		_g_object_unref0 (tmp);
		_g_free0 (text);
		return result;
	} else {
		while (TRUE) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			Number* _tmp7_;
			Number* _tmp8_;
			gint _tmp9_;
			PreLexer* _tmp10_;
			PreLexer* _tmp11_;
			gchar* _tmp12_;
			_tmp5_ = text;
			if (!(g_strcmp0 (_tmp5_, "") != 0)) {
				break;
			}
			_tmp6_ = text;
			_tmp7_ = mp_set_from_string (_tmp6_, self->priv->number_base, TRUE);
			_g_object_unref0 (tmp);
			tmp = _tmp7_;
			_tmp8_ = tmp;
			if (_tmp8_ != NULL) {
				result = TRUE;
				_g_object_unref0 (tmp);
				_g_free0 (text);
				return result;
			}
			_tmp9_ = count;
			count = _tmp9_ + 1;
			_tmp10_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp10_);
			_tmp11_ = self->priv->prelexer;
			_tmp12_ = pre_lexer_get_marked_substring (_tmp11_);
			_g_free0 (text);
			text = _tmp12_;
		}
		while (TRUE) {
			gint _tmp13_;
			PreLexer* _tmp14_;
			_tmp13_ = count;
			count = _tmp13_ - 1;
			if (!(_tmp13_ > 0)) {
				break;
			}
			_tmp14_ = self->priv->prelexer;
			pre_lexer_get_next_token (_tmp14_);
		}
		result = FALSE;
		_g_object_unref0 (tmp);
		_g_free0 (text);
		return result;
	}
}

static LexerToken*
lexer_insert_token (Lexer* self,
                    LexerTokenType type)
{
	LexerToken* token = NULL;
	LexerToken* _tmp0_;
	PreLexer* _tmp1_;
	gchar* _tmp2_;
	PreLexer* _tmp3_;
	PreLexer* _tmp4_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = lexer_token_new ();
	token = _tmp0_;
	_tmp1_ = self->priv->prelexer;
	_tmp2_ = pre_lexer_get_marked_substring (_tmp1_);
	_g_free0 (token->text);
	token->text = _tmp2_;
	_tmp3_ = self->priv->prelexer;
	token->start_index = (guint) _tmp3_->mark_index;
	_tmp4_ = self->priv->prelexer;
	token->end_index = (guint) _tmp4_->index;
	token->type = type;
	result = token;
	return result;
}

static LexerToken*
lexer_insert_next_token (Lexer* self)
{
	PreLexer* _tmp0_;
	LexerTokenType type = 0;
	PreLexer* _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	Parser* _tmp63_;
	PreLexer* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	PreLexer* _tmp67_;
	PreLexer* _tmp68_;
	LexerToken* _tmp69_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	pre_lexer_set_marker (_tmp0_);
	_tmp1_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp1_);
	while (TRUE) {
		PreLexer* _tmp2_;
		PreLexer* _tmp3_;
		if (!(type == LEXER_TOKEN_TYPE_PL_SKIP)) {
			break;
		}
		_tmp2_ = self->priv->prelexer;
		pre_lexer_set_marker (_tmp2_);
		_tmp3_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp3_);
	}
	if (type == LEXER_TOKEN_TYPE_AND) {
		_tmp36_ = TRUE;
	} else {
		_tmp36_ = type == LEXER_TOKEN_TYPE_OR;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = type == LEXER_TOKEN_TYPE_XOR;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		_tmp34_ = type == LEXER_TOKEN_TYPE_NOT;
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = type == LEXER_TOKEN_TYPE_NAND;
	}
	if (_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = type == LEXER_TOKEN_TYPE_NOR;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		_tmp31_ = type == LEXER_TOKEN_TYPE_XNOR;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = type == LEXER_TOKEN_TYPE_ADD;
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = type == LEXER_TOKEN_TYPE_SUBTRACT;
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = type == LEXER_TOKEN_TYPE_MULTIPLY;
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = type == LEXER_TOKEN_TYPE_DIVIDE;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = type == LEXER_TOKEN_TYPE_L_FLOOR;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = type == LEXER_TOKEN_TYPE_R_FLOOR;
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = type == LEXER_TOKEN_TYPE_L_CEILING;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = type == LEXER_TOKEN_TYPE_R_CEILING;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = type == LEXER_TOKEN_TYPE_ROOT;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = type == LEXER_TOKEN_TYPE_ROOT_3;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = type == LEXER_TOKEN_TYPE_ROOT_4;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = type == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = type == LEXER_TOKEN_TYPE_L_R_BRACKET;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = type == LEXER_TOKEN_TYPE_R_R_BRACKET;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = type == LEXER_TOKEN_TYPE_L_S_BRACKET;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = type == LEXER_TOKEN_TYPE_R_S_BRACKET;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = type == LEXER_TOKEN_TYPE_L_C_BRACKET;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = type == LEXER_TOKEN_TYPE_R_C_BRACKET;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = type == LEXER_TOKEN_TYPE_ABS;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = type == LEXER_TOKEN_TYPE_POWER;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = type == LEXER_TOKEN_TYPE_FACTORIAL;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = type == LEXER_TOKEN_TYPE_PERCENTAGE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = type == LEXER_TOKEN_TYPE_ARGUMENT_SEPARATOR;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = type == LEXER_TOKEN_TYPE_SHIFT_LEFT;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = type == LEXER_TOKEN_TYPE_SHIFT_RIGHT;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = type == LEXER_TOKEN_TYPE_SHIFT_URIGHT;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = type == LEXER_TOKEN_TYPE_FUNC_DESC_SEPARATOR;
	}
	if (_tmp4_) {
		LexerToken* _tmp37_;
		_tmp37_ = lexer_insert_token (self, type);
		result = _tmp37_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_SUPER_MINUS) {
		PreLexer* _tmp38_;
		PreLexer* _tmp45_;
		LexerToken* _tmp46_;
		_tmp38_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp38_);
		if (type != LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
			PreLexer* _tmp39_;
			Parser* _tmp40_;
			PreLexer* _tmp41_;
			PreLexer* _tmp42_;
			LexerToken* _tmp43_;
			_tmp39_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp39_);
			_tmp40_ = self->priv->parser;
			_tmp41_ = self->priv->prelexer;
			_tmp42_ = self->priv->prelexer;
			parser_set_error (_tmp40_, ERROR_CODE_MP, _ ("Missing digits after minus sign"), (guint) _tmp41_->mark_index, (guint) _tmp42_->index);
			_tmp43_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp43_;
			return result;
		}
		while (TRUE) {
			PreLexer* _tmp44_;
			_tmp44_ = self->priv->prelexer;
			if (!(pre_lexer_get_next_token (_tmp44_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp45_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp45_);
		_tmp46_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NSUP_NUMBER);
		result = _tmp46_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT) {
		PreLexer* _tmp48_;
		LexerToken* _tmp49_;
		while (TRUE) {
			PreLexer* _tmp47_;
			_tmp47_ = self->priv->prelexer;
			if (!(pre_lexer_get_next_token (_tmp47_) == LEXER_TOKEN_TYPE_PL_SUPER_DIGIT)) {
				break;
			}
		}
		_tmp48_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp48_);
		_tmp49_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUP_NUMBER);
		result = _tmp49_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
		PreLexer* _tmp51_;
		LexerToken* _tmp52_;
		while (TRUE) {
			PreLexer* _tmp50_;
			_tmp50_ = self->priv->prelexer;
			if (!(pre_lexer_get_next_token (_tmp50_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
				break;
			}
		}
		_tmp51_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp51_);
		_tmp52_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_SUB_NUMBER);
		result = _tmp52_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp53_;
		_tmp53_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp53_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp54_;
		_tmp54_ = lexer_insert_digit (self);
		result = _tmp54_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp55_;
		_tmp55_ = lexer_insert_decimal (self);
		result = _tmp55_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_HEX) {
		LexerToken* _tmp56_;
		_tmp56_ = lexer_insert_hex (self);
		result = _tmp56_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_LETTER) {
		LexerToken* _tmp57_;
		_tmp57_ = lexer_insert_letter (self);
		result = _tmp57_;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PL_DEGREE) {
		PreLexer* _tmp58_;
		gboolean _tmp59_ = FALSE;
		gboolean _tmp60_ = FALSE;
		_tmp58_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp58_);
		if (type == LEXER_TOKEN_TYPE_PL_HEX) {
			_tmp60_ = TRUE;
		} else {
			_tmp60_ = type == LEXER_TOKEN_TYPE_PL_LETTER;
		}
		if (_tmp60_) {
			_tmp59_ = lexer_check_if_unit (self);
		} else {
			_tmp59_ = FALSE;
		}
		if (_tmp59_) {
			LexerToken* _tmp61_;
			_tmp61_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
			result = _tmp61_;
			return result;
		}
	}
	if (type == LEXER_TOKEN_TYPE_PL_EOS) {
		LexerToken* _tmp62_;
		_tmp62_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_PL_EOS);
		result = _tmp62_;
		return result;
	}
	_tmp63_ = self->priv->parser;
	_tmp64_ = self->priv->prelexer;
	_tmp65_ = pre_lexer_get_marked_substring (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = self->priv->prelexer;
	_tmp68_ = self->priv->prelexer;
	parser_set_error (_tmp63_, ERROR_CODE_INVALID, _tmp66_, (guint) _tmp67_->mark_index, (guint) _tmp68_->index);
	_g_free0 (_tmp66_);
	_tmp69_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
	result = _tmp69_;
	return result;
}

static LexerToken*
lexer_insert_digit (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		PreLexer* _tmp1_;
		if (!(type == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
		_tmp1_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp1_);
	}
	if (type == LEXER_TOKEN_TYPE_PL_FRACTION) {
		LexerToken* _tmp2_;
		_tmp2_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp2_;
		return result;
	} else {
		if (type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp4_;
			LexerToken* _tmp5_;
			while (TRUE) {
				PreLexer* _tmp3_;
				_tmp3_ = self->priv->prelexer;
				if (!(pre_lexer_get_next_token (_tmp3_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp4_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp4_);
			_tmp5_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp5_;
			return result;
		} else {
			if (type == LEXER_TOKEN_TYPE_PL_DEGREE) {
				PreLexer* _tmp6_;
				_tmp6_ = self->priv->prelexer;
				type = pre_lexer_get_next_token (_tmp6_);
				if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
					while (TRUE) {
						PreLexer* _tmp7_;
						_tmp7_ = self->priv->prelexer;
						type = pre_lexer_get_next_token (_tmp7_);
						if (!(type == LEXER_TOKEN_TYPE_PL_DIGIT)) {
							break;
						}
					}
					if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp8_;
						_tmp8_ = lexer_insert_angle_num_dm (self);
						result = _tmp8_;
						return result;
					} else {
						if (type == LEXER_TOKEN_TYPE_PL_MINUTE) {
							PreLexer* _tmp9_;
							_tmp9_ = self->priv->prelexer;
							type = pre_lexer_get_next_token (_tmp9_);
							if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
								while (TRUE) {
									PreLexer* _tmp10_;
									_tmp10_ = self->priv->prelexer;
									type = pre_lexer_get_next_token (_tmp10_);
									if (!(type == LEXER_TOKEN_TYPE_PL_DIGIT)) {
										break;
									}
								}
								if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp11_;
									_tmp11_ = lexer_insert_angle_num_dms (self);
									result = _tmp11_;
									return result;
								} else {
									if (type == LEXER_TOKEN_TYPE_PL_SECOND) {
										LexerToken* _tmp12_;
										_tmp12_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
										result = _tmp12_;
										return result;
									} else {
										PreLexer* _tmp13_;
										Parser* _tmp14_;
										PreLexer* _tmp15_;
										PreLexer* _tmp16_;
										LexerToken* _tmp17_;
										_tmp13_ = self->priv->prelexer;
										pre_lexer_roll_back (_tmp13_);
										_tmp14_ = self->priv->parser;
										_tmp15_ = self->priv->prelexer;
										_tmp16_ = self->priv->prelexer;
										parser_set_error (_tmp14_, ERROR_CODE_MP, _ ("Missing second symbol (″)"), (guint) _tmp15_->mark_index, (guint) _tmp16_->index);
										_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
										result = _tmp17_;
										return result;
									}
								}
							} else {
								if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
									LexerToken* _tmp18_;
									_tmp18_ = lexer_insert_angle_num_dms (self);
									result = _tmp18_;
									return result;
								} else {
									PreLexer* _tmp19_;
									LexerToken* _tmp20_;
									_tmp19_ = self->priv->prelexer;
									pre_lexer_roll_back (_tmp19_);
									_tmp20_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
									result = _tmp20_;
									return result;
								}
							}
						} else {
							PreLexer* _tmp21_;
							Parser* _tmp22_;
							PreLexer* _tmp23_;
							PreLexer* _tmp24_;
							LexerToken* _tmp25_;
							_tmp21_ = self->priv->prelexer;
							pre_lexer_roll_back (_tmp21_);
							_tmp22_ = self->priv->parser;
							_tmp23_ = self->priv->prelexer;
							_tmp24_ = self->priv->prelexer;
							parser_set_error (_tmp22_, ERROR_CODE_MP, _ ("Missing minute symbol (′)"), (guint) _tmp23_->mark_index, (guint) _tmp24_->index);
							_tmp25_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
							result = _tmp25_;
							return result;
						}
					}
				} else {
					if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
						LexerToken* _tmp26_;
						_tmp26_ = lexer_insert_angle_num_dm (self);
						result = _tmp26_;
						return result;
					} else {
						LexerToken* _tmp27_;
						_tmp27_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp27_;
						return result;
					}
				}
			} else {
				if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
					LexerToken* _tmp28_;
					_tmp28_ = lexer_insert_decimal (self);
					result = _tmp28_;
					return result;
				} else {
					if (lexer_check_if_literal_base (self)) {
						LexerToken* _tmp29_;
						_tmp29_ = lexer_insert_hex (self);
						result = _tmp29_;
						return result;
					} else {
						if (type == LEXER_TOKEN_TYPE_PL_HEX) {
							LexerToken* _tmp30_;
							_tmp30_ = lexer_insert_hex_dec (self);
							result = _tmp30_;
							return result;
						} else {
							PreLexer* _tmp31_;
							LexerToken* _tmp32_;
							_tmp31_ = self->priv->prelexer;
							pre_lexer_roll_back (_tmp31_);
							_tmp32_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
							result = _tmp32_;
							return result;
						}
					}
				}
			}
		}
	}
}

static LexerToken*
lexer_insert_angle_num_dm (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	if (type != LEXER_TOKEN_TYPE_PL_DIGIT) {
		PreLexer* _tmp1_;
		Parser* _tmp2_;
		PreLexer* _tmp3_;
		PreLexer* _tmp4_;
		LexerToken* _tmp5_;
		_tmp1_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp1_);
		_tmp2_ = self->priv->parser;
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = self->priv->prelexer;
		parser_set_error (_tmp2_, ERROR_CODE_MP, _ ("Missing digits after decimal point"), (guint) _tmp3_->mark_index, (guint) _tmp4_->index);
		_tmp5_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp5_;
		return result;
	}
	while (TRUE) {
		PreLexer* _tmp6_;
		if (!(type == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
		_tmp6_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp6_);
	}
	if (type == LEXER_TOKEN_TYPE_PL_MINUTE) {
		LexerToken* _tmp7_;
		_tmp7_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp7_;
		return result;
	} else {
		PreLexer* _tmp8_;
		Parser* _tmp9_;
		PreLexer* _tmp10_;
		PreLexer* _tmp11_;
		LexerToken* _tmp12_;
		_tmp8_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp8_);
		_tmp9_ = self->priv->parser;
		_tmp10_ = self->priv->prelexer;
		_tmp11_ = self->priv->prelexer;
		parser_set_error (_tmp9_, ERROR_CODE_MP, _ ("Missing minute symbol (′)"), (guint) _tmp10_->mark_index, (guint) _tmp11_->index);
		_tmp12_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp12_;
		return result;
	}
}

static LexerToken*
lexer_insert_angle_num_dms (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	if (type != LEXER_TOKEN_TYPE_PL_DIGIT) {
		PreLexer* _tmp1_;
		Parser* _tmp2_;
		PreLexer* _tmp3_;
		PreLexer* _tmp4_;
		LexerToken* _tmp5_;
		_tmp1_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp1_);
		_tmp2_ = self->priv->parser;
		_tmp3_ = self->priv->prelexer;
		_tmp4_ = self->priv->prelexer;
		parser_set_error (_tmp2_, ERROR_CODE_MP, _ ("Missing digits after decimal point"), (guint) _tmp3_->mark_index, (guint) _tmp4_->index);
		_tmp5_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp5_;
		return result;
	}
	while (TRUE) {
		PreLexer* _tmp6_;
		_tmp6_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp6_);
		if (!(type == LEXER_TOKEN_TYPE_PL_DIGIT)) {
			break;
		}
	}
	if (type == LEXER_TOKEN_TYPE_PL_SECOND) {
		LexerToken* _tmp7_;
		_tmp7_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
		result = _tmp7_;
		return result;
	} else {
		PreLexer* _tmp8_;
		Parser* _tmp9_;
		PreLexer* _tmp10_;
		PreLexer* _tmp11_;
		LexerToken* _tmp12_;
		_tmp8_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp8_);
		_tmp9_ = self->priv->parser;
		_tmp10_ = self->priv->prelexer;
		_tmp11_ = self->priv->prelexer;
		parser_set_error (_tmp9_, ERROR_CODE_MP, _ ("Missing second symbol (″)"), (guint) _tmp10_->mark_index, (guint) _tmp11_->index);
		_tmp12_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp12_;
		return result;
	}
}

static LexerToken*
lexer_insert_decimal (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
		while (TRUE) {
			PreLexer* _tmp1_;
			_tmp1_ = self->priv->prelexer;
			type = pre_lexer_get_next_token (_tmp1_);
			if (!(type == LEXER_TOKEN_TYPE_PL_DIGIT)) {
				break;
			}
		}
		if (type == LEXER_TOKEN_TYPE_PL_DEGREE) {
			LexerToken* _tmp2_;
			_tmp2_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp2_;
			return result;
		} else {
			if (type == LEXER_TOKEN_TYPE_PL_HEX) {
				LexerToken* _tmp3_;
				_tmp3_ = lexer_insert_decimal_hex (self);
				result = _tmp3_;
				return result;
			} else {
				if (type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
					PreLexer* _tmp5_;
					LexerToken* _tmp6_;
					while (TRUE) {
						PreLexer* _tmp4_;
						_tmp4_ = self->priv->prelexer;
						if (!(pre_lexer_get_next_token (_tmp4_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
							break;
						}
					}
					_tmp5_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp5_);
					_tmp6_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp6_;
					return result;
				} else {
					PreLexer* _tmp7_;
					LexerToken* _tmp8_;
					_tmp7_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp7_);
					_tmp8_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp8_;
					return result;
				}
			}
		}
	} else {
		if (type == LEXER_TOKEN_TYPE_PL_HEX) {
			LexerToken* _tmp9_;
			_tmp9_ = lexer_insert_decimal_hex (self);
			result = _tmp9_;
			return result;
		} else {
			PreLexer* _tmp10_;
			Parser* _tmp11_;
			PreLexer* _tmp12_;
			PreLexer* _tmp13_;
			LexerToken* _tmp14_;
			_tmp10_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp10_);
			_tmp11_ = self->priv->parser;
			_tmp12_ = self->priv->prelexer;
			_tmp13_ = self->priv->prelexer;
			parser_set_error (_tmp11_, ERROR_CODE_MP, _ ("Missing digits after decimal point"), (guint) _tmp12_->mark_index, (guint) _tmp13_->index);
			_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp14_;
			return result;
		}
	}
}

static LexerToken*
lexer_insert_hex (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		PreLexer* _tmp1_;
		if (!(type == LEXER_TOKEN_TYPE_PL_HEX)) {
			break;
		}
		_tmp1_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp1_);
	}
	if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
		LexerToken* _tmp2_;
		_tmp2_ = lexer_insert_hex_dec (self);
		result = _tmp2_;
		return result;
	} else {
		if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
			LexerToken* _tmp3_;
			_tmp3_ = lexer_insert_decimal_hex (self);
			result = _tmp3_;
			return result;
		} else {
			if (type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
				PreLexer* _tmp5_;
				while (TRUE) {
					PreLexer* _tmp4_;
					_tmp4_ = self->priv->prelexer;
					if (!(pre_lexer_get_next_token (_tmp4_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
						break;
					}
				}
				_tmp5_ = self->priv->prelexer;
				pre_lexer_roll_back (_tmp5_);
				if (lexer_check_if_number (self)) {
					LexerToken* _tmp6_;
					_tmp6_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
					result = _tmp6_;
					return result;
				} else {
					if (lexer_check_if_function (self)) {
						LexerToken* _tmp7_;
						_tmp7_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
						result = _tmp7_;
						return result;
					} else {
						if (lexer_check_if_currency (self)) {
							LexerToken* _tmp8_;
							_tmp8_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_CURRENCY);
							result = _tmp8_;
							return result;
						} else {
							if (lexer_check_if_unit (self)) {
								LexerToken* _tmp9_;
								_tmp9_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
								result = _tmp9_;
								return result;
							} else {
								LexerToken* _tmp10_;
								_tmp10_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
								result = _tmp10_;
								return result;
							}
						}
					}
				}
			} else {
				if (type == LEXER_TOKEN_TYPE_PL_LETTER) {
					LexerToken* _tmp11_;
					_tmp11_ = lexer_insert_letter (self);
					result = _tmp11_;
					return result;
				} else {
					PreLexer* _tmp12_;
					_tmp12_ = self->priv->prelexer;
					pre_lexer_roll_back (_tmp12_);
					if (lexer_check_if_number (self)) {
						LexerToken* _tmp13_;
						_tmp13_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
						result = _tmp13_;
						return result;
					} else {
						if (lexer_check_if_function (self)) {
							LexerToken* _tmp14_;
							_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
							result = _tmp14_;
							return result;
						} else {
							if (lexer_check_if_currency (self)) {
								LexerToken* _tmp15_;
								_tmp15_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_CURRENCY);
								result = _tmp15_;
								return result;
							} else {
								if (lexer_check_if_unit (self)) {
									LexerToken* _tmp16_;
									_tmp16_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
									result = _tmp16_;
									return result;
								} else {
									LexerToken* _tmp17_;
									_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
									result = _tmp17_;
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
}

static LexerToken*
lexer_insert_hex_dec (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		PreLexer* _tmp2_;
		if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = type == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp2_);
	}
	if (type == LEXER_TOKEN_TYPE_PL_DECIMAL) {
		LexerToken* _tmp3_;
		_tmp3_ = lexer_insert_decimal_hex (self);
		result = _tmp3_;
		return result;
	} else {
		if (type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT) {
			PreLexer* _tmp5_;
			LexerToken* _tmp6_;
			while (TRUE) {
				PreLexer* _tmp4_;
				_tmp4_ = self->priv->prelexer;
				if (!(pre_lexer_get_next_token (_tmp4_) == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
					break;
				}
			}
			_tmp5_ = self->priv->prelexer;
			pre_lexer_roll_back (_tmp5_);
			_tmp6_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
			result = _tmp6_;
			return result;
		} else {
			Parser* _tmp8_;
			PreLexer* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			PreLexer* _tmp12_;
			PreLexer* _tmp13_;
			LexerToken* _tmp14_;
			if (lexer_check_if_number (self)) {
				LexerToken* _tmp7_;
				_tmp7_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
				result = _tmp7_;
				return result;
			}
			_tmp8_ = self->priv->parser;
			_tmp9_ = self->priv->prelexer;
			_tmp10_ = pre_lexer_get_marked_substring (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->prelexer;
			_tmp13_ = self->priv->prelexer;
			parser_set_error (_tmp8_, ERROR_CODE_MP, _tmp11_, (guint) _tmp12_->mark_index, (guint) _tmp13_->index);
			_g_free0 (_tmp11_);
			_tmp14_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
			result = _tmp14_;
			return result;
		}
	}
}

static LexerToken*
lexer_insert_decimal_hex (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	PreLexer* _tmp10_;
	LexerToken* _tmp11_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	if (type != LEXER_TOKEN_TYPE_PL_DIGIT) {
		_tmp1_ = type != LEXER_TOKEN_TYPE_PL_HEX;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PreLexer* _tmp2_;
		Parser* _tmp3_;
		PreLexer* _tmp4_;
		PreLexer* _tmp5_;
		LexerToken* _tmp6_;
		_tmp2_ = self->priv->prelexer;
		pre_lexer_roll_back (_tmp2_);
		_tmp3_ = self->priv->parser;
		_tmp4_ = self->priv->prelexer;
		_tmp5_ = self->priv->prelexer;
		parser_set_error (_tmp3_, ERROR_CODE_MP, _ ("Missing digits after decimal point"), (guint) _tmp4_->mark_index, (guint) _tmp5_->index);
		_tmp6_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNKNOWN);
		result = _tmp6_;
		return result;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		PreLexer* _tmp8_;
		if (type == LEXER_TOKEN_TYPE_PL_DIGIT) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = type == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp8_);
	}
	while (TRUE) {
		PreLexer* _tmp9_;
		if (!(type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp9_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp9_);
	}
	_tmp10_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp10_);
	_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NUMBER);
	result = _tmp11_;
	return result;
}

static LexerToken*
lexer_insert_letter (Lexer* self)
{
	LexerTokenType type = 0;
	PreLexer* _tmp0_;
	PreLexer* _tmp4_;
	gchar* name = NULL;
	PreLexer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp12_;
	const gchar* _tmp14_;
	const gchar* _tmp16_;
	const gchar* _tmp18_;
	const gchar* _tmp20_;
	const gchar* _tmp22_;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	const gchar* _tmp28_;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prelexer;
	type = pre_lexer_get_next_token (_tmp0_);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		PreLexer* _tmp2_;
		if (type == LEXER_TOKEN_TYPE_PL_LETTER) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = type == LEXER_TOKEN_TYPE_PL_HEX;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp2_);
	}
	while (TRUE) {
		PreLexer* _tmp3_;
		if (!(type == LEXER_TOKEN_TYPE_PL_SUB_DIGIT)) {
			break;
		}
		_tmp3_ = self->priv->prelexer;
		type = pre_lexer_get_next_token (_tmp3_);
	}
	_tmp4_ = self->priv->prelexer;
	pre_lexer_roll_back (_tmp4_);
	_tmp5_ = self->priv->prelexer;
	_tmp6_ = pre_lexer_get_marked_substring (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	name = _tmp9_;
	_tmp10_ = name;
	if (g_strcmp0 (_tmp10_, "mod") == 0) {
		LexerToken* _tmp11_;
		_tmp11_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_MOD);
		result = _tmp11_;
		_g_free0 (name);
		return result;
	}
	_tmp12_ = name;
	if (g_strcmp0 (_tmp12_, "and") == 0) {
		LexerToken* _tmp13_;
		_tmp13_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_AND);
		result = _tmp13_;
		_g_free0 (name);
		return result;
	}
	_tmp14_ = name;
	if (g_strcmp0 (_tmp14_, "nand") == 0) {
		LexerToken* _tmp15_;
		_tmp15_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NAND);
		result = _tmp15_;
		_g_free0 (name);
		return result;
	}
	_tmp16_ = name;
	if (g_strcmp0 (_tmp16_, "\\cdot") == 0) {
		LexerToken* _tmp17_;
		_tmp17_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_MULTIPLY);
		result = _tmp17_;
		_g_free0 (name);
		return result;
	}
	_tmp18_ = name;
	if (g_strcmp0 (_tmp18_, "or") == 0) {
		LexerToken* _tmp19_;
		_tmp19_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_OR);
		result = _tmp19_;
		_g_free0 (name);
		return result;
	}
	_tmp20_ = name;
	if (g_strcmp0 (_tmp20_, "nor") == 0) {
		LexerToken* _tmp21_;
		_tmp21_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NOR);
		result = _tmp21_;
		_g_free0 (name);
		return result;
	}
	_tmp22_ = name;
	if (g_strcmp0 (_tmp22_, "xor") == 0) {
		LexerToken* _tmp23_;
		_tmp23_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_XOR);
		result = _tmp23_;
		_g_free0 (name);
		return result;
	}
	_tmp25_ = name;
	if (g_strcmp0 (_tmp25_, "xnor") == 0) {
		_tmp24_ = TRUE;
	} else {
		const gchar* _tmp26_;
		_tmp26_ = name;
		_tmp24_ = g_strcmp0 (_tmp26_, "nxor") == 0;
	}
	if (_tmp24_) {
		LexerToken* _tmp27_;
		_tmp27_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_XNOR);
		result = _tmp27_;
		_g_free0 (name);
		return result;
	}
	_tmp28_ = name;
	if (g_strcmp0 (_tmp28_, "not") == 0) {
		LexerToken* _tmp29_;
		_tmp29_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_NOT);
		result = _tmp29_;
		_g_free0 (name);
		return result;
	}
	_tmp31_ = name;
	if (g_strcmp0 (_tmp31_, _ ("in")) == 0) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp32_;
		_tmp32_ = name;
		_tmp30_ = g_strcmp0 (_tmp32_, _ ("to")) == 0;
	}
	if (_tmp30_) {
		LexerToken* _tmp33_;
		_tmp33_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_IN);
		result = _tmp33_;
		_g_free0 (name);
		return result;
	}
	if (lexer_check_if_function (self)) {
		LexerToken* _tmp34_;
		_tmp34_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_FUNCTION);
		result = _tmp34_;
		_g_free0 (name);
		return result;
	}
	if (lexer_check_if_currency (self)) {
		LexerToken* _tmp35_;
		_tmp35_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_CURRENCY);
		result = _tmp35_;
		_g_free0 (name);
		return result;
	}
	if (lexer_check_if_unit (self)) {
		LexerToken* _tmp36_;
		_tmp36_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_UNIT);
		result = _tmp36_;
		_g_free0 (name);
		return result;
	} else {
		LexerToken* _tmp37_;
		_tmp37_ = lexer_insert_token (self, LEXER_TOKEN_TYPE_VARIABLE);
		result = _tmp37_;
		_g_free0 (name);
		return result;
	}
}

static void
lexer_class_init (LexerClass * klass,
                  gpointer klass_data)
{
	lexer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Lexer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = lexer_finalize;
}

static void
lexer_instance_init (Lexer * self,
                     gpointer klass)
{
	self->priv = lexer_get_instance_private (self);
}

static void
lexer_finalize (GObject * obj)
{
	Lexer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LEXER, Lexer);
	_parser_unref0 (self->priv->parser);
	_g_object_unref0 (self->priv->prelexer);
	(self->tokens == NULL) ? NULL : (self->tokens = (_g_list_free__g_object_unref0_ (self->tokens), NULL));
	G_OBJECT_CLASS (lexer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
lexer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Lexer), 0, (GInstanceInitFunc) lexer_instance_init, NULL };
	GType lexer_type_id;
	lexer_type_id = g_type_register_static (G_TYPE_OBJECT, "Lexer", &g_define_type_info, 0);
	Lexer_private_offset = g_type_add_instance_private (lexer_type_id, sizeof (LexerPrivate));
	return lexer_type_id;
}

GType
lexer_get_type (void)
{
	static gsize lexer_type_id__once = 0;
	if (g_once_init_enter (&lexer_type_id__once)) {
		GType lexer_type_id;
		lexer_type_id = lexer_get_type_once ();
		g_once_init_leave (&lexer_type_id__once, lexer_type_id);
	}
	return lexer_type_id__once;
}

