/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_agc_ff = R"doc(high performance Automatic Gain Control class

Power is approximated by absolute value

Constructor Specific Documentation:

Build a floating point AGC loop block.

Args:
    rate : the update rate of the loop.
    reference : reference value to adjust signal power to.
    gain : initial gain value.
    max_gain : maximum gain value (0 for unlimited).)doc";


static const char* __doc_gr_analog_agc_ff_agc_ff_0 = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_agc_ff_1 = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_make = R"doc(high performance Automatic Gain Control class

Power is approximated by absolute value

Constructor Specific Documentation:

Build a floating point AGC loop block.

Args:
    rate : the update rate of the loop.
    reference : reference value to adjust signal power to.
    gain : initial gain value.
    max_gain : maximum gain value (0 for unlimited).)doc";


static const char* __doc_gr_analog_agc_ff_rate = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_reference = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_gain = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_max_gain = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_set_rate = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_set_reference = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_set_gain = R"doc()doc";


static const char* __doc_gr_analog_agc_ff_set_max_gain = R"doc()doc";
