/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_ofdm_carrier_allocator_cvc = R"doc(Create frequency domain OFDM symbols from complex values, add pilots.

This block turns a stream of complex, scalar modulation symbols into vectors which are the input for an IFFT in an OFDM transmitter. It also supports the possibility of placing pilot symbols onto the carriers.


The carriers can be allocated freely, if a carrier is not allocated, it is set to zero. This allows doing OFDMA-style carrier allocations.


Input: A tagged stream of complex scalars. The first item must have a tag containing the number of complex symbols in this frame. Output: A tagged stream of complex vectors of length fft_len. This can directly be connected to an FFT block. Make sure to set this block to 'reverse' for the IFFT. If  is true, the FFT block must activate FFT shifting, otherwise, set shifting to false. If given, sync words are prepended to the output. Note that sync words are prepended verbatim, make sure they are shifted (or not).


Carrier indexes are always such that index 0 is the DC carrier (note: you should not allocate this carrier). The carriers below the DC carrier are either indexed with negative numbers, or with indexes larger than . Index -1 and index  both identify the carrier below the DC carrier.


There are some basic checks in place during initialization which check that the carrier allocation table is valid. However, it is possible to overwrite data symbols with pilot symbols, or provide a carrier allocation that has mismatching pilot symbol positions and -values.


Tags are propagated such that a tag on an incoming complex symbol is mapped to the corresponding OFDM symbol. There is one exception: If a tag is on the first OFDM symbol, it is assumed that this tag should stay there, so it is moved to the front even if a sync word is included (any other tags will never be attached to the sync word). This allows tags to control the transmit timing to pass through in the correct position.

Constructor Specific Documentation:



Args:
    fft_len : 
    occupied_carriers : 
    pilot_carriers : 
    pilot_symbols : 
    sync_words : 
    len_tag_key : 
    output_is_shifted : )doc";


static const char*
    __doc_gr_digital_ofdm_carrier_allocator_cvc_ofdm_carrier_allocator_cvc_0 =
        R"doc()doc";


static const char*
    __doc_gr_digital_ofdm_carrier_allocator_cvc_ofdm_carrier_allocator_cvc_1 =
        R"doc()doc";


static const char* __doc_gr_digital_ofdm_carrier_allocator_cvc_len_tag_key = R"doc()doc";


static const char* __doc_gr_digital_ofdm_carrier_allocator_cvc_fft_len = R"doc()doc";


static const char* __doc_gr_digital_ofdm_carrier_allocator_cvc_occupied_carriers =
    R"doc()doc";


static const char* __doc_gr_digital_ofdm_carrier_allocator_cvc_make = R"doc(Create frequency domain OFDM symbols from complex values, add pilots.

This block turns a stream of complex, scalar modulation symbols into vectors which are the input for an IFFT in an OFDM transmitter. It also supports the possibility of placing pilot symbols onto the carriers.


The carriers can be allocated freely, if a carrier is not allocated, it is set to zero. This allows doing OFDMA-style carrier allocations.


Input: A tagged stream of complex scalars. The first item must have a tag containing the number of complex symbols in this frame. Output: A tagged stream of complex vectors of length fft_len. This can directly be connected to an FFT block. Make sure to set this block to 'reverse' for the IFFT. If  is true, the FFT block must activate FFT shifting, otherwise, set shifting to false. If given, sync words are prepended to the output. Note that sync words are prepended verbatim, make sure they are shifted (or not).


Carrier indexes are always such that index 0 is the DC carrier (note: you should not allocate this carrier). The carriers below the DC carrier are either indexed with negative numbers, or with indexes larger than . Index -1 and index  both identify the carrier below the DC carrier.


There are some basic checks in place during initialization which check that the carrier allocation table is valid. However, it is possible to overwrite data symbols with pilot symbols, or provide a carrier allocation that has mismatching pilot symbol positions and -values.


Tags are propagated such that a tag on an incoming complex symbol is mapped to the corresponding OFDM symbol. There is one exception: If a tag is on the first OFDM symbol, it is assumed that this tag should stay there, so it is moved to the front even if a sync word is included (any other tags will never be attached to the sync word). This allows tags to control the transmit timing to pass through in the correct position.

Constructor Specific Documentation:



Args:
    fft_len : 
    occupied_carriers : 
    pilot_carriers : 
    pilot_symbols : 
    sync_words : 
    len_tag_key : 
    output_is_shifted : )doc";
