/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, channels, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_channels_channel_model = R"doc(Basic channel simulator.

This block implements a basic channel model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.


This model allows the user to set the voltage of an AWGN noise source (), a (normalized) frequency offset (), a sample timing offset (), and a seed () to randomize or make reproducible the AWGN noise source.


Multipath can be approximated in this model by using a FIR filter representation of a multipath delay profile with the parameter .


To simulate a channel with time-variant channel, use gr::channels::channel_model2.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    noise_voltage : The AWGN noise level as a voltage (to be calculated externally to meet, say, a desired SNR).
    frequency_offset : The normalized frequency offset. 0 is no offset; 0.25 would be, for a digital modem, one quarter of the symbol rate.
    epsilon : The sample timing offset to emulate the different rates between the sample clocks of the transmitter and receiver. 1.0 is no difference.
    taps : Taps of a FIR filter to emulate a multipath delay profile.
    noise_seed : A random number generator seed for the noise source.
    block_tags : If true, tags will not be able to propagate through this block.)doc";


static const char* __doc_gr_channels_channel_model_channel_model_0 = R"doc()doc";


static const char* __doc_gr_channels_channel_model_channel_model_1 = R"doc()doc";


static const char* __doc_gr_channels_channel_model_make = R"doc(Basic channel simulator.

This block implements a basic channel model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.


This model allows the user to set the voltage of an AWGN noise source (), a (normalized) frequency offset (), a sample timing offset (), and a seed () to randomize or make reproducible the AWGN noise source.


Multipath can be approximated in this model by using a FIR filter representation of a multipath delay profile with the parameter .


To simulate a channel with time-variant channel, use gr::channels::channel_model2.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    noise_voltage : The AWGN noise level as a voltage (to be calculated externally to meet, say, a desired SNR).
    frequency_offset : The normalized frequency offset. 0 is no offset; 0.25 would be, for a digital modem, one quarter of the symbol rate.
    epsilon : The sample timing offset to emulate the different rates between the sample clocks of the transmitter and receiver. 1.0 is no difference.
    taps : Taps of a FIR filter to emulate a multipath delay profile.
    noise_seed : A random number generator seed for the noise source.
    block_tags : If true, tags will not be able to propagate through this block.)doc";


static const char* __doc_gr_channels_channel_model_set_noise_voltage = R"doc()doc";


static const char* __doc_gr_channels_channel_model_set_frequency_offset = R"doc()doc";


static const char* __doc_gr_channels_channel_model_set_taps = R"doc()doc";


static const char* __doc_gr_channels_channel_model_set_timing_offset = R"doc()doc";


static const char* __doc_gr_channels_channel_model_noise_voltage = R"doc()doc";


static const char* __doc_gr_channels_channel_model_frequency_offset = R"doc()doc";


static const char* __doc_gr_channels_channel_model_taps = R"doc()doc";


static const char* __doc_gr_channels_channel_model_timing_offset = R"doc()doc";
