/* -*- c++ -*- */
/*
 * Copyright 2006,2009,2013 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnuradio/constants.h>
#include <boost/dll/runtime_symbol_info.hpp>
#include <cstdlib>
#include <filesystem>

using std::filesystem::path;

namespace gr {
const std::string prefix()
{
    // Use "GR_PREFIX" environment variable when specified
    const char* prefix = std::getenv("GR_PREFIX");
    if (prefix != NULL)
        return prefix;

    path prefix_rel_lib = "../";
    path gr_runtime_lib_path = boost::dll::this_line_location().string();
    // Canonize before decomposing path so result is reliable and without symlinks
    path canonical_lib_path = std::filesystem::canonical(gr_runtime_lib_path);
    path prefix_path = canonical_lib_path.parent_path() / prefix_rel_lib;
    return prefix_path.lexically_normal().string();
}

const std::string sysconfdir()
{
    path sysconfdir_rel_prefix = "../etc";
    path prefix_path = prefix();
    path sysconfdir_path = prefix_path / sysconfdir_rel_prefix;

    return sysconfdir_path.lexically_normal().string();
}

const std::string prefsdir()
{
    path prefsdir_rel_prefix = "../etc/gnuradio/conf.d";
    path prefix_path = prefix();
    path prefsdir_path = prefix_path / prefsdir_rel_prefix;

    return prefsdir_path.lexically_normal().string();
}

const std::string build_date() { return "Tue, 14 Oct 2025 13:50:45Z"; }

const std::string version() { return "3.10.12.0"; }

// Return individual parts of the version
const std::string major_version() { return "3"; }

const std::string api_version() { return "10"; }

const std::string minor_version() { return "12"; }

const std::string c_compiler() { return "cc (GCC) 15.2.1 20250813 \nCopyright (C) 2025 Free Software Foundation, Inc. \nThis is free software see the source for copying conditions.  There is NO \nwarranty not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."; }

const std::string cxx_compiler() { return "c++ (GCC) 15.2.1 20250813 \nCopyright (C) 2025 Free Software Foundation, Inc. \nThis is free software see the source for copying conditions.  There is NO \nwarranty not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."; }

const std::string compiler_flags() { return "/usr/bin/cc::: -march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/gnuradio/src=/usr/src/debug/gnuradio -flto=auto -fvisibility=hidden -Wsign-compare -Wall -Wno-uninitialized -Wignored-qualifiers -Wcast-qual \n/usr/bin/c++::: -march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/gnuradio/src=/usr/src/debug/gnuradio -flto=auto -fvisibility=hidden -Wsign-compare -Wall -Wno-uninitialized -Wignored-qualifiers -Wcast-qual"; }

const std::string build_time_enabled_components() { return "testing-support;python-support;doxygen;man-pages;gnuradio-runtime;common-precompiled-headers;gr-ctrlport;* thrift;gnuradio-companion;JSON/YAML config blocks;gr-blocks;gr-fec;gr-fft;gr-filter;gr-analog;gr-digital;gr-dtv;gr-audio;* alsa;* oss;* jack;* portaudio;gr-channels;gr-pdu;gr-iio;* libad9361;gr-qtgui;gr-trellis;gr-uhd;gr-uhd UHD 4.0 RFNoC;gr-utils;gr_modtool;gr_blocktool;gr-video-sdl;gr-vocoder;* codec2;* freedv;gr-wavelet;gr-zeromq;gr-network;gr-soapy"; }

const std::string pybind_version() { return "3.0.1"; }

} /* namespace gr */
