{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.GdkX11.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "pkg-config-name xlib x11"
 , ""]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.GdkX11.Config"
 , "GI.GdkX11"
 , "GI.GdkX11.Enums"
 , "GI.GdkX11.Functions"
 , "GI.GdkX11.Objects"
 , "GI.GdkX11.Objects.X11AppLaunchContext"
 , "GI.GdkX11.Objects.X11DeviceManagerXI2"
 , "GI.GdkX11.Objects.X11DeviceXI2"
 , "GI.GdkX11.Objects.X11Display"
 , "GI.GdkX11.Objects.X11Drag"
 , "GI.GdkX11.Objects.X11GLContext"
 , "GI.GdkX11.Objects.X11Monitor"
 , "GI.GdkX11.Objects.X11Screen"
 , "GI.GdkX11.Objects.X11Surface"]
