{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A socket address of some unknown native type.
-- 
-- This corresponds to a general @struct sockaddr@ of a type not otherwise
-- handled by GLib.
-- 
-- /Since: 2.46/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.NativeSocketAddress
    ( 

-- * Exported types
    NativeSocketAddress(..)                 ,
    IsNativeSocketAddress                   ,
    toNativeSocketAddress                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [enumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:enumerate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [proxyEnumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:proxyEnumerate"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toNative]("GI.Gio.Objects.SocketAddress#g:method:toNative"), [toString]("GI.Gio.Interfaces.SocketConnectable#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFamily]("GI.Gio.Objects.SocketAddress#g:method:getFamily"), [getNativeSize]("GI.Gio.Objects.SocketAddress#g:method:getNativeSize"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveNativeSocketAddressMethod        ,
#endif

-- ** new #method:new#

    nativeSocketAddressNew                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress

#endif

-- | Memory-managed wrapper type.
newtype NativeSocketAddress = NativeSocketAddress (SP.ManagedPtr NativeSocketAddress)
    deriving (Eq)

instance SP.ManagedPtrNewtype NativeSocketAddress where
    toManagedPtr (NativeSocketAddress p) = p

foreign import ccall "g_native_socket_address_get_type"
    c_g_native_socket_address_get_type :: IO B.Types.GType

instance B.Types.TypedObject NativeSocketAddress where
    glibType = c_g_native_socket_address_get_type

instance B.Types.GObject NativeSocketAddress

-- | Type class for types which can be safely cast to t'NativeSocketAddress', for instance with `toNativeSocketAddress`.
class (SP.GObject o, O.IsDescendantOf NativeSocketAddress o) => IsNativeSocketAddress o
instance (SP.GObject o, O.IsDescendantOf NativeSocketAddress o) => IsNativeSocketAddress o

instance O.HasParentTypes NativeSocketAddress
type instance O.ParentTypes NativeSocketAddress = '[Gio.SocketAddress.SocketAddress, GObject.Object.Object, Gio.SocketConnectable.SocketConnectable]

-- | Cast to t'NativeSocketAddress', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNativeSocketAddress :: (MIO.MonadIO m, IsNativeSocketAddress o) => o -> m NativeSocketAddress
toNativeSocketAddress = MIO.liftIO . B.ManagedPtr.unsafeCastTo NativeSocketAddress

-- | Convert t'NativeSocketAddress' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NativeSocketAddress) where
    gvalueGType_ = c_g_native_socket_address_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NativeSocketAddress)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NativeSocketAddress)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NativeSocketAddress ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNativeSocketAddressMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNativeSocketAddressMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNativeSocketAddressMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNativeSocketAddressMethod "enumerate" o = Gio.SocketConnectable.SocketConnectableEnumerateMethodInfo
    ResolveNativeSocketAddressMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNativeSocketAddressMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNativeSocketAddressMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNativeSocketAddressMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNativeSocketAddressMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNativeSocketAddressMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNativeSocketAddressMethod "proxyEnumerate" o = Gio.SocketConnectable.SocketConnectableProxyEnumerateMethodInfo
    ResolveNativeSocketAddressMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNativeSocketAddressMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNativeSocketAddressMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNativeSocketAddressMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNativeSocketAddressMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNativeSocketAddressMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNativeSocketAddressMethod "toNative" o = Gio.SocketAddress.SocketAddressToNativeMethodInfo
    ResolveNativeSocketAddressMethod "toString" o = Gio.SocketConnectable.SocketConnectableToStringMethodInfo
    ResolveNativeSocketAddressMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNativeSocketAddressMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNativeSocketAddressMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNativeSocketAddressMethod "getFamily" o = Gio.SocketAddress.SocketAddressGetFamilyMethodInfo
    ResolveNativeSocketAddressMethod "getNativeSize" o = Gio.SocketAddress.SocketAddressGetNativeSizeMethodInfo
    ResolveNativeSocketAddressMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNativeSocketAddressMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNativeSocketAddressMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNativeSocketAddressMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNativeSocketAddressMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNativeSocketAddressMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNativeSocketAddressMethod t NativeSocketAddress, O.OverloadedMethod info NativeSocketAddress p) => OL.IsLabel t (NativeSocketAddress -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNativeSocketAddressMethod t NativeSocketAddress, O.OverloadedMethod info NativeSocketAddress p, R.HasField t NativeSocketAddress p) => R.HasField t NativeSocketAddress p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNativeSocketAddressMethod t NativeSocketAddress, O.OverloadedMethodInfo info NativeSocketAddress) => OL.IsLabel t (O.MethodProxy info NativeSocketAddress) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NativeSocketAddress
type instance O.AttributeList NativeSocketAddress = NativeSocketAddressAttributeList
type NativeSocketAddressAttributeList = ('[ '("family", Gio.SocketAddress.SocketAddressFamilyPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NativeSocketAddress = NativeSocketAddressSignalList
type NativeSocketAddressSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NativeSocketAddress::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "native"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a native address object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of @native, in bytes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "NativeSocketAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_native_socket_address_new" g_native_socket_address_new :: 
    Ptr () ->                               -- native : TBasicType TPtr
    FCT.CSize ->                            -- len : TBasicType TSize
    IO (Ptr NativeSocketAddress)

-- | Creates a new t'GI.Gio.Objects.NativeSocketAddress.NativeSocketAddress' for /@native@/ and /@len@/.
-- 
-- /Since: 2.46/
nativeSocketAddressNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@native@/: a native address object
    -> FCT.CSize
    -- ^ /@len@/: the length of /@native@/, in bytes
    -> m NativeSocketAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.NativeSocketAddress.NativeSocketAddress'
nativeSocketAddressNew native len = liftIO $ do
    result <- g_native_socket_address_new native len
    checkUnexpectedReturnNULL "nativeSocketAddressNew" result
    result' <- (wrapObject NativeSocketAddress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


