{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GFileIcon@ specifies an icon by pointing to an image file
-- to be used as icon.
-- 
-- It implements t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.FileIcon
    ( 

-- * Exported types
    FileIcon(..)                            ,
    IsFileIcon                              ,
    toFileIcon                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [load]("GI.Gio.Interfaces.LoadableIcon#g:method:load"), [loadAsync]("GI.Gio.Interfaces.LoadableIcon#g:method:loadAsync"), [loadFinish]("GI.Gio.Interfaces.LoadableIcon#g:method:loadFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFile]("GI.Gio.Objects.FileIcon#g:method:getFile"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFileIconMethod                   ,
#endif

-- ** getFile #method:getFile#

#if defined(ENABLE_OVERLOADING)
    FileIconGetFileMethodInfo               ,
#endif
    fileIconGetFile                         ,


-- ** new #method:new#

    fileIconNew                             ,




 -- * Properties


-- ** file #attr:file#
-- | The file containing the icon.

#if defined(ENABLE_OVERLOADING)
    FileIconFilePropertyInfo                ,
#endif
    constructFileIconFile                   ,
#if defined(ENABLE_OVERLOADING)
    fileIconFile                            ,
#endif
    getFileIconFile                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#endif

-- | Memory-managed wrapper type.
newtype FileIcon = FileIcon (SP.ManagedPtr FileIcon)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileIcon where
    toManagedPtr (FileIcon p) = p

foreign import ccall "g_file_icon_get_type"
    c_g_file_icon_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileIcon where
    glibType = c_g_file_icon_get_type

instance B.Types.GObject FileIcon

-- | Type class for types which can be safely cast to t'FileIcon', for instance with `toFileIcon`.
class (SP.GObject o, O.IsDescendantOf FileIcon o) => IsFileIcon o
instance (SP.GObject o, O.IsDescendantOf FileIcon o) => IsFileIcon o

instance O.HasParentTypes FileIcon
type instance O.ParentTypes FileIcon = '[GObject.Object.Object, Gio.Icon.Icon, Gio.LoadableIcon.LoadableIcon]

-- | Cast to t'FileIcon', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFileIcon :: (MIO.MonadIO m, IsFileIcon o) => o -> m FileIcon
toFileIcon = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileIcon

-- | Convert t'FileIcon' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileIcon) where
    gvalueGType_ = c_g_file_icon_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileIcon)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileIcon)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileIcon ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFileIconMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileIconMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileIconMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileIconMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveFileIconMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileIconMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileIconMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileIconMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveFileIconMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileIconMethod "load" o = Gio.LoadableIcon.LoadableIconLoadMethodInfo
    ResolveFileIconMethod "loadAsync" o = Gio.LoadableIcon.LoadableIconLoadAsyncMethodInfo
    ResolveFileIconMethod "loadFinish" o = Gio.LoadableIcon.LoadableIconLoadFinishMethodInfo
    ResolveFileIconMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileIconMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileIconMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileIconMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileIconMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileIconMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveFileIconMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileIconMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileIconMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileIconMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveFileIconMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileIconMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileIconMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileIconMethod "getFile" o = FileIconGetFileMethodInfo
    ResolveFileIconMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileIconMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileIconMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileIconMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileIconMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileIconMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileIconMethod t FileIcon, O.OverloadedMethod info FileIcon p) => OL.IsLabel t (FileIcon -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileIconMethod t FileIcon, O.OverloadedMethod info FileIcon p, R.HasField t FileIcon p) => R.HasField t FileIcon p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileIconMethod t FileIcon, O.OverloadedMethodInfo info FileIcon) => OL.IsLabel t (O.MethodProxy info FileIcon) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "file"
   -- Type: TInterface (Name {namespace = "Gio", name = "File"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fileIcon #file
-- @
getFileIconFile :: (MonadIO m, IsFileIcon o) => o -> m Gio.File.File
getFileIconFile obj = MIO.liftIO $ checkUnexpectedNothing "getFileIconFile" $ B.Properties.getObjectPropertyObject obj "file" Gio.File.File

-- | Construct a t'GValueConstruct' with valid value for the “@file@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFileIconFile :: (IsFileIcon o, MIO.MonadIO m, Gio.File.IsFile a) => a -> m (GValueConstruct o)
constructFileIconFile val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "file" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FileIconFilePropertyInfo
instance AttrInfo FileIconFilePropertyInfo where
    type AttrAllowedOps FileIconFilePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FileIconFilePropertyInfo = IsFileIcon
    type AttrSetTypeConstraint FileIconFilePropertyInfo = Gio.File.IsFile
    type AttrTransferTypeConstraint FileIconFilePropertyInfo = Gio.File.IsFile
    type AttrTransferType FileIconFilePropertyInfo = Gio.File.File
    type AttrGetType FileIconFilePropertyInfo = Gio.File.File
    type AttrLabel FileIconFilePropertyInfo = "file"
    type AttrOrigin FileIconFilePropertyInfo = FileIcon
    attrGet = getFileIconFile
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.File.File v
    attrConstruct = constructFileIconFile
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileIcon.file"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileIcon.html#g:attr:file"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileIcon
type instance O.AttributeList FileIcon = FileIconAttributeList
type FileIconAttributeList = ('[ '("file", FileIconFilePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
fileIconFile :: AttrLabelProxy "file"
fileIconFile = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileIcon = FileIconSignalList
type FileIconSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FileIcon::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFile." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "FileIcon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_icon_new" g_file_icon_new :: 
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO (Ptr FileIcon)

-- | Creates a new icon for a file.
fileIconNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    a
    -- ^ /@file@/: a t'GI.Gio.Interfaces.File.File'.
    -> m FileIcon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon' for the given
    --   /@file@/, or 'P.Nothing' on error.
fileIconNew file = liftIO $ do
    file' <- unsafeManagedPtrCastPtr file
    result <- g_file_icon_new file'
    checkUnexpectedReturnNULL "fileIconNew" result
    result' <- (wrapObject FileIcon) result
    touchManagedPtr file
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FileIcon::get_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIcon." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_file_icon_get_file" g_file_icon_get_file :: 
    Ptr FileIcon ->                         -- icon : TInterface (Name {namespace = "Gio", name = "FileIcon"})
    IO (Ptr Gio.File.File)

-- | Gets the t'GI.Gio.Interfaces.File.File' associated with the given /@icon@/.
fileIconGetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileIcon a) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.Icon.Icon'.
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File'.
fileIconGetFile icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- g_file_icon_get_file icon'
    checkUnexpectedReturnNULL "fileIconGetFile" result
    result' <- (newObject Gio.File.File) result
    touchManagedPtr icon
    return result'

#if defined(ENABLE_OVERLOADING)
data FileIconGetFileMethodInfo
instance (signature ~ (m Gio.File.File), MonadIO m, IsFileIcon a) => O.OverloadedMethod FileIconGetFileMethodInfo a signature where
    overloadedMethod = fileIconGetFile

instance O.OverloadedMethodInfo FileIconGetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileIcon.fileIconGetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-FileIcon.html#v:fileIconGetFile"
        })


#endif


