{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This t'GI.Gio.Objects.SocketControlMessage.SocketControlMessage' contains a t'GI.Gio.Objects.Credentials.Credentials'
-- instance.  It may be sent using 'GI.Gio.Objects.Socket.socketSendMessage' and received
-- using 'GI.Gio.Objects.Socket.socketReceiveMessage' over UNIX sockets (ie: sockets in
-- the @G_SOCKET_FAMILY_UNIX@ family).
-- 
-- For an easier way to send and receive credentials over
-- stream-oriented UNIX sockets, see
-- 'GI.Gio.Objects.UnixConnection.unixConnectionSendCredentials' and
-- 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentials'. To receive credentials of
-- a foreign process connected to a socket, use
-- 'GI.Gio.Objects.Socket.socketGetCredentials'.
-- 
-- Since GLib 2.72, @GUnixCredentialMessage@ is available on all platforms. It
-- requires underlying system support (such as Windows 10 with @AF_UNIX@) at run
-- time.
-- 
-- Before GLib 2.72, @\<gio\/gunixcredentialsmessage.h>@ belonged to the UNIX-specific
-- GIO interfaces, thus you had to use the @gio-unix-2.0.pc@ pkg-config file
-- when using it. This is no longer necessary since GLib 2.72.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.UnixCredentialsMessage
    ( 

-- * Exported types
    UnixCredentialsMessage(..)              ,
    IsUnixCredentialsMessage                ,
    toUnixCredentialsMessage                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Objects.SocketControlMessage#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCredentials]("GI.Gio.Objects.UnixCredentialsMessage#g:method:getCredentials"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLevel]("GI.Gio.Objects.SocketControlMessage#g:method:getLevel"), [getMsgType]("GI.Gio.Objects.SocketControlMessage#g:method:getMsgType"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSize]("GI.Gio.Objects.SocketControlMessage#g:method:getSize").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveUnixCredentialsMessageMethod     ,
#endif

-- ** getCredentials #method:getCredentials#

#if defined(ENABLE_OVERLOADING)
    UnixCredentialsMessageGetCredentialsMethodInfo,
#endif
    unixCredentialsMessageGetCredentials    ,


-- ** isSupported #method:isSupported#

    unixCredentialsMessageIsSupported       ,


-- ** new #method:new#

    unixCredentialsMessageNew               ,


-- ** newWithCredentials #method:newWithCredentials#

    unixCredentialsMessageNewWithCredentials,




 -- * Properties


-- ** credentials #attr:credentials#
-- | The credentials stored in the message.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    UnixCredentialsMessageCredentialsPropertyInfo,
#endif
    constructUnixCredentialsMessageCredentials,
    getUnixCredentialsMessageCredentials    ,
#if defined(ENABLE_OVERLOADING)
    unixCredentialsMessageCredentials       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage

#endif

-- | Memory-managed wrapper type.
newtype UnixCredentialsMessage = UnixCredentialsMessage (SP.ManagedPtr UnixCredentialsMessage)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixCredentialsMessage where
    toManagedPtr (UnixCredentialsMessage p) = p

foreign import ccall "g_unix_credentials_message_get_type"
    c_g_unix_credentials_message_get_type :: IO B.Types.GType

instance B.Types.TypedObject UnixCredentialsMessage where
    glibType = c_g_unix_credentials_message_get_type

instance B.Types.GObject UnixCredentialsMessage

-- | Type class for types which can be safely cast to t'UnixCredentialsMessage', for instance with `toUnixCredentialsMessage`.
class (SP.GObject o, O.IsDescendantOf UnixCredentialsMessage o) => IsUnixCredentialsMessage o
instance (SP.GObject o, O.IsDescendantOf UnixCredentialsMessage o) => IsUnixCredentialsMessage o

instance O.HasParentTypes UnixCredentialsMessage
type instance O.ParentTypes UnixCredentialsMessage = '[Gio.SocketControlMessage.SocketControlMessage, GObject.Object.Object]

-- | Cast to t'UnixCredentialsMessage', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toUnixCredentialsMessage :: (MIO.MonadIO m, IsUnixCredentialsMessage o) => o -> m UnixCredentialsMessage
toUnixCredentialsMessage = MIO.liftIO . B.ManagedPtr.unsafeCastTo UnixCredentialsMessage

-- | Convert t'UnixCredentialsMessage' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnixCredentialsMessage) where
    gvalueGType_ = c_g_unix_credentials_message_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UnixCredentialsMessage)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UnixCredentialsMessage)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UnixCredentialsMessage ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixCredentialsMessageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixCredentialsMessageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUnixCredentialsMessageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUnixCredentialsMessageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUnixCredentialsMessageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUnixCredentialsMessageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUnixCredentialsMessageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUnixCredentialsMessageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUnixCredentialsMessageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUnixCredentialsMessageMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUnixCredentialsMessageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUnixCredentialsMessageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUnixCredentialsMessageMethod "serialize" o = Gio.SocketControlMessage.SocketControlMessageSerializeMethodInfo
    ResolveUnixCredentialsMessageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUnixCredentialsMessageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUnixCredentialsMessageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUnixCredentialsMessageMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUnixCredentialsMessageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUnixCredentialsMessageMethod "getCredentials" o = UnixCredentialsMessageGetCredentialsMethodInfo
    ResolveUnixCredentialsMessageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUnixCredentialsMessageMethod "getLevel" o = Gio.SocketControlMessage.SocketControlMessageGetLevelMethodInfo
    ResolveUnixCredentialsMessageMethod "getMsgType" o = Gio.SocketControlMessage.SocketControlMessageGetMsgTypeMethodInfo
    ResolveUnixCredentialsMessageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUnixCredentialsMessageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUnixCredentialsMessageMethod "getSize" o = Gio.SocketControlMessage.SocketControlMessageGetSizeMethodInfo
    ResolveUnixCredentialsMessageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUnixCredentialsMessageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUnixCredentialsMessageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUnixCredentialsMessageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixCredentialsMessageMethod t UnixCredentialsMessage, O.OverloadedMethod info UnixCredentialsMessage p) => OL.IsLabel t (UnixCredentialsMessage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixCredentialsMessageMethod t UnixCredentialsMessage, O.OverloadedMethod info UnixCredentialsMessage p, R.HasField t UnixCredentialsMessage p) => R.HasField t UnixCredentialsMessage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixCredentialsMessageMethod t UnixCredentialsMessage, O.OverloadedMethodInfo info UnixCredentialsMessage) => OL.IsLabel t (O.MethodProxy info UnixCredentialsMessage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "credentials"
   -- Type: TInterface (Name {namespace = "Gio", name = "Credentials"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@credentials@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' unixCredentialsMessage #credentials
-- @
getUnixCredentialsMessageCredentials :: (MonadIO m, IsUnixCredentialsMessage o) => o -> m Gio.Credentials.Credentials
getUnixCredentialsMessageCredentials obj = MIO.liftIO $ checkUnexpectedNothing "getUnixCredentialsMessageCredentials" $ B.Properties.getObjectPropertyObject obj "credentials" Gio.Credentials.Credentials

-- | Construct a t'GValueConstruct' with valid value for the “@credentials@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructUnixCredentialsMessageCredentials :: (IsUnixCredentialsMessage o, MIO.MonadIO m, Gio.Credentials.IsCredentials a) => a -> m (GValueConstruct o)
constructUnixCredentialsMessageCredentials val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "credentials" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data UnixCredentialsMessageCredentialsPropertyInfo
instance AttrInfo UnixCredentialsMessageCredentialsPropertyInfo where
    type AttrAllowedOps UnixCredentialsMessageCredentialsPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint UnixCredentialsMessageCredentialsPropertyInfo = IsUnixCredentialsMessage
    type AttrSetTypeConstraint UnixCredentialsMessageCredentialsPropertyInfo = Gio.Credentials.IsCredentials
    type AttrTransferTypeConstraint UnixCredentialsMessageCredentialsPropertyInfo = Gio.Credentials.IsCredentials
    type AttrTransferType UnixCredentialsMessageCredentialsPropertyInfo = Gio.Credentials.Credentials
    type AttrGetType UnixCredentialsMessageCredentialsPropertyInfo = Gio.Credentials.Credentials
    type AttrLabel UnixCredentialsMessageCredentialsPropertyInfo = "credentials"
    type AttrOrigin UnixCredentialsMessageCredentialsPropertyInfo = UnixCredentialsMessage
    attrGet = getUnixCredentialsMessageCredentials
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.Credentials.Credentials v
    attrConstruct = constructUnixCredentialsMessageCredentials
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixCredentialsMessage.credentials"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixCredentialsMessage.html#g:attr:credentials"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixCredentialsMessage
type instance O.AttributeList UnixCredentialsMessage = UnixCredentialsMessageAttributeList
type UnixCredentialsMessageAttributeList = ('[ '("credentials", UnixCredentialsMessageCredentialsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
unixCredentialsMessageCredentials :: AttrLabelProxy "credentials"
unixCredentialsMessageCredentials = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UnixCredentialsMessage = UnixCredentialsMessageSignalList
type UnixCredentialsMessageSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UnixCredentialsMessage::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "UnixCredentialsMessage" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_credentials_message_new" g_unix_credentials_message_new :: 
    IO (Ptr UnixCredentialsMessage)

-- | Creates a new t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage' with credentials matching the current processes.
-- 
-- /Since: 2.26/
unixCredentialsMessageNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m UnixCredentialsMessage
    -- ^ __Returns:__ a new t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage'
unixCredentialsMessageNew  = liftIO $ do
    result <- g_unix_credentials_message_new
    checkUnexpectedReturnNULL "unixCredentialsMessageNew" result
    result' <- (wrapObject UnixCredentialsMessage) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixCredentialsMessage::new_with_credentials
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials object."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "UnixCredentialsMessage" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_credentials_message_new_with_credentials" g_unix_credentials_message_new_with_credentials :: 
    Ptr Gio.Credentials.Credentials ->      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    IO (Ptr UnixCredentialsMessage)

-- | Creates a new t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage' holding /@credentials@/.
-- 
-- /Since: 2.26/
unixCredentialsMessageNewWithCredentials ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Credentials.IsCredentials a) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials' object.
    -> m UnixCredentialsMessage
    -- ^ __Returns:__ a new t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage'
unixCredentialsMessageNewWithCredentials credentials = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    result <- g_unix_credentials_message_new_with_credentials credentials'
    checkUnexpectedReturnNULL "unixCredentialsMessageNewWithCredentials" result
    result' <- (wrapObject UnixCredentialsMessage) result
    touchManagedPtr credentials
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixCredentialsMessage::get_credentials
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "message"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "UnixCredentialsMessage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GUnixCredentialsMessage."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Credentials" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_credentials_message_get_credentials" g_unix_credentials_message_get_credentials :: 
    Ptr UnixCredentialsMessage ->           -- message : TInterface (Name {namespace = "Gio", name = "UnixCredentialsMessage"})
    IO (Ptr Gio.Credentials.Credentials)

-- | Gets the credentials stored in /@message@/.
-- 
-- /Since: 2.26/
unixCredentialsMessageGetCredentials ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixCredentialsMessage a) =>
    a
    -- ^ /@message@/: A t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage'.
    -> m Gio.Credentials.Credentials
    -- ^ __Returns:__ A t'GI.Gio.Objects.Credentials.Credentials' instance. Do not free, it is owned by /@message@/.
unixCredentialsMessageGetCredentials message = liftIO $ do
    message' <- unsafeManagedPtrCastPtr message
    result <- g_unix_credentials_message_get_credentials message'
    checkUnexpectedReturnNULL "unixCredentialsMessageGetCredentials" result
    result' <- (newObject Gio.Credentials.Credentials) result
    touchManagedPtr message
    return result'

#if defined(ENABLE_OVERLOADING)
data UnixCredentialsMessageGetCredentialsMethodInfo
instance (signature ~ (m Gio.Credentials.Credentials), MonadIO m, IsUnixCredentialsMessage a) => O.OverloadedMethod UnixCredentialsMessageGetCredentialsMethodInfo a signature where
    overloadedMethod = unixCredentialsMessageGetCredentials

instance O.OverloadedMethodInfo UnixCredentialsMessageGetCredentialsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixCredentialsMessage.unixCredentialsMessageGetCredentials",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixCredentialsMessage.html#v:unixCredentialsMessageGetCredentials"
        })


#endif

-- method UnixCredentialsMessage::is_supported
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_credentials_message_is_supported" g_unix_credentials_message_is_supported :: 
    IO CInt

-- | Checks if passing t'GI.Gio.Objects.Credentials.Credentials' on a t'GI.Gio.Objects.Socket.Socket' is supported on this platform.
-- 
-- /Since: 2.26/
unixCredentialsMessageIsSupported ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Bool
    -- ^ __Returns:__ 'P.True' if supported, 'P.False' otherwise
unixCredentialsMessageIsSupported  = liftIO $ do
    result <- g_unix_credentials_message_is_supported
    let result' = (/= 0) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


