{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GUnixFDList@ contains a list of file descriptors.  It owns the file
-- descriptors that it contains, closing them when finalized.
-- 
-- It may be wrapped in a
-- <http://developer.gnome.org/gio/stable/../gio-unix/class.UnixFDMessage.html `GUnixFDMessage`> and sent over a
-- t'GI.Gio.Objects.Socket.Socket' in the @G_SOCKET_FAMILY_UNIX@ family by using
-- 'GI.Gio.Objects.Socket.socketSendMessage' and received using
-- 'GI.Gio.Objects.Socket.socketReceiveMessage'.
-- 
-- Before 2.74, @\<gio\/gunixfdlist.h>@ belonged to the UNIX-specific GIO
-- interfaces, thus you had to use the @gio-unix-2.0.pc@ pkg-config file when
-- using it.
-- 
-- Since 2.74, the API is available for Windows.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.UnixFDList
    ( 

-- * Exported types
    UnixFDList(..)                          ,
    IsUnixFDList                            ,
    toUnixFDList                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [append]("GI.Gio.Objects.UnixFDList#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [get]("GI.Gio.Objects.UnixFDList#g:method:get"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [peekFds]("GI.Gio.Objects.UnixFDList#g:method:peekFds"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealFds]("GI.Gio.Objects.UnixFDList#g:method:stealFds"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLength]("GI.Gio.Objects.UnixFDList#g:method:getLength"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveUnixFDListMethod                 ,
#endif

-- ** append #method:append#

#if defined(ENABLE_OVERLOADING)
    UnixFDListAppendMethodInfo              ,
#endif
    unixFDListAppend                        ,


-- ** get #method:get#

#if defined(ENABLE_OVERLOADING)
    UnixFDListGetMethodInfo                 ,
#endif
    unixFDListGet                           ,


-- ** getLength #method:getLength#

#if defined(ENABLE_OVERLOADING)
    UnixFDListGetLengthMethodInfo           ,
#endif
    unixFDListGetLength                     ,


-- ** new #method:new#

    unixFDListNew                           ,


-- ** newFromArray #method:newFromArray#

    unixFDListNewFromArray                  ,


-- ** peekFds #method:peekFds#

#if defined(ENABLE_OVERLOADING)
    UnixFDListPeekFdsMethodInfo             ,
#endif
    unixFDListPeekFds                       ,


-- ** stealFds #method:stealFds#

#if defined(ENABLE_OVERLOADING)
    UnixFDListStealFdsMethodInfo            ,
#endif
    unixFDListStealFds                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype UnixFDList = UnixFDList (SP.ManagedPtr UnixFDList)
    deriving (Eq)

instance SP.ManagedPtrNewtype UnixFDList where
    toManagedPtr (UnixFDList p) = p

foreign import ccall "g_unix_fd_list_get_type"
    c_g_unix_fd_list_get_type :: IO B.Types.GType

instance B.Types.TypedObject UnixFDList where
    glibType = c_g_unix_fd_list_get_type

instance B.Types.GObject UnixFDList

-- | Type class for types which can be safely cast to t'UnixFDList', for instance with `toUnixFDList`.
class (SP.GObject o, O.IsDescendantOf UnixFDList o) => IsUnixFDList o
instance (SP.GObject o, O.IsDescendantOf UnixFDList o) => IsUnixFDList o

instance O.HasParentTypes UnixFDList
type instance O.ParentTypes UnixFDList = '[GObject.Object.Object]

-- | Cast to t'UnixFDList', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toUnixFDList :: (MIO.MonadIO m, IsUnixFDList o) => o -> m UnixFDList
toUnixFDList = MIO.liftIO . B.ManagedPtr.unsafeCastTo UnixFDList

-- | Convert t'UnixFDList' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UnixFDList) where
    gvalueGType_ = c_g_unix_fd_list_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UnixFDList)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UnixFDList)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UnixFDList ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUnixFDListMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUnixFDListMethod "append" o = UnixFDListAppendMethodInfo
    ResolveUnixFDListMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUnixFDListMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUnixFDListMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUnixFDListMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUnixFDListMethod "get" o = UnixFDListGetMethodInfo
    ResolveUnixFDListMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUnixFDListMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUnixFDListMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUnixFDListMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUnixFDListMethod "peekFds" o = UnixFDListPeekFdsMethodInfo
    ResolveUnixFDListMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUnixFDListMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUnixFDListMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUnixFDListMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUnixFDListMethod "stealFds" o = UnixFDListStealFdsMethodInfo
    ResolveUnixFDListMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUnixFDListMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUnixFDListMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUnixFDListMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUnixFDListMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUnixFDListMethod "getLength" o = UnixFDListGetLengthMethodInfo
    ResolveUnixFDListMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUnixFDListMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUnixFDListMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUnixFDListMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUnixFDListMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUnixFDListMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUnixFDListMethod t UnixFDList, O.OverloadedMethod info UnixFDList p) => OL.IsLabel t (UnixFDList -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUnixFDListMethod t UnixFDList, O.OverloadedMethod info UnixFDList p, R.HasField t UnixFDList p) => R.HasField t UnixFDList p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUnixFDListMethod t UnixFDList, O.OverloadedMethodInfo info UnixFDList) => OL.IsLabel t (O.MethodProxy info UnixFDList) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UnixFDList
type instance O.AttributeList UnixFDList = UnixFDListAttributeList
type UnixFDListAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UnixFDList = UnixFDListSignalList
type UnixFDListSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UnixFDList::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "UnixFDList" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_list_new" g_unix_fd_list_new :: 
    IO (Ptr UnixFDList)

-- | Creates a new t'GI.Gio.Objects.UnixFDList.UnixFDList' containing no file descriptors.
-- 
-- /Since: 2.24/
unixFDListNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m UnixFDList
    -- ^ __Returns:__ a new t'GI.Gio.Objects.UnixFDList.UnixFDList'
unixFDListNew  = liftIO $ do
    result <- g_unix_fd_list_new
    checkUnexpectedReturnNULL "unixFDListNew" result
    result' <- (wrapObject UnixFDList) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixFDList::new_from_array
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "fds"
--           , argType = TCArray False (-1) 1 (TBasicType TInt)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the initial list of file descriptors"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fds"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of #fds, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fds"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of #fds, or -1"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "UnixFDList" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_list_new_from_array" g_unix_fd_list_new_from_array :: 
    Ptr Int32 ->                            -- fds : TCArray False (-1) 1 (TBasicType TInt)
    Int32 ->                                -- n_fds : TBasicType TInt
    IO (Ptr UnixFDList)

-- | Creates a new t'GI.Gio.Objects.UnixFDList.UnixFDList' containing the file descriptors given in
-- /@fds@/.  The file descriptors become the property of the new list and
-- may no longer be used by the caller.  The array itself is owned by
-- the caller.
-- 
-- Each file descriptor in the array should be set to close-on-exec.
-- 
-- If /@nFds@/ is -1 then /@fds@/ must be terminated with -1.
-- 
-- /Since: 2.24/
unixFDListNewFromArray ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Int32]
    -- ^ /@fds@/: the initial list of file descriptors
    -> m UnixFDList
    -- ^ __Returns:__ a new t'GI.Gio.Objects.UnixFDList.UnixFDList'
unixFDListNewFromArray fds = liftIO $ do
    let nFds = fromIntegral $ P.length fds
    fds' <- packStorableArray fds
    result <- g_unix_fd_list_new_from_array fds' nFds
    checkUnexpectedReturnNULL "unixFDListNewFromArray" result
    result' <- (wrapObject UnixFDList) result
    freeMem fds'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UnixFDList::append
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixFDList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixFDList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a valid open file descriptor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_fd_list_append" g_unix_fd_list_append :: 
    Ptr UnixFDList ->                       -- list : TInterface (Name {namespace = "Gio", name = "UnixFDList"})
    Int32 ->                                -- fd : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO Int32

-- | Adds a file descriptor to /@list@/.
-- 
-- The file descriptor is duplicated using @/dup()/@. You keep your copy
-- of the descriptor and the copy contained in /@list@/ will be closed
-- when /@list@/ is finalized.
-- 
-- A possible cause of failure is exceeding the per-process or
-- system-wide file descriptor limit.
-- 
-- The index of the file descriptor in the list is returned.  If you use
-- this index with 'GI.Gio.Objects.UnixFDList.unixFDListGet' then you will receive back a
-- duplicated copy of the same file descriptor.
-- 
-- /Since: 2.24/
unixFDListAppend ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixFDList a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Objects.UnixFDList.UnixFDList'
    -> Int32
    -- ^ /@fd@/: a valid open file descriptor
    -> m Int32
    -- ^ __Returns:__ the index of the appended fd in case of success, else -1
    --          (and /@error@/ is set) /(Can throw 'Data.GI.Base.GError.GError')/
unixFDListAppend list fd = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    onException (do
        result <- propagateGError $ g_unix_fd_list_append list' fd
        touchManagedPtr list
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixFDListAppendMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsUnixFDList a) => O.OverloadedMethod UnixFDListAppendMethodInfo a signature where
    overloadedMethod = unixFDListAppend

instance O.OverloadedMethodInfo UnixFDListAppendMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixFDList.unixFDListAppend",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixFDList.html#v:unixFDListAppend"
        })


#endif

-- method UnixFDList::get
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixFDList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixFDList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index into the list"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : True
-- Skip return : False

foreign import ccall "g_unix_fd_list_get" g_unix_fd_list_get :: 
    Ptr UnixFDList ->                       -- list : TInterface (Name {namespace = "Gio", name = "UnixFDList"})
    Int32 ->                                -- index_ : TBasicType TInt
    Ptr (Ptr GError) ->                     -- error
    IO Int32

-- | Gets a file descriptor out of /@list@/.
-- 
-- /@index_@/ specifies the index of the file descriptor to get.  It is a
-- programmer error for /@index_@/ to be out of range; see
-- 'GI.Gio.Objects.UnixFDList.unixFDListGetLength'.
-- 
-- The file descriptor is duplicated using @/dup()/@ and set as
-- close-on-exec before being returned.  You must call @/close()/@ on it
-- when you are done.
-- 
-- A possible cause of failure is exceeding the per-process or
-- system-wide file descriptor limit.
-- 
-- /Since: 2.24/
unixFDListGet ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixFDList a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Objects.UnixFDList.UnixFDList'
    -> Int32
    -- ^ /@index_@/: the index into the list
    -> m Int32
    -- ^ __Returns:__ the file descriptor, or -1 in case of error /(Can throw 'Data.GI.Base.GError.GError')/
unixFDListGet list index_ = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    onException (do
        result <- propagateGError $ g_unix_fd_list_get list' index_
        touchManagedPtr list
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UnixFDListGetMethodInfo
instance (signature ~ (Int32 -> m Int32), MonadIO m, IsUnixFDList a) => O.OverloadedMethod UnixFDListGetMethodInfo a signature where
    overloadedMethod = unixFDListGet

instance O.OverloadedMethodInfo UnixFDListGetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixFDList.unixFDListGet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixFDList.html#v:unixFDListGet"
        })


#endif

-- method UnixFDList::get_length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixFDList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixFDList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_list_get_length" g_unix_fd_list_get_length :: 
    Ptr UnixFDList ->                       -- list : TInterface (Name {namespace = "Gio", name = "UnixFDList"})
    IO Int32

-- | Gets the length of /@list@/ (ie: the number of file descriptors
-- contained within).
-- 
-- /Since: 2.24/
unixFDListGetLength ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixFDList a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Objects.UnixFDList.UnixFDList'
    -> m Int32
    -- ^ __Returns:__ the length of /@list@/
unixFDListGetLength list = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    result <- g_unix_fd_list_get_length list'
    touchManagedPtr list
    return result

#if defined(ENABLE_OVERLOADING)
data UnixFDListGetLengthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsUnixFDList a) => O.OverloadedMethod UnixFDListGetLengthMethodInfo a signature where
    overloadedMethod = unixFDListGetLength

instance O.OverloadedMethodInfo UnixFDListGetLengthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixFDList.unixFDListGetLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixFDList.html#v:unixFDListGetLength"
        })


#endif

-- method UnixFDList::peek_fds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixFDList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixFDList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to the length of the returned\n    array, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "pointer to the length of the returned\n    array, or %NULL"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TInt))
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_list_peek_fds" g_unix_fd_list_peek_fds :: 
    Ptr UnixFDList ->                       -- list : TInterface (Name {namespace = "Gio", name = "UnixFDList"})
    Ptr Int32 ->                            -- length : TBasicType TInt
    IO (Ptr Int32)

-- | Returns the array of file descriptors that is contained in this
-- object.
-- 
-- After this call, the descriptors remain the property of /@list@/.  The
-- caller must not close them and must not free the array.  The array is
-- valid only until /@list@/ is changed in any way.
-- 
-- If /@length@/ is non-'P.Nothing' then it is set to the number of file
-- descriptors in the returned array. The returned array is also
-- terminated with -1.
-- 
-- This function never returns 'P.Nothing'. In case there are no file
-- descriptors contained in /@list@/, an empty array is returned.
-- 
-- /Since: 2.24/
unixFDListPeekFds ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixFDList a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Objects.UnixFDList.UnixFDList'
    -> m [Int32]
    -- ^ __Returns:__ an array of file
    --     descriptors
unixFDListPeekFds list = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    length_ <- allocMem :: IO (Ptr Int32)
    result <- g_unix_fd_list_peek_fds list' length_
    length_' <- peek length_
    checkUnexpectedReturnNULL "unixFDListPeekFds" result
    result' <- (unpackStorableArrayWithLength length_') result
    touchManagedPtr list
    freeMem length_
    return result'

#if defined(ENABLE_OVERLOADING)
data UnixFDListPeekFdsMethodInfo
instance (signature ~ (m [Int32]), MonadIO m, IsUnixFDList a) => O.OverloadedMethod UnixFDListPeekFdsMethodInfo a signature where
    overloadedMethod = unixFDListPeekFds

instance O.OverloadedMethodInfo UnixFDListPeekFdsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixFDList.unixFDListPeekFds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixFDList.html#v:unixFDListPeekFds"
        })


#endif

-- method UnixFDList::steal_fds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "list"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixFDList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GUnixFDList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pointer to the length of the returned\n    array, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "length"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "pointer to the length of the returned\n    array, or %NULL"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TCArray False (-1) 1 (TBasicType TInt))
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_fd_list_steal_fds" g_unix_fd_list_steal_fds :: 
    Ptr UnixFDList ->                       -- list : TInterface (Name {namespace = "Gio", name = "UnixFDList"})
    Ptr Int32 ->                            -- length : TBasicType TInt
    IO (Ptr Int32)

-- | Returns the array of file descriptors that is contained in this
-- object.
-- 
-- After this call, the descriptors are no longer contained in
-- /@list@/. Further calls will return an empty list (unless more
-- descriptors have been added).
-- 
-- The return result of this function must be freed with 'GI.GLib.Functions.free'.
-- The caller is also responsible for closing all of the file
-- descriptors.  The file descriptors in the array are set to
-- close-on-exec.
-- 
-- If /@length@/ is non-'P.Nothing' then it is set to the number of file
-- descriptors in the returned array. The returned array is also
-- terminated with -1.
-- 
-- This function never returns 'P.Nothing'. In case there are no file
-- descriptors contained in /@list@/, an empty array is returned.
-- 
-- /Since: 2.24/
unixFDListStealFds ::
    (B.CallStack.HasCallStack, MonadIO m, IsUnixFDList a) =>
    a
    -- ^ /@list@/: a t'GI.Gio.Objects.UnixFDList.UnixFDList'
    -> m [Int32]
    -- ^ __Returns:__ an array of file
    --     descriptors
unixFDListStealFds list = liftIO $ do
    list' <- unsafeManagedPtrCastPtr list
    length_ <- allocMem :: IO (Ptr Int32)
    result <- g_unix_fd_list_steal_fds list' length_
    length_' <- peek length_
    checkUnexpectedReturnNULL "unixFDListStealFds" result
    result' <- (unpackStorableArrayWithLength length_') result
    freeMem result
    touchManagedPtr list
    freeMem length_
    return result'

#if defined(ENABLE_OVERLOADING)
data UnixFDListStealFdsMethodInfo
instance (signature ~ (m [Int32]), MonadIO m, IsUnixFDList a) => O.OverloadedMethod UnixFDListStealFdsMethodInfo a signature where
    overloadedMethod = unixFDListStealFds

instance O.OverloadedMethodInfo UnixFDListStealFdsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.UnixFDList.unixFDListStealFds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-UnixFDList.html#v:unixFDListStealFds"
        })


#endif


