

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Flags
    ( 

 -- * Flags


-- ** PathForeachFlags #flag:PathForeachFlags#

    PathForeachFlags(..)                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags PathForeachFlags
-- | Flags that can be passed to 'GI.Gsk.Structs.Path.pathForeach' to influence what
-- kinds of operations the path is decomposed into.
-- 
-- By default, 'GI.Gsk.Structs.Path.pathForeach' will only emit a path with all
-- operations flattened to straight lines to allow for maximum compatibility.
-- The only operations emitted will be @GSK_PATH_MOVE@, @GSK_PATH_LINE@ and
-- @GSK_PATH_CLOSE@.
-- 
-- /Since: 4.14/
data PathForeachFlags = 
      PathForeachFlagsOnlyLines
    -- ^ The default behavior, only allow lines.
    | PathForeachFlagsQuad
    -- ^ Allow emission of @GSK_PATH_QUAD@ operations
    | PathForeachFlagsCubic
    -- ^ Allow emission of @GSK_PATH_CUBIC@ operations.
    | PathForeachFlagsConic
    -- ^ Allow emission of @GSK_PATH_CONIC@ operations.
    | AnotherPathForeachFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PathForeachFlags where
    fromEnum PathForeachFlagsOnlyLines = 0
    fromEnum PathForeachFlagsQuad = 1
    fromEnum PathForeachFlagsCubic = 2
    fromEnum PathForeachFlagsConic = 4
    fromEnum (AnotherPathForeachFlags k) = k

    toEnum 0 = PathForeachFlagsOnlyLines
    toEnum 1 = PathForeachFlagsQuad
    toEnum 2 = PathForeachFlagsCubic
    toEnum 4 = PathForeachFlagsConic
    toEnum k = AnotherPathForeachFlags k

instance P.Ord PathForeachFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PathForeachFlags = '[]
instance O.HasParentTypes PathForeachFlags

foreign import ccall "gsk_path_foreach_flags_get_type" c_gsk_path_foreach_flags_get_type :: 
    IO GType

instance B.Types.TypedObject PathForeachFlags where
    glibType = c_gsk_path_foreach_flags_get_type

instance B.Types.BoxedFlags PathForeachFlags

instance IsGFlag PathForeachFlags


