{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Combines two shortcut triggers.
-- 
-- The @GtkAlternativeTrigger@ triggers when either of the two trigger.
-- 
-- This can be cascaded to combine more than two triggers.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AlternativeTrigger
    ( 

-- * Exported types
    AlternativeTrigger(..)                  ,
    IsAlternativeTrigger                    ,
    toAlternativeTrigger                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [compare]("GI.Gtk.Objects.ShortcutTrigger#g:method:compare"), [equal]("GI.Gtk.Objects.ShortcutTrigger#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gtk.Objects.ShortcutTrigger#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutTrigger#g:method:print"), [printLabel]("GI.Gtk.Objects.ShortcutTrigger#g:method:printLabel"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toLabel]("GI.Gtk.Objects.ShortcutTrigger#g:method:toLabel"), [toString]("GI.Gtk.Objects.ShortcutTrigger#g:method:toString"), [trigger]("GI.Gtk.Objects.ShortcutTrigger#g:method:trigger"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFirst]("GI.Gtk.Objects.AlternativeTrigger#g:method:getFirst"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSecond]("GI.Gtk.Objects.AlternativeTrigger#g:method:getSecond").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAlternativeTriggerMethod         ,
#endif

-- ** getFirst #method:getFirst#

#if defined(ENABLE_OVERLOADING)
    AlternativeTriggerGetFirstMethodInfo    ,
#endif
    alternativeTriggerGetFirst              ,


-- ** getSecond #method:getSecond#

#if defined(ENABLE_OVERLOADING)
    AlternativeTriggerGetSecondMethodInfo   ,
#endif
    alternativeTriggerGetSecond             ,


-- ** new #method:new#

    alternativeTriggerNew                   ,




 -- * Properties


-- ** first #attr:first#
-- | The first @GtkShortcutTrigger@ to check.

#if defined(ENABLE_OVERLOADING)
    AlternativeTriggerFirstPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    alternativeTriggerFirst                 ,
#endif
    constructAlternativeTriggerFirst        ,
    getAlternativeTriggerFirst              ,


-- ** second #attr:second#
-- | The second @GtkShortcutTrigger@ to check.

#if defined(ENABLE_OVERLOADING)
    AlternativeTriggerSecondPropertyInfo    ,
#endif
#if defined(ENABLE_OVERLOADING)
    alternativeTriggerSecond                ,
#endif
    constructAlternativeTriggerSecond       ,
    getAlternativeTriggerSecond             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#endif

-- | Memory-managed wrapper type.
newtype AlternativeTrigger = AlternativeTrigger (SP.ManagedPtr AlternativeTrigger)
    deriving (Eq)

instance SP.ManagedPtrNewtype AlternativeTrigger where
    toManagedPtr (AlternativeTrigger p) = p

foreign import ccall "gtk_alternative_trigger_get_type"
    c_gtk_alternative_trigger_get_type :: IO B.Types.GType

instance B.Types.TypedObject AlternativeTrigger where
    glibType = c_gtk_alternative_trigger_get_type

instance B.Types.GObject AlternativeTrigger

-- | Type class for types which can be safely cast to t'AlternativeTrigger', for instance with `toAlternativeTrigger`.
class (SP.GObject o, O.IsDescendantOf AlternativeTrigger o) => IsAlternativeTrigger o
instance (SP.GObject o, O.IsDescendantOf AlternativeTrigger o) => IsAlternativeTrigger o

instance O.HasParentTypes AlternativeTrigger
type instance O.ParentTypes AlternativeTrigger = '[Gtk.ShortcutTrigger.ShortcutTrigger, GObject.Object.Object]

-- | Cast to t'AlternativeTrigger', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAlternativeTrigger :: (MIO.MonadIO m, IsAlternativeTrigger o) => o -> m AlternativeTrigger
toAlternativeTrigger = MIO.liftIO . B.ManagedPtr.unsafeCastTo AlternativeTrigger

-- | Convert t'AlternativeTrigger' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AlternativeTrigger) where
    gvalueGType_ = c_gtk_alternative_trigger_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AlternativeTrigger)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AlternativeTrigger)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AlternativeTrigger ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAlternativeTriggerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAlternativeTriggerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAlternativeTriggerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAlternativeTriggerMethod "compare" o = Gtk.ShortcutTrigger.ShortcutTriggerCompareMethodInfo
    ResolveAlternativeTriggerMethod "equal" o = Gtk.ShortcutTrigger.ShortcutTriggerEqualMethodInfo
    ResolveAlternativeTriggerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAlternativeTriggerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAlternativeTriggerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAlternativeTriggerMethod "hash" o = Gtk.ShortcutTrigger.ShortcutTriggerHashMethodInfo
    ResolveAlternativeTriggerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAlternativeTriggerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAlternativeTriggerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAlternativeTriggerMethod "print" o = Gtk.ShortcutTrigger.ShortcutTriggerPrintMethodInfo
    ResolveAlternativeTriggerMethod "printLabel" o = Gtk.ShortcutTrigger.ShortcutTriggerPrintLabelMethodInfo
    ResolveAlternativeTriggerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAlternativeTriggerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAlternativeTriggerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAlternativeTriggerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAlternativeTriggerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAlternativeTriggerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAlternativeTriggerMethod "toLabel" o = Gtk.ShortcutTrigger.ShortcutTriggerToLabelMethodInfo
    ResolveAlternativeTriggerMethod "toString" o = Gtk.ShortcutTrigger.ShortcutTriggerToStringMethodInfo
    ResolveAlternativeTriggerMethod "trigger" o = Gtk.ShortcutTrigger.ShortcutTriggerTriggerMethodInfo
    ResolveAlternativeTriggerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAlternativeTriggerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAlternativeTriggerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAlternativeTriggerMethod "getFirst" o = AlternativeTriggerGetFirstMethodInfo
    ResolveAlternativeTriggerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAlternativeTriggerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAlternativeTriggerMethod "getSecond" o = AlternativeTriggerGetSecondMethodInfo
    ResolveAlternativeTriggerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAlternativeTriggerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAlternativeTriggerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAlternativeTriggerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAlternativeTriggerMethod t AlternativeTrigger, O.OverloadedMethod info AlternativeTrigger p) => OL.IsLabel t (AlternativeTrigger -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAlternativeTriggerMethod t AlternativeTrigger, O.OverloadedMethod info AlternativeTrigger p, R.HasField t AlternativeTrigger p) => R.HasField t AlternativeTrigger p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAlternativeTriggerMethod t AlternativeTrigger, O.OverloadedMethodInfo info AlternativeTrigger) => OL.IsLabel t (O.MethodProxy info AlternativeTrigger) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "first"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@first@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alternativeTrigger #first
-- @
getAlternativeTriggerFirst :: (MonadIO m, IsAlternativeTrigger o) => o -> m Gtk.ShortcutTrigger.ShortcutTrigger
getAlternativeTriggerFirst obj = MIO.liftIO $ checkUnexpectedNothing "getAlternativeTriggerFirst" $ B.Properties.getObjectPropertyObject obj "first" Gtk.ShortcutTrigger.ShortcutTrigger

-- | Construct a t'GValueConstruct' with valid value for the “@first@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlternativeTriggerFirst :: (IsAlternativeTrigger o, MIO.MonadIO m, Gtk.ShortcutTrigger.IsShortcutTrigger a) => a -> m (GValueConstruct o)
constructAlternativeTriggerFirst val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "first" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AlternativeTriggerFirstPropertyInfo
instance AttrInfo AlternativeTriggerFirstPropertyInfo where
    type AttrAllowedOps AlternativeTriggerFirstPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AlternativeTriggerFirstPropertyInfo = IsAlternativeTrigger
    type AttrSetTypeConstraint AlternativeTriggerFirstPropertyInfo = Gtk.ShortcutTrigger.IsShortcutTrigger
    type AttrTransferTypeConstraint AlternativeTriggerFirstPropertyInfo = Gtk.ShortcutTrigger.IsShortcutTrigger
    type AttrTransferType AlternativeTriggerFirstPropertyInfo = Gtk.ShortcutTrigger.ShortcutTrigger
    type AttrGetType AlternativeTriggerFirstPropertyInfo = Gtk.ShortcutTrigger.ShortcutTrigger
    type AttrLabel AlternativeTriggerFirstPropertyInfo = "first"
    type AttrOrigin AlternativeTriggerFirstPropertyInfo = AlternativeTrigger
    attrGet = getAlternativeTriggerFirst
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.ShortcutTrigger.ShortcutTrigger v
    attrConstruct = constructAlternativeTriggerFirst
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlternativeTrigger.first"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlternativeTrigger.html#g:attr:first"
        })
#endif

-- VVV Prop "second"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@second@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' alternativeTrigger #second
-- @
getAlternativeTriggerSecond :: (MonadIO m, IsAlternativeTrigger o) => o -> m Gtk.ShortcutTrigger.ShortcutTrigger
getAlternativeTriggerSecond obj = MIO.liftIO $ checkUnexpectedNothing "getAlternativeTriggerSecond" $ B.Properties.getObjectPropertyObject obj "second" Gtk.ShortcutTrigger.ShortcutTrigger

-- | Construct a t'GValueConstruct' with valid value for the “@second@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAlternativeTriggerSecond :: (IsAlternativeTrigger o, MIO.MonadIO m, Gtk.ShortcutTrigger.IsShortcutTrigger a) => a -> m (GValueConstruct o)
constructAlternativeTriggerSecond val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "second" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AlternativeTriggerSecondPropertyInfo
instance AttrInfo AlternativeTriggerSecondPropertyInfo where
    type AttrAllowedOps AlternativeTriggerSecondPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AlternativeTriggerSecondPropertyInfo = IsAlternativeTrigger
    type AttrSetTypeConstraint AlternativeTriggerSecondPropertyInfo = Gtk.ShortcutTrigger.IsShortcutTrigger
    type AttrTransferTypeConstraint AlternativeTriggerSecondPropertyInfo = Gtk.ShortcutTrigger.IsShortcutTrigger
    type AttrTransferType AlternativeTriggerSecondPropertyInfo = Gtk.ShortcutTrigger.ShortcutTrigger
    type AttrGetType AlternativeTriggerSecondPropertyInfo = Gtk.ShortcutTrigger.ShortcutTrigger
    type AttrLabel AlternativeTriggerSecondPropertyInfo = "second"
    type AttrOrigin AlternativeTriggerSecondPropertyInfo = AlternativeTrigger
    attrGet = getAlternativeTriggerSecond
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.ShortcutTrigger.ShortcutTrigger v
    attrConstruct = constructAlternativeTriggerSecond
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlternativeTrigger.second"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlternativeTrigger.html#g:attr:second"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AlternativeTrigger
type instance O.AttributeList AlternativeTrigger = AlternativeTriggerAttributeList
type AlternativeTriggerAttributeList = ('[ '("first", AlternativeTriggerFirstPropertyInfo), '("second", AlternativeTriggerSecondPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
alternativeTriggerFirst :: AttrLabelProxy "first"
alternativeTriggerFirst = AttrLabelProxy

alternativeTriggerSecond :: AttrLabelProxy "second"
alternativeTriggerSecond = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AlternativeTrigger = AlternativeTriggerSignalList
type AlternativeTriggerSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AlternativeTrigger::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "first"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The first trigger that may trigger"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "second"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The second trigger that may trigger"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "AlternativeTrigger" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alternative_trigger_new" gtk_alternative_trigger_new :: 
    Ptr Gtk.ShortcutTrigger.ShortcutTrigger -> -- first : TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
    Ptr Gtk.ShortcutTrigger.ShortcutTrigger -> -- second : TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
    IO (Ptr AlternativeTrigger)

-- | Creates a @GtkShortcutTrigger@ that will trigger whenever
-- either of the two given triggers gets triggered.
-- 
-- Note that nesting is allowed, so if you want more than two
-- alternative, create a new alternative trigger for each option.
alternativeTriggerNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ShortcutTrigger.IsShortcutTrigger a, Gtk.ShortcutTrigger.IsShortcutTrigger b) =>
    a
    -- ^ /@first@/: The first trigger that may trigger
    -> b
    -- ^ /@second@/: The second trigger that may trigger
    -> m AlternativeTrigger
    -- ^ __Returns:__ a new @GtkShortcutTrigger@
alternativeTriggerNew first second = liftIO $ do
    first' <- B.ManagedPtr.disownObject first
    second' <- B.ManagedPtr.disownObject second
    result <- gtk_alternative_trigger_new first' second'
    checkUnexpectedReturnNULL "alternativeTriggerNew" result
    result' <- (wrapObject AlternativeTrigger) result
    touchManagedPtr first
    touchManagedPtr second
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AlternativeTrigger::get_first
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlternativeTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alternative `GtkShortcutTrigger`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alternative_trigger_get_first" gtk_alternative_trigger_get_first :: 
    Ptr AlternativeTrigger ->               -- self : TInterface (Name {namespace = "Gtk", name = "AlternativeTrigger"})
    IO (Ptr Gtk.ShortcutTrigger.ShortcutTrigger)

-- | Gets the first of the two alternative triggers that may
-- trigger /@self@/.
-- 
-- 'GI.Gtk.Objects.AlternativeTrigger.alternativeTriggerGetSecond' will return
-- the other one.
alternativeTriggerGetFirst ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlternativeTrigger a) =>
    a
    -- ^ /@self@/: an alternative @GtkShortcutTrigger@
    -> m Gtk.ShortcutTrigger.ShortcutTrigger
    -- ^ __Returns:__ the first alternative trigger
alternativeTriggerGetFirst self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alternative_trigger_get_first self'
    checkUnexpectedReturnNULL "alternativeTriggerGetFirst" result
    result' <- (newObject Gtk.ShortcutTrigger.ShortcutTrigger) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AlternativeTriggerGetFirstMethodInfo
instance (signature ~ (m Gtk.ShortcutTrigger.ShortcutTrigger), MonadIO m, IsAlternativeTrigger a) => O.OverloadedMethod AlternativeTriggerGetFirstMethodInfo a signature where
    overloadedMethod = alternativeTriggerGetFirst

instance O.OverloadedMethodInfo AlternativeTriggerGetFirstMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlternativeTrigger.alternativeTriggerGetFirst",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlternativeTrigger.html#v:alternativeTriggerGetFirst"
        })


#endif

-- method AlternativeTrigger::get_second
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AlternativeTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an alternative `GtkShortcutTrigger`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_alternative_trigger_get_second" gtk_alternative_trigger_get_second :: 
    Ptr AlternativeTrigger ->               -- self : TInterface (Name {namespace = "Gtk", name = "AlternativeTrigger"})
    IO (Ptr Gtk.ShortcutTrigger.ShortcutTrigger)

-- | Gets the second of the two alternative triggers that may
-- trigger /@self@/.
-- 
-- 'GI.Gtk.Objects.AlternativeTrigger.alternativeTriggerGetFirst' will return
-- the other one.
alternativeTriggerGetSecond ::
    (B.CallStack.HasCallStack, MonadIO m, IsAlternativeTrigger a) =>
    a
    -- ^ /@self@/: an alternative @GtkShortcutTrigger@
    -> m Gtk.ShortcutTrigger.ShortcutTrigger
    -- ^ __Returns:__ the second alternative trigger
alternativeTriggerGetSecond self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_alternative_trigger_get_second self'
    checkUnexpectedReturnNULL "alternativeTriggerGetSecond" result
    result' <- (newObject Gtk.ShortcutTrigger.ShortcutTrigger) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data AlternativeTriggerGetSecondMethodInfo
instance (signature ~ (m Gtk.ShortcutTrigger.ShortcutTrigger), MonadIO m, IsAlternativeTrigger a) => O.OverloadedMethod AlternativeTriggerGetSecondMethodInfo a signature where
    overloadedMethod = alternativeTriggerGetSecond

instance O.OverloadedMethodInfo AlternativeTriggerGetSecondMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AlternativeTrigger.alternativeTriggerGetSecond",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AlternativeTrigger.html#v:alternativeTriggerGetSecond"
        })


#endif


