
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kfontutils_wrapper.h"

// Argument includes
#include <QString>
#include <qpainter.h>
#include <qsize.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFontUtils_Type = nullptr;
static PyTypeObject *Sbk_KFontUtils_TypeF(void)
{
    return _Sbk_KFontUtils_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KFontUtils_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KFontUtils");
    return -1;
}

static PyObject *Sbk_KFontUtilsFunc_adaptFontSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "adaptFontSize", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:adaptFontSize", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KFontUtils::adaptFontSize(QPainter&,QString,QSizeF,qreal=,qreal=,QFlags<KFontUtils::AdaptFontSizeOption>=)->qreal
    // 1: static KFontUtils::adaptFontSize(QPainter&,QString,qreal,qreal,qreal=,qreal=,QFlags<KFontUtils::AdaptFontSizeOption>=)->qreal
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs >= 4
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 1; // adaptFontSize(QPainter&,QString,qreal,qreal,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
                if (numArgs == 5) {
                    overloadId = 1; // adaptFontSize(QPainter&,QString,qreal,qreal,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                } else if (numArgs >= 6
                    && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5])))) {
                    if (numArgs == 6) {
                        overloadId = 1; // adaptFontSize(QPainter&,QString,qreal,qreal,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                    } else if (numArgs >= 7
                        && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_QFlags_KFontUtils_AdaptFontSizeOption_IDX])))->flagsConverter, (pyArgs[6])))) {
                        overloadId = 1; // adaptFontSize(QPainter&,QString,qreal,qreal,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                    }
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSizeF_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // adaptFontSize(QPainter&,QString,QSizeF,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // adaptFontSize(QPainter&,QString,QSizeF,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 0; // adaptFontSize(QPainter&,QString,QSizeF,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_QFlags_KFontUtils_AdaptFontSizeOption_IDX])))->flagsConverter, (pyArgs[5])))) {
                        overloadId = 0; // adaptFontSize(QPainter&,QString,QSizeF,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "adaptFontSize", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // adaptFontSize(QPainter &painter, const QString &text, const QSizeF &availableSize, qreal maxFontSize, qreal minFontSize, QFlags<KFontUtils::AdaptFontSizeOption> flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"maxFontSize", 3}, {"minFontSize", 4}, {"flags", 5}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4]))))
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_QFlags_KFontUtils_AdaptFontSizeOption_IDX])))->flagsConverter, (pyArgs[5]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "adaptFontSize", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QSizeF cppArg2_local;
            ::QSizeF *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2].isValue())
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            qreal cppArg3 = 28.0;
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            qreal cppArg4 = 1.0;
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QFlags<KFontUtils::AdaptFontSizeOption> cppArg5(KFontUtils::AdaptFontSizeOption::NoFlags);
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (Shiboken::Errors::occurred() == nullptr) {
                // adaptFontSize(QPainter&,QString,QSizeF,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                qreal cppResult = ::KFontUtils::adaptFontSize(*cppArg0, cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
        case 1: // adaptFontSize(QPainter &painter, const QString &text, qreal width, qreal height, qreal maxFontSize, qreal minFontSize, QFlags<KFontUtils::AdaptFontSizeOption> flags)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"maxFontSize", 4}, {"minFontSize", 5}, {"flags", 6}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4]))))
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5]))))
                    || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_QFlags_KFontUtils_AdaptFontSizeOption_IDX])))->flagsConverter, (pyArgs[6]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "adaptFontSize", errInfo, SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            qreal cppArg4 = 28.0;
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);
            qreal cppArg5 = 1.0;
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QFlags<KFontUtils::AdaptFontSizeOption> cppArg6(KFontUtils::AdaptFontSizeOption::NoFlags);
            if (pythonToCpp[6])
                pythonToCpp[6](pyArgs[6], &cppArg6);

            if (Shiboken::Errors::occurred() == nullptr) {
                // adaptFontSize(QPainter&,QString,qreal,qreal,qreal,qreal,QFlags<KFontUtils::AdaptFontSizeOption>)
                qreal cppResult = ::KFontUtils::adaptFontSize(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KFontUtils_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KFontUtils_EnumFlagInfo[] = {
    "AdaptFontSizeOption:IntFlag:AdaptFontSizeOptions",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFontUtils_methods[] = {
    {"adaptFontSize", reinterpret_cast<PyCFunction>(Sbk_KFontUtilsFunc_adaptFontSize), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KFontUtils_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFontUtils_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFontUtils_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFontUtils_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFontUtils_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFontUtils_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFontUtils_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFontUtils_spec = {
    "1:KGuiAddons.KFontUtils",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFontUtils_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KFontUtils_AdaptFontSizeOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KFontUtils::AdaptFontSizeOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KFontUtils::AdaptFontSizeOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KFontUtils_AdaptFontSizeOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KFontUtils_AdaptFontSizeOption_IDX])))
        return Enum_PythonToCpp_KFontUtils_AdaptFontSizeOption;
    return {};
}

static PyObject *KFontUtils_AdaptFontSizeOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KFontUtils::AdaptFontSizeOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KFontUtils::AdaptFontSizeOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KFontUtils_AdaptFontSizeOption(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KFontUtils::AdaptFontSizeOption>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KFontUtils::AdaptFontSizeOption> *>(cppOut) = value;

}

static PyObject *KFontUtils_AdaptFontSizeOption_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KFontUtils::AdaptFontSizeOption> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KFontUtils_AdaptFontSizeOption_IDX]), flags.toInt());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KGuiAddonsKFontUtils_SignatureStrings[] = {
    "1:KGuiAddons.KFontUtils.adaptFontSize(painter:PySide6.QtGui.QPainter,text:QString,availableSize:typing.Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize],maxFontSize:qreal=28.0,minFontSize:qreal=1.0,flags:KGuiAddons.KFontUtils.AdaptFontSizeOption=KFontUtils.AdaptFontSizeOption.NoFlags)->qreal",
    "0:KGuiAddons.KFontUtils.adaptFontSize(painter:PySide6.QtGui.QPainter,text:QString,width:qreal,height:qreal,maxFontSize:qreal=28.0,minFontSize:qreal=1.0,flags:KGuiAddons.KFontUtils.AdaptFontSizeOption=KFontUtils.AdaptFontSizeOption.NoFlags)->qreal",
    nullptr}; // Sentinel
#else
static constexpr size_t KGuiAddonsKFontUtils_SignatureByteSize = 198;
static constexpr uint8_t KGuiAddonsKFontUtils_SignatureBytes[198] = {
    0x78, 0xda, 0xcd, 0x90, 0x3f, 0x0b, 0xc2, 0x40, 0x0c, 0xc5, 0x77, 0x3f, 0x85, 0xa3, 0xc2, 0x79,
    0xb4, 0x0e, 0x22, 0x07, 0x0a, 0x22, 0xd4, 0xa1, 0xa0, 0x2d, 0xc5, 0x49, 0x1c, 0x22, 0x77, 0xb6,
    0x81, 0xeb, 0x5d, 0x6d, 0xa3, 0xb6, 0x7e, 0x7a, 0x5b, 0xff, 0xa0, 0x88, 0x3a, 0x39, 0x38, 0xbe,
    0x5f, 0xf2, 0x92, 0xbc, 0xb8, 0xc2, 0x9f, 0xed, 0x71, 0x22, 0xa5, 0x35, 0x05, 0xf7, 0x3d, 0x6b,
    0x68, 0x49, 0xa8, 0x0b, 0x0e, 0x12, 0x32, 0x6a, 0x64, 0x84, 0x27, 0xd5, 0xc9, 0x00, 0x0d, 0xa9,
    0x5c, 0x04, 0x55, 0x84, 0x52, 0x0d, 0x78, 0x48, 0xb5, 0x89, 0x87, 0xc1, 0x15, 0x33, 0x52, 0x25,
    0x89, 0x30, 0xa2, 0x1c, 0x4d, 0xcc, 0xe0, 0x00, 0xa8, 0x61, 0xa3, 0x55, 0xe3, 0x14, 0x54, 0x65,
    0x35, 0xe4, 0x4b, 0x83, 0xd6, 0xac, 0x1e, 0xf6, 0xa9, 0xcd, 0x15, 0x0f, 0x9b, 0x0e, 0x8f, 0xb5,
    0xdf, 0xe1, 0x35, 0x4b, 0xa1, 0xbc, 0xef, 0x17, 0xbb, 0x5c, 0x81, 0x1e, 0xf5, 0x87, 0xdc, 0x61,
    0x29, 0x9a, 0x17, 0xec, 0xd6, 0x74, 0xab, 0x21, 0x2e, 0x3e, 0x44, 0x99, 0x3c, 0x47, 0x59, 0x64,
    0x54, 0x5f, 0x32, 0xfa, 0x5e, 0xe6, 0x73, 0xeb, 0x35, 0x03, 0xbb, 0xbd, 0xf1, 0x65, 0x45, 0xcb,
    0xf9, 0xf9, 0x97, 0x8e, 0x28, 0x29, 0xb9, 0x06, 0x60, 0x89, 0xc2, 0x38, 0xa1, 0x9b, 0xf8, 0xa7,
    0xd8, 0x67, 0x64, 0x07, 0xc6, 0x11
};
#endif

PyTypeObject *init_KGuiAddonsKFontUtils(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX].type;

    Shiboken::AutoDecRef Sbk_KFontUtils_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KFontUtils_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFontUtils",
        "KFontUtils",
        &Sbk_KFontUtils_spec,
        nullptr,
        Sbk_KFontUtils_Type_bases.object(),
        0);
    auto *pyType = Sbk_KFontUtils_TypeF(); // references _Sbk_KFontUtils_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KGuiAddonsKFontUtils_SignatureStrings);
#else
    InitSignatureBytes(pyType, KGuiAddonsKFontUtils_SignatureBytes, KGuiAddonsKFontUtils_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFontUtils_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KGuiAddonsKFontUtils_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KFontUtils_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'AdaptFontSizeOption'.
    const char *AdaptFontSizeOption_Initializer[] = {
        "NoFlags",
        "DoNotAllowWordWrap",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t AdaptFontSizeOption_InitializerValues[] = {
        uint8_t(KFontUtils::AdaptFontSizeOption::NoFlags),           //  0x01  1
        uint8_t(KFontUtils::AdaptFontSizeOption::DoNotAllowWordWrap) //  0x02  2
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KFontUtils_TypeF(),
        "1:KGuiAddons.KFontUtils.AdaptFontSizeOption",
        AdaptFontSizeOption_Initializer, AdaptFontSizeOption_InitializerValues);
    SbkKGuiAddonsTypeStructs[SBK_KFontUtils_AdaptFontSizeOption_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKGuiAddonsTypeStructs[SBK_QFlags_KFontUtils_AdaptFontSizeOption_IDX].type =
        EType;
    // Register converter for enum 'KFontUtils::AdaptFontSizeOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KFontUtils_AdaptFontSizeOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KFontUtils_AdaptFontSizeOption,
            is_Enum_PythonToCpp_KFontUtils_AdaptFontSizeOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KFontUtils::AdaptFontSizeOption");
        Shiboken::Conversions::registerConverterAlias(converter, "AdaptFontSizeOption");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KFontUtils_AdaptFontSizeOption_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KFontUtils_AdaptFontSizeOption,
            is_Enum_PythonToCpp_KFontUtils_AdaptFontSizeOption_Convertible);
        // Register converter for flag 'QFlags<KFontUtils::AdaptFontSizeOption>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KFontUtils::AdaptFontSizeOption>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KFontUtils::AdaptFontSizeOptions");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'AdaptFontSizeOption' enum/flags.

    qRegisterMetaType< ::KFontUtils::AdaptFontSizeOption >("KFontUtils::AdaptFontSizeOption");

    return pyType;
}
