
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kratingpainter_wrapper.h"

// Argument includes
#include <qicon.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qpoint.h>
#include <qrect.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KRatingPainter_Type = nullptr;
static PyTypeObject *Sbk_KRatingPainter_TypeF(void)
{
    return _Sbk_KRatingPainter_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KRatingPainter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KRatingPainter >()))
        return -1;

    ::KRatingPainter *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // KRatingPainter()
        cptr = new ::KRatingPainter();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KRatingPainter >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KRatingPainterFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // alignment()const
        QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->alignment();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_customPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // customPixmap()const
        QPixmap cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->customPixmap();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_getRatingFromPosition(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "getRatingFromPosition", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KRatingPainter::getRatingFromPosition(QRect,QFlags<Qt::AlignmentFlag>,Qt::LayoutDirection,QPoint)->int
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_LayoutDirection_IDX])))->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[3])))) {
        overloadId = 0; // getRatingFromPosition(QRect,QFlags<Qt::AlignmentFlag>,Qt::LayoutDirection,QPoint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getRatingFromPosition", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<Qt::AlignmentFlag> cppArg1 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::Qt::LayoutDirection cppArg2{Qt::LeftToRight};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QPoint cppArg3_local;
        ::QPoint *cppArg3 = &cppArg3_local;
        if (pythonToCpp[3].isValue())
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getRatingFromPosition(QRect,QFlags<Qt::AlignmentFlag>,Qt::LayoutDirection,QPoint)
            int cppResult = ::KRatingPainter::getRatingFromPosition(*cppArg0, cppArg1, cppArg2, *cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_halfStepsEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // halfStepsEnabled()const
        bool cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->halfStepsEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // icon()const
        QIcon cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->icon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEnabled()const
        bool cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->isEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_layoutDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // layoutDirection()const
        Qt::LayoutDirection cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->layoutDirection();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_LayoutDirection_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_maxRating(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maxRating()const
        int cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->maxRating();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_paint(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "paint", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:paint", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KRatingPainter::paint(QPainter*,QRect,int,int=)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // paint(QPainter*,QRect,int,int)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // paint(QPainter*,QRect,int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "paint", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"hoverRating", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "paint", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paint(QPainter*,QRect,int,int)const
            const_cast<const ::KRatingPainter *>(cppSelf)->paint(cppArg0, *cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_paintRating(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 4, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "paintRating", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:paintRating", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KRatingPainter::paintRating(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,int,int=)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // paintRating(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,int,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 0; // paintRating(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "paintRating", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"hoverRating", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "paintRating", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QFlags<Qt::AlignmentFlag> cppArg2 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = -1;
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintRating(QPainter*,QRect,QFlags<Qt::AlignmentFlag>,int,int)
            ::KRatingPainter::paintRating(cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_ratingFromPosition(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "ratingFromPosition", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KRatingPainter::ratingFromPosition(QRect,QPoint)const->int
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[1])))) {
        overloadId = 0; // ratingFromPosition(QRect,QPoint)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "ratingFromPosition", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPoint cppArg1_local;
        ::QPoint *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // ratingFromPosition(QRect,QPoint)const
            int cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->ratingFromPosition(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KRatingPainterFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAlignment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setAlignment(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setCustomPixmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setCustomPixmap(QPixmap)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArg)))) {
        overloadId = 0; // setCustomPixmap(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCustomPixmap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setCustomPixmap(QPixmap)
            cppSelf->setCustomPixmap(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setHalfStepsEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setHalfStepsEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setHalfStepsEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHalfStepsEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHalfStepsEnabled(bool)
            cppSelf->setHalfStepsEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setLayoutDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setLayoutDirection(Qt::LayoutDirection)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_LayoutDirection_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setLayoutDirection(Qt::LayoutDirection)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLayoutDirection", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLayoutDirection(Qt::LayoutDirection)
            cppSelf->setLayoutDirection(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setMaxRating(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setMaxRating(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxRating(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMaxRating", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaxRating(int)
            cppSelf->setMaxRating(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_setSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KRatingPainter::setSpacing(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSpacing(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSpacing", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSpacing(int)
            cppSelf->setSpacing(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KRatingPainterFunc_spacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KRatingPainter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // spacing()const
        int cppResult = const_cast<const ::KRatingPainter *>(cppSelf)->spacing();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KRatingPainter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KRatingPainter_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_alignment), METH_NOARGS, nullptr},
    {"customPixmap", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_customPixmap), METH_NOARGS, nullptr},
    {"getRatingFromPosition", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_getRatingFromPosition), METH_VARARGS|METH_STATIC, nullptr},
    {"halfStepsEnabled", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_halfStepsEnabled), METH_NOARGS, nullptr},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_icon), METH_NOARGS, nullptr},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_isEnabled), METH_NOARGS, nullptr},
    {"layoutDirection", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_layoutDirection), METH_NOARGS, nullptr},
    {"maxRating", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_maxRating), METH_NOARGS, nullptr},
    {"paint", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_paint), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"paintRating", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_paintRating), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"ratingFromPosition", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_ratingFromPosition), METH_VARARGS, nullptr},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setAlignment), METH_O, nullptr},
    {"setCustomPixmap", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setCustomPixmap), METH_O, nullptr},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setEnabled), METH_O, nullptr},
    {"setHalfStepsEnabled", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setHalfStepsEnabled), METH_O, nullptr},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setIcon), METH_O, nullptr},
    {"setLayoutDirection", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setLayoutDirection), METH_O, nullptr},
    {"setMaxRating", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setMaxRating), METH_O, nullptr},
    {"setSpacing", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_setSpacing), METH_O, nullptr},
    {"spacing", reinterpret_cast<PyCFunction>(Sbk_KRatingPainterFunc_spacing), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KRatingPainter_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KRatingPainter_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KRatingPainter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KRatingPainter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KRatingPainter_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KRatingPainter_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KRatingPainter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KRatingPainter_spec = {
    "1:KWidgetsAddons.KRatingPainter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KRatingPainter_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KRatingPainter_PythonToCpp_KRatingPainter_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KRatingPainter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KRatingPainter_PythonToCpp_KRatingPainter_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KRatingPainter_TypeF()))
        return KRatingPainter_PythonToCpp_KRatingPainter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KRatingPainter_PTR_CppToPython_KRatingPainter(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KRatingPainter_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KRatingPainter_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KRatingPainter_SignatureStrings[] = {
    "KWidgetsAddons.KRatingPainter(self)",
    "KWidgetsAddons.KRatingPainter.alignment(self)->PySide6.QtCore.Qt.AlignmentFlag",
    "KWidgetsAddons.KRatingPainter.customPixmap(self)->PySide6.QtGui.QPixmap",
    "KWidgetsAddons.KRatingPainter.getRatingFromPosition(rect:PySide6.QtCore.QRect,align:PySide6.QtCore.Qt.AlignmentFlag,direction:PySide6.QtCore.Qt.LayoutDirection,pos:PySide6.QtCore.QPoint)->int",
    "KWidgetsAddons.KRatingPainter.halfStepsEnabled(self)->bool",
    "KWidgetsAddons.KRatingPainter.icon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KRatingPainter.isEnabled(self)->bool",
    "KWidgetsAddons.KRatingPainter.layoutDirection(self)->PySide6.QtCore.Qt.LayoutDirection",
    "KWidgetsAddons.KRatingPainter.maxRating(self)->int",
    "KWidgetsAddons.KRatingPainter.paint(self,painter:PySide6.QtGui.QPainter,rect:PySide6.QtCore.QRect,rating:int,hoverRating:int=-1)",
    "KWidgetsAddons.KRatingPainter.paintRating(p:PySide6.QtGui.QPainter,rect:PySide6.QtCore.QRect,align:PySide6.QtCore.Qt.AlignmentFlag,rating:int,hoverRating:int=-1)",
    "KWidgetsAddons.KRatingPainter.ratingFromPosition(self,rect:PySide6.QtCore.QRect,pos:PySide6.QtCore.QPoint)->int",
    "KWidgetsAddons.KRatingPainter.setAlignment(self,align:PySide6.QtCore.Qt.AlignmentFlag)",
    "KWidgetsAddons.KRatingPainter.setCustomPixmap(self,pixmap:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage])",
    "KWidgetsAddons.KRatingPainter.setEnabled(self,enabled:bool)",
    "KWidgetsAddons.KRatingPainter.setHalfStepsEnabled(self,enabled:bool)",
    "KWidgetsAddons.KRatingPainter.setIcon(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KRatingPainter.setLayoutDirection(self,direction:PySide6.QtCore.Qt.LayoutDirection)",
    "KWidgetsAddons.KRatingPainter.setMaxRating(self,max:int)",
    "KWidgetsAddons.KRatingPainter.setSpacing(self,spacing:int)",
    "KWidgetsAddons.KRatingPainter.spacing(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KRatingPainter_SignatureByteSize = 391;
static constexpr uint8_t KRatingPainter_SignatureBytes[391] = {
    0x78, 0xda, 0xa5, 0x54, 0x5d, 0x6b, 0xc2, 0x30, 0x14, 0x7d, 0xdf, 0xaf, 0xd8, 0xa3, 0x85, 0x58,
    0xd8, 0xcb, 0x1e, 0x0a, 0x1b, 0x88, 0x9b, 0x9b, 0xe8, 0xa0, 0x2a, 0x63, 0x0f, 0x63, 0x0f, 0xb1,
    0x8d, 0x35, 0x90, 0x26, 0x21, 0x89, 0xc3, 0xfe, 0xfb, 0xdd, 0x36, 0x56, 0xb4, 0x1f, 0x26, 0xce,
    0x97, 0xa6, 0xb9, 0x39, 0xf7, 0xe4, 0x9e, 0xcb, 0x3d, 0x99, 0x7d, 0xd1, 0x34, 0x23, 0x46, 0x8f,
    0xd2, 0x54, 0x70, 0x1d, 0xce, 0x96, 0xd8, 0x50, 0x9e, 0xc5, 0x98, 0x72, 0x43, 0xd4, 0x40, 0x13,
    0xb6, 0x09, 0xee, 0x66, 0x97, 0x30, 0x21, 0x66, 0x34, 0xe3, 0x39, 0xe1, 0xc6, 0xa2, 0x87, 0xcf,
    0x71, 0xb1, 0xa2, 0x29, 0x79, 0x0c, 0x17, 0x66, 0x2c, 0x14, 0x81, 0x25, 0x1c, 0xd5, 0x90, 0x09,
    0xc3, 0x99, 0x83, 0x2e, 0xd9, 0x69, 0x23, 0xf2, 0x98, 0xee, 0x73, 0x2c, 0xdb, 0x8c, 0x6f, 0x3b,
    0x1a, 0x2e, 0xec, 0xa1, 0x83, 0x07, 0x4e, 0x6c, 0x60, 0xa2, 0x80, 0x4e, 0x68, 0x6a, 0xa8, 0xe0,
    0x03, 0x45, 0x12, 0x13, 0x35, 0x0b, 0x5c, 0x42, 0x10, 0x55, 0x32, 0x22, 0x47, 0xed, 0x28, 0xa5,
    0x25, 0x03, 0x30, 0x75, 0x20, 0xe7, 0xb8, 0x10, 0x3b, 0xf3, 0x52, 0x23, 0x90, 0x14, 0xba, 0x85,
    0x8a, 0x05, 0x54, 0x07, 0x8a, 0xe0, 0xeb, 0xa8, 0x7f, 0x8b, 0xd9, 0x66, 0x65, 0x88, 0xd4, 0xaf,
    0x1c, 0xaf, 0x19, 0x49, 0xeb, 0x5e, 0xac, 0x85, 0x60, 0x8e, 0x54, 0x9a, 0x80, 0xd2, 0xee, 0xd6,
    0x4d, 0xe1, 0xc8, 0x95, 0xfd, 0x8f, 0x1b, 0xd9, 0xb9, 0xf4, 0xfe, 0x49, 0x68, 0xf4, 0xc8, 0x41,
    0x9b, 0xe3, 0xbd, 0x0d, 0xd4, 0x84, 0xee, 0xb6, 0xc9, 0x72, 0xad, 0xe0, 0x48, 0xda, 0x50, 0xd4,
    0x9c, 0x1e, 0x1b, 0x46, 0xfd, 0xa3, 0xa0, 0x2a, 0xc6, 0x08, 0x60, 0x68, 0x2b, 0x7e, 0x89, 0x5a,
    0x1e, 0xf7, 0x4f, 0xc3, 0x87, 0xc0, 0xa7, 0x80, 0x43, 0xd5, 0xf2, 0xfa, 0xbb, 0xfd, 0xc6, 0xf0,
    0xa6, 0x0a, 0x55, 0xdb, 0x16, 0x55, 0xbf, 0xfa, 0x8b, 0xba, 0x6d, 0x92, 0x35, 0x31, 0xa3, 0xb3,
    0x37, 0xc2, 0x4f, 0x64, 0xe0, 0xa6, 0x1d, 0x37, 0xdf, 0x0a, 0x24, 0xab, 0xff, 0xc8, 0x14, 0x12,
    0x90, 0xe1, 0x27, 0x07, 0x71, 0xdf, 0x9d, 0xaf, 0x07, 0xba, 0x6f, 0x3a, 0x23, 0xc7, 0x19, 0xf9,
    0xf1, 0xb8, 0xf4, 0xd4, 0x1d, 0x88, 0xd8, 0x4d, 0x54, 0x7a, 0xc4, 0x23, 0xf7, 0xbd, 0xcb, 0xd4,
    0xd7, 0x92, 0x4c, 0x6b, 0x7b, 0xa3, 0xd2, 0xe8, 0x17, 0xb5, 0x96, 0xd0, 0x96, 0x52, 0xdb, 0x00,
    0x1f, 0xa9, 0xf3, 0x0e, 0x5b, 0x5f, 0xf3, 0x04, 0x7a, 0x5c, 0xf1, 0x71, 0x66, 0x71, 0x04, 0x8e,
    0x2f, 0xa7, 0xd8, 0x23, 0x71, 0x25, 0x71, 0x72, 0x4c, 0xd3, 0x76, 0xe3, 0x95, 0x7a, 0x92, 0x77,
    0x18, 0xdf, 0x3f, 0x5e, 0x2b, 0x92, 0x84
};
#endif

PyTypeObject *init_KRatingPainter(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX].type;

    Shiboken::AutoDecRef Sbk_KRatingPainter_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KRatingPainter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KRatingPainter",
        "KRatingPainter*",
        &Sbk_KRatingPainter_spec,
        &Shiboken::callCppDestructor< ::KRatingPainter >,
        Sbk_KRatingPainter_Type_bases.object(),
        0);
    auto *pyType = Sbk_KRatingPainter_TypeF(); // references _Sbk_KRatingPainter_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KRatingPainter_SignatureStrings);
#else
    InitSignatureBytes(pyType, KRatingPainter_SignatureBytes, KRatingPainter_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KRatingPainter_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KRatingPainter_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KRatingPainter_PythonToCpp_KRatingPainter_PTR,
        is_KRatingPainter_PythonToCpp_KRatingPainter_PTR_Convertible,
        KRatingPainter_PTR_CppToPython_KRatingPainter);

    Shiboken::Conversions::registerConverterName(converter, "KRatingPainter");
    Shiboken::Conversions::registerConverterName(converter, "KRatingPainter*");
    Shiboken::Conversions::registerConverterName(converter, "KRatingPainter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KRatingPainter).name());

    qRegisterMetaType< ::KRatingPainter *>();

    return pyType;
}
