
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kselectaction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktoolbarspaceraction_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <kselectaction.h>
#include <qaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qtoolbutton.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KSelectAction_Type = nullptr;
static PyTypeObject *Sbk_KSelectAction_TypeF(void)
{
    return _Sbk_KSelectAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KSelectActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KSelectActionWrapper::KSelectActionWrapper(::QObject * parent) : KSelectAction(parent)
{
}

KSelectActionWrapper::KSelectActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : KSelectAction(icon, text, parent)
{
}

KSelectActionWrapper::KSelectActionWrapper(const ::QString & text, ::QObject * parent) : KSelectAction(text, parent)
{
}

void KSelectActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KSelectAction", funcName, gil, pyOverride, event);
}

void KSelectActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KSelectAction", funcName, gil, pyOverride, signal);
}

::QWidget * KSelectActionWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::createWidget(parent);
    }
    return KToolBarSpacerActionWrapper::sbk_o_createWidget("KSelectAction", funcName, gil, pyOverride, parent);
}

void KSelectActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KSelectAction", funcName, gil, pyOverride, event);
}

void KSelectActionWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::deleteWidget(widget);
    }
    KToolBarSpacerActionWrapper::sbk_o_deleteWidget("KSelectAction", funcName, gil, pyOverride, widget);
}

void KSelectActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KSelectAction", funcName, gil, pyOverride, signal);
}

bool KSelectActionWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KSelectAction", funcName, gil, pyOverride, event);
}

bool KSelectActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KSelectAction", funcName, gil, pyOverride, watched, event);
}

void KSelectActionWrapper::insertAction(::QAction * before, ::QAction * action)
{
    static const char *funcName = "insertAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::insertAction(before, action);
    }
    sbk_o_insertAction("KSelectAction", funcName, gil, pyOverride, before, action);
}

void KSelectActionWrapper::sbk_o_insertAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAction * before, ::QAction * action)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), before),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), before),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QAction * KSelectActionWrapper::removeAction(::QAction * action)
{
    static const char *funcName = "removeAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::removeAction(action);
    }
    return sbk_o_removeAction("KSelectAction", funcName, gil, pyOverride, action);
}

::QAction * KSelectActionWrapper::sbk_o_removeAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAction * action)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QAction >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAction *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KSelectActionWrapper::slotActionTriggered(::QAction * action)
{
    static const char *funcName = "slotActionTriggered";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::slotActionTriggered(action);
    }
    sbk_o_slotActionTriggered("KSelectAction", funcName, gil, pyOverride, action);
}

void KSelectActionWrapper::sbk_o_slotActionTriggered(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAction * action)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KSelectActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KSelectAction_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KSelectAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KSelectActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KSelectAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KSelectActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KSelectAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KSelectActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KSelectActionWrapper *>(this));
    }
    return KSelectAction::qt_metacast(_clname);
}

KSelectActionWrapper::~KSelectActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KSelectAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KSelectAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KSelectAction >()))
        return -1;

    KSelectActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KSelectAction", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KSelectAction::KSelectAction(QObject*)
    // 1: KSelectAction::KSelectAction(QIcon,QString,QObject*)
    // 2: KSelectAction::KSelectAction(QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 1; // KSelectAction(QIcon,QString,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KSelectAction(QObject*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 2; // KSelectAction(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KSelectAction(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KSelectAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KSelectActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KSelectActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KSelectAction(const QIcon &icon, const QString &text, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KSelectAction(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KSelectActionWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KSelectActionWrapper(*cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 2: // KSelectAction(const QString &text, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KSelectAction(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KSelectActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KSelectActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KSelectAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KSelectActionFunc_action(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "action", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    if (PyArg_ParseTuple(args, "|OO:action", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSelectAction::action(QString,Qt::CaseSensitivity=)const->QAction*
    // 1: KSelectAction::action(int)const->QAction*
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // action(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // action(QString,Qt::CaseSensitivity)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CaseSensitivity_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // action(QString,Qt::CaseSensitivity)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "action", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // action(const QString &text, Qt::CaseSensitivity cs) const
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"cs", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CaseSensitivity_IDX])))->converter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "action", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::CaseSensitivity cppArg1(Qt::CaseSensitive);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // action(QString,Qt::CaseSensitivity)const
                QAction * cppResult = const_cast<const ::KSelectAction *>(cppSelf)->action(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
        case 1: // action(int index) const
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "action", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // action(int)const
                QAction * cppResult = const_cast<const ::KSelectAction *>(cppSelf)->action(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_actions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actions()const
        QList<QAction*> cppResult = const_cast<const ::KSelectAction *>(cppSelf)->actions();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QActionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_addAction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addAction", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSelectAction::addAction(QAction*)
    // 1: KSelectAction::addAction(QIcon,QString)->QAction*
    // 2: KSelectAction::addAction(QString)->QAction*
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 1; // addAction(QIcon,QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addAction(QAction*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 2; // addAction(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addAction(QAction *action)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QAction *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QAction*)
                cppSelf->addAction(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // addAction(const QIcon &icon, const QString &text)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QIcon,QString)
                QAction * cppResult = cppSelf->addAction(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
        case 2: // addAction(const QString &text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QString)
                QAction * cppResult = cppSelf->addAction(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_changeItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "changeItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSelectAction::changeItem(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // changeItem(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "changeItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeItem(int,QString)
            cppSelf->changeItem(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clear()
        cppSelf->clear();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_comboWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // comboWidth()const
        int cppResult = const_cast<const ::KSelectAction *>(cppSelf)->comboWidth();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_createWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::createWidget(QWidget*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // createWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createWidget(QWidget*)
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::createWidget(cppArg0)
                : cppSelf->createWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_currentAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentAction()const
        QAction * cppResult = const_cast<const ::KSelectAction *>(cppSelf)->currentAction();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_currentItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentItem()const
        int cppResult = const_cast<const ::KSelectAction *>(cppSelf)->currentItem();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_currentText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentText()const
        QString cppResult = const_cast<const ::KSelectAction *>(cppSelf)->currentText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_deleteWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidgetAction::deleteWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // deleteWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "deleteWidget", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // deleteWidget(QWidget*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::deleteWidget(cppArg0)
                : cppSelf->deleteWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_insertAction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insertAction", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSelectAction::insertAction(QAction*,QAction*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertAction(QAction*,QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAction *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QAction *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertAction(QAction*,QAction*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::insertAction(cppArg0, cppArg1)
                : cppSelf->insertAction(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_isEditable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEditable()const
        bool cppResult = const_cast<const ::KSelectAction *>(cppSelf)->isEditable();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_items(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // items()const
        QStringList cppResult = const_cast<const ::KSelectAction *>(cppSelf)->items();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_menuAccelsEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // menuAccelsEnabled()const
        bool cppResult = const_cast<const ::KSelectAction *>(cppSelf)->menuAccelsEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_removeAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::removeAction(QAction*)->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // removeAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeAction(QAction*)
            QAction * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::removeAction(cppArg0)
                : cppSelf->removeAction(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_removeAllActions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // removeAllActions()
        cppSelf->removeAllActions();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_selectableActionGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectableActionGroup()const
        QActionGroup * cppResult = const_cast<const ::KSelectAction *>(cppSelf)->selectableActionGroup();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QActionGroup_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_setComboWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setComboWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setComboWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setComboWidth", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComboWidth(int)
            cppSelf->setComboWidth(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_setCurrentAction(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setCurrentAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setCurrentAction", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSelectAction::setCurrentAction(QAction*)->bool
    // 1: KSelectAction::setCurrentAction(QString,Qt::CaseSensitivity=)->bool
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setCurrentAction(QAction*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setCurrentAction(QString,Qt::CaseSensitivity)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CaseSensitivity_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 1; // setCurrentAction(QString,Qt::CaseSensitivity)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setCurrentAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setCurrentAction(QAction *action)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setCurrentAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QAction *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setCurrentAction(QAction*)
                bool cppResult = cppSelf->setCurrentAction(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // setCurrentAction(const QString &text, Qt::CaseSensitivity cs)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"cs", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_CaseSensitivity_IDX])))->converter, (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setCurrentAction", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::CaseSensitivity cppArg1(Qt::CaseSensitive);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setCurrentAction(QString,Qt::CaseSensitivity)
                bool cppResult = cppSelf->setCurrentAction(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_setCurrentItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setCurrentItem(int)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentItem(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentItem(int)
            bool cppResult = cppSelf->setCurrentItem(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_setEditable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setEditable(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEditable(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEditable", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEditable(bool)
            cppSelf->setEditable(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_setItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setItems(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // setItems(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setItems", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setItems(QStringList)
            cppSelf->setItems(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_setMaxComboViewCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setMaxComboViewCount(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxComboViewCount(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMaxComboViewCount", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaxComboViewCount(int)
            cppSelf->setMaxComboViewCount(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_setMenuAccelsEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setMenuAccelsEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMenuAccelsEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMenuAccelsEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMenuAccelsEnabled(bool)
            cppSelf->setMenuAccelsEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_setToolBarMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setToolBarMode(KSelectAction::ToolBarMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_ToolBarMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setToolBarMode(KSelectAction::ToolBarMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolBarMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        ::KSelectAction::ToolBarMode cppArg0{KSelectAction::MenuMode};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolBarMode(KSelectAction::ToolBarMode)
            cppSelf->setToolBarMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_setToolButtonPopupMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::setToolButtonPopupMode(QToolButton::ToolButtonPopupMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_ToolButtonPopupMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setToolButtonPopupMode(QToolButton::ToolButtonPopupMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToolButtonPopupMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        ::QToolButton::ToolButtonPopupMode cppArg0{QToolButton::DelayedPopup};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToolButtonPopupMode(QToolButton::ToolButtonPopupMode)
            cppSelf->setToolButtonPopupMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_slotActionTriggered(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::slotActionTriggered(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // slotActionTriggered(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotActionTriggered", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotActionTriggered(QAction*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KSelectAction::slotActionTriggered(cppArg0)
                : cppSelf->slotActionTriggered(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_slotToggled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::slotToggled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // slotToggled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotToggled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotToggled(bool)
            cppSelf->slotToggled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSelectActionFunc_toolBarMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolBarMode()const
        KSelectAction::ToolBarMode cppResult = const_cast<const ::KSelectAction *>(cppSelf)->toolBarMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_ToolBarMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSelectActionFunc_toolButtonPopupMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // toolButtonPopupMode()const
        QToolButton::ToolButtonPopupMode cppResult = const_cast<const ::KSelectAction *>(cppSelf)->toolButtonPopupMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_ToolButtonPopupMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KSelectAction_PropertyStrings[] = {
    "comboWidth::",
    "currentAction::",
    "currentItem::",
    "currentText:",
    "editable:isEditable:",
    "items::",
    "toolBarMode::",
    "toolButtonPopupMode::",
    nullptr // Sentinel
};

static const char *Sbk_KSelectAction_EnumFlagInfo[] = {
    "ToolBarMode:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KSelectAction_methods[] = {
    {"action", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_action), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"actions", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_actions), METH_NOARGS, nullptr},
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_addAction), METH_VARARGS, nullptr},
    {"changeItem", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_changeItem), METH_VARARGS, nullptr},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_clear), METH_NOARGS, nullptr},
    {"comboWidth", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_comboWidth), METH_NOARGS, nullptr},
    {"createWidget", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_createWidget), METH_O, nullptr},
    {"currentAction", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_currentAction), METH_NOARGS, nullptr},
    {"currentItem", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_currentItem), METH_NOARGS, nullptr},
    {"currentText", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_currentText), METH_NOARGS, nullptr},
    {"deleteWidget", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_deleteWidget), METH_O, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_event), METH_O, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_eventFilter), METH_VARARGS, nullptr},
    {"insertAction", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_insertAction), METH_VARARGS, nullptr},
    {"isEditable", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_isEditable), METH_NOARGS, nullptr},
    {"items", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_items), METH_NOARGS, nullptr},
    {"menuAccelsEnabled", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_menuAccelsEnabled), METH_NOARGS, nullptr},
    {"removeAction", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_removeAction), METH_O, nullptr},
    {"removeAllActions", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_removeAllActions), METH_NOARGS, nullptr},
    {"selectableActionGroup", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_selectableActionGroup), METH_NOARGS, nullptr},
    {"setComboWidth", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setComboWidth), METH_O, nullptr},
    {"setCurrentAction", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setCurrentAction), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setCurrentItem", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setCurrentItem), METH_O, nullptr},
    {"setEditable", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setEditable), METH_O, nullptr},
    {"setItems", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setItems), METH_O, nullptr},
    {"setMaxComboViewCount", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setMaxComboViewCount), METH_O, nullptr},
    {"setMenuAccelsEnabled", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setMenuAccelsEnabled), METH_O, nullptr},
    {"setToolBarMode", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setToolBarMode), METH_O, nullptr},
    {"setToolButtonPopupMode", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_setToolButtonPopupMode), METH_O, nullptr},
    {"slotActionTriggered", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_slotActionTriggered), METH_O, nullptr},
    {"slotToggled", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_slotToggled), METH_O, nullptr},
    {"toolBarMode", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_toolBarMode), METH_NOARGS, nullptr},
    {"toolButtonPopupMode", reinterpret_cast<PyCFunction>(Sbk_KSelectActionFunc_toolButtonPopupMode), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KSelectAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KSelectAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KSelectActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KSelectAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KSelectAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KSelectAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KSelectAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KSelectAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KSelectAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KSelectAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KSelectAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KSelectAction_spec = {
    "1:KWidgetsAddons.KSelectAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KSelectAction_slots
};

} //extern "C"

static void *Sbk_KSelectAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KSelectAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KSelectAction_ToolBarMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KSelectAction::ToolBarMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KSelectAction::ToolBarMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KSelectAction_ToolBarMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_ToolBarMode_IDX])))
        return Enum_PythonToCpp_KSelectAction_ToolBarMode;
    return {};
}

static PyObject *KSelectAction_ToolBarMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KSelectAction::ToolBarMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KSelectAction::ToolBarMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KSelectAction_PythonToCpp_KSelectAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KSelectAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KSelectAction_PythonToCpp_KSelectAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KSelectAction_TypeF()))
        return KSelectAction_PythonToCpp_KSelectAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KSelectAction_PTR_CppToPython_KSelectAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KSelectAction *>(const_cast<void *>(cppIn)), Sbk_KSelectAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KSelectAction_SignatureStrings[] = {
    "2:KWidgetsAddons.KSelectAction(self,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,currentAction:QAction=None,editable:bool=None,comboWidth:int=None,currentText:QString=None,toolBarMode:KWidgetsAddons.KSelectAction.ToolBarMode=None,toolButtonPopupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode=None,currentItem:int=None,items:QStringList=None)",
    "1:KWidgetsAddons.KSelectAction(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,currentAction:QAction=None,editable:bool=None,comboWidth:int=None,currentText:QString=None,toolBarMode:KWidgetsAddons.KSelectAction.ToolBarMode=None,toolButtonPopupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode=None,currentItem:int=None,items:QStringList=None)",
    "0:KWidgetsAddons.KSelectAction(self,text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,currentAction:QAction=None,editable:bool=None,comboWidth:int=None,currentText:QString=None,toolBarMode:KWidgetsAddons.KSelectAction.ToolBarMode=None,toolButtonPopupMode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode=None,currentItem:int=None,items:QStringList=None)",
    "1:KWidgetsAddons.KSelectAction.action(self,text:QString,cs:PySide6.QtCore.Qt.CaseSensitivity=Qt.CaseSensitive)->PySide6.QtGui.QAction",
    "0:KWidgetsAddons.KSelectAction.action(self,index:int)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KSelectAction.actions(self)->QList[PySide6.QtGui.QAction]",
    "2:KWidgetsAddons.KSelectAction.addAction(self,action:PySide6.QtGui.QAction)",
    "1:KWidgetsAddons.KSelectAction.addAction(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString)->PySide6.QtGui.QAction",
    "0:KWidgetsAddons.KSelectAction.addAction(self,text:QString)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KSelectAction.changeItem(self,index:int,text:QString)",
    "KWidgetsAddons.KSelectAction.clear(self)",
    "KWidgetsAddons.KSelectAction.comboWidth(self)->int",
    "KWidgetsAddons.KSelectAction.createWidget(self,parent:PySide6.QtWidgets.QWidget)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KSelectAction.currentAction(self)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KSelectAction.currentItem(self)->int",
    "KWidgetsAddons.KSelectAction.currentText(self)->QString",
    "KWidgetsAddons.KSelectAction.deleteWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KWidgetsAddons.KSelectAction.event(self,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KSelectAction.eventFilter(self,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KSelectAction.insertAction(self,before:PySide6.QtGui.QAction,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KSelectAction.isEditable(self)->bool",
    "KWidgetsAddons.KSelectAction.items(self)->QStringList",
    "KWidgetsAddons.KSelectAction.menuAccelsEnabled(self)->bool",
    "KWidgetsAddons.KSelectAction.removeAction(self,action:PySide6.QtGui.QAction)->PySide6.QtGui.QAction",
    "KWidgetsAddons.KSelectAction.removeAllActions(self)",
    "KWidgetsAddons.KSelectAction.selectableActionGroup(self)->PySide6.QtGui.QActionGroup",
    "KWidgetsAddons.KSelectAction.setComboWidth(self,width:int)",
    "1:KWidgetsAddons.KSelectAction.setCurrentAction(self,action:PySide6.QtGui.QAction)->bool",
    "0:KWidgetsAddons.KSelectAction.setCurrentAction(self,text:QString,cs:PySide6.QtCore.Qt.CaseSensitivity=Qt.CaseSensitive)->bool",
    "KWidgetsAddons.KSelectAction.setCurrentItem(self,index:int)->bool",
    "KWidgetsAddons.KSelectAction.setEditable(self,arg__1:bool)",
    "KWidgetsAddons.KSelectAction.setItems(self,lst:QStringList)",
    "KWidgetsAddons.KSelectAction.setMaxComboViewCount(self,n:int)",
    "KWidgetsAddons.KSelectAction.setMenuAccelsEnabled(self,b:bool)",
    "KWidgetsAddons.KSelectAction.setToolBarMode(self,mode:KWidgetsAddons.KSelectAction.ToolBarMode)",
    "KWidgetsAddons.KSelectAction.setToolButtonPopupMode(self,mode:PySide6.QtWidgets.QToolButton.ToolButtonPopupMode)",
    "KWidgetsAddons.KSelectAction.slotActionTriggered(self,action:PySide6.QtGui.QAction)",
    "KWidgetsAddons.KSelectAction.slotToggled(self,arg__1:bool)",
    "KWidgetsAddons.KSelectAction.toolBarMode(self)->KWidgetsAddons.KSelectAction.ToolBarMode",
    "KWidgetsAddons.KSelectAction.toolButtonPopupMode(self)->PySide6.QtWidgets.QToolButton.ToolButtonPopupMode",
    nullptr}; // Sentinel
#else
static constexpr size_t KSelectAction_SignatureByteSize = 689;
static constexpr uint8_t KSelectAction_SignatureBytes[689] = {
    0x78, 0xda, 0xed, 0x56, 0xc9, 0x6e, 0xdb, 0x30, 0x10, 0xbd, 0xfb, 0x2b, 0x7a, 0x6c, 0x0a, 0x55,
    0x48, 0x72, 0xe8, 0x41, 0x40, 0x0a, 0xb8, 0x86, 0x1b, 0x04, 0x6e, 0x1a, 0x0b, 0x76, 0xdb, 0x43,
    0x10, 0x04, 0x92, 0x38, 0x91, 0x59, 0x48, 0xa4, 0x40, 0x52, 0x5e, 0xfe, 0xbe, 0xa4, 0x28, 0x59,
    0x8b, 0x65, 0x91, 0xb1, 0x83, 0x9e, 0x72, 0x12, 0x45, 0xce, 0xbc, 0x19, 0xbe, 0x59, 0x38, 0xd7,
    0xde, 0xec, 0x0f, 0x46, 0x31, 0x08, 0x3e, 0x46, 0x88, 0x12, 0xee, 0xce, 0x16, 0x90, 0x40, 0x24,
    0xc6, 0x91, 0xc0, 0x94, 0x7c, 0xe4, 0x90, 0xbc, 0x38, 0x59, 0xc0, 0x80, 0x08, 0x6f, 0xbe, 0x5b,
    0x60, 0x04, 0x5f, 0x5c, 0x5f, 0x4c, 0x28, 0x03, 0xd7, 0x7f, 0x08, 0xff, 0x4a, 0x41, 0xe7, 0x93,
    0x37, 0x83, 0xdd, 0x86, 0x32, 0xf4, 0x40, 0x92, 0xdd, 0xcd, 0x4f, 0x4a, 0xc0, 0x89, 0x72, 0xa6,
    0x34, 0x34, 0x86, 0xe7, 0xeb, 0xaf, 0x3e, 0x02, 0x84, 0x45, 0x10, 0x26, 0xe0, 0x85, 0x94, 0x26,
    0xa5, 0x34, 0x4d, 0x43, 0x2a, 0x9d, 0x10, 0x2b, 0x0f, 0x13, 0xd1, 0x42, 0x58, 0xc2, 0x56, 0x78,
    0xfe, 0x42, 0x30, 0x4c, 0x62, 0x7d, 0x20, 0xa4, 0xda, 0xb7, 0x80, 0xdd, 0x53, 0x04, 0x83, 0x9e,
    0xbb, 0xcb, 0x5a, 0xb0, 0xa1, 0x99, 0x0b, 0x41, 0xc9, 0x9c, 0x66, 0x79, 0x56, 0x20, 0xd4, 0x57,
    0x2a, 0xa1, 0x5c, 0x7f, 0xb9, 0x17, 0x73, 0x97, 0x87, 0x1a, 0x2d, 0xef, 0xee, 0x04, 0xa4, 0xb5,
    0xcb, 0x58, 0xfe, 0xf1, 0xca, 0xd9, 0x1f, 0x98, 0xeb, 0xed, 0x8b, 0xd1, 0x95, 0x05, 0xc3, 0x38,
    0x92, 0x3c, 0x89, 0x5d, 0x26, 0x35, 0xdd, 0x5f, 0x44, 0x6e, 0x3f, 0xd6, 0x9e, 0xdd, 0xe6, 0xd8,
    0xf5, 0xef, 0xa4, 0x80, 0xf3, 0xa1, 0xb3, 0x39, 0xc7, 0xdb, 0x34, 0xc8, 0x9e, 0x1c, 0xd1, 0x60,
    0xe9, 0x3d, 0x58, 0x67, 0x05, 0xeb, 0xd2, 0x22, 0x58, 0xef, 0x74, 0xff, 0xa7, 0xda, 0x70, 0x83,
    0x63, 0xac, 0x47, 0xfc, 0x80, 0x71, 0xe1, 0x4e, 0x02, 0x0e, 0x0b, 0x20, 0x1c, 0x0b, 0xbc, 0xc6,
    0x62, 0x77, 0xd3, 0xd9, 0x82, 0x8b, 0xcf, 0x5f, 0x3b, 0x05, 0xa4, 0xcd, 0x18, 0x82, 0xde, 0xf2,
    0x02, 0x13, 0x04, 0x5b, 0x75, 0xaf, 0xa3, 0x60, 0x16, 0x50, 0xbc, 0xc0, 0x92, 0x08, 0xbe, 0xa2,
    0xe2, 0xb1, 0x17, 0xe7, 0x69, 0x74, 0x6d, 0xf0, 0x0a, 0xa1, 0x66, 0x52, 0x6a, 0x64, 0xaf, 0x17,
    0xcb, 0xcc, 0x73, 0x1b, 0xeb, 0xed, 0xba, 0xd1, 0xc9, 0x94, 0xb7, 0x1d, 0xb2, 0x82, 0x1c, 0x04,
    0x8c, 0x56, 0x01, 0x89, 0x41, 0x25, 0x65, 0x27, 0x8e, 0x6d, 0x6c, 0x03, 0x48, 0x02, 0x01, 0xd3,
    0xb1, 0x33, 0x08, 0xee, 0xab, 0xb6, 0x8a, 0xb4, 0xb4, 0x64, 0x50, 0x61, 0x10, 0x08, 0xd0, 0x12,
    0x47, 0x5e, 0xdd, 0x7d, 0x19, 0xea, 0x45, 0x8b, 0x88, 0xce, 0x99, 0xc1, 0x56, 0xb3, 0x05, 0x55,
    0x1e, 0x9e, 0x42, 0x6a, 0x5d, 0xea, 0xf6, 0xf7, 0xac, 0x9b, 0xd7, 0xbe, 0x0a, 0x34, 0xf9, 0xc3,
    0x7a, 0x48, 0xfe, 0xb4, 0xf9, 0xd9, 0x14, 0xeb, 0x01, 0x7e, 0x86, 0x01, 0x61, 0x2d, 0xdd, 0xd0,
    0x48, 0xc5, 0xf2, 0xa0, 0xa1, 0x4c, 0xd5, 0xae, 0x74, 0x4f, 0x35, 0x63, 0x0b, 0xa8, 0xef, 0x38,
    0x11, 0xc0, 0x4a, 0xd7, 0x02, 0x11, 0xad, 0x00, 0x1d, 0x7b, 0x15, 0xce, 0xb5, 0x87, 0x09, 0x07,
    0xd6, 0x7a, 0x92, 0x42, 0x78, 0x91, 0x18, 0xfd, 0xd5, 0x6f, 0x68, 0x0d, 0xc3, 0x96, 0xf8, 0xb4,
    0x7c, 0x93, 0xaa, 0x60, 0x59, 0x78, 0xa7, 0x7a, 0x7d, 0x27, 0xb6, 0xaa, 0xcf, 0x0d, 0x6b, 0xa5,
    0x40, 0xf2, 0x71, 0x14, 0x41, 0xc2, 0xa7, 0x44, 0xd9, 0x43, 0xf6, 0x06, 0x19, 0xa4, 0x74, 0x0d,
    0xd6, 0xcd, 0xf0, 0xa4, 0x54, 0x2f, 0x6d, 0x24, 0xc9, 0xb8, 0xd9, 0xc1, 0x87, 0x75, 0x78, 0xf1,
    0xa3, 0x2e, 0xa3, 0x37, 0x6e, 0x19, 0xcd, 0xb3, 0xc1, 0x72, 0x2b, 0x24, 0x4c, 0xa0, 0x32, 0x5d,
    0x5a, 0xdd, 0x45, 0x15, 0x82, 0x1e, 0x0f, 0x8c, 0x7d, 0x5e, 0x29, 0x1f, 0xd4, 0xbe, 0x89, 0xad,
    0x22, 0x00, 0x97, 0xa7, 0x00, 0xbf, 0xc9, 0x93, 0x6d, 0x8e, 0x7f, 0x6d, 0xbc, 0xa7, 0xbf, 0xdb,
    0x22, 0xb4, 0xf2, 0xdc, 0x09, 0x58, 0xfc, 0xfc, 0x7c, 0x55, 0xcc, 0x61, 0xc6, 0x20, 0x17, 0x56,
    0x75, 0x42, 0x38, 0x09, 0x17, 0xcd, 0x29, 0xc7, 0xac, 0x7b, 0x1f, 0x6c, 0x8b, 0x70, 0xfe, 0xc6,
    0xb0, 0x99, 0xd0, 0xbc, 0xea, 0x48, 0x44, 0x87, 0xd3, 0xa8, 0xdd, 0x5b, 0x34, 0x4e, 0x68, 0xe9,
    0x78, 0x63, 0x0c, 0xd4, 0x8a, 0xe9, 0x6b, 0x26, 0x47, 0x4b, 0xfc, 0xf6, 0x8c, 0xd8, 0xb0, 0xf3,
    0xea, 0xf9, 0xd2, 0x64, 0x30, 0xa1, 0xe5, 0x72, 0xc9, 0x70, 0x1c, 0x03, 0xab, 0xe8, 0x38, 0xa3,
    0xff, 0x29, 0xcc, 0x25, 0x8d, 0xe3, 0x3d, 0xb5, 0xf6, 0x89, 0x21, 0x3a, 0xe4, 0xca, 0x44, 0xb4,
    0x65, 0xd6, 0x02, 0xb8, 0x87, 0xd5, 0xfe, 0x79, 0x60, 0x98, 0xd2, 0xd1, 0x3f, 0xdf, 0x69, 0xe4,
    0x63
};
#endif

PyTypeObject *init_KSelectAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KSelectAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX]))));

    _Sbk_KSelectAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KSelectAction",
        "KSelectAction*",
        &Sbk_KSelectAction_spec,
        &Shiboken::callCppDestructor< KSelectAction >,
        Sbk_KSelectAction_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KSelectAction_Type; // references _Sbk_KSelectAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KSelectAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KSelectAction_SignatureBytes, KSelectAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KSelectAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KSelectAction_PythonToCpp_KSelectAction_PTR,
        is_KSelectAction_PythonToCpp_KSelectAction_PTR_Convertible,
        KSelectAction_PTR_CppToPython_KSelectAction);

    Shiboken::Conversions::registerConverterName(converter, "KSelectAction");
    Shiboken::Conversions::registerConverterName(converter, "KSelectAction*");
    Shiboken::Conversions::registerConverterName(converter, "KSelectAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KSelectAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KSelectActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KSelectAction_TypeF(), &Sbk_KSelectAction_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KSelectAction_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ToolBarMode'.
    const char *ToolBarMode_Initializer[] = {
        "MenuMode",
        "ComboBoxMode",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ToolBarMode_InitializerValues[] = {
        uint8_t(KSelectAction::ToolBarMode::MenuMode),    //  0x00  0
        uint8_t(KSelectAction::ToolBarMode::ComboBoxMode) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KSelectAction_TypeF(),
        "1:KWidgetsAddons.KSelectAction.ToolBarMode",
        ToolBarMode_Initializer, ToolBarMode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_ToolBarMode_IDX].type = EType;
    // Register converter for enum 'KSelectAction::ToolBarMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KSelectAction_ToolBarMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KSelectAction_ToolBarMode,
            is_Enum_PythonToCpp_KSelectAction_ToolBarMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KSelectAction::ToolBarMode");
        Shiboken::Conversions::registerConverterAlias(converter, "ToolBarMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ToolBarMode' enum.

    PySide::Signal::registerSignals(pyType, &::KSelectAction::staticMetaObject);
    qRegisterMetaType< ::KSelectAction::ToolBarMode >("KSelectAction::ToolBarMode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KSelectAction::staticMetaObject, sizeof(KSelectActionWrapper));

    return pyType;
}
