
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kkeysequencewidget_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "ktoolbar_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kactioncollection.h>
#include <kkeysequencewidget.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qkeysequence.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KKeySequenceWidget_Type = nullptr;
static PyTypeObject *Sbk_KKeySequenceWidget_TypeF(void)
{
    return _Sbk_KKeySequenceWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KKeySequenceWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KKeySequenceWidgetWrapper::KKeySequenceWidgetWrapper(::QWidget * parent) : KKeySequenceWidget(parent)
{
}

void KKeySequenceWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KToolBarWrapper::sbk_o_actionEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KToolBarWrapper::sbk_o_changeEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KToolBarWrapper::sbk_o_closeEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KKeySequenceWidget", funcName, gil, pyOverride, signal);
}

void KKeySequenceWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KToolBarWrapper::sbk_o_contextMenuEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

int KKeySequenceWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KToolBarWrapper::sbk_o_devType("KKeySequenceWidget", funcName, gil, pyOverride);
}

void KKeySequenceWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KKeySequenceWidget", funcName, gil, pyOverride, signal);
}

void KKeySequenceWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KToolBarWrapper::sbk_o_dragEnterEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragLeaveEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_dragMoveEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KToolBarWrapper::sbk_o_dropEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KToolBarWrapper::sbk_o_enterEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

bool KKeySequenceWidgetWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KKeySequenceWidget", funcName, gil, pyOverride, watched, event);
}

void KKeySequenceWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KToolBarWrapper::sbk_o_focusInEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

bool KKeySequenceWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KToolBarWrapper::sbk_o_focusNextPrevChild("KKeySequenceWidget", funcName, gil, pyOverride, next);
}

void KKeySequenceWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KToolBarWrapper::sbk_o_focusOutEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

bool KKeySequenceWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KToolBarWrapper::sbk_o_hasHeightForWidth("KKeySequenceWidget", funcName, gil, pyOverride);
}

int KKeySequenceWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KToolBarWrapper::sbk_o_heightForWidth("KKeySequenceWidget", funcName, gil, pyOverride, arg__1);
}

void KKeySequenceWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KToolBarWrapper::sbk_o_hideEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KToolBarWrapper::sbk_o_initPainter("KKeySequenceWidget", funcName, gil, pyOverride, painter);
}

void KKeySequenceWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KToolBarWrapper::sbk_o_inputMethodEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

::QVariant KKeySequenceWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KToolBarWrapper::sbk_o_inputMethodQuery("KKeySequenceWidget", funcName, gil, pyOverride, arg__1);
}

void KKeySequenceWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KToolBarWrapper::sbk_o_keyPressEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_keyReleaseEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KToolBarWrapper::sbk_o_leaveEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

int KKeySequenceWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KToolBarWrapper::sbk_o_metric("KKeySequenceWidget", funcName, gil, pyOverride, arg__1);
}

::QSize KKeySequenceWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KKeySequenceWidget", funcName, gil, pyOverride);
}

void KKeySequenceWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseDoubleClickEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseMoveEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KToolBarWrapper::sbk_o_mousePressEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KToolBarWrapper::sbk_o_mouseReleaseEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KToolBarWrapper::sbk_o_moveEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

bool KKeySequenceWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KToolBarWrapper::sbk_o_nativeEvent("KKeySequenceWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KKeySequenceWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KToolBarWrapper::sbk_o_paintEngine("KKeySequenceWidget", funcName, gil, pyOverride);
}

void KKeySequenceWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KToolBarWrapper::sbk_o_paintEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * KKeySequenceWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KToolBarWrapper::sbk_o_redirected("KKeySequenceWidget", funcName, gil, pyOverride, offset);
}

void KKeySequenceWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KToolBarWrapper::sbk_o_resizeEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KToolBarWrapper::sbk_o_setVisible("KKeySequenceWidget", funcName, gil, pyOverride, visible);
}

::QPainter * KKeySequenceWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KToolBarWrapper::sbk_o_sharedPainter("KKeySequenceWidget", funcName, gil, pyOverride);
}

void KKeySequenceWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KToolBarWrapper::sbk_o_showEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

::QSize KKeySequenceWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KToolBarWrapper::sbk_o_minimumSizeHint("KKeySequenceWidget", funcName, gil, pyOverride);
}

void KKeySequenceWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KToolBarWrapper::sbk_o_tabletEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

void KKeySequenceWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KKeySequenceWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KToolBarWrapper::sbk_o_wheelEvent("KKeySequenceWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *KKeySequenceWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KKeySequenceWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KKeySequenceWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KKeySequenceWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KKeySequenceWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KKeySequenceWidgetWrapper *>(this));
    }
    return KKeySequenceWidget::qt_metacast(_clname);
}

KKeySequenceWidgetWrapper::~KKeySequenceWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KKeySequenceWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KKeySequenceWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KKeySequenceWidget >()))
        return -1;

    KKeySequenceWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KKeySequenceWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KKeySequenceWidget::KKeySequenceWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KKeySequenceWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KKeySequenceWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KKeySequenceWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KKeySequenceWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KKeySequenceWidgetWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KKeySequenceWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KKeySequenceWidgetFunc_applyStealShortcut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // applyStealShortcut()
        cppSelf->applyStealShortcut();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_captureKeySequence(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // captureKeySequence()
        cppSelf->captureKeySequence();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_checkForConflictsAgainst(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // checkForConflictsAgainst()const
        QFlags<KKeySequenceWidget::ShortcutType> cppResult = const_cast<const ::KKeySequenceWidget *>(cppSelf)->checkForConflictsAgainst();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KKeySequenceWidget_ShortcutType_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_clearKeySequence(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearKeySequence()
        cppSelf->clearKeySequence();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "event", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("event(QEvent *ev)");
        return {};
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_isKeySequenceAvailable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::isKeySequenceAvailable(QKeySequence)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArg)))) {
        overloadId = 0; // isKeySequenceAvailable(QKeySequence)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isKeySequenceAvailable", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // isKeySequenceAvailable(QKeySequence)const
            bool cppResult = const_cast<const ::KKeySequenceWidget *>(cppSelf)->isKeySequenceAvailable(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_isModifierlessAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceWidget", "isModifierlessAllowed()");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // isModifierlessAllowed()
        bool cppResult = cppSelf->isModifierlessAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_isRecording(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRecording()const
        bool cppResult = const_cast<const ::KKeySequenceWidget *>(cppSelf)->isRecording();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_keySequence(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // keySequence()const
        QKeySequence cppResult = const_cast<const ::KKeySequenceWidget *>(cppSelf)->keySequence();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_modifierOnlyAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceWidget", "modifierOnlyAllowed() const");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};

        // modifierOnlyAllowed()const
        bool cppResult = const_cast<const ::KKeySequenceWidget *>(cppSelf)->modifierOnlyAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_multiKeyShortcutsAllowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // multiKeyShortcutsAllowed()const
        bool cppResult = const_cast<const ::KKeySequenceWidget *>(cppSelf)->multiKeyShortcutsAllowed();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setCheckActionCollections(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setCheckActionCollections(QList<KActionCollection*>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX], (pyArg)))) {
        overloadId = 0; // setCheckActionCollections(QList<KActionCollection*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCheckActionCollections", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        ::QList<KActionCollection*> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCheckActionCollections(QList<KActionCollection*>)
            cppSelf->setCheckActionCollections(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setCheckForConflictsAgainst(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setCheckForConflictsAgainst(QFlags<KKeySequenceWidget::ShortcutType>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_QFlags_KKeySequenceWidget_ShortcutType_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setCheckForConflictsAgainst(QFlags<KKeySequenceWidget::ShortcutType>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCheckForConflictsAgainst", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        ::QFlags<KKeySequenceWidget::ShortcutType> cppArg0 = QFlags<KKeySequenceWidget::ShortcutType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCheckForConflictsAgainst(QFlags<KKeySequenceWidget::ShortcutType>)
            cppSelf->setCheckForConflictsAgainst(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setClearButtonShown(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setClearButtonShown(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setClearButtonShown(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setClearButtonShown", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setClearButtonShown(bool)
            cppSelf->setClearButtonShown(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setComponentName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setComponentName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setComponentName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setComponentName", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComponentName(QString)
            cppSelf->setComponentName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setKeySequence(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setKeySequence", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setKeySequence", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KKeySequenceWidget::setKeySequence(QKeySequence,KKeySequenceWidget::Validation=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setKeySequence(QKeySequence,KKeySequenceWidget::Validation)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_Validation_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 0; // setKeySequence(QKeySequence,KKeySequenceWidget::Validation)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setKeySequence", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"val", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_Validation_IDX])))->converter, (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setKeySequence", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::KKeySequenceWidget::Validation cppArg1(KKeySequenceWidget::Validation::NoValidate);
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setKeySequence(QKeySequence,KKeySequenceWidget::Validation)
            cppSelf->setKeySequence(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setModifierOnlyAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setModifierOnlyAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setModifierOnlyAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModifierOnlyAllowed", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceWidget", "setModifierOnlyAllowed(bool allow)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModifierOnlyAllowed(bool)
            cppSelf->setModifierOnlyAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setModifierlessAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setModifierlessAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setModifierlessAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setModifierlessAllowed", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KKeySequenceWidget", "setModifierlessAllowed(bool allow)");
        if (Shiboken::Errors::occurred() != nullptr)
            return {};
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setModifierlessAllowed(bool)
            cppSelf->setModifierlessAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KKeySequenceWidgetFunc_setMultiKeyShortcutsAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KKeySequenceWidget::setMultiKeyShortcutsAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMultiKeyShortcutsAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMultiKeyShortcutsAllowed", errInfo, SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMultiKeyShortcutsAllowed(bool)
            cppSelf->setMultiKeyShortcutsAllowed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KKeySequenceWidget_PropertyStrings[] = {
    "checkForConflictsAgainst::",
    "keySequence::",
    "modifierOnlyAllowed::",
    "modifierlessAllowed:isModifierlessAllowed:",
    "multiKeyShortcutsAllowed::",
    "recording:isRecording",
    nullptr // Sentinel
};

static const char *Sbk_KKeySequenceWidget_EnumFlagInfo[] = {
    "ShortcutType:IntFlag:ShortcutTypes",
    "Validation:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KKeySequenceWidget_methods[] = {
    {"applyStealShortcut", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_applyStealShortcut), METH_NOARGS, nullptr},
    {"captureKeySequence", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_captureKeySequence), METH_NOARGS, nullptr},
    {"checkForConflictsAgainst", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_checkForConflictsAgainst), METH_NOARGS, nullptr},
    {"clearKeySequence", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_clearKeySequence), METH_NOARGS, nullptr},
    {"event", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_event), METH_O, nullptr},
    {"isKeySequenceAvailable", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_isKeySequenceAvailable), METH_O, nullptr},
    {"isModifierlessAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_isModifierlessAllowed), METH_NOARGS, nullptr},
    {"isRecording", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_isRecording), METH_NOARGS, nullptr},
    {"keySequence", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_keySequence), METH_NOARGS, nullptr},
    {"modifierOnlyAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_modifierOnlyAllowed), METH_NOARGS, nullptr},
    {"multiKeyShortcutsAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_multiKeyShortcutsAllowed), METH_NOARGS, nullptr},
    {"setCheckActionCollections", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setCheckActionCollections), METH_O, nullptr},
    {"setCheckForConflictsAgainst", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setCheckForConflictsAgainst), METH_O, nullptr},
    {"setClearButtonShown", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setClearButtonShown), METH_O, nullptr},
    {"setComponentName", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setComponentName), METH_O, nullptr},
    {"setKeySequence", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setKeySequence), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setModifierOnlyAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setModifierOnlyAllowed), METH_O, nullptr},
    {"setModifierlessAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setModifierlessAllowed), METH_O, nullptr},
    {"setMultiKeyShortcutsAllowed", reinterpret_cast<PyCFunction>(Sbk_KKeySequenceWidgetFunc_setMultiKeyShortcutsAllowed), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KKeySequenceWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KKeySequenceWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KKeySequenceWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KKeySequenceWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KKeySequenceWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KKeySequenceWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KKeySequenceWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KKeySequenceWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KKeySequenceWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KKeySequenceWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KKeySequenceWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KKeySequenceWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KKeySequenceWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KKeySequenceWidget_spec = {
    "1:KXmlGui.KKeySequenceWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KKeySequenceWidget_slots
};

} //extern "C"

static void *Sbk_KKeySequenceWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KKeySequenceWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KKeySequenceWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KKeySequenceWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KKeySequenceWidget_Validation(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KKeySequenceWidget::Validation>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KKeySequenceWidget::Validation *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KKeySequenceWidget_Validation_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_Validation_IDX])))
        return Enum_PythonToCpp_KKeySequenceWidget_Validation;
    return {};
}

static PyObject *KKeySequenceWidget_Validation_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KKeySequenceWidget::Validation>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KKeySequenceWidget::Validation *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KKeySequenceWidget_ShortcutType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KKeySequenceWidget::ShortcutType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KKeySequenceWidget::ShortcutType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KKeySequenceWidget_ShortcutType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_ShortcutType_IDX])))
        return Enum_PythonToCpp_KKeySequenceWidget_ShortcutType;
    return {};
}

static PyObject *KKeySequenceWidget_ShortcutType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KKeySequenceWidget::ShortcutType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KKeySequenceWidget::ShortcutType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KKeySequenceWidget_ShortcutType(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KKeySequenceWidget::ShortcutType>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KKeySequenceWidget::ShortcutType> *>(cppOut) = value;

}

static PyObject *KKeySequenceWidget_ShortcutType_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KKeySequenceWidget::ShortcutType> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_ShortcutType_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KKeySequenceWidget_PythonToCpp_KKeySequenceWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KKeySequenceWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KKeySequenceWidget_PythonToCpp_KKeySequenceWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KKeySequenceWidget_TypeF()))
        return KKeySequenceWidget_PythonToCpp_KKeySequenceWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KKeySequenceWidget_PTR_CppToPython_KKeySequenceWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KKeySequenceWidget *>(const_cast<void *>(cppIn)), Sbk_KKeySequenceWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KKeySequenceWidget_SignatureStrings[] = {
    "KXmlGui.KKeySequenceWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,keySequence:QKeySequence=None,multiKeyShortcutsAllowed:bool=None,checkForConflictsAgainst:KXmlGui.KKeySequenceWidget.ShortcutType=None,modifierlessAllowed:bool=None,modifierOnlyAllowed:bool=None,recording:bool=None)",
    "KXmlGui.KKeySequenceWidget.applyStealShortcut(self)",
    "KXmlGui.KKeySequenceWidget.captureKeySequence(self)",
    "KXmlGui.KKeySequenceWidget.checkForConflictsAgainst(self)->KXmlGui.KKeySequenceWidget.ShortcutType",
    "KXmlGui.KKeySequenceWidget.clearKeySequence(self)",
    "KXmlGui.KKeySequenceWidget.event(self,ev:PySide6.QtCore.QEvent)->bool",
    "KXmlGui.KKeySequenceWidget.isKeySequenceAvailable(self,seq:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int])->bool",
    "KXmlGui.KKeySequenceWidget.isModifierlessAllowed(self)->bool",
    "KXmlGui.KKeySequenceWidget.isRecording(self)->bool",
    "KXmlGui.KKeySequenceWidget.keySequence(self)->PySide6.QtGui.QKeySequence",
    "KXmlGui.KKeySequenceWidget.modifierOnlyAllowed(self)->bool",
    "KXmlGui.KKeySequenceWidget.multiKeyShortcutsAllowed(self)->bool",
    "KXmlGui.KKeySequenceWidget.setCheckActionCollections(self,actionCollections:QList[KXmlGui.KActionCollection])",
    "KXmlGui.KKeySequenceWidget.setCheckForConflictsAgainst(self,types:KXmlGui.KKeySequenceWidget.ShortcutType)",
    "KXmlGui.KKeySequenceWidget.setClearButtonShown(self,show:bool)",
    "KXmlGui.KKeySequenceWidget.setComponentName(self,componentName:QString)",
    "KXmlGui.KKeySequenceWidget.setKeySequence(self,seq:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int],val:KXmlGui.KKeySequenceWidget.Validation=KKeySequenceWidget.Validation.NoValidate)",
    "KXmlGui.KKeySequenceWidget.setModifierOnlyAllowed(self,allow:bool)",
    "KXmlGui.KKeySequenceWidget.setModifierlessAllowed(self,allow:bool)",
    "KXmlGui.KKeySequenceWidget.setMultiKeyShortcutsAllowed(self,arg__1:bool)",
    nullptr}; // Sentinel
#else
static constexpr size_t KKeySequenceWidget_SignatureByteSize = 485;
static constexpr uint8_t KKeySequenceWidget_SignatureBytes[485] = {
    0x78, 0xda, 0xcd, 0x54, 0xc1, 0x6e, 0xdb, 0x30, 0x0c, 0xbd, 0xef, 0x2b, 0x72, 0x5c, 0x0b, 0xd5,
    0xc0, 0x2e, 0x3d, 0x18, 0x48, 0x81, 0xcc, 0xd8, 0x7a, 0xc8, 0x9a, 0xd6, 0xf3, 0xb6, 0x0e, 0x28,
    0x8a, 0x42, 0x91, 0x99, 0x54, 0x08, 0x2d, 0xb9, 0x12, 0x9d, 0xc0, 0x7f, 0x3f, 0x39, 0xb6, 0x17,
    0xc3, 0xad, 0x6d, 0xf5, 0xd6, 0x9b, 0x4c, 0xfa, 0xbd, 0x47, 0x91, 0x8f, 0x5a, 0xfe, 0xcd, 0xf0,
    0xba, 0x90, 0xc1, 0x72, 0x09, 0x65, 0x02, 0x2f, 0x05, 0x28, 0x01, 0xf7, 0x32, 0xdd, 0x02, 0x7d,
    0xb6, 0x80, 0x1b, 0x96, 0x73, 0x03, 0x8a, 0xc2, 0xbb, 0x32, 0x91, 0x29, 0x5c, 0x06, 0x31, 0xd5,
    0x49, 0x1b, 0xc4, 0xf5, 0x61, 0xae, 0x0a, 0xc4, 0x9c, 0x0c, 0x3b, 0x0f, 0x1d, 0xc3, 0x41, 0x9b,
    0xf4, 0x56, 0x61, 0x39, 0x5f, 0x69, 0x05, 0x6c, 0x77, 0xa2, 0x0c, 0xe3, 0x0e, 0x7f, 0x9d, 0xcd,
    0x0a, 0x24, 0x59, 0x45, 0x9f, 0xb5, 0x21, 0x51, 0x90, 0x5d, 0x20, 0xea, 0x03, 0xa4, 0xe1, 0x5a,
    0x6b, 0xac, 0x7f, 0x11, 0xcf, 0x20, 0x76, 0xdf, 0xb5, 0x89, 0xb4, 0xda, 0xa0, 0x14, 0xee, 0x97,
    0x2d, 0x97, 0xca, 0x52, 0xb8, 0x1c, 0xac, 0x3a, 0x68, 0xe9, 0x7e, 0x95, 0x79, 0x2b, 0xa4, 0x53,
    0xb9, 0x91, 0x60, 0x10, 0xec, 0x1b, 0x1a, 0x6d, 0xb6, 0x2a, 0xfb, 0x75, 0xd6, 0x80, 0x70, 0x57,
    0x92, 0x6a, 0x7b, 0x8a, 0x9d, 0x7d, 0x1a, 0x51, 0xe7, 0x79, 0x8e, 0x65, 0x42, 0xc0, 0xb1, 0xad,
    0xe3, 0xd8, 0xc6, 0x51, 0x8c, 0xe0, 0x39, 0x15, 0x06, 0x3a, 0x09, 0x0f, 0xcc, 0x40, 0x67, 0x6a,
    0xe4, 0xc5, 0x95, 0x67, 0x83, 0x46, 0x25, 0x10, 0xb8, 0x79, 0x57, 0x51, 0xb0, 0x77, 0x56, 0xa9,
    0x6d, 0x03, 0xfb, 0x8e, 0x65, 0x22, 0x6d, 0x20, 0x88, 0xbf, 0x55, 0x59, 0x57, 0x5a, 0xd5, 0xc8,
    0x31, 0x16, 0x69, 0x3b, 0xb1, 0xc5, 0x9e, 0x4b, 0xe4, 0x6b, 0xac, 0xd5, 0x99, 0x85, 0x97, 0x90,
    0xca, 0xdc, 0xcd, 0x23, 0xf8, 0xad, 0xa4, 0x56, 0x0f, 0x27, 0x91, 0x8a, 0xad, 0x6b, 0x32, 0x36,
    0xeb, 0x17, 0xe0, 0x92, 0x91, 0xce, 0xd6, 0x52, 0x71, 0x72, 0xd0, 0x6e, 0xbe, 0x8f, 0x0d, 0x12,
    0xe2, 0x2a, 0xe5, 0x26, 0x75, 0x31, 0x36, 0x8b, 0x13, 0x32, 0x4e, 0x91, 0xcd, 0xa4, 0xa2, 0x47,
    0xaf, 0x0b, 0xdc, 0xbc, 0x76, 0x5c, 0x3b, 0x98, 0x69, 0xf0, 0xcf, 0xd6, 0x72, 0xbe, 0x90, 0x5d,
    0x7f, 0x46, 0x17, 0x57, 0xc3, 0x57, 0x1b, 0x23, 0x7a, 0x63, 0x15, 0x7c, 0x6b, 0x18, 0x5a, 0x66,
    0x5f, 0xbc, 0x05, 0x8a, 0x2a, 0x4b, 0x2f, 0x44, 0x35, 0x9b, 0x48, 0x23, 0xc2, 0xf1, 0x64, 0xeb,
    0xb9, 0xf3, 0x7e, 0x38, 0x8c, 0x7f, 0x48, 0x4b, 0x0f, 0xff, 0x19, 0xfb, 0xb8, 0xc7, 0x33, 0x1f,
    0xb5, 0xa1, 0x05, 0x62, 0xce, 0x63, 0x60, 0x7d, 0x5f, 0x99, 0x49, 0xa9, 0x6a, 0x91, 0xbe, 0x16,
    0x44, 0x5a, 0x39, 0xd8, 0x41, 0x35, 0x56, 0x76, 0xc7, 0xe3, 0xa3, 0x32, 0x09, 0xd7, 0x59, 0xee,
    0x9e, 0x1d, 0x45, 0x2b, 0x9e, 0x35, 0x6b, 0x20, 0xba, 0xa1, 0xb0, 0xf1, 0xe7, 0x14, 0x4f, 0x7f,
    0x95, 0x3f, 0xc0, 0x32, 0xb1, 0x3d, 0xc7, 0xb1, 0x2e, 0xff, 0xe1, 0x28, 0xd3, 0xa3, 0xc0, 0x7c,
    0x34, 0x1b, 0xac, 0x74, 0xf3, 0x31, 0x39, 0x8c, 0x9b, 0x01, 0x8f, 0x33, 0x5e, 0x7d, 0x78, 0x0d,
    0x64, 0x68, 0xbb, 0xdf, 0x43, 0x31, 0xb6, 0x2e, 0x8c, 0x9b, 0xed, 0xd3, 0xd3, 0x97, 0x86, 0xe8,
    0x1f, 0xad, 0x17, 0xd7, 0x7e
};
#endif

PyTypeObject *init_KKeySequenceWidget(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_KKeySequenceWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KKeySequenceWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KKeySequenceWidget",
        "KKeySequenceWidget*",
        &Sbk_KKeySequenceWidget_spec,
        &Shiboken::callCppDestructor< KKeySequenceWidget >,
        Sbk_KKeySequenceWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KKeySequenceWidget_Type; // references _Sbk_KKeySequenceWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KKeySequenceWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, KKeySequenceWidget_SignatureBytes, KKeySequenceWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KKeySequenceWidget_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KKeySequenceWidget_PythonToCpp_KKeySequenceWidget_PTR,
        is_KKeySequenceWidget_PythonToCpp_KKeySequenceWidget_PTR_Convertible,
        KKeySequenceWidget_PTR_CppToPython_KKeySequenceWidget);

    Shiboken::Conversions::registerConverterName(converter, "KKeySequenceWidget");
    Shiboken::Conversions::registerConverterName(converter, "KKeySequenceWidget*");
    Shiboken::Conversions::registerConverterName(converter, "KKeySequenceWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KKeySequenceWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KKeySequenceWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KKeySequenceWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KKeySequenceWidget_TypeF(), &Sbk_KKeySequenceWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KKeySequenceWidget_TypeF(), &Sbk_KKeySequenceWidget_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KKeySequenceWidget_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Validation'.
    const char *Validation_Initializer[] = {
        "Validate",
        "NoValidate",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Validation_InitializerValues[] = {
        uint8_t(KKeySequenceWidget::Validation::Validate),  //  0x00  0
        uint8_t(KKeySequenceWidget::Validation::NoValidate) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KKeySequenceWidget_TypeF(),
        "1:KXmlGui.KKeySequenceWidget.Validation",
        Validation_Initializer, Validation_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_Validation_IDX].type = EType;
    // Register converter for enum 'KKeySequenceWidget::Validation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KKeySequenceWidget_Validation_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KKeySequenceWidget_Validation,
            is_Enum_PythonToCpp_KKeySequenceWidget_Validation_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KKeySequenceWidget::Validation");
        Shiboken::Conversions::registerConverterAlias(converter, "Validation");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Validation' enum.

    // Initialization of enum 'ShortcutType'.
    const char *ShortcutType_Initializer[] = {
        "None_",
        "LocalShortcuts",
        "StandardShortcuts",
        "GlobalShortcuts",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ShortcutType_InitializerValues[] = {
        uint8_t(KKeySequenceWidget::ShortcutType::None),              //  0x00  0
        uint8_t(KKeySequenceWidget::ShortcutType::LocalShortcuts),    //  0x01  1
        uint8_t(KKeySequenceWidget::ShortcutType::StandardShortcuts), //  0x02  2
        uint8_t(KKeySequenceWidget::ShortcutType::GlobalShortcuts)    //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KKeySequenceWidget_TypeF(),
        "1:KXmlGui.KKeySequenceWidget.ShortcutType",
        ShortcutType_Initializer, ShortcutType_InitializerValues);
    SbkKXmlGuiTypeStructs[SBK_KKeySequenceWidget_ShortcutType_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKXmlGuiTypeStructs[SBK_QFlags_KKeySequenceWidget_ShortcutType_IDX].type =
        EType;
    // Register converter for enum 'KKeySequenceWidget::ShortcutType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KKeySequenceWidget_ShortcutType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KKeySequenceWidget_ShortcutType,
            is_Enum_PythonToCpp_KKeySequenceWidget_ShortcutType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KKeySequenceWidget::ShortcutType");
        Shiboken::Conversions::registerConverterAlias(converter, "ShortcutType");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KKeySequenceWidget_ShortcutType_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KKeySequenceWidget_ShortcutType,
            is_Enum_PythonToCpp_KKeySequenceWidget_ShortcutType_Convertible);
        // Register converter for flag 'QFlags<KKeySequenceWidget::ShortcutType>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KKeySequenceWidget::ShortcutType>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KKeySequenceWidget::ShortcutTypes");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'ShortcutType' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KKeySequenceWidget::staticMetaObject);
    qRegisterMetaType< ::KKeySequenceWidget::Validation >("KKeySequenceWidget::Validation");
    qRegisterMetaType< ::KKeySequenceWidget::ShortcutType >("KKeySequenceWidget::ShortcutType");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KKeySequenceWidget::staticMetaObject, sizeof(KKeySequenceWidgetWrapper));

    return pyType;
}
