/* Generated file (by generator) */

/*
 * Copyright (C) 2015 William Yu <williamyu@gnome.org>
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of version 2.1. of the GNU Lesser General Public License
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <https://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "i-cal-timezone.h"
#include "libical-glib-private.h"
#include "i-cal-component.h"
#include "i-cal-array.h"
#include "i-cal-time.h"

G_DEFINE_TYPE (ICalTimezone, i_cal_timezone, I_CAL_TYPE_OBJECT)

static void i_cal_timezone_class_init (G_GNUC_UNUSED ICalTimezoneClass *klass)
{
}

static void i_cal_timezone_init (G_GNUC_UNUSED ICalTimezone *self)
{
}

/**
 * i_cal_timezone_new_full: (skip)
 * @native: The native libical object.
 * @owner: The parent.
 * @is_global_memory: Whether it is allocated in the global memory.
 *
 * Create a new libical-glib object from the native libical object and the owner.
 *
 * Returns: (transfer full): The newly create libical-glib object.
 *
 * Since: 1.0
 **/
ICalTimezone *
i_cal_timezone_new_full (icaltimezone *native, 
                         GObject *owner, 
                         gboolean is_global_memory)
{
    ICalTimezone *object;
    if (native == NULL)
        return NULL;
    
    
    object = i_cal_object_construct (I_CAL_TYPE_TIMEZONE,
                            (gpointer) native,
                            (GDestroyNotify) i_cal_timezone_destroy,
                            is_global_memory,
                            owner);

    return object;
}


/**
 * i_cal_timezone_new:
 *
 * The constructor of the type #ICalTimezone.
 *
 * Returns: (transfer full) (nullable): The newly created object of the type #ICalTimezone.
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_new (void)
{
	return i_cal_timezone_new_full (icaltimezone_new (), NULL, FALSE);
}

/**
 * i_cal_timezone_destroy: (skip)
 * @zone: The #ICalTimezone to be freed
 *
 * The destructor of the type #ICalTimezone to fully destroy the object by providing 1 as the second argument
 * of i_cal_time_zone_free. The method is used as a default destructor for introspection.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_destroy (icaltimezone *zone)
{
        icaltimezone_free (zone, 1);
}

/**
 * i_cal_timezone_copy:
 * @zone: The #ICalTimezone needs to be cloned
 *
 * The clone method for #ICalTimezone.
 *
 * Returns: (transfer full): The newly created #ICalTimezone with the same values as @zone
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_copy (const ICalTimezone *zone)
{
	g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return i_cal_timezone_new_full (icaltimezone_copy ((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))), NULL, FALSE);
}

/**
 * i_cal_timezone_free: (skip)
 * @zone: The #ICalTimezone to be freed
 * @free_struct: Whether to free it or reset it. 1 to free and 0 to reset
 *
 * The destructor of #ICalTimezone.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_free (ICalTimezone *zone, 
                     gint free_struct)
{
	g_return_if_fail (I_CAL_IS_TIMEZONE (zone));

	icaltimezone_free ((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone)), free_struct);
}

/**
 * i_cal_timezone_set_tzid_prefix:
 * @new_prefix: The #ICalTimezone to be set
 *
 * Sets the prefix to be used for tzid's generated from system tzdata. Must be globally unique (such as
 * a domain name owned by the developer of the calling application), and begin and end with forward slashes.
 * Do not change or de-allocate the string buffer after calling this.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_set_tzid_prefix (const gchar *new_prefix)
{
	g_return_if_fail (new_prefix != NULL);

	icaltimezone_set_tzid_prefix (new_prefix);
}

/**
 * i_cal_timezone_free_builtin_timezones:
 *
 * Frees any builtin timezone information.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_free_builtin_timezones (void)
{
	icaltimezone_free_builtin_timezones ();
}

/**
 * i_cal_timezone_get_builtin_timezone:
 * @location: (nullable): The location representing the timezone
 *
 * Returns a single builtin timezone, given its Olson city name.
 *
 * Returns: (transfer none) (nullable): The builtin #ICalTimezone with the name of @location
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_get_builtin_timezone (const gchar *location)
{
	return i_cal_timezone_new_full (icaltimezone_get_builtin_timezone (location), NULL, TRUE);
}

/**
 * i_cal_timezone_get_builtin_timezone_from_offset:
 * @offset: The offset used to get the #ICalTimezone
 * @tzname: (nullable): The reference #ICalTimezone name
 *
 * Returns a single builtin timezone, given its offset.
 *
 * Returns: (transfer none)
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_get_builtin_timezone_from_offset (gint offset, 
                                                 const gchar *tzname)
{
	return i_cal_timezone_new_full (icaltimezone_get_builtin_timezone_from_offset (offset, tzname), NULL, TRUE);
}

/**
 * i_cal_timezone_get_builtin_timezone_from_tzid:
 * @tzid: (nullable): The tzid name
 *
 * Returns a single builtin timezone, given its TZID.
 *
 * Returns: (transfer none)
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_get_builtin_timezone_from_tzid (const gchar *tzid)
{
	return i_cal_timezone_new_full (icaltimezone_get_builtin_timezone_from_tzid (tzid), NULL, TRUE);
}

/**
 * i_cal_timezone_get_builtin_timezones:
 *
 * Returns a list of builtin timezones.
 *
 * Returns: (transfer none): An #ICalArray of the builtin #ICalTimezone objects.
 *
 * Since: 1.0
 *
 **/
ICalArray *
i_cal_timezone_get_builtin_timezones (void)
{
	return i_cal_array_new_full (icaltimezone_get_builtin_timezones (), NULL, TRUE);
}

/**
 * i_cal_timezone_get_utc_timezone:
 *
 * Returns the UTC timezone.
 *
 * Returns: (transfer none): The utc #ICalTimezone
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_get_utc_timezone (void)
{
	return i_cal_timezone_new_full (icaltimezone_get_utc_timezone (), NULL, TRUE);
}

/**
 * i_cal_timezone_get_tzid:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Returns the TZID of a timezone, or %NULL, when none is set or when @zone is also %NULL.
 *
 * Returns: (nullable): The timezone id, or %NULL
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_get_tzid (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return icaltimezone_get_tzid (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_timezone_get_location:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Returns the city name of a timezone, or %NULL, when none is set or when @zone is also %NULL.
 *
 * Returns: (nullable): The location of the #ICalTimezone, or %NULL
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_get_location (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return icaltimezone_get_location (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_timezone_get_tznames:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Returns the TZNAME properties used in the latest STANDARD and DAYLIGHT components. If they are the same
 * it will return just one, e.g. "LMT". If they are different it will format them like "EST/EDT". Note that
 * this may also return NULL.
 *
 * Returns: (nullable): The timezone name
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_get_tznames (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return icaltimezone_get_tznames (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_timezone_get_latitude:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Returns the latitude of a builtin timezone.
 *
 * Returns: The latitude of the #ICalTimezone
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_timezone_get_latitude (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);

	return icaltimezone_get_latitude (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_timezone_get_longitude:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Returns the longitude of a builtin timezone.
 *
 * Returns: The longitude of the #ICalTimezone.
 *
 * Since: 1.0
 *
 **/
gdouble
i_cal_timezone_get_longitude (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);

	return icaltimezone_get_longitude (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_timezone_get_component:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Returns the VTIMEZONE component of a timezone.
 *
 * Returns: (transfer full): The VTIMEZONE component of the @zone.
 *
 * Since: 1.0
 *
 **/
ICalComponent *
i_cal_timezone_get_component (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return i_cal_component_new_full (icaltimezone_get_component (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL)), (GObject *)zone);
}

/**
 * i_cal_timezone_set_component:
 * @zone: The #ICalTimezone to be set
 * @comp: The VTIMEZONE component of an #ICalTimezone, initializing the tzid, location and tzname fields
 *
 * Sets the VTIMEZONE component of #ICalTimezone, initializing the tzid, location and tzname fields. It
 * returns 1 on success or 0 on failure, i.e. no TZID was found.
 *
 * @note The @zone assumes ownership
 * of the @comp, thus make sure you pass an unowned #ICalComponent.
 *
 * Returns: Whether the action is successful. 1 for success, 0 for failure.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_set_component (ICalTimezone *zone, 
                              ICalComponent *comp)
{
    g_return_val_if_fail(I_CAL_IS_TIMEZONE(zone), 0);
    g_return_val_if_fail(I_CAL_IS_COMPONENT(comp), 0);

    i_cal_object_set_owner(I_CAL_OBJECT(comp), G_OBJECT(zone));

    return icaltimezone_set_component ((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone)), (icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)));
}

/**
 * i_cal_timezone_get_display_name:
 * @zone: (nullable): The #ICalTimezone to be queried
 *
 * Gets the display name of the @zone.
 *
 * Returns: The display name of @zone
 *
 * Since: 1.0
 *
 **/
const gchar *
i_cal_timezone_get_display_name (const ICalTimezone *zone)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), NULL);

	return icaltimezone_get_display_name (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL));
}

/**
 * i_cal_time_convert_timezone:
 * @tt: The time to be converted
 * @from_zone: (nullable): From timezone
 * @to_zone: (nullable): To timezone
 *
 * Convert time from one timezone to another.
 *
 * Since: 1.0
 *
 **/
void
i_cal_time_convert_timezone (ICalTime *tt, 
                             ICalTimezone *from_zone, 
                             ICalTimezone *to_zone)
{
	g_return_if_fail (I_CAL_IS_TIME (tt));
	if(from_zone)
		g_return_if_fail (I_CAL_IS_TIMEZONE (from_zone));
	if(to_zone)
		g_return_if_fail (I_CAL_IS_TIMEZONE (to_zone));

	icaltimezone_convert_time ((struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), ((from_zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (from_zone))):NULL), ((to_zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (to_zone))):NULL));
}

/**
 * i_cal_timezone_get_utc_offset:
 * @zone: (nullable): The given #ICalTimezone
 * @tt: (nullable): The local time
 * @is_daylight: (out) (optional): Whether it is day light
 *
 * Calculates the UTC offset of a given local time in the given timezone.  It is the number of seconds to
 * add to UTC to get local time.  The is_daylight flag is set to 1 if the time is in daylight-savings time.
 *
 * Returns: UTC offset of the @zone
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_get_utc_offset (ICalTimezone *zone, 
                               ICalTime *tt, 
                               gint *is_daylight)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);
	if(tt)
		g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltimezone_get_utc_offset (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL), ((tt)?((struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt))):NULL), is_daylight);
}

/**
 * i_cal_timezone_get_utc_offset_of_utc_time:
 * @zone: (nullable): The given #ICalTimezone
 * @tt: The local time
 * @is_daylight: (out) (optional): Whether it is day light, can be %NULL
 *
 * Calculates the UTC offset of a given UTC time in the given timezone.  It is the number of seconds to
 * add to UTC to get local time.  The is_daylight flag is set to 1 if the time is in daylight-savings time.
 *
 * Returns: UTC offset of the @zone
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_get_utc_offset_of_utc_time (ICalTimezone *zone, 
                                           ICalTime *tt, 
                                           gint *is_daylight)
{
	if(zone)
		g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);
	g_return_val_if_fail (I_CAL_IS_TIME (tt), 0);

	return icaltimezone_get_utc_offset_of_utc_time (((zone)?((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone))):NULL), (struct icaltimetype *)i_cal_object_get_native (I_CAL_OBJECT (tt)), is_daylight);
}

/**
 * i_cal_timezone_array_new:
 *
 * Creates a new array of timezones.
 *
 * Returns: (transfer full): Create a new array.
 *
 * Since: 1.0
 *
 **/
ICalArray *
i_cal_timezone_array_new (void)
{
    ICalArray *zones_array;

    zones_array = i_cal_array_new_full(icaltimezone_array_new (), NULL, FALSE);
    i_cal_object_set_native_destroy_func(I_CAL_OBJECT (zones_array), (GDestroyNotify) i_cal_timezone_array_destroy);
    return zones_array;
}

/**
 * i_cal_timezone_array_destroy: (skip)
 * @zones_array: (nullable): The icalarray created by i_cal_timezone_array_new() to be freed
 *
 * The destructor of the icalarray of icaltimezone elements to fully destroy the native object.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_array_destroy (icalarray *zones_array)
{
        icaltimezone_array_free (zones_array);
}

/**
 * i_cal_timezone_array_append_from_vtimezone:
 * @timezones: The timezones to be populated
 * @child: The component to be appended to @timezones
 *
 * Populate the array of timezones with a component.
 *
 * @note The @timezones assumes ownership of the
 * @child, thus make sure you pass an unowned #ICalComponent.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_array_append_from_vtimezone (ICalArray *timezones, 
                                            ICalComponent *child)
{
    g_return_if_fail(I_CAL_IS_ARRAY(timezones));
    g_return_if_fail(I_CAL_IS_COMPONENT(child));

    i_cal_object_set_owner(I_CAL_OBJECT(child), G_OBJECT(timezones));

    icaltimezone_array_append_from_vtimezone ((icalarray *)i_cal_object_get_native (I_CAL_OBJECT (timezones)), (icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (child)));
}

/**
 * i_cal_timezone_array_free: (skip)
 * @timezones: Free an array
 *
 * Frees an array of timezones.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_array_free (ICalArray *timezones)
{
	g_return_if_fail (I_CAL_IS_ARRAY (timezones));

	icaltimezone_array_free ((icalarray *)i_cal_object_steal_native (I_CAL_OBJECT (timezones)));
}

/**
 * i_cal_time_timezone_expand_vtimezone:
 * @comp: The #ICalComponent
 * @end_year: The end year
 * @changes: The changes to be applies
 *
 * Applies a list of timezone changes on the array of components until the end year.
 *
 * Since: 2.0
 *
 **/
void
i_cal_time_timezone_expand_vtimezone (ICalComponent *comp, 
                                      gint end_year, 
                                      ICalArray *changes)
{
	g_return_if_fail (I_CAL_IS_COMPONENT (comp));
	g_return_if_fail (I_CAL_IS_ARRAY (changes));

	icaltimezone_expand_vtimezone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (comp)), end_year, (icalarray *)i_cal_object_get_native (I_CAL_OBJECT (changes)));
}

/**
 * i_cal_timezone_get_location_from_vtimezone:
 * @component: The #ICalComponent to be queried
 *
 * Gets the location of the vtimezone in component.
 *
 * Returns: The location of vtimezone.
 *
 * Since: 2.0
 *
 **/
gchar *
i_cal_timezone_get_location_from_vtimezone (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return icaltimezone_get_location_from_vtimezone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_timezone_get_tznames_from_vtimezone:
 * @component: The #ICalComponent to be queried
 *
 * Gets the name of the vtimezone in component.
 *
 * Returns: The name of vtimezone.
 *
 * Since: 2.0
 *
 **/
gchar *
i_cal_timezone_get_tznames_from_vtimezone (ICalComponent *component)
{
	g_return_val_if_fail (I_CAL_IS_COMPONENT (component), NULL);

	return icaltimezone_get_tznames_from_vtimezone ((icalcomponent *)i_cal_object_get_native (I_CAL_OBJECT (component)));
}

/**
 * i_cal_timezone_get_zone_directory:
 *
 * Gets the directory to look for the zonefiles.
 *
 * Returns: The path to look for the zonefiles
 *
 * Since: 3.0.17
 *
 **/
const gchar *
i_cal_timezone_get_zone_directory (void)
{
	return get_zone_directory ();
}

/**
 * i_cal_timezone_set_zone_directory:
 * @path: The path to look for the zonefiles
 *
 * Sets the directory to look for the zonefiles.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_set_zone_directory (const gchar *path)
{
	g_return_if_fail (path != NULL);

	set_zone_directory (path);
}

/**
 * i_cal_timezone_free_zone_directory:
 *
 * Frees memory dedicated to the zonefile directory.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_free_zone_directory (void)
{
	free_zone_directory ();
}

/**
 * i_cal_timezone_release_zone_tab:
 *
 * Frees memory dedicated to the zonefile directory.
 *
 * Since: 1.0
 *
 **/
void
i_cal_timezone_release_zone_tab (void)
{
	icaltimezone_release_zone_tab ();
}

/**
 * i_cal_timezone_set_builtin_tzdata:
 * @set: Whether to use builtin timezones files
 *
 * Sets whether to use builtin timezones files.
 *
 * Since: 2.0
 *
 **/
void
i_cal_timezone_set_builtin_tzdata (gboolean set)
{
	icaltimezone_set_builtin_tzdata (set);
}

/**
 * i_cal_timezone_get_builtin_tzdata:
 *
 * Gets whether to use builtin timezones files.
 *
 * Returns: Whether to use builtin timezones files.
 *
 * Since: 2.0
 *
 **/
gboolean
i_cal_timezone_get_builtin_tzdata (void)
{
	return icaltimezone_get_builtin_tzdata ();
}

/**
 * i_cal_timezone_dump_changes:
 * @zone: The timezone to be queried
 * @max_year: Max year
 * @fp: The file handle
 *
 * Outputs a list of timezone changes for the given timezone to the given file, up to the maximum year given.
 *
 * Returns: 1 if success.
 *
 * Since: 1.0
 *
 **/
gint
i_cal_timezone_dump_changes (ICalTimezone *zone, 
                             gint max_year, 
                             FILE *fp)
{
	g_return_val_if_fail (I_CAL_IS_TIMEZONE (zone), 0);
	g_return_val_if_fail (fp != NULL, 0);

	return icaltimezone_dump_changes ((icaltimezone *)i_cal_object_get_native (I_CAL_OBJECT (zone)), max_year, fp);
}

/**
 * i_cal_timezone_array_element_at:
 * @timezones: The array to be visited
 * @index: The index
 *
 * Gets the #ICalTimezone at specified position in array.
 *
 * Returns: (transfer full): The #ICalTimezone at the position @index in @timezones.
 *
 * Since: 1.0
 *
 **/
ICalTimezone *
i_cal_timezone_array_element_at (ICalArray *timezones, 
                                 guint index)
{
        return i_cal_timezone_new_full ((gpointer)i_cal_array_element_at (timezones, index), (GObject *)timezones, FALSE);
}
