#ifndef INCLUDED_OFFICECFG_SYSTEM_HXX
#define INCLUDED_OFFICECFG_SYSTEM_HXX

#include "sal/config.h"

#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace System {

struct L10N: public comphelper::ConfigurationGroup< L10N> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.System/L10N"_ustr); return PATH; }

struct Locale: public comphelper::ConfigurationProperty<Locale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.System/L10N/Locale"_ustr); return PATH; }
private:
    Locale(); // not defined
    ~Locale(); // not defined
};

struct UILocale: public comphelper::ConfigurationProperty<UILocale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.System/L10N/UILocale"_ustr); return PATH; }
private:
    UILocale(); // not defined
    ~UILocale(); // not defined
};

struct SystemLocale: public comphelper::ConfigurationProperty<SystemLocale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.System/L10N/SystemLocale"_ustr); return PATH; }
private:
    SystemLocale(); // not defined
    ~SystemLocale(); // not defined
};

private:
    L10N(); // not defined
    ~L10N(); // not defined
};

} }

#endif
