// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolScopeMetrics = sync.Pool{
		New: func() any {
			return &otlpmetrics.ScopeMetrics{}
		},
	}
)

func NewOrigScopeMetrics() *otlpmetrics.ScopeMetrics {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.ScopeMetrics{}
	}
	return protoPoolScopeMetrics.Get().(*otlpmetrics.ScopeMetrics)
}

func DeleteOrigScopeMetrics(orig *otlpmetrics.ScopeMetrics, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteOrigInstrumentationScope(&orig.Scope, false)
	for i := range orig.Metrics {
		DeleteOrigMetric(orig.Metrics[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolScopeMetrics.Put(orig)
	}
}

func CopyOrigScopeMetrics(dest, src *otlpmetrics.ScopeMetrics) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	CopyOrigInstrumentationScope(&dest.Scope, &src.Scope)
	dest.Metrics = CopyOrigMetricSlice(dest.Metrics, src.Metrics)
	dest.SchemaUrl = src.SchemaUrl
}

func GenTestOrigScopeMetrics() *otlpmetrics.ScopeMetrics {
	orig := NewOrigScopeMetrics()
	orig.Scope = *GenTestOrigInstrumentationScope()
	orig.Metrics = GenerateOrigTestMetricSlice()
	orig.SchemaUrl = "test_schemaurl"
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigScopeMetrics(orig *otlpmetrics.ScopeMetrics, dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("scope")
	MarshalJSONOrigInstrumentationScope(&orig.Scope, dest)
	if len(orig.Metrics) > 0 {
		dest.WriteObjectField("metrics")
		dest.WriteArrayStart()
		MarshalJSONOrigMetric(orig.Metrics[0], dest)
		for i := 1; i < len(orig.Metrics); i++ {
			dest.WriteMore()
			MarshalJSONOrigMetric(orig.Metrics[i], dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigScopeMetrics unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigScopeMetrics(orig *otlpmetrics.ScopeMetrics, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "scope":
			UnmarshalJSONOrigInstrumentationScope(&orig.Scope, iter)
		case "metrics":
			for iter.ReadArray() {
				orig.Metrics = append(orig.Metrics, NewOrigMetric())
				UnmarshalJSONOrigMetric(orig.Metrics[len(orig.Metrics)-1], iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigScopeMetrics(orig *otlpmetrics.ScopeMetrics) int {
	var n int
	var l int
	_ = l
	l = SizeProtoOrigInstrumentationScope(&orig.Scope)
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Metrics {
		l = SizeProtoOrigMetric(orig.Metrics[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigScopeMetrics(orig *otlpmetrics.ScopeMetrics, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l

	l = MarshalProtoOrigInstrumentationScope(&orig.Scope, buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.Metrics) - 1; i >= 0; i-- {
		l = MarshalProtoOrigMetric(orig.Metrics[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigScopeMetrics(orig *otlpmetrics.ScopeMetrics, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = UnmarshalProtoOrigInstrumentationScope(&orig.Scope, buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Metrics = append(orig.Metrics, NewOrigMetric())
			err = UnmarshalProtoOrigMetric(orig.Metrics[len(orig.Metrics)-1], buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
