// IWYU pragma: private, include "nvim/charset.h"
#define DEFINE_FUNC_ATTRIBUTES
#include "nvim/func_attr.h"
#undef DEFINE_FUNC_ATTRIBUTES
#ifndef DLLEXPORT
#  ifdef MSWIN
#    define DLLEXPORT __declspec(dllexport)
#  else
#    define DLLEXPORT
#  endif
#endif
DLLEXPORT int init_chartab(void);
DLLEXPORT int buf_init_chartab(buf_T *buf, bool global);
DLLEXPORT int check_isopt(char *var);
DLLEXPORT void trans_characters(char *buf, int bufsize);
DLLEXPORT size_t transstr_len(const char *const s, bool untab) FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_PURE;
DLLEXPORT size_t transstr_buf(const char *const s, const ssize_t slen, char *const buf, const size_t buflen, bool untab) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT char *transstr(const char *const s, bool untab) FUNC_ATTR_NONNULL_RET;
DLLEXPORT size_t kv_transstr(StringBuilder *str, const char *const s, bool untab) FUNC_ATTR_NONNULL_ARG(1);
DLLEXPORT char *str_foldcase(char *str, int orglen, char *buf, int buflen) FUNC_ATTR_NONNULL_RET;
DLLEXPORT char *transchar(int c);
DLLEXPORT char *transchar_buf(const buf_T *buf, int c);
DLLEXPORT char *transchar_byte(const int c) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT char *transchar_byte_buf(const buf_T *buf, const int c) FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT void transchar_nonprint(const buf_T *buf, char *charbuf, int c);
DLLEXPORT size_t transchar_hex(char *const buf, const int c) FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void rl_mirror_ascii(char *str, char *end);
DLLEXPORT int byte2cells(int b) FUNC_ATTR_PURE;
DLLEXPORT int char2cells(int c);
DLLEXPORT int ptr2cells(const char *p_in);
DLLEXPORT int vim_strsize(const char *s);
DLLEXPORT int vim_strnsize(const char *s, int len);
DLLEXPORT bool vim_isIDc(int c) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool vim_iswordc(const int c) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool vim_iswordc_tab(const int c, const uint64_t *const chartab) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool vim_iswordc_buf(const int c, buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ARG(2);
DLLEXPORT bool vim_iswordp(const char *const p) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool vim_iswordp_buf(const char *const p, buf_T *const buf) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT bool vim_isfilec(int c) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool vim_is_fname_char(int c) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool vim_isfilec_or_wc(int c) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT bool vim_isprintc(int c) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT;
DLLEXPORT char *skipwhite(const char *p) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT char *skipwhite_len(const char *p, size_t len) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT intptr_t getwhitecols_curline(void);
DLLEXPORT intptr_t getwhitecols(const char *p) FUNC_ATTR_PURE;
DLLEXPORT char *skipdigits(const char *q) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT const char *skipbin(const char *q) FUNC_ATTR_PURE FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT char *skiphex(char *q) FUNC_ATTR_PURE;
DLLEXPORT char *skiptodigit(char *q) FUNC_ATTR_PURE;
DLLEXPORT const char *skiptobin(const char *q) FUNC_ATTR_PURE FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT char *skiptohex(char *q) FUNC_ATTR_PURE;
DLLEXPORT char *skiptowhite(const char *p) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_PURE;
DLLEXPORT char *skiptowhite_esc(const char *p) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_PURE;
DLLEXPORT char *skip_to_newline(const char *const p) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
DLLEXPORT bool try_getdigits(char **pp, intmax_t *nr);
DLLEXPORT intmax_t getdigits(char **pp, bool strict, intmax_t def);
DLLEXPORT int getdigits_int(char **pp, bool strict, int def);
DLLEXPORT long getdigits_long(char **pp, bool strict, long def);
DLLEXPORT int32_t getdigits_int32(char **pp, bool strict, int32_t def);
DLLEXPORT bool vim_isblankline(char *lbuf) FUNC_ATTR_PURE;
DLLEXPORT void vim_str2nr(const char *const start, int *const prep, int *const len, const int what, varnumber_T *const nptr, uvarnumber_T *const unptr, const int maxlen, const bool strict, bool *const overflow) FUNC_ATTR_NONNULL_ARG(1);
DLLEXPORT int hex2nr(int c) FUNC_ATTR_CONST;
DLLEXPORT int hexhex2nr(const char *p) FUNC_ATTR_PURE;
DLLEXPORT bool rem_backslash(const char *str) FUNC_ATTR_PURE FUNC_ATTR_WARN_UNUSED_RESULT FUNC_ATTR_NONNULL_ALL;
DLLEXPORT void backslash_halve(char *p);
DLLEXPORT char *backslash_halve_save(const char *p) FUNC_ATTR_NONNULL_ALL FUNC_ATTR_NONNULL_RET;
#include "nvim/func_attr.h"
