/* GridDay.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GridDay.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2011-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "elementary-calendar.h"
#include <libecal/libecal.h>
#include <libical-glib/libical-glib.h>
#include <libedataserver/libedataserver.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_GRID_DAY (maya_view_grid_day_get_type ())
#define MAYA_VIEW_GRID_DAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDay))
#define MAYA_VIEW_GRID_DAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDayClass))
#define MAYA_VIEW_IS_GRID_DAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_GRID_DAY))
#define MAYA_VIEW_IS_GRID_DAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_GRID_DAY))
#define MAYA_VIEW_GRID_DAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDayClass))

typedef struct _MayaViewGridDay MayaViewGridDay;
typedef struct _MayaViewGridDayClass MayaViewGridDayClass;
typedef struct _MayaViewGridDayPrivate MayaViewGridDayPrivate;

#define MAYA_VIEW_TYPE_VAUTO_HIDER (maya_view_vauto_hider_get_type ())
#define MAYA_VIEW_VAUTO_HIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_VAUTO_HIDER, MayaViewVAutoHider))
#define MAYA_VIEW_VAUTO_HIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_VAUTO_HIDER, MayaViewVAutoHiderClass))
#define MAYA_VIEW_IS_VAUTO_HIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_VAUTO_HIDER))
#define MAYA_VIEW_IS_VAUTO_HIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_VAUTO_HIDER))
#define MAYA_VIEW_VAUTO_HIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_VAUTO_HIDER, MayaViewVAutoHiderClass))

typedef struct _MayaViewVAutoHider MayaViewVAutoHider;
typedef struct _MayaViewVAutoHiderClass MayaViewVAutoHiderClass;

#define MAYA_VIEW_TYPE_EVENT_BUTTON (maya_view_event_button_get_type ())
#define MAYA_VIEW_EVENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton))
#define MAYA_VIEW_EVENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButtonClass))
#define MAYA_VIEW_IS_EVENT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON))
#define MAYA_VIEW_IS_EVENT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_BUTTON))
#define MAYA_VIEW_EVENT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButtonClass))

typedef struct _MayaViewEventButton MayaViewEventButton;
typedef struct _MayaViewEventButtonClass MayaViewEventButtonClass;
enum  {
	MAYA_VIEW_GRID_DAY_0_PROPERTY,
	MAYA_VIEW_GRID_DAY_DATE_PROPERTY,
	MAYA_VIEW_GRID_DAY_IN_CURRENT_MONTH_PROPERTY,
	MAYA_VIEW_GRID_DAY_NUM_PROPERTIES
};
static GParamSpec* maya_view_grid_day_properties[MAYA_VIEW_GRID_DAY_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))
enum  {
	MAYA_VIEW_GRID_DAY_ON_EVENT_ADD_SIGNAL,
	MAYA_VIEW_GRID_DAY_NUM_SIGNALS
};
static guint maya_view_grid_day_signals[MAYA_VIEW_GRID_DAY_NUM_SIGNALS] = {0};

struct _MayaViewGridDay {
	GtkEventBox parent_instance;
	MayaViewGridDayPrivate * priv;
	gboolean draw_left_border;
};

struct _MayaViewGridDayClass {
	GtkEventBoxClass parent_class;
};

struct _MayaViewGridDayPrivate {
	GDateTime* _date;
	MayaViewVAutoHider* event_box;
	GHashTable* event_buttons;
	GRecMutex __lock_event_buttons;
	GtkEventControllerKey* key_controller;
	GtkGestureMultiPress* click_gesture;
};

static gint MayaViewGridDay_private_offset;
static gpointer maya_view_grid_day_parent_class = NULL;

VALA_EXTERN GType maya_view_grid_day_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewGridDay, g_object_unref)
VALA_EXTERN GType maya_view_vauto_hider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewVAutoHider, g_object_unref)
VALA_EXTERN GType maya_view_event_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventButton, g_object_unref)
VALA_EXTERN MayaViewGridDay* maya_view_grid_day_new (GDateTime* date);
VALA_EXTERN MayaViewGridDay* maya_view_grid_day_construct (GType object_type,
                                               GDateTime* date);
static gboolean maya_view_grid_day_real_drag_drop (GtkWidget* base,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            guint time_);
static void maya_view_grid_day_real_drag_data_received (GtkWidget* base,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_);
VALA_EXTERN GDateTime* maya_view_grid_day_get_date (MayaViewGridDay* self);
VALA_EXTERN void maya_view_grid_day_add_event_button (MayaViewGridDay* self,
                                          MayaViewEventButton* button);
VALA_EXTERN gchar* maya_view_event_button_get_uid (MayaViewEventButton* self);
VALA_EXTERN gboolean maya_view_grid_day_update_event (MayaViewGridDay* self,
                                          ECalComponent* modified_event);
static void _vala_ECalComponentId_free (ECalComponentId* self);
VALA_EXTERN void maya_view_event_button_update (MayaViewEventButton* self,
                                    ECalComponent* modified);
VALA_EXTERN void maya_view_vauto_hider_update (MayaViewVAutoHider* self,
                                   GtkWidget* widget);
VALA_EXTERN void maya_view_grid_day_remove_event (MayaViewGridDay* self,
                                      ECalComponent* comp);
VALA_EXTERN void maya_view_grid_day_clear_events (MayaViewGridDay* self);
VALA_EXTERN void maya_view_grid_day_set_selected (MayaViewGridDay* self,
                                      gboolean selected);
static void maya_view_grid_day_on_button_press (MayaViewGridDay* self,
                                         gint n_press,
                                         gdouble x,
                                         gdouble y);
static gboolean maya_view_grid_day_on_key_press (MayaViewGridDay* self,
                                          GtkEventControllerKey* event,
                                          guint keyval,
                                          guint keycode,
                                          GdkModifierType state);
VALA_EXTERN void maya_view_grid_day_set_date (MayaViewGridDay* self,
                                  GDateTime* value);
VALA_EXTERN void maya_view_grid_day_set_in_current_month (MayaViewGridDay* self,
                                              gboolean value);
static GObject * maya_view_grid_day_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _maya_view_grid_day___lambda134_ (void* value_data);
VALA_EXTERN void maya_view_event_button_destroy_button (MayaViewEventButton* self);
static void __maya_view_grid_day___lambda134__gdestroy_notify (void* data);
VALA_EXTERN MayaViewVAutoHider* maya_view_vauto_hider_new (void);
VALA_EXTERN MayaViewVAutoHider* maya_view_vauto_hider_construct (GType object_type);
static void _maya_view_grid_day_on_button_press_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                           gint n_press,
                                                                           gdouble x,
                                                                           gdouble y,
                                                                           gpointer self);
static gboolean _maya_view_grid_day_on_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                guint keyval,
                                                                                guint keycode,
                                                                                GdkModifierType state,
                                                                                gpointer self);
static gboolean _maya_view_grid_day___lambda135_ (MayaViewGridDay* self,
                                           GdkEventScroll* event);
static gboolean __maya_view_grid_day___lambda135__gtk_widget_scroll_event (GtkWidget* _sender,
                                                                    GdkEventScroll* event,
                                                                    gpointer self);
static gboolean _maya_view_grid_day___lambda136_ (MayaViewGridDay* self,
                                           GBinding* binding,
                                           GValue* srcval,
                                           GValue* targetval);
static gboolean __maya_view_grid_day___lambda136__gbinding_transform_func (GBinding* binding,
                                                                    GValue* from_value,
                                                                    GValue* to_value,
                                                                    gpointer self);
static void maya_view_grid_day_finalize (GObject * obj);
static GType maya_view_grid_day_get_type_once (void);
static void _vala_maya_view_grid_day_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_maya_view_grid_day_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
maya_view_grid_day_get_instance_private (MayaViewGridDay* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewGridDay_private_offset);
}

MayaViewGridDay*
maya_view_grid_day_construct (GType object_type,
                              GDateTime* date)
{
	MayaViewGridDay * self = NULL;
	g_return_val_if_fail (date != NULL, NULL);
	self = (MayaViewGridDay*) g_object_new (object_type, "date", date, NULL);
	return self;
}

MayaViewGridDay*
maya_view_grid_day_new (GDateTime* date)
{
	return maya_view_grid_day_construct (MAYA_VIEW_TYPE_GRID_DAY, date);
}

static gboolean
maya_view_grid_day_real_drag_drop (GtkWidget* base,
                                   GdkDragContext* context,
                                   gint x,
                                   gint y,
                                   guint time_)
{
	MayaViewGridDay * self;
	GdkAtom atom = (GdkAtom) 0U;
	GtkTargetList* _tmp0_;
	gboolean result;
	self = (MayaViewGridDay*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	gtk_drag_finish (context, TRUE, FALSE, (guint32) time_);
	_tmp0_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
	atom = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp0_);
	gtk_drag_get_data ((GtkWidget*) self, context, atom, (guint32) time_);
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
maya_view_grid_day_real_drag_data_received (GtkWidget* base,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_)
{
	MayaViewGridDay * self;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp0_;
	ECalComponent* comp = NULL;
	CalendarEventStore* _tmp1_;
	ECalComponent* _tmp2_;
	ECalComponent* _tmp3_;
	ECalComponent* _tmp4_;
	ICalComponent* icalcomp = NULL;
	ECalComponent* _tmp5_;
	ICalComponent* _tmp6_;
	ESource* src = NULL;
	ECalComponent* _tmp7_;
	gconstpointer _tmp8_;
	ESource* _tmp9_;
	ICalTime* start = NULL;
	ICalComponent* _tmp10_;
	ICalTime* _tmp11_;
	ICalTime* end = NULL;
	ICalComponent* _tmp12_;
	ICalTime* _tmp13_;
	gint gap = 0;
	GDateTime* _tmp14_;
	ICalTime* _tmp15_;
	ICalTime* _tmp16_;
	ICalTime* _tmp17_;
	ICalTime* _tmp18_;
	ICalComponent* _tmp23_;
	ICalTime* _tmp24_;
	CalendarEventStore* _tmp25_;
	ESource* _tmp26_;
	ECalComponent* _tmp27_;
	self = (MayaViewGridDay*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	calmodel = _tmp0_;
	_tmp1_ = calmodel;
	_tmp2_ = calendar_event_store_get_drag_component (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	comp = _tmp4_;
	_tmp5_ = comp;
	_tmp6_ = e_cal_component_get_icalcomponent (_tmp5_);
	icalcomp = _tmp6_;
	_tmp7_ = comp;
	_tmp8_ = g_object_get_data ((GObject*) _tmp7_, "source");
	_tmp9_ = _g_object_ref0 ((ESource*) _tmp8_);
	src = _tmp9_;
	_tmp10_ = icalcomp;
	_tmp11_ = i_cal_component_get_dtstart (_tmp10_);
	start = _tmp11_;
	_tmp12_ = icalcomp;
	_tmp13_ = i_cal_component_get_dtend (_tmp12_);
	end = _tmp13_;
	_tmp14_ = self->priv->_date;
	_tmp15_ = start;
	gap = g_date_time_get_day_of_month (_tmp14_) - i_cal_time_get_day (_tmp15_);
	_tmp16_ = start;
	_tmp17_ = start;
	i_cal_time_set_day (_tmp16_, i_cal_time_get_day (_tmp17_) + gap);
	_tmp18_ = end;
	if (!i_cal_time_is_null_time (_tmp18_)) {
		ICalTime* _tmp19_;
		ICalTime* _tmp20_;
		ICalComponent* _tmp21_;
		ICalTime* _tmp22_;
		_tmp19_ = end;
		_tmp20_ = end;
		i_cal_time_set_day (_tmp19_, i_cal_time_get_day (_tmp20_) + gap);
		_tmp21_ = icalcomp;
		_tmp22_ = end;
		i_cal_component_set_dtend (_tmp21_, _tmp22_);
	}
	_tmp23_ = icalcomp;
	_tmp24_ = start;
	i_cal_component_set_dtstart (_tmp23_, _tmp24_);
	_tmp25_ = calmodel;
	_tmp26_ = src;
	_tmp27_ = comp;
	calendar_event_store_update_event (_tmp25_, _tmp26_, _tmp27_, E_CAL_OBJ_MOD_ALL);
	_g_object_unref0 (end);
	_g_object_unref0 (start);
	_g_object_unref0 (src);
	_g_object_unref0 (comp);
	_g_object_unref0 (calmodel);
}

void
maya_view_grid_day_add_event_button (MayaViewGridDay* self,
                                     MayaViewEventButton* button)
{
	gchar* uid = NULL;
	gchar* _tmp0_;
	GtkContainer* _tmp7_;
	MayaViewVAutoHider* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = maya_view_event_button_get_uid (button);
	uid = _tmp0_;
	{
		GHashTable* _tmp1_;
		_tmp1_ = self->priv->event_buttons;
		g_rec_mutex_lock (&self->priv->__lock_event_buttons);
		{
			GHashTable* _tmp2_;
			GHashTable* _tmp3_;
			gchar* _tmp4_;
			MayaViewEventButton* _tmp5_;
			_tmp2_ = self->priv->event_buttons;
			g_hash_table_remove (_tmp2_, uid);
			_tmp3_ = self->priv->event_buttons;
			_tmp4_ = g_strdup (uid);
			_tmp5_ = _g_object_ref0 (button);
			g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
		}
		__finally0:
		{
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->event_buttons;
			g_rec_mutex_unlock (&self->priv->__lock_event_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = gtk_widget_get_parent ((GtkWidget*) button);
	if (_tmp7_ != NULL) {
		gtk_widget_unparent ((GtkWidget*) button);
	}
	_tmp8_ = self->priv->event_box;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) button);
	gtk_widget_show_all ((GtkWidget*) button);
	_g_free0 (uid);
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

gboolean
maya_view_grid_day_update_event (MayaViewGridDay* self,
                                 ECalComponent* modified_event)
{
	gchar* uid = NULL;
	ECalComponentId* _tmp0_;
	ECalComponentId* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (modified_event != NULL, FALSE);
	_tmp0_ = e_cal_component_get_id (modified_event);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_id_get_uid (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	__vala_ECalComponentId_free0 (_tmp1_);
	uid = _tmp4_;
	{
		GHashTable* _tmp5_;
		_tmp5_ = self->priv->event_buttons;
		g_rec_mutex_lock (&self->priv->__lock_event_buttons);
		{
			MayaViewEventButton* uidbutton = NULL;
			GHashTable* _tmp6_;
			const gchar* _tmp7_;
			gconstpointer _tmp8_;
			MayaViewEventButton* _tmp9_;
			MayaViewEventButton* _tmp10_;
			_tmp6_ = self->priv->event_buttons;
			_tmp7_ = uid;
			_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
			_tmp9_ = _g_object_ref0 ((MayaViewEventButton*) _tmp8_);
			uidbutton = _tmp9_;
			_tmp10_ = uidbutton;
			if (_tmp10_ != NULL) {
				MayaViewEventButton* _tmp11_;
				MayaViewVAutoHider* _tmp12_;
				MayaViewEventButton* _tmp13_;
				_tmp11_ = uidbutton;
				maya_view_event_button_update (_tmp11_, modified_event);
				_tmp12_ = self->priv->event_box;
				_tmp13_ = uidbutton;
				maya_view_vauto_hider_update (_tmp12_, (GtkWidget*) _tmp13_);
				result = TRUE;
				_g_object_unref0 (uidbutton);
				{
					GHashTable* _tmp14_;
					_tmp14_ = self->priv->event_buttons;
					g_rec_mutex_unlock (&self->priv->__lock_event_buttons);
				}
				_g_free0 (uid);
				return result;
			}
			_g_object_unref0 (uidbutton);
		}
		__finally0:
		{
			GHashTable* _tmp15_;
			_tmp15_ = self->priv->event_buttons;
			g_rec_mutex_unlock (&self->priv->__lock_event_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			_g_free0 (uid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	result = FALSE;
	_g_free0 (uid);
	return result;
}

void
maya_view_grid_day_remove_event (MayaViewGridDay* self,
                                 ECalComponent* comp)
{
	gchar* uid = NULL;
	ECalComponentId* _tmp0_;
	ECalComponentId* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = e_cal_component_get_id (comp);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_id_get_uid (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	__vala_ECalComponentId_free0 (_tmp1_);
	uid = _tmp4_;
	{
		GHashTable* _tmp5_;
		_tmp5_ = self->priv->event_buttons;
		g_rec_mutex_lock (&self->priv->__lock_event_buttons);
		{
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->event_buttons;
			g_hash_table_remove (_tmp6_, uid);
		}
		__finally0:
		{
			GHashTable* _tmp7_;
			_tmp7_ = self->priv->event_buttons;
			g_rec_mutex_unlock (&self->priv->__lock_event_buttons);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uid);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (uid);
}

void
maya_view_grid_day_clear_events (MayaViewGridDay* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->event_buttons;
	g_hash_table_remove_all (_tmp0_);
}

void
maya_view_grid_day_set_selected (MayaViewGridDay* self,
                                 gboolean selected)
{
	g_return_if_fail (self != NULL);
	if (selected) {
		gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_SELECTED, TRUE);
	} else {
		gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_NORMAL, TRUE);
	}
}

static void
maya_view_grid_day_on_button_press (MayaViewGridDay* self,
                                    gint n_press,
                                    gdouble x,
                                    gdouble y)
{
	g_return_if_fail (self != NULL);
	if (n_press == 2) {
		GDateTime* _tmp0_;
		_tmp0_ = self->priv->_date;
		g_signal_emit (self, maya_view_grid_day_signals[MAYA_VIEW_GRID_DAY_ON_EVENT_ADD_SIGNAL], 0, _tmp0_);
	}
	gtk_widget_grab_focus ((GtkWidget*) self);
}

static gboolean
maya_view_grid_day_on_key_press (MayaViewGridDay* self,
                                 GtkEventControllerKey* event,
                                 guint keyval,
                                 guint keycode,
                                 GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (keyval == gdk_keyval_from_name ("Return")) {
		GDateTime* _tmp0_;
		_tmp0_ = self->priv->_date;
		g_signal_emit (self, maya_view_grid_day_signals[MAYA_VIEW_GRID_DAY_ON_EVENT_ADD_SIGNAL], 0, _tmp0_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

GDateTime*
maya_view_grid_day_get_date (MayaViewGridDay* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
maya_view_grid_day_set_date (MayaViewGridDay* self,
                             GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_grid_day_get_date (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_date);
		self->priv->_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_grid_day_properties[MAYA_VIEW_GRID_DAY_DATE_PROPERTY]);
	}
}

void
maya_view_grid_day_set_in_current_month (MayaViewGridDay* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp0_, GTK_STYLE_CLASS_DIM_LABEL);
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_DIM_LABEL);
	}
	g_object_notify_by_pspec ((GObject *) self, maya_view_grid_day_properties[MAYA_VIEW_GRID_DAY_IN_CURRENT_MONTH_PROPERTY]);
}

static void
_maya_view_grid_day___lambda134_ (void* value_data)
{
	maya_view_event_button_destroy_button (G_TYPE_CHECK_INSTANCE_CAST (value_data, MAYA_VIEW_TYPE_EVENT_BUTTON, MayaViewEventButton));
}

static void
__maya_view_grid_day___lambda134__gdestroy_notify (void* data)
{
	_maya_view_grid_day___lambda134_ (data);
}

static void
_maya_view_grid_day_on_button_press_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                      gint n_press,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self)
{
	maya_view_grid_day_on_button_press ((MayaViewGridDay*) self, n_press, x, y);
}

static gboolean
_maya_view_grid_day_on_key_press_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                       guint keyval,
                                                                       guint keycode,
                                                                       GdkModifierType state,
                                                                       gpointer self)
{
	gboolean result;
	result = maya_view_grid_day_on_key_press ((MayaViewGridDay*) self, _sender, keyval, keycode, state);
	return result;
}

static gboolean
_maya_view_grid_day___lambda135_ (MayaViewGridDay* self,
                                  GdkEventScroll* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	result = maya_gestures_utils_on_scroll_event (event);
	return result;
}

static gboolean
__maya_view_grid_day___lambda135__gtk_widget_scroll_event (GtkWidget* _sender,
                                                           GdkEventScroll* event,
                                                           gpointer self)
{
	gboolean result;
	result = _maya_view_grid_day___lambda135_ ((MayaViewGridDay*) self, event);
	return result;
}

static gboolean
_maya_view_grid_day___lambda136_ (MayaViewGridDay* self,
                                  GBinding* binding,
                                  GValue* srcval,
                                  GValue* targetval)
{
	GDateTime* date = NULL;
	void* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (srcval != NULL, FALSE);
	g_return_val_if_fail (targetval != NULL, FALSE);
	_tmp0_ = g_value_get_boxed (srcval);
	date = (GDateTime*) _tmp0_;
	_tmp1_ = date;
	_tmp2_ = g_strdup_printf ("%i", g_date_time_get_day_of_month (_tmp1_));
	g_value_take_string (targetval, _tmp2_);
	result = TRUE;
	return result;
}

static gboolean
__maya_view_grid_day___lambda136__gbinding_transform_func (GBinding* binding,
                                                           GValue* from_value,
                                                           GValue* to_value,
                                                           gpointer self)
{
	gboolean result;
	result = _maya_view_grid_day___lambda136_ ((MayaViewGridDay*) self, binding, from_value, to_value);
	return result;
}

static GObject *
maya_view_grid_day_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewGridDay * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	MayaViewVAutoHider* _tmp3_ = NULL;
	GtkLabel* label = NULL;
	gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkBox* container_box = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkBox* _tmp9_;
	MayaViewVAutoHider* _tmp10_;
	GtkBox* _tmp11_;
	GdkEventMask _tmp12_;
	GdkEventMask _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkGestureMultiPress* _tmp15_ = NULL;
	GtkGestureMultiPress* _tmp16_;
	GtkEventControllerKey* _tmp17_ = NULL;
	GtkEventControllerKey* _tmp18_;
	GtkTargetEntry dnd = {0};
	GtkTargetEntry _tmp19_ = {0};
	GtkTargetEntry _tmp20_;
	GtkTargetEntry* _tmp21_;
	GtkTargetEntry* _tmp22_;
	gint _tmp22__length1;
	GtkLabel* _tmp23_;
	parent_class = G_OBJECT_CLASS (maya_view_grid_day_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDay);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __maya_view_grid_day___lambda134__gdestroy_notify);
	_g_hash_table_unref0 (self->priv->event_buttons);
	self->priv->event_buttons = _tmp2_;
	_tmp3_ = maya_view_vauto_hider_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->event_box);
	self->priv->event_box = _tmp3_;
	_tmp4_ = g_strdup ("date");
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_END);
	gtk_widget_set_name ((GtkWidget*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	label = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	g_object_ref_sink (_tmp6_);
	container_box = _tmp6_;
	_tmp7_ = container_box;
	_tmp8_ = label;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = container_box;
	_tmp10_ = self->priv->event_box;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	_tmp11_ = container_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp11_, NULL);
	_tmp12_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp13_ = _tmp12_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp13_ | GDK_SMOOTH_SCROLL_MASK);
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp14_, "cell");
	_tmp15_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp15_, (guint) GDK_BUTTON_PRIMARY);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp15_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->click_gesture);
	self->priv->click_gesture = _tmp15_;
	_tmp16_ = self->priv->click_gesture;
	g_signal_connect_object (_tmp16_, "released", (GCallback) _maya_view_grid_day_on_button_press_gtk_gesture_multi_press_released, self, 0);
	_tmp17_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp17_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp17_;
	_tmp18_ = self->priv->key_controller;
	g_signal_connect_object (_tmp18_, "key-pressed", (GCallback) _maya_view_grid_day_on_key_press_gtk_event_controller_key_key_pressed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "scroll-event", (GCallback) __maya_view_grid_day___lambda135__gtk_widget_scroll_event, self, 0);
	_tmp19_.target = "binary/calendar";
	_tmp19_.flags = (guint) 0;
	_tmp19_.info = (guint) 0;
	dnd = _tmp19_;
	_tmp20_ = dnd;
	_tmp21_ = g_new0 (GtkTargetEntry, 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_MOTION, _tmp22_, (gint) 1, GDK_ACTION_MOVE);
	_tmp22_ = (g_free (_tmp22_), NULL);
	_tmp23_ = label;
	g_object_bind_property_with_closures ((GObject*) self, "date", (GObject*) _tmp23_, "label", G_BINDING_SYNC_CREATE, (GClosure*) ((__maya_view_grid_day___lambda136__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __maya_view_grid_day___lambda136__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (container_box);
	_g_object_unref0 (label);
	return obj;
}

static void
maya_view_grid_day_class_init (MayaViewGridDayClass * klass,
                               gpointer klass_data)
{
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* _tmp3_;
	maya_view_grid_day_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewGridDay_private_offset);
	((GtkWidgetClass *) klass)->drag_drop = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) maya_view_grid_day_real_drag_drop;
	((GtkWidgetClass *) klass)->drag_data_received = (void (*) (GtkWidget*, GdkDragContext*, gint, gint, GtkSelectionData*, guint, guint)) maya_view_grid_day_real_drag_data_received;
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_grid_day_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_grid_day_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_grid_day_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_grid_day_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_GRID_DAY_DATE_PROPERTY, maya_view_grid_day_properties[MAYA_VIEW_GRID_DAY_DATE_PROPERTY] = g_param_spec_boxed ("date", "date", "date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_GRID_DAY_IN_CURRENT_MONTH_PROPERTY, maya_view_grid_day_properties[MAYA_VIEW_GRID_DAY_IN_CURRENT_MONTH_PROPERTY] = g_param_spec_boolean ("in-current-month", "in-current-month", "in-current-month", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	maya_view_grid_day_signals[MAYA_VIEW_GRID_DAY_ON_EVENT_ADD_SIGNAL] = g_signal_new ("on-event-add", MAYA_VIEW_TYPE_GRID_DAY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	_tmp0_ = gtk_css_provider_new ();
	style_provider = _tmp0_;
	_tmp1_ = style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/Grid.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = style_provider;
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (style_provider);
}

static void
maya_view_grid_day_instance_init (MayaViewGridDay * self,
                                  gpointer klass)
{
	self->priv = maya_view_grid_day_get_instance_private (self);
	self->draw_left_border = TRUE;
	g_rec_mutex_init (&self->priv->__lock_event_buttons);
}

static void
maya_view_grid_day_finalize (GObject * obj)
{
	MayaViewGridDay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDay);
	_g_date_time_unref0 (self->priv->_date);
	_g_object_unref0 (self->priv->event_box);
	g_rec_mutex_clear (&self->priv->__lock_event_buttons);
	_g_hash_table_unref0 (self->priv->event_buttons);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->click_gesture);
	G_OBJECT_CLASS (maya_view_grid_day_parent_class)->finalize (obj);
}

/**
 * Represents a single day on the grid.
 */
static GType
maya_view_grid_day_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewGridDayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_grid_day_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewGridDay), 0, (GInstanceInitFunc) maya_view_grid_day_instance_init, NULL };
	GType maya_view_grid_day_type_id;
	maya_view_grid_day_type_id = g_type_register_static (gtk_event_box_get_type (), "MayaViewGridDay", &g_define_type_info, 0);
	MayaViewGridDay_private_offset = g_type_add_instance_private (maya_view_grid_day_type_id, sizeof (MayaViewGridDayPrivate));
	return maya_view_grid_day_type_id;
}

GType
maya_view_grid_day_get_type (void)
{
	static volatile gsize maya_view_grid_day_type_id__once = 0;
	if (g_once_init_enter (&maya_view_grid_day_type_id__once)) {
		GType maya_view_grid_day_type_id;
		maya_view_grid_day_type_id = maya_view_grid_day_get_type_once ();
		g_once_init_leave (&maya_view_grid_day_type_id__once, maya_view_grid_day_type_id);
	}
	return maya_view_grid_day_type_id__once;
}

static void
_vala_maya_view_grid_day_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	MayaViewGridDay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDay);
	switch (property_id) {
		case MAYA_VIEW_GRID_DAY_DATE_PROPERTY:
		g_value_set_boxed (value, maya_view_grid_day_get_date (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_grid_day_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	MayaViewGridDay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_GRID_DAY, MayaViewGridDay);
	switch (property_id) {
		case MAYA_VIEW_GRID_DAY_DATE_PROPERTY:
		maya_view_grid_day_set_date (self, g_value_get_boxed (value));
		break;
		case MAYA_VIEW_GRID_DAY_IN_CURRENT_MONTH_PROPERTY:
		maya_view_grid_day_set_in_current_month (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

