/* CustomComponents.c generated by valac 0.56.18, the Vala compiler
 * generated from CustomComponents.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE 13
#define RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH (RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE / 2)
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH (256 + (2 * RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH))
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET 1
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH (RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH + 2)
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT 118
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION (((((RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) - RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET) - ((RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) / 2)) - RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) - 2)
#define RGB_HISTOGRAM_GRAPHIC_WIDTH 256
#define RGB_HISTOGRAM_GRAPHIC_HEIGHT 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_RGB_HISTOGRAM (rgb_histogram_get_type ())
#define RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM, RGBHistogram))
#define RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM, RGBHistogramClass))
#define IS_RGB_HISTOGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM))
#define IS_RGB_HISTOGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM))
#define RGB_HISTOGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM, RGBHistogramClass))

typedef struct _RGBHistogram RGBHistogram;
typedef struct _RGBHistogramClass RGBHistogramClass;
enum  {
	RGB_HISTOGRAM_MANIPULATOR_0_PROPERTY,
	RGB_HISTOGRAM_MANIPULATOR_NUM_PROPERTIES
};
static GParamSpec* rgb_histogram_manipulator_properties[RGB_HISTOGRAM_MANIPULATOR_NUM_PROPERTIES];
typedef enum  {
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA
} RGBHistogramManipulatorLocationCode;

#define RGB_HISTOGRAM_MANIPULATOR_TYPE_LOCATION_CODE (rgb_histogram_manipulator_location_code_get_type ())
#define _rgb_histogram_unref0(var) ((var == NULL) ? NULL : (var = (rgb_histogram_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL,
	RGB_HISTOGRAM_MANIPULATOR_NUM_SIGNALS
};
static guint rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RGBHistogramManipulatorPrivate {
	gint left_nub_max;
	gint right_nub_min;
	RGBHistogram* histogram;
	gint left_nub_position;
	gint right_nub_position;
	gboolean is_left_nub_tracking;
	gboolean is_right_nub_tracking;
	gint track_start_x;
	gint track_nub_start_position;
	GdkPixbuf* drag_nub_pixbuf;
};

static gint RGBHistogramManipulator_private_offset;
static gpointer rgb_histogram_manipulator_parent_class = NULL;
static GtkWidget* rgb_histogram_manipulator_dummy_slider;
static GtkWidget* rgb_histogram_manipulator_dummy_slider = NULL;
static GtkWidget* rgb_histogram_manipulator_dummy_frame;
static GtkWidget* rgb_histogram_manipulator_dummy_frame = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path = NULL;
static gboolean rgb_histogram_manipulator_paths_setup;
static gboolean rgb_histogram_manipulator_paths_setup = FALSE;

VALA_EXTERN gpointer rgb_histogram_ref (gpointer instance);
VALA_EXTERN void rgb_histogram_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_rgb_histogram (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_rgb_histogram (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_rgb_histogram (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_rgb_histogram (const GValue* value);
VALA_EXTERN GType rgb_histogram_get_type (void) G_GNUC_CONST ;
static GType rgb_histogram_manipulator_location_code_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GdkPixbuf* rgb_histogram_manipulator_get_drag_nub_pixbuf (RGBHistogramManipulator* self);
static gboolean rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self,
                                                    GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self);
static gboolean rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self,
                                                      GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                       GdkEventButton* event,
                                                                                       gpointer self);
static gboolean rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self,
                                                     GdkEventMotion* event_record);
static gboolean _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                     GdkEventMotion* event,
                                                                                     gpointer self);
static RGBHistogramManipulatorLocationCode rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self,
                                                                              gint x,
                                                                              gint y);
static void rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self);
static void rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self);
static gboolean rgb_histogram_manipulator_real_draw (GtkWidget* base,
                                              cairo_t* ctx);
static void rgb_histogram_manipulator_draw_histogram_frame (RGBHistogramManipulator* self,
                                                     cairo_t* ctx,
                                                     GdkRectangle* area);
static void rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self,
                                               cairo_t* ctx,
                                               GdkRectangle* area);
static void rgb_histogram_manipulator_draw_trough (RGBHistogramManipulator* self,
                                            cairo_t* ctx,
                                            GdkRectangle* area);
static void rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self,
                                         cairo_t* ctx,
                                         GdkRectangle* area,
                                         gint position);
VALA_EXTERN GdkPixbuf* rgb_histogram_get_graphic (RGBHistogram* self);
VALA_EXTERN RGBHistogram* rgb_histogram_new (GdkPixbuf* pixbuf);
VALA_EXTERN RGBHistogram* rgb_histogram_construct (GType object_type,
                                       GdkPixbuf* pixbuf);
static void rgb_histogram_manipulator_finalize (GObject * obj);
static GType rgb_histogram_manipulator_get_type_once (void);

static inline gpointer
rgb_histogram_manipulator_get_instance_private (RGBHistogramManipulator* self)
{
	return G_STRUCT_MEMBER_P (self, RGBHistogramManipulator_private_offset);
}

static GType
rgb_histogram_manipulator_location_code_get_type_once (void)
{
	static const GEnumValue values[] = {{RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB", "left-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB", "right-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH", "left-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH", "right-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA", "insensitive-area"}, {0, NULL, NULL}};
	GType rgb_histogram_manipulator_location_code_type_id;
	rgb_histogram_manipulator_location_code_type_id = g_enum_register_static ("RGBHistogramManipulatorLocationCode", values);
	return rgb_histogram_manipulator_location_code_type_id;
}

static GType
rgb_histogram_manipulator_location_code_get_type (void)
{
	static volatile gsize rgb_histogram_manipulator_location_code_type_id__once = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_location_code_type_id__once)) {
		GType rgb_histogram_manipulator_location_code_type_id;
		rgb_histogram_manipulator_location_code_type_id = rgb_histogram_manipulator_location_code_get_type_once ();
		g_once_init_leave (&rgb_histogram_manipulator_location_code_type_id__once, rgb_histogram_manipulator_location_code_type_id);
	}
	return rgb_histogram_manipulator_location_code_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GdkPixbuf*
rgb_histogram_manipulator_get_drag_nub_pixbuf (RGBHistogramManipulator* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->drag_nub_pixbuf;
	if (_tmp0_ == NULL) {
		{
			GdkPixbuf* _tmp1_ = NULL;
			GdkPixbuf* _tmp2_;
			GdkPixbuf* _tmp3_;
			_tmp2_ = gdk_pixbuf_new_from_resource ("/io/elementary/photos/icons/drag-nub.svg", &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->drag_nub_pixbuf);
			self->priv->drag_nub_pixbuf = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = err->message;
			g_error ("CustomComponents.vala:59: Can't load drag nub image: %s", _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = self->priv->drag_nub_pixbuf;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static gboolean
_rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self)
{
	gboolean result;
	result = rgb_histogram_manipulator_on_button_press ((RGBHistogramManipulator*) self, event);
	return result;
}

static gboolean
_rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self)
{
	gboolean result;
	result = rgb_histogram_manipulator_on_button_release ((RGBHistogramManipulator*) self, event);
	return result;
}

static gboolean
_rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                            GdkEventMotion* event,
                                                                            gpointer self)
{
	gboolean result;
	result = rgb_histogram_manipulator_on_button_motion ((RGBHistogramManipulator*) self, event);
	return result;
}

RGBHistogramManipulator*
rgb_histogram_manipulator_construct (GType object_type)
{
	RGBHistogramManipulator * self = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp2_;
	self = (RGBHistogramManipulator*) g_object_new (object_type, NULL);
	gtk_widget_set_size_request ((GtkWidget*) self, RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH, RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT);
	_tmp0_ = rgb_histogram_manipulator_dummy_slider;
	if (_tmp0_ == NULL) {
		GtkScale* _tmp1_;
		_tmp1_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, NULL);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (rgb_histogram_manipulator_dummy_slider);
		rgb_histogram_manipulator_dummy_slider = (GtkWidget*) _tmp1_;
	}
	_tmp2_ = rgb_histogram_manipulator_dummy_frame;
	if (_tmp2_ == NULL) {
		GtkFrame* _tmp3_;
		_tmp3_ = (GtkFrame*) gtk_frame_new (NULL);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (rgb_histogram_manipulator_dummy_frame);
		rgb_histogram_manipulator_dummy_frame = (GtkWidget*) _tmp3_;
	}
	if (!rgb_histogram_manipulator_paths_setup) {
		GtkWidgetPath* _tmp4_;
		GtkWidgetPath* _tmp5_;
		GtkWidgetPath* _tmp6_;
		GtkWidgetPath* _tmp7_;
		GtkWidgetPath* _tmp8_;
		_tmp4_ = rgb_histogram_manipulator_slider_draw_path;
		gtk_widget_path_append_type (_tmp4_, gtk_scale_get_type ());
		_tmp5_ = rgb_histogram_manipulator_slider_draw_path;
		gtk_widget_path_iter_add_class (_tmp5_, 0, "scale");
		_tmp6_ = rgb_histogram_manipulator_slider_draw_path;
		gtk_widget_path_iter_add_class (_tmp6_, 0, "range");
		_tmp7_ = rgb_histogram_manipulator_frame_draw_path;
		gtk_widget_path_append_type (_tmp7_, gtk_frame_get_type ());
		_tmp8_ = rgb_histogram_manipulator_frame_draw_path;
		gtk_widget_path_iter_add_class (_tmp8_, 0, "default");
		rgb_histogram_manipulator_paths_setup = TRUE;
	}
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_RELEASE_MASK);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_MOTION_MASK);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event, self, 0);
	return self;
}

RGBHistogramManipulator*
rgb_histogram_manipulator_new (void)
{
	return rgb_histogram_manipulator_construct (TYPE_RGB_HISTOGRAM_MANIPULATOR);
}

static RGBHistogramManipulatorLocationCode
rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self,
                                          gint x,
                                          gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	RGBHistogramManipulatorLocationCode result;
	g_return_val_if_fail (self != NULL, 0);
	if (y < RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) {
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
		return result;
	}
	if (x > self->priv->left_nub_position) {
		_tmp0_ = x < (self->priv->left_nub_position + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB;
		return result;
	}
	if (x > self->priv->right_nub_position) {
		_tmp1_ = x < (self->priv->right_nub_position + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB;
		return result;
	}
	if (y < ((RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION + RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) + 1)) {
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
		return result;
	}
	if (((x - self->priv->left_nub_position) * (x - self->priv->left_nub_position)) < ((x - self->priv->right_nub_position) * (x - self->priv->right_nub_position))) {
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH;
		return result;
	} else {
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH;
		return result;
	}
}

static gboolean
rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self,
                                           GdkEventButton* event_record)
{
	RGBHistogramManipulatorLocationCode loc = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_record != NULL, FALSE);
	loc = rgb_histogram_manipulator_hit_test_point (self, (gint) event_record->x, (gint) event_record->y);
	switch (loc) {
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB:
		{
			self->priv->track_start_x = (gint) event_record->x;
			self->priv->track_nub_start_position = self->priv->left_nub_position;
			self->priv->is_left_nub_tracking = TRUE;
			result = TRUE;
			return result;
		}
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB:
		{
			self->priv->track_start_x = (gint) event_record->x;
			self->priv->track_nub_start_position = self->priv->right_nub_position;
			self->priv->is_right_nub_tracking = TRUE;
			result = TRUE;
			return result;
		}
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH:
		{
			self->priv->left_nub_position = ((gint) event_record->x) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
			self->priv->left_nub_position = CLAMP (self->priv->left_nub_position, 0, self->priv->left_nub_max);
			rgb_histogram_manipulator_force_update (self);
			g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
			rgb_histogram_manipulator_update_nub_extrema (self);
			result = TRUE;
			return result;
		}
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH:
		{
			self->priv->right_nub_position = ((gint) event_record->x) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
			self->priv->right_nub_position = CLAMP (self->priv->right_nub_position, self->priv->right_nub_min, 255);
			rgb_histogram_manipulator_force_update (self);
			g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
			rgb_histogram_manipulator_update_nub_extrema (self);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self,
                                             GdkEventButton* event_record)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_record != NULL, FALSE);
	if (self->priv->is_left_nub_tracking) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->is_right_nub_tracking;
	}
	if (_tmp0_) {
		g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
		rgb_histogram_manipulator_update_nub_extrema (self);
	}
	self->priv->is_left_nub_tracking = FALSE;
	self->priv->is_right_nub_tracking = FALSE;
	result = FALSE;
	return result;
}

static gboolean
rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self,
                                            GdkEventMotion* event_record)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_record != NULL, FALSE);
	if (!self->priv->is_left_nub_tracking) {
		_tmp0_ = !self->priv->is_right_nub_tracking;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->is_left_nub_tracking) {
		gint track_x_delta = 0;
		track_x_delta = ((gint) event_record->x) - self->priv->track_start_x;
		self->priv->left_nub_position = self->priv->track_nub_start_position + track_x_delta;
		self->priv->left_nub_position = CLAMP (self->priv->left_nub_position, 0, self->priv->left_nub_max);
	} else {
		gint track_x_delta = 0;
		track_x_delta = ((gint) event_record->x) - self->priv->track_start_x;
		self->priv->right_nub_position = self->priv->track_nub_start_position + track_x_delta;
		self->priv->right_nub_position = CLAMP (self->priv->right_nub_position, self->priv->right_nub_min, 255);
	}
	rgb_histogram_manipulator_force_update (self);
	result = TRUE;
	return result;
}

static gboolean
rgb_histogram_manipulator_real_draw (GtkWidget* base,
                                     cairo_t* ctx)
{
	RGBHistogramManipulator * self;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp0_;
	GtkBorder _tmp1_ = {0};
	GdkRectangle area = {0};
	GtkBorder _tmp2_;
	GtkBorder _tmp3_;
	GtkBorder _tmp4_;
	GtkBorder _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	gboolean result;
	self = (RGBHistogramManipulator*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_padding (_tmp0_, GTK_STATE_FLAG_NORMAL, &_tmp1_);
	padding = _tmp1_;
	memset (&area, 0, sizeof (GdkRectangle));
	_tmp2_ = padding;
	area.x = (gint) _tmp2_.left;
	_tmp3_ = padding;
	area.y = (gint) _tmp3_.top;
	_tmp4_ = padding;
	area.width = RGB_HISTOGRAM_GRAPHIC_WIDTH + _tmp4_.right;
	_tmp5_ = padding;
	area.height = RGB_HISTOGRAM_GRAPHIC_HEIGHT + _tmp5_.bottom;
	_tmp6_ = area;
	rgb_histogram_manipulator_draw_histogram_frame (self, ctx, &_tmp6_);
	_tmp7_ = area;
	rgb_histogram_manipulator_draw_histogram (self, ctx, &_tmp7_);
	_tmp8_ = area;
	rgb_histogram_manipulator_draw_trough (self, ctx, &_tmp8_);
	_tmp9_ = area;
	rgb_histogram_manipulator_draw_nub (self, ctx, &_tmp9_, self->priv->left_nub_position);
	_tmp10_ = area;
	rgb_histogram_manipulator_draw_nub (self, ctx, &_tmp10_, self->priv->right_nub_position);
	result = TRUE;
	return result;
}

static void
rgb_histogram_manipulator_draw_histogram_frame (RGBHistogramManipulator* self,
                                                cairo_t* ctx,
                                                GdkRectangle* area)
{
	GdkRectangle framed_area = {0};
	GdkRectangle _tmp0_;
	GtkStyleContext* stylectx = NULL;
	GtkWidget* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkWidgetPath* _tmp4_;
	GtkWidgetPath* _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	GdkRectangle _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = *area;
	framed_area = _tmp0_;
	framed_area.x = framed_area.x + 5;
	framed_area.y = framed_area.y + 1;
	framed_area.width = framed_area.width - 8;
	framed_area.height = framed_area.height - 12;
	_tmp1_ = rgb_histogram_manipulator_dummy_frame;
	_tmp2_ = gtk_widget_get_style_context (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	stylectx = _tmp3_;
	gtk_style_context_save (stylectx);
	_tmp4_ = gtk_style_context_get_path (stylectx);
	gtk_widget_path_append_type (_tmp4_, gtk_frame_get_type ());
	_tmp5_ = gtk_style_context_get_path (stylectx);
	gtk_widget_path_iter_add_class (_tmp5_, 0, "default");
	gtk_style_context_add_class (stylectx, GTK_STYLE_CLASS_TROUGH);
	gtk_style_context_set_junction_sides (stylectx, ((GTK_JUNCTION_TOP | GTK_JUNCTION_BOTTOM) | GTK_JUNCTION_LEFT) | GTK_JUNCTION_RIGHT);
	_tmp6_ = framed_area;
	_tmp7_ = framed_area;
	_tmp8_ = framed_area;
	_tmp9_ = framed_area;
	gtk_render_frame (stylectx, ctx, (gdouble) _tmp6_.x, (gdouble) _tmp7_.y, (gdouble) _tmp8_.width, (gdouble) _tmp9_.height);
	gtk_style_context_restore (stylectx);
	_g_object_unref0 (stylectx);
}

static void
rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self,
                                          cairo_t* ctx,
                                          GdkRectangle* area)
{
	RGBHistogram* _tmp0_;
	GdkPixbuf* histogram_graphic = NULL;
	RGBHistogram* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	guchar* pixel_data = NULL;
	GdkPixbuf* _tmp6_;
	guint8* _tmp7_;
	gint pixel_data_length1;
	gint _pixel_data_size_;
	gint edge_blend_red = 0;
	gint edge_blend_green = 0;
	gint edge_blend_blue = 0;
	gint body_blend_red = 0;
	gint body_blend_green = 0;
	gint body_blend_blue = 0;
	GdkPixbuf* _tmp90_;
	GdkRectangle _tmp91_;
	GdkRectangle _tmp92_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = self->priv->histogram;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->histogram;
	_tmp2_ = rgb_histogram_get_graphic (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	histogram_graphic = _tmp5_;
	_tmp6_ = histogram_graphic;
	_tmp7_ = gdk_pixbuf_get_pixels (_tmp6_);
	pixel_data = _tmp7_;
	pixel_data_length1 = -1;
	_pixel_data_size_ = pixel_data_length1;
	edge_blend_red = 0;
	edge_blend_green = 0;
	edge_blend_blue = 0;
	body_blend_red = 20;
	body_blend_green = 20;
	body_blend_blue = 20;
	if (self->priv->left_nub_position > 0) {
		gint edge_pixel_index = 0;
		GdkPixbuf* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = histogram_graphic;
		_tmp9_ = gdk_pixbuf_get_n_channels (_tmp8_);
		_tmp10_ = _tmp9_;
		edge_pixel_index = _tmp10_ * self->priv->left_nub_position;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					GdkPixbuf* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gint body_pixel_index = 0;
					GdkPixbuf* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gint row_last_pixel = 0;
					GdkPixbuf* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					guchar* _tmp34_;
					gint _tmp34__length1;
					guchar* _tmp35_;
					gint _tmp35__length1;
					guchar _tmp36_;
					guchar* _tmp37_;
					gint _tmp37__length1;
					guchar* _tmp38_;
					gint _tmp38__length1;
					guchar _tmp39_;
					guchar* _tmp40_;
					gint _tmp40__length1;
					guchar* _tmp41_;
					gint _tmp41__length1;
					guchar _tmp42_;
					GdkPixbuf* _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = histogram_graphic;
					_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
					_tmp15_ = _tmp14_;
					if (!(i < _tmp15_)) {
						break;
					}
					_tmp16_ = histogram_graphic;
					_tmp17_ = gdk_pixbuf_get_rowstride (_tmp16_);
					_tmp18_ = _tmp17_;
					body_pixel_index = i * _tmp18_;
					_tmp19_ = histogram_graphic;
					_tmp20_ = gdk_pixbuf_get_n_channels (_tmp19_);
					_tmp21_ = _tmp20_;
					row_last_pixel = body_pixel_index + (_tmp21_ * self->priv->left_nub_position);
					while (TRUE) {
						guchar* _tmp22_;
						gint _tmp22__length1;
						guchar* _tmp23_;
						gint _tmp23__length1;
						guchar _tmp24_;
						guchar* _tmp25_;
						gint _tmp25__length1;
						guchar* _tmp26_;
						gint _tmp26__length1;
						guchar _tmp27_;
						guchar* _tmp28_;
						gint _tmp28__length1;
						guchar* _tmp29_;
						gint _tmp29__length1;
						guchar _tmp30_;
						GdkPixbuf* _tmp31_;
						gint _tmp32_;
						gint _tmp33_;
						if (!(body_pixel_index < row_last_pixel)) {
							break;
						}
						_tmp22_ = pixel_data;
						_tmp22__length1 = pixel_data_length1;
						_tmp23_ = pixel_data;
						_tmp23__length1 = pixel_data_length1;
						_tmp24_ = _tmp23_[body_pixel_index];
						_tmp22_[body_pixel_index] = (guchar) ((_tmp24_ + body_blend_red) / 2);
						_tmp25_ = pixel_data;
						_tmp25__length1 = pixel_data_length1;
						_tmp26_ = pixel_data;
						_tmp26__length1 = pixel_data_length1;
						_tmp27_ = _tmp26_[body_pixel_index + 1];
						_tmp25_[body_pixel_index + 1] = (guchar) ((_tmp27_ + body_blend_green) / 2);
						_tmp28_ = pixel_data;
						_tmp28__length1 = pixel_data_length1;
						_tmp29_ = pixel_data;
						_tmp29__length1 = pixel_data_length1;
						_tmp30_ = _tmp29_[body_pixel_index + 2];
						_tmp28_[body_pixel_index + 2] = (guchar) ((_tmp30_ + body_blend_blue) / 2);
						_tmp31_ = histogram_graphic;
						_tmp32_ = gdk_pixbuf_get_n_channels (_tmp31_);
						_tmp33_ = _tmp32_;
						body_pixel_index += _tmp33_;
					}
					_tmp34_ = pixel_data;
					_tmp34__length1 = pixel_data_length1;
					_tmp35_ = pixel_data;
					_tmp35__length1 = pixel_data_length1;
					_tmp36_ = _tmp35_[edge_pixel_index];
					_tmp34_[edge_pixel_index] = (guchar) ((_tmp36_ + edge_blend_red) / 2);
					_tmp37_ = pixel_data;
					_tmp37__length1 = pixel_data_length1;
					_tmp38_ = pixel_data;
					_tmp38__length1 = pixel_data_length1;
					_tmp39_ = _tmp38_[edge_pixel_index + 1];
					_tmp37_[edge_pixel_index + 1] = (guchar) ((_tmp39_ + edge_blend_green) / 2);
					_tmp40_ = pixel_data;
					_tmp40__length1 = pixel_data_length1;
					_tmp41_ = pixel_data;
					_tmp41__length1 = pixel_data_length1;
					_tmp42_ = _tmp41_[edge_pixel_index + 2];
					_tmp40_[edge_pixel_index + 2] = (guchar) ((_tmp42_ + edge_blend_blue) / 2);
					_tmp43_ = histogram_graphic;
					_tmp44_ = gdk_pixbuf_get_rowstride (_tmp43_);
					_tmp45_ = _tmp44_;
					edge_pixel_index += _tmp45_;
				}
			}
		}
	}
	edge_blend_red = 250;
	edge_blend_green = 250;
	edge_blend_blue = 250;
	body_blend_red = 200;
	body_blend_green = 200;
	body_blend_blue = 200;
	if (self->priv->right_nub_position < 255) {
		gint edge_pixel_index = 0;
		GdkPixbuf* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp46_ = histogram_graphic;
		_tmp47_ = gdk_pixbuf_get_n_channels (_tmp46_);
		_tmp48_ = _tmp47_;
		edge_pixel_index = _tmp48_ * self->priv->right_nub_position;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp49_ = FALSE;
				_tmp49_ = TRUE;
				while (TRUE) {
					GdkPixbuf* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					gint body_pixel_index = 0;
					GdkPixbuf* _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					GdkPixbuf* _tmp57_;
					gint _tmp58_;
					gint _tmp59_;
					gint row_last_pixel = 0;
					GdkPixbuf* _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					GdkPixbuf* _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					guchar* _tmp78_;
					gint _tmp78__length1;
					guchar* _tmp79_;
					gint _tmp79__length1;
					guchar _tmp80_;
					guchar* _tmp81_;
					gint _tmp81__length1;
					guchar* _tmp82_;
					gint _tmp82__length1;
					guchar _tmp83_;
					guchar* _tmp84_;
					gint _tmp84__length1;
					guchar* _tmp85_;
					gint _tmp85__length1;
					guchar _tmp86_;
					GdkPixbuf* _tmp87_;
					gint _tmp88_;
					gint _tmp89_;
					if (!_tmp49_) {
						gint _tmp50_;
						_tmp50_ = i;
						i = _tmp50_ + 1;
					}
					_tmp49_ = FALSE;
					_tmp51_ = histogram_graphic;
					_tmp52_ = gdk_pixbuf_get_height (_tmp51_);
					_tmp53_ = _tmp52_;
					if (!(i < _tmp53_)) {
						break;
					}
					_tmp54_ = histogram_graphic;
					_tmp55_ = gdk_pixbuf_get_rowstride (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = histogram_graphic;
					_tmp58_ = gdk_pixbuf_get_n_channels (_tmp57_);
					_tmp59_ = _tmp58_;
					body_pixel_index = (i * _tmp56_) + (_tmp59_ * 255);
					_tmp60_ = histogram_graphic;
					_tmp61_ = gdk_pixbuf_get_rowstride (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = histogram_graphic;
					_tmp64_ = gdk_pixbuf_get_n_channels (_tmp63_);
					_tmp65_ = _tmp64_;
					row_last_pixel = (i * _tmp62_) + (_tmp65_ * self->priv->right_nub_position);
					while (TRUE) {
						guchar* _tmp66_;
						gint _tmp66__length1;
						guchar* _tmp67_;
						gint _tmp67__length1;
						guchar _tmp68_;
						guchar* _tmp69_;
						gint _tmp69__length1;
						guchar* _tmp70_;
						gint _tmp70__length1;
						guchar _tmp71_;
						guchar* _tmp72_;
						gint _tmp72__length1;
						guchar* _tmp73_;
						gint _tmp73__length1;
						guchar _tmp74_;
						GdkPixbuf* _tmp75_;
						gint _tmp76_;
						gint _tmp77_;
						if (!(body_pixel_index > row_last_pixel)) {
							break;
						}
						_tmp66_ = pixel_data;
						_tmp66__length1 = pixel_data_length1;
						_tmp67_ = pixel_data;
						_tmp67__length1 = pixel_data_length1;
						_tmp68_ = _tmp67_[body_pixel_index];
						_tmp66_[body_pixel_index] = (guchar) ((_tmp68_ + body_blend_red) / 2);
						_tmp69_ = pixel_data;
						_tmp69__length1 = pixel_data_length1;
						_tmp70_ = pixel_data;
						_tmp70__length1 = pixel_data_length1;
						_tmp71_ = _tmp70_[body_pixel_index + 1];
						_tmp69_[body_pixel_index + 1] = (guchar) ((_tmp71_ + body_blend_green) / 2);
						_tmp72_ = pixel_data;
						_tmp72__length1 = pixel_data_length1;
						_tmp73_ = pixel_data;
						_tmp73__length1 = pixel_data_length1;
						_tmp74_ = _tmp73_[body_pixel_index + 2];
						_tmp72_[body_pixel_index + 2] = (guchar) ((_tmp74_ + body_blend_blue) / 2);
						_tmp75_ = histogram_graphic;
						_tmp76_ = gdk_pixbuf_get_n_channels (_tmp75_);
						_tmp77_ = _tmp76_;
						body_pixel_index -= _tmp77_;
					}
					_tmp78_ = pixel_data;
					_tmp78__length1 = pixel_data_length1;
					_tmp79_ = pixel_data;
					_tmp79__length1 = pixel_data_length1;
					_tmp80_ = _tmp79_[edge_pixel_index];
					_tmp78_[edge_pixel_index] = (guchar) ((_tmp80_ + edge_blend_red) / 2);
					_tmp81_ = pixel_data;
					_tmp81__length1 = pixel_data_length1;
					_tmp82_ = pixel_data;
					_tmp82__length1 = pixel_data_length1;
					_tmp83_ = _tmp82_[edge_pixel_index + 1];
					_tmp81_[edge_pixel_index + 1] = (guchar) ((_tmp83_ + edge_blend_green) / 2);
					_tmp84_ = pixel_data;
					_tmp84__length1 = pixel_data_length1;
					_tmp85_ = pixel_data;
					_tmp85__length1 = pixel_data_length1;
					_tmp86_ = _tmp85_[edge_pixel_index + 2];
					_tmp84_[edge_pixel_index + 2] = (guchar) ((_tmp86_ + edge_blend_blue) / 2);
					_tmp87_ = histogram_graphic;
					_tmp88_ = gdk_pixbuf_get_rowstride (_tmp87_);
					_tmp89_ = _tmp88_;
					edge_pixel_index += _tmp89_;
				}
			}
		}
	}
	_tmp90_ = histogram_graphic;
	_tmp91_ = *area;
	_tmp92_ = *area;
	gdk_cairo_set_source_pixbuf (ctx, _tmp90_, (gdouble) (_tmp91_.x + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp92_.y + 2));
	cairo_paint (ctx);
	_g_object_unref0 (histogram_graphic);
}

static void
rgb_histogram_manipulator_draw_trough (RGBHistogramManipulator* self,
                                       cairo_t* ctx,
                                       GdkRectangle* area)
{
	gint trough_x = 0;
	GdkRectangle _tmp0_;
	gint trough_y = 0;
	GdkRectangle _tmp1_;
	GtkStyleContext* stylectx = NULL;
	GtkWidget* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkWidgetPath* _tmp5_;
	GtkWidgetPath* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = *area;
	trough_x = _tmp0_.x;
	_tmp1_ = *area;
	trough_y = _tmp1_.y + (((RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) - RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET) - 3);
	_tmp2_ = rgb_histogram_manipulator_dummy_slider;
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	stylectx = _tmp4_;
	gtk_style_context_save (stylectx);
	_tmp5_ = gtk_style_context_get_path (stylectx);
	gtk_widget_path_append_type (_tmp5_, gtk_scale_get_type ());
	_tmp6_ = gtk_style_context_get_path (stylectx);
	gtk_widget_path_iter_add_class (_tmp6_, 0, "scale");
	gtk_style_context_add_class (stylectx, GTK_STYLE_CLASS_TROUGH);
	gtk_render_activity (stylectx, ctx, (gdouble) trough_x, (gdouble) trough_y, (gdouble) RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH, (gdouble) RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT);
	gtk_style_context_restore (stylectx);
	_g_object_unref0 (stylectx);
}

static void
rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self,
                                    cairo_t* ctx,
                                    GdkRectangle* area,
                                    gint position)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = rgb_histogram_manipulator_get_drag_nub_pixbuf (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *area;
	_tmp3_ = *area;
	gdk_cairo_set_source_pixbuf (ctx, _tmp1_, (gdouble) (_tmp2_.x + position), (gdouble) (_tmp3_.y + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION));
	_g_object_unref0 (_tmp1_);
	cairo_paint (ctx);
}

static void
rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self)
{
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_invalidate_rect (_tmp0_, NULL, TRUE);
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_process_updates (_tmp1_, TRUE);
}

static void
rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self)
{
	g_return_if_fail (self != NULL);
	self->priv->right_nub_min = (self->priv->left_nub_position + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) + 1;
	self->priv->left_nub_max = (self->priv->right_nub_position - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
}

void
rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self,
                                            GdkPixbuf* source_pixbuf)
{
	RGBHistogram* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_pixbuf != NULL);
	_tmp0_ = rgb_histogram_new (source_pixbuf);
	_rgb_histogram_unref0 (self->priv->histogram);
	self->priv->histogram = _tmp0_;
	rgb_histogram_manipulator_force_update (self);
}

gint
rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->left_nub_position;
	return result;
}

gint
rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->right_nub_position;
	return result;
}

void
rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self,
                                                 gint user_nub_pos)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (user_nub_pos >= 0) {
		_tmp0_ = user_nub_pos <= 255;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
	self->priv->left_nub_position = CLAMP (user_nub_pos, 0, self->priv->left_nub_max);
	rgb_histogram_manipulator_update_nub_extrema (self);
}

void
rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self,
                                                  gint user_nub_pos)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (user_nub_pos >= 0) {
		_tmp0_ = user_nub_pos <= 255;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
	self->priv->right_nub_position = CLAMP (user_nub_pos, self->priv->right_nub_min, 255);
	rgb_histogram_manipulator_update_nub_extrema (self);
}

static void
rgb_histogram_manipulator_class_init (RGBHistogramManipulatorClass * klass,
                                      gpointer klass_data)
{
	GtkWidgetPath* _tmp0_;
	GtkWidgetPath* _tmp1_;
	rgb_histogram_manipulator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RGBHistogramManipulator_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) rgb_histogram_manipulator_real_draw;
	G_OBJECT_CLASS (klass)->finalize = rgb_histogram_manipulator_finalize;
	rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL] = g_signal_new ("nub-position-changed", TYPE_RGB_HISTOGRAM_MANIPULATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gtk_widget_path_new ();
	rgb_histogram_manipulator_slider_draw_path = _tmp0_;
	_tmp1_ = gtk_widget_path_new ();
	rgb_histogram_manipulator_frame_draw_path = _tmp1_;
}

static void
rgb_histogram_manipulator_instance_init (RGBHistogramManipulator * self,
                                         gpointer klass)
{
	self->priv = rgb_histogram_manipulator_get_instance_private (self);
	self->priv->left_nub_max = (255 - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
	self->priv->right_nub_min = RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE + 1;
	self->priv->histogram = NULL;
	self->priv->left_nub_position = 0;
	self->priv->right_nub_position = 255;
	self->priv->is_left_nub_tracking = FALSE;
	self->priv->is_right_nub_tracking = FALSE;
	self->priv->track_start_x = 0;
	self->priv->track_nub_start_position = 0;
	self->priv->drag_nub_pixbuf = NULL;
}

static void
rgb_histogram_manipulator_finalize (GObject * obj)
{
	RGBHistogramManipulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
	_rgb_histogram_unref0 (self->priv->histogram);
	_g_object_unref0 (self->priv->drag_nub_pixbuf);
	G_OBJECT_CLASS (rgb_histogram_manipulator_parent_class)->finalize (obj);
}

static GType
rgb_histogram_manipulator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramManipulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_manipulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogramManipulator), 0, (GInstanceInitFunc) rgb_histogram_manipulator_instance_init, NULL };
	GType rgb_histogram_manipulator_type_id;
	rgb_histogram_manipulator_type_id = g_type_register_static (gtk_drawing_area_get_type (), "RGBHistogramManipulator", &g_define_type_info, 0);
	RGBHistogramManipulator_private_offset = g_type_add_instance_private (rgb_histogram_manipulator_type_id, sizeof (RGBHistogramManipulatorPrivate));
	return rgb_histogram_manipulator_type_id;
}

GType
rgb_histogram_manipulator_get_type (void)
{
	static volatile gsize rgb_histogram_manipulator_type_id__once = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_type_id__once)) {
		GType rgb_histogram_manipulator_type_id;
		rgb_histogram_manipulator_type_id = rgb_histogram_manipulator_get_type_once ();
		g_once_init_leave (&rgb_histogram_manipulator_type_id__once, rgb_histogram_manipulator_type_id);
	}
	return rgb_histogram_manipulator_type_id__once;
}

