/* Printing.c generated by valac 0.56.18, the Vala compiler
 * generated from Printing.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io)
*               2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define MEASUREMENT_CENTIMETERS_PER_INCH 2.54
#define MEASUREMENT_INCHES_PER_CENTIMETER (1.0 / 2.54)
#define PRINT_MANAGER_IMAGE_DISTANCE 0.24
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _print_manager_unref0(var) ((var == NULL) ? NULL : (var = (print_manager_unref (var), NULL)))
typedef struct _ParamSpecPrintSettings ParamSpecPrintSettings;
typedef enum  {
	PRINT_LAYOUT_ENTIRE_PAGE,
	PRINT_LAYOUT_TWO_PER_PAGE,
	PRINT_LAYOUT_FOUR_PER_PAGE,
	PRINT_LAYOUT_SIX_PER_PAGE,
	PRINT_LAYOUT_EIGHT_PER_PAGE,
	PRINT_LAYOUT_SIXTEEN_PER_PAGE,
	PRINT_LAYOUT_THIRTY_TWO_PER_PAGE
} PrintLayout;

#define TYPE_PRINT_LAYOUT (print_layout_get_type ())
enum  {
	PRINT_JOB_0_PROPERTY,
	PRINT_JOB_NUM_PROPERTIES
};
static GParamSpec* print_job_properties[PRINT_JOB_NUM_PROPERTIES];
#define _print_settings_unref0(var) ((var == NULL) ? NULL : (var = (print_settings_unref (var), NULL)))
typedef struct _ParamSpecStandardPrintSize ParamSpecStandardPrintSize;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _ParamSpecPrintManager ParamSpecPrintManager;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PrintSettingsPrivate {
	ContentLayout content_layout;
	Measurement content_width;
	Measurement content_height;
	gint content_ppi;
	gint image_per_page_selection;
	gint size_selection;
	gboolean match_aspect_ratio;
	gboolean print_titles;
	gchar* print_titles_font;
	GSettings* print_settings;
};

struct _ParamSpecPrintSettings {
	GParamSpec parent_instance;
};

struct _PrintJobPrivate {
	PrintSettings* settings;
	GeeArrayList* photos;
};

struct _ParamSpecStandardPrintSize {
	GParamSpec parent_instance;
};

struct _PrintManagerPrivate {
	PrintSettings* settings;
	GtkPageSetup* user_page_setup;
	CustomPrintTab* custom_tab;
	ProgressDialog* progress_dialog;
	GCancellable* cancellable;
};

struct _ParamSpecPrintManager {
	GParamSpec parent_instance;
};

static gint PrintSettings_private_offset;
static gpointer print_settings_parent_class = NULL;
static gint PrintJob_private_offset;
static gpointer print_job_parent_class = NULL;
static gpointer standard_print_size_parent_class = NULL;
static gint PrintManager_private_offset;
static gpointer print_manager_parent_class = NULL;
static PrintManager* print_manager_instance;
static PrintManager* print_manager_instance = NULL;

static void print_settings_finalize (PrintSettings * obj);
static GType print_settings_get_type_once (void);
VALA_EXTERN GType print_layout_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PrintLayout* print_layout_get_all (gint* result_length1);
VALA_EXTERN gint print_layout_get_per_page (PrintLayout self);
VALA_EXTERN gint print_layout_get_x (PrintLayout self);
VALA_EXTERN gint print_layout_get_y (PrintLayout self);
VALA_EXTERN gchar* print_layout_to_string (PrintLayout self);
static void print_job_finalize (GObject * obj);
static GType print_job_get_type_once (void);
static void standard_print_size_finalize (StandardPrintSize * obj);
static GType standard_print_size_get_type_once (void);
static PrintManager* print_manager_new (void);
static PrintManager* print_manager_construct (GType object_type);
static void _vala_array_add30 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add31 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add32 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add33 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add34 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add35 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add36 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add37 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add38 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add39 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add40 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add41 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add42 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add43 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void _vala_array_add44 (StandardPrintSize** * array,
                        gint* length,
                        gint* size,
                        StandardPrintSize* value);
static void print_manager_on_begin_print (PrintManager* self,
                                   GtkPrintOperation* emitting_object,
                                   GtkPrintContext* job_context);
static void _print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                                    GtkPrintContext* context,
                                                                    gpointer self);
static void print_manager_on_draw_page (PrintManager* self,
                                 GtkPrintOperation* emitting_object,
                                 GtkPrintContext* job_context,
                                 gint page_num);
static void _print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                                GtkPrintContext* context,
                                                                gint page_nr,
                                                                gpointer self);
static GObject* print_manager_on_create_custom_widget (PrintManager* self,
                                                GtkPrintOperation* emitting_object);
static GObject* _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender,
                                                                                          gpointer self);
static void print_manager_on_status_changed (PrintManager* self,
                                      GtkPrintOperation* job);
static void _print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender,
                                                                          gpointer self);
static void print_manager_fit_image_to_canvas (PrintManager* self,
                                        Photo* photo,
                                        gdouble x,
                                        gdouble y,
                                        gdouble canvas_width,
                                        gdouble canvas_height,
                                        gboolean crop,
                                        PrintJob* job,
                                        GtkPrintContext* job_context);
static void print_manager_add_title_to_canvas (PrintManager* self,
                                        gdouble x,
                                        gdouble y,
                                        const gchar* title,
                                        PrintJob* job,
                                        GtkPrintContext* job_context);
static void print_manager_on_custom_widget_apply (PrintManager* self,
                                           GtkWidget* custom_widget);
static void _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender,
                                                                                    GtkWidget* widget,
                                                                                    gpointer self);
static gboolean print_manager_are_approximately_equal (PrintManager* self,
                                                gdouble val1,
                                                gdouble val2);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void print_manager_finalize (PrintManager * obj);
static GType print_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GType
content_layout_get_type_once (void)
{
	static const GEnumValue values[] = {{CONTENT_LAYOUT_STANDARD_SIZE, "CONTENT_LAYOUT_STANDARD_SIZE", "standard-size"}, {CONTENT_LAYOUT_CUSTOM_SIZE, "CONTENT_LAYOUT_CUSTOM_SIZE", "custom-size"}, {CONTENT_LAYOUT_IMAGE_PER_PAGE, "CONTENT_LAYOUT_IMAGE_PER_PAGE", "image-per-page"}, {0, NULL, NULL}};
	GType content_layout_type_id;
	content_layout_type_id = g_enum_register_static ("ContentLayout", values);
	return content_layout_type_id;
}

GType
content_layout_get_type (void)
{
	static volatile gsize content_layout_type_id__once = 0;
	if (g_once_init_enter (&content_layout_type_id__once)) {
		GType content_layout_type_id;
		content_layout_type_id = content_layout_get_type_once ();
		g_once_init_leave (&content_layout_type_id__once, content_layout_type_id);
	}
	return content_layout_type_id__once;
}

static inline gpointer
print_settings_get_instance_private (PrintSettings* self)
{
	return G_STRUCT_MEMBER_P (self, PrintSettings_private_offset);
}

PrintSettings*
print_settings_construct (GType object_type)
{
	PrintSettings* self = NULL;
	GSettings* _tmp0_;
	MeasurementUnit units = 0;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	gchar* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	self = (PrintSettings*) g_type_create_instance (object_type);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_PRINTING_SCHEMA_NAME);
	_g_object_unref0 (self->priv->print_settings);
	self->priv->print_settings = _tmp0_;
	_tmp1_ = self->priv->print_settings;
	units = ((MeasurementUnit) g_settings_get_int (_tmp1_, "content-units")) - 1;
	_tmp2_ = self->priv->print_settings;
	measurement_init (&self->priv->content_width, g_settings_get_double (_tmp2_, "content-width"), units);
	_tmp3_ = self->priv->print_settings;
	measurement_init (&self->priv->content_height, g_settings_get_double (_tmp3_, "content-height"), units);
	_tmp4_ = self->priv->print_settings;
	self->priv->size_selection = g_settings_get_int (_tmp4_, "size-selection") - 1;
	_tmp5_ = self->priv->print_settings;
	self->priv->content_layout = (ContentLayout) (g_settings_get_int (_tmp5_, "content-layout") - 1);
	_tmp6_ = self->priv->print_settings;
	self->priv->match_aspect_ratio = g_settings_get_boolean (_tmp6_, "match-aspect-ratio");
	_tmp7_ = self->priv->print_settings;
	self->priv->print_titles = g_settings_get_boolean (_tmp7_, "print-titles");
	_tmp8_ = self->priv->print_settings;
	_tmp9_ = g_settings_get_string (_tmp8_, "titles-font");
	_g_free0 (self->priv->print_titles_font);
	self->priv->print_titles_font = _tmp9_;
	_tmp10_ = self->priv->print_settings;
	self->priv->image_per_page_selection = g_settings_get_int (_tmp10_, "images-per-page") - 1;
	_tmp11_ = self->priv->print_settings;
	self->priv->content_ppi = g_settings_get_int (_tmp11_, "content-ppi");
	return self;
}

PrintSettings*
print_settings_new (void)
{
	return print_settings_construct (TYPE_PRINT_SETTINGS);
}

void
print_settings_save (PrintSettings* self)
{
	GSettings* _tmp0_;
	Measurement _tmp1_;
	GSettings* _tmp2_;
	Measurement _tmp3_;
	GSettings* _tmp4_;
	Measurement _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	const gchar* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_settings;
	_tmp1_ = self->priv->content_width;
	g_settings_set_int (_tmp0_, "content-units", (gint) (_tmp1_.unit + 1));
	_tmp2_ = self->priv->print_settings;
	_tmp3_ = self->priv->content_width;
	g_settings_set_double (_tmp2_, "content-width", _tmp3_.value);
	_tmp4_ = self->priv->print_settings;
	_tmp5_ = self->priv->content_height;
	g_settings_set_double (_tmp4_, "content-height", _tmp5_.value);
	_tmp6_ = self->priv->print_settings;
	g_settings_set_int (_tmp6_, "size-selection", self->priv->size_selection + 1);
	_tmp7_ = self->priv->print_settings;
	g_settings_set_int (_tmp7_, "content-layout", (gint) (self->priv->content_layout + 1));
	_tmp8_ = self->priv->print_settings;
	g_settings_set_boolean (_tmp8_, "match-aspect-ratio", self->priv->match_aspect_ratio);
	_tmp9_ = self->priv->print_settings;
	g_settings_set_boolean (_tmp9_, "print-titles", self->priv->print_titles);
	_tmp10_ = self->priv->print_settings;
	_tmp11_ = self->priv->print_titles_font;
	g_settings_set_string (_tmp10_, "titles-font", _tmp11_);
	_tmp12_ = self->priv->print_settings;
	g_settings_set_int (_tmp12_, "images-per-page", self->priv->image_per_page_selection + 1);
	_tmp13_ = self->priv->print_settings;
	g_settings_set_int (_tmp13_, "content-ppi", self->priv->content_ppi);
}

void
print_settings_get_content_width (PrintSettings* self,
                                  Measurement* result)
{
	g_return_if_fail (self != NULL);
	switch (print_settings_get_content_layout (self)) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			PrintManager* _tmp0_;
			PrintManager* _tmp1_;
			gint _tmp2_ = 0;
			StandardPrintSize** _tmp3_;
			StandardPrintSize** _tmp4_;
			gint _tmp4__length1;
			StandardPrintSize* _tmp5_;
			Measurement _tmp6_;
			Measurement _tmp7_;
			_tmp0_ = print_manager_get_instance ();
			_tmp1_ = _tmp0_;
			_tmp3_ = print_manager_get_standard_sizes (_tmp1_, &_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp4__length1 = _tmp2_;
			_tmp5_ = _tmp4_[print_settings_get_size_selection (self)];
			_tmp6_ = _tmp5_->width;
			_tmp7_ = _tmp6_;
			_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) standard_print_size_unref), NULL);
			_print_manager_unref0 (_tmp1_);
			*result = _tmp7_;
			return;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			Measurement _tmp8_;
			_tmp8_ = self->priv->content_width;
			*result = _tmp8_;
			return;
		}
		default:
		{
			g_error ("Printing.vala:85: unknown ContentLayout enumeration value");
		}
	}
}

void
print_settings_get_content_height (PrintSettings* self,
                                   Measurement* result)
{
	g_return_if_fail (self != NULL);
	switch (print_settings_get_content_layout (self)) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			PrintManager* _tmp0_;
			PrintManager* _tmp1_;
			gint _tmp2_ = 0;
			StandardPrintSize** _tmp3_;
			StandardPrintSize** _tmp4_;
			gint _tmp4__length1;
			StandardPrintSize* _tmp5_;
			Measurement _tmp6_;
			Measurement _tmp7_;
			_tmp0_ = print_manager_get_instance ();
			_tmp1_ = _tmp0_;
			_tmp3_ = print_manager_get_standard_sizes (_tmp1_, &_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp4__length1 = _tmp2_;
			_tmp5_ = _tmp4_[print_settings_get_size_selection (self)];
			_tmp6_ = _tmp5_->height;
			_tmp7_ = _tmp6_;
			_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) standard_print_size_unref), NULL);
			_print_manager_unref0 (_tmp1_);
			*result = _tmp7_;
			return;
		}
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			Measurement _tmp8_;
			_tmp8_ = self->priv->content_height;
			*result = _tmp8_;
			return;
		}
		default:
		{
			g_error ("Printing.vala:100: unknown ContentLayout enumeration value");
		}
	}
}

void
print_settings_get_minimum_content_dimension (PrintSettings* self,
                                              Measurement* result)
{
	Measurement _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	measurement_init (&_tmp0_, 0.5, MEASUREMENT_UNIT_INCHES);
	*result = _tmp0_;
	return;
}

void
print_settings_get_maximum_content_dimension (PrintSettings* self,
                                              Measurement* result)
{
	Measurement _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	measurement_init (&_tmp0_, (gdouble) 30, MEASUREMENT_UNIT_INCHES);
	*result = _tmp0_;
	return;
}

gboolean
print_settings_is_match_aspect_ratio_enabled (PrintSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->match_aspect_ratio;
	return result;
}

gboolean
print_settings_is_print_titles_enabled (PrintSettings* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->print_titles;
	return result;
}

gint
print_settings_get_content_ppi (PrintSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->content_ppi;
	return result;
}

gint
print_settings_get_image_per_page_selection (PrintSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->image_per_page_selection;
	return result;
}

gint
print_settings_get_size_selection (PrintSettings* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->size_selection;
	return result;
}

ContentLayout
print_settings_get_content_layout (PrintSettings* self)
{
	ContentLayout result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->content_layout;
	return result;
}

void
print_settings_set_content_layout (PrintSettings* self,
                                   ContentLayout content_layout)
{
	g_return_if_fail (self != NULL);
	self->priv->content_layout = content_layout;
}

void
print_settings_set_content_width (PrintSettings* self,
                                  Measurement* content_width)
{
	Measurement _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_width != NULL);
	_tmp0_ = *content_width;
	self->priv->content_width = _tmp0_;
}

void
print_settings_set_content_height (PrintSettings* self,
                                   Measurement* content_height)
{
	Measurement _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content_height != NULL);
	_tmp0_ = *content_height;
	self->priv->content_height = _tmp0_;
}

void
print_settings_set_content_ppi (PrintSettings* self,
                                gint content_ppi)
{
	g_return_if_fail (self != NULL);
	self->priv->content_ppi = content_ppi;
}

void
print_settings_set_image_per_page_selection (PrintSettings* self,
                                             gint image_per_page_selection)
{
	g_return_if_fail (self != NULL);
	self->priv->image_per_page_selection = image_per_page_selection;
}

void
print_settings_set_size_selection (PrintSettings* self,
                                   gint size_selection)
{
	g_return_if_fail (self != NULL);
	self->priv->size_selection = size_selection;
}

void
print_settings_set_match_aspect_ratio_enabled (PrintSettings* self,
                                               gboolean enable_state)
{
	g_return_if_fail (self != NULL);
	self->priv->match_aspect_ratio = enable_state;
}

void
print_settings_set_print_titles_enabled (PrintSettings* self,
                                         gboolean print_titles)
{
	g_return_if_fail (self != NULL);
	self->priv->print_titles = print_titles;
}

void
print_settings_set_print_titles_font (PrintSettings* self,
                                      const gchar* fontname)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fontname != NULL);
	_tmp0_ = g_strdup (fontname);
	_g_free0 (self->priv->print_titles_font);
	self->priv->print_titles_font = _tmp0_;
}

gchar*
print_settings_get_print_titles_font (PrintSettings* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->print_titles_font;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
value_print_settings_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_print_settings_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		print_settings_unref (value->data[0].v_pointer);
	}
}

static void
value_print_settings_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = print_settings_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_print_settings_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_print_settings_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PrintSettings * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = print_settings_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_print_settings_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	PrintSettings ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = print_settings_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_print_settings (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecPrintSettings* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_SETTINGS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_print_settings (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_print_settings (GValue* value,
                          gpointer v_object)
{
	PrintSettings * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		print_settings_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_settings_unref (old);
	}
}

void
value_take_print_settings (GValue* value,
                           gpointer v_object)
{
	PrintSettings * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_SETTINGS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_SETTINGS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_settings_unref (old);
	}
}

static void
print_settings_class_init (PrintSettingsClass * klass,
                           gpointer klass_data)
{
	print_settings_parent_class = g_type_class_peek_parent (klass);
	((PrintSettingsClass *) klass)->finalize = print_settings_finalize;
	g_type_class_adjust_private_offset (klass, &PrintSettings_private_offset);
}

static void
print_settings_instance_init (PrintSettings * self,
                              gpointer klass)
{
	self->priv = print_settings_get_instance_private (self);
	self->ref_count = 1;
}

static void
print_settings_finalize (PrintSettings * obj)
{
	PrintSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_SETTINGS, PrintSettings);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->print_titles_font);
	_g_object_unref0 (self->priv->print_settings);
}

static GType
print_settings_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_print_settings_init, value_print_settings_free_value, value_print_settings_copy_value, value_print_settings_peek_pointer, "p", value_print_settings_collect_value, "p", value_print_settings_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PrintSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintSettings), 0, (GInstanceInitFunc) print_settings_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType print_settings_type_id;
	print_settings_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintSettings", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PrintSettings_private_offset = g_type_add_instance_private (print_settings_type_id, sizeof (PrintSettingsPrivate));
	return print_settings_type_id;
}

GType
print_settings_get_type (void)
{
	static volatile gsize print_settings_type_id__once = 0;
	if (g_once_init_enter (&print_settings_type_id__once)) {
		GType print_settings_type_id;
		print_settings_type_id = print_settings_get_type_once ();
		g_once_init_leave (&print_settings_type_id__once, print_settings_type_id);
	}
	return print_settings_type_id__once;
}

gpointer
print_settings_ref (gpointer instance)
{
	PrintSettings * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
print_settings_unref (gpointer instance)
{
	PrintSettings * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PRINT_SETTINGS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
measurement_unit_get_type_once (void)
{
	static const GEnumValue values[] = {{MEASUREMENT_UNIT_INCHES, "MEASUREMENT_UNIT_INCHES", "inches"}, {MEASUREMENT_UNIT_CENTIMETERS, "MEASUREMENT_UNIT_CENTIMETERS", "centimeters"}, {0, NULL, NULL}};
	GType measurement_unit_type_id;
	measurement_unit_type_id = g_enum_register_static ("MeasurementUnit", values);
	return measurement_unit_type_id;
}

GType
measurement_unit_get_type (void)
{
	static volatile gsize measurement_unit_type_id__once = 0;
	if (g_once_init_enter (&measurement_unit_type_id__once)) {
		GType measurement_unit_type_id;
		measurement_unit_type_id = measurement_unit_get_type_once ();
		g_once_init_leave (&measurement_unit_type_id__once, measurement_unit_type_id);
	}
	return measurement_unit_type_id__once;
}

void
measurement_init (Measurement *self,
                  gdouble value,
                  MeasurementUnit unit)
{
	memset (self, 0, sizeof (Measurement));
	(*self).value = value;
	(*self).unit = unit;
}

void
measurement_convert_to (Measurement *self,
                        MeasurementUnit to_unit,
                        Measurement* result)
{
	if ((*self).unit == to_unit) {
		*result = (*self);
		return;
	}
	if (to_unit == MEASUREMENT_UNIT_INCHES) {
		Measurement _tmp0_ = {0};
		measurement_init (&_tmp0_, (*self).value * MEASUREMENT_INCHES_PER_CENTIMETER, MEASUREMENT_UNIT_INCHES);
		*result = _tmp0_;
		return;
	} else {
		if (to_unit == MEASUREMENT_UNIT_CENTIMETERS) {
			Measurement _tmp1_ = {0};
			measurement_init (&_tmp1_, (*self).value * MEASUREMENT_CENTIMETERS_PER_INCH, MEASUREMENT_UNIT_CENTIMETERS);
			*result = _tmp1_;
			return;
		} else {
			g_error ("Printing.vala:211: unrecognized unit");
		}
	}
}

gboolean
measurement_is_less_than (Measurement *self,
                          Measurement* rhs)
{
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	Measurement converted_rhs = {0};
	Measurement _tmp4_;
	gboolean result;
	g_return_val_if_fail (rhs != NULL, FALSE);
	_tmp1_ = *rhs;
	if ((*self).unit == _tmp1_.unit) {
		Measurement _tmp2_;
		_tmp2_ = *rhs;
		_tmp0_ = _tmp2_;
	} else {
		Measurement _tmp3_ = {0};
		measurement_convert_to (rhs, (*self).unit, &_tmp3_);
		_tmp0_ = _tmp3_;
	}
	converted_rhs = _tmp0_;
	_tmp4_ = converted_rhs;
	result = (*self).value < _tmp4_.value;
	return result;
}

gboolean
measurement_is_greater_than (Measurement *self,
                             Measurement* rhs)
{
	Measurement _tmp0_ = {0};
	Measurement _tmp1_;
	Measurement converted_rhs = {0};
	Measurement _tmp4_;
	gboolean result;
	g_return_val_if_fail (rhs != NULL, FALSE);
	_tmp1_ = *rhs;
	if ((*self).unit == _tmp1_.unit) {
		Measurement _tmp2_;
		_tmp2_ = *rhs;
		_tmp0_ = _tmp2_;
	} else {
		Measurement _tmp3_ = {0};
		measurement_convert_to (rhs, (*self).unit, &_tmp3_);
		_tmp0_ = _tmp3_;
	}
	converted_rhs = _tmp0_;
	_tmp4_ = converted_rhs;
	result = (*self).value > _tmp4_.value;
	return result;
}

Measurement*
measurement_dup (const Measurement* self)
{
	Measurement* dup;
	dup = g_new0 (Measurement, 1);
	memcpy (dup, self, sizeof (Measurement));
	return dup;
}

void
measurement_free (Measurement* self)
{
	g_free (self);
}

static GType
measurement_get_type_once (void)
{
	GType measurement_type_id;
	measurement_type_id = g_boxed_type_register_static ("Measurement", (GBoxedCopyFunc) measurement_dup, (GBoxedFreeFunc) measurement_free);
	return measurement_type_id;
}

GType
measurement_get_type (void)
{
	static volatile gsize measurement_type_id__once = 0;
	if (g_once_init_enter (&measurement_type_id__once)) {
		GType measurement_type_id;
		measurement_type_id = measurement_get_type_once ();
		g_once_init_leave (&measurement_type_id__once, measurement_type_id);
	}
	return measurement_type_id__once;
}

PrintLayout*
print_layout_get_all (gint* result_length1)
{
	PrintLayout* _tmp0_;
	PrintLayout* _tmp1_;
	gint _tmp1__length1;
	PrintLayout* result;
	_tmp0_ = g_new0 (PrintLayout, 7);
	_tmp0_[0] = PRINT_LAYOUT_ENTIRE_PAGE;
	_tmp0_[1] = PRINT_LAYOUT_TWO_PER_PAGE;
	_tmp0_[2] = PRINT_LAYOUT_FOUR_PER_PAGE;
	_tmp0_[3] = PRINT_LAYOUT_SIX_PER_PAGE;
	_tmp0_[4] = PRINT_LAYOUT_EIGHT_PER_PAGE;
	_tmp0_[5] = PRINT_LAYOUT_SIXTEEN_PER_PAGE;
	_tmp0_[6] = PRINT_LAYOUT_THIRTY_TWO_PER_PAGE;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 7;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gint
print_layout_get_per_page (PrintLayout self)
{
	gint* per_page = NULL;
	gint* _tmp0_;
	gint per_page_length1;
	gint _per_page_size_;
	gint _tmp1_;
	gint result;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 1;
	_tmp0_[1] = 2;
	_tmp0_[2] = 4;
	_tmp0_[3] = 6;
	_tmp0_[4] = 8;
	_tmp0_[5] = 16;
	_tmp0_[6] = 32;
	per_page = _tmp0_;
	per_page_length1 = 7;
	_per_page_size_ = per_page_length1;
	_tmp1_ = per_page[self];
	result = _tmp1_;
	per_page = (g_free (per_page), NULL);
	return result;
}

gint
print_layout_get_x (PrintLayout self)
{
	gint* x = NULL;
	gint* _tmp0_;
	gint x_length1;
	gint _x_size_;
	gint _tmp1_;
	gint result;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 1;
	_tmp0_[1] = 1;
	_tmp0_[2] = 2;
	_tmp0_[3] = 2;
	_tmp0_[4] = 2;
	_tmp0_[5] = 4;
	_tmp0_[6] = 4;
	x = _tmp0_;
	x_length1 = 7;
	_x_size_ = x_length1;
	_tmp1_ = x[self];
	result = _tmp1_;
	x = (g_free (x), NULL);
	return result;
}

gint
print_layout_get_y (PrintLayout self)
{
	gint* y = NULL;
	gint* _tmp0_;
	gint y_length1;
	gint _y_size_;
	gint _tmp1_;
	gint result;
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 1;
	_tmp0_[1] = 2;
	_tmp0_[2] = 2;
	_tmp0_[3] = 3;
	_tmp0_[4] = 4;
	_tmp0_[5] = 4;
	_tmp0_[6] = 8;
	y = _tmp0_;
	y_length1 = 7;
	_y_size_ = y_length1;
	_tmp1_ = y[self];
	result = _tmp1_;
	y = (g_free (y), NULL);
	return result;
}

gchar*
print_layout_to_string (PrintLayout self)
{
	gchar** labels = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint labels_length1;
	gint _labels_size_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	_tmp0_ = g_strdup (_ ("Fill the entire page"));
	_tmp1_ = g_strdup (_ ("2 images per page"));
	_tmp2_ = g_strdup (_ ("4 images per page"));
	_tmp3_ = g_strdup (_ ("6 images per page"));
	_tmp4_ = g_strdup (_ ("8 images per page"));
	_tmp5_ = g_strdup (_ ("16 images per page"));
	_tmp6_ = g_strdup (_ ("32 images per page"));
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	labels = _tmp7_;
	labels_length1 = 7;
	_labels_size_ = labels_length1;
	_tmp8_ = labels[self];
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	labels = (_vala_array_free (labels, labels_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static GType
print_layout_get_type_once (void)
{
	static const GEnumValue values[] = {{PRINT_LAYOUT_ENTIRE_PAGE, "PRINT_LAYOUT_ENTIRE_PAGE", "entire-page"}, {PRINT_LAYOUT_TWO_PER_PAGE, "PRINT_LAYOUT_TWO_PER_PAGE", "two-per-page"}, {PRINT_LAYOUT_FOUR_PER_PAGE, "PRINT_LAYOUT_FOUR_PER_PAGE", "four-per-page"}, {PRINT_LAYOUT_SIX_PER_PAGE, "PRINT_LAYOUT_SIX_PER_PAGE", "six-per-page"}, {PRINT_LAYOUT_EIGHT_PER_PAGE, "PRINT_LAYOUT_EIGHT_PER_PAGE", "eight-per-page"}, {PRINT_LAYOUT_SIXTEEN_PER_PAGE, "PRINT_LAYOUT_SIXTEEN_PER_PAGE", "sixteen-per-page"}, {PRINT_LAYOUT_THIRTY_TWO_PER_PAGE, "PRINT_LAYOUT_THIRTY_TWO_PER_PAGE", "thirty-two-per-page"}, {0, NULL, NULL}};
	GType print_layout_type_id;
	print_layout_type_id = g_enum_register_static ("PrintLayout", values);
	return print_layout_type_id;
}

GType
print_layout_get_type (void)
{
	static volatile gsize print_layout_type_id__once = 0;
	if (g_once_init_enter (&print_layout_type_id__once)) {
		GType print_layout_type_id;
		print_layout_type_id = print_layout_get_type_once ();
		g_once_init_leave (&print_layout_type_id__once, print_layout_type_id);
	}
	return print_layout_type_id__once;
}

static inline gpointer
print_job_get_instance_private (PrintJob* self)
{
	return G_STRUCT_MEMBER_P (self, PrintJob_private_offset);
}

PrintJob*
print_job_construct (GType object_type,
                     GeeCollection* to_print)
{
	PrintJob * self = NULL;
	PrintManager* _tmp0_;
	PrintManager* _tmp1_;
	PrintSettings* _tmp2_;
	GeeArrayList* _tmp3_;
	gdouble photo_aspect_ratio = 0.0;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	Photo* _tmp6_;
	Dimensions _tmp7_ = {0};
	gdouble _tmp8_;
	g_return_val_if_fail (to_print != NULL, NULL);
	self = (PrintJob*) g_object_new (object_type, NULL);
	_tmp0_ = print_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = print_manager_get_global_settings (_tmp1_);
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_print_manager_unref0 (_tmp1_);
	_tmp3_ = self->priv->photos;
	gee_array_list_add_all (_tmp3_, to_print);
	gtk_print_operation_set_embed_page_setup ((GtkPrintOperation*) self, TRUE);
	_tmp4_ = self->priv->photos;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, 0);
	_tmp6_ = (Photo*) _tmp5_;
	media_source_get_dimensions ((MediaSource*) _tmp6_, PHOTO_EXCEPTION_NONE, &_tmp7_);
	_tmp8_ = dimensions_get_aspect_ratio (&_tmp7_);
	_g_object_unref0 (_tmp6_);
	photo_aspect_ratio = _tmp8_;
	if (photo_aspect_ratio < 1.0) {
		photo_aspect_ratio = 1.0 / photo_aspect_ratio;
	}
	return self;
}

PrintJob*
print_job_new (GeeCollection* to_print)
{
	return print_job_construct (TYPE_PRINT_JOB, to_print);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeList*
print_job_get_photos (PrintJob* self)
{
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->photos;
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
	result = _tmp1_;
	return result;
}

Photo*
print_job_get_source_photo (PrintJob* self)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	Photo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->photos;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, 0);
	result = (Photo*) _tmp1_;
	return result;
}

gdouble
print_job_get_source_aspect_ratio (PrintJob* self)
{
	gdouble aspect_ratio = 0.0;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	Photo* _tmp2_;
	Dimensions _tmp3_ = {0};
	gdouble _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->photos;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, 0);
	_tmp2_ = (Photo*) _tmp1_;
	media_source_get_dimensions ((MediaSource*) _tmp2_, PHOTO_EXCEPTION_NONE, &_tmp3_);
	_tmp4_ = dimensions_get_aspect_ratio (&_tmp3_);
	_g_object_unref0 (_tmp2_);
	aspect_ratio = _tmp4_;
	if (aspect_ratio < 1.0) {
		_tmp5_ = 1.0 / aspect_ratio;
	} else {
		_tmp5_ = aspect_ratio;
	}
	result = _tmp5_;
	return result;
}

static gpointer
_print_settings_ref0 (gpointer self)
{
	return self ? print_settings_ref (self) : NULL;
}

PrintSettings*
print_job_get_local_settings (PrintJob* self)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	PrintSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = _print_settings_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
print_job_set_local_settings (PrintJob* self,
                              PrintSettings* settings)
{
	PrintSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = _print_settings_ref0 (settings);
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
}

static void
print_job_class_init (PrintJobClass * klass,
                      gpointer klass_data)
{
	print_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintJob_private_offset);
	G_OBJECT_CLASS (klass)->finalize = print_job_finalize;
}

static void
print_job_instance_init (PrintJob * self,
                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = print_job_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->photos = _tmp0_;
}

static void
print_job_finalize (GObject * obj)
{
	PrintJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_JOB, PrintJob);
	_print_settings_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->photos);
	G_OBJECT_CLASS (print_job_parent_class)->finalize (obj);
}

static GType
print_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintJob), 0, (GInstanceInitFunc) print_job_instance_init, NULL };
	GType print_job_type_id;
	print_job_type_id = g_type_register_static (gtk_print_operation_get_type (), "PrintJob", &g_define_type_info, 0);
	PrintJob_private_offset = g_type_add_instance_private (print_job_type_id, sizeof (PrintJobPrivate));
	return print_job_type_id;
}

GType
print_job_get_type (void)
{
	static volatile gsize print_job_type_id__once = 0;
	if (g_once_init_enter (&print_job_type_id__once)) {
		GType print_job_type_id;
		print_job_type_id = print_job_get_type_once ();
		g_once_init_leave (&print_job_type_id__once, print_job_type_id);
	}
	return print_job_type_id__once;
}

StandardPrintSize*
standard_print_size_construct (GType object_type,
                               const gchar* name,
                               Measurement* width,
                               Measurement* height)
{
	StandardPrintSize* self = NULL;
	gchar* _tmp0_;
	Measurement _tmp1_;
	Measurement _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (width != NULL, NULL);
	g_return_val_if_fail (height != NULL, NULL);
	self = (StandardPrintSize*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = *width;
	self->width = _tmp1_;
	_tmp2_ = *height;
	self->height = _tmp2_;
	return self;
}

StandardPrintSize*
standard_print_size_new (const gchar* name,
                         Measurement* width,
                         Measurement* height)
{
	return standard_print_size_construct (TYPE_STANDARD_PRINT_SIZE, name, width, height);
}

static void
value_standard_print_size_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_standard_print_size_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		standard_print_size_unref (value->data[0].v_pointer);
	}
}

static void
value_standard_print_size_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = standard_print_size_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_standard_print_size_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_standard_print_size_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		StandardPrintSize * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = standard_print_size_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_standard_print_size_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	StandardPrintSize ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = standard_print_size_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_standard_print_size (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecStandardPrintSize* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STANDARD_PRINT_SIZE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_standard_print_size (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_standard_print_size (GValue* value,
                               gpointer v_object)
{
	StandardPrintSize * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		standard_print_size_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		standard_print_size_unref (old);
	}
}

void
value_take_standard_print_size (GValue* value,
                                gpointer v_object)
{
	StandardPrintSize * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STANDARD_PRINT_SIZE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STANDARD_PRINT_SIZE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		standard_print_size_unref (old);
	}
}

static void
standard_print_size_class_init (StandardPrintSizeClass * klass,
                                gpointer klass_data)
{
	standard_print_size_parent_class = g_type_class_peek_parent (klass);
	((StandardPrintSizeClass *) klass)->finalize = standard_print_size_finalize;
}

static void
standard_print_size_instance_init (StandardPrintSize * self,
                                   gpointer klass)
{
	self->ref_count = 1;
}

static void
standard_print_size_finalize (StandardPrintSize * obj)
{
	StandardPrintSize * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STANDARD_PRINT_SIZE, StandardPrintSize);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
}

static GType
standard_print_size_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_standard_print_size_init, value_standard_print_size_free_value, value_standard_print_size_copy_value, value_standard_print_size_peek_pointer, "p", value_standard_print_size_collect_value, "p", value_standard_print_size_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (StandardPrintSizeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) standard_print_size_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StandardPrintSize), 0, (GInstanceInitFunc) standard_print_size_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType standard_print_size_type_id;
	standard_print_size_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StandardPrintSize", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return standard_print_size_type_id;
}

GType
standard_print_size_get_type (void)
{
	static volatile gsize standard_print_size_type_id__once = 0;
	if (g_once_init_enter (&standard_print_size_type_id__once)) {
		GType standard_print_size_type_id;
		standard_print_size_type_id = standard_print_size_get_type_once ();
		g_once_init_leave (&standard_print_size_type_id__once, standard_print_size_type_id);
	}
	return standard_print_size_type_id__once;
}

gpointer
standard_print_size_ref (gpointer instance)
{
	StandardPrintSize * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
standard_print_size_unref (gpointer instance)
{
	StandardPrintSize * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STANDARD_PRINT_SIZE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
print_manager_get_instance_private (PrintManager* self)
{
	return G_STRUCT_MEMBER_P (self, PrintManager_private_offset);
}

static PrintManager*
print_manager_construct (GType object_type)
{
	PrintManager* self = NULL;
	GtkPageSetup* _tmp0_;
	PrintSettings* _tmp1_;
	self = (PrintManager*) g_type_create_instance (object_type);
	_tmp0_ = gtk_page_setup_new ();
	_g_object_unref0 (self->priv->user_page_setup);
	self->priv->user_page_setup = _tmp0_;
	_tmp1_ = print_settings_new ();
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	return self;
}

static PrintManager*
print_manager_new (void)
{
	return print_manager_construct (TYPE_PRINT_MANAGER);
}

static void
_vala_array_add30 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add31 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add32 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add33 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add34 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add35 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add36 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add37 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add38 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add39 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add40 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add41 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add42 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add43 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add44 (StandardPrintSize** * array,
                   gint* length,
                   gint* size,
                   StandardPrintSize* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (StandardPrintSize*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

StandardPrintSize**
print_manager_get_standard_sizes (PrintManager* self,
                                  gint* result_length1)
{
	StandardPrintSize** _result_ = NULL;
	StandardPrintSize** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	Measurement _tmp1_ = {0};
	Measurement _tmp2_ = {0};
	StandardPrintSize* _tmp3_;
	Measurement _tmp4_ = {0};
	Measurement _tmp5_ = {0};
	StandardPrintSize* _tmp6_;
	Measurement _tmp7_ = {0};
	Measurement _tmp8_ = {0};
	StandardPrintSize* _tmp9_;
	Measurement _tmp10_ = {0};
	Measurement _tmp11_ = {0};
	StandardPrintSize* _tmp12_;
	Measurement _tmp13_ = {0};
	Measurement _tmp14_ = {0};
	StandardPrintSize* _tmp15_;
	Measurement _tmp16_ = {0};
	Measurement _tmp17_ = {0};
	StandardPrintSize* _tmp18_;
	Measurement _tmp19_ = {0};
	Measurement _tmp20_ = {0};
	StandardPrintSize* _tmp21_;
	Measurement _tmp22_ = {0};
	Measurement _tmp23_ = {0};
	StandardPrintSize* _tmp24_;
	Measurement _tmp25_ = {0};
	Measurement _tmp26_ = {0};
	StandardPrintSize* _tmp27_;
	Measurement _tmp28_ = {0};
	Measurement _tmp29_ = {0};
	StandardPrintSize* _tmp30_;
	Measurement _tmp31_ = {0};
	Measurement _tmp32_ = {0};
	StandardPrintSize* _tmp33_;
	Measurement _tmp34_ = {0};
	Measurement _tmp35_ = {0};
	StandardPrintSize* _tmp36_;
	Measurement _tmp37_ = {0};
	Measurement _tmp38_ = {0};
	StandardPrintSize* _tmp39_;
	Measurement _tmp40_ = {0};
	Measurement _tmp41_ = {0};
	StandardPrintSize* _tmp42_;
	Measurement _tmp43_ = {0};
	Measurement _tmp44_ = {0};
	StandardPrintSize* _tmp45_;
	StandardPrintSize** _tmp46_;
	gint _tmp46__length1;
	StandardPrintSize** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (StandardPrintSize*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	measurement_init (&_tmp1_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp2_, (gdouble) 2, MEASUREMENT_UNIT_INCHES);
	_tmp3_ = standard_print_size_new (_ ("Wallet (2 x 3 in.)"), &_tmp1_, &_tmp2_);
	_vala_array_add30 (&_result_, &_result__length1, &__result__size_, _tmp3_);
	measurement_init (&_tmp4_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp5_, (gdouble) 3, MEASUREMENT_UNIT_INCHES);
	_tmp6_ = standard_print_size_new (_ ("Notecard (3 x 5 in.)"), &_tmp4_, &_tmp5_);
	_vala_array_add31 (&_result_, &_result__length1, &__result__size_, _tmp6_);
	measurement_init (&_tmp7_, (gdouble) 6, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp8_, (gdouble) 4, MEASUREMENT_UNIT_INCHES);
	_tmp9_ = standard_print_size_new (_ ("4 x 6 in."), &_tmp7_, &_tmp8_);
	_vala_array_add32 (&_result_, &_result__length1, &__result__size_, _tmp9_);
	measurement_init (&_tmp10_, (gdouble) 7, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp11_, (gdouble) 5, MEASUREMENT_UNIT_INCHES);
	_tmp12_ = standard_print_size_new (_ ("5 x 7 in."), &_tmp10_, &_tmp11_);
	_vala_array_add33 (&_result_, &_result__length1, &__result__size_, _tmp12_);
	measurement_init (&_tmp13_, (gdouble) 10, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp14_, (gdouble) 8, MEASUREMENT_UNIT_INCHES);
	_tmp15_ = standard_print_size_new (_ ("8 x 10 in."), &_tmp13_, &_tmp14_);
	_vala_array_add34 (&_result_, &_result__length1, &__result__size_, _tmp15_);
	measurement_init (&_tmp16_, (gdouble) 14, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp17_, (gdouble) 11, MEASUREMENT_UNIT_INCHES);
	_tmp18_ = standard_print_size_new (_ ("11 x 14 in."), &_tmp16_, &_tmp17_);
	_vala_array_add35 (&_result_, &_result__length1, &__result__size_, _tmp18_);
	measurement_init (&_tmp19_, (gdouble) 20, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp20_, (gdouble) 16, MEASUREMENT_UNIT_INCHES);
	_tmp21_ = standard_print_size_new (_ ("16 x 20 in."), &_tmp19_, &_tmp20_);
	_vala_array_add36 (&_result_, &_result__length1, &__result__size_, _tmp21_);
	measurement_init (&_tmp22_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
	measurement_init (&_tmp23_, (gdouble) 0, MEASUREMENT_UNIT_INCHES);
	_tmp24_ = standard_print_size_new ("-", &_tmp22_, &_tmp23_);
	_vala_array_add37 (&_result_, &_result__length1, &__result__size_, _tmp24_);
	measurement_init (&_tmp25_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp26_, (gdouble) 9, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp27_ = standard_print_size_new (_ ("Metric Wallet (9 x 13 cm)"), &_tmp25_, &_tmp26_);
	_vala_array_add38 (&_result_, &_result__length1, &__result__size_, _tmp27_);
	measurement_init (&_tmp28_, (gdouble) 15, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp29_, (gdouble) 10, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp30_ = standard_print_size_new (_ ("Postcard (10 x 15 cm)"), &_tmp28_, &_tmp29_);
	_vala_array_add39 (&_result_, &_result__length1, &__result__size_, _tmp30_);
	measurement_init (&_tmp31_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp32_, (gdouble) 13, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp33_ = standard_print_size_new (_ ("13 x 18 cm"), &_tmp31_, &_tmp32_);
	_vala_array_add40 (&_result_, &_result__length1, &__result__size_, _tmp33_);
	measurement_init (&_tmp34_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp35_, (gdouble) 18, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp36_ = standard_print_size_new (_ ("18 x 24 cm"), &_tmp34_, &_tmp35_);
	_vala_array_add41 (&_result_, &_result__length1, &__result__size_, _tmp36_);
	measurement_init (&_tmp37_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp38_, (gdouble) 20, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp39_ = standard_print_size_new (_ ("20 x 30 cm"), &_tmp37_, &_tmp38_);
	_vala_array_add42 (&_result_, &_result__length1, &__result__size_, _tmp39_);
	measurement_init (&_tmp40_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp41_, (gdouble) 24, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp42_ = standard_print_size_new (_ ("24 x 40 cm"), &_tmp40_, &_tmp41_);
	_vala_array_add43 (&_result_, &_result__length1, &__result__size_, _tmp42_);
	measurement_init (&_tmp43_, (gdouble) 40, MEASUREMENT_UNIT_CENTIMETERS);
	measurement_init (&_tmp44_, (gdouble) 30, MEASUREMENT_UNIT_CENTIMETERS);
	_tmp45_ = standard_print_size_new (_ ("30 x 40 cm"), &_tmp43_, &_tmp44_);
	_vala_array_add44 (&_result_, &_result__length1, &__result__size_, _tmp45_);
	_tmp46_ = _result_;
	_tmp46__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp46__length1;
	}
	result = _tmp46_;
	return result;
}

static gpointer
_print_manager_ref0 (gpointer self)
{
	return self ? print_manager_ref (self) : NULL;
}

PrintManager*
print_manager_get_instance (void)
{
	PrintManager* _tmp0_;
	PrintManager* _tmp2_;
	PrintManager* _tmp3_;
	PrintManager* result;
	_tmp0_ = print_manager_instance;
	if (_tmp0_ == NULL) {
		PrintManager* _tmp1_;
		_tmp1_ = print_manager_new ();
		_print_manager_unref0 (print_manager_instance);
		print_manager_instance = _tmp1_;
	}
	_tmp2_ = print_manager_instance;
	_tmp3_ = _print_manager_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_print_manager_on_begin_print_gtk_print_operation_begin_print (GtkPrintOperation* _sender,
                                                               GtkPrintContext* context,
                                                               gpointer self)
{
	print_manager_on_begin_print ((PrintManager*) self, _sender, context);
}

static void
_print_manager_on_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                           GtkPrintContext* context,
                                                           gint page_nr,
                                                           gpointer self)
{
	print_manager_on_draw_page ((PrintManager*) self, _sender, context, page_nr);
}

static GObject*
_print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget (GtkPrintOperation* _sender,
                                                                                 gpointer self)
{
	GObject* result;
	result = print_manager_on_create_custom_widget ((PrintManager*) self, _sender);
	return result;
}

static void
_print_manager_on_status_changed_gtk_print_operation_status_changed (GtkPrintOperation* _sender,
                                                                     gpointer self)
{
	print_manager_on_status_changed ((PrintManager*) self, _sender);
}

void
print_manager_spool_photo (PrintManager* self,
                           GeeCollection* to_print)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	Photo* _tmp1_;
	Photo* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkPageSetup* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	GCancellable* _tmp8_;
	AppWindow* _tmp9_;
	AppWindow* _tmp10_;
	GCancellable* _tmp11_;
	ProgressDialog* _tmp12_;
	gchar* err_msg = NULL;
	ProgressDialog* _tmp21_;
	AppWindow* _tmp22_;
	AppWindow* _tmp23_;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_print != NULL);
	_tmp0_ = print_job_new (to_print);
	job = _tmp0_;
	gtk_print_operation_set_custom_tab_label ((GtkPrintOperation*) job, _ ("Image Settings"));
	gtk_print_operation_set_unit ((GtkPrintOperation*) job, GTK_UNIT_INCH);
	gtk_print_operation_set_n_pages ((GtkPrintOperation*) job, 1);
	_tmp1_ = print_job_get_source_photo (job);
	_tmp2_ = _tmp1_;
	_tmp3_ = data_object_get_name ((DataObject*) _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_print_operation_set_job_name ((GtkPrintOperation*) job, _tmp4_);
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp5_ = self->priv->user_page_setup;
	gtk_print_operation_set_default_page_setup ((GtkPrintOperation*) job, _tmp5_);
	g_signal_connect ((GtkPrintOperation*) job, "begin-print", (GCallback) _print_manager_on_begin_print_gtk_print_operation_begin_print, self);
	g_signal_connect ((GtkPrintOperation*) job, "draw-page", (GCallback) _print_manager_on_draw_page_gtk_print_operation_draw_page, self);
	g_signal_connect ((GtkPrintOperation*) job, "create-custom-widget", (GCallback) _print_manager_on_create_custom_widget_gtk_print_operation_create_custom_widget, self);
	g_signal_connect ((GtkPrintOperation*) job, "status-changed", (GCallback) _print_manager_on_status_changed_gtk_print_operation_status_changed, self);
	_tmp6_ = app_window_get_instance ();
	_tmp7_ = _tmp6_;
	page_window_set_busy_cursor ((PageWindow*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp8_;
	_tmp9_ = app_window_get_instance ();
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->cancellable;
	_tmp12_ = progress_dialog_new ((GtkWindow*) _tmp10_, _ ("Printing…"), _tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = _tmp12_;
	_g_object_unref0 (_tmp10_);
	err_msg = NULL;
	{
		GtkPrintOperationResult _result_ = 0;
		AppWindow* _tmp13_;
		AppWindow* _tmp14_;
		GtkPrintOperationResult _tmp15_;
		_tmp13_ = app_window_get_instance ();
		_tmp14_ = _tmp13_;
		_tmp15_ = gtk_print_operation_run ((GtkPrintOperation*) job, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) _tmp14_, &_inner_error0_);
		_g_object_unref0 (_tmp14_);
		_result_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_result_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
			GtkPageSetup* _tmp16_;
			GtkPageSetup* _tmp17_;
			_tmp16_ = gtk_print_operation_get_default_page_setup ((GtkPrintOperation*) job);
			_tmp17_ = _g_object_ref0 (_tmp16_);
			_g_object_unref0 (self->priv->user_page_setup);
			self->priv->user_page_setup = _tmp17_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		gtk_print_operation_cancel ((GtkPrintOperation*) job);
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (err_msg);
		err_msg = _tmp20_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (err_msg);
		_g_object_unref0 (job);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp21_ = self->priv->progress_dialog;
	progress_dialog_close (_tmp21_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = NULL;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
	_tmp22_ = app_window_get_instance ();
	_tmp23_ = _tmp22_;
	page_window_set_normal_cursor ((PageWindow*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = err_msg;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = err_msg;
		_tmp26_ = g_strdup_printf (_ ("Unable to print photo:\n\n%s"), _tmp25_);
		_tmp27_ = _tmp26_;
		app_window_error_message (_tmp27_, NULL, NULL);
		_g_free0 (_tmp27_);
	}
	_g_free0 (err_msg);
	_g_object_unref0 (job);
}

static void
print_manager_on_begin_print (PrintManager* self,
                              GtkPrintOperation* emitting_object,
                              GtkPrintContext* job_context)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GeeList* photos = NULL;
	PrintJob* _tmp5_;
	GeeList* _tmp6_;
	PrintJob* _tmp7_;
	PrintSettings* _tmp8_;
	PrintSettings* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (emitting_object != NULL);
	g_return_if_fail (job_context != NULL);
	g_debug ("Printing.vala:442: on_begin_print");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
	job = _tmp0_;
	_tmp2_ = self->priv->cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		_tmp3_ = self->priv->cancellable;
		_tmp1_ = g_cancellable_is_cancelled (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PrintJob* _tmp4_;
		_tmp4_ = job;
		gtk_print_operation_cancel ((GtkPrintOperation*) _tmp4_);
		_g_object_unref0 (job);
		return;
	}
	_tmp5_ = job;
	_tmp6_ = print_job_get_photos (_tmp5_);
	photos = _tmp6_;
	_tmp7_ = job;
	_tmp8_ = print_job_get_local_settings (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = print_settings_get_content_layout (_tmp9_) == CONTENT_LAYOUT_IMAGE_PER_PAGE;
	_print_settings_unref0 (_tmp9_);
	if (_tmp10_) {
		PrintLayout layout = 0;
		PrintJob* _tmp11_;
		PrintSettings* _tmp12_;
		PrintSettings* _tmp13_;
		PrintLayout _tmp14_;
		PrintJob* _tmp15_;
		GeeList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp11_ = job;
		_tmp12_ = print_job_get_local_settings (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = (PrintLayout) print_settings_get_image_per_page_selection (_tmp13_);
		_print_settings_unref0 (_tmp13_);
		layout = _tmp14_;
		_tmp15_ = job;
		_tmp16_ = photos;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		gtk_print_operation_set_n_pages ((GtkPrintOperation*) _tmp15_, (gint) ceil (((gdouble) _tmp18_) / ((gdouble) print_layout_get_per_page (layout))));
	} else {
		PrintJob* _tmp19_;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = job;
		_tmp20_ = photos;
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		gtk_print_operation_set_n_pages ((GtkPrintOperation*) _tmp19_, _tmp22_);
	}
	spin_event_loop ();
	_g_object_unref0 (photos);
	_g_object_unref0 (job);
}

static void
print_manager_on_status_changed (PrintManager* self,
                                 GtkPrintOperation* job)
{
	const gchar* _tmp0_;
	ProgressDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	_tmp0_ = gtk_print_operation_get_status_string (job);
	g_debug ("Printing.vala:465: on_status_changed: %s", _tmp0_);
	_tmp1_ = self->priv->progress_dialog;
	if (_tmp1_ != NULL) {
		ProgressDialog* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->progress_dialog;
		_tmp3_ = gtk_print_operation_get_status_string (job);
		progress_dialog_set_status (_tmp2_, _tmp3_);
		spin_event_loop ();
	}
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static void
print_manager_on_draw_page (PrintManager* self,
                            GtkPrintOperation* emitting_object,
                            GtkPrintContext* job_context,
                            gint page_num)
{
	PrintJob* job = NULL;
	PrintJob* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	GtkPageSetup* page_setup = NULL;
	GtkPageSetup* _tmp5_;
	GtkPageSetup* _tmp6_;
	gdouble page_width = 0.0;
	GtkPageSetup* _tmp7_;
	gdouble page_height = 0.0;
	GtkPageSetup* _tmp8_;
	gdouble dpi = 0.0;
	PrintJob* _tmp9_;
	PrintSettings* _tmp10_;
	PrintSettings* _tmp11_;
	gdouble _tmp12_;
	gdouble inv_dpi = 0.0;
	cairo_t* dc = NULL;
	cairo_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	GeeList* photos = NULL;
	PrintJob* _tmp16_;
	GeeList* _tmp17_;
	ContentLayout content_layout = 0;
	PrintJob* _tmp18_;
	PrintSettings* _tmp19_;
	PrintSettings* _tmp20_;
	ContentLayout _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (emitting_object != NULL);
	g_return_if_fail (job_context != NULL);
	g_debug ("Printing.vala:475: on_draw_page");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
	job = _tmp0_;
	_tmp2_ = self->priv->cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		_tmp3_ = self->priv->cancellable;
		_tmp1_ = g_cancellable_is_cancelled (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PrintJob* _tmp4_;
		_tmp4_ = job;
		gtk_print_operation_cancel ((GtkPrintOperation*) _tmp4_);
		_g_object_unref0 (job);
		return;
	}
	spin_event_loop ();
	_tmp5_ = gtk_print_context_get_page_setup (job_context);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	page_setup = _tmp6_;
	_tmp7_ = page_setup;
	page_width = gtk_page_setup_get_page_width (_tmp7_, GTK_UNIT_INCH);
	_tmp8_ = page_setup;
	page_height = gtk_page_setup_get_page_height (_tmp8_, GTK_UNIT_INCH);
	_tmp9_ = job;
	_tmp10_ = print_job_get_local_settings (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = (gdouble) print_settings_get_content_ppi (_tmp11_);
	_print_settings_unref0 (_tmp11_);
	dpi = _tmp12_;
	inv_dpi = 1.0 / dpi;
	_tmp13_ = gtk_print_context_get_cairo_context (job_context);
	_tmp14_ = _cairo_reference0 (_tmp13_);
	dc = _tmp14_;
	_tmp15_ = dc;
	cairo_scale (_tmp15_, inv_dpi, inv_dpi);
	_tmp16_ = job;
	_tmp17_ = print_job_get_photos (_tmp16_);
	photos = _tmp17_;
	_tmp18_ = job;
	_tmp19_ = print_job_get_local_settings (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = print_settings_get_content_layout (_tmp20_);
	_print_settings_unref0 (_tmp20_);
	content_layout = _tmp21_;
	switch (content_layout) {
		case CONTENT_LAYOUT_STANDARD_SIZE:
		case CONTENT_LAYOUT_CUSTOM_SIZE:
		{
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			GeeList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			ProgressDialog* _tmp70_;
			if (content_layout == CONTENT_LAYOUT_STANDARD_SIZE) {
				gint _tmp22_ = 0;
				StandardPrintSize** _tmp23_;
				StandardPrintSize** _tmp24_;
				gint _tmp24__length1;
				PrintJob* _tmp25_;
				PrintSettings* _tmp26_;
				PrintSettings* _tmp27_;
				StandardPrintSize* _tmp28_;
				Measurement _tmp29_ = {0};
				gint _tmp30_ = 0;
				StandardPrintSize** _tmp31_;
				StandardPrintSize** _tmp32_;
				gint _tmp32__length1;
				PrintJob* _tmp33_;
				PrintSettings* _tmp34_;
				PrintSettings* _tmp35_;
				StandardPrintSize* _tmp36_;
				Measurement _tmp37_ = {0};
				_tmp23_ = print_manager_get_standard_sizes (self, &_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp24__length1 = _tmp22_;
				_tmp25_ = job;
				_tmp26_ = print_job_get_local_settings (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp24_[print_settings_get_size_selection (_tmp27_)];
				measurement_convert_to (&_tmp28_->width, MEASUREMENT_UNIT_INCHES, &_tmp29_);
				canvas_width = _tmp29_.value;
				_print_settings_unref0 (_tmp27_);
				_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) standard_print_size_unref), NULL);
				_tmp31_ = print_manager_get_standard_sizes (self, &_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp32__length1 = _tmp30_;
				_tmp33_ = job;
				_tmp34_ = print_job_get_local_settings (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = _tmp32_[print_settings_get_size_selection (_tmp35_)];
				measurement_convert_to (&_tmp36_->height, MEASUREMENT_UNIT_INCHES, &_tmp37_);
				canvas_height = _tmp37_.value;
				_print_settings_unref0 (_tmp35_);
				_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) standard_print_size_unref), NULL);
			} else {
				PrintJob* _tmp38_;
				PrintSettings* _tmp39_;
				PrintSettings* _tmp40_;
				Measurement _tmp41_ = {0};
				Measurement _tmp42_ = {0};
				PrintJob* _tmp43_;
				PrintSettings* _tmp44_;
				PrintSettings* _tmp45_;
				Measurement _tmp46_ = {0};
				Measurement _tmp47_ = {0};
				_vala_assert (content_layout == CONTENT_LAYOUT_CUSTOM_SIZE, "content_layout == ContentLayout.CUSTOM_SIZE");
				_tmp38_ = job;
				_tmp39_ = print_job_get_local_settings (_tmp38_);
				_tmp40_ = _tmp39_;
				print_settings_get_content_width (_tmp40_, &_tmp41_);
				measurement_convert_to (&_tmp41_, MEASUREMENT_UNIT_INCHES, &_tmp42_);
				canvas_width = _tmp42_.value;
				_print_settings_unref0 (_tmp40_);
				_tmp43_ = job;
				_tmp44_ = print_job_get_local_settings (_tmp43_);
				_tmp45_ = _tmp44_;
				print_settings_get_content_height (_tmp45_, &_tmp46_);
				measurement_convert_to (&_tmp46_, MEASUREMENT_UNIT_INCHES, &_tmp47_);
				canvas_height = _tmp47_.value;
				_print_settings_unref0 (_tmp45_);
			}
			_tmp48_ = photos;
			_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (page_num < _tmp50_) {
				Dimensions photo_dimensions = {0};
				GeeList* _tmp51_;
				gpointer _tmp52_;
				Photo* _tmp53_;
				Dimensions _tmp54_ = {0};
				Dimensions _tmp55_;
				gdouble photo_aspect_ratio = 0.0;
				gdouble canvas_aspect_ratio = 0.0;
				gdouble dx = 0.0;
				gdouble dy = 0.0;
				GeeList* _tmp56_;
				gpointer _tmp57_;
				Photo* _tmp58_;
				PrintJob* _tmp59_;
				PrintJob* _tmp60_;
				PrintSettings* _tmp61_;
				PrintSettings* _tmp62_;
				gboolean _tmp63_;
				_tmp51_ = photos;
				_tmp52_ = gee_list_get (_tmp51_, page_num);
				_tmp53_ = (Photo*) _tmp52_;
				media_source_get_dimensions ((MediaSource*) _tmp53_, PHOTO_EXCEPTION_NONE, &_tmp54_);
				_tmp55_ = _tmp54_;
				_g_object_unref0 (_tmp53_);
				photo_dimensions = _tmp55_;
				photo_aspect_ratio = dimensions_get_aspect_ratio (&photo_dimensions);
				canvas_aspect_ratio = ((gdouble) canvas_width) / canvas_height;
				if (floor (canvas_aspect_ratio) != floor (photo_aspect_ratio)) {
					gdouble canvas_tmp = 0.0;
					canvas_tmp = canvas_width;
					canvas_width = canvas_height;
					canvas_height = canvas_tmp;
				}
				dx = (page_width - canvas_width) / 2.0;
				dy = (page_height - canvas_height) / 2.0;
				_tmp56_ = photos;
				_tmp57_ = gee_list_get (_tmp56_, page_num);
				_tmp58_ = (Photo*) _tmp57_;
				_tmp59_ = job;
				print_manager_fit_image_to_canvas (self, _tmp58_, dx, dy, canvas_width, canvas_height, TRUE, _tmp59_, job_context);
				_g_object_unref0 (_tmp58_);
				_tmp60_ = job;
				_tmp61_ = print_job_get_local_settings (_tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = print_settings_is_print_titles_enabled (_tmp62_);
				_print_settings_unref0 (_tmp62_);
				if (_tmp63_) {
					GeeList* _tmp64_;
					gpointer _tmp65_;
					Photo* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					PrintJob* _tmp69_;
					_tmp64_ = photos;
					_tmp65_ = gee_list_get (_tmp64_, page_num);
					_tmp66_ = (Photo*) _tmp65_;
					_tmp67_ = data_object_get_name ((DataObject*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = job;
					print_manager_add_title_to_canvas (self, page_width / 2, page_height, _tmp68_, _tmp69_, job_context);
					_g_free0 (_tmp68_);
					_g_object_unref0 (_tmp66_);
				}
			}
			_tmp70_ = self->priv->progress_dialog;
			if (_tmp70_ != NULL) {
				ProgressDialog* _tmp71_;
				GeeList* _tmp72_;
				gint _tmp73_;
				gint _tmp74_;
				_tmp71_ = self->priv->progress_dialog;
				_tmp72_ = photos;
				_tmp73_ = gee_collection_get_size ((GeeCollection*) _tmp72_);
				_tmp74_ = _tmp73_;
				progress_dialog_monitor (_tmp71_, (guint64) page_num, (guint64) _tmp74_, TRUE);
			}
			break;
		}
		case CONTENT_LAYOUT_IMAGE_PER_PAGE:
		{
			PrintLayout layout = 0;
			PrintJob* _tmp75_;
			PrintSettings* _tmp76_;
			PrintSettings* _tmp77_;
			PrintLayout _tmp78_;
			gint nx = 0;
			gint ny = 0;
			gint start = 0;
			gdouble canvas_width = 0.0;
			gdouble canvas_height = 0.0;
			_tmp75_ = job;
			_tmp76_ = print_job_get_local_settings (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = (PrintLayout) print_settings_get_image_per_page_selection (_tmp77_);
			_print_settings_unref0 (_tmp77_);
			layout = _tmp78_;
			nx = print_layout_get_x (layout);
			ny = print_layout_get_y (layout);
			start = page_num * print_layout_get_per_page (layout);
			canvas_width = ((gdouble) (page_width - (PRINT_MANAGER_IMAGE_DISTANCE * (nx - 1)))) / nx;
			canvas_height = ((gdouble) (page_height - (PRINT_MANAGER_IMAGE_DISTANCE * (ny - 1)))) / ny;
			{
				gint y = 0;
				y = 0;
				{
					gboolean _tmp79_ = FALSE;
					_tmp79_ = TRUE;
					while (TRUE) {
						if (!_tmp79_) {
							gint _tmp80_;
							_tmp80_ = y;
							y = _tmp80_ + 1;
						}
						_tmp79_ = FALSE;
						if (!(y < ny)) {
							break;
						}
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp81_ = FALSE;
								_tmp81_ = TRUE;
								while (TRUE) {
									gint i = 0;
									GeeList* _tmp83_;
									gint _tmp84_;
									gint _tmp85_;
									ProgressDialog* _tmp100_;
									if (!_tmp81_) {
										gint _tmp82_;
										_tmp82_ = x;
										x = _tmp82_ + 1;
									}
									_tmp81_ = FALSE;
									if (!(x < nx)) {
										break;
									}
									i = (start + (y * nx)) + x;
									_tmp83_ = photos;
									_tmp84_ = gee_collection_get_size ((GeeCollection*) _tmp83_);
									_tmp85_ = _tmp84_;
									if (i < _tmp85_) {
										gdouble dx = 0.0;
										gdouble dy = 0.0;
										GeeList* _tmp86_;
										gpointer _tmp87_;
										Photo* _tmp88_;
										PrintJob* _tmp89_;
										PrintJob* _tmp90_;
										PrintSettings* _tmp91_;
										PrintSettings* _tmp92_;
										gboolean _tmp93_;
										dx = (x * canvas_width) + (x * PRINT_MANAGER_IMAGE_DISTANCE);
										dy = (y * canvas_height) + (y * PRINT_MANAGER_IMAGE_DISTANCE);
										_tmp86_ = photos;
										_tmp87_ = gee_list_get (_tmp86_, i);
										_tmp88_ = (Photo*) _tmp87_;
										_tmp89_ = job;
										print_manager_fit_image_to_canvas (self, _tmp88_, dx, dy, canvas_width, canvas_height, FALSE, _tmp89_, job_context);
										_g_object_unref0 (_tmp88_);
										_tmp90_ = job;
										_tmp91_ = print_job_get_local_settings (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = print_settings_is_print_titles_enabled (_tmp92_);
										_print_settings_unref0 (_tmp92_);
										if (_tmp93_) {
											GeeList* _tmp94_;
											gpointer _tmp95_;
											Photo* _tmp96_;
											gchar* _tmp97_;
											gchar* _tmp98_;
											PrintJob* _tmp99_;
											_tmp94_ = photos;
											_tmp95_ = gee_list_get (_tmp94_, i);
											_tmp96_ = (Photo*) _tmp95_;
											_tmp97_ = data_object_get_name ((DataObject*) _tmp96_);
											_tmp98_ = _tmp97_;
											_tmp99_ = job;
											print_manager_add_title_to_canvas (self, dx + (canvas_width / 2), dy + canvas_height, _tmp98_, _tmp99_, job_context);
											_g_free0 (_tmp98_);
											_g_object_unref0 (_tmp96_);
										}
									}
									_tmp100_ = self->priv->progress_dialog;
									if (_tmp100_ != NULL) {
										ProgressDialog* _tmp101_;
										GeeList* _tmp102_;
										gint _tmp103_;
										gint _tmp104_;
										_tmp101_ = self->priv->progress_dialog;
										_tmp102_ = photos;
										_tmp103_ = gee_collection_get_size ((GeeCollection*) _tmp102_);
										_tmp104_ = _tmp103_;
										progress_dialog_monitor (_tmp101_, (guint64) i, (guint64) _tmp104_, TRUE);
									}
								}
							}
						}
					}
				}
			}
			break;
		}
		default:
		{
			g_error ("Printing.vala:568: unknown or unsupported layout mode");
		}
	}
	_g_object_unref0 (photos);
	_cairo_destroy0 (dc);
	_g_object_unref0 (page_setup);
	_g_object_unref0 (job);
}

static void
_print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply (GtkPrintOperation* _sender,
                                                                               GtkWidget* widget,
                                                                               gpointer self)
{
	print_manager_on_custom_widget_apply ((PrintManager*) self, widget);
}

static GObject*
print_manager_on_create_custom_widget (PrintManager* self,
                                       GtkPrintOperation* emitting_object)
{
	CustomPrintTab* _tmp0_;
	CustomPrintTab* _tmp1_;
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (emitting_object != NULL, NULL);
	_tmp0_ = custom_print_tab_new (G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->custom_tab);
	self->priv->custom_tab = _tmp0_;
	g_signal_connect ((GtkPrintOperation*) G_TYPE_CHECK_INSTANCE_CAST (emitting_object, TYPE_PRINT_JOB, PrintJob), "custom-widget-apply", (GCallback) _print_manager_on_custom_widget_apply_gtk_print_operation_custom_widget_apply, self);
	_tmp1_ = self->priv->custom_tab;
	result = (GObject*) _tmp1_;
	return result;
}

static void
print_manager_on_custom_widget_apply (PrintManager* self,
                                      GtkWidget* custom_widget)
{
	CustomPrintTab* tab = NULL;
	CustomPrintTab* _tmp0_;
	PrintJob* _tmp1_;
	PrintJob* _tmp2_;
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	PrintSettings* _tmp5_;
	PrintSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (custom_widget != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (custom_widget, TYPE_CUSTOM_PRINT_TAB, CustomPrintTab));
	tab = _tmp0_;
	_tmp1_ = custom_print_tab_get_source_job (tab);
	_tmp2_ = _tmp1_;
	_tmp3_ = custom_print_tab_get_local_settings (tab);
	_tmp4_ = _tmp3_;
	print_job_set_local_settings (_tmp2_, _tmp4_);
	_print_settings_unref0 (_tmp4_);
	_tmp5_ = custom_print_tab_get_local_settings (tab);
	_tmp6_ = _tmp5_;
	print_manager_set_global_settings (self, _tmp6_);
	_print_settings_unref0 (_tmp6_);
	_g_object_unref0 (tab);
}

static void
print_manager_fit_image_to_canvas (PrintManager* self,
                                   Photo* photo,
                                   gdouble x,
                                   gdouble y,
                                   gdouble canvas_width,
                                   gdouble canvas_height,
                                   gboolean crop,
                                   PrintJob* job,
                                   GtkPrintContext* job_context)
{
	cairo_t* dc = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	Dimensions photo_dimensions = {0};
	Dimensions _tmp2_ = {0};
	gdouble photo_aspect_ratio = 0.0;
	gdouble canvas_aspect_ratio = 0.0;
	gdouble target_width = 0.0;
	gdouble target_height = 0.0;
	gdouble dpi = 0.0;
	PrintSettings* _tmp3_;
	PrintSettings* _tmp4_;
	gdouble _tmp5_;
	gdouble x_offset = 0.0;
	gdouble y_offset = 0.0;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gint w = 0;
	gint h = 0;
	Dimensions viewport = {0};
	cairo_t* _tmp40_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (photo != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (job_context != NULL);
	_tmp0_ = gtk_print_context_get_cairo_context (job_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	dc = _tmp1_;
	media_source_get_dimensions ((MediaSource*) photo, PHOTO_EXCEPTION_NONE, &_tmp2_);
	photo_dimensions = _tmp2_;
	photo_aspect_ratio = dimensions_get_aspect_ratio (&photo_dimensions);
	canvas_aspect_ratio = ((gdouble) canvas_width) / canvas_height;
	target_width = 0.0;
	target_height = 0.0;
	_tmp3_ = print_job_get_local_settings (job);
	_tmp4_ = _tmp3_;
	_tmp5_ = (gdouble) print_settings_get_content_ppi (_tmp4_);
	_print_settings_unref0 (_tmp4_);
	dpi = _tmp5_;
	if (!crop) {
		if (canvas_aspect_ratio < photo_aspect_ratio) {
			target_width = canvas_width;
			target_height = target_width * (1.0 / photo_aspect_ratio);
		} else {
			target_height = canvas_height;
			target_width = target_height * photo_aspect_ratio;
		}
		x = x + ((canvas_width - target_width) / 2.0);
		y = y + ((canvas_height - target_height) / 2.0);
	}
	x_offset = dpi * x;
	y_offset = dpi * y;
	_tmp6_ = dc;
	cairo_save (_tmp6_);
	_tmp7_ = dc;
	cairo_translate (_tmp7_, x_offset, y_offset);
	w = (gint) (dpi * canvas_width);
	h = (gint) (dpi * canvas_height);
	dimensions_init (&viewport, w, h);
	{
		gboolean _tmp8_ = FALSE;
		cairo_t* _tmp35_;
		if (crop) {
			_tmp8_ = !print_manager_are_approximately_equal (self, canvas_aspect_ratio, photo_aspect_ratio);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp9_;
			Scaling _tmp10_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Scaling _tmp11_;
			GdkPixbuf* _tmp12_;
			Dimensions scaled_photo_dimensions = {0};
			GdkPixbuf* _tmp13_;
			Dimensions _tmp14_ = {0};
			gint shave_vertical = 0;
			gint shave_horizontal = 0;
			GdkPixbuf* shaved_pixbuf = NULL;
			GdkPixbuf* _tmp19_;
			Dimensions _tmp20_;
			Dimensions _tmp21_;
			GdkPixbuf* _tmp22_;
			GdkPixbuf* _tmp23_;
			GdkPixbuf* _tmp24_;
			cairo_t* _tmp25_;
			GdkPixbuf* _tmp26_;
			_tmp9_ = viewport;
			scaling_to_fill_viewport (&_tmp9_, &_tmp10_);
			pixbuf_scaling = _tmp10_;
			_tmp11_ = pixbuf_scaling;
			_tmp12_ = photo_source_get_pixbuf ((PhotoSource*) photo, &_tmp11_, &_inner_error0_);
			photo_pixbuf = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp13_ = photo_pixbuf;
			dimensions_for_pixbuf (_tmp13_, &_tmp14_);
			scaled_photo_dimensions = _tmp14_;
			shave_vertical = 0;
			shave_horizontal = 0;
			if (canvas_aspect_ratio < photo_aspect_ratio) {
				Dimensions _tmp15_;
				Dimensions _tmp16_;
				_tmp15_ = scaled_photo_dimensions;
				_tmp16_ = scaled_photo_dimensions;
				shave_vertical = (gint) ((_tmp15_.width - (_tmp16_.height * canvas_aspect_ratio)) / 2.0);
			} else {
				Dimensions _tmp17_;
				Dimensions _tmp18_;
				_tmp17_ = scaled_photo_dimensions;
				_tmp18_ = scaled_photo_dimensions;
				shave_horizontal = (gint) ((_tmp17_.height - (_tmp18_.width * (1.0 / canvas_aspect_ratio))) / 2.0);
			}
			_tmp19_ = photo_pixbuf;
			_tmp20_ = scaled_photo_dimensions;
			_tmp21_ = scaled_photo_dimensions;
			_tmp22_ = gdk_pixbuf_new_subpixbuf (_tmp19_, shave_vertical, shave_horizontal, _tmp20_.width - (2 * shave_vertical), _tmp21_.height - (2 * shave_horizontal));
			shaved_pixbuf = _tmp22_;
			_tmp23_ = shaved_pixbuf;
			_tmp24_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp23_, GDK_INTERP_HYPER, TRUE);
			_g_object_unref0 (photo_pixbuf);
			photo_pixbuf = _tmp24_;
			_tmp25_ = dc;
			_tmp26_ = photo_pixbuf;
			gdk_cairo_set_source_pixbuf (_tmp25_, _tmp26_, 0.0, 0.0);
			_g_object_unref0 (shaved_pixbuf);
			_g_object_unref0 (photo_pixbuf);
		} else {
			Scaling pixbuf_scaling = {0};
			Dimensions _tmp27_;
			Scaling _tmp28_ = {0};
			GdkPixbuf* photo_pixbuf = NULL;
			Scaling _tmp29_;
			GdkPixbuf* _tmp30_;
			GdkPixbuf* _tmp31_;
			GdkPixbuf* _tmp32_;
			cairo_t* _tmp33_;
			GdkPixbuf* _tmp34_;
			_tmp27_ = viewport;
			scaling_for_viewport (&_tmp27_, TRUE, &_tmp28_);
			pixbuf_scaling = _tmp28_;
			_tmp29_ = pixbuf_scaling;
			_tmp30_ = photo_source_get_pixbuf ((PhotoSource*) photo, &_tmp29_, &_inner_error0_);
			photo_pixbuf = _tmp30_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp31_ = photo_pixbuf;
			_tmp32_ = scaling_perform_on_pixbuf (&pixbuf_scaling, _tmp31_, GDK_INTERP_HYPER, TRUE);
			_g_object_unref0 (photo_pixbuf);
			photo_pixbuf = _tmp32_;
			_tmp33_ = dc;
			_tmp34_ = photo_pixbuf;
			gdk_cairo_set_source_pixbuf (_tmp33_, _tmp34_, 0.0, 0.0);
			_g_object_unref0 (photo_pixbuf);
		}
		_tmp35_ = dc;
		cairo_paint (_tmp35_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		gtk_print_operation_cancel ((GtkPrintOperation*) job);
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		_tmp38_ = g_strdup_printf (_ ("Unable to print photo:\n\n%s"), _tmp37_);
		_tmp39_ = _tmp38_;
		app_window_error_message (_tmp39_, NULL, NULL);
		_g_free0 (_tmp39_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (dc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp40_ = dc;
	cairo_restore (_tmp40_);
	_cairo_destroy0 (dc);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
print_manager_add_title_to_canvas (PrintManager* self,
                                   gdouble x,
                                   gdouble y,
                                   const gchar* title,
                                   PrintJob* job,
                                   GtkPrintContext* job_context)
{
	cairo_t* dc = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	gdouble dpi = 0.0;
	PrintSettings* _tmp2_;
	PrintSettings* _tmp3_;
	gdouble _tmp4_;
	PangoFontDescription* title_font_description = NULL;
	PrintSettings* _tmp5_;
	PrintSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoFontDescription* _tmp10_;
	PangoLayout* title_layout = NULL;
	PangoLayout* _tmp11_;
	PangoContext* context = NULL;
	PangoContext* _tmp12_;
	PangoContext* _tmp13_;
	gint title_width = 0;
	gint title_height = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (job_context != NULL);
	_tmp0_ = gtk_print_context_get_cairo_context (job_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	dc = _tmp1_;
	_tmp2_ = print_job_get_local_settings (job);
	_tmp3_ = _tmp2_;
	_tmp4_ = (gdouble) print_settings_get_content_ppi (_tmp3_);
	_print_settings_unref0 (_tmp3_);
	dpi = _tmp4_;
	_tmp5_ = print_job_get_local_settings (job);
	_tmp6_ = _tmp5_;
	_tmp7_ = print_settings_get_print_titles_font (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = pango_font_description_from_string (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_print_settings_unref0 (_tmp6_);
	title_font_description = _tmp10_;
	_tmp11_ = pango_cairo_create_layout (dc);
	title_layout = _tmp11_;
	_tmp12_ = pango_layout_get_context (title_layout);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	context = _tmp13_;
	pango_cairo_context_set_resolution (context, dpi);
	pango_layout_set_font_description (title_layout, title_font_description);
	pango_layout_set_text (title_layout, title, -1);
	pango_layout_get_pixel_size (title_layout, &_tmp14_, &_tmp15_);
	title_width = _tmp14_;
	title_height = _tmp15_;
	tx = (dpi * x) - (title_width / 2);
	ty = (dpi * y) - title_height;
	cairo_rectangle (dc, tx - 10, ty + 2, (gdouble) (title_width + 20), (gdouble) title_height);
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_set_line_width (dc, (gdouble) 2);
	cairo_stroke_preserve (dc);
	cairo_set_source_rgba (dc, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.5);
	cairo_fill (dc);
	cairo_set_source_rgba (dc, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	cairo_move_to (dc, tx, ty + 2);
	pango_cairo_show_layout (dc, title_layout);
	_g_object_unref0 (context);
	_g_object_unref0 (title_layout);
	__vala_PangoFontDescription_free0 (title_font_description);
	_cairo_destroy0 (dc);
}

static gboolean
print_manager_are_approximately_equal (PrintManager* self,
                                       gdouble val1,
                                       gdouble val2)
{
	gdouble accept_err = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	accept_err = 0.005;
	result = fabs (val1 - val2) <= accept_err;
	return result;
}

PrintSettings*
print_manager_get_global_settings (PrintManager* self)
{
	PrintSettings* _tmp0_;
	PrintSettings* _tmp1_;
	PrintSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = _print_settings_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
print_manager_set_global_settings (PrintManager* self,
                                   PrintSettings* settings)
{
	PrintSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = _print_settings_ref0 (settings);
	_print_settings_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	print_settings_save (settings);
}

static void
value_print_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_print_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		print_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_print_manager_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = print_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_print_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_print_manager_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PrintManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = print_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_print_manager_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PrintManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = print_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_print_manager (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPrintManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PRINT_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_print_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_print_manager (GValue* value,
                         gpointer v_object)
{
	PrintManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		print_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_manager_unref (old);
	}
}

void
value_take_print_manager (GValue* value,
                          gpointer v_object)
{
	PrintManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PRINT_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PRINT_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		print_manager_unref (old);
	}
}

static void
print_manager_class_init (PrintManagerClass * klass,
                          gpointer klass_data)
{
	print_manager_parent_class = g_type_class_peek_parent (klass);
	((PrintManagerClass *) klass)->finalize = print_manager_finalize;
	g_type_class_adjust_private_offset (klass, &PrintManager_private_offset);
}

static void
print_manager_instance_init (PrintManager * self,
                             gpointer klass)
{
	self->priv = print_manager_get_instance_private (self);
	self->priv->progress_dialog = NULL;
	self->priv->cancellable = NULL;
	self->ref_count = 1;
}

static void
print_manager_finalize (PrintManager * obj)
{
	PrintManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_MANAGER, PrintManager);
	g_signal_handlers_destroy (self);
	_print_settings_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->user_page_setup);
	_g_object_unref0 (self->priv->custom_tab);
	_g_object_unref0 (self->priv->progress_dialog);
	_g_object_unref0 (self->priv->cancellable);
}

static GType
print_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_print_manager_init, value_print_manager_free_value, value_print_manager_copy_value, value_print_manager_peek_pointer, "p", value_print_manager_collect_value, "p", value_print_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PrintManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintManager), 0, (GInstanceInitFunc) print_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType print_manager_type_id;
	print_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PrintManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PrintManager_private_offset = g_type_add_instance_private (print_manager_type_id, sizeof (PrintManagerPrivate));
	return print_manager_type_id;
}

GType
print_manager_get_type (void)
{
	static volatile gsize print_manager_type_id__once = 0;
	if (g_once_init_enter (&print_manager_type_id__once)) {
		GType print_manager_type_id;
		print_manager_type_id = print_manager_get_type_once ();
		g_once_init_leave (&print_manager_type_id__once, print_manager_type_id);
	}
	return print_manager_type_id__once;
}

gpointer
print_manager_ref (gpointer instance)
{
	PrintManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
print_manager_unref (gpointer instance)
{
	PrintManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PRINT_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

