/* VideoMonitor.c generated by valac 0.56.18, the Vala compiler
 * generated from VideoMonitor.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define VIDEO_MONITOR_MAX_INTERPRETABLE_CHECKS_PER_CYCLE 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_VIDEO_UPDATES (video_updates_get_type ())
#define VIDEO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_UPDATES, VideoUpdates))
#define VIDEO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_UPDATES, VideoUpdatesClass))
#define IS_VIDEO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_UPDATES))
#define IS_VIDEO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_UPDATES))
#define VIDEO_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_UPDATES, VideoUpdatesClass))

typedef struct _VideoUpdates VideoUpdates;
typedef struct _VideoUpdatesClass VideoUpdatesClass;
typedef struct _VideoUpdatesPrivate VideoUpdatesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;
typedef struct _VideoMonitorPrivate VideoMonitorPrivate;
enum  {
	VIDEO_MONITOR_0_PROPERTY,
	VIDEO_MONITOR_NUM_PROPERTIES
};
static GParamSpec* video_monitor_properties[VIDEO_MONITOR_NUM_PROPERTIES];
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB (video_monitor_video_interpretable_check_job_get_type ())
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob))
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJobClass))
#define VIDEO_MONITOR_IS_VIDEO_INTERPRETABLE_CHECK_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB))
#define VIDEO_MONITOR_IS_VIDEO_INTERPRETABLE_CHECK_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB))
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJobClass))

typedef struct _VideoMonitorVideoInterpretableCheckJob VideoMonitorVideoInterpretableCheckJob;
typedef struct _VideoMonitorVideoInterpretableCheckJobClass VideoMonitorVideoInterpretableCheckJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _VideoMonitorVideoInterpretableCheckJobPrivate VideoMonitorVideoInterpretableCheckJobPrivate;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VideoUpdates {
	MonitorableUpdates parent_instance;
	VideoUpdatesPrivate * priv;
	Video* video;
};

struct _VideoUpdatesClass {
	MonitorableUpdatesClass parent_class;
	void (*set_check_interpretable) (VideoUpdates* self, gboolean check);
};

struct _VideoUpdatesPrivate {
	gboolean check_interpretable;
};

struct _VideoMonitor {
	MediaMonitor parent_instance;
	VideoMonitorPrivate * priv;
};

struct _VideoMonitorClass {
	MediaMonitorClass parent_class;
};

struct _VideoMonitorPrivate {
	Workers* workers;
	guint64 background_jobs;
};

struct _VideoMonitorVideoInterpretableCheckJob {
	BackgroundJob parent_instance;
	VideoMonitorVideoInterpretableCheckJobPrivate * priv;
	Video* video;
	VideoInterpretableResults* results;
};

struct _VideoMonitorVideoInterpretableCheckJobClass {
	BackgroundJobClass parent_class;
};

static gint VideoUpdates_private_offset;
static gpointer video_updates_parent_class = NULL;
static gint VideoMonitor_private_offset;
static gpointer video_monitor_parent_class = NULL;
static gpointer video_monitor_video_interpretable_check_job_parent_class = NULL;

VALA_EXTERN GType video_updates_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void video_updates_set_check_interpretable (VideoUpdates* self,
                                            gboolean check);
VALA_EXTERN VideoUpdates* video_updates_new (Video* video);
VALA_EXTERN VideoUpdates* video_updates_construct (GType object_type,
                                       Video* video);
static void video_updates_real_set_check_interpretable (VideoUpdates* self,
                                                 gboolean check);
static void video_updates_real_mark_online (MonitorableUpdates* base);
VALA_EXTERN gboolean video_updates_is_check_interpretable (VideoUpdates* self);
static gboolean video_updates_real_is_all_updated (MonitorableUpdates* base);
static void video_updates_finalize (MonitorableUpdates * obj);
static GType video_updates_get_type_once (void);
VALA_EXTERN GType video_monitor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoMonitor* video_monitor_new (GCancellable* cancellable);
VALA_EXTERN VideoMonitor* video_monitor_construct (GType object_type,
                                       GCancellable* cancellable);
VALA_EXTERN void video_monitor_set_check_interpretable (VideoMonitor* self,
                                            Video* video,
                                            gboolean check);
static MonitorableUpdates* video_monitor_real_create_updates (MediaMonitor* base,
                                                       Monitorable* monitorable);
static MediaSourceCollection* video_monitor_real_get_media_source_collection (MediaMonitor* base);
static gboolean video_monitor_real_is_file_represented (MediaMonitor* base,
                                                 GFile* file);
static Video* video_monitor_get_state (VideoMonitor* self,
                                GFile* file,
                                VideoSourceCollectionState* state);
static MediaMonitorDiscoveredFile video_monitor_real_notify_file_discovered (MediaMonitor* base,
                                                                      GFile* file,
                                                                      GFileInfo* info,
                                                                      Monitorable** monitorable);
static GeeCollection* video_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                               GFile* file,
                                                               GFileInfo* info,
                                                               MediaMonitorDiscoveredFile* _result_);
static gboolean video_monitor_real_notify_file_created (MediaMonitor* base,
                                                 GFile* file,
                                                 GFileInfo* info);
static gboolean video_monitor_real_notify_file_moved (MediaMonitor* base,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* new_file_info);
static gboolean video_monitor_real_notify_file_altered (MediaMonitor* base,
                                                 GFile* file);
static gboolean video_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                            GFile* file);
static gboolean video_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                              GFile* file,
                                                              GFileInfo* info);
static gboolean video_monitor_real_notify_file_deleted (MediaMonitor* base,
                                                 GFile* file);
VALA_EXTERN VideoUpdates* video_monitor_get_existing_video_updates (VideoMonitor* self,
                                                        Video* video);
VALA_EXTERN VideoUpdates* video_monitor_fetch_video_updates (VideoMonitor* self,
                                                 Video* video);
static void video_monitor_real_process_updates (MediaMonitor* base,
                                         GeeCollection* all_updates,
                                         TransactionController* controller,
                                         gint* op_count,
                                         GError** error);
static void video_monitor_on_interpretable_check_complete (VideoMonitor* self,
                                                    BackgroundJob* j);
static void _video_monitor_on_interpretable_check_complete_completion_callback (BackgroundJob* job,
                                                                         gpointer self);
static VideoMonitorVideoInterpretableCheckJob* video_monitor_video_interpretable_check_job_new (Video* video,
                                                                                         CompletionCallback callback,
                                                                                         gpointer callback_target);
static VideoMonitorVideoInterpretableCheckJob* video_monitor_video_interpretable_check_job_construct (GType object_type,
                                                                                               Video* video,
                                                                                               CompletionCallback callback,
                                                                                               gpointer callback_target);
static GType video_monitor_video_interpretable_check_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void video_monitor_video_interpretable_check_job_real_execute (BackgroundJob* base);
static void video_monitor_video_interpretable_check_job_finalize (BackgroundJob * obj);
static GType video_monitor_video_interpretable_check_job_get_type_once (void);
static void video_monitor_finalize (GObject * obj);
static GType video_monitor_get_type_once (void);

static inline gpointer
video_updates_get_instance_private (VideoUpdates* self)
{
	return G_STRUCT_MEMBER_P (self, VideoUpdates_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

VideoUpdates*
video_updates_construct (GType object_type,
                         Video* video)
{
	VideoUpdates* self = NULL;
	Video* _tmp0_;
	g_return_val_if_fail (video != NULL, NULL);
	self = (VideoUpdates*) monitorable_updates_construct (object_type, (Monitorable*) video);
	_tmp0_ = _g_object_ref0 (video);
	_g_object_unref0 (self->video);
	self->video = _tmp0_;
	return self;
}

VideoUpdates*
video_updates_new (Video* video)
{
	return video_updates_construct (TYPE_VIDEO_UPDATES, video);
}

static void
video_updates_real_set_check_interpretable (VideoUpdates* self,
                                            gboolean check)
{
	self->priv->check_interpretable = check;
}

void
video_updates_set_check_interpretable (VideoUpdates* self,
                                       gboolean check)
{
	VideoUpdatesClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIDEO_UPDATES_GET_CLASS (self);
	if (_klass_->set_check_interpretable) {
		_klass_->set_check_interpretable (self, check);
	}
}

static void
video_updates_real_mark_online (MonitorableUpdates* base)
{
	VideoUpdates * self;
	self = (VideoUpdates*) base;
	MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	video_updates_set_check_interpretable (self, TRUE);
}

gboolean
video_updates_is_check_interpretable (VideoUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->check_interpretable;
	return result;
}

static gboolean
video_updates_real_is_all_updated (MonitorableUpdates* base)
{
	VideoUpdates * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (VideoUpdates*) base;
	if (self->priv->check_interpretable == FALSE) {
		_tmp0_ = MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->is_all_updated (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
video_updates_class_init (VideoUpdatesClass * klass,
                          gpointer klass_data)
{
	video_updates_parent_class = g_type_class_peek_parent (klass);
	((MonitorableUpdatesClass *) klass)->finalize = video_updates_finalize;
	g_type_class_adjust_private_offset (klass, &VideoUpdates_private_offset);
	((VideoUpdatesClass *) klass)->set_check_interpretable = (void (*) (VideoUpdates*, gboolean)) video_updates_real_set_check_interpretable;
	((MonitorableUpdatesClass *) klass)->mark_online = (void (*) (MonitorableUpdates*)) video_updates_real_mark_online;
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*) (MonitorableUpdates*)) video_updates_real_is_all_updated;
}

static void
video_updates_instance_init (VideoUpdates * self,
                             gpointer klass)
{
	self->priv = video_updates_get_instance_private (self);
	self->priv->check_interpretable = FALSE;
}

static void
video_updates_finalize (MonitorableUpdates * obj)
{
	VideoUpdates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_UPDATES, VideoUpdates);
	_g_object_unref0 (self->video);
	MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->finalize (obj);
}

static GType
video_updates_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoUpdates), 0, (GInstanceInitFunc) video_updates_instance_init, NULL };
	GType video_updates_type_id;
	video_updates_type_id = g_type_register_static (TYPE_MONITORABLE_UPDATES, "VideoUpdates", &g_define_type_info, 0);
	VideoUpdates_private_offset = g_type_add_instance_private (video_updates_type_id, sizeof (VideoUpdatesPrivate));
	return video_updates_type_id;
}

GType
video_updates_get_type (void)
{
	static volatile gsize video_updates_type_id__once = 0;
	if (g_once_init_enter (&video_updates_type_id__once)) {
		GType video_updates_type_id;
		video_updates_type_id = video_updates_get_type_once ();
		g_once_init_leave (&video_updates_type_id__once, video_updates_type_id);
	}
	return video_updates_type_id__once;
}

static inline gpointer
video_monitor_get_instance_private (VideoMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, VideoMonitor_private_offset);
}

VideoMonitor*
video_monitor_construct (GType object_type,
                         GCancellable* cancellable)
{
	VideoMonitor * self = NULL;
	VideoSourceCollection* _tmp0_;
	g_return_val_if_fail (cancellable != NULL, NULL);
	_tmp0_ = video_global;
	self = (VideoMonitor*) media_monitor_construct (object_type, (MediaSourceCollection*) _tmp0_, cancellable);
	{
		GeeIterator* _obj_it = NULL;
		VideoSourceCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = video_global;
		_tmp2_ = data_collection_get_all ((DataCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_obj_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			DataObject* obj = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			Video* video = NULL;
			DataObject* _tmp9_;
			Video* _tmp10_;
			Video* _tmp11_;
			Video* _tmp12_;
			_tmp6_ = _obj_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _obj_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			obj = (DataObject*) _tmp8_;
			_tmp9_ = obj;
			_tmp10_ = _g_object_ref0 (IS_VIDEO (_tmp9_) ? ((Video*) _tmp9_) : NULL);
			video = _tmp10_;
			_tmp11_ = video;
			_vala_assert (_tmp11_ != NULL, "video != null");
			_tmp12_ = video;
			if (!video_get_is_interpretable (_tmp12_)) {
				Video* _tmp13_;
				_tmp13_ = video;
				video_monitor_set_check_interpretable (self, _tmp13_, TRUE);
			}
			_g_object_unref0 (video);
			_g_object_unref0 (obj);
		}
		_g_object_unref0 (_obj_it);
	}
	return self;
}

VideoMonitor*
video_monitor_new (GCancellable* cancellable)
{
	return video_monitor_construct (TYPE_VIDEO_MONITOR, cancellable);
}

static MonitorableUpdates*
video_monitor_real_create_updates (MediaMonitor* base,
                                   Monitorable* monitorable)
{
	VideoMonitor * self;
	VideoUpdates* _tmp0_;
	MonitorableUpdates* result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (monitorable != NULL, NULL);
	_vala_assert (IS_VIDEO (monitorable), "monitorable is Video");
	_tmp0_ = video_updates_new (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_VIDEO, Video));
	result = (MonitorableUpdates*) _tmp0_;
	return result;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static MediaSourceCollection*
video_monitor_real_get_media_source_collection (MediaMonitor* base)
{
	VideoMonitor * self;
	VideoSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
	MediaSourceCollection* result;
	self = (VideoMonitor*) base;
	_tmp0_ = video_global;
	_tmp1_ = _data_collection_ref0 ((MediaSourceCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
video_monitor_real_is_file_represented (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static MediaMonitorDiscoveredFile
video_monitor_real_notify_file_discovered (MediaMonitor* base,
                                           GFile* file,
                                           GFileInfo* info,
                                           Monitorable** monitorable)
{
	VideoMonitor * self;
	Monitorable* _vala_monitorable = NULL;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	MediaMonitorDiscoveredFile result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, 0);
	g_return_val_if_fail (info != NULL, 0);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_vala_monitorable);
		_vala_monitorable = NULL;
		result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
		_g_object_unref0 (video);
		if (monitorable) {
			*monitorable = _vala_monitorable;
		} else {
			_g_object_unref0 (_vala_monitorable);
		}
		return result;
	}
	switch (state) {
		case VIDEO_SOURCE_COLLECTION_STATE_ONLINE:
		case VIDEO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			Video* _tmp3_;
			Monitorable* _tmp4_;
			_tmp3_ = video;
			_tmp4_ = _g_object_ref0 ((Monitorable*) _tmp3_);
			_g_object_unref0 (_vala_monitorable);
			_vala_monitorable = _tmp4_;
			result = MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED;
			_g_object_unref0 (video);
			if (monitorable) {
				*monitorable = _vala_monitorable;
			} else {
				_g_object_unref0 (_vala_monitorable);
			}
			return result;
		}
		default:
		case VIDEO_SOURCE_COLLECTION_STATE_TRASH:
		{
			_g_object_unref0 (_vala_monitorable);
			_vala_monitorable = NULL;
			result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
			_g_object_unref0 (video);
			if (monitorable) {
				*monitorable = _vala_monitorable;
			} else {
				_g_object_unref0 (_vala_monitorable);
			}
			return result;
		}
	}
}

static GeeCollection*
video_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                GFile* file,
                                                GFileInfo* info,
                                                MediaMonitorDiscoveredFile* _result_)
{
	VideoMonitor * self;
	MediaMonitorDiscoveredFile _vala__result_ = 0;
	GeeCollection* matched = NULL;
	GeeArrayList* _tmp0_;
	VideoSourceCollection* _tmp1_;
	GeeCollection* result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	matched = (GeeCollection*) _tmp0_;
	_tmp1_ = video_global;
	video_source_collection_fetch_by_matching_backing (_tmp1_, info, matched);
	_vala__result_ = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
	result = matched;
	if (_result_) {
		*_result_ = _vala__result_;
	}
	return result;
}

static gboolean
video_monitor_real_notify_file_created (MediaMonitor* base,
                                        GFile* file,
                                        GFileInfo* info)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_online ((MediaMonitor*) self, (Monitorable*) _tmp3_);
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static gboolean
video_monitor_real_notify_file_moved (MediaMonitor* base,
                                      GFile* old_file,
                                      GFile* new_file,
                                      GFileInfo* new_file_info)
{
	VideoMonitor * self;
	VideoSourceCollectionState old_state = 0;
	Video* old_video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	VideoSourceCollectionState new_state = 0;
	Video* new_video = NULL;
	VideoSourceCollectionState _tmp2_ = 0;
	Video* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Video* _tmp5_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (old_file != NULL, FALSE);
	g_return_val_if_fail (new_file != NULL, FALSE);
	g_return_val_if_fail (new_file_info != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, old_file, &_tmp0_);
	old_state = _tmp0_;
	old_video = _tmp1_;
	_tmp3_ = video_monitor_get_state (self, new_file, &_tmp2_);
	new_state = _tmp2_;
	new_video = _tmp3_;
	_tmp5_ = old_video;
	if (_tmp5_ != NULL) {
		Video* _tmp6_;
		_tmp6_ = new_video;
		_tmp4_ = _tmp6_ == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Video* _tmp7_;
		_tmp7_ = old_video;
		media_monitor_update_master_file ((MediaMonitor*) self, (Monitorable*) _tmp7_, new_file);
	} else {
		gboolean _tmp8_ = FALSE;
		Video* _tmp9_;
		_tmp9_ = old_video;
		if (_tmp9_ == NULL) {
			Video* _tmp10_;
			_tmp10_ = new_video;
			_tmp8_ = _tmp10_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Video* _tmp11_;
			_tmp11_ = new_video;
			video_monitor_set_check_interpretable (self, _tmp11_, TRUE);
		} else {
			gboolean _tmp12_ = FALSE;
			Video* _tmp13_;
			_tmp13_ = old_video;
			if (_tmp13_ == NULL) {
				Video* _tmp14_;
				_tmp14_ = new_video;
				_tmp12_ = _tmp14_ == NULL;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = FALSE;
				_g_object_unref0 (new_video);
				_g_object_unref0 (old_video);
				return result;
			} else {
				gboolean _tmp15_ = FALSE;
				Video* _tmp16_;
				Video* _tmp18_;
				Video* _tmp19_;
				_tmp16_ = old_video;
				if (_tmp16_ != NULL) {
					Video* _tmp17_;
					_tmp17_ = new_video;
					_tmp15_ = _tmp17_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				_vala_assert (_tmp15_, "old_video != null && new_video != null");
				_tmp18_ = old_video;
				media_monitor_update_offline ((MediaMonitor*) self, (Monitorable*) _tmp18_);
				_tmp19_ = new_video;
				video_monitor_set_check_interpretable (self, _tmp19_, TRUE);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (new_video);
	_g_object_unref0 (old_video);
	return result;
}

static gboolean
video_monitor_real_notify_file_altered (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
video_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                   GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	Video* _tmp4_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_master_file_info_altered ((MediaMonitor*) self, (Monitorable*) _tmp3_);
	_tmp4_ = video;
	media_monitor_update_master_file_in_alteration ((MediaMonitor*) self, (Monitorable*) _tmp4_, TRUE);
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static gboolean
video_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                     GFile* file,
                                                     GFileInfo* info)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_master_file_alterations_completed ((MediaMonitor*) self, (Monitorable*) _tmp3_, info);
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static gboolean
video_monitor_real_notify_file_deleted (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	Video* _tmp4_;
	gboolean result;
	self = (VideoMonitor*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_master_file_in_alteration ((MediaMonitor*) self, (Monitorable*) _tmp3_, FALSE);
	_tmp4_ = video;
	media_monitor_update_offline ((MediaMonitor*) self, (Monitorable*) _tmp4_);
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static Video*
video_monitor_get_state (VideoMonitor* self,
                         GFile* file,
                         VideoSourceCollectionState* state)
{
	VideoSourceCollectionState _vala_state = 0;
	GFile* real_file = NULL;
	GFile* _tmp22_ = NULL;
	GFile* _tmp23_;
	VideoSourceCollection* _tmp24_;
	VideoSourceCollectionState _tmp25_ = 0;
	Video* _tmp26_;
	Video* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	real_file = NULL;
	{
		GeeIterator* _monitorable_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_monitor_get_monitorables ((MediaMonitor*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_monitorable_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			Monitorable* monitorable = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Video* video = NULL;
			Monitorable* _tmp7_;
			Video* _tmp8_;
			VideoUpdates* updates = NULL;
			Video* _tmp9_;
			VideoUpdates* _tmp10_;
			VideoUpdates* _tmp11_;
			gboolean _tmp12_ = FALSE;
			VideoUpdates* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
			_tmp4_ = _monitorable_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _monitorable_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			monitorable = (Monitorable*) _tmp6_;
			_tmp7_ = monitorable;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video));
			video = _tmp8_;
			_tmp9_ = video;
			_tmp10_ = video_monitor_get_existing_video_updates (self, _tmp9_);
			updates = _tmp10_;
			_tmp11_ = updates;
			if (_tmp11_ == NULL) {
				_monitorable_updates_unref0 (updates);
				_g_object_unref0 (video);
				_g_object_unref0 (monitorable);
				continue;
			}
			_tmp13_ = updates;
			_tmp14_ = monitorable_updates_get_master_file ((MonitorableUpdates*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_ != NULL;
			_g_object_unref0 (_tmp15_);
			if (_tmp16_) {
				VideoUpdates* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
				_tmp17_ = updates;
				_tmp18_ = monitorable_updates_get_master_file ((MonitorableUpdates*) _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp12_ = g_file_equal (_tmp19_, file);
				_g_object_unref0 (_tmp19_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				Video* _tmp20_;
				GFile* _tmp21_;
				_tmp20_ = video;
				_tmp21_ = media_source_get_master_file ((MediaSource*) _tmp20_);
				_g_object_unref0 (real_file);
				real_file = _tmp21_;
				_monitorable_updates_unref0 (updates);
				_g_object_unref0 (video);
				_g_object_unref0 (monitorable);
				break;
			}
			_monitorable_updates_unref0 (updates);
			_g_object_unref0 (video);
			_g_object_unref0 (monitorable);
		}
		_g_object_unref0 (_monitorable_it);
	}
	_tmp23_ = real_file;
	_tmp22_ = _tmp23_;
	if (_tmp22_ == NULL) {
		_tmp22_ = file;
	}
	_tmp24_ = video_global;
	_tmp26_ = video_source_collection_get_state_by_file (_tmp24_, _tmp22_, &_tmp25_);
	_vala_state = _tmp25_;
	result = _tmp26_;
	_g_object_unref0 (real_file);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

VideoUpdates*
video_monitor_fetch_video_updates (VideoMonitor* self,
                                   Video* video)
{
	VideoUpdates* updates = NULL;
	MonitorableUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
	VideoUpdates* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (video != NULL, NULL);
	_tmp0_ = media_monitor_fetch_updates ((MediaMonitor*) self, (Monitorable*) video);
	_tmp1_ = IS_VIDEO_UPDATES (_tmp0_) ? ((VideoUpdates*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_monitorable_updates_unref0 (_tmp0_);
	}
	updates = _tmp1_;
	_vala_assert (updates != NULL, "updates != null");
	result = updates;
	return result;
}

VideoUpdates*
video_monitor_get_existing_video_updates (VideoMonitor* self,
                                          Video* video)
{
	MonitorableUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
	VideoUpdates* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (video != NULL, NULL);
	_tmp0_ = media_monitor_get_existing_updates ((MediaMonitor*) self, (Monitorable*) video);
	_tmp1_ = IS_VIDEO_UPDATES (_tmp0_) ? ((VideoUpdates*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_monitorable_updates_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

void
video_monitor_set_check_interpretable (VideoMonitor* self,
                                       Video* video,
                                       gboolean check)
{
	VideoUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video != NULL);
	_tmp0_ = video_monitor_fetch_video_updates (self, video);
	_tmp1_ = _tmp0_;
	video_updates_set_check_interpretable (_tmp1_, check);
	_monitorable_updates_unref0 (_tmp1_);
}

static gpointer
_monitorable_updates_ref0 (gpointer self)
{
	return self ? monitorable_updates_ref (self) : NULL;
}

static void
_video_monitor_on_interpretable_check_complete_completion_callback (BackgroundJob* job,
                                                                    gpointer self)
{
	video_monitor_on_interpretable_check_complete ((VideoMonitor*) self, job);
}

static void
video_monitor_real_process_updates (MediaMonitor* base,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error)
{
	VideoMonitor * self;
	GeeArrayList* check = NULL;
	GeeArrayList* _tmp20_;
	GError* _inner_error0_ = NULL;
	self = (VideoMonitor*) base;
	g_return_if_fail (all_updates != NULL);
	g_return_if_fail (controller != NULL);
	MEDIA_MONITOR_CLASS (video_monitor_parent_class)->process_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), all_updates, controller, op_count, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	check = NULL;
	{
		GeeIterator* _monitorable_updates_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) all_updates);
		_monitorable_updates_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MonitorableUpdates* monitorable_updates = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			GeeArrayList* _tmp5_;
			VideoUpdates* updates = NULL;
			MonitorableUpdates* _tmp9_;
			VideoUpdates* _tmp10_;
			VideoUpdates* _tmp11_;
			VideoUpdates* _tmp12_;
			_tmp1_ = _monitorable_updates_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _monitorable_updates_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			monitorable_updates = (MonitorableUpdates*) _tmp3_;
			if ((*op_count) >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
				_monitorable_updates_unref0 (monitorable_updates);
				break;
			}
			_tmp5_ = check;
			if (_tmp5_ != NULL) {
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp6_ = check;
				_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp4_ = _tmp8_ >= VIDEO_MONITOR_MAX_INTERPRETABLE_CHECKS_PER_CYCLE;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_monitorable_updates_unref0 (monitorable_updates);
				break;
			}
			_tmp9_ = monitorable_updates;
			_tmp10_ = _monitorable_updates_ref0 (IS_VIDEO_UPDATES (_tmp9_) ? ((VideoUpdates*) _tmp9_) : NULL);
			updates = _tmp10_;
			_tmp11_ = updates;
			if (_tmp11_ == NULL) {
				_monitorable_updates_unref0 (updates);
				_monitorable_updates_unref0 (monitorable_updates);
				continue;
			}
			_tmp12_ = updates;
			if (video_updates_is_check_interpretable (_tmp12_)) {
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp15_;
				VideoUpdates* _tmp16_;
				Video* _tmp17_;
				VideoUpdates* _tmp18_;
				gint _tmp19_;
				_tmp13_ = check;
				if (_tmp13_ == NULL) {
					GeeArrayList* _tmp14_;
					_tmp14_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (check);
					check = _tmp14_;
				}
				_tmp15_ = check;
				_tmp16_ = updates;
				_tmp17_ = _tmp16_->video;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
				_tmp18_ = updates;
				video_updates_set_check_interpretable (_tmp18_, FALSE);
				_tmp19_ = *op_count;
				*op_count = _tmp19_ + 1;
			}
			_monitorable_updates_unref0 (updates);
			_monitorable_updates_unref0 (monitorable_updates);
		}
		_g_object_unref0 (_monitorable_updates_it);
	}
	_tmp20_ = check;
	if (_tmp20_ != NULL) {
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GeeArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp21_ = check;
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("Checking interpretable for %d videos", _tmp23_);
		_tmp25_ = _tmp24_;
		media_monitor_mdbg (_tmp25_);
		_g_free0 (_tmp25_);
		video_notify_offline_thumbs_regenerated ();
		_tmp26_ = check;
		_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		self->priv->background_jobs = self->priv->background_jobs + _tmp28_;
		{
			GeeArrayList* _video_list = NULL;
			GeeArrayList* _tmp29_;
			gint _video_size = 0;
			GeeArrayList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _video_index = 0;
			_tmp29_ = check;
			_video_list = _tmp29_;
			_tmp30_ = _video_list;
			_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_video_size = _tmp32_;
			_video_index = -1;
			while (TRUE) {
				gint _tmp33_;
				gint _tmp34_;
				Video* video = NULL;
				GeeArrayList* _tmp35_;
				gpointer _tmp36_;
				Workers* _tmp37_;
				Video* _tmp38_;
				VideoMonitorVideoInterpretableCheckJob* _tmp39_;
				VideoMonitorVideoInterpretableCheckJob* _tmp40_;
				_video_index = _video_index + 1;
				_tmp33_ = _video_index;
				_tmp34_ = _video_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _video_list;
				_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _video_index);
				video = (Video*) _tmp36_;
				_tmp37_ = self->priv->workers;
				_tmp38_ = video;
				_tmp39_ = video_monitor_video_interpretable_check_job_new (_tmp38_, _video_monitor_on_interpretable_check_complete_completion_callback, self);
				_tmp40_ = _tmp39_;
				workers_enqueue (_tmp37_, (BackgroundJob*) _tmp40_);
				_background_job_unref0 (_tmp40_);
				_g_object_unref0 (video);
			}
		}
	}
	_g_object_unref0 (check);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
video_monitor_on_interpretable_check_complete (VideoMonitor* self,
                                               BackgroundJob* j)
{
	VideoMonitorVideoInterpretableCheckJob* job = NULL;
	VideoMonitorVideoInterpretableCheckJob* _tmp0_;
	VideoMonitorVideoInterpretableCheckJob* _tmp1_;
	VideoInterpretableResults* _tmp2_;
	guint64 _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->results;
	video_interpretable_results_foreground_finish (_tmp2_);
	self->priv->background_jobs = self->priv->background_jobs - 1;
	_tmp3_ = self->priv->background_jobs;
	if (self->priv->background_jobs <= ((guint64) 0)) {
		video_notify_normal_thumbs_regenerated ();
	}
	_background_job_unref0 (job);
}

static VideoMonitorVideoInterpretableCheckJob*
video_monitor_video_interpretable_check_job_construct (GType object_type,
                                                       Video* video,
                                                       CompletionCallback callback,
                                                       gpointer callback_target)
{
	VideoMonitorVideoInterpretableCheckJob* self = NULL;
	Video* _tmp0_;
	g_return_val_if_fail (video != NULL, NULL);
	self = (VideoMonitorVideoInterpretableCheckJob*) background_job_construct (object_type, (GObject*) video, callback, callback_target, NULL, NULL, NULL, NULL);
	_tmp0_ = _g_object_ref0 (video);
	_g_object_unref0 (self->video);
	self->video = _tmp0_;
	return self;
}

static VideoMonitorVideoInterpretableCheckJob*
video_monitor_video_interpretable_check_job_new (Video* video,
                                                 CompletionCallback callback,
                                                 gpointer callback_target)
{
	return video_monitor_video_interpretable_check_job_construct (VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, video, callback, callback_target);
}

static void
video_monitor_video_interpretable_check_job_real_execute (BackgroundJob* base)
{
	VideoMonitorVideoInterpretableCheckJob * self;
	Video* _tmp0_;
	VideoInterpretableResults* _tmp1_;
	self = (VideoMonitorVideoInterpretableCheckJob*) base;
	_tmp0_ = self->video;
	_tmp1_ = video_check_is_interpretable (_tmp0_);
	_video_interpretable_results_unref0 (self->results);
	self->results = _tmp1_;
}

static void
video_monitor_video_interpretable_check_job_class_init (VideoMonitorVideoInterpretableCheckJobClass * klass,
                                                        gpointer klass_data)
{
	video_monitor_video_interpretable_check_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = video_monitor_video_interpretable_check_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) video_monitor_video_interpretable_check_job_real_execute;
}

static void
video_monitor_video_interpretable_check_job_instance_init (VideoMonitorVideoInterpretableCheckJob * self,
                                                           gpointer klass)
{
	self->results = NULL;
}

static void
video_monitor_video_interpretable_check_job_finalize (BackgroundJob * obj)
{
	VideoMonitorVideoInterpretableCheckJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob);
	_g_object_unref0 (self->video);
	_video_interpretable_results_unref0 (self->results);
	BACKGROUND_JOB_CLASS (video_monitor_video_interpretable_check_job_parent_class)->finalize (obj);
}

static GType
video_monitor_video_interpretable_check_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoMonitorVideoInterpretableCheckJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_monitor_video_interpretable_check_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMonitorVideoInterpretableCheckJob), 0, (GInstanceInitFunc) video_monitor_video_interpretable_check_job_instance_init, NULL };
	GType video_monitor_video_interpretable_check_job_type_id;
	video_monitor_video_interpretable_check_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "VideoMonitorVideoInterpretableCheckJob", &g_define_type_info, 0);
	return video_monitor_video_interpretable_check_job_type_id;
}

static GType
video_monitor_video_interpretable_check_job_get_type (void)
{
	static volatile gsize video_monitor_video_interpretable_check_job_type_id__once = 0;
	if (g_once_init_enter (&video_monitor_video_interpretable_check_job_type_id__once)) {
		GType video_monitor_video_interpretable_check_job_type_id;
		video_monitor_video_interpretable_check_job_type_id = video_monitor_video_interpretable_check_job_get_type_once ();
		g_once_init_leave (&video_monitor_video_interpretable_check_job_type_id__once, video_monitor_video_interpretable_check_job_type_id);
	}
	return video_monitor_video_interpretable_check_job_type_id__once;
}

static void
video_monitor_class_init (VideoMonitorClass * klass,
                          gpointer klass_data)
{
	video_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &VideoMonitor_private_offset);
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*) (MediaMonitor*, Monitorable*)) video_monitor_real_create_updates;
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*) (MediaMonitor*)) video_monitor_real_get_media_source_collection;
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_is_file_represented;
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*) (MediaMonitor*, GFile*, GFileInfo*, Monitorable**)) video_monitor_real_notify_file_discovered;
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*) (MediaMonitor*, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) video_monitor_real_candidates_for_unknown_file;
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) video_monitor_real_notify_file_created;
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*) (MediaMonitor*, GFile*, GFile*, GFileInfo*)) video_monitor_real_notify_file_moved;
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_notify_file_altered;
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_notify_file_attributes_altered;
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) video_monitor_real_notify_file_alteration_completed;
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_notify_file_deleted;
	((MediaMonitorClass *) klass)->process_updates = (void (*) (MediaMonitor*, GeeCollection*, TransactionController*, gint*, GError**)) video_monitor_real_process_updates;
	G_OBJECT_CLASS (klass)->finalize = video_monitor_finalize;
}

static void
video_monitor_instance_init (VideoMonitor * self,
                             gpointer klass)
{
	Workers* _tmp0_;
	self->priv = video_monitor_get_instance_private (self);
	_tmp0_ = workers_new (1, FALSE);
	self->priv->workers = _tmp0_;
	self->priv->background_jobs = (guint64) 0;
}

static void
video_monitor_finalize (GObject * obj)
{
	VideoMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_MONITOR, VideoMonitor);
	_workers_unref0 (self->priv->workers);
	G_OBJECT_CLASS (video_monitor_parent_class)->finalize (obj);
}

static GType
video_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMonitor), 0, (GInstanceInitFunc) video_monitor_instance_init, NULL };
	GType video_monitor_type_id;
	video_monitor_type_id = g_type_register_static (TYPE_MEDIA_MONITOR, "VideoMonitor", &g_define_type_info, 0);
	VideoMonitor_private_offset = g_type_add_instance_private (video_monitor_type_id, sizeof (VideoMonitorPrivate));
	return video_monitor_type_id;
}

GType
video_monitor_get_type (void)
{
	static volatile gsize video_monitor_type_id__once = 0;
	if (g_once_init_enter (&video_monitor_type_id__once)) {
		GType video_monitor_type_id;
		video_monitor_type_id = video_monitor_get_type_once ();
		g_once_init_leave (&video_monitor_type_id__once, video_monitor_type_id);
	}
	return video_monitor_type_id__once;
}

