/* CheckerboardPage.c generated by valac 0.56.18, the Vala compiler
 * generated from CheckerboardPage.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>

#define CHECKERBOARD_PAGE_AUTOSCROLL_PIXELS 50
#define CHECKERBOARD_PAGE_AUTOSCROLL_TICKS_MSEC 50
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CHECKERBOARD_PAGE_0_PROPERTY,
	CHECKERBOARD_PAGE_NUM_PROPERTIES
};
static GParamSpec* checkerboard_page_properties[CHECKERBOARD_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardPagePrivate {
	CheckerboardLayout* layout;
	gchar* page_sidebar_menu_path;
	GtkViewport* viewport;
	CheckerboardItem* highlighted;
	gboolean autoscroll_scheduled;
	gboolean selection_button_clicked;
	CheckerboardItem* activated_item;
	GeeArrayList* previously_selected;
};

static gint CheckerboardPage_private_offset;
static gpointer checkerboard_page_parent_class = NULL;

static gchar* checkerboard_page_real_get_back_name (CheckerboardPage* self);
static GtkMenu* checkerboard_page_real_get_item_context_menu (CheckerboardPage* self);
static gboolean checkerboard_page_real_on_context_keypress (Page* base);
static gchar* checkerboard_page_real_get_view_empty_message (CheckerboardPage* self);
static gchar* checkerboard_page_real_get_filter_no_match_message (CheckerboardPage* self);
static void checkerboard_page_real_on_item_activated (CheckerboardPage* self,
                                               CheckerboardItem* item);
static SearchViewFilter* checkerboard_page_real_get_search_view_filter (CheckerboardPage* self);
static CoreViewTracker* checkerboard_page_real_get_view_tracker (CheckerboardPage* self);
static void checkerboard_page_real_switching_from (Page* base);
static void checkerboard_page_on_view_filter_refresh (CheckerboardPage* self);
static void _checkerboard_page_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender,
                                                                    gpointer self);
static void checkerboard_page_real_switched_to (Page* base);
static void checkerboard_page_update_view_filter_message (CheckerboardPage* self);
static void checkerboard_page_on_contents_altered (CheckerboardPage* self,
                                            GeeIterable* added,
                                            GeeIterable* removed);
static void checkerboard_page_on_items_state_changed (CheckerboardPage* self,
                                               GeeIterable* changed);
static void checkerboard_page_on_items_visibility_changed (CheckerboardPage* self,
                                                    GeeCollection* changed);
static void checkerboard_page_on_items_hidden (CheckerboardPage* self,
                                        GeeIterable* hidden);
static gboolean checkerboard_page_real_key_press_event (GtkWidget* base,
                                                 GdkEventKey* event);
static void checkerboard_page_move_cursor (CheckerboardPage* self,
                                    GtkDirectionType direction);
static gboolean checkerboard_page_real_is_point_on_item_selection_button (CheckerboardPage* self,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   CheckerboardItem* item);
static gboolean checkerboard_page_real_on_left_click (Page* base,
                                               GdkEventButton* event);
static gboolean checkerboard_page_real_on_left_released (Page* base,
                                                  GdkEventButton* event);
static gboolean checkerboard_page_real_on_right_click (Page* base,
                                                GdkEventButton* event);
static gboolean checkerboard_page_real_on_mouse_over (CheckerboardPage* self,
                                               CheckerboardItem* item,
                                               gint x,
                                               gint y,
                                               GdkModifierType mask);
static gboolean checkerboard_page_real_on_motion (Page* base,
                                           GdkEventMotion* event,
                                           gint x,
                                           gint y,
                                           GdkModifierType mask);
static void checkerboard_page_updated_selection_band (CheckerboardPage* self);
static gboolean checkerboard_page_selection_autoscroll (CheckerboardPage* self);
static gboolean _checkerboard_page_selection_autoscroll_gsource_func (gpointer self);
static void checkerboard_page_real_set_display_titles (CheckerboardPage* self,
                                                gboolean display);
static void checkerboard_page_real_set_display_comments (CheckerboardPage* self,
                                                  gboolean display);
static GObject * checkerboard_page_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _checkerboard_page_on_items_hidden_view_collection_items_hidden (ViewCollection* _sender,
                                                                      GeeCollection* hidden,
                                                                      gpointer self);
static void _checkerboard_page_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                              GeeIterable* added,
                                                                              GeeIterable* removed,
                                                                              gpointer self);
static void _checkerboard_page_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                                    GeeIterable* changed,
                                                                                    gpointer self);
static void _checkerboard_page_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                              GeeCollection* changed,
                                                                                              gpointer self);
static void _checkerboard_page___lambda116_ (CheckerboardPage* self);
static void __checkerboard_page___lambda116__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void checkerboard_page_finalize (GObject * obj);
static GType checkerboard_page_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
checkerboard_page_get_instance_private (CheckerboardPage* self)
{
	return G_STRUCT_MEMBER_P (self, CheckerboardPage_private_offset);
}

CheckerboardPage*
checkerboard_page_construct (GType object_type,
                             const gchar* page_name)
{
	CheckerboardPage * self = NULL;
	g_return_val_if_fail (page_name != NULL, NULL);
	self = (CheckerboardPage*) g_object_new (object_type, "page-name", page_name, NULL);
	return self;
}

static gchar*
checkerboard_page_real_get_back_name (CheckerboardPage* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = page_get_page_name ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
checkerboard_page_get_back_name (CheckerboardPage* self)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->get_back_name) {
		return _klass_->get_back_name (self);
	}
	return NULL;
}

void
checkerboard_page_init_page_sidebar_menu (CheckerboardPage* self,
                                          const gchar* path)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup (path);
	_g_free0 (self->priv->page_sidebar_menu_path);
	self->priv->page_sidebar_menu_path = _tmp0_;
}

GtkMenu*
checkerboard_page_get_context_menu (CheckerboardPage* self)
{
	GtkMenu* _tmp0_ = NULL;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	gboolean _tmp3_;
	GtkMenu* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = page_get_view ((Page*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = view_collection_get_selected_count (_tmp2_) != 0;
	_data_collection_unref0 (_tmp2_);
	if (_tmp3_) {
		GtkMenu* _tmp4_;
		_tmp4_ = checkerboard_page_get_item_context_menu (self);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		GtkMenu* _tmp5_;
		_tmp5_ = page_get_page_context_menu ((Page*) self);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

static GtkMenu*
checkerboard_page_real_get_item_context_menu (CheckerboardPage* self)
{
	GtkMenu* result;
	result = NULL;
	return result;
}

GtkMenu*
checkerboard_page_get_item_context_menu (CheckerboardPage* self)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->get_item_context_menu) {
		return _klass_->get_item_context_menu (self);
	}
	return NULL;
}

static gboolean
checkerboard_page_real_on_context_keypress (Page* base)
{
	CheckerboardPage * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (CheckerboardPage*) base;
	_tmp0_ = checkerboard_page_get_context_menu (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_popup_context_menu ((Page*) self, _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
checkerboard_page_real_get_view_empty_message (CheckerboardPage* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (_ ("No photos/videos"));
	result = _tmp0_;
	return result;
}

gchar*
checkerboard_page_get_view_empty_message (CheckerboardPage* self)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->get_view_empty_message) {
		return _klass_->get_view_empty_message (self);
	}
	return NULL;
}

static gchar*
checkerboard_page_real_get_filter_no_match_message (CheckerboardPage* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (_ ("No photos/videos found"));
	result = _tmp0_;
	return result;
}

gchar*
checkerboard_page_get_filter_no_match_message (CheckerboardPage* self)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->get_filter_no_match_message) {
		return _klass_->get_filter_no_match_message (self);
	}
	return NULL;
}

static void
checkerboard_page_real_on_item_activated (CheckerboardPage* self,
                                          CheckerboardItem* item)
{
	g_return_if_fail (item != NULL);
}

void
checkerboard_page_on_item_activated (CheckerboardPage* self,
                                     CheckerboardItem* item)
{
	CheckerboardPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->on_item_activated) {
		_klass_->on_item_activated (self, item);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CheckerboardLayout*
checkerboard_page_get_checkerboard_layout (CheckerboardPage* self)
{
	CheckerboardLayout* _tmp0_;
	CheckerboardLayout* _tmp1_;
	CheckerboardLayout* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->layout;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static SearchViewFilter*
checkerboard_page_real_get_search_view_filter (CheckerboardPage* self)
{
	g_critical ("Type `%s' does not implement abstract method `checkerboard_page_get_search_view_filter'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

SearchViewFilter*
checkerboard_page_get_search_view_filter (CheckerboardPage* self)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->get_search_view_filter) {
		return _klass_->get_search_view_filter (self);
	}
	return NULL;
}

static CoreViewTracker*
checkerboard_page_real_get_view_tracker (CheckerboardPage* self)
{
	CoreViewTracker* result;
	result = NULL;
	return result;
}

CoreViewTracker*
checkerboard_page_get_view_tracker (CheckerboardPage* self)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->get_view_tracker) {
		return _klass_->get_view_tracker (self);
	}
	return NULL;
}

static void
_checkerboard_page_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender,
                                                               gpointer self)
{
	checkerboard_page_on_view_filter_refresh ((CheckerboardPage*) self);
}

static void
checkerboard_page_real_switching_from (Page* base)
{
	CheckerboardPage * self;
	CheckerboardLayout* _tmp0_;
	SearchViewFilter* _tmp1_;
	SearchViewFilter* _tmp2_;
	guint _tmp3_;
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	self = (CheckerboardPage*) base;
	_tmp0_ = self->priv->layout;
	checkerboard_layout_set_in_view (_tmp0_, FALSE);
	_tmp1_ = checkerboard_page_get_search_view_filter (self);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((ViewFilter*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_page_on_view_filter_refresh_view_filter_refresh, self);
	_view_filter_unref0 (_tmp2_);
	_tmp4_ = page_get_view ((Page*) self);
	_tmp5_ = _tmp4_;
	view_collection_unselect_all (_tmp5_);
	_data_collection_unref0 (_tmp5_);
	PAGE_CLASS (checkerboard_page_parent_class)->switching_from (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page));
}

static void
checkerboard_page_real_switched_to (Page* base)
{
	CheckerboardPage * self;
	CheckerboardLayout* _tmp0_;
	SearchViewFilter* _tmp1_;
	SearchViewFilter* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	gboolean _tmp5_;
	self = (CheckerboardPage*) base;
	_tmp0_ = self->priv->layout;
	checkerboard_layout_set_in_view (_tmp0_, TRUE);
	_tmp1_ = checkerboard_page_get_search_view_filter (self);
	_tmp2_ = _tmp1_;
	g_signal_connect_object ((ViewFilter*) _tmp2_, "refresh", (GCallback) _checkerboard_page_on_view_filter_refresh_view_filter_refresh, self, 0);
	_view_filter_unref0 (_tmp2_);
	checkerboard_page_on_view_filter_refresh (self);
	_tmp3_ = page_get_view ((Page*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = view_collection_get_selected_count (_tmp4_) > 0;
	_data_collection_unref0 (_tmp4_);
	if (_tmp5_) {
		CheckerboardItem* item = NULL;
		ViewCollection* _tmp6_;
		ViewCollection* _tmp7_;
		DataView* _tmp8_;
		CheckerboardItem* _tmp9_;
		GtkAdjustment* vadj = NULL;
		GtkAdjustment* _tmp10_;
		GtkAdjustment* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GtkAdjustment* _tmp13_;
		CheckerboardItem* _tmp14_;
		GdkRectangle _tmp15_;
		_tmp6_ = page_get_view ((Page*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = view_collection_get_selected_at (_tmp7_, 0);
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
		_data_collection_unref0 (_tmp7_);
		item = _tmp9_;
		_tmp10_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		vadj = _tmp11_;
		_tmp13_ = vadj;
		_tmp14_ = item;
		_tmp15_ = _tmp14_->allocation;
		if (get_adjustment_relation (_tmp13_, _tmp15_.y) == ADJUSTMENT_RELATION_IN_RANGE) {
			GtkAdjustment* _tmp16_;
			CheckerboardItem* _tmp17_;
			GdkRectangle _tmp18_;
			CheckerboardItem* _tmp19_;
			GdkRectangle _tmp20_;
			_tmp16_ = vadj;
			_tmp17_ = item;
			_tmp18_ = _tmp17_->allocation;
			_tmp19_ = item;
			_tmp20_ = _tmp19_->allocation;
			_tmp12_ = get_adjustment_relation (_tmp16_, _tmp18_.y + _tmp20_.height) == ADJUSTMENT_RELATION_IN_RANGE;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			gint top = 0;
			CheckerboardItem* _tmp21_;
			GdkRectangle _tmp22_;
			GtkAdjustment* _tmp23_;
			GtkAdjustment* _tmp31_;
			top = 0;
			_tmp21_ = item;
			_tmp22_ = _tmp21_->allocation;
			_tmp23_ = vadj;
			if (((gdouble) _tmp22_.y) < gtk_adjustment_get_value (_tmp23_)) {
				CheckerboardItem* _tmp24_;
				GdkRectangle _tmp25_;
				_tmp24_ = item;
				_tmp25_ = _tmp24_->allocation;
				top = _tmp25_.y;
				top -= CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING / 2;
			} else {
				CheckerboardItem* _tmp26_;
				GdkRectangle _tmp27_;
				CheckerboardItem* _tmp28_;
				GdkRectangle _tmp29_;
				GtkAdjustment* _tmp30_;
				_tmp26_ = item;
				_tmp27_ = _tmp26_->allocation;
				_tmp28_ = item;
				_tmp29_ = _tmp28_->allocation;
				_tmp30_ = vadj;
				top = (_tmp27_.y + _tmp29_.height) - ((gint) gtk_adjustment_get_page_size (_tmp30_));
				top += CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING / 2;
			}
			_tmp31_ = vadj;
			gtk_adjustment_set_value (_tmp31_, (gdouble) top);
		}
		_g_object_unref0 (vadj);
		_g_object_unref0 (item);
	}
	PAGE_CLASS (checkerboard_page_parent_class)->switched_to (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page));
}

static void
checkerboard_page_on_view_filter_refresh (CheckerboardPage* self)
{
	g_return_if_fail (self != NULL);
	checkerboard_page_update_view_filter_message (self);
}

static void
checkerboard_page_on_contents_altered (CheckerboardPage* self,
                                       GeeIterable* added,
                                       GeeIterable* removed)
{
	g_return_if_fail (self != NULL);
	checkerboard_page_update_view_filter_message (self);
}

static void
checkerboard_page_on_items_state_changed (CheckerboardPage* self,
                                          GeeIterable* changed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	checkerboard_page_update_view_filter_message (self);
}

static void
checkerboard_page_on_items_visibility_changed (CheckerboardPage* self,
                                               GeeCollection* changed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	checkerboard_page_update_view_filter_message (self);
}

static void
checkerboard_page_update_view_filter_message (CheckerboardPage* self)
{
	LibraryWindow* window = NULL;
	AppWindow* _tmp0_;
	LibraryWindow* _tmp1_;
	LibraryWindow* _tmp2_;
	LibraryWindow* _tmp3_;
	gboolean _tmp5_ = FALSE;
	ViewCollection* _tmp6_;
	ViewCollection* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = IS_LIBRARY_WINDOW (_tmp0_) ? ((LibraryWindow*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	window = _tmp1_;
	_tmp2_ = window;
	g_warn_if_fail (_tmp2_ != NULL);
	_tmp3_ = window;
	if (_tmp3_ != NULL) {
		LibraryWindow* _tmp4_;
		_tmp4_ = window;
		library_window_toggle_welcome_page (_tmp4_, FALSE, "", "", FALSE);
	}
	_tmp6_ = page_get_view ((Page*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = view_collection_are_items_filtered_out (_tmp7_);
	_data_collection_unref0 (_tmp7_);
	if (_tmp8_) {
		ViewCollection* _tmp9_;
		ViewCollection* _tmp10_;
		_tmp9_ = page_get_view ((Page*) self);
		_tmp10_ = _tmp9_;
		_tmp5_ = data_collection_get_count ((DataCollection*) _tmp10_) == 0;
		_data_collection_unref0 (_tmp10_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = checkerboard_page_get_filter_no_match_message (self);
		_tmp12_ = _tmp11_;
		checkerboard_page_set_page_message (self, _tmp12_);
		_g_free0 (_tmp12_);
	} else {
		ViewCollection* _tmp13_;
		ViewCollection* _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = page_get_view ((Page*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = data_collection_get_count ((DataCollection*) _tmp14_) == 0;
		_data_collection_unref0 (_tmp14_);
		if (_tmp15_) {
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = checkerboard_page_get_view_empty_message (self);
			_tmp17_ = _tmp16_;
			checkerboard_page_set_page_message (self, _tmp17_);
			_g_free0 (_tmp17_);
		} else {
			checkerboard_page_unset_page_message (self);
		}
	}
	_g_object_unref0 (window);
}

void
checkerboard_page_set_page_message (CheckerboardPage* self,
                                    const gchar* message)
{
	CheckerboardLayout* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->layout;
	checkerboard_layout_set_message (_tmp0_, message);
	_tmp1_ = page_get_in_view ((Page*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		CheckerboardLayout* _tmp3_;
		_tmp3_ = self->priv->layout;
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	}
}

void
checkerboard_page_unset_page_message (CheckerboardPage* self)
{
	CheckerboardLayout* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layout;
	checkerboard_layout_unset_message (_tmp0_);
	_tmp1_ = page_get_in_view ((Page*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		CheckerboardLayout* _tmp3_;
		_tmp3_ = self->priv->layout;
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	}
}

CheckerboardItem*
checkerboard_page_get_item_at_pixel (CheckerboardPage* self,
                                     gdouble x,
                                     gdouble y)
{
	CheckerboardLayout* _tmp0_;
	CheckerboardItem* _tmp1_;
	CheckerboardItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->layout;
	_tmp1_ = checkerboard_layout_get_item_at_pixel (_tmp0_, x, y);
	result = _tmp1_;
	return result;
}

static void
checkerboard_page_on_items_hidden (CheckerboardPage* self,
                                   GeeIterable* hidden)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (hidden != NULL);
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (hidden);
		_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			CheckerboardItem* item = NULL;
			DataView* _tmp4_;
			CheckerboardItem* _tmp5_;
			CheckerboardItem* _tmp6_;
			CheckerboardItem* _tmp7_;
			CheckerboardItem* _tmp8_;
			CheckerboardItem* _tmp9_;
			CheckerboardItem* _tmp10_;
			CheckerboardItem* _tmp11_;
			_tmp1_ = _view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			view = (DataView*) _tmp3_;
			_tmp4_ = view;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
			item = _tmp5_;
			_tmp6_ = self->anchor;
			_tmp7_ = item;
			if (_tmp6_ == _tmp7_) {
				_g_object_unref0 (self->anchor);
				self->anchor = NULL;
			}
			_tmp8_ = self->cursor;
			_tmp9_ = item;
			if (_tmp8_ == _tmp9_) {
				_g_object_unref0 (self->cursor);
				self->cursor = NULL;
			}
			_tmp10_ = self->priv->highlighted;
			_tmp11_ = item;
			if (_tmp10_ == _tmp11_) {
				_g_object_unref0 (self->priv->highlighted);
				self->priv->highlighted = NULL;
			}
			_g_object_unref0 (item);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
}

static gboolean
checkerboard_page_real_key_press_event (GtkWidget* base,
                                        GdkEventKey* event)
{
	CheckerboardPage * self;
	gboolean handled = FALSE;
	guint state = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	gboolean _tmp23_ = FALSE;
	gboolean result;
	self = (CheckerboardPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	handled = TRUE;
	state = (guint) (event->state & GDK_SHIFT_MASK);
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Up")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("KP_Up"))))) {
		switch (0) {
			default:
			{
				checkerboard_page_move_cursor (self, GTK_DIR_UP);
				checkerboard_page_select_anchor_to_cursor (self, state);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Down")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("KP_Down"))))) {
		switch (0) {
			default:
			{
				checkerboard_page_move_cursor (self, GTK_DIR_DOWN);
				checkerboard_page_select_anchor_to_cursor (self, state);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("Left")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("KP_Left"))))) {
		switch (0) {
			default:
			{
				checkerboard_page_move_cursor (self, GTK_DIR_LEFT);
				checkerboard_page_select_anchor_to_cursor (self, state);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("Right")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("KP_Right"))))) {
		switch (0) {
			default:
			{
				checkerboard_page_move_cursor (self, GTK_DIR_RIGHT);
				checkerboard_page_select_anchor_to_cursor (self, state);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("Home")))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("KP_Home"))))) {
		switch (0) {
			default:
			{
				CheckerboardItem* first = NULL;
				ViewCollection* _tmp4_;
				ViewCollection* _tmp5_;
				DataView* _tmp6_;
				CheckerboardItem* _tmp7_;
				CheckerboardItem* _tmp8_;
				_tmp4_ = page_get_view ((Page*) self);
				_tmp5_ = _tmp4_;
				_tmp6_ = view_collection_get_first (_tmp5_);
				_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
				_data_collection_unref0 (_tmp5_);
				first = _tmp7_;
				_tmp8_ = first;
				if (_tmp8_ != NULL) {
					CheckerboardItem* _tmp9_;
					_tmp9_ = first;
					checkerboard_page_cursor_to_item (self, _tmp9_);
				}
				checkerboard_page_select_anchor_to_cursor (self, state);
				_g_object_unref0 (first);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("End")))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("KP_End"))))) {
		switch (0) {
			default:
			{
				CheckerboardItem* last = NULL;
				ViewCollection* _tmp10_;
				ViewCollection* _tmp11_;
				DataView* _tmp12_;
				CheckerboardItem* _tmp13_;
				CheckerboardItem* _tmp14_;
				_tmp10_ = page_get_view ((Page*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = view_collection_get_last (_tmp11_);
				_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
				_data_collection_unref0 (_tmp11_);
				last = _tmp13_;
				_tmp14_ = last;
				if (_tmp14_ != NULL) {
					CheckerboardItem* _tmp15_;
					_tmp15_ = last;
					checkerboard_page_cursor_to_item (self, _tmp15_);
				}
				checkerboard_page_select_anchor_to_cursor (self, state);
				_g_object_unref0 (last);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("Return")))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("KP_Enter"))))) {
		switch (0) {
			default:
			{
				ViewCollection* _tmp16_;
				ViewCollection* _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = page_get_view ((Page*) self);
				_tmp17_ = _tmp16_;
				_tmp18_ = view_collection_get_selected_count (_tmp17_) == 1;
				_data_collection_unref0 (_tmp17_);
				if (_tmp18_) {
					ViewCollection* _tmp19_;
					ViewCollection* _tmp20_;
					DataView* _tmp21_;
					CheckerboardItem* _tmp22_;
					_tmp19_ = page_get_view ((Page*) self);
					_tmp20_ = _tmp19_;
					_tmp21_ = view_collection_get_selected_at (_tmp20_, 0);
					_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
					checkerboard_page_on_item_activated (self, _tmp22_);
					_g_object_unref0 (_tmp22_);
					_data_collection_unref0 (_tmp20_);
				} else {
					handled = FALSE;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				handled = FALSE;
				break;
			}
		}
	}
	if (handled) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (checkerboard_page_parent_class)->key_press_event != NULL) {
		_tmp23_ = GTK_WIDGET_CLASS (checkerboard_page_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PAGE, Page), event);
	} else {
		_tmp23_ = TRUE;
	}
	result = _tmp23_;
	return result;
}

static gboolean
checkerboard_page_real_is_point_on_item_selection_button (CheckerboardPage* self,
                                                          gdouble x,
                                                          gdouble y,
                                                          CheckerboardItem* item)
{
	GdkRectangle button_area = {0};
	GdkRectangle _tmp0_ = {0};
	static const gint X_ERROR_MARGIN = 3;
	static const gint Y_ERROR_MARGIN = 3;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkRectangle _tmp4_;
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	checkerboard_item_get_selection_button_area (item, &_tmp0_);
	button_area = _tmp0_;
	_tmp4_ = button_area;
	if (x >= ((gdouble) (_tmp4_.x - X_ERROR_MARGIN))) {
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_;
		_tmp5_ = button_area;
		_tmp6_ = button_area;
		_tmp3_ = x <= ((gdouble) ((_tmp5_.x + _tmp6_.width) + X_ERROR_MARGIN));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GdkRectangle _tmp7_;
		_tmp7_ = button_area;
		_tmp2_ = y >= ((gdouble) (_tmp7_.y - Y_ERROR_MARGIN));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkRectangle _tmp8_;
		GdkRectangle _tmp9_;
		_tmp8_ = button_area;
		_tmp9_ = button_area;
		_tmp1_ = y <= ((gdouble) ((_tmp8_.y + _tmp9_.height) + Y_ERROR_MARGIN));
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gboolean
checkerboard_page_is_point_on_item_selection_button (CheckerboardPage* self,
                                                     gdouble x,
                                                     gdouble y,
                                                     CheckerboardItem* item)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->is_point_on_item_selection_button) {
		return _klass_->is_point_on_item_selection_button (self, x, y, item);
	}
	return FALSE;
}

static gboolean
checkerboard_page_real_on_left_click (Page* base,
                                      GdkEventButton* event)
{
	CheckerboardPage * self;
	gboolean _tmp0_ = FALSE;
	guint state = 0U;
	CheckerboardItem* item = NULL;
	CheckerboardItem* _tmp1_;
	CheckerboardItem* _tmp2_;
	ViewCollection* _tmp69_;
	ViewCollection* _tmp70_;
	gboolean _tmp71_;
	gboolean result;
	self = (CheckerboardPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->selection_button_clicked = FALSE;
	if (event->type != GDK_BUTTON_PRESS) {
		_tmp0_ = event->type != GDK_2BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	state = (guint) (event->state & (GDK_CONTROL_MASK | GDK_SHIFT_MASK));
	_tmp1_ = checkerboard_page_get_item_at_pixel (self, event->x, event->y);
	item = _tmp1_;
	_tmp2_ = item;
	if (_tmp2_ != NULL) {
		switch (state) {
			case GDK_CONTROL_MASK:
			{
				Marker* marker = NULL;
				ViewCollection* _tmp3_;
				ViewCollection* _tmp4_;
				CheckerboardItem* _tmp5_;
				Marker* _tmp6_;
				Marker* _tmp7_;
				ViewCollection* _tmp8_;
				ViewCollection* _tmp9_;
				Marker* _tmp10_;
				CheckerboardItem* _tmp11_;
				_tmp3_ = page_get_view ((Page*) self);
				_tmp4_ = _tmp3_;
				_tmp5_ = item;
				_tmp6_ = data_collection_mark ((DataCollection*) _tmp4_, (DataObject*) _tmp5_);
				_tmp7_ = _tmp6_;
				_data_collection_unref0 (_tmp4_);
				marker = _tmp7_;
				_tmp8_ = page_get_view ((Page*) self);
				_tmp9_ = _tmp8_;
				_tmp10_ = marker;
				view_collection_toggle_marked (_tmp9_, _tmp10_);
				_data_collection_unref0 (_tmp9_);
				_tmp11_ = item;
				if (data_view_is_selected ((DataView*) _tmp11_)) {
					CheckerboardItem* _tmp12_;
					CheckerboardItem* _tmp13_;
					CheckerboardItem* _tmp14_;
					CheckerboardItem* _tmp15_;
					_tmp12_ = item;
					_tmp13_ = _g_object_ref0 (_tmp12_);
					_g_object_unref0 (self->anchor);
					self->anchor = _tmp13_;
					_tmp14_ = item;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					_g_object_unref0 (self->cursor);
					self->cursor = _tmp15_;
				}
				_g_object_unref0 (marker);
				break;
			}
			case GDK_SHIFT_MASK:
			{
				ViewCollection* _tmp16_;
				ViewCollection* _tmp17_;
				CheckerboardItem* _tmp18_;
				CheckerboardItem* _tmp21_;
				CheckerboardItem* _tmp22_;
				CheckerboardItem* _tmp23_;
				CheckerboardItem* _tmp24_;
				_tmp16_ = page_get_view ((Page*) self);
				_tmp17_ = _tmp16_;
				view_collection_unselect_all (_tmp17_);
				_data_collection_unref0 (_tmp17_);
				_tmp18_ = self->anchor;
				if (_tmp18_ == NULL) {
					CheckerboardItem* _tmp19_;
					CheckerboardItem* _tmp20_;
					_tmp19_ = item;
					_tmp20_ = _g_object_ref0 (_tmp19_);
					_g_object_unref0 (self->anchor);
					self->anchor = _tmp20_;
				}
				_tmp21_ = self->anchor;
				_tmp22_ = item;
				checkerboard_page_select_between_items (self, _tmp21_, _tmp22_);
				_tmp23_ = item;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_g_object_unref0 (self->cursor);
				self->cursor = _tmp24_;
				break;
			}
			case GDK_CONTROL_MASK | GDK_SHIFT_MASK:
			{
				CheckerboardItem* _tmp25_;
				CheckerboardItem* _tmp28_;
				CheckerboardItem* _tmp29_;
				CheckerboardItem* _tmp30_;
				CheckerboardItem* _tmp31_;
				_tmp25_ = self->anchor;
				if (_tmp25_ == NULL) {
					CheckerboardItem* _tmp26_;
					CheckerboardItem* _tmp27_;
					_tmp26_ = item;
					_tmp27_ = _g_object_ref0 (_tmp26_);
					_g_object_unref0 (self->anchor);
					self->anchor = _tmp27_;
				}
				_tmp28_ = self->anchor;
				_tmp29_ = item;
				checkerboard_page_select_between_items (self, _tmp28_, _tmp29_);
				_tmp30_ = item;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				_g_object_unref0 (self->cursor);
				self->cursor = _tmp31_;
				break;
			}
			default:
			{
				CheckerboardItem* _tmp32_;
				_tmp32_ = item;
				if (checkerboard_page_is_point_on_item_selection_button (self, event->x, event->y, _tmp32_)) {
					Marker* marker = NULL;
					ViewCollection* _tmp33_;
					ViewCollection* _tmp34_;
					CheckerboardItem* _tmp35_;
					Marker* _tmp36_;
					Marker* _tmp37_;
					ViewCollection* _tmp38_;
					ViewCollection* _tmp39_;
					Marker* _tmp40_;
					CheckerboardItem* _tmp41_;
					g_debug ("CheckerboardPage.vala:349: Selection button clicked");
					self->priv->selection_button_clicked = TRUE;
					_tmp33_ = page_get_view ((Page*) self);
					_tmp34_ = _tmp33_;
					_tmp35_ = item;
					_tmp36_ = data_collection_mark ((DataCollection*) _tmp34_, (DataObject*) _tmp35_);
					_tmp37_ = _tmp36_;
					_data_collection_unref0 (_tmp34_);
					marker = _tmp37_;
					_tmp38_ = page_get_view ((Page*) self);
					_tmp39_ = _tmp38_;
					_tmp40_ = marker;
					view_collection_toggle_marked (_tmp39_, _tmp40_);
					_data_collection_unref0 (_tmp39_);
					_tmp41_ = item;
					if (data_view_is_selected ((DataView*) _tmp41_)) {
						CheckerboardItem* _tmp42_;
						CheckerboardItem* _tmp43_;
						CheckerboardItem* _tmp44_;
						CheckerboardItem* _tmp45_;
						_tmp42_ = item;
						_tmp43_ = _g_object_ref0 (_tmp42_);
						_g_object_unref0 (self->anchor);
						self->anchor = _tmp43_;
						_tmp44_ = item;
						_tmp45_ = _g_object_ref0 (_tmp44_);
						_g_object_unref0 (self->cursor);
						self->cursor = _tmp45_;
					}
					_g_object_unref0 (marker);
				} else {
					CheckerboardItem* _tmp46_;
					CheckerboardItem* _tmp47_;
					CheckerboardItem* _tmp48_;
					CheckerboardItem* _tmp49_;
					CheckerboardItem* _tmp50_;
					CheckerboardItem* _tmp51_;
					_tmp46_ = item;
					_tmp47_ = _g_object_ref0 (_tmp46_);
					_g_object_unref0 (self->priv->activated_item);
					self->priv->activated_item = _tmp47_;
					_tmp48_ = item;
					_tmp49_ = _g_object_ref0 (_tmp48_);
					_g_object_unref0 (self->anchor);
					self->anchor = _tmp49_;
					_tmp50_ = item;
					_tmp51_ = _g_object_ref0 (_tmp50_);
					_g_object_unref0 (self->cursor);
					self->cursor = _tmp51_;
				}
				break;
			}
		}
	} else {
		GeeArrayList* _tmp54_;
		CheckerboardLayout* _tmp68_;
		if (state != ((guint) GDK_CONTROL_MASK)) {
			ViewCollection* _tmp52_;
			ViewCollection* _tmp53_;
			_tmp52_ = page_get_view ((Page*) self);
			_tmp53_ = _tmp52_;
			view_collection_unselect_all (_tmp53_);
			_data_collection_unref0 (_tmp53_);
		}
		_tmp54_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->previously_selected);
		self->priv->previously_selected = _tmp54_;
		{
			GeeList* _view_list = NULL;
			ViewCollection* _tmp55_;
			ViewCollection* _tmp56_;
			GeeList* _tmp57_;
			GeeList* _tmp58_;
			gint _view_size = 0;
			GeeList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _view_index = 0;
			_tmp55_ = page_get_view ((Page*) self);
			_tmp56_ = _tmp55_;
			_tmp57_ = view_collection_get_selected (_tmp56_);
			_tmp58_ = _tmp57_;
			_data_collection_unref0 (_tmp56_);
			_view_list = _tmp58_;
			_tmp59_ = _view_list;
			_tmp60_ = gee_collection_get_size ((GeeCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_view_size = _tmp61_;
			_view_index = -1;
			while (TRUE) {
				gint _tmp62_;
				gint _tmp63_;
				DataView* view = NULL;
				GeeList* _tmp64_;
				gpointer _tmp65_;
				GeeArrayList* _tmp66_;
				DataView* _tmp67_;
				_view_index = _view_index + 1;
				_tmp62_ = _view_index;
				_tmp63_ = _view_size;
				if (!(_tmp62_ < _tmp63_)) {
					break;
				}
				_tmp64_ = _view_list;
				_tmp65_ = gee_list_get (_tmp64_, _view_index);
				view = (DataView*) _tmp65_;
				_tmp66_ = self->priv->previously_selected;
				_tmp67_ = view;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_list);
		}
		_tmp68_ = self->priv->layout;
		checkerboard_layout_set_drag_select_origin (_tmp68_, (gint) event->x, (gint) event->y);
		result = TRUE;
		_g_object_unref0 (item);
		return result;
	}
	_tmp69_ = page_get_view ((Page*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = view_collection_get_selected_count (_tmp70_) == 0;
	_data_collection_unref0 (_tmp70_);
	result = _tmp71_;
	_g_object_unref0 (item);
	return result;
}

static gboolean
checkerboard_page_real_on_left_released (Page* base,
                                         GdkEventButton* event)
{
	CheckerboardPage * self;
	CheckerboardLayout* _tmp0_;
	CheckerboardItem* _tmp4_;
	CheckerboardItem* item = NULL;
	CheckerboardItem* _tmp6_;
	CheckerboardItem* _tmp7_;
	CheckerboardItem* _tmp8_;
	CheckerboardItem* _tmp9_;
	gboolean result;
	self = (CheckerboardPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_g_object_unref0 (self->priv->previously_selected);
	self->priv->previously_selected = NULL;
	_tmp0_ = self->priv->layout;
	if (checkerboard_layout_is_drag_select_active (_tmp0_)) {
		CheckerboardLayout* _tmp1_;
		CheckerboardItem* _tmp2_;
		CheckerboardItem* _tmp3_;
		_tmp1_ = self->priv->layout;
		checkerboard_layout_clear_drag_select (_tmp1_);
		_tmp2_ = self->cursor;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->anchor);
		self->anchor = _tmp3_;
		result = TRUE;
		return result;
	}
	if ((event->state & (GDK_CONTROL_MASK | GDK_SHIFT_MASK)) != 0) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->activated_item;
	if (_tmp4_ != NULL) {
		CheckerboardItem* _tmp5_;
		_tmp5_ = self->priv->activated_item;
		checkerboard_page_on_item_activated (self, _tmp5_);
		_g_object_unref0 (self->priv->activated_item);
		self->priv->activated_item = NULL;
		result = TRUE;
		return result;
	}
	_tmp6_ = checkerboard_page_get_item_at_pixel (self, event->x, event->y);
	item = _tmp6_;
	_tmp7_ = item;
	if (_tmp7_ == NULL) {
		result = TRUE;
		_g_object_unref0 (item);
		return result;
	}
	if (self->priv->selection_button_clicked) {
		self->priv->selection_button_clicked = FALSE;
		result = TRUE;
		_g_object_unref0 (item);
		return result;
	}
	_tmp8_ = self->cursor;
	_tmp9_ = item;
	if (_tmp8_ != _tmp9_) {
		ViewCollection* _tmp10_;
		ViewCollection* _tmp11_;
		_tmp10_ = page_get_view ((Page*) self);
		_tmp11_ = _tmp10_;
		view_collection_unselect_all (_tmp11_);
		_data_collection_unref0 (_tmp11_);
	} else {
		CheckerboardItem* _tmp12_;
		_tmp12_ = item;
		if (data_view_is_selected ((DataView*) _tmp12_)) {
			ViewCollection* _tmp13_;
			ViewCollection* _tmp14_;
			CheckerboardItem* _tmp15_;
			_tmp13_ = page_get_view ((Page*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = item;
			view_collection_unselect_all_but (_tmp14_, (DataView*) _tmp15_);
			_data_collection_unref0 (_tmp14_);
		}
	}
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static gboolean
checkerboard_page_real_on_right_click (Page* base,
                                       GdkEventButton* event)
{
	CheckerboardPage * self;
	CheckerboardItem* item = NULL;
	CheckerboardItem* _tmp0_;
	CheckerboardItem* _tmp1_;
	GtkMenu* context_menu = NULL;
	GtkMenu* _tmp30_;
	GtkMenu* _tmp31_;
	gboolean result;
	self = (CheckerboardPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp0_ = checkerboard_page_get_item_at_pixel (self, event->x, event->y);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		switch (event->state & (GDK_CONTROL_MASK | GDK_SHIFT_MASK)) {
			case GDK_CONTROL_MASK:
			{
				Marker* marker = NULL;
				ViewCollection* _tmp2_;
				ViewCollection* _tmp3_;
				CheckerboardItem* _tmp4_;
				Marker* _tmp5_;
				Marker* _tmp6_;
				ViewCollection* _tmp7_;
				ViewCollection* _tmp8_;
				Marker* _tmp9_;
				_tmp2_ = page_get_view ((Page*) self);
				_tmp3_ = _tmp2_;
				_tmp4_ = item;
				_tmp5_ = data_collection_mark ((DataCollection*) _tmp3_, (DataObject*) _tmp4_);
				_tmp6_ = _tmp5_;
				_data_collection_unref0 (_tmp3_);
				marker = _tmp6_;
				_tmp7_ = page_get_view ((Page*) self);
				_tmp8_ = _tmp7_;
				_tmp9_ = marker;
				view_collection_toggle_marked (_tmp8_, _tmp9_);
				_data_collection_unref0 (_tmp8_);
				_g_object_unref0 (marker);
				break;
			}
			case GDK_SHIFT_MASK:
			{
				break;
			}
			case GDK_CONTROL_MASK | GDK_SHIFT_MASK:
			{
				break;
			}
			default:
			{
				CheckerboardItem* _tmp10_;
				_tmp10_ = item;
				if (!data_view_is_selected ((DataView*) _tmp10_)) {
					Marker* all = NULL;
					ViewCollection* _tmp11_;
					ViewCollection* _tmp12_;
					Marker* _tmp13_;
					Marker* _tmp14_;
					Marker* _tmp15_;
					ViewCollection* _tmp16_;
					ViewCollection* _tmp17_;
					GeeList* _tmp18_;
					GeeList* _tmp19_;
					ViewCollection* _tmp20_;
					ViewCollection* _tmp21_;
					Marker* _tmp22_;
					ViewCollection* _tmp23_;
					ViewCollection* _tmp24_;
					CheckerboardItem* _tmp25_;
					Marker* _tmp26_;
					Marker* _tmp27_;
					_tmp11_ = page_get_view ((Page*) self);
					_tmp12_ = _tmp11_;
					_tmp13_ = data_collection_start_marking ((DataCollection*) _tmp12_);
					_tmp14_ = _tmp13_;
					_data_collection_unref0 (_tmp12_);
					all = _tmp14_;
					_tmp15_ = all;
					_tmp16_ = page_get_view ((Page*) self);
					_tmp17_ = _tmp16_;
					_tmp18_ = view_collection_get_selected (_tmp17_);
					_tmp19_ = _tmp18_;
					marker_mark_many (_tmp15_, (GeeCollection*) _tmp19_);
					_g_object_unref0 (_tmp19_);
					_data_collection_unref0 (_tmp17_);
					_tmp20_ = page_get_view ((Page*) self);
					_tmp21_ = _tmp20_;
					_tmp22_ = all;
					_tmp23_ = page_get_view ((Page*) self);
					_tmp24_ = _tmp23_;
					_tmp25_ = item;
					_tmp26_ = data_collection_mark ((DataCollection*) _tmp24_, (DataObject*) _tmp25_);
					_tmp27_ = _tmp26_;
					view_collection_unselect_and_select_marked (_tmp21_, _tmp22_, _tmp27_);
					_g_object_unref0 (_tmp27_);
					_data_collection_unref0 (_tmp24_);
					_data_collection_unref0 (_tmp21_);
					_g_object_unref0 (all);
				}
				break;
			}
		}
	} else {
		ViewCollection* _tmp28_;
		ViewCollection* _tmp29_;
		_tmp28_ = page_get_view ((Page*) self);
		_tmp29_ = _tmp28_;
		view_collection_unselect_all (_tmp29_);
		_data_collection_unref0 (_tmp29_);
	}
	_tmp30_ = checkerboard_page_get_context_menu (self);
	context_menu = _tmp30_;
	_tmp31_ = context_menu;
	result = page_popup_context_menu ((Page*) self, _tmp31_, event);
	_g_object_unref0 (context_menu);
	_g_object_unref0 (item);
	return result;
}

static gboolean
checkerboard_page_real_on_mouse_over (CheckerboardPage* self,
                                      CheckerboardItem* item,
                                      gint x,
                                      gint y,
                                      GdkModifierType mask)
{
	CheckerboardItem* _tmp0_;
	GdkCursorType _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	GdkCursorType cursor_type = 0;
	gboolean result;
	_tmp0_ = self->priv->highlighted;
	if (item != _tmp0_) {
		CheckerboardItem* _tmp1_;
		_tmp1_ = self->priv->highlighted;
		if (_tmp1_ != NULL) {
			CheckerboardItem* _tmp2_;
			_tmp2_ = self->priv->highlighted;
			checkerboard_item_unbrighten (_tmp2_);
			_g_object_unref0 (self->priv->highlighted);
			self->priv->highlighted = NULL;
		}
		if (item != NULL) {
			CheckerboardItem* _tmp3_;
			checkerboard_item_brighten (item);
			_tmp3_ = _g_object_ref0 (item);
			_g_object_unref0 (self->priv->highlighted);
			self->priv->highlighted = _tmp3_;
		}
	}
	if (item != NULL) {
		_tmp5_ = !checkerboard_page_is_point_on_item_selection_button (self, (gdouble) x, (gdouble) y, item);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = GDK_HAND1;
	} else {
		_tmp4_ = GDK_ARROW;
	}
	cursor_type = _tmp4_;
	page_set_page_cursor ((Page*) self, cursor_type);
	result = TRUE;
	return result;
}

gboolean
checkerboard_page_on_mouse_over (CheckerboardPage* self,
                                 CheckerboardItem* item,
                                 gint x,
                                 gint y,
                                 GdkModifierType mask)
{
	CheckerboardPageClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->on_mouse_over) {
		return _klass_->on_mouse_over (self, item, x, y, mask);
	}
	return FALSE;
}

static gboolean
_checkerboard_page_selection_autoscroll_gsource_func (gpointer self)
{
	gboolean result;
	result = checkerboard_page_selection_autoscroll ((CheckerboardPage*) self);
	return result;
}

static gboolean
checkerboard_page_real_on_motion (Page* base,
                                  GdkEventMotion* event,
                                  gint x,
                                  gint y,
                                  GdkModifierType mask)
{
	CheckerboardPage * self;
	CheckerboardItem* _tmp0_;
	CheckerboardItem* _tmp1_;
	gboolean _tmp2_;
	CheckerboardLayout* _tmp3_;
	CheckerboardLayout* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean result;
	self = (CheckerboardPage*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = checkerboard_page_get_item_at_pixel (self, (gdouble) x, (gdouble) y);
	_tmp1_ = _tmp0_;
	_tmp2_ = !checkerboard_page_on_mouse_over (self, _tmp1_, x, y, mask);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->layout;
	if (!checkerboard_layout_is_drag_select_active (_tmp3_)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->layout;
	checkerboard_layout_set_drag_select_endpoint (_tmp4_, x, y);
	checkerboard_page_updated_selection_band (self);
	if (!self->priv->autoscroll_scheduled) {
		GtkAdjustment* _tmp6_;
		_tmp6_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
		_tmp5_ = get_adjustment_relation (_tmp6_, y) != ADJUSTMENT_RELATION_IN_RANGE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) CHECKERBOARD_PAGE_AUTOSCROLL_TICKS_MSEC, _checkerboard_page_selection_autoscroll_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->autoscroll_scheduled = TRUE;
	}
	result = TRUE;
	return result;
}

static void
checkerboard_page_updated_selection_band (CheckerboardPage* self)
{
	CheckerboardLayout* _tmp0_;
	GeeList* intersection = NULL;
	CheckerboardLayout* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	Marker* to_unselect = NULL;
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	Marker* _tmp6_;
	Marker* _tmp7_;
	Marker* to_select = NULL;
	ViewCollection* _tmp8_;
	ViewCollection* _tmp9_;
	Marker* _tmp10_;
	Marker* _tmp11_;
	Marker* _tmp12_;
	ViewCollection* _tmp13_;
	ViewCollection* _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	GeeArrayList* _tmp17_;
	Marker* _tmp18_;
	GeeArrayList* _tmp19_;
	Marker* _tmp20_;
	GeeArrayList* _tmp21_;
	ViewCollection* _tmp39_;
	ViewCollection* _tmp40_;
	Marker* _tmp41_;
	ViewCollection* _tmp42_;
	ViewCollection* _tmp43_;
	Marker* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->layout;
	_vala_assert (checkerboard_layout_is_drag_select_active (_tmp0_), "layout.is_drag_select_active ()");
	_tmp1_ = self->priv->layout;
	_tmp2_ = checkerboard_layout_items_in_selection_band (_tmp1_);
	intersection = _tmp2_;
	_tmp3_ = intersection;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (intersection);
		return;
	}
	_tmp4_ = page_get_view ((Page*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = data_collection_start_marking ((DataCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_data_collection_unref0 (_tmp5_);
	to_unselect = _tmp7_;
	_tmp8_ = page_get_view ((Page*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = data_collection_start_marking ((DataCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_data_collection_unref0 (_tmp9_);
	to_select = _tmp11_;
	_tmp12_ = to_unselect;
	_tmp13_ = page_get_view ((Page*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = view_collection_get_selected (_tmp14_);
	_tmp16_ = _tmp15_;
	marker_mark_many (_tmp12_, (GeeCollection*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	_data_collection_unref0 (_tmp14_);
	_tmp17_ = self->priv->previously_selected;
	_vala_assert (_tmp17_ != NULL, "previously_selected != null");
	_tmp18_ = to_unselect;
	_tmp19_ = self->priv->previously_selected;
	marker_unmark_many (_tmp18_, (GeeCollection*) _tmp19_);
	_tmp20_ = to_select;
	_tmp21_ = self->priv->previously_selected;
	marker_mark_many (_tmp20_, (GeeCollection*) _tmp21_);
	_g_object_unref0 (self->cursor);
	self->cursor = NULL;
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp22_;
		gint _item_size = 0;
		GeeList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _item_index = 0;
		_tmp22_ = intersection;
		_item_list = _tmp22_;
		_tmp23_ = _item_list;
		_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_item_size = _tmp25_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			CheckerboardItem* item = NULL;
			GeeList* _tmp28_;
			gpointer _tmp29_;
			Marker* _tmp30_;
			CheckerboardItem* _tmp31_;
			CheckerboardItem* _tmp36_;
			_item_index = _item_index + 1;
			_tmp26_ = _item_index;
			_tmp27_ = _item_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _item_list;
			_tmp29_ = gee_list_get (_tmp28_, _item_index);
			item = (CheckerboardItem*) _tmp29_;
			_tmp30_ = to_select;
			_tmp31_ = item;
			if (marker_toggle (_tmp30_, (DataObject*) _tmp31_)) {
				Marker* _tmp32_;
				CheckerboardItem* _tmp33_;
				_tmp32_ = to_unselect;
				_tmp33_ = item;
				marker_unmark (_tmp32_, (DataObject*) _tmp33_);
			} else {
				Marker* _tmp34_;
				CheckerboardItem* _tmp35_;
				_tmp34_ = to_unselect;
				_tmp35_ = item;
				marker_mark (_tmp34_, (DataObject*) _tmp35_);
			}
			_tmp36_ = self->cursor;
			if (_tmp36_ == NULL) {
				CheckerboardItem* _tmp37_;
				CheckerboardItem* _tmp38_;
				_tmp37_ = item;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_g_object_unref0 (self->cursor);
				self->cursor = _tmp38_;
			}
			_g_object_unref0 (item);
		}
	}
	_tmp39_ = page_get_view ((Page*) self);
	_tmp40_ = _tmp39_;
	_tmp41_ = to_select;
	view_collection_select_marked (_tmp40_, _tmp41_);
	_data_collection_unref0 (_tmp40_);
	_tmp42_ = page_get_view ((Page*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = to_unselect;
	view_collection_unselect_marked (_tmp43_, _tmp44_);
	_data_collection_unref0 (_tmp43_);
	_g_object_unref0 (to_select);
	_g_object_unref0 (to_unselect);
	_g_object_unref0 (intersection);
}

static gboolean
checkerboard_page_selection_autoscroll (CheckerboardPage* self)
{
	CheckerboardLayout* _tmp0_;
	GtkAdjustment* vadj = NULL;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	gint x = 0;
	gint y = 0;
	GdkModifierType mask = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkModifierType _tmp5_ = 0U;
	gint new_value = 0;
	GtkAdjustment* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	GtkAdjustment* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->layout;
	if (!checkerboard_layout_is_drag_select_active (_tmp0_)) {
		self->priv->autoscroll_scheduled = FALSE;
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	vadj = _tmp2_;
	page_get_event_source_pointer ((Page*) self, &_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp3_;
	y = _tmp4_;
	mask = _tmp5_;
	_tmp6_ = vadj;
	new_value = (gint) gtk_adjustment_get_value (_tmp6_);
	_tmp7_ = vadj;
	switch (get_adjustment_relation (_tmp7_, y)) {
		case ADJUSTMENT_RELATION_BELOW:
		{
			CheckerboardLayout* _tmp8_;
			new_value -= CHECKERBOARD_PAGE_AUTOSCROLL_PIXELS;
			_tmp8_ = self->priv->layout;
			checkerboard_layout_set_drag_select_endpoint (_tmp8_, x, new_value);
			break;
		}
		case ADJUSTMENT_RELATION_ABOVE:
		{
			CheckerboardLayout* _tmp9_;
			GtkAdjustment* _tmp10_;
			new_value += CHECKERBOARD_PAGE_AUTOSCROLL_PIXELS;
			_tmp9_ = self->priv->layout;
			_tmp10_ = vadj;
			checkerboard_layout_set_drag_select_endpoint (_tmp9_, x, new_value + ((gint) gtk_adjustment_get_page_size (_tmp10_)));
			break;
		}
		case ADJUSTMENT_RELATION_IN_RANGE:
		{
			self->priv->autoscroll_scheduled = FALSE;
			result = FALSE;
			_g_object_unref0 (vadj);
			return result;
		}
		default:
		{
			g_warn_if_reached ();
			break;
		}
	}
	_tmp11_ = vadj;
	_tmp12_ = vadj;
	_tmp13_ = vadj;
	_tmp14_ = vadj;
	gtk_adjustment_set_value (_tmp11_, (gdouble) CLAMP (new_value, (gint) gtk_adjustment_get_lower (_tmp12_), ((gint) gtk_adjustment_get_upper (_tmp13_)) - ((gint) gtk_adjustment_get_page_size (_tmp14_))));
	checkerboard_page_updated_selection_band (self);
	result = TRUE;
	_g_object_unref0 (vadj);
	return result;
}

void
checkerboard_page_cursor_to_item (CheckerboardPage* self,
                                  CheckerboardItem* item)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	CheckerboardItem* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	Marker* marker = NULL;
	ViewCollection* _tmp5_;
	ViewCollection* _tmp6_;
	Marker* _tmp7_;
	Marker* _tmp8_;
	ViewCollection* _tmp9_;
	ViewCollection* _tmp10_;
	Marker* _tmp11_;
	GtkAdjustment* vadj = NULL;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	gboolean _tmp14_ = FALSE;
	GtkAdjustment* _tmp15_;
	GdkRectangle _tmp16_;
	gint top = 0;
	GdkRectangle _tmp20_;
	GtkAdjustment* _tmp21_;
	GtkAdjustment* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_vala_assert (data_collection_contains ((DataCollection*) _tmp1_, (DataObject*) item), "get_view ().contains (item)");
	_data_collection_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (item);
	_g_object_unref0 (self->cursor);
	self->cursor = _tmp2_;
	_tmp3_ = page_get_view ((Page*) self);
	_tmp4_ = _tmp3_;
	view_collection_unselect_all (_tmp4_);
	_data_collection_unref0 (_tmp4_);
	_tmp5_ = page_get_view ((Page*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = data_collection_mark ((DataCollection*) _tmp6_, (DataObject*) item);
	_tmp8_ = _tmp7_;
	_data_collection_unref0 (_tmp6_);
	marker = _tmp8_;
	_tmp9_ = page_get_view ((Page*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = marker;
	view_collection_select_marked (_tmp10_, _tmp11_);
	_data_collection_unref0 (_tmp10_);
	_tmp12_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	vadj = _tmp13_;
	_tmp15_ = vadj;
	_tmp16_ = item->allocation;
	if (get_adjustment_relation (_tmp15_, _tmp16_.y) == ADJUSTMENT_RELATION_IN_RANGE) {
		GtkAdjustment* _tmp17_;
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		_tmp17_ = vadj;
		_tmp18_ = item->allocation;
		_tmp19_ = item->allocation;
		_tmp14_ = get_adjustment_relation (_tmp17_, _tmp18_.y + _tmp19_.height) == ADJUSTMENT_RELATION_IN_RANGE;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_g_object_unref0 (vadj);
		_g_object_unref0 (marker);
		return;
	}
	top = 0;
	_tmp20_ = item->allocation;
	_tmp21_ = vadj;
	if (((gdouble) _tmp20_.y) < gtk_adjustment_get_value (_tmp21_)) {
		GdkRectangle _tmp22_;
		_tmp22_ = item->allocation;
		top = _tmp22_.y;
		top -= CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING / 2;
	} else {
		GdkRectangle _tmp23_;
		GdkRectangle _tmp24_;
		GtkAdjustment* _tmp25_;
		_tmp23_ = item->allocation;
		_tmp24_ = item->allocation;
		_tmp25_ = vadj;
		top = (_tmp23_.y + _tmp24_.height) - ((gint) gtk_adjustment_get_page_size (_tmp25_));
		top += CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING / 2;
	}
	_tmp26_ = vadj;
	gtk_adjustment_set_value (_tmp26_, (gdouble) top);
	_g_object_unref0 (vadj);
	_g_object_unref0 (marker);
}

static void
checkerboard_page_move_cursor (CheckerboardPage* self,
                               GtkDirectionType direction)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	gboolean _tmp6_;
	CheckerboardItem* item = NULL;
	CheckerboardLayout* _tmp13_;
	CheckerboardItem* _tmp14_;
	CheckerboardItem* _tmp15_;
	CheckerboardItem* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = data_collection_get_count ((DataCollection*) _tmp1_) == 0;
	_data_collection_unref0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp4_ = page_get_view ((Page*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = view_collection_get_selected_count (_tmp5_) == 0;
	_data_collection_unref0 (_tmp5_);
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		CheckerboardItem* _tmp7_;
		_tmp7_ = self->cursor;
		_tmp3_ = _tmp7_ == NULL;
	}
	if (_tmp3_) {
		CheckerboardItem* item = NULL;
		CheckerboardLayout* _tmp8_;
		CheckerboardItem* _tmp9_;
		CheckerboardItem* _tmp10_;
		CheckerboardItem* _tmp11_;
		CheckerboardItem* _tmp12_;
		_tmp8_ = self->priv->layout;
		_tmp9_ = checkerboard_layout_get_item_at_coordinate (_tmp8_, 0, 0);
		item = _tmp9_;
		_tmp10_ = item;
		checkerboard_page_cursor_to_item (self, _tmp10_);
		_tmp11_ = item;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (self->anchor);
		self->anchor = _tmp12_;
		_g_object_unref0 (item);
		return;
	}
	_tmp13_ = self->priv->layout;
	_tmp14_ = self->cursor;
	_tmp15_ = checkerboard_layout_get_item_relative_to (_tmp13_, _tmp14_, direction);
	item = _tmp15_;
	_tmp16_ = item;
	if (_tmp16_ != NULL) {
		CheckerboardItem* _tmp17_;
		_tmp17_ = item;
		checkerboard_page_cursor_to_item (self, _tmp17_);
	}
	_g_object_unref0 (item);
}

void
checkerboard_page_set_cursor (CheckerboardPage* self,
                              CheckerboardItem* item)
{
	Marker* marker = NULL;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	Marker* _tmp2_;
	Marker* _tmp3_;
	ViewCollection* _tmp4_;
	ViewCollection* _tmp5_;
	CheckerboardItem* _tmp6_;
	CheckerboardItem* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = data_collection_mark ((DataCollection*) _tmp1_, (DataObject*) item);
	_tmp3_ = _tmp2_;
	_data_collection_unref0 (_tmp1_);
	marker = _tmp3_;
	_tmp4_ = page_get_view ((Page*) self);
	_tmp5_ = _tmp4_;
	view_collection_select_marked (_tmp5_, marker);
	_data_collection_unref0 (_tmp5_);
	_tmp6_ = _g_object_ref0 (item);
	_g_object_unref0 (self->cursor);
	self->cursor = _tmp6_;
	_tmp7_ = _g_object_ref0 (item);
	_g_object_unref0 (self->anchor);
	self->anchor = _tmp7_;
	_g_object_unref0 (marker);
}

void
checkerboard_page_select_between_items (CheckerboardPage* self,
                                        CheckerboardItem* item_start,
                                        CheckerboardItem* item_end)
{
	Marker* marker = NULL;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	Marker* _tmp2_;
	Marker* _tmp3_;
	gboolean passed_start = FALSE;
	gboolean passed_end = FALSE;
	ViewCollection* _tmp21_;
	ViewCollection* _tmp22_;
	Marker* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_start != NULL);
	g_return_if_fail (item_end != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = data_collection_start_marking ((DataCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_data_collection_unref0 (_tmp1_);
	marker = _tmp3_;
	passed_start = FALSE;
	passed_end = FALSE;
	{
		GeeIterator* _object_it = NULL;
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp4_ = page_get_view ((Page*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = data_collection_get_all ((DataCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_data_collection_unref0 (_tmp5_);
		_object_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataObject* object = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			CheckerboardItem* item = NULL;
			DataObject* _tmp13_;
			CheckerboardItem* _tmp14_;
			CheckerboardItem* _tmp15_;
			CheckerboardItem* _tmp16_;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp20_ = FALSE;
			_tmp10_ = _object_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _object_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			object = (DataObject*) _tmp12_;
			_tmp13_ = object;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
			item = _tmp14_;
			_tmp15_ = item;
			if (item_start == _tmp15_) {
				passed_start = TRUE;
			}
			_tmp16_ = item;
			if (item_end == _tmp16_) {
				passed_end = TRUE;
			}
			if (passed_start) {
				_tmp17_ = TRUE;
			} else {
				_tmp17_ = passed_end;
			}
			if (_tmp17_) {
				Marker* _tmp18_;
				DataObject* _tmp19_;
				_tmp18_ = marker;
				_tmp19_ = object;
				marker_mark (_tmp18_, (DataObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_VIEW, DataView));
			}
			if (passed_start) {
				_tmp20_ = passed_end;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				_g_object_unref0 (item);
				_g_object_unref0 (object);
				break;
			}
			_g_object_unref0 (item);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp21_ = page_get_view ((Page*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = marker;
	view_collection_select_marked (_tmp22_, _tmp23_);
	_data_collection_unref0 (_tmp22_);
	_g_object_unref0 (marker);
}

void
checkerboard_page_select_anchor_to_cursor (CheckerboardPage* self,
                                           guint state)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->cursor;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		CheckerboardItem* _tmp2_;
		_tmp2_ = self->anchor;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	if (state == ((guint) GDK_SHIFT_MASK)) {
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		CheckerboardItem* _tmp5_;
		CheckerboardItem* _tmp6_;
		_tmp3_ = page_get_view ((Page*) self);
		_tmp4_ = _tmp3_;
		view_collection_unselect_all (_tmp4_);
		_data_collection_unref0 (_tmp4_);
		_tmp5_ = self->anchor;
		_tmp6_ = self->cursor;
		checkerboard_page_select_between_items (self, _tmp5_, _tmp6_);
	} else {
		CheckerboardItem* _tmp7_;
		CheckerboardItem* _tmp8_;
		_tmp7_ = self->cursor;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (self->anchor);
		self->anchor = _tmp8_;
	}
}

static void
checkerboard_page_real_set_display_titles (CheckerboardPage* self,
                                           gboolean display)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	GValue _tmp4_ = {0};
	ViewCollection* _tmp5_;
	ViewCollection* _tmp6_;
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	data_collection_freeze_notifications ((DataCollection*) _tmp1_);
	_data_collection_unref0 (_tmp1_);
	_tmp2_ = page_get_view ((Page*) self);
	_tmp3_ = _tmp2_;
	g_value_init (&_tmp4_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp4_, display);
	data_collection_set_property ((DataCollection*) _tmp3_, CHECKERBOARD_ITEM_PROP_SHOW_TITLES, &_tmp4_, NULL, NULL);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_data_collection_unref0 (_tmp3_);
	_tmp5_ = page_get_view ((Page*) self);
	_tmp6_ = _tmp5_;
	data_collection_thaw_notifications ((DataCollection*) _tmp6_);
	_data_collection_unref0 (_tmp6_);
}

void
checkerboard_page_set_display_titles (CheckerboardPage* self,
                                      gboolean display)
{
	CheckerboardPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->set_display_titles) {
		_klass_->set_display_titles (self, display);
	}
}

static void
checkerboard_page_real_set_display_comments (CheckerboardPage* self,
                                             gboolean display)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	GValue _tmp4_ = {0};
	ViewCollection* _tmp5_;
	ViewCollection* _tmp6_;
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	data_collection_freeze_notifications ((DataCollection*) _tmp1_);
	_data_collection_unref0 (_tmp1_);
	_tmp2_ = page_get_view ((Page*) self);
	_tmp3_ = _tmp2_;
	g_value_init (&_tmp4_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp4_, display);
	data_collection_set_property ((DataCollection*) _tmp3_, CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, &_tmp4_, NULL, NULL);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_data_collection_unref0 (_tmp3_);
	_tmp5_ = page_get_view ((Page*) self);
	_tmp6_ = _tmp5_;
	data_collection_thaw_notifications ((DataCollection*) _tmp6_);
	_data_collection_unref0 (_tmp6_);
}

void
checkerboard_page_set_display_comments (CheckerboardPage* self,
                                        gboolean display)
{
	CheckerboardPageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHECKERBOARD_PAGE_GET_CLASS (self);
	if (_klass_->set_display_comments) {
		_klass_->set_display_comments (self, display);
	}
}

static void
_checkerboard_page_on_items_hidden_view_collection_items_hidden (ViewCollection* _sender,
                                                                 GeeCollection* hidden,
                                                                 gpointer self)
{
	checkerboard_page_on_items_hidden ((CheckerboardPage*) self, hidden);
}

static void
_checkerboard_page_on_contents_altered_data_collection_contents_altered (DataCollection* _sender,
                                                                         GeeIterable* added,
                                                                         GeeIterable* removed,
                                                                         gpointer self)
{
	checkerboard_page_on_contents_altered ((CheckerboardPage*) self, added, removed);
}

static void
_checkerboard_page_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                               GeeIterable* changed,
                                                                               gpointer self)
{
	checkerboard_page_on_items_state_changed ((CheckerboardPage*) self, changed);
}

static void
_checkerboard_page_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                         GeeCollection* changed,
                                                                                         gpointer self)
{
	checkerboard_page_on_items_visibility_changed ((CheckerboardPage*) self, changed);
}

static void
_checkerboard_page___lambda116_ (CheckerboardPage* self)
{
	CheckerboardLayout* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->layout;
	_tmp1_ = page_get_page_name ((Page*) self);
	_tmp2_ = _tmp1_;
	checkerboard_layout_set_name (_tmp0_, _tmp2_);
}

static void
__checkerboard_page___lambda116__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_checkerboard_page___lambda116_ ((CheckerboardPage*) self);
}

static GObject *
checkerboard_page_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CheckerboardPage * self;
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	CheckerboardLayout* _tmp2_;
	CheckerboardLayout* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	CheckerboardLayout* _tmp6_;
	GtkViewport* _tmp7_;
	CheckerboardLayout* _tmp8_;
	CheckerboardLayout* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkViewport* _tmp12_;
	ViewCollection* _tmp13_;
	ViewCollection* _tmp14_;
	ViewCollection* _tmp15_;
	ViewCollection* _tmp16_;
	ViewCollection* _tmp17_;
	ViewCollection* _tmp18_;
	ViewCollection* _tmp19_;
	ViewCollection* _tmp20_;
	parent_class = G_OBJECT_CLASS (checkerboard_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_PAGE, CheckerboardPage);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = checkerboard_layout_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp2_;
	_data_collection_unref0 (_tmp1_);
	_tmp3_ = self->priv->layout;
	_tmp4_ = page_get_page_name ((Page*) self);
	_tmp5_ = _tmp4_;
	checkerboard_layout_set_name (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->layout;
	page_set_event_source ((Page*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->viewport;
	_tmp8_ = self->priv->layout;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->layout;
	_tmp10_ = gtk_scrolled_window_get_hadjustment ((GtkScrolledWindow*) self);
	_tmp11_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
	checkerboard_layout_set_adjustments (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->viewport;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	_tmp13_ = page_get_view ((Page*) self);
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "items-hidden", (GCallback) _checkerboard_page_on_items_hidden_view_collection_items_hidden, self, 0);
	_data_collection_unref0 (_tmp14_);
	_tmp15_ = page_get_view ((Page*) self);
	_tmp16_ = _tmp15_;
	g_signal_connect_object ((DataCollection*) _tmp16_, "contents-altered", (GCallback) _checkerboard_page_on_contents_altered_data_collection_contents_altered, self, 0);
	_data_collection_unref0 (_tmp16_);
	_tmp17_ = page_get_view ((Page*) self);
	_tmp18_ = _tmp17_;
	g_signal_connect_object (_tmp18_, "items-state-changed", (GCallback) _checkerboard_page_on_items_state_changed_view_collection_items_state_changed, self, 0);
	_data_collection_unref0 (_tmp18_);
	_tmp19_ = page_get_view ((Page*) self);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "items-visibility-changed", (GCallback) _checkerboard_page_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
	_data_collection_unref0 (_tmp20_);
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	g_signal_connect_object ((GObject*) self, "notify::page_name", (GCallback) __checkerboard_page___lambda116__g_object_notify, self, 0);
	return obj;
}

static void
checkerboard_page_class_init (CheckerboardPageClass * klass,
                              gpointer klass_data)
{
	checkerboard_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheckerboardPage_private_offset);
	((CheckerboardPageClass *) klass)->get_back_name = (gchar* (*) (CheckerboardPage*)) checkerboard_page_real_get_back_name;
	((CheckerboardPageClass *) klass)->get_item_context_menu = (GtkMenu* (*) (CheckerboardPage*)) checkerboard_page_real_get_item_context_menu;
	((PageClass *) klass)->on_context_keypress = (gboolean (*) (Page*)) checkerboard_page_real_on_context_keypress;
	((CheckerboardPageClass *) klass)->get_view_empty_message = (gchar* (*) (CheckerboardPage*)) checkerboard_page_real_get_view_empty_message;
	((CheckerboardPageClass *) klass)->get_filter_no_match_message = (gchar* (*) (CheckerboardPage*)) checkerboard_page_real_get_filter_no_match_message;
	((CheckerboardPageClass *) klass)->on_item_activated = (void (*) (CheckerboardPage*, CheckerboardItem*)) checkerboard_page_real_on_item_activated;
	((CheckerboardPageClass *) klass)->get_search_view_filter = (SearchViewFilter* (*) (CheckerboardPage*)) checkerboard_page_real_get_search_view_filter;
	((CheckerboardPageClass *) klass)->get_view_tracker = (CoreViewTracker* (*) (CheckerboardPage*)) checkerboard_page_real_get_view_tracker;
	((PageClass *) klass)->switching_from = (void (*) (Page*)) checkerboard_page_real_switching_from;
	((PageClass *) klass)->switched_to = (void (*) (Page*)) checkerboard_page_real_switched_to;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) checkerboard_page_real_key_press_event;
	((CheckerboardPageClass *) klass)->is_point_on_item_selection_button = (gboolean (*) (CheckerboardPage*, gdouble, gdouble, CheckerboardItem*)) checkerboard_page_real_is_point_on_item_selection_button;
	((PageClass *) klass)->on_left_click = (gboolean (*) (Page*, GdkEventButton*)) checkerboard_page_real_on_left_click;
	((PageClass *) klass)->on_left_released = (gboolean (*) (Page*, GdkEventButton*)) checkerboard_page_real_on_left_released;
	((PageClass *) klass)->on_right_click = (gboolean (*) (Page*, GdkEventButton*)) checkerboard_page_real_on_right_click;
	((CheckerboardPageClass *) klass)->on_mouse_over = (gboolean (*) (CheckerboardPage*, CheckerboardItem*, gint, gint, GdkModifierType)) checkerboard_page_real_on_mouse_over;
	((PageClass *) klass)->on_motion = (gboolean (*) (Page*, GdkEventMotion*, gint, gint, GdkModifierType)) checkerboard_page_real_on_motion;
	((CheckerboardPageClass *) klass)->set_display_titles = (void (*) (CheckerboardPage*, gboolean)) checkerboard_page_real_set_display_titles;
	((CheckerboardPageClass *) klass)->set_display_comments = (void (*) (CheckerboardPage*, gboolean)) checkerboard_page_real_set_display_comments;
	G_OBJECT_CLASS (klass)->constructor = checkerboard_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = checkerboard_page_finalize;
}

static void
checkerboard_page_instance_init (CheckerboardPage * self,
                                 gpointer klass)
{
	GtkViewport* _tmp0_;
	self->priv = checkerboard_page_get_instance_private (self);
	self->priv->page_sidebar_menu_path = NULL;
	_tmp0_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	self->priv->viewport = _tmp0_;
	self->anchor = NULL;
	self->cursor = NULL;
	self->priv->highlighted = NULL;
	self->priv->autoscroll_scheduled = FALSE;
	self->priv->selection_button_clicked = FALSE;
	self->priv->activated_item = NULL;
	self->priv->previously_selected = NULL;
}

static void
checkerboard_page_finalize (GObject * obj)
{
	CheckerboardPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_PAGE, CheckerboardPage);
	_g_object_unref0 (self->priv->layout);
	_g_free0 (self->priv->page_sidebar_menu_path);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->anchor);
	_g_object_unref0 (self->cursor);
	_g_object_unref0 (self->priv->highlighted);
	_g_object_unref0 (self->priv->activated_item);
	_g_object_unref0 (self->priv->previously_selected);
	G_OBJECT_CLASS (checkerboard_page_parent_class)->finalize (obj);
}

static GType
checkerboard_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardPage), 0, (GInstanceInitFunc) checkerboard_page_instance_init, NULL };
	GType checkerboard_page_type_id;
	checkerboard_page_type_id = g_type_register_static (TYPE_PAGE, "CheckerboardPage", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	CheckerboardPage_private_offset = g_type_add_instance_private (checkerboard_page_type_id, sizeof (CheckerboardPagePrivate));
	return checkerboard_page_type_id;
}

GType
checkerboard_page_get_type (void)
{
	static volatile gsize checkerboard_page_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_page_type_id__once)) {
		GType checkerboard_page_type_id;
		checkerboard_page_type_id = checkerboard_page_get_type_once ();
		g_once_init_leave (&checkerboard_page_type_id__once, checkerboard_page_type_id);
	}
	return checkerboard_page_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

