/* EventDirectoryItem.c generated by valac 0.56.18, the Vala compiler
 * generated from EventDirectoryItem.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <pango/pango.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_EVENT_DIRECTORY_ITEM (event_directory_item_get_type ())
#define EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem))
#define EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))
#define IS_EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_DIRECTORY_ITEM))
#define IS_EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_DIRECTORY_ITEM))
#define EVENT_DIRECTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))

typedef struct _EventDirectoryItem EventDirectoryItem;
typedef struct _EventDirectoryItemClass EventDirectoryItemClass;
typedef struct _EventDirectoryItemPrivate EventDirectoryItemPrivate;
enum  {
	EVENT_DIRECTORY_ITEM_0_PROPERTY,
	EVENT_DIRECTORY_ITEM_NUM_PROPERTIES
};
static GParamSpec* event_directory_item_properties[EVENT_DIRECTORY_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EventDirectoryItem {
	CheckerboardItem parent_instance;
	EventDirectoryItemPrivate * priv;
	Event* event;
};

struct _EventDirectoryItemClass {
	CheckerboardItemClass parent_class;
};

struct _EventDirectoryItemPrivate {
	GdkRectangle paul_lynde;
};

static gint EventDirectoryItem_private_offset;
static gpointer event_directory_item_parent_class = NULL;
VALA_EXTERN Scaling event_directory_item_squared_scaling;
Scaling event_directory_item_squared_scaling = {0};

VALA_EXTERN GType event_directory_item_get_type (void) G_GNUC_CONST ;
static void event_directory_item_on_events_altered (EventDirectoryItem* self,
                                             GeeMap* map);
static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                            GeeMap* items,
                                                                            gpointer self);
static gint event_directory_item_get_CROPPED_SCALE (void);
VALA_EXTERN EventDirectoryItem* event_directory_item_new (Event* event);
VALA_EXTERN EventDirectoryItem* event_directory_item_construct (GType object_type,
                                                    Event* event);
static gchar* event_directory_item_get_formatted_title (Event* event);
static void event_directory_item_get_paul_lynde_rect (MediaSource* source,
                                               GdkRectangle* result);
static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media,
                                                GdkRectangle* paul_lynde,
                                                GError** error);
static void event_directory_item_real_exposed (CheckerboardItem* base);
static void event_directory_item_update_comment (EventDirectoryItem* self,
                                          gboolean init);
static void event_directory_item_real_unexposed (CheckerboardItem* base);
static void event_directory_item_real_thumbnail_altered (ThumbnailView* base);
static void event_directory_item_real_paint (CheckerboardItem* base,
                                      cairo_t* ctx,
                                      GtkStyleContext* style_context);
static void event_directory_item_finalize (GObject * obj);
static GType event_directory_item_get_type_once (void);
static void _vala_event_directory_item_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
event_directory_item_get_instance_private (EventDirectoryItem* self)
{
	return G_STRUCT_MEMBER_P (self, EventDirectoryItem_private_offset);
}

static void
_event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender,
                                                                       GeeMap* items,
                                                                       gpointer self)
{
	event_directory_item_on_events_altered ((EventDirectoryItem*) self, items);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

EventDirectoryItem*
event_directory_item_construct (GType object_type,
                                Event* event)
{
	EventDirectoryItem * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	Event* _tmp9_;
	MediaSource* _tmp10_;
	MediaSource* _tmp11_;
	GdkRectangle _tmp12_ = {0};
	GdkRectangle _tmp13_;
	Dimensions _tmp14_ = {0};
	EventSourceCollection* _tmp15_;
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp1_ = _tmp0_;
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp3_ = _tmp2_;
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
	_tmp5_ = event_directory_item_get_formatted_title (event);
	_tmp6_ = _tmp5_;
	_tmp7_ = event_source_get_comment ((EventSource*) event);
	_tmp8_ = _tmp7_;
	self = (EventDirectoryItem*) checkerboard_item_construct (object_type, (ThumbnailSource*) event, &_tmp4_, _tmp6_, _tmp8_, TRUE, PANGO_ALIGN_CENTER);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = _g_object_ref0 (event);
	_g_object_unref0 (self->event);
	self->event = _tmp9_;
	_tmp10_ = event_get_primary_source (event);
	_tmp11_ = _tmp10_;
	event_directory_item_get_paul_lynde_rect (_tmp11_, &_tmp12_);
	self->priv->paul_lynde = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->paul_lynde;
	dimensions_for_rectangle (&_tmp13_, &_tmp14_);
	checkerboard_item_clear_image ((CheckerboardItem*) self, &_tmp14_);
	_tmp15_ = event_global;
	g_signal_connect_object ((DataCollection*) _tmp15_, "items-altered", (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self, 0);
	return self;
}

EventDirectoryItem*
event_directory_item_new (Event* event)
{
	return event_directory_item_construct (TYPE_EVENT_DIRECTORY_ITEM, event);
}

static void
event_directory_item_get_paul_lynde_rect (MediaSource* source,
                                          GdkRectangle* result)
{
	Dimensions scaled = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	GdkRectangle paul_lynde = {0};
	Dimensions _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Dimensions _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Dimensions _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (source != NULL);
	media_source_get_dimensions (source, PHOTO_EXCEPTION_NONE, &_tmp0_);
	scaling_get_scaled_dimensions (&event_directory_item_squared_scaling, &_tmp0_, &_tmp1_);
	scaled = _tmp1_;
	memset (&paul_lynde, 0, sizeof (GdkRectangle));
	_tmp2_ = scaled;
	_tmp3_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp4_ = _tmp3_;
	_tmp5_ = scaled;
	paul_lynde.x = CLAMP (_tmp2_.width - _tmp4_, 0, _tmp5_.width) / 2;
	_tmp6_ = scaled;
	_tmp7_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp8_ = _tmp7_;
	_tmp9_ = scaled;
	paul_lynde.y = CLAMP (_tmp6_.height - _tmp8_, 0, _tmp9_.height) / 2;
	_tmp10_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp11_ = _tmp10_;
	paul_lynde.width = _tmp11_;
	_tmp12_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp13_ = _tmp12_;
	paul_lynde.height = _tmp13_;
	*result = paul_lynde;
	return;
}

static GdkPixbuf*
event_directory_item_get_paul_lynde (MediaSource* media,
                                     GdkRectangle* paul_lynde,
                                     GError** error)
{
	GdkPixbuf* pixbuf = NULL;
	Scaling _tmp0_;
	GdkPixbuf* _tmp1_;
	Dimensions thumbnail_dimensions = {0};
	GdkPixbuf* _tmp2_;
	Dimensions _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	Dimensions _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp17_;
	Dimensions _tmp18_;
	GdkRectangle _tmp19_ = {0};
	GdkPixbuf* _tmp20_;
	GdkRectangle _tmp21_;
	GdkRectangle _tmp22_;
	GdkRectangle _tmp23_;
	GdkRectangle _tmp24_;
	GdkPixbuf* _tmp25_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (media != NULL, NULL);
	g_return_val_if_fail (paul_lynde != NULL, NULL);
	_tmp0_ = event_directory_item_squared_scaling;
	_tmp1_ = media_source_get_preview_pixbuf (media, &_tmp0_, &_inner_error0_);
	pixbuf = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = pixbuf;
	dimensions_for_pixbuf (_tmp2_, &_tmp3_);
	thumbnail_dimensions = _tmp3_;
	_tmp5_ = thumbnail_dimensions;
	_tmp6_ = *paul_lynde;
	if (_tmp5_.width > (2 * _tmp6_.width)) {
		_tmp4_ = TRUE;
	} else {
		Dimensions _tmp7_;
		GdkRectangle _tmp8_;
		_tmp7_ = thumbnail_dimensions;
		_tmp8_ = *paul_lynde;
		_tmp4_ = _tmp7_.height > (_tmp8_.height * 2);
	}
	if (_tmp4_) {
		LibraryPhoto* photo = NULL;
		LibraryPhoto* _tmp9_;
		GdkPixbuf* _tmp10_ = NULL;
		LibraryPhoto* _tmp11_;
		Scaling _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		Dimensions _tmp16_ = {0};
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (media, TYPE_LIBRARY_PHOTO, LibraryPhoto));
		photo = _tmp9_;
		_tmp11_ = photo;
		_tmp12_ = event_directory_item_squared_scaling;
		_tmp13_ = photo_source_get_pixbuf ((PhotoSource*) _tmp11_, &_tmp12_, &_inner_error0_);
		_tmp10_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (photo);
			_g_object_unref0 (pixbuf);
			return NULL;
		}
		_tmp14_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp14_;
		_tmp15_ = pixbuf;
		dimensions_for_pixbuf (_tmp15_, &_tmp16_);
		thumbnail_dimensions = _tmp16_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (photo);
	}
	_tmp17_ = *paul_lynde;
	_tmp18_ = thumbnail_dimensions;
	clamp_rectangle (&_tmp17_, &_tmp18_, &_tmp19_);
	*paul_lynde = _tmp19_;
	_tmp20_ = pixbuf;
	_tmp21_ = *paul_lynde;
	_tmp22_ = *paul_lynde;
	_tmp23_ = *paul_lynde;
	_tmp24_ = *paul_lynde;
	_tmp25_ = gdk_pixbuf_new_subpixbuf (_tmp20_, _tmp21_.x, _tmp22_.y, _tmp23_.width, _tmp24_.height);
	result = _tmp25_;
	_g_object_unref0 (pixbuf);
	return result;
}

static gchar*
event_directory_item_get_formatted_title (Event* event)
{
	gboolean has_photos = FALSE;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean has_videos = FALSE;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	gboolean _tmp5_;
	gint count = 0;
	gchar* count_text = NULL;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gchar* daterange = NULL;
	gchar* _tmp11_;
	gchar* name = NULL;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = event_source_get_media ((EventSource*) event);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_collection_has_photo (_tmp1_);
	_g_object_unref0 (_tmp1_);
	has_photos = _tmp2_;
	_tmp3_ = event_source_get_media ((EventSource*) event);
	_tmp4_ = _tmp3_;
	_tmp5_ = media_source_collection_has_video (_tmp4_);
	_g_object_unref0 (_tmp4_);
	has_videos = _tmp5_;
	count = event_source_get_media_count ((EventSource*) event);
	_tmp6_ = g_strdup ("");
	count_text = _tmp6_;
	if (has_photos) {
		_tmp7_ = has_videos;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup_printf (ngettext ("%d Photo/Video", "%d Photos/Videos", (gulong) count), count);
		_g_free0 (count_text);
		count_text = _tmp8_;
	} else {
		if (has_videos) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup_printf (ngettext ("%d Video", "%d Videos", (gulong) count), count);
			_g_free0 (count_text);
			count_text = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup_printf (ngettext ("%d Photo", "%d Photos", (gulong) count), count);
			_g_free0 (count_text);
			count_text = _tmp10_;
		}
	}
	_tmp11_ = event_get_formatted_daterange (event);
	daterange = _tmp11_;
	_tmp12_ = data_object_get_name ((DataObject*) event);
	name = _tmp12_;
	_tmp14_ = daterange;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = daterange;
		_tmp16_ = name;
		_tmp13_ = g_strcmp0 (_tmp15_, _tmp16_) == 0;
	}
	if (_tmp13_) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp17_ = name;
		_tmp18_ = guarded_markup_escape_text (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = count_text;
		_tmp21_ = guarded_markup_escape_text (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp19_, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		result = _tmp24_;
		_g_free0 (name);
		_g_free0 (daterange);
		_g_free0 (count_text);
		return result;
	} else {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp25_ = name;
		_tmp26_ = guarded_markup_escape_text (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = count_text;
		_tmp29_ = guarded_markup_escape_text (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = daterange;
		_tmp32_ = guarded_markup_escape_text (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup_printf ("<b>%s</b>\n%s\n%s", _tmp27_, _tmp30_, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp27_);
		result = _tmp35_;
		_g_free0 (name);
		_g_free0 (daterange);
		_g_free0 (count_text);
		return result;
	}
}

static void
event_directory_item_real_exposed (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	GError* _inner_error0_ = NULL;
	self = (EventDirectoryItem*) base;
	if (checkerboard_item_is_exposed ((CheckerboardItem*) self)) {
		return;
	}
	{
		GdkPixbuf* _tmp0_ = NULL;
		Event* _tmp1_;
		MediaSource* _tmp2_;
		MediaSource* _tmp3_;
		GdkRectangle _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp1_ = self->event;
		_tmp2_ = event_get_primary_source (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->paul_lynde;
		_tmp5_ = event_directory_item_get_paul_lynde (_tmp3_, &_tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_tmp0_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		checkerboard_item_set_image ((CheckerboardItem*) self, _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		Event* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = self->event;
		_tmp8_ = data_object_to_string ((DataObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_critical ("EventDirectoryItem.vala:122: Unable to fetch preview for %s: %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	event_directory_item_update_comment (self, FALSE);
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
event_directory_item_real_unexposed (CheckerboardItem* base)
{
	EventDirectoryItem * self;
	GdkRectangle _tmp0_;
	Dimensions _tmp1_ = {0};
	self = (EventDirectoryItem*) base;
	if (!checkerboard_item_is_exposed ((CheckerboardItem*) self)) {
		return;
	}
	_tmp0_ = self->priv->paul_lynde;
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
	checkerboard_item_clear_image ((CheckerboardItem*) self, &_tmp1_);
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
}

static void
event_directory_item_on_events_altered (EventDirectoryItem* self,
                                        GeeMap* map)
{
	Event* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	event_directory_item_update_comment (self, FALSE);
	_tmp0_ = self->event;
	if (gee_map_has_key (map, (DataObject*) _tmp0_)) {
		Event* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->event;
		_tmp2_ = event_directory_item_get_formatted_title (_tmp1_);
		_tmp3_ = _tmp2_;
		checkerboard_item_set_title ((CheckerboardItem*) self, _tmp3_, TRUE, PANGO_ALIGN_CENTER);
		_g_free0 (_tmp3_);
	}
}

static void
event_directory_item_real_thumbnail_altered (ThumbnailView* base)
{
	EventDirectoryItem * self;
	MediaSource* media = NULL;
	Event* _tmp0_;
	MediaSource* _tmp1_;
	MediaSource* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	GError* _inner_error0_ = NULL;
	self = (EventDirectoryItem*) base;
	_tmp0_ = self->event;
	_tmp1_ = event_get_primary_source (_tmp0_);
	media = _tmp1_;
	_tmp2_ = media;
	event_directory_item_get_paul_lynde_rect (_tmp2_, &_tmp3_);
	self->priv->paul_lynde = _tmp3_;
	if (checkerboard_item_is_exposed ((CheckerboardItem*) self)) {
		{
			GdkPixbuf* _tmp4_ = NULL;
			MediaSource* _tmp5_;
			GdkRectangle _tmp6_;
			GdkPixbuf* _tmp7_;
			_tmp5_ = media;
			_tmp6_ = self->priv->paul_lynde;
			_tmp7_ = event_directory_item_get_paul_lynde (_tmp5_, &_tmp6_, &_inner_error0_);
			_tmp4_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			checkerboard_item_set_image ((CheckerboardItem*) self, _tmp4_);
			_g_object_unref0 (_tmp4_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			Event* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = self->event;
			_tmp9_ = data_object_to_string ((DataObject*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			g_critical ("EventDirectoryItem.vala:155: Unable to fetch preview for %s: %s", _tmp10_, _tmp12_);
			_g_free0 (_tmp10_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (media);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GdkRectangle _tmp13_;
		Dimensions _tmp14_ = {0};
		_tmp13_ = self->priv->paul_lynde;
		dimensions_for_rectangle (&_tmp13_, &_tmp14_);
		checkerboard_item_clear_image ((CheckerboardItem*) self, &_tmp14_);
	}
	THUMBNAIL_VIEW_CLASS (event_directory_item_parent_class)->thumbnail_altered ((ThumbnailView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
	_g_object_unref0 (media);
}

static void
event_directory_item_real_paint (CheckerboardItem* base,
                                 cairo_t* ctx,
                                 GtkStyleContext* style_context)
{
	EventDirectoryItem * self;
	self = (EventDirectoryItem*) base;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (style_context != NULL);
	gtk_style_context_save (style_context);
	gtk_style_context_add_class (style_context, "event");
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), ctx, style_context);
	gtk_style_context_restore (style_context);
}

static void
event_directory_item_update_comment (EventDirectoryItem* self,
                                     gboolean init)
{
	gchar* comment = NULL;
	Event* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->event;
	_tmp1_ = event_source_get_comment ((EventSource*) _tmp0_);
	comment = _tmp1_;
	_tmp2_ = comment;
	if (is_string_empty (_tmp2_)) {
		checkerboard_item_clear_comment ((CheckerboardItem*) self);
	} else {
		if (!init) {
			const gchar* _tmp3_;
			_tmp3_ = comment;
			checkerboard_item_set_comment ((CheckerboardItem*) self, _tmp3_, FALSE, PANGO_ALIGN_LEFT);
		} else {
			checkerboard_item_set_comment ((CheckerboardItem*) self, "", FALSE, PANGO_ALIGN_LEFT);
		}
	}
	_g_free0 (comment);
}

static gint
event_directory_item_get_CROPPED_SCALE (void)
{
	gint result;
	result = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM) + ((thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_BIG) - thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM)) / 2);
	return result;
}

static void
event_directory_item_class_init (EventDirectoryItemClass * klass,
                                 gpointer klass_data)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	Dimensions _tmp4_ = {0};
	Scaling _tmp5_ = {0};
	event_directory_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EventDirectoryItem_private_offset);
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem*)) event_directory_item_real_exposed;
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem*)) event_directory_item_real_unexposed;
	((ThumbnailViewClass *) klass)->thumbnail_altered = (void (*) (ThumbnailView*)) event_directory_item_real_thumbnail_altered;
	((CheckerboardItemClass *) klass)->paint = (void (*) (CheckerboardItem*, cairo_t*, GtkStyleContext*)) event_directory_item_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_event_directory_item_get_property;
	G_OBJECT_CLASS (klass)->finalize = event_directory_item_finalize;
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp1_ = _tmp0_;
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
	_tmp3_ = _tmp2_;
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
	scaling_to_fill_viewport (&_tmp4_, &_tmp5_);
	event_directory_item_squared_scaling = _tmp5_;
}

static void
event_directory_item_instance_init (EventDirectoryItem * self,
                                    gpointer klass)
{
	self->priv = event_directory_item_get_instance_private (self);
	memset (&self->priv->paul_lynde, 0, sizeof (GdkRectangle));
}

static void
event_directory_item_finalize (GObject * obj)
{
	EventDirectoryItem * self;
	EventSourceCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	_tmp0_ = event_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self);
	_g_object_unref0 (self->event);
	G_OBJECT_CLASS (event_directory_item_parent_class)->finalize (obj);
}

static GType
event_directory_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EventDirectoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_directory_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventDirectoryItem), 0, (GInstanceInitFunc) event_directory_item_instance_init, NULL };
	GType event_directory_item_type_id;
	event_directory_item_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "EventDirectoryItem", &g_define_type_info, 0);
	EventDirectoryItem_private_offset = g_type_add_instance_private (event_directory_item_type_id, sizeof (EventDirectoryItemPrivate));
	return event_directory_item_type_id;
}

GType
event_directory_item_get_type (void)
{
	static volatile gsize event_directory_item_type_id__once = 0;
	if (g_once_init_enter (&event_directory_item_type_id__once)) {
		GType event_directory_item_type_id;
		event_directory_item_type_id = event_directory_item_get_type_once ();
		g_once_init_leave (&event_directory_item_type_id__once, event_directory_item_type_id);
	}
	return event_directory_item_type_id__once;
}

static void
_vala_event_directory_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	EventDirectoryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

