/* TopDisplay.c generated by valac 0.56.18, the Vala compiler
 * generated from TopDisplay.vala, do not modify */

/*
* Copyright (c) 2016-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <pango/pango.h>

#define TOP_DISPLAY_BACKGROUND_PROGRESS_PULSE_MSEC 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TOP_DISPLAY_0_PROPERTY,
	TOP_DISPLAY_TITLE_PROPERTY,
	TOP_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* top_display_properties[TOP_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TopDisplayPrivate {
	GtkLabel* title_label;
	GtkLabel* background_progress_label;
	GtkProgressBar* background_progress_bar;
	gint current_priority;
	guint background_progress_pulse_id;
};

static gint TopDisplay_private_offset;
static gpointer top_display_parent_class = NULL;

static void top_display_set_show_progress (TopDisplay* self,
                                    gboolean value);
static gboolean top_display_on_pulse_background_progress_bar (TopDisplay* self);
static gboolean _top_display_on_pulse_background_progress_bar_gsource_func (gpointer self);
static GObject * top_display_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void top_display_finalize (GObject * obj);
static GType top_display_get_type_once (void);
static void _vala_top_display_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
top_display_get_instance_private (TopDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, TopDisplay_private_offset);
}

TopDisplay*
top_display_construct (GType object_type)
{
	TopDisplay * self = NULL;
	self = (TopDisplay*) g_object_new (object_type, "transition-type", GTK_STACK_TRANSITION_TYPE_CROSSFADE, NULL);
	return self;
}

TopDisplay*
top_display_new (void)
{
	return top_display_construct (TYPE_TOP_DISPLAY);
}

static gboolean
_top_display_on_pulse_background_progress_bar_gsource_func (gpointer self)
{
	gboolean result;
	result = top_display_on_pulse_background_progress_bar ((TopDisplay*) self);
	return result;
}

void
top_display_start_pulse_background_progress_bar (TopDisplay* self,
                                                 const gchar* label,
                                                 gint priority)
{
	GtkLabel* _tmp0_;
	GtkProgressBar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	if (priority < self->priv->current_priority) {
		return;
	}
	top_display_stop_pulse_background_progress_bar (self, priority, FALSE);
	self->priv->current_priority = priority;
	_tmp0_ = self->priv->background_progress_label;
	gtk_label_set_label (_tmp0_, label);
	_tmp1_ = self->priv->background_progress_bar;
	gtk_progress_bar_pulse (_tmp1_);
	top_display_set_show_progress (self, TRUE);
	if (self->priv->background_progress_pulse_id > ((guint) 0)) {
		g_source_remove (self->priv->background_progress_pulse_id);
	}
	self->priv->background_progress_pulse_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) TOP_DISPLAY_BACKGROUND_PROGRESS_PULSE_MSEC, _top_display_on_pulse_background_progress_bar_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
top_display_on_pulse_background_progress_bar (TopDisplay* self)
{
	GtkProgressBar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->background_progress_bar;
	gtk_progress_bar_pulse (_tmp0_);
	result = TRUE;
	return result;
}

void
top_display_stop_pulse_background_progress_bar (TopDisplay* self,
                                                gint priority,
                                                gboolean clear)
{
	g_return_if_fail (self != NULL);
	if (priority < self->priv->current_priority) {
		return;
	}
	if (self->priv->background_progress_pulse_id > ((guint) 0)) {
		g_source_remove (self->priv->background_progress_pulse_id);
		self->priv->background_progress_pulse_id = (guint) 0;
	}
	if (clear) {
		top_display_clear_background_progress_bar (self, priority);
	}
}

void
top_display_update_background_progress_bar (TopDisplay* self,
                                            const gchar* label,
                                            gint priority,
                                            gdouble count,
                                            gdouble total)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble fraction = 0.0;
	GtkProgressBar* _tmp2_;
	GtkLabel* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	if (priority < self->priv->current_priority) {
		return;
	}
	top_display_stop_pulse_background_progress_bar (self, priority, FALSE);
	if (count <= 0.0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = total <= 0.0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = count >= total;
	}
	if (_tmp0_) {
		top_display_clear_background_progress_bar (self, priority);
		return;
	}
	self->priv->current_priority = priority;
	fraction = count / total;
	_tmp2_ = self->priv->background_progress_bar;
	gtk_progress_bar_set_fraction (_tmp2_, fraction);
	_tmp3_ = self->priv->background_progress_label;
	_tmp4_ = g_strdup_printf (_ ("%s (%d%%)"), label, (gint) (fraction * 100.0));
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	top_display_set_show_progress (self, TRUE);
	granite_services_application_set_progress_visible (TRUE, NULL, NULL);
	granite_services_application_set_progress (fraction, NULL, NULL);
}

void
top_display_clear_background_progress_bar (TopDisplay* self,
                                           gint priority)
{
	GtkProgressBar* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	if (priority < self->priv->current_priority) {
		return;
	}
	top_display_stop_pulse_background_progress_bar (self, priority, FALSE);
	self->priv->current_priority = 0;
	_tmp0_ = self->priv->background_progress_bar;
	gtk_progress_bar_set_fraction (_tmp0_, 0.0);
	_tmp1_ = self->priv->background_progress_label;
	gtk_label_set_label (_tmp1_, "");
	top_display_set_show_progress (self, FALSE);
	granite_services_application_set_progress_visible (FALSE, NULL, NULL);
	granite_services_application_set_progress (0.0, NULL, NULL);
}

static void
top_display_set_show_progress (TopDisplay* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		gtk_stack_set_visible_child_name ((GtkStack*) self, "progress");
	} else {
		GtkLabel* _tmp0_;
		_tmp0_ = self->priv->title_label;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp0_);
	}
}

void
top_display_set_title (TopDisplay* self,
                       const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, top_display_properties[TOP_DISPLAY_TITLE_PROPERTY]);
}

static GObject *
top_display_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TopDisplay * self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkProgressBar* _tmp6_;
	GtkProgressBar* _tmp7_;
	GtkGrid* progress_grid = NULL;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkLabel* _tmp13_;
	GtkGrid* _tmp14_;
	GtkProgressBar* _tmp15_;
	GtkLabel* _tmp16_;
	GtkGrid* _tmp17_;
	parent_class = G_OBJECT_CLASS (top_display_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOP_DISPLAY, TopDisplay);
	gtk_widget_set_hexpand ((GtkWidget*) self, FALSE);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Photos"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp0_;
	_tmp1_ = self->priv->title_label;
	gtk_label_set_ellipsize (_tmp1_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp2_ = self->priv->title_label;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_TITLE);
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->background_progress_label);
	self->priv->background_progress_label = _tmp4_;
	_tmp5_ = self->priv->background_progress_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->background_progress_bar);
	self->priv->background_progress_bar = _tmp6_;
	_tmp7_ = self->priv->background_progress_bar;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	progress_grid = _tmp8_;
	_tmp9_ = progress_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp9_, GTK_ORIENTATION_VERTICAL);
	_tmp10_ = progress_grid;
	gtk_grid_set_row_spacing (_tmp10_, 6);
	_tmp11_ = progress_grid;
	g_object_set ((GtkWidget*) _tmp11_, "width-request", 200, NULL);
	_tmp12_ = progress_grid;
	_tmp13_ = self->priv->background_progress_label;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = progress_grid;
	_tmp15_ = self->priv->background_progress_bar;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->title_label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = progress_grid;
	gtk_stack_add_named ((GtkStack*) self, (GtkWidget*) _tmp17_, "progress");
	_g_object_unref0 (progress_grid);
	return obj;
}

static void
top_display_class_init (TopDisplayClass * klass,
                        gpointer klass_data)
{
	top_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TopDisplay_private_offset);
	G_OBJECT_CLASS (klass)->set_property = _vala_top_display_set_property;
	G_OBJECT_CLASS (klass)->constructor = top_display_constructor;
	G_OBJECT_CLASS (klass)->finalize = top_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TOP_DISPLAY_TITLE_PROPERTY, top_display_properties[TOP_DISPLAY_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
top_display_instance_init (TopDisplay * self,
                           gpointer klass)
{
	self->priv = top_display_get_instance_private (self);
	self->priv->current_priority = 0;
	self->priv->background_progress_pulse_id = 0U;
}

static void
top_display_finalize (GObject * obj)
{
	TopDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOP_DISPLAY, TopDisplay);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->background_progress_label);
	_g_object_unref0 (self->priv->background_progress_bar);
	G_OBJECT_CLASS (top_display_parent_class)->finalize (obj);
}

static GType
top_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TopDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) top_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TopDisplay), 0, (GInstanceInitFunc) top_display_instance_init, NULL };
	GType top_display_type_id;
	top_display_type_id = g_type_register_static (gtk_stack_get_type (), "TopDisplay", &g_define_type_info, 0);
	TopDisplay_private_offset = g_type_add_instance_private (top_display_type_id, sizeof (TopDisplayPrivate));
	return top_display_type_id;
}

GType
top_display_get_type (void)
{
	static volatile gsize top_display_type_id__once = 0;
	if (g_once_init_enter (&top_display_type_id__once)) {
		GType top_display_type_id;
		top_display_type_id = top_display_get_type_once ();
		g_once_init_leave (&top_display_type_id__once, top_display_type_id);
	}
	return top_display_type_id__once;
}

static void
_vala_top_display_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	TopDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TOP_DISPLAY, TopDisplay);
	switch (property_id) {
		case TOP_DISPLAY_TITLE_PROPERTY:
		top_display_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

