/* Exporter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Exporter.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	EXPORTER_0_PROPERTY,
	EXPORTER_NUM_PROPERTIES
};
static GParamSpec* exporter_properties[EXPORTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define EXPORTER_TYPE_EXPORT_JOB (exporter_export_job_get_type ())
#define EXPORTER_EXPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob))
#define EXPORTER_EXPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJobClass))
#define EXPORTER_IS_EXPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXPORTER_TYPE_EXPORT_JOB))
#define EXPORTER_IS_EXPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EXPORTER_TYPE_EXPORT_JOB))
#define EXPORTER_EXPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJobClass))

typedef struct _ExporterExportJob ExporterExportJob;
typedef struct _ExporterExportJobClass ExporterExportJobClass;
typedef struct _ExporterExportJobPrivate ExporterExportJobPrivate;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scaling_free0(var) ((var == NULL) ? NULL : (var = (scaling_free (var), NULL)))
typedef struct _ParamSpecExporterUI ParamSpecExporterUI;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ExporterPrivate {
	GeeCollection* to_export;
	GFile** exported_files;
	gint exported_files_length1;
	gint _exported_files_size_;
	GFile* dir;
	Scaling scaling;
	gint completed_count;
	Workers* workers;
	ExporterCompletionCallback completion_callback;
	gpointer completion_callback_target;
	ExporterExportFailedCallback error_callback;
	gpointer error_callback_target;
	ExporterOverwriteCallback overwrite_callback;
	gpointer overwrite_callback_target;
	ProgressMonitor monitor;
	gpointer monitor_target;
	GCancellable* cancellable;
	gboolean replace_all;
	gboolean aborted;
	ExportFormatParameters export_params;
};

struct _ExporterExportJob {
	BackgroundJob parent_instance;
	ExporterExportJobPrivate * priv;
	MediaSource* media;
	GFile* dest;
	Scaling* scaling;
	JpegQuality* quality;
	PhotoFileFormat* format;
	GError* err;
	gboolean direct_copy_unmodified;
	gboolean export_metadata;
};

struct _ExporterExportJobClass {
	BackgroundJobClass parent_class;
};

struct _ExporterUIPrivate {
	Exporter* exporter;
	GCancellable* cancellable;
	ProgressDialog* progress_dialog;
	ExporterCompletionCallback completion_callback;
	gpointer completion_callback_target;
};

struct _ParamSpecExporterUI {
	GParamSpec parent_instance;
};

static gint Exporter_private_offset;
static gpointer exporter_parent_class = NULL;
static gpointer exporter_export_job_parent_class = NULL;
static gint ExporterUI_private_offset;
static gpointer exporter_ui_parent_class = NULL;

static void export_format_parameters_init (ExportFormatParameters *self,
                                    ExportFormatMode mode,
                                    PhotoFileFormat specified_format,
                                    JpegQuality quality);
static gboolean exporter_process_queue (Exporter* self);
static void exporter_export_completed (Exporter* self,
                                gboolean is_cancelled);
static void exporter_on_exported (Exporter* self,
                           BackgroundJob* j);
static GType exporter_export_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _vala_array_add1 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void exporter_on_export_cancelled (Exporter* self,
                                   BackgroundJob* j);
static GFile** _vala_array_dup2 (GFile** self,
                          gssize length);
static void _vala_array_add2 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN GFile* app_dirs_get_temp_dir (void);
static ExporterExportJob* exporter_export_job_new (Exporter* owner,
                                            MediaSource* media,
                                            GFile* dest,
                                            Scaling* scaling,
                                            JpegQuality* quality,
                                            PhotoFileFormat* format,
                                            GCancellable* cancellable,
                                            gboolean direct_copy_unmodified,
                                            gboolean export_metadata);
static ExporterExportJob* exporter_export_job_construct (GType object_type,
                                                  Exporter* owner,
                                                  MediaSource* media,
                                                  GFile* dest,
                                                  Scaling* scaling,
                                                  JpegQuality* quality,
                                                  PhotoFileFormat* format,
                                                  GCancellable* cancellable,
                                                  gboolean direct_copy_unmodified,
                                                  gboolean export_metadata);
static void _exporter_on_exported_completion_callback (BackgroundJob* job,
                                                gpointer self);
static void _exporter_on_export_cancelled_cancellation_callback (BackgroundJob* job,
                                                          gpointer self);
static JpegQuality* _jpeg_quality_dup (JpegQuality* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
static void exporter_export_job_real_execute (BackgroundJob* base);
static void exporter_export_job_finalize (BackgroundJob * obj);
static GType exporter_export_job_get_type_once (void);
static void exporter_finalize (GObject * obj);
static GType exporter_get_type_once (void);
static void exporter_ui_on_export_completed (ExporterUI* self,
                                      Exporter* exporter,
                                      gboolean is_cancelled);
static void _exporter_ui_on_export_completed_exporter_completion_callback (Exporter* exporter,
                                                                    gboolean is_cancelled,
                                                                    gpointer self);
static gboolean exporter_ui_on_export_failed (ExporterUI* self,
                                       Exporter* exporter,
                                       GFile* file,
                                       gint remaining,
                                       GError* err);
static gboolean _exporter_ui_on_export_failed_exporter_export_failed_callback (Exporter* exporter,
                                                                        GFile* file,
                                                                        gint remaining,
                                                                        GError* err,
                                                                        gpointer self);
static ExporterOverwrite exporter_ui_on_export_overwrite (ExporterUI* self,
                                                   Exporter* exporter,
                                                   GFile* file);
static ExporterOverwrite _exporter_ui_on_export_overwrite_exporter_overwrite_callback (Exporter* exporter,
                                                                                GFile* file,
                                                                                gpointer self);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
static void exporter_ui_finalize (ExporterUI * obj);
static GType exporter_ui_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GType
export_format_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{EXPORT_FORMAT_MODE_UNMODIFIED, "EXPORT_FORMAT_MODE_UNMODIFIED", "unmodified"}, {EXPORT_FORMAT_MODE_CURRENT, "EXPORT_FORMAT_MODE_CURRENT", "current"}, {EXPORT_FORMAT_MODE_SPECIFIED, "EXPORT_FORMAT_MODE_SPECIFIED", "specified"}, {EXPORT_FORMAT_MODE_LAST, "EXPORT_FORMAT_MODE_LAST", "last"}, {0, NULL, NULL}};
	GType export_format_mode_type_id;
	export_format_mode_type_id = g_enum_register_static ("ExportFormatMode", values);
	return export_format_mode_type_id;
}

GType
export_format_mode_get_type (void)
{
	static volatile gsize export_format_mode_type_id__once = 0;
	if (g_once_init_enter (&export_format_mode_type_id__once)) {
		GType export_format_mode_type_id;
		export_format_mode_type_id = export_format_mode_get_type_once ();
		g_once_init_leave (&export_format_mode_type_id__once, export_format_mode_type_id);
	}
	return export_format_mode_type_id__once;
}

static void
export_format_parameters_init (ExportFormatParameters *self,
                               ExportFormatMode mode,
                               PhotoFileFormat specified_format,
                               JpegQuality quality)
{
	memset (self, 0, sizeof (ExportFormatParameters));
	(*self).mode = mode;
	(*self).specified_format = specified_format;
	(*self).quality = quality;
	(*self).export_metadata = TRUE;
}

void
export_format_parameters_current (ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_CURRENT, photo_file_format_get_system_default_format (), JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_unmodified (ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_UNMODIFIED, photo_file_format_get_system_default_format (), JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_for_format (PhotoFileFormat format,
                                     ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_SPECIFIED, format, JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_last (ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_LAST, photo_file_format_get_system_default_format (), JPEG_QUALITY_HIGH);
	*result = _tmp0_;
	return;
}

void
export_format_parameters_for_jpeg (JpegQuality quality,
                                   ExportFormatParameters* result)
{
	ExportFormatParameters _tmp0_ = {0};
	export_format_parameters_init (&_tmp0_, EXPORT_FORMAT_MODE_SPECIFIED, PHOTO_FILE_FORMAT_JFIF, quality);
	*result = _tmp0_;
	return;
}

ExportFormatParameters*
export_format_parameters_dup (const ExportFormatParameters* self)
{
	ExportFormatParameters* dup;
	dup = g_new0 (ExportFormatParameters, 1);
	memcpy (dup, self, sizeof (ExportFormatParameters));
	return dup;
}

void
export_format_parameters_free (ExportFormatParameters* self)
{
	g_free (self);
}

static GType
export_format_parameters_get_type_once (void)
{
	GType export_format_parameters_type_id;
	export_format_parameters_type_id = g_boxed_type_register_static ("ExportFormatParameters", (GBoxedCopyFunc) export_format_parameters_dup, (GBoxedFreeFunc) export_format_parameters_free);
	return export_format_parameters_type_id;
}

GType
export_format_parameters_get_type (void)
{
	static volatile gsize export_format_parameters_type_id__once = 0;
	if (g_once_init_enter (&export_format_parameters_type_id__once)) {
		GType export_format_parameters_type_id;
		export_format_parameters_type_id = export_format_parameters_get_type_once ();
		g_once_init_leave (&export_format_parameters_type_id__once, export_format_parameters_type_id);
	}
	return export_format_parameters_type_id__once;
}

static inline gpointer
exporter_get_instance_private (Exporter* self)
{
	return G_STRUCT_MEMBER_P (self, Exporter_private_offset);
}

static GType
exporter_overwrite_get_type_once (void)
{
	static const GEnumValue values[] = {{EXPORTER_OVERWRITE_YES, "EXPORTER_OVERWRITE_YES", "yes"}, {EXPORTER_OVERWRITE_NO, "EXPORTER_OVERWRITE_NO", "no"}, {EXPORTER_OVERWRITE_CANCEL, "EXPORTER_OVERWRITE_CANCEL", "cancel"}, {EXPORTER_OVERWRITE_REPLACE_ALL, "EXPORTER_OVERWRITE_REPLACE_ALL", "replace-all"}, {0, NULL, NULL}};
	GType exporter_overwrite_type_id;
	exporter_overwrite_type_id = g_enum_register_static ("ExporterOverwrite", values);
	return exporter_overwrite_type_id;
}

GType
exporter_overwrite_get_type (void)
{
	static volatile gsize exporter_overwrite_type_id__once = 0;
	if (g_once_init_enter (&exporter_overwrite_type_id__once)) {
		GType exporter_overwrite_type_id;
		exporter_overwrite_type_id = exporter_overwrite_get_type_once ();
		g_once_init_leave (&exporter_overwrite_type_id__once, exporter_overwrite_type_id);
	}
	return exporter_overwrite_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Exporter*
exporter_construct (GType object_type,
                    GeeCollection* to_export,
                    GFile* dir,
                    Scaling* scaling,
                    ExportFormatParameters* export_params,
                    gboolean auto_replace_all)
{
	Exporter * self = NULL;
	GeeCollection* _tmp0_;
	GFile* _tmp1_;
	Scaling _tmp2_;
	ExportFormatParameters _tmp3_;
	g_return_val_if_fail (to_export != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	g_return_val_if_fail (export_params != NULL, NULL);
	self = (Exporter*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->to_export;
	gee_collection_add_all (_tmp0_, to_export);
	_tmp1_ = _g_object_ref0 (dir);
	_g_object_unref0 (self->priv->dir);
	self->priv->dir = _tmp1_;
	_tmp2_ = *scaling;
	self->priv->scaling = _tmp2_;
	_tmp3_ = *export_params;
	self->priv->export_params = _tmp3_;
	self->priv->replace_all = auto_replace_all;
	return self;
}

Exporter*
exporter_new (GeeCollection* to_export,
              GFile* dir,
              Scaling* scaling,
              ExportFormatParameters* export_params,
              gboolean auto_replace_all)
{
	return exporter_construct (TYPE_EXPORTER, to_export, dir, scaling, export_params, auto_replace_all);
}

Exporter*
exporter_construct_for_temp_file (GType object_type,
                                  GeeCollection* to_export,
                                  Scaling* scaling,
                                  ExportFormatParameters* export_params)
{
	Exporter * self = NULL;
	GeeCollection* _tmp0_;
	Scaling _tmp1_;
	ExportFormatParameters _tmp2_;
	g_return_val_if_fail (to_export != NULL, NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	g_return_val_if_fail (export_params != NULL, NULL);
	self = (Exporter*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->to_export;
	gee_collection_add_all (_tmp0_, to_export);
	_g_object_unref0 (self->priv->dir);
	self->priv->dir = NULL;
	_tmp1_ = *scaling;
	self->priv->scaling = _tmp1_;
	_tmp2_ = *export_params;
	self->priv->export_params = _tmp2_;
	return self;
}

Exporter*
exporter_new_for_temp_file (GeeCollection* to_export,
                            Scaling* scaling,
                            ExportFormatParameters* export_params)
{
	return exporter_construct_for_temp_file (TYPE_EXPORTER, to_export, scaling, export_params);
}

void
exporter_export (Exporter* self,
                 ExporterCompletionCallback completion_callback,
                 gpointer completion_callback_target,
                 ExporterExportFailedCallback error_callback,
                 gpointer error_callback_target,
                 ExporterOverwriteCallback overwrite_callback,
                 gpointer overwrite_callback_target,
                 GCancellable* cancellable,
                 ProgressMonitor monitor,
                 gpointer monitor_target)
{
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->completion_callback = completion_callback;
	self->priv->completion_callback_target = completion_callback_target;
	self->priv->error_callback = error_callback;
	self->priv->error_callback_target = error_callback_target;
	self->priv->overwrite_callback = overwrite_callback;
	self->priv->overwrite_callback_target = overwrite_callback_target;
	self->priv->monitor = monitor;
	self->priv->monitor_target = monitor_target;
	_tmp1_ = _g_object_ref0 (cancellable);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = g_cancellable_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	if (!exporter_process_queue (self)) {
		exporter_export_completed (self, TRUE);
	}
	_g_object_unref0 (_tmp0_);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
_vala_array_add1 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
exporter_on_exported (Exporter* self,
                      BackgroundJob* j)
{
	ExporterExportJob* job = NULL;
	ExporterExportJob* _tmp0_;
	gint _tmp1_;
	gboolean completed = FALSE;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob));
	job = _tmp0_;
	_tmp1_ = self->priv->completed_count;
	self->priv->completed_count = _tmp1_ + 1;
	_tmp2_ = self->priv->to_export;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	completed = self->priv->completed_count == _tmp4_;
	if (!self->priv->aborted) {
		ExporterExportJob* _tmp6_;
		GError* _tmp7_;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->err;
		_tmp5_ = _tmp7_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ExporterExportFailedCallback _tmp8_;
		gpointer _tmp8__target;
		ExporterExportJob* _tmp9_;
		GFile* _tmp10_;
		GeeCollection* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		ExporterExportJob* _tmp14_;
		GError* _tmp15_;
		_tmp8_ = self->priv->error_callback;
		_tmp8__target = self->priv->error_callback_target;
		_tmp9_ = job;
		_tmp10_ = _tmp9_->dest;
		_tmp11_ = self->priv->to_export;
		_tmp12_ = gee_collection_get_size (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = job;
		_tmp15_ = _tmp14_->err;
		if (!_tmp8_ (self, _tmp10_, _tmp13_ - self->priv->completed_count, _tmp15_, _tmp8__target)) {
			self->priv->aborted = TRUE;
			if (!completed) {
				_background_job_unref0 (job);
				return;
			}
		}
	}
	if (!self->priv->aborted) {
		ProgressMonitor _tmp17_;
		gpointer _tmp17__target;
		_tmp17_ = self->priv->monitor;
		_tmp17__target = self->priv->monitor_target;
		_tmp16_ = _tmp17_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ProgressMonitor _tmp18_;
		gpointer _tmp18__target;
		GeeCollection* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		_tmp18_ = self->priv->monitor;
		_tmp18__target = self->priv->monitor_target;
		_tmp19_ = self->priv->to_export;
		_tmp20_ = gee_collection_get_size (_tmp19_);
		_tmp21_ = _tmp20_;
		if (!_tmp18_ ((guint64) self->priv->completed_count, (guint64) _tmp21_, FALSE, _tmp18__target)) {
			self->priv->aborted = TRUE;
			if (!completed) {
				_background_job_unref0 (job);
				return;
			}
		} else {
			ExporterExportJob* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			_tmp22_ = job;
			_tmp23_ = _tmp22_->dest;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			_vala_array_add1 (&self->priv->exported_files, &self->priv->exported_files_length1, &self->priv->_exported_files_size_, _tmp24_);
		}
	}
	if (completed) {
		exporter_export_completed (self, FALSE);
	}
	_background_job_unref0 (job);
}

static void
exporter_on_export_cancelled (Exporter* self,
                              BackgroundJob* j)
{
	gint _tmp0_;
	GeeCollection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	self->priv->completed_count = self->priv->completed_count + 1;
	_tmp0_ = self->priv->completed_count;
	_tmp1_ = self->priv->to_export;
	_tmp2_ = gee_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0_ == _tmp3_) {
		exporter_export_completed (self, TRUE);
	}
}

static GFile**
_vala_array_dup2 (GFile** self,
                  gssize length)
{
	if (length >= 0) {
		GFile** result;
		gssize i;
		result = g_new0 (GFile*, length + 1);
		for (i = 0; i < length; i++) {
			GFile* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GFile**
exporter_get_exported_files (Exporter* self,
                             gint* result_length1)
{
	GFile** _tmp0_;
	gint _tmp0__length1;
	GFile** _tmp1_;
	gint _tmp1__length1;
	GFile** _tmp2_;
	gint _tmp2__length1;
	GFile** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->exported_files;
	_tmp0__length1 = self->priv->exported_files_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
_vala_array_add2 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
exporter_process_queue (Exporter* self)
{
	gint submitted = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	submitted = 0;
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->to_export;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GFile* use_source_file = NULL;
			PhotoFileFormat real_export_format = 0;
			gchar* basename = NULL;
			MediaSource* _tmp5_;
			const gchar* _tmp16_;
			GFile* _tmp17_;
			GFile* export_dir = NULL;
			GFile* _tmp27_;
			GFile* _tmp28_;
			GFile* dest = NULL;
			GFile* _tmp29_;
			Workers* _tmp63_;
			MediaSource* _tmp64_;
			GFile* _tmp65_;
			Scaling _tmp66_;
			ExportFormatParameters _tmp67_;
			GCancellable* _tmp68_;
			ExportFormatParameters _tmp69_;
			ExportFormatParameters _tmp70_;
			ExporterExportJob* _tmp71_;
			ExporterExportJob* _tmp72_;
			gint _tmp73_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (MediaSource*) _tmp4_;
			use_source_file = NULL;
			real_export_format = photo_file_format_get_system_default_format ();
			basename = NULL;
			_tmp5_ = source;
			if (IS_PHOTO (_tmp5_)) {
				Photo* photo = NULL;
				MediaSource* _tmp6_;
				Photo* _tmp7_;
				Photo* _tmp8_;
				ExportFormatParameters _tmp9_;
				Photo* _tmp10_;
				ExportFormatParameters _tmp11_;
				gchar* _tmp12_;
				_tmp6_ = source;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
				photo = _tmp7_;
				_tmp8_ = photo;
				_tmp9_ = self->priv->export_params;
				real_export_format = photo_get_export_format_for_parameters (_tmp8_, &_tmp9_);
				_tmp10_ = photo;
				_tmp11_ = self->priv->export_params;
				_tmp12_ = photo_get_export_basename_for_parameters (_tmp10_, &_tmp11_);
				_g_free0 (basename);
				basename = _tmp12_;
				_g_object_unref0 (photo);
			} else {
				MediaSource* _tmp13_;
				_tmp13_ = source;
				if (IS_VIDEO (_tmp13_)) {
					MediaSource* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = source;
					_tmp15_ = media_source_get_basename ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_VIDEO, Video));
					_g_free0 (basename);
					basename = _tmp15_;
				}
			}
			_tmp16_ = basename;
			_vala_assert (_tmp16_ != NULL, "basename != null");
			_tmp17_ = use_source_file;
			if (_tmp17_ != NULL) {
				GFile* _tmp18_;
				GFile* _tmp19_;
				gint _tmp20_;
				ProgressMonitor _tmp21_;
				gpointer _tmp21__target;
				_tmp18_ = use_source_file;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_vala_array_add2 (&self->priv->exported_files, &self->priv->exported_files_length1, &self->priv->_exported_files_size_, _tmp19_);
				_tmp20_ = self->priv->completed_count;
				self->priv->completed_count = _tmp20_ + 1;
				_tmp21_ = self->priv->monitor;
				_tmp21__target = self->priv->monitor_target;
				if (_tmp21_ != NULL) {
					ProgressMonitor _tmp22_;
					gpointer _tmp22__target;
					GeeCollection* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp22_ = self->priv->monitor;
					_tmp22__target = self->priv->monitor_target;
					_tmp23_ = self->priv->to_export;
					_tmp24_ = gee_collection_get_size (_tmp23_);
					_tmp25_ = _tmp24_;
					if (!_tmp22_ ((guint64) self->priv->completed_count, (guint64) _tmp25_, TRUE, _tmp22__target)) {
						GCancellable* _tmp26_;
						_tmp26_ = self->priv->cancellable;
						g_cancellable_cancel (_tmp26_);
						result = FALSE;
						_g_free0 (basename);
						_g_object_unref0 (use_source_file);
						_g_object_unref0 (source);
						_g_object_unref0 (_source_it);
						return result;
					}
				}
				_g_free0 (basename);
				_g_object_unref0 (use_source_file);
				_g_object_unref0 (source);
				continue;
			}
			_tmp27_ = self->priv->dir;
			_tmp28_ = _g_object_ref0 (_tmp27_);
			export_dir = _tmp28_;
			dest = NULL;
			_tmp29_ = export_dir;
			if (_tmp29_ == NULL) {
				{
					gboolean collision = FALSE;
					GFile* _tmp30_ = NULL;
					GFile* _tmp31_;
					GFile* _tmp32_;
					const gchar* _tmp33_;
					gboolean _tmp34_ = FALSE;
					GFile* _tmp35_;
					GFile* _tmp36_;
					GFile* _tmp37_;
					_tmp31_ = app_dirs_get_temp_dir ();
					_tmp32_ = _tmp31_;
					_tmp33_ = basename;
					_tmp35_ = generate_unique_file (_tmp32_, _tmp33_, &_tmp34_, &_inner_error0_);
					collision = _tmp34_;
					_tmp36_ = _tmp35_;
					_g_object_unref0 (_tmp32_);
					_tmp30_ = _tmp36_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp37_ = _tmp30_;
					_tmp30_ = NULL;
					_g_object_unref0 (dest);
					dest = _tmp37_;
					_g_object_unref0 (_tmp30_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					MediaSource* _tmp38_;
					GFile* _tmp39_;
					GFile* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					GError* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp38_ = source;
					_tmp39_ = media_source_get_file (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_file_get_basename (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = err;
					_tmp44_ = _tmp43_->message;
					_tmp45_ = g_strdup_printf (_ ("Unable to generate a temporary file for %s: %s"), _tmp42_, _tmp44_);
					_tmp46_ = _tmp45_;
					app_window_error_message (_tmp46_, NULL, NULL);
					_g_free0 (_tmp46_);
					_g_free0 (_tmp42_);
					_g_object_unref0 (_tmp40_);
					_g_error_free0 (err);
					_g_object_unref0 (dest);
					_g_object_unref0 (export_dir);
					_g_free0 (basename);
					_g_object_unref0 (use_source_file);
					_g_object_unref0 (source);
					break;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp47_ = FALSE;
					_g_object_unref0 (dest);
					_g_object_unref0 (export_dir);
					_g_free0 (basename);
					_g_object_unref0 (use_source_file);
					_g_object_unref0 (source);
					_g_object_unref0 (_source_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp47_;
				}
			} else {
				GFile* _tmp48_;
				const gchar* _tmp49_;
				GFile* _tmp50_;
				gboolean _tmp51_ = FALSE;
				_tmp48_ = self->priv->dir;
				_tmp49_ = basename;
				_tmp50_ = g_file_get_child (_tmp48_, _tmp49_);
				_g_object_unref0 (dest);
				dest = _tmp50_;
				if (!self->priv->replace_all) {
					GFile* _tmp52_;
					_tmp52_ = dest;
					_tmp51_ = g_file_query_exists (_tmp52_, NULL);
				} else {
					_tmp51_ = FALSE;
				}
				if (_tmp51_) {
					ExporterOverwriteCallback _tmp53_;
					gpointer _tmp53__target;
					GFile* _tmp54_;
					_tmp53_ = self->priv->overwrite_callback;
					_tmp53__target = self->priv->overwrite_callback_target;
					_tmp54_ = dest;
					switch (_tmp53_ (self, _tmp54_, _tmp53__target)) {
						case EXPORTER_OVERWRITE_YES:
						{
							break;
						}
						case EXPORTER_OVERWRITE_REPLACE_ALL:
						{
							self->priv->replace_all = TRUE;
							break;
						}
						case EXPORTER_OVERWRITE_CANCEL:
						{
							GCancellable* _tmp55_;
							_tmp55_ = self->priv->cancellable;
							g_cancellable_cancel (_tmp55_);
							result = FALSE;
							_g_object_unref0 (dest);
							_g_object_unref0 (export_dir);
							_g_free0 (basename);
							_g_object_unref0 (use_source_file);
							_g_object_unref0 (source);
							_g_object_unref0 (_source_it);
							return result;
						}
						default:
						case EXPORTER_OVERWRITE_NO:
						{
							gint _tmp56_;
							ProgressMonitor _tmp57_;
							gpointer _tmp57__target;
							_tmp56_ = self->priv->completed_count;
							self->priv->completed_count = _tmp56_ + 1;
							_tmp57_ = self->priv->monitor;
							_tmp57__target = self->priv->monitor_target;
							if (_tmp57_ != NULL) {
								ProgressMonitor _tmp58_;
								gpointer _tmp58__target;
								GeeCollection* _tmp59_;
								gint _tmp60_;
								gint _tmp61_;
								_tmp58_ = self->priv->monitor;
								_tmp58__target = self->priv->monitor_target;
								_tmp59_ = self->priv->to_export;
								_tmp60_ = gee_collection_get_size (_tmp59_);
								_tmp61_ = _tmp60_;
								if (!_tmp58_ ((guint64) self->priv->completed_count, (guint64) _tmp61_, TRUE, _tmp58__target)) {
									GCancellable* _tmp62_;
									_tmp62_ = self->priv->cancellable;
									g_cancellable_cancel (_tmp62_);
									result = FALSE;
									_g_object_unref0 (dest);
									_g_object_unref0 (export_dir);
									_g_free0 (basename);
									_g_object_unref0 (use_source_file);
									_g_object_unref0 (source);
									_g_object_unref0 (_source_it);
									return result;
								}
							}
							_g_object_unref0 (dest);
							_g_object_unref0 (export_dir);
							_g_free0 (basename);
							_g_object_unref0 (use_source_file);
							_g_object_unref0 (source);
							continue;
						}
					}
				}
			}
			_tmp63_ = self->priv->workers;
			_tmp64_ = source;
			_tmp65_ = dest;
			_tmp66_ = self->priv->scaling;
			_tmp67_ = self->priv->export_params;
			_tmp68_ = self->priv->cancellable;
			_tmp69_ = self->priv->export_params;
			_tmp70_ = self->priv->export_params;
			_tmp71_ = exporter_export_job_new (self, _tmp64_, _tmp65_, &_tmp66_, &_tmp67_.quality, &real_export_format, _tmp68_, _tmp69_.mode == EXPORT_FORMAT_MODE_UNMODIFIED, _tmp70_.export_metadata);
			_tmp72_ = _tmp71_;
			workers_enqueue (_tmp63_, (BackgroundJob*) _tmp72_);
			_background_job_unref0 (_tmp72_);
			_tmp73_ = submitted;
			submitted = _tmp73_ + 1;
			_g_object_unref0 (dest);
			_g_object_unref0 (export_dir);
			_g_free0 (basename);
			_g_object_unref0 (use_source_file);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	result = submitted > 0;
	return result;
}

static void
exporter_export_completed (Exporter* self,
                           gboolean is_cancelled)
{
	ExporterCompletionCallback _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->completion_callback;
	_tmp0__target = self->priv->completion_callback_target;
	_tmp0_ (self, is_cancelled, _tmp0__target);
}

static void
_exporter_on_exported_completion_callback (BackgroundJob* job,
                                           gpointer self)
{
	exporter_on_exported ((Exporter*) self, job);
}

static void
_exporter_on_export_cancelled_cancellation_callback (BackgroundJob* job,
                                                     gpointer self)
{
	exporter_on_export_cancelled ((Exporter*) self, job);
}

static gpointer
_scaling_dup0 (gpointer self)
{
	return self ? scaling_dup (self) : NULL;
}

static JpegQuality*
_jpeg_quality_dup (JpegQuality* self)
{
	JpegQuality* dup;
	dup = g_new0 (JpegQuality, 1);
	memcpy (dup, self, sizeof (JpegQuality));
	return dup;
}

static gpointer
__jpeg_quality_dup0 (gpointer self)
{
	return self ? _jpeg_quality_dup (self) : NULL;
}

static PhotoFileFormat*
_photo_file_format_dup (PhotoFileFormat* self)
{
	PhotoFileFormat* dup;
	dup = g_new0 (PhotoFileFormat, 1);
	memcpy (dup, self, sizeof (PhotoFileFormat));
	return dup;
}

static gpointer
__photo_file_format_dup0 (gpointer self)
{
	return self ? _photo_file_format_dup (self) : NULL;
}

static ExporterExportJob*
exporter_export_job_construct (GType object_type,
                               Exporter* owner,
                               MediaSource* media,
                               GFile* dest,
                               Scaling* scaling,
                               JpegQuality* quality,
                               PhotoFileFormat* format,
                               GCancellable* cancellable,
                               gboolean direct_copy_unmodified,
                               gboolean export_metadata)
{
	ExporterExportJob* self = NULL;
	gboolean _tmp0_ = FALSE;
	MediaSource* _tmp1_;
	GFile* _tmp2_;
	Scaling* _tmp3_;
	JpegQuality* _tmp4_;
	PhotoFileFormat* _tmp5_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (media != NULL, NULL);
	g_return_val_if_fail (dest != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (ExporterExportJob*) background_job_construct (object_type, (GObject*) owner, _exporter_on_exported_completion_callback, owner, cancellable, _exporter_on_export_cancelled_cancellation_callback, owner, NULL);
	if (IS_PHOTO (media)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = IS_VIDEO (media);
	}
	_vala_assert (_tmp0_, "media is Photo || media is Video");
	_tmp1_ = _g_object_ref0 (media);
	_g_object_unref0 (self->media);
	self->media = _tmp1_;
	_tmp2_ = _g_object_ref0 (dest);
	_g_object_unref0 (self->dest);
	self->dest = _tmp2_;
	_tmp3_ = _scaling_dup0 (scaling);
	_scaling_free0 (self->scaling);
	self->scaling = _tmp3_;
	_tmp4_ = __jpeg_quality_dup0 (quality);
	_g_free0 (self->quality);
	self->quality = _tmp4_;
	_tmp5_ = __photo_file_format_dup0 (format);
	_g_free0 (self->format);
	self->format = _tmp5_;
	self->direct_copy_unmodified = direct_copy_unmodified;
	self->export_metadata = export_metadata;
	return self;
}

static ExporterExportJob*
exporter_export_job_new (Exporter* owner,
                         MediaSource* media,
                         GFile* dest,
                         Scaling* scaling,
                         JpegQuality* quality,
                         PhotoFileFormat* format,
                         GCancellable* cancellable,
                         gboolean direct_copy_unmodified,
                         gboolean export_metadata)
{
	return exporter_export_job_construct (EXPORTER_TYPE_EXPORT_JOB, owner, media, dest, scaling, quality, format, cancellable, direct_copy_unmodified, export_metadata);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
exporter_export_job_real_execute (BackgroundJob* base)
{
	ExporterExportJob * self;
	GError* _inner_error0_ = NULL;
	self = (ExporterExportJob*) base;
	{
		MediaSource* _tmp0_;
		_tmp0_ = self->media;
		if (IS_PHOTO (_tmp0_)) {
			MediaSource* _tmp1_;
			GFile* _tmp2_;
			Scaling* _tmp3_;
			JpegQuality* _tmp4_;
			PhotoFileFormat* _tmp5_;
			Scaling _tmp6_;
			_tmp1_ = self->media;
			_tmp2_ = self->dest;
			_tmp3_ = self->scaling;
			_tmp4_ = self->quality;
			_tmp5_ = self->format;
			_tmp6_ = *_tmp3_;
			photo_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), _tmp2_, &_tmp6_, *_tmp4_, *_tmp5_, self->direct_copy_unmodified, self->export_metadata, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			MediaSource* _tmp7_;
			_tmp7_ = self->media;
			if (IS_VIDEO (_tmp7_)) {
				MediaSource* _tmp8_;
				GFile* _tmp9_;
				_tmp8_ = self->media;
				_tmp9_ = self->dest;
				video_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video), _tmp9_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		GError* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		_tmp11_ = _g_error_copy0 (_tmp10_);
		_g_error_free0 (self->err);
		self->err = _tmp11_;
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
exporter_export_job_class_init (ExporterExportJobClass * klass,
                                gpointer klass_data)
{
	exporter_export_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = exporter_export_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) exporter_export_job_real_execute;
}

static void
exporter_export_job_instance_init (ExporterExportJob * self,
                                   gpointer klass)
{
	self->err = NULL;
	self->direct_copy_unmodified = FALSE;
	self->export_metadata = TRUE;
}

static void
exporter_export_job_finalize (BackgroundJob * obj)
{
	ExporterExportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob);
	_g_object_unref0 (self->media);
	_g_object_unref0 (self->dest);
	_scaling_free0 (self->scaling);
	_g_free0 (self->quality);
	_g_free0 (self->format);
	_g_error_free0 (self->err);
	BACKGROUND_JOB_CLASS (exporter_export_job_parent_class)->finalize (obj);
}

static GType
exporter_export_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExporterExportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_export_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExporterExportJob), 0, (GInstanceInitFunc) exporter_export_job_instance_init, NULL };
	GType exporter_export_job_type_id;
	exporter_export_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ExporterExportJob", &g_define_type_info, 0);
	return exporter_export_job_type_id;
}

static GType
exporter_export_job_get_type (void)
{
	static volatile gsize exporter_export_job_type_id__once = 0;
	if (g_once_init_enter (&exporter_export_job_type_id__once)) {
		GType exporter_export_job_type_id;
		exporter_export_job_type_id = exporter_export_job_get_type_once ();
		g_once_init_leave (&exporter_export_job_type_id__once, exporter_export_job_type_id);
	}
	return exporter_export_job_type_id__once;
}

static void
exporter_class_init (ExporterClass * klass,
                     gpointer klass_data)
{
	exporter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Exporter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = exporter_finalize;
}

static void
exporter_instance_init (Exporter * self,
                        gpointer klass)
{
	GeeArrayList* _tmp0_;
	Workers* _tmp1_;
	self->priv = exporter_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->to_export = (GeeCollection*) _tmp0_;
	self->priv->completed_count = 0;
	_tmp1_ = workers_new (workers_threads_per_cpu (1, 4), FALSE);
	self->priv->workers = _tmp1_;
	self->priv->completion_callback = NULL;
	self->priv->completion_callback_target = NULL;
	self->priv->error_callback = NULL;
	self->priv->error_callback_target = NULL;
	self->priv->overwrite_callback = NULL;
	self->priv->overwrite_callback_target = NULL;
	self->priv->monitor = NULL;
	self->priv->monitor_target = NULL;
	self->priv->replace_all = FALSE;
	self->priv->aborted = FALSE;
}

static void
exporter_finalize (GObject * obj)
{
	Exporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER, Exporter);
	_g_object_unref0 (self->priv->to_export);
	self->priv->exported_files = (_vala_array_free (self->priv->exported_files, self->priv->exported_files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->dir);
	_workers_unref0 (self->priv->workers);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (exporter_parent_class)->finalize (obj);
}

static GType
exporter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Exporter), 0, (GInstanceInitFunc) exporter_instance_init, NULL };
	GType exporter_type_id;
	exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "Exporter", &g_define_type_info, 0);
	Exporter_private_offset = g_type_add_instance_private (exporter_type_id, sizeof (ExporterPrivate));
	return exporter_type_id;
}

GType
exporter_get_type (void)
{
	static volatile gsize exporter_type_id__once = 0;
	if (g_once_init_enter (&exporter_type_id__once)) {
		GType exporter_type_id;
		exporter_type_id = exporter_get_type_once ();
		g_once_init_leave (&exporter_type_id__once, exporter_type_id);
	}
	return exporter_type_id__once;
}

static inline gpointer
exporter_ui_get_instance_private (ExporterUI* self)
{
	return G_STRUCT_MEMBER_P (self, ExporterUI_private_offset);
}

ExporterUI*
exporter_ui_construct (GType object_type,
                       Exporter* exporter)
{
	ExporterUI* self = NULL;
	Exporter* _tmp0_;
	g_return_val_if_fail (exporter != NULL, NULL);
	self = (ExporterUI*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (exporter);
	_g_object_unref0 (self->priv->exporter);
	self->priv->exporter = _tmp0_;
	return self;
}

ExporterUI*
exporter_ui_new (Exporter* exporter)
{
	return exporter_ui_construct (TYPE_EXPORTER_UI, exporter);
}

static void
_exporter_ui_on_export_completed_exporter_completion_callback (Exporter* exporter,
                                                               gboolean is_cancelled,
                                                               gpointer self)
{
	exporter_ui_on_export_completed ((ExporterUI*) self, exporter, is_cancelled);
}

static gboolean
_exporter_ui_on_export_failed_exporter_export_failed_callback (Exporter* exporter,
                                                               GFile* file,
                                                               gint remaining,
                                                               GError* err,
                                                               gpointer self)
{
	gboolean result;
	result = exporter_ui_on_export_failed ((ExporterUI*) self, exporter, file, remaining, err);
	return result;
}

static ExporterOverwrite
_exporter_ui_on_export_overwrite_exporter_overwrite_callback (Exporter* exporter,
                                                              GFile* file,
                                                              gpointer self)
{
	ExporterOverwrite result;
	result = exporter_ui_on_export_overwrite ((ExporterUI*) self, exporter, file);
	return result;
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

void
exporter_ui_export (ExporterUI* self,
                    ExporterCompletionCallback completion_callback,
                    gpointer completion_callback_target)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	GCancellable* _tmp4_;
	ProgressDialog* _tmp5_;
	Exporter* _tmp6_;
	GCancellable* _tmp7_;
	ProgressDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	self->priv->completion_callback = completion_callback;
	self->priv->completion_callback_target = completion_callback_target;
	_tmp0_ = app_window_get_instance ();
	_tmp1_ = _tmp0_;
	page_window_set_busy_cursor ((PageWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->cancellable;
	_tmp5_ = progress_dialog_new ((GtkWindow*) _tmp3_, _ ("Exporting"), _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->progress_dialog);
	self->priv->progress_dialog = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_tmp6_ = self->priv->exporter;
	_tmp7_ = self->priv->cancellable;
	_tmp8_ = self->priv->progress_dialog;
	exporter_export (_tmp6_, _exporter_ui_on_export_completed_exporter_completion_callback, self, _exporter_ui_on_export_failed_exporter_export_failed_callback, self, _exporter_ui_on_export_overwrite_exporter_overwrite_callback, self, _tmp7_, _progress_dialog_monitor_progress_monitor, _tmp8_);
}

static void
exporter_ui_on_export_completed (ExporterUI* self,
                                 Exporter* exporter,
                                 gboolean is_cancelled)
{
	ProgressDialog* _tmp0_;
	AppWindow* _tmp2_;
	AppWindow* _tmp3_;
	ExporterCompletionCallback _tmp4_;
	gpointer _tmp4__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exporter != NULL);
	_tmp0_ = self->priv->progress_dialog;
	if (_tmp0_ != NULL) {
		ProgressDialog* _tmp1_;
		_tmp1_ = self->priv->progress_dialog;
		progress_dialog_close (_tmp1_);
		_g_object_unref0 (self->priv->progress_dialog);
		self->priv->progress_dialog = NULL;
	}
	_tmp2_ = app_window_get_instance ();
	_tmp3_ = _tmp2_;
	page_window_set_normal_cursor ((PageWindow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->completion_callback;
	_tmp4__target = self->priv->completion_callback_target;
	_tmp4_ (exporter, is_cancelled, _tmp4__target);
}

static ExporterOverwrite
exporter_ui_on_export_overwrite (ExporterUI* self,
                                 Exporter* exporter,
                                 GFile* file)
{
	ProgressDialog* _tmp0_;
	GraniteMessageDialog* dialog = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GraniteMessageDialog* _tmp5_;
	GraniteMessageDialog* _tmp6_;
	GraniteMessageDialog* _tmp7_;
	AppWindow* _tmp8_;
	AppWindow* _tmp9_;
	GraniteMessageDialog* _tmp10_;
	GtkButton* replace_button = NULL;
	GraniteMessageDialog* _tmp11_;
	GtkWidget* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	gint response = 0;
	GraniteMessageDialog* _tmp16_;
	GraniteMessageDialog* _tmp17_;
	ProgressDialog* _tmp18_;
	ExporterOverwrite result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (exporter != NULL, 0);
	g_return_val_if_fail (file != NULL, 0);
	_tmp0_ = self->priv->progress_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp0_, FALSE);
	_tmp1_ = g_file_get_basename (file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("File %s already exists. Replace?"), _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Export"), _tmp4_, "dialog-question", GTK_BUTTONS_NONE);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	dialog = _tmp6_;
	_tmp7_ = dialog;
	_tmp8_ = app_window_get_instance ();
	_tmp9_ = _tmp8_;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, (GtkWindow*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = dialog;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp10_, _ ("_Skip"), GTK_RESPONSE_NO, _ ("Replace _All"), GTK_RESPONSE_APPLY, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
	_tmp11_ = dialog;
	_tmp12_ = gtk_dialog_add_button ((GtkDialog*) _tmp11_, _ ("_Replace"), (gint) GTK_RESPONSE_YES);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_button_get_type (), GtkButton));
	replace_button = _tmp13_;
	_tmp14_ = replace_button;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp16_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp16_);
	_tmp17_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->progress_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp18_, TRUE);
	switch (response) {
		case GTK_RESPONSE_APPLY:
		{
			result = EXPORTER_OVERWRITE_REPLACE_ALL;
			_g_object_unref0 (replace_button);
			_g_object_unref0 (dialog);
			return result;
		}
		case GTK_RESPONSE_YES:
		{
			result = EXPORTER_OVERWRITE_YES;
			_g_object_unref0 (replace_button);
			_g_object_unref0 (dialog);
			return result;
		}
		case GTK_RESPONSE_CANCEL:
		{
			result = EXPORTER_OVERWRITE_CANCEL;
			_g_object_unref0 (replace_button);
			_g_object_unref0 (dialog);
			return result;
		}
		default:
		case GTK_RESPONSE_NO:
		{
			result = EXPORTER_OVERWRITE_NO;
			_g_object_unref0 (replace_button);
			_g_object_unref0 (dialog);
			return result;
		}
	}
}

static gboolean
exporter_ui_on_export_failed (ExporterUI* self,
                              Exporter* exporter,
                              GFile* file,
                              gint remaining,
                              GError* err)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (exporter != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (err != NULL, FALSE);
	result = export_error_dialog (file, remaining > 0) != GTK_RESPONSE_CANCEL;
	return result;
}

static void
value_exporter_ui_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_exporter_ui_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		exporter_ui_unref (value->data[0].v_pointer);
	}
}

static void
value_exporter_ui_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = exporter_ui_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_exporter_ui_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_exporter_ui_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ExporterUI * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = exporter_ui_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_exporter_ui_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ExporterUI ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = exporter_ui_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_exporter_ui (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecExporterUI* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPORTER_UI), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_exporter_ui (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI), NULL);
	return value->data[0].v_pointer;
}

void
value_set_exporter_ui (GValue* value,
                       gpointer v_object)
{
	ExporterUI * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORTER_UI));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		exporter_ui_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		exporter_ui_unref (old);
	}
}

void
value_take_exporter_ui (GValue* value,
                        gpointer v_object)
{
	ExporterUI * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORTER_UI));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		exporter_ui_unref (old);
	}
}

static void
exporter_ui_class_init (ExporterUIClass * klass,
                        gpointer klass_data)
{
	exporter_ui_parent_class = g_type_class_peek_parent (klass);
	((ExporterUIClass *) klass)->finalize = exporter_ui_finalize;
	g_type_class_adjust_private_offset (klass, &ExporterUI_private_offset);
}

static void
exporter_ui_instance_init (ExporterUI * self,
                           gpointer klass)
{
	GCancellable* _tmp0_;
	self->priv = exporter_ui_get_instance_private (self);
	_tmp0_ = g_cancellable_new ();
	self->priv->cancellable = _tmp0_;
	self->priv->progress_dialog = NULL;
	self->priv->completion_callback = NULL;
	self->priv->completion_callback_target = NULL;
	self->ref_count = 1;
}

static void
exporter_ui_finalize (ExporterUI * obj)
{
	ExporterUI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER_UI, ExporterUI);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->exporter);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->progress_dialog);
}

static GType
exporter_ui_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_exporter_ui_init, value_exporter_ui_free_value, value_exporter_ui_copy_value, value_exporter_ui_peek_pointer, "p", value_exporter_ui_collect_value, "p", value_exporter_ui_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ExporterUIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_ui_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExporterUI), 0, (GInstanceInitFunc) exporter_ui_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType exporter_ui_type_id;
	exporter_ui_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ExporterUI", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ExporterUI_private_offset = g_type_add_instance_private (exporter_ui_type_id, sizeof (ExporterUIPrivate));
	return exporter_ui_type_id;
}

GType
exporter_ui_get_type (void)
{
	static volatile gsize exporter_ui_type_id__once = 0;
	if (g_once_init_enter (&exporter_ui_type_id__once)) {
		GType exporter_ui_type_id;
		exporter_ui_type_id = exporter_ui_get_type_once ();
		g_once_init_leave (&exporter_ui_type_id__once, exporter_ui_type_id);
	}
	return exporter_ui_type_id__once;
}

gpointer
exporter_ui_ref (gpointer instance)
{
	ExporterUI * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
exporter_ui_unref (gpointer instance)
{
	ExporterUI * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPORTER_UI_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

