/* TiffSupport.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TiffSupport.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define PHOTOS_TIFF_WRITER_COMPRESSION_NONE "1"
#define PHOTOS_TIFF_WRITER_COMPRESSION_HUFFMAN "2"
#define PHOTOS_TIFF_WRITER_COMPRESSION_LZW "5"
#define PHOTOS_TIFF_WRITER_COMPRESSION_JPEG "7"
#define PHOTOS_TIFF_WRITER_COMPRESSION_DEFLATE "8"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

#define PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES (photos_tiff_file_format_properties_get_type ())
#define PHOTOS_TIFF_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES, PhotosTiffFileFormatProperties))
#define PHOTOS_TIFF_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES, PhotosTiffFileFormatPropertiesClass))
#define PHOTOS_IS_TIFF_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES))
#define PHOTOS_IS_TIFF_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES))
#define PHOTOS_TIFF_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES, PhotosTiffFileFormatPropertiesClass))

typedef struct _PhotosTiffFileFormatProperties PhotosTiffFileFormatProperties;
typedef struct _PhotosTiffFileFormatPropertiesClass PhotosTiffFileFormatPropertiesClass;

#define PHOTOS_TYPE_TIFF_READER (photos_tiff_reader_get_type ())
#define PHOTOS_TIFF_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_TIFF_READER, PhotosTiffReader))
#define PHOTOS_TIFF_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_TIFF_READER, PhotosTiffReaderClass))
#define PHOTOS_IS_TIFF_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_TIFF_READER))
#define PHOTOS_IS_TIFF_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_TIFF_READER))
#define PHOTOS_TIFF_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_TIFF_READER, PhotosTiffReaderClass))

typedef struct _PhotosTiffReader PhotosTiffReader;
typedef struct _PhotosTiffReaderClass PhotosTiffReaderClass;

#define PHOTOS_TYPE_TIFF_WRITER (photos_tiff_writer_get_type ())
#define PHOTOS_TIFF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_TIFF_WRITER, PhotosTiffWriter))
#define PHOTOS_TIFF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_TIFF_WRITER, PhotosTiffWriterClass))
#define PHOTOS_IS_TIFF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_TIFF_WRITER))
#define PHOTOS_IS_TIFF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_TIFF_WRITER))
#define PHOTOS_TIFF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_TIFF_WRITER, PhotosTiffWriterClass))

typedef struct _PhotosTiffWriter PhotosTiffWriter;
typedef struct _PhotosTiffWriterClass PhotosTiffWriterClass;

#define PHOTOS_TYPE_TIFF_METADATA_WRITER (photos_tiff_metadata_writer_get_type ())
#define PHOTOS_TIFF_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_TIFF_METADATA_WRITER, PhotosTiffMetadataWriter))
#define PHOTOS_TIFF_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_TIFF_METADATA_WRITER, PhotosTiffMetadataWriterClass))
#define PHOTOS_IS_TIFF_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_TIFF_METADATA_WRITER))
#define PHOTOS_IS_TIFF_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_TIFF_METADATA_WRITER))
#define PHOTOS_TIFF_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_TIFF_METADATA_WRITER, PhotosTiffMetadataWriterClass))

typedef struct _PhotosTiffMetadataWriter PhotosTiffMetadataWriter;
typedef struct _PhotosTiffMetadataWriterClass PhotosTiffMetadataWriterClass;

#define PHOTOS_TYPE_TIFF_SNIFFER (photos_tiff_sniffer_get_type ())
#define PHOTOS_TIFF_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTOS_TYPE_TIFF_SNIFFER, PhotosTiffSniffer))
#define PHOTOS_TIFF_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTOS_TYPE_TIFF_SNIFFER, PhotosTiffSnifferClass))
#define PHOTOS_IS_TIFF_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTOS_TYPE_TIFF_SNIFFER))
#define PHOTOS_IS_TIFF_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTOS_TYPE_TIFF_SNIFFER))
#define PHOTOS_TIFF_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTOS_TYPE_TIFF_SNIFFER, PhotosTiffSnifferClass))

typedef struct _PhotosTiffSniffer PhotosTiffSniffer;
typedef struct _PhotosTiffSnifferClass PhotosTiffSnifferClass;
typedef struct _PhotosTiffFileFormatPropertiesPrivate PhotosTiffFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
typedef struct _PhotosTiffSnifferPrivate PhotosTiffSnifferPrivate;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _PhotosTiffReaderPrivate PhotosTiffReaderPrivate;
typedef struct _PhotosTiffWriterPrivate PhotosTiffWriterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PhotosTiffMetadataWriterPrivate PhotosTiffMetadataWriterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PhotosTiffFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	PhotosTiffFileFormatPropertiesPrivate * priv;
};

struct _PhotosTiffFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

struct _PhotosTiffSniffer {
	GdkSniffer parent_instance;
	PhotosTiffSnifferPrivate * priv;
};

struct _PhotosTiffSnifferClass {
	GdkSnifferClass parent_class;
};

struct _PhotosTiffReader {
	GdkReader parent_instance;
	PhotosTiffReaderPrivate * priv;
};

struct _PhotosTiffReaderClass {
	GdkReaderClass parent_class;
};

struct _PhotosTiffWriter {
	PhotoFileWriter parent_instance;
	PhotosTiffWriterPrivate * priv;
};

struct _PhotosTiffWriterClass {
	PhotoFileWriterClass parent_class;
};

struct _PhotosTiffMetadataWriter {
	PhotoFileMetadataWriter parent_instance;
	PhotosTiffMetadataWriterPrivate * priv;
};

struct _PhotosTiffMetadataWriterClass {
	PhotoFileMetadataWriterClass parent_class;
};

static gpointer photos_tiff_file_format_driver_parent_class = NULL;
static PhotosTiffFileFormatDriver* photos_tiff_file_format_driver_instance;
static PhotosTiffFileFormatDriver* photos_tiff_file_format_driver_instance = NULL;
static gpointer photos_tiff_file_format_properties_parent_class = NULL;
static gchar** photos_tiff_file_format_properties_known_extensions;
static gint photos_tiff_file_format_properties_known_extensions_length1;
static gchar** photos_tiff_file_format_properties_known_extensions = NULL;
static gint photos_tiff_file_format_properties_known_extensions_length1 = 0;
static gint _photos_tiff_file_format_properties_known_extensions_size_ = 0;
static gchar** photos_tiff_file_format_properties_known_mime_types;
static gint photos_tiff_file_format_properties_known_mime_types_length1;
static gchar** photos_tiff_file_format_properties_known_mime_types = NULL;
static gint photos_tiff_file_format_properties_known_mime_types_length1 = 0;
static gint _photos_tiff_file_format_properties_known_mime_types_size_ = 0;
static PhotosTiffFileFormatProperties* photos_tiff_file_format_properties_instance;
static PhotosTiffFileFormatProperties* photos_tiff_file_format_properties_instance = NULL;
static gpointer photos_tiff_sniffer_parent_class = NULL;
static gpointer photos_tiff_reader_parent_class = NULL;
static gpointer photos_tiff_writer_parent_class = NULL;
static gpointer photos_tiff_metadata_writer_parent_class = NULL;

VALA_EXTERN void photos_tiff_file_format_properties_init (void);
static PhotoFileFormatProperties* photos_tiff_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
VALA_EXTERN GType photos_tiff_file_format_properties_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotosTiffFileFormatProperties* photos_tiff_file_format_properties_get_instance (void);
static PhotoFileReader* photos_tiff_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                                    const gchar* filepath);
VALA_EXTERN PhotosTiffReader* photos_tiff_reader_new (const gchar* filepath);
VALA_EXTERN PhotosTiffReader* photos_tiff_reader_construct (GType object_type,
                                                const gchar* filepath);
VALA_EXTERN GType photos_tiff_reader_get_type (void) G_GNUC_CONST ;
static PhotoMetadata* photos_tiff_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
static gboolean photos_tiff_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean photos_tiff_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* photos_tiff_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                                    const gchar* filepath);
VALA_EXTERN PhotosTiffWriter* photos_tiff_writer_new (const gchar* filepath);
VALA_EXTERN PhotosTiffWriter* photos_tiff_writer_construct (GType object_type,
                                                const gchar* filepath);
VALA_EXTERN GType photos_tiff_writer_get_type (void) G_GNUC_CONST ;
static PhotoFileMetadataWriter* photos_tiff_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                                                     const gchar* filepath);
VALA_EXTERN PhotosTiffMetadataWriter* photos_tiff_metadata_writer_new (const gchar* filepath);
VALA_EXTERN PhotosTiffMetadataWriter* photos_tiff_metadata_writer_construct (GType object_type,
                                                                 const gchar* filepath);
VALA_EXTERN GType photos_tiff_metadata_writer_get_type (void) G_GNUC_CONST ;
static PhotoFileSniffer* photos_tiff_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                                      GFile* file,
                                                                      PhotoFileSnifferOptions options);
VALA_EXTERN PhotosTiffSniffer* photos_tiff_sniffer_new (GFile* file,
                                            PhotoFileSnifferOptions options);
VALA_EXTERN PhotosTiffSniffer* photos_tiff_sniffer_construct (GType object_type,
                                                  GFile* file,
                                                  PhotoFileSnifferOptions options);
VALA_EXTERN GType photos_tiff_sniffer_get_type (void) G_GNUC_CONST ;
static void photos_tiff_file_format_driver_finalize (PhotoFileFormatDriver * obj);
static GType photos_tiff_file_format_driver_get_type_once (void);
VALA_EXTERN PhotosTiffFileFormatProperties* photos_tiff_file_format_properties_new (void);
VALA_EXTERN PhotosTiffFileFormatProperties* photos_tiff_file_format_properties_construct (GType object_type);
static PhotoFileFormat photos_tiff_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags photos_tiff_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* photos_tiff_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar* photos_tiff_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar** photos_tiff_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                                      gint* result_length1);
static gchar** _vala_array_dup22 (gchar** self,
                           gssize length);
static gchar* photos_tiff_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** photos_tiff_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                                gint* result_length1);
static gchar** _vala_array_dup23 (gchar** self,
                           gssize length);
static void photos_tiff_file_format_properties_finalize (PhotoFileFormatProperties * obj);
static GType photos_tiff_file_format_properties_get_type_once (void);
static DetectedPhotoInformation* photos_tiff_sniffer_real_sniff (PhotoFileSniffer* base,
                                                          GError** error);
static GType photos_tiff_sniffer_get_type_once (void);
static GType photos_tiff_reader_get_type_once (void);
static void photos_tiff_writer_real_write (PhotoFileWriter* base,
                                    GdkPixbuf* pixbuf,
                                    JpegQuality quality,
                                    GError** error);
static GType photos_tiff_writer_get_type_once (void);
static void photos_tiff_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                                      PhotoMetadata* metadata,
                                                      GError** error);
static GType photos_tiff_metadata_writer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
photos_tiff_file_format_driver_init (void)
{
	PhotosTiffFileFormatDriver* _tmp0_;
	_tmp0_ = photos_tiff_file_format_driver_new ();
	_photo_file_format_driver_unref0 (photos_tiff_file_format_driver_instance);
	photos_tiff_file_format_driver_instance = _tmp0_;
	photos_tiff_file_format_properties_init ();
}

static gpointer
_photo_file_format_driver_ref0 (gpointer self)
{
	return self ? photo_file_format_driver_ref (self) : NULL;
}

PhotosTiffFileFormatDriver*
photos_tiff_file_format_driver_get_instance (void)
{
	PhotosTiffFileFormatDriver* _tmp0_;
	PhotosTiffFileFormatDriver* _tmp1_;
	PhotosTiffFileFormatDriver* result;
	_tmp0_ = photos_tiff_file_format_driver_instance;
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormatProperties*
photos_tiff_file_format_driver_real_get_properties (PhotoFileFormatDriver* base)
{
	PhotosTiffFileFormatDriver * self;
	PhotosTiffFileFormatProperties* _tmp0_;
	PhotoFileFormatProperties* result;
	self = (PhotosTiffFileFormatDriver*) base;
	_tmp0_ = photos_tiff_file_format_properties_get_instance ();
	result = (PhotoFileFormatProperties*) _tmp0_;
	return result;
}

static PhotoFileReader*
photos_tiff_file_format_driver_real_create_reader (PhotoFileFormatDriver* base,
                                                   const gchar* filepath)
{
	PhotosTiffFileFormatDriver * self;
	PhotosTiffReader* _tmp0_;
	PhotoFileReader* result;
	self = (PhotosTiffFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photos_tiff_reader_new (filepath);
	result = (PhotoFileReader*) _tmp0_;
	return result;
}

static PhotoMetadata*
photos_tiff_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base)
{
	PhotosTiffFileFormatDriver * self;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* result;
	self = (PhotosTiffFileFormatDriver*) base;
	_tmp0_ = photo_metadata_new ();
	result = _tmp0_;
	return result;
}

static gboolean
photos_tiff_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base)
{
	PhotosTiffFileFormatDriver * self;
	gboolean result;
	self = (PhotosTiffFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static gboolean
photos_tiff_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base)
{
	PhotosTiffFileFormatDriver * self;
	gboolean result;
	self = (PhotosTiffFileFormatDriver*) base;
	result = TRUE;
	return result;
}

static PhotoFileWriter*
photos_tiff_file_format_driver_real_create_writer (PhotoFileFormatDriver* base,
                                                   const gchar* filepath)
{
	PhotosTiffFileFormatDriver * self;
	PhotosTiffWriter* _tmp0_;
	PhotoFileWriter* result;
	self = (PhotosTiffFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photos_tiff_writer_new (filepath);
	result = (PhotoFileWriter*) _tmp0_;
	return result;
}

static PhotoFileMetadataWriter*
photos_tiff_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base,
                                                            const gchar* filepath)
{
	PhotosTiffFileFormatDriver * self;
	PhotosTiffMetadataWriter* _tmp0_;
	PhotoFileMetadataWriter* result;
	self = (PhotosTiffFileFormatDriver*) base;
	g_return_val_if_fail (filepath != NULL, NULL);
	_tmp0_ = photos_tiff_metadata_writer_new (filepath);
	result = (PhotoFileMetadataWriter*) _tmp0_;
	return result;
}

static PhotoFileSniffer*
photos_tiff_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base,
                                                    GFile* file,
                                                    PhotoFileSnifferOptions options)
{
	PhotosTiffFileFormatDriver * self;
	PhotosTiffSniffer* _tmp0_;
	PhotoFileSniffer* result;
	self = (PhotosTiffFileFormatDriver*) base;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = photos_tiff_sniffer_new (file, options);
	result = (PhotoFileSniffer*) _tmp0_;
	return result;
}

PhotosTiffFileFormatDriver*
photos_tiff_file_format_driver_construct (GType object_type)
{
	PhotosTiffFileFormatDriver* self = NULL;
	self = (PhotosTiffFileFormatDriver*) photo_file_format_driver_construct (object_type);
	return self;
}

PhotosTiffFileFormatDriver*
photos_tiff_file_format_driver_new (void)
{
	return photos_tiff_file_format_driver_construct (PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER);
}

static void
photos_tiff_file_format_driver_class_init (PhotosTiffFileFormatDriverClass * klass,
                                           gpointer klass_data)
{
	photos_tiff_file_format_driver_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatDriverClass *) klass)->finalize = photos_tiff_file_format_driver_finalize;
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver*)) photos_tiff_file_format_driver_real_get_properties;
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver*, const gchar*)) photos_tiff_file_format_driver_real_create_reader;
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver*)) photos_tiff_file_format_driver_real_create_metadata;
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver*)) photos_tiff_file_format_driver_real_can_write_image;
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver*)) photos_tiff_file_format_driver_real_can_write_metadata;
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver*, const gchar*)) photos_tiff_file_format_driver_real_create_writer;
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver*, const gchar*)) photos_tiff_file_format_driver_real_create_metadata_writer;
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver*, GFile*, PhotoFileSnifferOptions)) photos_tiff_file_format_driver_real_create_sniffer;
}

static void
photos_tiff_file_format_driver_instance_init (PhotosTiffFileFormatDriver * self,
                                              gpointer klass)
{
}

static void
photos_tiff_file_format_driver_finalize (PhotoFileFormatDriver * obj)
{
	PhotosTiffFileFormatDriver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTOS_TYPE_TIFF_FILE_FORMAT_DRIVER, PhotosTiffFileFormatDriver);
	PHOTO_FILE_FORMAT_DRIVER_CLASS (photos_tiff_file_format_driver_parent_class)->finalize (obj);
}

static GType
photos_tiff_file_format_driver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosTiffFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_tiff_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosTiffFileFormatDriver), 0, (GInstanceInitFunc) photos_tiff_file_format_driver_instance_init, NULL };
	GType photos_tiff_file_format_driver_type_id;
	photos_tiff_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "PhotosTiffFileFormatDriver", &g_define_type_info, 0);
	return photos_tiff_file_format_driver_type_id;
}

GType
photos_tiff_file_format_driver_get_type (void)
{
	static volatile gsize photos_tiff_file_format_driver_type_id__once = 0;
	if (g_once_init_enter (&photos_tiff_file_format_driver_type_id__once)) {
		GType photos_tiff_file_format_driver_type_id;
		photos_tiff_file_format_driver_type_id = photos_tiff_file_format_driver_get_type_once ();
		g_once_init_leave (&photos_tiff_file_format_driver_type_id__once, photos_tiff_file_format_driver_type_id);
	}
	return photos_tiff_file_format_driver_type_id__once;
}

void
photos_tiff_file_format_properties_init (void)
{
	PhotosTiffFileFormatProperties* _tmp0_;
	_tmp0_ = photos_tiff_file_format_properties_new ();
	_photo_file_format_properties_unref0 (photos_tiff_file_format_properties_instance);
	photos_tiff_file_format_properties_instance = _tmp0_;
}

static gpointer
_photo_file_format_properties_ref0 (gpointer self)
{
	return self ? photo_file_format_properties_ref (self) : NULL;
}

PhotosTiffFileFormatProperties*
photos_tiff_file_format_properties_get_instance (void)
{
	PhotosTiffFileFormatProperties* _tmp0_;
	PhotosTiffFileFormatProperties* _tmp1_;
	PhotosTiffFileFormatProperties* result;
	_tmp0_ = photos_tiff_file_format_properties_instance;
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static PhotoFileFormat
photos_tiff_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base)
{
	PhotosTiffFileFormatProperties * self;
	PhotoFileFormat result;
	self = (PhotosTiffFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_TIFF;
	return result;
}

static PhotoFileFormatFlags
photos_tiff_file_format_properties_real_get_flags (PhotoFileFormatProperties* base)
{
	PhotosTiffFileFormatProperties * self;
	PhotoFileFormatFlags result;
	self = (PhotosTiffFileFormatProperties*) base;
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
	return result;
}

static gchar*
photos_tiff_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base)
{
	PhotosTiffFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (PhotosTiffFileFormatProperties*) base;
	_tmp0_ = g_strdup ("tif");
	result = _tmp0_;
	return result;
}

static gchar*
photos_tiff_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base)
{
	PhotosTiffFileFormatProperties * self;
	gchar* _tmp0_;
	gchar* result;
	self = (PhotosTiffFileFormatProperties*) base;
	_tmp0_ = g_strdup (_ ("TIFF"));
	result = _tmp0_;
	return result;
}

static gchar**
_vala_array_dup22 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
photos_tiff_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base,
                                                              gint* result_length1)
{
	PhotosTiffFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (PhotosTiffFileFormatProperties*) base;
	_tmp0_ = photos_tiff_file_format_properties_known_extensions;
	_tmp0__length1 = photos_tiff_file_format_properties_known_extensions_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup22 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
photos_tiff_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base)
{
	PhotosTiffFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (PhotosTiffFileFormatProperties*) base;
	_tmp0_ = photos_tiff_file_format_properties_known_mime_types;
	_tmp0__length1 = photos_tiff_file_format_properties_known_mime_types_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup23 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
photos_tiff_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base,
                                                        gint* result_length1)
{
	PhotosTiffFileFormatProperties * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (PhotosTiffFileFormatProperties*) base;
	_tmp0_ = photos_tiff_file_format_properties_known_mime_types;
	_tmp0__length1 = photos_tiff_file_format_properties_known_mime_types_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup23 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

PhotosTiffFileFormatProperties*
photos_tiff_file_format_properties_construct (GType object_type)
{
	PhotosTiffFileFormatProperties* self = NULL;
	self = (PhotosTiffFileFormatProperties*) photo_file_format_properties_construct (object_type);
	return self;
}

PhotosTiffFileFormatProperties*
photos_tiff_file_format_properties_new (void)
{
	return photos_tiff_file_format_properties_construct (PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES);
}

static void
photos_tiff_file_format_properties_class_init (PhotosTiffFileFormatPropertiesClass * klass,
                                               gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	photos_tiff_file_format_properties_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileFormatPropertiesClass *) klass)->finalize = photos_tiff_file_format_properties_finalize;
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties*)) photos_tiff_file_format_properties_real_get_file_format;
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties*)) photos_tiff_file_format_properties_real_get_flags;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties*)) photos_tiff_file_format_properties_real_get_default_extension;
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties*)) photos_tiff_file_format_properties_real_get_user_visible_name;
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties*, gint*)) photos_tiff_file_format_properties_real_get_known_extensions;
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties*)) photos_tiff_file_format_properties_real_get_default_mime_type;
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties*, gint*)) photos_tiff_file_format_properties_real_get_mime_types;
	_tmp0_ = g_strdup ("tif");
	_tmp1_ = g_strdup ("tiff");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	photos_tiff_file_format_properties_known_extensions = _tmp2_;
	photos_tiff_file_format_properties_known_extensions_length1 = 2;
	_photos_tiff_file_format_properties_known_extensions_size_ = photos_tiff_file_format_properties_known_extensions_length1;
	_tmp3_ = g_strdup ("image/tiff");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	photos_tiff_file_format_properties_known_mime_types = _tmp4_;
	photos_tiff_file_format_properties_known_mime_types_length1 = 1;
	_photos_tiff_file_format_properties_known_mime_types_size_ = photos_tiff_file_format_properties_known_mime_types_length1;
}

static void
photos_tiff_file_format_properties_instance_init (PhotosTiffFileFormatProperties * self,
                                                  gpointer klass)
{
}

static void
photos_tiff_file_format_properties_finalize (PhotoFileFormatProperties * obj)
{
	PhotosTiffFileFormatProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTOS_TYPE_TIFF_FILE_FORMAT_PROPERTIES, PhotosTiffFileFormatProperties);
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (photos_tiff_file_format_properties_parent_class)->finalize (obj);
}

static GType
photos_tiff_file_format_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosTiffFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_tiff_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosTiffFileFormatProperties), 0, (GInstanceInitFunc) photos_tiff_file_format_properties_instance_init, NULL };
	GType photos_tiff_file_format_properties_type_id;
	photos_tiff_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "PhotosTiffFileFormatProperties", &g_define_type_info, 0);
	return photos_tiff_file_format_properties_type_id;
}

GType
photos_tiff_file_format_properties_get_type (void)
{
	static volatile gsize photos_tiff_file_format_properties_type_id__once = 0;
	if (g_once_init_enter (&photos_tiff_file_format_properties_type_id__once)) {
		GType photos_tiff_file_format_properties_type_id;
		photos_tiff_file_format_properties_type_id = photos_tiff_file_format_properties_get_type_once ();
		g_once_init_leave (&photos_tiff_file_format_properties_type_id__once, photos_tiff_file_format_properties_type_id);
	}
	return photos_tiff_file_format_properties_type_id__once;
}

PhotosTiffSniffer*
photos_tiff_sniffer_construct (GType object_type,
                               GFile* file,
                               PhotoFileSnifferOptions options)
{
	PhotosTiffSniffer* self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (PhotosTiffSniffer*) gdk_sniffer_construct (object_type, file, options);
	return self;
}

PhotosTiffSniffer*
photos_tiff_sniffer_new (GFile* file,
                         PhotoFileSnifferOptions options)
{
	return photos_tiff_sniffer_construct (PHOTOS_TYPE_TIFF_SNIFFER, file, options);
}

static gpointer
_detected_photo_information_ref0 (gpointer self)
{
	return self ? detected_photo_information_ref (self) : NULL;
}

static DetectedPhotoInformation*
photos_tiff_sniffer_real_sniff (PhotoFileSniffer* base,
                                GError** error)
{
	PhotosTiffSniffer * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp2_;
	DetectedPhotoInformation* _tmp3_;
	DetectedPhotoInformation* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_;
	DetectedPhotoInformation* _tmp7_;
	GError* _inner_error0_ = NULL;
	DetectedPhotoInformation* result;
	self = (PhotosTiffSniffer*) base;
	_tmp1_ = ((PhotoFileSniffer*) self)->file;
	_tmp0_ = photos_is_tiff (_tmp1_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (!_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = PHOTO_FILE_SNIFFER_CLASS (photos_tiff_sniffer_parent_class)->sniff ((PhotoFileSniffer*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), &_inner_error0_);
	detected = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = detected;
	if (_tmp3_ == NULL) {
		result = NULL;
		_detected_photo_information_unref0 (detected);
		return result;
	}
	_tmp5_ = detected;
	if (_tmp5_->file_format == PHOTO_FILE_FORMAT_TIFF) {
		DetectedPhotoInformation* _tmp6_;
		_tmp6_ = detected;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp7_ = _detected_photo_information_ref0 (_tmp4_);
	result = _tmp7_;
	_detected_photo_information_unref0 (detected);
	return result;
}

static void
photos_tiff_sniffer_class_init (PhotosTiffSnifferClass * klass,
                                gpointer klass_data)
{
	photos_tiff_sniffer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer*, GError**)) photos_tiff_sniffer_real_sniff;
}

static void
photos_tiff_sniffer_instance_init (PhotosTiffSniffer * self,
                                   gpointer klass)
{
}

static GType
photos_tiff_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosTiffSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_tiff_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosTiffSniffer), 0, (GInstanceInitFunc) photos_tiff_sniffer_instance_init, NULL };
	GType photos_tiff_sniffer_type_id;
	photos_tiff_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "PhotosTiffSniffer", &g_define_type_info, 0);
	return photos_tiff_sniffer_type_id;
}

GType
photos_tiff_sniffer_get_type (void)
{
	static volatile gsize photos_tiff_sniffer_type_id__once = 0;
	if (g_once_init_enter (&photos_tiff_sniffer_type_id__once)) {
		GType photos_tiff_sniffer_type_id;
		photos_tiff_sniffer_type_id = photos_tiff_sniffer_get_type_once ();
		g_once_init_leave (&photos_tiff_sniffer_type_id__once, photos_tiff_sniffer_type_id);
	}
	return photos_tiff_sniffer_type_id__once;
}

PhotosTiffReader*
photos_tiff_reader_construct (GType object_type,
                              const gchar* filepath)
{
	PhotosTiffReader* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotosTiffReader*) gdk_reader_construct (object_type, filepath, PHOTO_FILE_FORMAT_TIFF);
	return self;
}

PhotosTiffReader*
photos_tiff_reader_new (const gchar* filepath)
{
	return photos_tiff_reader_construct (PHOTOS_TYPE_TIFF_READER, filepath);
}

static void
photos_tiff_reader_class_init (PhotosTiffReaderClass * klass,
                               gpointer klass_data)
{
	photos_tiff_reader_parent_class = g_type_class_peek_parent (klass);
}

static void
photos_tiff_reader_instance_init (PhotosTiffReader * self,
                                  gpointer klass)
{
}

static GType
photos_tiff_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosTiffReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_tiff_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosTiffReader), 0, (GInstanceInitFunc) photos_tiff_reader_instance_init, NULL };
	GType photos_tiff_reader_type_id;
	photos_tiff_reader_type_id = g_type_register_static (TYPE_GDK_READER, "PhotosTiffReader", &g_define_type_info, 0);
	return photos_tiff_reader_type_id;
}

GType
photos_tiff_reader_get_type (void)
{
	static volatile gsize photos_tiff_reader_type_id__once = 0;
	if (g_once_init_enter (&photos_tiff_reader_type_id__once)) {
		GType photos_tiff_reader_type_id;
		photos_tiff_reader_type_id = photos_tiff_reader_get_type_once ();
		g_once_init_leave (&photos_tiff_reader_type_id__once, photos_tiff_reader_type_id);
	}
	return photos_tiff_reader_type_id__once;
}

PhotosTiffWriter*
photos_tiff_writer_construct (GType object_type,
                              const gchar* filepath)
{
	PhotosTiffWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotosTiffWriter*) photo_file_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_TIFF);
	return self;
}

PhotosTiffWriter*
photos_tiff_writer_new (const gchar* filepath)
{
	return photos_tiff_writer_construct (PHOTOS_TYPE_TIFF_WRITER, filepath);
}

static void
photos_tiff_writer_real_write (PhotoFileWriter* base,
                               GdkPixbuf* pixbuf,
                               JpegQuality quality,
                               GError** error)
{
	PhotosTiffWriter * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (PhotosTiffWriter*) base;
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = photo_file_adapter_get_filepath ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	gdk_pixbuf_save (pixbuf, _tmp1_, "tiff", &_inner_error0_, "compression", PHOTOS_TIFF_WRITER_COMPRESSION_LZW, NULL);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
photos_tiff_writer_class_init (PhotosTiffWriterClass * klass,
                               gpointer klass_data)
{
	photos_tiff_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter*, GdkPixbuf*, JpegQuality, GError**)) photos_tiff_writer_real_write;
}

static void
photos_tiff_writer_instance_init (PhotosTiffWriter * self,
                                  gpointer klass)
{
}

static GType
photos_tiff_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosTiffWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_tiff_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosTiffWriter), 0, (GInstanceInitFunc) photos_tiff_writer_instance_init, NULL };
	GType photos_tiff_writer_type_id;
	photos_tiff_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_WRITER, "PhotosTiffWriter", &g_define_type_info, 0);
	return photos_tiff_writer_type_id;
}

GType
photos_tiff_writer_get_type (void)
{
	static volatile gsize photos_tiff_writer_type_id__once = 0;
	if (g_once_init_enter (&photos_tiff_writer_type_id__once)) {
		GType photos_tiff_writer_type_id;
		photos_tiff_writer_type_id = photos_tiff_writer_get_type_once ();
		g_once_init_leave (&photos_tiff_writer_type_id__once, photos_tiff_writer_type_id);
	}
	return photos_tiff_writer_type_id__once;
}

PhotosTiffMetadataWriter*
photos_tiff_metadata_writer_construct (GType object_type,
                                       const gchar* filepath)
{
	PhotosTiffMetadataWriter* self = NULL;
	g_return_val_if_fail (filepath != NULL, NULL);
	self = (PhotosTiffMetadataWriter*) photo_file_metadata_writer_construct (object_type, filepath, PHOTO_FILE_FORMAT_TIFF);
	return self;
}

PhotosTiffMetadataWriter*
photos_tiff_metadata_writer_new (const gchar* filepath)
{
	return photos_tiff_metadata_writer_construct (PHOTOS_TYPE_TIFF_METADATA_WRITER, filepath);
}

static void
photos_tiff_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base,
                                                 PhotoMetadata* metadata,
                                                 GError** error)
{
	PhotosTiffMetadataWriter * self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (PhotosTiffMetadataWriter*) base;
	g_return_if_fail (metadata != NULL);
	_tmp0_ = photo_file_adapter_get_file ((PhotoFileAdapter*) self);
	_tmp1_ = _tmp0_;
	photo_metadata_write_to_file (metadata, _tmp1_, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
photos_tiff_metadata_writer_class_init (PhotosTiffMetadataWriterClass * klass,
                                        gpointer klass_data)
{
	photos_tiff_metadata_writer_parent_class = g_type_class_peek_parent (klass);
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter*, PhotoMetadata*, GError**)) photos_tiff_metadata_writer_real_write_metadata;
}

static void
photos_tiff_metadata_writer_instance_init (PhotosTiffMetadataWriter * self,
                                           gpointer klass)
{
}

static GType
photos_tiff_metadata_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotosTiffMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photos_tiff_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotosTiffMetadataWriter), 0, (GInstanceInitFunc) photos_tiff_metadata_writer_instance_init, NULL };
	GType photos_tiff_metadata_writer_type_id;
	photos_tiff_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "PhotosTiffMetadataWriter", &g_define_type_info, 0);
	return photos_tiff_metadata_writer_type_id;
}

GType
photos_tiff_metadata_writer_get_type (void)
{
	static volatile gsize photos_tiff_metadata_writer_type_id__once = 0;
	if (g_once_init_enter (&photos_tiff_metadata_writer_type_id__once)) {
		GType photos_tiff_metadata_writer_type_id;
		photos_tiff_metadata_writer_type_id = photos_tiff_metadata_writer_get_type_once ();
		g_once_init_leave (&photos_tiff_metadata_writer_type_id__once, photos_tiff_metadata_writer_type_id);
	}
	return photos_tiff_metadata_writer_type_id__once;
}

gboolean
photos_is_tiff (GFile* file,
                GCancellable* cancellable,
                GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFileInputStream* _tmp1_;
	GDataInputStream* dins = NULL;
	GDataInputStream* _tmp3_;
	GDataStreamByteOrder order = 0;
	guint16 _tmp4_ = 0U;
	GDataInputStream* _tmp5_;
	GDataInputStream* _tmp7_;
	guint16 lue = 0U;
	GDataInputStream* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp1_ = g_file_read (file, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	dins = _tmp3_;
	_tmp5_ = dins;
	_tmp4_ = g_data_input_stream_read_uint16 (_tmp5_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dins);
		_g_object_unref0 (_tmp0_);
		return _tmp6_;
	}
	switch (_tmp4_) {
		case 0x4949:
		{
			order = G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN;
			break;
		}
		case 0x4D4D:
		{
			order = G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN;
			break;
		}
		default:
		{
			result = FALSE;
			_g_object_unref0 (dins);
			_g_object_unref0 (_tmp0_);
			return result;
		}
	}
	_tmp7_ = dins;
	g_data_input_stream_set_byte_order (_tmp7_, order);
	_tmp8_ = dins;
	lue = g_data_input_stream_read_uint16 (_tmp8_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dins);
		_g_object_unref0 (_tmp0_);
		return _tmp9_;
	}
	if (((gint) lue) != 42) {
		result = FALSE;
		_g_object_unref0 (dins);
		_g_object_unref0 (_tmp0_);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (dins);
	_g_object_unref0 (_tmp0_);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

