// python wrapper for vtkPVPythonInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVPythonInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPythonInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPythonInformation_ClassNew(); }

#ifndef DECLARED_PyvtkPVInformation_ClassNew
extern "C" { PyObject *PyvtkPVInformation_ClassNew(); }
#define DECLARED_PyvtkPVInformation_ClassNew
#endif

static PyObject *
PyvtkPVPythonInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVPythonInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVPythonInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVPythonInformation *tempr = vtkPVPythonInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVPythonInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVPythonInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVPythonInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVPythonInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_DeepCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeepCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  vtkPVPythonInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVPythonInformation"))
  {
    if (ap.IsBound())
    {
      op->DeepCopy(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::DeepCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_AddInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  vtkPVInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVInformation"))
  {
    if (ap.IsBound())
    {
      op->AddInformation(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::AddInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetPythonSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPythonSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPythonSupport(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetPythonSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetPythonSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPythonSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPythonSupport() :
      op->vtkPVPythonInformation::GetPythonSupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_PythonSupportOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PythonSupportOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PythonSupportOn();
    }
    else
    {
      op->vtkPVPythonInformation::PythonSupportOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_PythonSupportOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PythonSupportOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PythonSupportOff();
    }
    else
    {
      op->vtkPVPythonInformation::PythonSupportOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetPythonVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPythonVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPythonVersion(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetPythonVersion(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetPythonVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPythonVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetPythonVersion() :
      &op->vtkPVPythonInformation::GetPythonVersion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetPythonPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPythonPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPythonPath(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetPythonPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetPythonPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPythonPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetPythonPath() :
      &op->vtkPVPythonInformation::GetPythonPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetNumpySupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumpySupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumpySupport(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetNumpySupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetNumpySupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumpySupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNumpySupport() :
      op->vtkPVPythonInformation::GetNumpySupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_NumpySupportOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NumpySupportOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NumpySupportOn();
    }
    else
    {
      op->vtkPVPythonInformation::NumpySupportOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_NumpySupportOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NumpySupportOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NumpySupportOff();
    }
    else
    {
      op->vtkPVPythonInformation::NumpySupportOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetNumpyVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumpyVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumpyVersion(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetNumpyVersion(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetNumpyVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumpyVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetNumpyVersion() :
      &op->vtkPVPythonInformation::GetNumpyVersion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetNumpyPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumpyPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumpyPath(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetNumpyPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetNumpyPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumpyPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetNumpyPath() :
      &op->vtkPVPythonInformation::GetNumpyPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetMatplotlibSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMatplotlibSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMatplotlibSupport(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetMatplotlibSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetMatplotlibSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMatplotlibSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMatplotlibSupport() :
      op->vtkPVPythonInformation::GetMatplotlibSupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_MatplotlibSupportOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MatplotlibSupportOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MatplotlibSupportOn();
    }
    else
    {
      op->vtkPVPythonInformation::MatplotlibSupportOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_MatplotlibSupportOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MatplotlibSupportOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MatplotlibSupportOff();
    }
    else
    {
      op->vtkPVPythonInformation::MatplotlibSupportOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetMatplotlibVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMatplotlibVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMatplotlibVersion(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetMatplotlibVersion(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetMatplotlibVersion(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMatplotlibVersion");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetMatplotlibVersion() :
      &op->vtkPVPythonInformation::GetMatplotlibVersion());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_SetMatplotlibPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMatplotlibPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMatplotlibPath(temp0);
    }
    else
    {
      op->vtkPVPythonInformation::SetMatplotlibPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonInformation_GetMatplotlibPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMatplotlibPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVPythonInformation *op = static_cast<vtkPVPythonInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetMatplotlibPath() :
      &op->vtkPVPythonInformation::GetMatplotlibPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPythonInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVPythonInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVPythonInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVPythonInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVPythonInformation\nC++: static vtkPVPythonInformation *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVPythonInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVPythonInformation\nC++: vtkPVPythonInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVPythonInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVPythonInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"DeepCopy", PyvtkPVPythonInformation_DeepCopy, METH_VARARGS,
   "DeepCopy(self, info:vtkPVPythonInformation) -> None\nC++: void DeepCopy(vtkPVPythonInformation *info)\n\n"},
  {"CopyFromObject", PyvtkPVPythonInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, __a:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *) override;\n\nTransfer information about a single object into this object.\n"},
  {"AddInformation", PyvtkPVPythonInformation_AddInformation, METH_VARARGS,
   "AddInformation(self, __a:vtkPVInformation) -> None\nC++: void AddInformation(vtkPVInformation *) override;\n\nSame as DeepCopy for this object.\n"},
  {"SetPythonSupport", PyvtkPVPythonInformation_SetPythonSupport, METH_VARARGS,
   "SetPythonSupport(self, _arg:bool) -> None\nC++: virtual void SetPythonSupport(bool _arg)\n\nWhether the server was compiled with python support.\n"},
  {"GetPythonSupport", PyvtkPVPythonInformation_GetPythonSupport, METH_VARARGS,
   "GetPythonSupport(self) -> bool\nC++: virtual bool GetPythonSupport()\n\n"},
  {"PythonSupportOn", PyvtkPVPythonInformation_PythonSupportOn, METH_VARARGS,
   "PythonSupportOn(self) -> None\nC++: virtual void PythonSupportOn()\n\n"},
  {"PythonSupportOff", PyvtkPVPythonInformation_PythonSupportOff, METH_VARARGS,
   "PythonSupportOff(self) -> None\nC++: virtual void PythonSupportOff()\n\n"},
  {"SetPythonVersion", PyvtkPVPythonInformation_SetPythonVersion, METH_VARARGS,
   "SetPythonVersion(self, arg:str) -> None\nC++: void SetPythonVersion(const std::string &arg)\n\nIf GetPythonSupport() is true, returns the version of python\ndetected on the server.\n"},
  {"GetPythonVersion", PyvtkPVPythonInformation_GetPythonVersion, METH_VARARGS,
   "GetPythonVersion(self) -> str\nC++: const std::string &GetPythonVersion()\n\n"},
  {"SetPythonPath", PyvtkPVPythonInformation_SetPythonPath, METH_VARARGS,
   "SetPythonPath(self, arg:str) -> None\nC++: void SetPythonPath(const std::string &arg)\n\nIf GetPythonSupport() is true, returns the path to the python\nlibraries detected on the server.\n"},
  {"GetPythonPath", PyvtkPVPythonInformation_GetPythonPath, METH_VARARGS,
   "GetPythonPath(self) -> str\nC++: const std::string &GetPythonPath()\n\n"},
  {"SetNumpySupport", PyvtkPVPythonInformation_SetNumpySupport, METH_VARARGS,
   "SetNumpySupport(self, _arg:bool) -> None\nC++: virtual void SetNumpySupport(bool _arg)\n\nWhether the numpy module is available on the server.\n"},
  {"GetNumpySupport", PyvtkPVPythonInformation_GetNumpySupport, METH_VARARGS,
   "GetNumpySupport(self) -> bool\nC++: virtual bool GetNumpySupport()\n\n"},
  {"NumpySupportOn", PyvtkPVPythonInformation_NumpySupportOn, METH_VARARGS,
   "NumpySupportOn(self) -> None\nC++: virtual void NumpySupportOn()\n\n"},
  {"NumpySupportOff", PyvtkPVPythonInformation_NumpySupportOff, METH_VARARGS,
   "NumpySupportOff(self) -> None\nC++: virtual void NumpySupportOff()\n\n"},
  {"SetNumpyVersion", PyvtkPVPythonInformation_SetNumpyVersion, METH_VARARGS,
   "SetNumpyVersion(self, arg:str) -> None\nC++: void SetNumpyVersion(const std::string &arg)\n\nIf GetNumpySupport() is true, returns the version of numpy\ndetected on the server.\n"},
  {"GetNumpyVersion", PyvtkPVPythonInformation_GetNumpyVersion, METH_VARARGS,
   "GetNumpyVersion(self) -> str\nC++: const std::string &GetNumpyVersion()\n\n"},
  {"SetNumpyPath", PyvtkPVPythonInformation_SetNumpyPath, METH_VARARGS,
   "SetNumpyPath(self, arg:str) -> None\nC++: void SetNumpyPath(const std::string &arg)\n\nIf GetNumpySupport() is true, returns the path to numpy detected\non the server.\n"},
  {"GetNumpyPath", PyvtkPVPythonInformation_GetNumpyPath, METH_VARARGS,
   "GetNumpyPath(self) -> str\nC++: const std::string &GetNumpyPath()\n\n"},
  {"SetMatplotlibSupport", PyvtkPVPythonInformation_SetMatplotlibSupport, METH_VARARGS,
   "SetMatplotlibSupport(self, _arg:bool) -> None\nC++: virtual void SetMatplotlibSupport(bool _arg)\n\nWhether the matplotlib module is available on the server.\n"},
  {"GetMatplotlibSupport", PyvtkPVPythonInformation_GetMatplotlibSupport, METH_VARARGS,
   "GetMatplotlibSupport(self) -> bool\nC++: virtual bool GetMatplotlibSupport()\n\n"},
  {"MatplotlibSupportOn", PyvtkPVPythonInformation_MatplotlibSupportOn, METH_VARARGS,
   "MatplotlibSupportOn(self) -> None\nC++: virtual void MatplotlibSupportOn()\n\n"},
  {"MatplotlibSupportOff", PyvtkPVPythonInformation_MatplotlibSupportOff, METH_VARARGS,
   "MatplotlibSupportOff(self) -> None\nC++: virtual void MatplotlibSupportOff()\n\n"},
  {"SetMatplotlibVersion", PyvtkPVPythonInformation_SetMatplotlibVersion, METH_VARARGS,
   "SetMatplotlibVersion(self, arg:str) -> None\nC++: void SetMatplotlibVersion(const std::string &arg)\n\nIf GetMatplotlibSupport() is true, returns the version of\nmatplotlib detected on the server.\n"},
  {"GetMatplotlibVersion", PyvtkPVPythonInformation_GetMatplotlibVersion, METH_VARARGS,
   "GetMatplotlibVersion(self) -> str\nC++: const std::string &GetMatplotlibVersion()\n\n"},
  {"SetMatplotlibPath", PyvtkPVPythonInformation_SetMatplotlibPath, METH_VARARGS,
   "SetMatplotlibPath(self, arg:str) -> None\nC++: void SetMatplotlibPath(const std::string &arg)\n\nIf GetMatplotlibSupport() is true, returns the path to matplotlib\ndetected on the server.\n"},
  {"GetMatplotlibPath", PyvtkPVPythonInformation_GetMatplotlibPath, METH_VARARGS,
   "GetMatplotlibPath(self) -> str\nC++: const std::string &GetMatplotlibPath()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPythonInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("python_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetPythonSupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetPythonSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetPythonSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPythonSupport/SetPythonSupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("python_version"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetPythonVersion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetPythonVersion(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetPythonVersion(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPythonVersion/SetPythonVersion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("python_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetPythonPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetPythonPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetPythonPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPythonPath/SetPythonPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("numpy_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetNumpySupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetNumpySupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetNumpySupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumpySupport/SetNumpySupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("numpy_version"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetNumpyVersion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetNumpyVersion(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetNumpyVersion(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumpyVersion/SetNumpyVersion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("numpy_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetNumpyPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetNumpyPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetNumpyPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumpyPath/SetNumpyPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("matplotlib_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetMatplotlibSupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetMatplotlibSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetMatplotlibSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMatplotlibSupport/SetMatplotlibSupport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("matplotlib_version"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetMatplotlibVersion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetMatplotlibVersion(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetMatplotlibVersion(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMatplotlibVersion/SetMatplotlibVersion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("matplotlib_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonInformation_GetMatplotlibPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVPythonInformation_SetMatplotlibPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVPythonInformation_SetMatplotlibPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMatplotlibPath/SetMatplotlibPath\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVPythonInformation_Doc =
  "vtkPVPythonInformation - Gets python features.\n\n"
  "Superclass: vtkPVInformation\n\n"
  "Get details of python availability on the root server.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPythonInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVPythonInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVPythonInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVPythonInformation_StaticNew()
{
  return vtkPVPythonInformation::New();
}

PyObject *PyvtkPVPythonInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVPythonInformation_Type, PyvtkPVPythonInformation_Methods,
    "vtkPVPythonInformation",
 &PyvtkPVPythonInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVInformation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVPythonInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPythonInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPythonInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPythonInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

