// python wrapper for vtkPVRenderViewSettings
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVRenderViewSettings.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVRenderViewSettings(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVRenderViewSettings_ClassNew(); }


static PyObject *
PyvtkPVRenderViewSettings_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVRenderViewSettings::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVRenderViewSettings::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVRenderViewSettings *tempr = vtkPVRenderViewSettings::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVRenderViewSettings *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVRenderViewSettings::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVRenderViewSettings::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVRenderViewSettings::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVRenderViewSettings *tempr = vtkPVRenderViewSettings::GetInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetResolveCoincidentTopology(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResolveCoincidentTopology");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetResolveCoincidentTopology(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetResolveCoincidentTopology(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetPolygonOffsetParameters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolygonOffsetParameters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPolygonOffsetParameters(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetPolygonOffsetParameters(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetLineOffsetParameters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLineOffsetParameters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetLineOffsetParameters(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetLineOffsetParameters(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetPointOffsetParameter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointOffsetParameter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointOffsetParameter(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetPointOffsetParameter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetZShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZShift(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetZShift(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetOutlineThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutlineThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutlineThreshold(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetOutlineThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetOutlineThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutlineThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetOutlineThreshold() :
      op->vtkPVRenderViewSettings::GetOutlineThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetTwoSidedLighting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTwoSidedLighting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTwoSidedLighting(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetTwoSidedLighting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetTwoSidedLighting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTwoSidedLighting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTwoSidedLighting() :
      op->vtkPVRenderViewSettings::GetTwoSidedLighting());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetDefaultInteractionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDefaultInteractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDefaultInteractionMode(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetDefaultInteractionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetDefaultInteractionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDefaultInteractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDefaultInteractionMode() :
      op->vtkPVRenderViewSettings::GetDefaultInteractionMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetPointPickingRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointPickingRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointPickingRadius(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetPointPickingRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetPointPickingRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointPickingRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPointPickingRadius() :
      op->vtkPVRenderViewSettings::GetPointPickingRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetDisableIceT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisableIceT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisableIceT(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetDisableIceT(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetDisableIceT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisableIceT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisableIceT() :
      op->vtkPVRenderViewSettings::GetDisableIceT());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetEnableFastPreselection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableFastPreselection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableFastPreselection(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetEnableFastPreselection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetEnableFastPreselection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableFastPreselection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableFastPreselection() :
      op->vtkPVRenderViewSettings::GetEnableFastPreselection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetGrowSelectionRemoveSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGrowSelectionRemoveSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGrowSelectionRemoveSeed(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetGrowSelectionRemoveSeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetGrowSelectionRemoveSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGrowSelectionRemoveSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGrowSelectionRemoveSeed() :
      op->vtkPVRenderViewSettings::GetGrowSelectionRemoveSeed());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetGrowSelectionRemoveIntermediateLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGrowSelectionRemoveIntermediateLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGrowSelectionRemoveIntermediateLayers(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetGrowSelectionRemoveIntermediateLayers(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetGrowSelectionRemoveIntermediateLayers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGrowSelectionRemoveIntermediateLayers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGrowSelectionRemoveIntermediateLayers() :
      op->vtkPVRenderViewSettings::GetGrowSelectionRemoveIntermediateLayers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetBackgroundColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetBackgroundColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderViewSettings_SetBackgroundColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundColor(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetBackgroundColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderViewSettings_SetBackgroundColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVRenderViewSettings_SetBackgroundColor_s1(self, args);
    case 1:
      return PyvtkPVRenderViewSettings_SetBackgroundColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBackgroundColor");
  return nullptr;
}


static PyObject *
PyvtkPVRenderViewSettings_GetBackgroundColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackgroundColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBackgroundColor() :
      op->vtkPVRenderViewSettings::GetBackgroundColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetBackground2Color_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackground2Color");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBackground2Color(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetBackground2Color(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderViewSettings_SetBackground2Color_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackground2Color");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetBackground2Color(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetBackground2Color(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderViewSettings_SetBackground2Color(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVRenderViewSettings_SetBackground2Color_s1(self, args);
    case 1:
      return PyvtkPVRenderViewSettings_SetBackground2Color_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBackground2Color");
  return nullptr;
}


static PyObject *
PyvtkPVRenderViewSettings_GetBackground2Color(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackground2Color");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBackground2Color() :
      op->vtkPVRenderViewSettings::GetBackground2Color());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetBackgroundColorMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundColorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundColorMode(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetBackgroundColorMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetBackgroundColorMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackgroundColorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackgroundColorMode() :
      op->vtkPVRenderViewSettings::GetBackgroundColorMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_SetZoomClosestOffsetRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetZoomClosestOffsetRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetZoomClosestOffsetRatio(temp0);
    }
    else
    {
      op->vtkPVRenderViewSettings::SetZoomClosestOffsetRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderViewSettings_GetZoomClosestOffsetRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetZoomClosestOffsetRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderViewSettings *op = static_cast<vtkPVRenderViewSettings *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetZoomClosestOffsetRatio() :
      op->vtkPVRenderViewSettings::GetZoomClosestOffsetRatio());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRenderViewSettings_Methods[] = {
  {"IsTypeOf", PyvtkPVRenderViewSettings_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVRenderViewSettings_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVRenderViewSettings_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVRenderViewSettings\nC++: static vtkPVRenderViewSettings *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVRenderViewSettings_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVRenderViewSettings\nC++: vtkPVRenderViewSettings *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVRenderViewSettings_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVRenderViewSettings_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInstance", PyvtkPVRenderViewSettings_GetInstance, METH_VARARGS,
   "GetInstance() -> vtkPVRenderViewSettings\nC++: static vtkPVRenderViewSettings *GetInstance()\n\nAccess the singleton.\n"},
  {"SetResolveCoincidentTopology", PyvtkPVRenderViewSettings_SetResolveCoincidentTopology, METH_VARARGS,
   "SetResolveCoincidentTopology(self, mode:int) -> None\nC++: void SetResolveCoincidentTopology(int mode)\n\nvtkMapper settings.\n"},
  {"SetPolygonOffsetParameters", PyvtkPVRenderViewSettings_SetPolygonOffsetParameters, METH_VARARGS,
   "SetPolygonOffsetParameters(self, factor:float, units:float)\n    -> None\nC++: void SetPolygonOffsetParameters(double factor, double units)\n\n"},
  {"SetLineOffsetParameters", PyvtkPVRenderViewSettings_SetLineOffsetParameters, METH_VARARGS,
   "SetLineOffsetParameters(self, factor:float, units:float) -> None\nC++: void SetLineOffsetParameters(double factor, double units)\n\n"},
  {"SetPointOffsetParameter", PyvtkPVRenderViewSettings_SetPointOffsetParameter, METH_VARARGS,
   "SetPointOffsetParameter(self, units:float) -> None\nC++: void SetPointOffsetParameter(double units)\n\n"},
  {"SetZShift", PyvtkPVRenderViewSettings_SetZShift, METH_VARARGS,
   "SetZShift(self, a:float) -> None\nC++: void SetZShift(double a)\n\n"},
  {"SetOutlineThreshold", PyvtkPVRenderViewSettings_SetOutlineThreshold, METH_VARARGS,
   "SetOutlineThreshold(self, _arg:int) -> None\nC++: virtual void SetOutlineThreshold(vtkIdType _arg)\n\nSet the number of cells (in millions) when the representations\nshow try to use outline by default.\n"},
  {"GetOutlineThreshold", PyvtkPVRenderViewSettings_GetOutlineThreshold, METH_VARARGS,
   "GetOutlineThreshold(self) -> int\nC++: virtual vtkIdType GetOutlineThreshold()\n\n"},
  {"SetTwoSidedLighting", PyvtkPVRenderViewSettings_SetTwoSidedLighting, METH_VARARGS,
   "SetTwoSidedLighting(self, _arg:bool) -> None\nC++: virtual void SetTwoSidedLighting(bool _arg)\n\nWhen rendering a volume, this option simulates light coming from\nboth its direction and its opposite for all lights in the scene.\nIt is enabled by default.\n"},
  {"GetTwoSidedLighting", PyvtkPVRenderViewSettings_GetTwoSidedLighting, METH_VARARGS,
   "GetTwoSidedLighting(self) -> bool\nC++: virtual bool GetTwoSidedLighting()\n\n"},
  {"SetDefaultInteractionMode", PyvtkPVRenderViewSettings_SetDefaultInteractionMode, METH_VARARGS,
   "SetDefaultInteractionMode(self, _arg:int) -> None\nC++: virtual void SetDefaultInteractionMode(int _arg)\n\nSet the default interaction mode.\n"},
  {"GetDefaultInteractionMode", PyvtkPVRenderViewSettings_GetDefaultInteractionMode, METH_VARARGS,
   "GetDefaultInteractionMode(self) -> int\nC++: virtual int GetDefaultInteractionMode()\n\n"},
  {"SetPointPickingRadius", PyvtkPVRenderViewSettings_SetPointPickingRadius, METH_VARARGS,
   "SetPointPickingRadius(self, _arg:int) -> None\nC++: virtual void SetPointPickingRadius(int _arg)\n\nSet the radius in pixels to include for finding the closet point\nwhen selecting a point on render view. This only after single\npoint selections i.e. when selecting a regions this radius is not\nrespected.\n"},
  {"GetPointPickingRadius", PyvtkPVRenderViewSettings_GetPointPickingRadius, METH_VARARGS,
   "GetPointPickingRadius(self) -> int\nC++: virtual int GetPointPickingRadius()\n\n"},
  {"SetDisableIceT", PyvtkPVRenderViewSettings_SetDisableIceT, METH_VARARGS,
   "SetDisableIceT(self, _arg:bool) -> None\nC++: virtual void SetDisableIceT(bool _arg)\n\nEXPERIMENTAL: Add ability to disable IceT.\n"},
  {"GetDisableIceT", PyvtkPVRenderViewSettings_GetDisableIceT, METH_VARARGS,
   "GetDisableIceT(self) -> bool\nC++: virtual bool GetDisableIceT()\n\n"},
  {"SetEnableFastPreselection", PyvtkPVRenderViewSettings_SetEnableFastPreselection, METH_VARARGS,
   "SetEnableFastPreselection(self, _arg:bool) -> None\nC++: virtual void SetEnableFastPreselection(bool _arg)\n\nEnable fast preselection. When enabled, the preselection is\ncomputed using the visible geometry. This avoids a call to the\nextract selection filter each time the mouse moves, improving a\nlot the preselection highlight display, especially for big\ndatasets.\n"},
  {"GetEnableFastPreselection", PyvtkPVRenderViewSettings_GetEnableFastPreselection, METH_VARARGS,
   "GetEnableFastPreselection(self) -> bool\nC++: virtual bool GetEnableFastPreselection()\n\n"},
  {"SetGrowSelectionRemoveSeed", PyvtkPVRenderViewSettings_SetGrowSelectionRemoveSeed, METH_VARARGS,
   "SetGrowSelectionRemoveSeed(self, _arg:bool) -> None\nC++: virtual void SetGrowSelectionRemoveSeed(bool _arg)\n\nWhen enabled and growing selection, remove the initial selection\nseed. Default is false.\n"},
  {"GetGrowSelectionRemoveSeed", PyvtkPVRenderViewSettings_GetGrowSelectionRemoveSeed, METH_VARARGS,
   "GetGrowSelectionRemoveSeed(self) -> bool\nC++: virtual bool GetGrowSelectionRemoveSeed()\n\n"},
  {"SetGrowSelectionRemoveIntermediateLayers", PyvtkPVRenderViewSettings_SetGrowSelectionRemoveIntermediateLayers, METH_VARARGS,
   "SetGrowSelectionRemoveIntermediateLayers(self, _arg:bool) -> None\nC++: virtual void SetGrowSelectionRemoveIntermediateLayers(\n    bool _arg)\n\nWhen enabled and growing selection, remove the intermediate\nlayers. Default is false.\n"},
  {"GetGrowSelectionRemoveIntermediateLayers", PyvtkPVRenderViewSettings_GetGrowSelectionRemoveIntermediateLayers, METH_VARARGS,
   "GetGrowSelectionRemoveIntermediateLayers(self) -> bool\nC++: virtual bool GetGrowSelectionRemoveIntermediateLayers()\n\n"},
  {"SetBackgroundColor", PyvtkPVRenderViewSettings_SetBackgroundColor, METH_VARARGS,
   "SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetBackgroundColor(double _arg1, double _arg2,\n    double _arg3)\nSetBackgroundColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetBackgroundColor(const double _arg[3])\n\nUsed by vtkPVRenderView and other views to determine background\ncolor.\n"},
  {"GetBackgroundColor", PyvtkPVRenderViewSettings_GetBackgroundColor, METH_VARARGS,
   "GetBackgroundColor(self) -> (float, float, float)\nC++: virtual double *GetBackgroundColor()\n\n"},
  {"SetBackground2Color", PyvtkPVRenderViewSettings_SetBackground2Color, METH_VARARGS,
   "SetBackground2Color(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetBackground2Color(double _arg1, double _arg2,\n    double _arg3)\nSetBackground2Color(self, _arg:(float, float, float)) -> None\nC++: virtual void SetBackground2Color(const double _arg[3])\n\n"},
  {"GetBackground2Color", PyvtkPVRenderViewSettings_GetBackground2Color, METH_VARARGS,
   "GetBackground2Color(self) -> (float, float, float)\nC++: virtual double *GetBackground2Color()\n\n"},
  {"SetBackgroundColorMode", PyvtkPVRenderViewSettings_SetBackgroundColorMode, METH_VARARGS,
   "SetBackgroundColorMode(self, _arg:int) -> None\nC++: virtual void SetBackgroundColorMode(int _arg)\n\n"},
  {"GetBackgroundColorMode", PyvtkPVRenderViewSettings_GetBackgroundColorMode, METH_VARARGS,
   "GetBackgroundColorMode(self) -> int\nC++: virtual int GetBackgroundColorMode()\n\n"},
  {"SetZoomClosestOffsetRatio", PyvtkPVRenderViewSettings_SetZoomClosestOffsetRatio, METH_VARARGS,
   "SetZoomClosestOffsetRatio(self, _arg:float) -> None\nC++: virtual void SetZoomClosestOffsetRatio(double _arg)\n\nOffsetRatio is used to add a zoom offset when using Reset Camera\nClosest and Zoom Closest To Data.\n\nDefault is 0.9.\n"},
  {"GetZoomClosestOffsetRatio", PyvtkPVRenderViewSettings_GetZoomClosestOffsetRatio, METH_VARARGS,
   "GetZoomClosestOffsetRatio(self) -> float\nC++: virtual double GetZoomClosestOffsetRatio()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVRenderViewSettings_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("resolve_coincident_topology"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetResolveCoincidentTopology(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetResolveCoincidentTopology(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetResolveCoincidentTopology\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polygon_offset_parameters"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetPolygonOffsetParameters(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetPolygonOffsetParameters(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolygonOffsetParameters\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("line_offset_parameters"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetLineOffsetParameters(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetLineOffsetParameters(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLineOffsetParameters\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_offset_parameter"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetPointOffsetParameter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetPointOffsetParameter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointOffsetParameter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("z_shift"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetZShift(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetZShift(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetZShift\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("outline_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetOutlineThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetOutlineThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetOutlineThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutlineThreshold/SetOutlineThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("two_sided_lighting"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetTwoSidedLighting(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetTwoSidedLighting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetTwoSidedLighting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTwoSidedLighting/SetTwoSidedLighting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("default_interaction_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetDefaultInteractionMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetDefaultInteractionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetDefaultInteractionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDefaultInteractionMode/SetDefaultInteractionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_picking_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetPointPickingRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetPointPickingRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetPointPickingRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPointPickingRadius/SetPointPickingRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("disable_ice_t"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetDisableIceT(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetDisableIceT(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetDisableIceT(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisableIceT/SetDisableIceT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_fast_preselection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetEnableFastPreselection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetEnableFastPreselection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetEnableFastPreselection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableFastPreselection/SetEnableFastPreselection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grow_selection_remove_seed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetGrowSelectionRemoveSeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetGrowSelectionRemoveSeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetGrowSelectionRemoveSeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGrowSelectionRemoveSeed/SetGrowSelectionRemoveSeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grow_selection_remove_intermediate_layers"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetGrowSelectionRemoveIntermediateLayers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetGrowSelectionRemoveIntermediateLayers(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetGrowSelectionRemoveIntermediateLayers(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGrowSelectionRemoveIntermediateLayers/SetGrowSelectionRemoveIntermediateLayers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetBackgroundColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetBackgroundColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetBackgroundColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackgroundColor/SetBackgroundColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background2_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetBackground2Color(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetBackground2Color(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetBackground2Color(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackground2Color/SetBackground2Color\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_color_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetBackgroundColorMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetBackgroundColorMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetBackgroundColorMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackgroundColorMode/SetBackgroundColorMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("zoom_closest_offset_ratio"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetZoomClosestOffsetRatio(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderViewSettings_SetZoomClosestOffsetRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderViewSettings_SetZoomClosestOffsetRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetZoomClosestOffsetRatio/SetZoomClosestOffsetRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderViewSettings_GetInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInstance\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVRenderViewSettings_Doc =
  "vtkPVRenderViewSettings - singleton used to keep track of options for\nvtkPVRenderView.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVRenderViewSettings is a singleton used to keep track of\n"
  "selections for various configurable parameters used by\n"
  "vtkPVRenderView. All class to vtkPVRenderViewSettings::New() returns\n"
  "a reference to the singleton instance.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderViewSettings_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderViewSettings", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVRenderViewSettings_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVRenderViewSettings_StaticNew()
{
  return vtkPVRenderViewSettings::New();
}

PyObject *PyvtkPVRenderViewSettings_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVRenderViewSettings_Type, PyvtkPVRenderViewSettings_Methods,
    "vtkPVRenderViewSettings",
 &PyvtkPVRenderViewSettings_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 7; c++)
  {
    static const struct { const char *name; int value; }
      constants[7] = {
        { "DO_NOTHING", vtkPVRenderViewSettings::DO_NOTHING },
        { "OFFSET_FACES", vtkPVRenderViewSettings::OFFSET_FACES },
        { "OFFSET_LINES_AND_VERTS", vtkPVRenderViewSettings::OFFSET_LINES_AND_VERTS },
        { "ZSHIFT", vtkPVRenderViewSettings::ZSHIFT },
        { "AUTOMATIC", vtkPVRenderViewSettings::AUTOMATIC },
        { "ALWAYS_2D", vtkPVRenderViewSettings::ALWAYS_2D },
        { "ALWAYS_3D", vtkPVRenderViewSettings::ALWAYS_3D },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVRenderViewSettings_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVRenderViewSettings(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVRenderViewSettings_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVRenderViewSettings", o) != 0)
  {
    Py_DECREF(o);
  }

}

