/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qmessageauthenticationcode.sip"
#include <qmessageauthenticationcode.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQMessageAuthenticationCode.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qcryptographichash.sip"
#include <qcryptographichash.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQMessageAuthenticationCode.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearrayview.sip"
#include <qbytearrayview.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQMessageAuthenticationCode.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQMessageAuthenticationCode.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qiodevice.sip"
#include <qiodevice.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtCore/sipQtCoreQMessageAuthenticationCode.cpp"


PyDoc_STRVAR(doc_QMessageAuthenticationCode_reset, "reset(self)");

extern "C" {static PyObject *meth_QMessageAuthenticationCode_reset(PyObject *, PyObject *);}
static PyObject *meth_QMessageAuthenticationCode_reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QMessageAuthenticationCode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMessageAuthenticationCode, &sipCpp))
        {
            sipCpp->reset();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMessageAuthenticationCode, sipName_reset, doc_QMessageAuthenticationCode_reset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMessageAuthenticationCode_setKey, "setKey(self, key: Union[QByteArray, bytes, bytearray, memoryview])");

extern "C" {static PyObject *meth_QMessageAuthenticationCode_setKey(PyObject *, PyObject *);}
static PyObject *meth_QMessageAuthenticationCode_setKey(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        ::QMessageAuthenticationCode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QMessageAuthenticationCode, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            sipCpp->setKey(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMessageAuthenticationCode, sipName_setKey, doc_QMessageAuthenticationCode_setKey);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMessageAuthenticationCode_addData, "addData(self, data: Union[QByteArray, bytes, bytearray, memoryview])\n"
"addData(self, device: Optional[QIODevice]) -> bool");

extern "C" {static PyObject *meth_QMessageAuthenticationCode_addData(PyObject *, PyObject *);}
static PyObject *meth_QMessageAuthenticationCode_addData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        ::QMessageAuthenticationCode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QMessageAuthenticationCode, &sipCpp, sipType_QByteArrayView, &a0, &a0State, &a0UserState))
        {
            sipCpp->addData(*a0);
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QIODevice* a0;
        ::QMessageAuthenticationCode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QMessageAuthenticationCode, &sipCpp, sipType_QIODevice, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->addData(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMessageAuthenticationCode, sipName_addData, doc_QMessageAuthenticationCode_addData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMessageAuthenticationCode_result, "result(self) -> QByteArray");

extern "C" {static PyObject *meth_QMessageAuthenticationCode_result(PyObject *, PyObject *);}
static PyObject *meth_QMessageAuthenticationCode_result(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMessageAuthenticationCode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QMessageAuthenticationCode, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->result());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMessageAuthenticationCode, sipName_result, doc_QMessageAuthenticationCode_result);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMessageAuthenticationCode_hash, "hash(message: Union[QByteArray, bytes, bytearray, memoryview], key: Union[QByteArray, bytes, bytearray, memoryview], method: QCryptographicHash.Algorithm) -> QByteArray");

extern "C" {static PyObject *meth_QMessageAuthenticationCode_hash(PyObject *, PyObject *);}
static PyObject *meth_QMessageAuthenticationCode_hash(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QByteArrayView* a0;
        int a0State = 0;
        void *a0UserState = SIP_NULLPTR;
        ::QByteArrayView* a1;
        int a1State = 0;
        void *a1UserState = SIP_NULLPTR;
        ::QCryptographicHash::Algorithm a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1J1E", &sipSelf, sipType_QByteArrayView, &a0, &a0State, &a0UserState, sipType_QByteArrayView, &a1, &a1State, &a1UserState, sipType_QCryptographicHash_Algorithm, &a2))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(::QMessageAuthenticationCode::hash(*a0, *a1, a2));
            sipReleaseTypeUS(a0, sipType_QByteArrayView, a0State, a0UserState);
            sipReleaseTypeUS(a1, sipType_QByteArrayView, a1State, a1UserState);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QMessageAuthenticationCode, sipName_hash, doc_QMessageAuthenticationCode_hash);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QMessageAuthenticationCode_swap, "swap(self, other: QMessageAuthenticationCode)");

extern "C" {static PyObject *meth_QMessageAuthenticationCode_swap(PyObject *, PyObject *);}
static PyObject *meth_QMessageAuthenticationCode_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QMessageAuthenticationCode* a0;
        ::QMessageAuthenticationCode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QMessageAuthenticationCode, &sipCpp, sipType_QMessageAuthenticationCode, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QMessageAuthenticationCode, sipName_swap, doc_QMessageAuthenticationCode_swap);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QMessageAuthenticationCode(void *, int);}
static void release_QMessageAuthenticationCode(void *sipCppV, int)
{
    delete reinterpret_cast< ::QMessageAuthenticationCode *>(sipCppV);
}


extern "C" {static void dealloc_QMessageAuthenticationCode(sipSimpleWrapper *);}
static void dealloc_QMessageAuthenticationCode(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QMessageAuthenticationCode(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QMessageAuthenticationCode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QMessageAuthenticationCode(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QMessageAuthenticationCode *sipCpp = SIP_NULLPTR;

    {
        ::QCryptographicHash::Algorithm a0;
        ::QByteArrayView a1def = {};
        ::QByteArrayView* a1 = &a1def;
        int a1State = 0;
        void *a1UserState = SIP_NULLPTR;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_key,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E|J1", sipType_QCryptographicHash_Algorithm, &a0, sipType_QByteArrayView, &a1, &a1State, &a1UserState))
        {
            sipCpp = new ::QMessageAuthenticationCode(a0, *a1);
            sipReleaseTypeUS(a1, sipType_QByteArrayView, a1State, a1UserState);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QMessageAuthenticationCode[] = {
    {sipName_addData, meth_QMessageAuthenticationCode_addData, METH_VARARGS, doc_QMessageAuthenticationCode_addData},
    {sipName_hash, meth_QMessageAuthenticationCode_hash, METH_VARARGS, doc_QMessageAuthenticationCode_hash},
    {sipName_reset, meth_QMessageAuthenticationCode_reset, METH_VARARGS, doc_QMessageAuthenticationCode_reset},
    {sipName_result, meth_QMessageAuthenticationCode_result, METH_VARARGS, doc_QMessageAuthenticationCode_result},
    {sipName_setKey, meth_QMessageAuthenticationCode_setKey, METH_VARARGS, doc_QMessageAuthenticationCode_setKey},
    {sipName_swap, meth_QMessageAuthenticationCode_swap, METH_VARARGS, doc_QMessageAuthenticationCode_swap}
};

PyDoc_STRVAR(doc_QMessageAuthenticationCode, "\1QMessageAuthenticationCode(method: QCryptographicHash.Algorithm, key: Union[QByteArray, bytes, bytearray, memoryview] = {})");


sipClassTypeDef sipTypeDef_QtCore_QMessageAuthenticationCode = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QMessageAuthenticationCode,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QMessageAuthenticationCode,
        {0, 0, 1},
        6, methods_QMessageAuthenticationCode,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QMessageAuthenticationCode,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QMessageAuthenticationCode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QMessageAuthenticationCode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QMessageAuthenticationCode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QMessageAuthenticationCode),
};
