#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

/* passed to the real C compiler */
#ifndef LIBEV_EMBED
/* We're normally used to embed libev, assume that */
/* When this is defined, libev.h includes ev.c */
#define LIBEV_EMBED 1
#endif

#ifdef _WIN32
#define EV_STANDALONE 1
#include "libev_vfd.h"
#endif


#include "libev.h"

static void
_gevent_noop(struct ev_loop *_loop, struct ev_timer *w, int revents) { }

void (*gevent_noop)(struct ev_loop *, struct ev_timer *, int) = &_gevent_noop;

static int python_callback(void* handle, int revents);
static void python_handle_error(void* handle, int revents);
static void python_stop(void* handle);

static void _gevent_generic_callback(struct ev_loop* loop,
				     struct ev_watcher* watcher,
				     int revents)
{
    void* handle = watcher->data;
    int cb_result = python_callback(handle, revents);
    switch(cb_result) {
        case -1:
            // in case of exception, call self.loop.handle_error;
            // this function is also responsible for stopping the watcher
            // and allowing memory to be freed
            python_handle_error(handle, revents);
        break;
        case 1:
            // Code to stop the event. Note that if python_callback
            // has disposed of the last reference to the handle,
            // `watcher` could now be invalid/disposed memory!
            if (!ev_is_active(watcher)) {
                python_stop(handle);
            }
        break;
        case 2:
            // watcher is already stopped and dead, nothing to do.
        break;
        default:
            fprintf(stderr,
                    "WARNING: gevent: Unexpected return value %d from Python callback "
                    "for watcher %p and handle %p\n",
                    cb_result,
                    watcher, handle);
            // XXX: Possible leaking of resources here? Should we be
            // closing the watcher?
    }
}

static void gevent_zero_timer(struct ev_timer* handle)
{
	memset(handle, 0, sizeof(struct ev_timer));
}

static void gevent_zero_check(struct ev_check* handle)
{
	memset(handle, 0, sizeof(struct ev_check));
}

static void gevent_zero_prepare(struct ev_prepare* handle)
{
	memset(handle, 0, sizeof(struct ev_prepare));
}

#include "_ffi/alloc.c"

static void gevent_set_ev_alloc()
{
    void* (*ptr)(void*, long);
    ptr = (void*(*)(void*, long))&gevent_realloc;
    ev_set_allocator(ptr);
}

#define GEVENT_CFFI 1
#include "check_valid_fd.c"
#undef GEVENT_CFFI

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunreachable-code"
#endif


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 38), // double()(struct ev_loop *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 188), // struct ev_loop *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 38), // double()(void)
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // int()(int)
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // int()(struct ev_async *)
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 182), // struct ev_async *
/* 10 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // int()(struct ev_loop *)
/* 12 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // int()(void *)
/* 15 */ _CFFI_OP(_CFFI_OP_POINTER, 200), // void *
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // int()(void *, int)
/* 18 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 19 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 6), // int()(void)
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // struct ev_loop *()(unsigned int)
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // unsigned int()(struct ev_loop *)
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // unsigned int()(void)
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // void *()(struct ev_loop *)
/* 32 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(char *)
/* 35 */ _CFFI_OP(_CFFI_OP_POINTER, 179), // char *
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(double)
/* 38 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_async *, void *)
/* 41 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 43 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_check *)
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 183), // struct ev_check *
/* 46 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_check *, void *)
/* 48 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_child *, void *, int, int)
/* 52 */ _CFFI_OP(_CFFI_OP_POINTER, 184), // struct ev_child *
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 55 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_fork *, void *)
/* 58 */ _CFFI_OP(_CFFI_OP_POINTER, 185), // struct ev_fork *
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_idle *, void *)
/* 62 */ _CFFI_OP(_CFFI_OP_POINTER, 186), // struct ev_idle *
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_io *, void *, int, int)
/* 66 */ _CFFI_OP(_CFFI_OP_POINTER, 187), // struct ev_io *
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 68 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *)
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, int)
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 76 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, int, int)
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 80 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_async *)
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_check *)
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_child *)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_fork *)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_idle *)
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 62),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_io *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_prepare *)
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 109 */ _CFFI_OP(_CFFI_OP_POINTER, 189), // struct ev_prepare *
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_signal *)
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 113 */ _CFFI_OP(_CFFI_OP_POINTER, 190), // struct ev_signal *
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_stat *)
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 117 */ _CFFI_OP(_CFFI_OP_POINTER, 191), // struct ev_stat *
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_timer *)
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 121 */ _CFFI_OP(_CFFI_OP_POINTER, 192), // struct ev_timer *
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_timer *, int)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 126 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, struct ev_watcher *, int)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 130 */ _CFFI_OP(_CFFI_OP_POINTER, 193), // struct ev_watcher *
/* 131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, void *)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_loop *, void *, int)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 139 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 140 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_prepare *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 109),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_prepare *, void *)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 109),
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_signal *, void *, int)
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_stat *, void *, char *, double)
/* 155 */ _CFFI_OP(_CFFI_OP_NOOP, 117),
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 35),
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_timer *)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(struct ev_timer *, void *, double, double)
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 121),
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 167 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(void *)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(void *, int)
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 15),
/* 174 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // void()(void)
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 178 */ _CFFI_OP(_CFFI_OP_POINTER, 179), // char const *
/* 179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 180 */ _CFFI_OP(_CFFI_OP_POINTER, 17), // int(*)(void *, int)
/* 181 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(nlink_t), (
           ((nlink_t)-1) | 0 /* check that nlink_t is an integer type */
         ) <= 0)), // nlink_t
/* 182 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct ev_async
/* 183 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct ev_check
/* 184 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct ev_child
/* 185 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct ev_fork
/* 186 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct ev_idle
/* 187 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct ev_io
/* 188 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct ev_loop
/* 189 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct ev_prepare
/* 190 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct ev_signal
/* 191 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct ev_stat
/* 192 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct ev_timer
/* 193 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct ev_watcher
/* 194 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct stat
/* 195 */ _CFFI_OP(_CFFI_OP_POINTER, 34), // void(*)(char *)
/* 196 */ _CFFI_OP(_CFFI_OP_POINTER, 123), // void(*)(struct ev_loop *, struct ev_timer *, int)
/* 197 */ _CFFI_OP(_CFFI_OP_POINTER, 137), // void(*)(struct ev_loop *, void *, int)
/* 198 */ _CFFI_OP(_CFFI_OP_POINTER, 169), // void(*)(void *)
/* 199 */ _CFFI_OP(_CFFI_OP_POINTER, 172), // void(*)(void *, int)
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static struct _cffi_externpy_s _cffi_externpy___syserr_cb =
  { "gevent.libev._corecffi._syserr_cb", 0, 0, 0 };

static void _syserr_cb(char * a0)
{
  char a[8];
  char *p = a;
  *(char * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___syserr_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_callback =
  { "gevent.libev._corecffi.python_callback", (int)sizeof(int), 0, 0 };

static int python_callback(void * a0, int a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__python_callback, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__python_check_callback =
  { "gevent.libev._corecffi.python_check_callback", 0, 0, 0 };

static void python_check_callback(struct ev_loop * a0, void * a1, int a2)
{
  char a[24];
  char *p = a;
  *(struct ev_loop * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__python_check_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_handle_error =
  { "gevent.libev._corecffi.python_handle_error", 0, 0, 0 };

static void python_handle_error(void * a0, int a1)
{
  char a[16];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__python_handle_error, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_prepare_callback =
  { "gevent.libev._corecffi.python_prepare_callback", 0, 0, 0 };

static void python_prepare_callback(struct ev_loop * a0, void * a1, int a2)
{
  char a[24];
  char *p = a;
  *(struct ev_loop * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__python_prepare_callback, p);
}

static struct _cffi_externpy_s _cffi_externpy__python_stop =
  { "gevent.libev._corecffi.python_stop", 0, 0, 0 };

static void python_stop(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__python_stop, p);
}

static void _cffi_d__gevent_generic_callback(struct ev_loop * x0, struct ev_watcher * x1, int x2)
{
  _gevent_generic_callback(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__gevent_generic_callback(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_watcher * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "_gevent_generic_callback", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_watcher *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _gevent_generic_callback(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__gevent_generic_callback _cffi_d__gevent_generic_callback
#endif

static void _cffi_d_ev_async_init(struct ev_async * x0, void * x1)
{
  ev_async_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_async_init(PyObject *self, PyObject *args)
{
  struct ev_async * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_async_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_async *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_async_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_async_init _cffi_d_ev_async_init
#endif

static int _cffi_d_ev_async_pending(struct ev_async * x0)
{
  return ev_async_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_async_pending(PyObject *self, PyObject *arg0)
{
  struct ev_async * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_async *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_async_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_async_pending _cffi_d_ev_async_pending
#endif

static void _cffi_d_ev_async_send(struct ev_loop * x0, struct ev_async * x1)
{
  ev_async_send(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_async_send(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_async * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_async_send", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_async *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_async_send(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_async_send _cffi_d_ev_async_send
#endif

static void _cffi_d_ev_async_start(struct ev_loop * x0, struct ev_async * x1)
{
  ev_async_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_async_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_async * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_async_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_async *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_async_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_async_start _cffi_d_ev_async_start
#endif

static void _cffi_d_ev_async_stop(struct ev_loop * x0, struct ev_async * x1)
{
  ev_async_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_async_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_async * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_async_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_async *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_async_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_async_stop _cffi_d_ev_async_stop
#endif

static unsigned int _cffi_d_ev_backend(struct ev_loop * x0)
{
  return ev_backend(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_backend(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_backend(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_backend _cffi_d_ev_backend
#endif

static void _cffi_d_ev_break(struct ev_loop * x0, int x1)
{
  ev_break(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_break(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_break", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_break(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_break _cffi_d_ev_break
#endif

static void _cffi_d_ev_check_init(struct ev_check * x0, void * x1)
{
  ev_check_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_check_init(PyObject *self, PyObject *args)
{
  struct ev_check * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_check_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_check *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_check_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_check_init _cffi_d_ev_check_init
#endif

static void _cffi_d_ev_check_start(struct ev_loop * x0, struct ev_check * x1)
{
  ev_check_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_check_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_check * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_check_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_check *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_check_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_check_start _cffi_d_ev_check_start
#endif

static void _cffi_d_ev_check_stop(struct ev_loop * x0, struct ev_check * x1)
{
  ev_check_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_check_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_check * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_check_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_check *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_check_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_check_stop _cffi_d_ev_check_stop
#endif

static void _cffi_d_ev_child_init(struct ev_child * x0, void * x1, int x2, int x3)
{
  ev_child_init(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_child_init(PyObject *self, PyObject *args)
{
  struct ev_child * x0;
  void * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ev_child_init", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_child *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_child_init(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_child_init _cffi_d_ev_child_init
#endif

static void _cffi_d_ev_child_start(struct ev_loop * x0, struct ev_child * x1)
{
  ev_child_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_child_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_child * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_child_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_child *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_child_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_child_start _cffi_d_ev_child_start
#endif

static void _cffi_d_ev_child_stop(struct ev_loop * x0, struct ev_child * x1)
{
  ev_child_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_child_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_child * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_child_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_child *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_child_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_child_stop _cffi_d_ev_child_stop
#endif

static struct ev_loop * _cffi_d_ev_default_loop(unsigned int x0)
{
  return ev_default_loop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_default_loop(PyObject *self, PyObject *arg0)
{
  unsigned int x0;
  struct ev_loop * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_default_loop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_ev_default_loop _cffi_d_ev_default_loop
#endif

static unsigned int _cffi_d_ev_depth(struct ev_loop * x0)
{
  return ev_depth(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_depth(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_depth(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_depth _cffi_d_ev_depth
#endif

static unsigned int _cffi_d_ev_embeddable_backends(void)
{
  return ev_embeddable_backends();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_embeddable_backends(PyObject *self, PyObject *noarg)
{
  unsigned int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_embeddable_backends(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ev_embeddable_backends _cffi_d_ev_embeddable_backends
#endif

static void _cffi_d_ev_feed_event(struct ev_loop * x0, void * x1, int x2)
{
  ev_feed_event(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_feed_event(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  void * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ev_feed_event", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_feed_event(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_feed_event _cffi_d_ev_feed_event
#endif

static void _cffi_d_ev_feed_fd_event(struct ev_loop * x0, int x1, int x2)
{
  ev_feed_fd_event(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_feed_fd_event(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ev_feed_fd_event", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_feed_fd_event(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_feed_fd_event _cffi_d_ev_feed_fd_event
#endif

static void _cffi_d_ev_fork_init(struct ev_fork * x0, void * x1)
{
  ev_fork_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_fork_init(PyObject *self, PyObject *args)
{
  struct ev_fork * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_fork_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_fork *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_fork_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_fork_init _cffi_d_ev_fork_init
#endif

static void _cffi_d_ev_fork_start(struct ev_loop * x0, struct ev_fork * x1)
{
  ev_fork_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_fork_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_fork * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_fork_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_fork *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_fork_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_fork_start _cffi_d_ev_fork_start
#endif

static void _cffi_d_ev_fork_stop(struct ev_loop * x0, struct ev_fork * x1)
{
  ev_fork_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_fork_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_fork * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_fork_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(58), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_fork *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(58), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_fork_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_fork_stop _cffi_d_ev_fork_stop
#endif

static void _cffi_d_ev_idle_init(struct ev_idle * x0, void * x1)
{
  ev_idle_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_idle_init(PyObject *self, PyObject *args)
{
  struct ev_idle * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_idle_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_idle *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_idle_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_idle_init _cffi_d_ev_idle_init
#endif

static void _cffi_d_ev_idle_start(struct ev_loop * x0, struct ev_idle * x1)
{
  ev_idle_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_idle_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_idle * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_idle_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_idle *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_idle_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_idle_start _cffi_d_ev_idle_start
#endif

static void _cffi_d_ev_idle_stop(struct ev_loop * x0, struct ev_idle * x1)
{
  ev_idle_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_idle_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_idle * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_idle_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(62), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_idle *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(62), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_idle_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_idle_stop _cffi_d_ev_idle_stop
#endif

static void _cffi_d_ev_io_init(struct ev_io * x0, void * x1, int x2, int x3)
{
  ev_io_init(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_io_init(PyObject *self, PyObject *args)
{
  struct ev_io * x0;
  void * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ev_io_init", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_io *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_io_init(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_io_init _cffi_d_ev_io_init
#endif

static void _cffi_d_ev_io_start(struct ev_loop * x0, struct ev_io * x1)
{
  ev_io_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_io_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_io * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_io_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_io *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_io_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_io_start _cffi_d_ev_io_start
#endif

static void _cffi_d_ev_io_stop(struct ev_loop * x0, struct ev_io * x1)
{
  ev_io_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_io_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_io * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_io_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_io *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_io_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_io_stop _cffi_d_ev_io_stop
#endif

static int _cffi_d_ev_is_active(void * x0)
{
  return ev_is_active(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_is_active(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_is_active(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_is_active _cffi_d_ev_is_active
#endif

static int _cffi_d_ev_is_default_loop(struct ev_loop * x0)
{
  return ev_is_default_loop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_is_default_loop(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_is_default_loop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_is_default_loop _cffi_d_ev_is_default_loop
#endif

static int _cffi_d_ev_is_pending(void * x0)
{
  return ev_is_pending(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_is_pending(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_is_pending(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_is_pending _cffi_d_ev_is_pending
#endif

static unsigned int _cffi_d_ev_iteration(struct ev_loop * x0)
{
  return ev_iteration(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_iteration(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_iteration(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_iteration _cffi_d_ev_iteration
#endif

static void _cffi_d_ev_loop_destroy(struct ev_loop * x0)
{
  ev_loop_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_loop_destroy(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_loop_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_loop_destroy _cffi_d_ev_loop_destroy
#endif

static void _cffi_d_ev_loop_fork(struct ev_loop * x0)
{
  ev_loop_fork(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_loop_fork(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_loop_fork(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_loop_fork _cffi_d_ev_loop_fork
#endif

static struct ev_loop * _cffi_d_ev_loop_new(unsigned int x0)
{
  return ev_loop_new(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_loop_new(PyObject *self, PyObject *arg0)
{
  unsigned int x0;
  struct ev_loop * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_loop_new(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_ev_loop_new _cffi_d_ev_loop_new
#endif

static double _cffi_d_ev_now(struct ev_loop * x0)
{
  return ev_now(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_now(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_now(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_now _cffi_d_ev_now
#endif

static void _cffi_d_ev_now_update(struct ev_loop * x0)
{
  ev_now_update(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_now_update(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_now_update(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_now_update _cffi_d_ev_now_update
#endif

static unsigned int _cffi_d_ev_pending_count(struct ev_loop * x0)
{
  return ev_pending_count(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_pending_count(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_pending_count(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_pending_count _cffi_d_ev_pending_count
#endif

static void _cffi_d_ev_prepare_init(struct ev_prepare * x0, void * x1)
{
  ev_prepare_init(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_prepare_init(PyObject *self, PyObject *args)
{
  struct ev_prepare * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_prepare_init", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(109), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_prepare *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(109), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_prepare_init(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_prepare_init _cffi_d_ev_prepare_init
#endif

static void _cffi_d_ev_prepare_start(struct ev_loop * x0, struct ev_prepare * x1)
{
  ev_prepare_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_prepare_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_prepare * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_prepare_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(109), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_prepare *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(109), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_prepare_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_prepare_start _cffi_d_ev_prepare_start
#endif

static void _cffi_d_ev_prepare_stop(struct ev_loop * x0, struct ev_prepare * x1)
{
  ev_prepare_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_prepare_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_prepare * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_prepare_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(109), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_prepare *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(109), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_prepare_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_prepare_stop _cffi_d_ev_prepare_stop
#endif

static int _cffi_d_ev_priority(void * x0)
{
  return ev_priority(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_priority(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_priority(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_priority _cffi_d_ev_priority
#endif

static unsigned int _cffi_d_ev_recommended_backends(void)
{
  return ev_recommended_backends();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_recommended_backends(PyObject *self, PyObject *noarg)
{
  unsigned int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_recommended_backends(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ev_recommended_backends _cffi_d_ev_recommended_backends
#endif

static void _cffi_d_ev_ref(struct ev_loop * x0)
{
  ev_ref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_ref(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_ref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_ref _cffi_d_ev_ref
#endif

static void _cffi_d_ev_run(struct ev_loop * x0, int x1)
{
  ev_run(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_run(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_run", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_run(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_run _cffi_d_ev_run
#endif

static void _cffi_d_ev_set_priority(void * x0, int x1)
{
  ev_set_priority(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_set_priority(PyObject *self, PyObject *args)
{
  void * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_set_priority", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_set_priority(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_set_priority _cffi_d_ev_set_priority
#endif

static void _cffi_d_ev_set_syserr_cb(void * x0)
{
  ev_set_syserr_cb(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_set_syserr_cb(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_set_syserr_cb(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_set_syserr_cb _cffi_d_ev_set_syserr_cb
#endif

static void _cffi_d_ev_set_userdata(struct ev_loop * x0, void * x1)
{
  ev_set_userdata(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_set_userdata(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_set_userdata", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_set_userdata(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_set_userdata _cffi_d_ev_set_userdata
#endif

static void _cffi_d_ev_signal_init(struct ev_signal * x0, void * x1, int x2)
{
  ev_signal_init(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_signal_init(PyObject *self, PyObject *args)
{
  struct ev_signal * x0;
  void * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ev_signal_init", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_signal *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_signal_init(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_signal_init _cffi_d_ev_signal_init
#endif

static void _cffi_d_ev_signal_start(struct ev_loop * x0, struct ev_signal * x1)
{
  ev_signal_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_signal_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_signal * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_signal_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_signal *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_signal_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_signal_start _cffi_d_ev_signal_start
#endif

static void _cffi_d_ev_signal_stop(struct ev_loop * x0, struct ev_signal * x1)
{
  ev_signal_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_signal_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_signal * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_signal_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_signal *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_signal_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_signal_stop _cffi_d_ev_signal_stop
#endif

static void _cffi_d_ev_sleep(double x0)
{
  ev_sleep(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_sleep(PyObject *self, PyObject *arg0)
{
  double x0;

  x0 = (double)_cffi_to_c_double(arg0);
  if (x0 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_sleep(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_sleep _cffi_d_ev_sleep
#endif

static void _cffi_d_ev_stat_init(struct ev_stat * x0, void * x1, char * x2, double x3)
{
  ev_stat_init(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_stat_init(PyObject *self, PyObject *args)
{
  struct ev_stat * x0;
  void * x1;
  char * x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ev_stat_init", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_stat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(117), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(35), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_stat_init(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_stat_init _cffi_d_ev_stat_init
#endif

static void _cffi_d_ev_stat_start(struct ev_loop * x0, struct ev_stat * x1)
{
  ev_stat_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_stat_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_stat * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_stat_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_stat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(117), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_stat_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_stat_start _cffi_d_ev_stat_start
#endif

static void _cffi_d_ev_stat_stop(struct ev_loop * x0, struct ev_stat * x1)
{
  ev_stat_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_stat_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_stat * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_stat_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(117), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_stat *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(117), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_stat_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_stat_stop _cffi_d_ev_stat_stop
#endif

static unsigned int _cffi_d_ev_supported_backends(void)
{
  return ev_supported_backends();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_supported_backends(PyObject *self, PyObject *noarg)
{
  unsigned int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_supported_backends(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  return pyresult;
}
#else
#  define _cffi_f_ev_supported_backends _cffi_d_ev_supported_backends
#endif

static double _cffi_d_ev_time(void)
{
  return ev_time();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_time(PyObject *self, PyObject *noarg)
{
  double result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_time(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_double(result);
  return pyresult;
}
#else
#  define _cffi_f_ev_time _cffi_d_ev_time
#endif

static void _cffi_d_ev_timer_again(struct ev_loop * x0, struct ev_timer * x1)
{
  ev_timer_again(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_timer_again(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_timer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_timer_again", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_timer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_timer_again(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_timer_again _cffi_d_ev_timer_again
#endif

static void _cffi_d_ev_timer_init(struct ev_timer * x0, void * x1, double x2, double x3)
{
  ev_timer_init(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_timer_init(PyObject *self, PyObject *args)
{
  struct ev_timer * x0;
  void * x1;
  double x2;
  double x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ev_timer_init", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_timer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(15), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(15), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  x3 = (double)_cffi_to_c_double(arg3);
  if (x3 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_timer_init(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_timer_init _cffi_d_ev_timer_init
#endif

static void _cffi_d_ev_timer_start(struct ev_loop * x0, struct ev_timer * x1)
{
  ev_timer_start(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_timer_start(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_timer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_timer_start", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_timer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_timer_start(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_timer_start _cffi_d_ev_timer_start
#endif

static void _cffi_d_ev_timer_stop(struct ev_loop * x0, struct ev_timer * x1)
{
  ev_timer_stop(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_timer_stop(PyObject *self, PyObject *args)
{
  struct ev_loop * x0;
  struct ev_timer * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ev_timer_stop", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ev_timer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_timer_stop(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_timer_stop _cffi_d_ev_timer_stop
#endif

static void _cffi_d_ev_unref(struct ev_loop * x0)
{
  ev_unref(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_unref(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_unref(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_unref _cffi_d_ev_unref
#endif

static void * _cffi_d_ev_userdata(struct ev_loop * x0)
{
  return ev_userdata(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_userdata(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_userdata(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(15));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ev_userdata _cffi_d_ev_userdata
#endif

static void _cffi_d_ev_verify(struct ev_loop * x0)
{
  ev_verify(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_verify(PyObject *self, PyObject *arg0)
{
  struct ev_loop * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_loop *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ev_verify(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ev_verify _cffi_d_ev_verify
#endif

static int _cffi_d_ev_version_major(void)
{
  return ev_version_major();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_version_major(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_version_major(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ev_version_major _cffi_d_ev_version_major
#endif

static int _cffi_d_ev_version_minor(void)
{
  return ev_version_minor();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ev_version_minor(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ev_version_minor(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ev_version_minor _cffi_d_ev_version_minor
#endif

static int _cffi_d_gevent_check_fd_valid(int x0)
{
  return gevent_check_fd_valid(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_check_fd_valid(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = gevent_check_fd_valid(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_gevent_check_fd_valid _cffi_d_gevent_check_fd_valid
#endif

static struct ev_loop * _cffi_d_gevent_ev_default_loop(unsigned int x0)
{
  return gevent_ev_default_loop(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_ev_default_loop(PyObject *self, PyObject *arg0)
{
  unsigned int x0;
  struct ev_loop * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = gevent_ev_default_loop(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_gevent_ev_default_loop _cffi_d_gevent_ev_default_loop
#endif

static void _cffi_d_gevent_install_sigchld_handler(void)
{
  gevent_install_sigchld_handler();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_install_sigchld_handler(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_install_sigchld_handler(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_install_sigchld_handler _cffi_d_gevent_install_sigchld_handler
#endif

static void _cffi_d_gevent_reset_sigchld_handler(void)
{
  gevent_reset_sigchld_handler();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_reset_sigchld_handler(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_reset_sigchld_handler(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_reset_sigchld_handler _cffi_d_gevent_reset_sigchld_handler
#endif

static void _cffi_d_gevent_set_ev_alloc(void)
{
  gevent_set_ev_alloc();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_set_ev_alloc(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_set_ev_alloc(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_set_ev_alloc _cffi_d_gevent_set_ev_alloc
#endif

static void _cffi_d_gevent_zero_check(struct ev_check * x0)
{
  gevent_zero_check(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_check(PyObject *self, PyObject *arg0)
{
  struct ev_check * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_check *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_check(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_check _cffi_d_gevent_zero_check
#endif

static void _cffi_d_gevent_zero_prepare(struct ev_prepare * x0)
{
  gevent_zero_prepare(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_prepare(PyObject *self, PyObject *arg0)
{
  struct ev_prepare * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(109), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_prepare *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(109), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_prepare(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_prepare _cffi_d_gevent_zero_prepare
#endif

static void _cffi_d_gevent_zero_timer(struct ev_timer * x0)
{
  gevent_zero_timer(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_gevent_zero_timer(PyObject *self, PyObject *arg0)
{
  struct ev_timer * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ev_timer *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { gevent_zero_timer(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_gevent_zero_timer _cffi_d_gevent_zero_timer
#endif

static int _cffi_const_EVBACKEND_ALL(unsigned long long *o)
{
  int n = (EVBACKEND_ALL) <= 0;
  *o = (unsigned long long)((EVBACKEND_ALL) | 0);  /* check that EVBACKEND_ALL is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_DEVPOLL(unsigned long long *o)
{
  int n = (EVBACKEND_DEVPOLL) <= 0;
  *o = (unsigned long long)((EVBACKEND_DEVPOLL) | 0);  /* check that EVBACKEND_DEVPOLL is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_EPOLL(unsigned long long *o)
{
  int n = (EVBACKEND_EPOLL) <= 0;
  *o = (unsigned long long)((EVBACKEND_EPOLL) | 0);  /* check that EVBACKEND_EPOLL is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_IOURING(unsigned long long *o)
{
  int n = (EVBACKEND_IOURING) <= 0;
  *o = (unsigned long long)((EVBACKEND_IOURING) | 0);  /* check that EVBACKEND_IOURING is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_KQUEUE(unsigned long long *o)
{
  int n = (EVBACKEND_KQUEUE) <= 0;
  *o = (unsigned long long)((EVBACKEND_KQUEUE) | 0);  /* check that EVBACKEND_KQUEUE is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_LINUXAIO(unsigned long long *o)
{
  int n = (EVBACKEND_LINUXAIO) <= 0;
  *o = (unsigned long long)((EVBACKEND_LINUXAIO) | 0);  /* check that EVBACKEND_LINUXAIO is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_MASK(unsigned long long *o)
{
  int n = (EVBACKEND_MASK) <= 0;
  *o = (unsigned long long)((EVBACKEND_MASK) | 0);  /* check that EVBACKEND_MASK is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_POLL(unsigned long long *o)
{
  int n = (EVBACKEND_POLL) <= 0;
  *o = (unsigned long long)((EVBACKEND_POLL) | 0);  /* check that EVBACKEND_POLL is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_PORT(unsigned long long *o)
{
  int n = (EVBACKEND_PORT) <= 0;
  *o = (unsigned long long)((EVBACKEND_PORT) | 0);  /* check that EVBACKEND_PORT is an integer */
  return n;
}

static int _cffi_const_EVBACKEND_SELECT(unsigned long long *o)
{
  int n = (EVBACKEND_SELECT) <= 0;
  *o = (unsigned long long)((EVBACKEND_SELECT) | 0);  /* check that EVBACKEND_SELECT is an integer */
  return n;
}

static int _cffi_const_EVBREAK_ALL(unsigned long long *o)
{
  int n = (EVBREAK_ALL) <= 0;
  *o = (unsigned long long)((EVBREAK_ALL) | 0);  /* check that EVBREAK_ALL is an integer */
  return n;
}

static int _cffi_const_EVBREAK_CANCEL(unsigned long long *o)
{
  int n = (EVBREAK_CANCEL) <= 0;
  *o = (unsigned long long)((EVBREAK_CANCEL) | 0);  /* check that EVBREAK_CANCEL is an integer */
  return n;
}

static int _cffi_const_EVBREAK_ONE(unsigned long long *o)
{
  int n = (EVBREAK_ONE) <= 0;
  *o = (unsigned long long)((EVBREAK_ONE) | 0);  /* check that EVBREAK_ONE is an integer */
  return n;
}

static int _cffi_const_EVFLAG_AUTO(unsigned long long *o)
{
  int n = (EVFLAG_AUTO) <= 0;
  *o = (unsigned long long)((EVFLAG_AUTO) | 0);  /* check that EVFLAG_AUTO is an integer */
  return n;
}

static int _cffi_const_EVFLAG_FORKCHECK(unsigned long long *o)
{
  int n = (EVFLAG_FORKCHECK) <= 0;
  *o = (unsigned long long)((EVFLAG_FORKCHECK) | 0);  /* check that EVFLAG_FORKCHECK is an integer */
  return n;
}

static int _cffi_const_EVFLAG_NOENV(unsigned long long *o)
{
  int n = (EVFLAG_NOENV) <= 0;
  *o = (unsigned long long)((EVFLAG_NOENV) | 0);  /* check that EVFLAG_NOENV is an integer */
  return n;
}

static int _cffi_const_EVFLAG_NOINOTIFY(unsigned long long *o)
{
  int n = (EVFLAG_NOINOTIFY) <= 0;
  *o = (unsigned long long)((EVFLAG_NOINOTIFY) | 0);  /* check that EVFLAG_NOINOTIFY is an integer */
  return n;
}

static int _cffi_const_EVFLAG_NOSIGMASK(unsigned long long *o)
{
  int n = (EVFLAG_NOSIGMASK) <= 0;
  *o = (unsigned long long)((EVFLAG_NOSIGMASK) | 0);  /* check that EVFLAG_NOSIGMASK is an integer */
  return n;
}

static int _cffi_const_EVFLAG_SIGNALFD(unsigned long long *o)
{
  int n = (EVFLAG_SIGNALFD) <= 0;
  *o = (unsigned long long)((EVFLAG_SIGNALFD) | 0);  /* check that EVFLAG_SIGNALFD is an integer */
  return n;
}

static int _cffi_const_EVRUN_NOWAIT(unsigned long long *o)
{
  int n = (EVRUN_NOWAIT) <= 0;
  *o = (unsigned long long)((EVRUN_NOWAIT) | 0);  /* check that EVRUN_NOWAIT is an integer */
  return n;
}

static int _cffi_const_EVRUN_ONCE(unsigned long long *o)
{
  int n = (EVRUN_ONCE) <= 0;
  *o = (unsigned long long)((EVRUN_ONCE) | 0);  /* check that EVRUN_ONCE is an integer */
  return n;
}

static int _cffi_const_EV_ASYNC(unsigned long long *o)
{
  int n = (EV_ASYNC) <= 0;
  *o = (unsigned long long)((EV_ASYNC) | 0);  /* check that EV_ASYNC is an integer */
  return n;
}

static int _cffi_const_EV_CHECK(unsigned long long *o)
{
  int n = (EV_CHECK) <= 0;
  *o = (unsigned long long)((EV_CHECK) | 0);  /* check that EV_CHECK is an integer */
  return n;
}

static int _cffi_const_EV_CHILD(unsigned long long *o)
{
  int n = (EV_CHILD) <= 0;
  *o = (unsigned long long)((EV_CHILD) | 0);  /* check that EV_CHILD is an integer */
  return n;
}

static int _cffi_const_EV_CLEANUP(unsigned long long *o)
{
  int n = (EV_CLEANUP) <= 0;
  *o = (unsigned long long)((EV_CLEANUP) | 0);  /* check that EV_CLEANUP is an integer */
  return n;
}

static int _cffi_const_EV_CUSTOM(unsigned long long *o)
{
  int n = (EV_CUSTOM) <= 0;
  *o = (unsigned long long)((EV_CUSTOM) | 0);  /* check that EV_CUSTOM is an integer */
  return n;
}

static int _cffi_const_EV_EMBED(unsigned long long *o)
{
  int n = (EV_EMBED) <= 0;
  *o = (unsigned long long)((EV_EMBED) | 0);  /* check that EV_EMBED is an integer */
  return n;
}

static int _cffi_const_EV_ERROR(unsigned long long *o)
{
  int n = (EV_ERROR) <= 0;
  *o = (unsigned long long)((EV_ERROR) | 0);  /* check that EV_ERROR is an integer */
  return n;
}

static int _cffi_const_EV_FORK(unsigned long long *o)
{
  int n = (EV_FORK) <= 0;
  *o = (unsigned long long)((EV_FORK) | 0);  /* check that EV_FORK is an integer */
  return n;
}

static int _cffi_const_EV_IDLE(unsigned long long *o)
{
  int n = (EV_IDLE) <= 0;
  *o = (unsigned long long)((EV_IDLE) | 0);  /* check that EV_IDLE is an integer */
  return n;
}

static int _cffi_const_EV_MAXPRI(unsigned long long *o)
{
  int n = (EV_MAXPRI) <= 0;
  *o = (unsigned long long)((EV_MAXPRI) | 0);  /* check that EV_MAXPRI is an integer */
  return n;
}

static int _cffi_const_EV_MINPRI(unsigned long long *o)
{
  int n = (EV_MINPRI) <= 0;
  *o = (unsigned long long)((EV_MINPRI) | 0);  /* check that EV_MINPRI is an integer */
  return n;
}

static int _cffi_const_EV_NONE(unsigned long long *o)
{
  int n = (EV_NONE) <= 0;
  *o = (unsigned long long)((EV_NONE) | 0);  /* check that EV_NONE is an integer */
  return n;
}

static int _cffi_const_EV_PERIODIC(unsigned long long *o)
{
  int n = (EV_PERIODIC) <= 0;
  *o = (unsigned long long)((EV_PERIODIC) | 0);  /* check that EV_PERIODIC is an integer */
  return n;
}

static int _cffi_const_EV_PREPARE(unsigned long long *o)
{
  int n = (EV_PREPARE) <= 0;
  *o = (unsigned long long)((EV_PREPARE) | 0);  /* check that EV_PREPARE is an integer */
  return n;
}

static int _cffi_const_EV_READ(unsigned long long *o)
{
  int n = (EV_READ) <= 0;
  *o = (unsigned long long)((EV_READ) | 0);  /* check that EV_READ is an integer */
  return n;
}

static int _cffi_const_EV_SIGNAL(unsigned long long *o)
{
  int n = (EV_SIGNAL) <= 0;
  *o = (unsigned long long)((EV_SIGNAL) | 0);  /* check that EV_SIGNAL is an integer */
  return n;
}

static int _cffi_const_EV_STAT(unsigned long long *o)
{
  int n = (EV_STAT) <= 0;
  *o = (unsigned long long)((EV_STAT) | 0);  /* check that EV_STAT is an integer */
  return n;
}

static int _cffi_const_EV_TIMER(unsigned long long *o)
{
  int n = (EV_TIMER) <= 0;
  *o = (unsigned long long)((EV_TIMER) | 0);  /* check that EV_TIMER is an integer */
  return n;
}

static int _cffi_const_EV_UNDEF(unsigned long long *o)
{
  int n = (EV_UNDEF) <= 0;
  *o = (unsigned long long)((EV_UNDEF) | 0);  /* check that EV_UNDEF is an integer */
  return n;
}

static int _cffi_const_EV_VERSION_MAJOR(unsigned long long *o)
{
  int n = (EV_VERSION_MAJOR) <= 0;
  *o = (unsigned long long)((EV_VERSION_MAJOR) | 0);  /* check that EV_VERSION_MAJOR is an integer */
  return n;
}

static int _cffi_const_EV_VERSION_MINOR(unsigned long long *o)
{
  int n = (EV_VERSION_MINOR) <= 0;
  *o = (unsigned long long)((EV_VERSION_MINOR) | 0);  /* check that EV_VERSION_MINOR is an integer */
  return n;
}

static int _cffi_const_EV_WRITE(unsigned long long *o)
{
  int n = (EV_WRITE) <= 0;
  *o = (unsigned long long)((EV_WRITE) | 0);  /* check that EV_WRITE is an integer */
  return n;
}

static int _cffi_const_EV__IOFDSET(unsigned long long *o)
{
  int n = (EV__IOFDSET) <= 0;
  *o = (unsigned long long)((EV__IOFDSET) | 0);  /* check that EV__IOFDSET is an integer */
  return n;
}

static int _cffi_const_LIBEV_EMBED(unsigned long long *o)
{
  int n = (LIBEV_EMBED) <= 0;
  *o = (unsigned long long)((LIBEV_EMBED) | 0);  /* check that LIBEV_EMBED is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_async(struct ev_async *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_async { char x; struct ev_async y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_check(struct ev_check *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_check { char x; struct ev_check y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_child(struct ev_child *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->pid) | 0);  /* check that 'struct ev_child.pid' is an integer */
  (void)((p->rpid) | 0);  /* check that 'struct ev_child.rpid' is an integer */
  (void)((p->rstatus) | 0);  /* check that 'struct ev_child.rstatus' is an integer */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_child { char x; struct ev_child y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_fork(struct ev_fork *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_fork { char x; struct ev_fork y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_idle(struct ev_idle *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_idle { char x; struct ev_idle y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_io(struct ev_io *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->fd) | 0);  /* check that 'struct ev_io.fd' is an integer */
  (void)((p->events) | 0);  /* check that 'struct ev_io.events' is an integer */
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_io { char x; struct ev_io y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_prepare(struct ev_prepare *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_prepare { char x; struct ev_prepare y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_signal(struct ev_signal *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_signal { char x; struct ev_signal y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_stat(struct ev_stat *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct stat *tmp = &p->attr; (void)tmp; }
  { char const * *tmp = &p->path; (void)tmp; }
  { struct stat *tmp = &p->prev; (void)tmp; }
  { double *tmp = &p->interval; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_stat { char x; struct ev_stat y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_timer(struct ev_timer *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->at; (void)tmp; }
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_timer { char x; struct ev_timer y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ev_watcher(struct ev_watcher *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { void * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_ev_watcher { char x; struct ev_watcher y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_stat(struct stat *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->st_nlink) | 0);  /* check that 'struct stat.st_nlink' is an integer */
}
struct _cffi_align_struct_stat { char x; struct stat y; };

static void(* *_cffi_var_gevent_noop(void))(struct ev_loop *, struct ev_timer *, int)
{
  return &(gevent_noop);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "EVBACKEND_ALL", (void *)_cffi_const_EVBACKEND_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_DEVPOLL", (void *)_cffi_const_EVBACKEND_DEVPOLL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_EPOLL", (void *)_cffi_const_EVBACKEND_EPOLL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_IOURING", (void *)_cffi_const_EVBACKEND_IOURING, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_KQUEUE", (void *)_cffi_const_EVBACKEND_KQUEUE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_LINUXAIO", (void *)_cffi_const_EVBACKEND_LINUXAIO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_MASK", (void *)_cffi_const_EVBACKEND_MASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_POLL", (void *)_cffi_const_EVBACKEND_POLL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_PORT", (void *)_cffi_const_EVBACKEND_PORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBACKEND_SELECT", (void *)_cffi_const_EVBACKEND_SELECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBREAK_ALL", (void *)_cffi_const_EVBREAK_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBREAK_CANCEL", (void *)_cffi_const_EVBREAK_CANCEL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVBREAK_ONE", (void *)_cffi_const_EVBREAK_ONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVFLAG_AUTO", (void *)_cffi_const_EVFLAG_AUTO, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVFLAG_FORKCHECK", (void *)_cffi_const_EVFLAG_FORKCHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVFLAG_NOENV", (void *)_cffi_const_EVFLAG_NOENV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVFLAG_NOINOTIFY", (void *)_cffi_const_EVFLAG_NOINOTIFY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVFLAG_NOSIGMASK", (void *)_cffi_const_EVFLAG_NOSIGMASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVFLAG_SIGNALFD", (void *)_cffi_const_EVFLAG_SIGNALFD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVRUN_NOWAIT", (void *)_cffi_const_EVRUN_NOWAIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EVRUN_ONCE", (void *)_cffi_const_EVRUN_ONCE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_ASYNC", (void *)_cffi_const_EV_ASYNC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_CHECK", (void *)_cffi_const_EV_CHECK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_CHILD", (void *)_cffi_const_EV_CHILD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_CLEANUP", (void *)_cffi_const_EV_CLEANUP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_CUSTOM", (void *)_cffi_const_EV_CUSTOM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_EMBED", (void *)_cffi_const_EV_EMBED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_ERROR", (void *)_cffi_const_EV_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_FORK", (void *)_cffi_const_EV_FORK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_IDLE", (void *)_cffi_const_EV_IDLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_MAXPRI", (void *)_cffi_const_EV_MAXPRI, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_MINPRI", (void *)_cffi_const_EV_MINPRI, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_NONE", (void *)_cffi_const_EV_NONE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_PERIODIC", (void *)_cffi_const_EV_PERIODIC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_PREPARE", (void *)_cffi_const_EV_PREPARE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_READ", (void *)_cffi_const_EV_READ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_SIGNAL", (void *)_cffi_const_EV_SIGNAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_STAT", (void *)_cffi_const_EV_STAT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_TIMER", (void *)_cffi_const_EV_TIMER, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_UNDEF", (void *)_cffi_const_EV_UNDEF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_VERSION_MAJOR", (void *)_cffi_const_EV_VERSION_MAJOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_VERSION_MINOR", (void *)_cffi_const_EV_VERSION_MINOR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV_WRITE", (void *)_cffi_const_EV_WRITE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EV__IOFDSET", (void *)_cffi_const_EV__IOFDSET, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LIBEV_EMBED", (void *)_cffi_const_LIBEV_EMBED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_gevent_generic_callback", (void *)_cffi_f__gevent_generic_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d__gevent_generic_callback },
  { "_syserr_cb", (void *)&_cffi_externpy___syserr_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 195), (void *)_syserr_cb },
  { "ev_async_init", (void *)_cffi_f_ev_async_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 40), (void *)_cffi_d_ev_async_init },
  { "ev_async_pending", (void *)_cffi_f_ev_async_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 8), (void *)_cffi_d_ev_async_pending },
  { "ev_async_send", (void *)_cffi_f_ev_async_send, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_ev_async_send },
  { "ev_async_start", (void *)_cffi_f_ev_async_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_ev_async_start },
  { "ev_async_stop", (void *)_cffi_f_ev_async_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 83), (void *)_cffi_d_ev_async_stop },
  { "ev_backend", (void *)_cffi_f_ev_backend, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_ev_backend },
  { "ev_break", (void *)_cffi_f_ev_break, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 74), (void *)_cffi_d_ev_break },
  { "ev_check_init", (void *)_cffi_f_ev_check_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 47), (void *)_cffi_d_ev_check_init },
  { "ev_check_start", (void *)_cffi_f_ev_check_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 87), (void *)_cffi_d_ev_check_start },
  { "ev_check_stop", (void *)_cffi_f_ev_check_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 87), (void *)_cffi_d_ev_check_stop },
  { "ev_child_init", (void *)_cffi_f_ev_child_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 51), (void *)_cffi_d_ev_child_init },
  { "ev_child_start", (void *)_cffi_f_ev_child_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_ev_child_start },
  { "ev_child_stop", (void *)_cffi_f_ev_child_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 91), (void *)_cffi_d_ev_child_stop },
  { "ev_default_loop", (void *)_cffi_f_ev_default_loop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 23), (void *)_cffi_d_ev_default_loop },
  { "ev_depth", (void *)_cffi_f_ev_depth, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_ev_depth },
  { "ev_embeddable_backends", (void *)_cffi_f_ev_embeddable_backends, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 29), (void *)_cffi_d_ev_embeddable_backends },
  { "ev_feed_event", (void *)_cffi_f_ev_feed_event, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 137), (void *)_cffi_d_ev_feed_event },
  { "ev_feed_fd_event", (void *)_cffi_f_ev_feed_fd_event, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 78), (void *)_cffi_d_ev_feed_fd_event },
  { "ev_fork_init", (void *)_cffi_f_ev_fork_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_ev_fork_init },
  { "ev_fork_start", (void *)_cffi_f_ev_fork_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_ev_fork_start },
  { "ev_fork_stop", (void *)_cffi_f_ev_fork_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 95), (void *)_cffi_d_ev_fork_stop },
  { "ev_idle_init", (void *)_cffi_f_ev_idle_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_ev_idle_init },
  { "ev_idle_start", (void *)_cffi_f_ev_idle_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 99), (void *)_cffi_d_ev_idle_start },
  { "ev_idle_stop", (void *)_cffi_f_ev_idle_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 99), (void *)_cffi_d_ev_idle_stop },
  { "ev_io_init", (void *)_cffi_f_ev_io_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 65), (void *)_cffi_d_ev_io_init },
  { "ev_io_start", (void *)_cffi_f_ev_io_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_ev_io_start },
  { "ev_io_stop", (void *)_cffi_f_ev_io_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_ev_io_stop },
  { "ev_is_active", (void *)_cffi_f_ev_is_active, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 14), (void *)_cffi_d_ev_is_active },
  { "ev_is_default_loop", (void *)_cffi_f_ev_is_default_loop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 11), (void *)_cffi_d_ev_is_default_loop },
  { "ev_is_pending", (void *)_cffi_f_ev_is_pending, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 14), (void *)_cffi_d_ev_is_pending },
  { "ev_iteration", (void *)_cffi_f_ev_iteration, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_ev_iteration },
  { "ev_loop_destroy", (void *)_cffi_f_ev_loop_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 71), (void *)_cffi_d_ev_loop_destroy },
  { "ev_loop_fork", (void *)_cffi_f_ev_loop_fork, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 71), (void *)_cffi_d_ev_loop_fork },
  { "ev_loop_new", (void *)_cffi_f_ev_loop_new, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 23), (void *)_cffi_d_ev_loop_new },
  { "ev_now", (void *)_cffi_f_ev_now, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_ev_now },
  { "ev_now_update", (void *)_cffi_f_ev_now_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 71), (void *)_cffi_d_ev_now_update },
  { "ev_pending_count", (void *)_cffi_f_ev_pending_count, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_ev_pending_count },
  { "ev_prepare_init", (void *)_cffi_f_ev_prepare_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 145), (void *)_cffi_d_ev_prepare_init },
  { "ev_prepare_start", (void *)_cffi_f_ev_prepare_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 107), (void *)_cffi_d_ev_prepare_start },
  { "ev_prepare_stop", (void *)_cffi_f_ev_prepare_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 107), (void *)_cffi_d_ev_prepare_stop },
  { "ev_priority", (void *)_cffi_f_ev_priority, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 14), (void *)_cffi_d_ev_priority },
  { "ev_recommended_backends", (void *)_cffi_f_ev_recommended_backends, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 29), (void *)_cffi_d_ev_recommended_backends },
  { "ev_ref", (void *)_cffi_f_ev_ref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 71), (void *)_cffi_d_ev_ref },
  { "ev_run", (void *)_cffi_f_ev_run, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 74), (void *)_cffi_d_ev_run },
  { "ev_set_priority", (void *)_cffi_f_ev_set_priority, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 172), (void *)_cffi_d_ev_set_priority },
  { "ev_set_syserr_cb", (void *)_cffi_f_ev_set_syserr_cb, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 169), (void *)_cffi_d_ev_set_syserr_cb },
  { "ev_set_userdata", (void *)_cffi_f_ev_set_userdata, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 133), (void *)_cffi_d_ev_set_userdata },
  { "ev_signal_init", (void *)_cffi_f_ev_signal_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 149), (void *)_cffi_d_ev_signal_init },
  { "ev_signal_start", (void *)_cffi_f_ev_signal_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 111), (void *)_cffi_d_ev_signal_start },
  { "ev_signal_stop", (void *)_cffi_f_ev_signal_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 111), (void *)_cffi_d_ev_signal_stop },
  { "ev_sleep", (void *)_cffi_f_ev_sleep, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 37), (void *)_cffi_d_ev_sleep },
  { "ev_stat_init", (void *)_cffi_f_ev_stat_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 154), (void *)_cffi_d_ev_stat_init },
  { "ev_stat_start", (void *)_cffi_f_ev_stat_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 115), (void *)_cffi_d_ev_stat_start },
  { "ev_stat_stop", (void *)_cffi_f_ev_stat_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 115), (void *)_cffi_d_ev_stat_stop },
  { "ev_supported_backends", (void *)_cffi_f_ev_supported_backends, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 29), (void *)_cffi_d_ev_supported_backends },
  { "ev_time", (void *)_cffi_f_ev_time, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 3), (void *)_cffi_d_ev_time },
  { "ev_timer_again", (void *)_cffi_f_ev_timer_again, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 119), (void *)_cffi_d_ev_timer_again },
  { "ev_timer_init", (void *)_cffi_f_ev_timer_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 163), (void *)_cffi_d_ev_timer_init },
  { "ev_timer_start", (void *)_cffi_f_ev_timer_start, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 119), (void *)_cffi_d_ev_timer_start },
  { "ev_timer_stop", (void *)_cffi_f_ev_timer_stop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 119), (void *)_cffi_d_ev_timer_stop },
  { "ev_unref", (void *)_cffi_f_ev_unref, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 71), (void *)_cffi_d_ev_unref },
  { "ev_userdata", (void *)_cffi_f_ev_userdata, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 31), (void *)_cffi_d_ev_userdata },
  { "ev_verify", (void *)_cffi_f_ev_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 71), (void *)_cffi_d_ev_verify },
  { "ev_version_major", (void *)_cffi_f_ev_version_major, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 21), (void *)_cffi_d_ev_version_major },
  { "ev_version_minor", (void *)_cffi_f_ev_version_minor, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 21), (void *)_cffi_d_ev_version_minor },
  { "gevent_check_fd_valid", (void *)_cffi_f_gevent_check_fd_valid, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 5), (void *)_cffi_d_gevent_check_fd_valid },
  { "gevent_ev_default_loop", (void *)_cffi_f_gevent_ev_default_loop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 23), (void *)_cffi_d_gevent_ev_default_loop },
  { "gevent_install_sigchld_handler", (void *)_cffi_f_gevent_install_sigchld_handler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 176), (void *)_cffi_d_gevent_install_sigchld_handler },
  { "gevent_noop", (void *)_cffi_var_gevent_noop, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 196), (void *)0 },
  { "gevent_reset_sigchld_handler", (void *)_cffi_f_gevent_reset_sigchld_handler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 176), (void *)_cffi_d_gevent_reset_sigchld_handler },
  { "gevent_set_ev_alloc", (void *)_cffi_f_gevent_set_ev_alloc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 176), (void *)_cffi_d_gevent_set_ev_alloc },
  { "gevent_zero_check", (void *)_cffi_f_gevent_zero_check, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 44), (void *)_cffi_d_gevent_zero_check },
  { "gevent_zero_prepare", (void *)_cffi_f_gevent_zero_prepare, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 142), (void *)_cffi_d_gevent_zero_prepare },
  { "gevent_zero_timer", (void *)_cffi_f_gevent_zero_timer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 160), (void *)_cffi_d_gevent_zero_timer },
  { "python_callback", (void *)&_cffi_externpy__python_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 180), (void *)python_callback },
  { "python_check_callback", (void *)&_cffi_externpy__python_check_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 197), (void *)python_check_callback },
  { "python_handle_error", (void *)&_cffi_externpy__python_handle_error, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 199), (void *)python_handle_error },
  { "python_prepare_callback", (void *)&_cffi_externpy__python_prepare_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 197), (void *)python_prepare_callback },
  { "python_stop", (void *)&_cffi_externpy__python_stop, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 198), (void *)python_stop },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "data", offsetof(struct ev_async, data),
            sizeof(((struct ev_async *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "data", offsetof(struct ev_check, data),
            sizeof(((struct ev_check *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "pid", offsetof(struct ev_child, pid),
           sizeof(((struct ev_child *)0)->pid),
           _CFFI_OP(_CFFI_OP_NOOP, 6) },
  { "rpid", offsetof(struct ev_child, rpid),
            sizeof(((struct ev_child *)0)->rpid),
            _CFFI_OP(_CFFI_OP_NOOP, 6) },
  { "rstatus", offsetof(struct ev_child, rstatus),
               sizeof(((struct ev_child *)0)->rstatus),
               _CFFI_OP(_CFFI_OP_NOOP, 6) },
  { "data", offsetof(struct ev_child, data),
            sizeof(((struct ev_child *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "data", offsetof(struct ev_fork, data),
            sizeof(((struct ev_fork *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "data", offsetof(struct ev_idle, data),
            sizeof(((struct ev_idle *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "fd", offsetof(struct ev_io, fd),
          sizeof(((struct ev_io *)0)->fd),
          _CFFI_OP(_CFFI_OP_NOOP, 6) },
  { "events", offsetof(struct ev_io, events),
              sizeof(((struct ev_io *)0)->events),
              _CFFI_OP(_CFFI_OP_NOOP, 6) },
  { "data", offsetof(struct ev_io, data),
            sizeof(((struct ev_io *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "data", offsetof(struct ev_prepare, data),
            sizeof(((struct ev_prepare *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "data", offsetof(struct ev_signal, data),
            sizeof(((struct ev_signal *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "attr", offsetof(struct ev_stat, attr),
            sizeof(((struct ev_stat *)0)->attr),
            _CFFI_OP(_CFFI_OP_NOOP, 194) },
  { "path", offsetof(struct ev_stat, path),
            sizeof(((struct ev_stat *)0)->path),
            _CFFI_OP(_CFFI_OP_NOOP, 178) },
  { "prev", offsetof(struct ev_stat, prev),
            sizeof(((struct ev_stat *)0)->prev),
            _CFFI_OP(_CFFI_OP_NOOP, 194) },
  { "interval", offsetof(struct ev_stat, interval),
                sizeof(((struct ev_stat *)0)->interval),
                _CFFI_OP(_CFFI_OP_NOOP, 38) },
  { "data", offsetof(struct ev_stat, data),
            sizeof(((struct ev_stat *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "at", offsetof(struct ev_timer, at),
          sizeof(((struct ev_timer *)0)->at),
          _CFFI_OP(_CFFI_OP_NOOP, 38) },
  { "data", offsetof(struct ev_timer, data),
            sizeof(((struct ev_timer *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "data", offsetof(struct ev_watcher, data),
            sizeof(((struct ev_watcher *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "st_nlink", offsetof(struct stat, st_nlink),
                sizeof(((struct stat *)0)->st_nlink),
                _CFFI_OP(_CFFI_OP_NOOP, 181) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "ev_async", 182, 0,
    sizeof(struct ev_async), offsetof(struct _cffi_align_struct_ev_async, y), 0, 1 },
  { "ev_check", 183, 0,
    sizeof(struct ev_check), offsetof(struct _cffi_align_struct_ev_check, y), 1, 1 },
  { "ev_child", 184, 0,
    sizeof(struct ev_child), offsetof(struct _cffi_align_struct_ev_child, y), 2, 4 },
  { "ev_fork", 185, 0,
    sizeof(struct ev_fork), offsetof(struct _cffi_align_struct_ev_fork, y), 6, 1 },
  { "ev_idle", 186, 0,
    sizeof(struct ev_idle), offsetof(struct _cffi_align_struct_ev_idle, y), 7, 1 },
  { "ev_io", 187, 0,
    sizeof(struct ev_io), offsetof(struct _cffi_align_struct_ev_io, y), 8, 3 },
  { "ev_loop", 188, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ev_prepare", 189, 0,
    sizeof(struct ev_prepare), offsetof(struct _cffi_align_struct_ev_prepare, y), 11, 1 },
  { "ev_signal", 190, 0,
    sizeof(struct ev_signal), offsetof(struct _cffi_align_struct_ev_signal, y), 12, 1 },
  { "ev_stat", 191, 0,
    sizeof(struct ev_stat), offsetof(struct _cffi_align_struct_ev_stat, y), 13, 5 },
  { "ev_timer", 192, 0,
    sizeof(struct ev_timer), offsetof(struct _cffi_align_struct_ev_timer, y), 18, 2 },
  { "ev_watcher", 193, 0,
    sizeof(struct ev_watcher), offsetof(struct _cffi_align_struct_ev_watcher, y), 20, 1 },
  { "stat", 194, 0,
    sizeof(struct stat), offsetof(struct _cffi_align_struct_stat, y), 21, 1 },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ev_tstamp", 38 },
  { "nlink_t", 181 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  126,  /* num_globals */
  13,  /* num_struct_unions */
  0,  /* num_enums */
  2,  /* num_typenames */
  NULL,  /* no includes */
  201,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__corecffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__corecffi(void) { return NULL; }
#  else
     init_corecffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__corecffi(void)
{
  return _cffi_init("gevent.libev._corecffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_corecffi(void)
{
  _cffi_init("gevent.libev._corecffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
