// components/services/storage/public/mojom/partition.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_PARTITION_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_PARTITION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/partition.mojom-shared.h"
#include "components/services/storage/public/mojom/partition.mojom-forward.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom.h"
#include "components/services/storage/public/mojom/origin_context.mojom.h"
#include "components/services/storage/public/mojom/session_storage_control.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class PartitionProxy;

template <typename ImplRefTraits>
class PartitionStub;

class PartitionRequestValidator;


class  Partition
    : public PartitionInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PartitionInterfaceBase;
  using Proxy_ = PartitionProxy;

  template <typename ImplRefTraits>
  using Stub_ = PartitionStub<ImplRefTraits>;

  using RequestValidator_ = PartitionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindOriginContextMinVersion = 0,
    kBindSessionStorageControlMinVersion = 0,
    kBindLocalStorageControlMinVersion = 0,
  };
  virtual ~Partition() {}

  
  virtual void BindOriginContext(const ::url::Origin& origin, ::mojo::PendingReceiver<::storage::mojom::OriginContext> receiver) = 0;

  
  virtual void BindSessionStorageControl(::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) = 0;

  
  virtual void BindLocalStorageControl(::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) = 0;
};



class  PartitionProxy
    : public Partition {
 public:
  using InterfaceType = Partition;

  explicit PartitionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindOriginContext(const ::url::Origin& origin, ::mojo::PendingReceiver<::storage::mojom::OriginContext> receiver) final;
  
  void BindSessionStorageControl(::mojo::PendingReceiver<::storage::mojom::SessionStorageControl> receiver) final;
  
  void BindLocalStorageControl(::mojo::PendingReceiver<::storage::mojom::LocalStorageControl> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PartitionStubDispatch {
 public:
  static bool Accept(Partition* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Partition* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Partition>>
class PartitionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PartitionStub() {}
  ~PartitionStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PartitionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PartitionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PartitionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_PARTITION_MOJOM_H_